/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskCheckRPMVersion {
    private final String m_RPM_VERSION_CMD = "/bin/rpm -q --queryformat '%{VERSION}' rpm";
    private final String m_RPM_REQ_VER = "4.4.2";
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");

    public void performVerification(String[] nodeList, HashMap<String, String> nodeVersionPair, ResultSet rpmVerResults) {
        GlobalExecution globalExec = new GlobalExecution();
        String errMsg = null;
        ResultSet RPMVerRsltSet = new ResultSet();
        globalExec.runGenericCmd(nodeList, "/bin/rpm -q --queryformat '%{VERSION}' rpm", RPMVerRsltSet);
        Hashtable rsltTab = RPMVerRsltSet.getResultTable();
        Enumeration e = rsltTab.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)rsltTab.get(node);
            if (result.getStatus() == 1) {
                String output = new String();
                output = VerificationUtil.fetchVerificationValue((String)result.getResultInfoSet().firstElement());
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("sTaskCheckRPMVersion::performVerification Retrieved version of RPM as :" + output + " from node " + node));
                }
                boolean validVersion = false;
                if (output != null && output.trim().length() > 0) {
                    output = output.trim();
                    result.setHasResultValues(true);
                    result.setActualValue(output);
                    result.setExpectedValue("4.4.2");
                    nodeVersionPair.put(node, output);
                    String delim = "\\.";
                    String[] curVerArray = output.split(delim);
                    String[] reqVerArray = "4.4.2".split(delim);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("sTaskCheckRPMVersion::performVerification output " + output + " length is cur : " + curVerArray.length + " req: " + reqVerArray.length));
                    }
                    for (int i = 0; i < curVerArray.length && i < reqVerArray.length; ++i) {
                        if (output.startsWith("4.4.2")) {
                            validVersion = true;
                            break;
                        }
                        int curVerInt = Integer.parseInt(curVerArray[i]);
                        int reqVerInt = Integer.parseInt(reqVerArray[i]);
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)("sTaskCheckRPMVersion::performVerification comparing" + curVerInt + " with " + reqVerInt));
                        }
                        if (curVerInt > reqVerInt) {
                            validVersion = true;
                            break;
                        }
                        if (curVerInt == reqVerInt) continue;
                        validVersion = false;
                        break;
                    }
                    if (validVersion) {
                        result.setStatus(1);
                        rpmVerResults.addResult(node, result);
                        continue;
                    }
                    errMsg = s_msgBundle.getMessage("9106", true, (Object[])new String[]{"4.4.2", output, node});
                    result.addErrorDescription(new ErrorDescription(errMsg));
                    result.setStatus(3);
                    rpmVerResults.addResult(node, result);
                    continue;
                }
                nodeVersionPair.put(node, output);
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"sTaskCheckRPMVersion::performVerification verification OR operation failed ");
                }
                errMsg = s_msgBundle.getMessage("9108", true, (Object[])new String[]{node}) + VerificationUtil.LSEP + result.getExecutionErrorDetails();
                result.addErrorDescription(new ErrorDescription(errMsg));
                result.setStatus(2);
                rpmVerResults.addResult(node, result);
                continue;
            }
            nodeVersionPair.put(node, null);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"sTaskCheckRPMVersion::performVerification verification OR operation failed ");
            }
            errMsg = s_msgBundle.getMessage("9108", true, (Object[])new String[]{node});
            result.addErrorDescription(new ErrorDescription(errMsg));
            result.setStatus(2);
            rpmVerResults.addResult(node, result);
        }
    }

    public String getExpectedRPMVersion() {
        return "4.4.2";
    }
}

