/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.fixup.FixupData;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskDaemonLiveliness;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkDataDiscovery;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskCheckIPMPSettings
extends Task {
    private boolean m_isPre = false;
    private List<NetworkInfo> m_globalPrivateInterfaceList = null;
    private List<NetworkInfo> m_globalPublicInterfaceList = null;
    private final String MPATHD_DAEMON_NAME_SOLARIS = "in.mpathd";
    private final String IPMP_NIC_CONF_FILE_PATH_PREFIX = "/etc/hostname.";
    private final String DEFAULT_MAC_ADDRESS = "UNDEFINED_MAC_ADDRESS";
    private boolean isOSReleasePost10 = false;
    private Hashtable<String, List<NetworkInfo>> m_nodeSpecificPrivateInterfaceList = null;
    private Hashtable<String, List<NetworkInfo>> m_nodeSpecificPublicInterfaceList = null;
    private Hashtable<String, List<NetworkInfo>> m_nodeSpecificParticipatingIPMPInterfaceTable = null;
    HashMap<String, List<NetworkInfo>> m_allIPMPGroupInterfaceList = null;
    private List<String> m_errorMsgList = new ArrayList<String>();
    private List<String> m_warningMsgList = new ArrayList<String>();

    public sTaskCheckIPMPSettings(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        this.m_isPre = this.m_globalContext.isPreCRS();
        this.m_globalPrivateInterfaceList = new ArrayList<NetworkInfo>();
        this.m_globalPublicInterfaceList = new ArrayList<NetworkInfo>();
        this.m_nodeSpecificPrivateInterfaceList = new Hashtable();
        this.m_nodeSpecificPublicInterfaceList = new Hashtable();
        this.m_nodeSpecificParticipatingIPMPInterfaceTable = new Hashtable();
        this.isOSReleasePost10 = this.compareOSRelease(5, 11);
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        ResultSet ipmpResSet = new ResultSet();
        Trace.out((String)"Checking if IPMP group configuration exist or not");
        this.m_allIPMPGroupInterfaceList = new VerifyNetwork().getIPMPConfigInfo(this.m_nodeList, ipmpResSet);
        if (!ipmpResSet.anySuccess() || this.m_allIPMPGroupInterfaceList.isEmpty()) {
            VerificationUtil.traceAndLog("Failure in retrieval of IPMP configuration information on all nodes");
            return false;
        }
        if (this.m_globalContext.isRollingUpgrade()) {
            if (this.m_globalContext.isLocalNodeCRSRunning()) {
                Trace.out((String)"Upgrade: Adding IPMP check on Solaris, local CRS up.");
                this.m_isPre = false;
                return true;
            }
            Trace.out((String)"Upgrade: not adding IPMP check (Solaris) local CRS not up. Or could not get the status of CRS on node");
        } else {
            if (this.m_globalContext.isLocalNodeCRSRunning()) {
                Trace.out((String)"Upgrade: Adding IPMP check on Solaris, local CRS up.");
                this.m_isPre = false;
                return true;
            }
            String ifList = CVUVariables.getValue(CVUVariableConstants.INTERCONNECT_LIST);
            if (ifList != null && ifList.trim().length() > 0) {
                Trace.out((String)"Adding IPMP check on Solaris for Pre req scenario, the INTERCONNECT_LIST installer variable will be used to get the interconnect information.");
                this.m_isPre = true;
                return true;
            }
            Trace.out((String)"Not adding the IPMP check on solaris as the INTERCONNECT_LIST variable is not found set by installer.");
        }
        return false;
    }

    public sTaskCheckIPMPSettings(String[] nodeList, boolean isPreCRS) {
        this.m_nodeList = nodeList;
        this.m_isPre = isPreCRS;
        this.m_globalPrivateInterfaceList = new ArrayList<NetworkInfo>();
        this.m_globalPublicInterfaceList = new ArrayList<NetworkInfo>();
        this.m_nodeSpecificPrivateInterfaceList = new Hashtable();
        this.m_nodeSpecificPublicInterfaceList = new Hashtable();
        this.m_nodeSpecificParticipatingIPMPInterfaceTable = new Hashtable();
        this.isOSReleasePost10 = this.compareOSRelease(5, 11);
    }

    @Override
    public boolean performTask() {
        boolean result = true;
        result = this.performInterfaceConsistency();
        if (this.m_nodeSpecificParticipatingIPMPInterfaceTable.size() > 0) {
            String[] nodesWithIPMPConfig = this.m_nodeSpecificParticipatingIPMPInterfaceTable.keySet().toArray(new String[0]);
            if (null != nodesWithIPMPConfig && nodesWithIPMPConfig.length > 0) {
                result &= this.performMpathdDaemonLivelinessCheck(nodesWithIPMPConfig);
            }
            if (!this.isOSReleasePost10) {
                result &= this.performNicConfFileExistenceCheckForIPMPIfs();
            }
            result &= this.performDeprecatedtatusCheck();
            result &= this.performSubnetAndMacAddressCheck();
            if (this.isOSReleasePost10) {
                result &= this.performSol11SpecificIPMPCheck();
            }
        }
        return result;
    }

    private boolean performInterfaceConsistency() {
        boolean retVal = false;
        ReportUtil.blankln();
        String msgString = null;
        ResultSet currentConfigResultSet = new ResultSet();
        ReportUtil.blankln();
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("1502", false));
        this.retrieveNetworkInterfaceList(currentConfigResultSet);
        if (currentConfigResultSet.getStatus() == 4) {
            Trace.out((String)"No interface information available about the current configuration");
            msgString = s_gMsgBundle.getMessage("1546", true);
            this.m_resultSet.addResultSetData(currentConfigResultSet);
            ReportUtil.printWarning(msgString);
            return true;
        }
        if (!currentConfigResultSet.anySuccess()) {
            Trace.out((String)"Failure in retrieval of Current configuration of public and private classification");
            this.m_resultSet.addResultSetData(currentConfigResultSet);
            ReportUtil.printError(s_gMsgBundle.getMessage("1512", true));
            retVal = false;
        } else {
            this.m_resultSet.addResultSetData(currentConfigResultSet);
            ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.COMMENT);
            Hashtable resultTable = this.m_resultSet.getResultTable();
            Enumeration resultTableKeys = resultTable.keys();
            ArrayList<String> inconsistentIPMPConfigNodeList = new ArrayList<String>();
            while (resultTableKeys.hasMoreElements()) {
                String node = (String)resultTableKeys.nextElement();
                Result result = (Result)resultTable.get(node);
                if (result.getStatus() == 1) {
                    List<NetworkInfo> nodeIpmpInterfaceList = this.m_allIPMPGroupInterfaceList.get(node);
                    if (nodeIpmpInterfaceList.isEmpty()) {
                        msgString = s_gMsgBundle.getMessage("1507", false);
                        ReportUtil.writeRecord(node, ReportUtil.PASSED, msgString);
                        this.m_resultSet.addResult(node, 1);
                        continue;
                    }
                    retVal = this.validateInterfaceConsistency(node, nodeIpmpInterfaceList);
                    if (retVal || inconsistentIPMPConfigNodeList.contains(node)) continue;
                    inconsistentIPMPConfigNodeList.add(node);
                    continue;
                }
                if (result.getStatus() == 2) {
                    msgString = s_gMsgBundle.getMessage("1513", false, (Object[])new String[]{node});
                    this.m_resultSet.addErrorDescription(node, new ErrorDescription(s_gMsgBundle.getMessage("1513", true, (Object[])new String[]{node})));
                } else {
                    msgString = s_gMsgBundle.getMessage("1511", false, (Object[])new String[]{node});
                    this.m_resultSet.addErrorDescription(node, new ErrorDescription(s_gMsgBundle.getMessage("1511", true, (Object[])new String[]{node})));
                }
                ReportUtil.writeRecord(node, ReportUtil.FAILED, msgString);
            }
            if (inconsistentIPMPConfigNodeList.size() > 0) {
                this.m_resultSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("1545", true, (Object[])new String[]{VerificationUtil.strCollection2String(inconsistentIPMPConfigNodeList)})));
            }
        }
        for (String errorMsg : this.m_errorMsgList) {
            ReportUtil.printError(errorMsg);
        }
        this.m_errorMsgList.clear();
        this.m_resultSet.setStatus();
        retVal = !this.m_resultSet.anyFailure();
        msgString = retVal ? s_gMsgBundle.getMessage("1503", false) : s_gMsgBundle.getMessage("1505", false);
        ReportUtil.printResult(msgString);
        return retVal;
    }

    private boolean performNicConfFileExistenceCheckForIPMPIfs() {
        boolean result = true;
        ArrayList<String> nicConfFileMissingNodes = new ArrayList<String>();
        ReportUtil.blankln();
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("1518", false));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.COMMENT);
        for (String node : this.m_nodeSpecificParticipatingIPMPInterfaceTable.keySet()) {
            boolean isNICFileAbsentOnNode = false;
            for (NetworkInfo ipmpIf : this.m_nodeSpecificParticipatingIPMPInterfaceTable.get(node)) {
                if (ipmpIf.isNICConfFileExists()) continue;
                isNICFileAbsentOnNode = true;
                if (!nicConfFileMissingNodes.contains(node)) {
                    nicConfFileMissingNodes.add(node);
                }
                String nicConfFilePath = "/etc/hostname." + ipmpIf.getInterfaceName();
                Trace.out((String)("The NIC configuration file " + nicConfFilePath + " for interface " + ipmpIf.getInterfaceName() + " does not exists on node " + node));
                VerificationLogData.log("The NIC configuration file " + nicConfFilePath + " for interface " + ipmpIf.getInterfaceName() + " does not exists on node " + node);
                String errorMsg = s_gMsgBundle.getMessage("1521", true, (Object[])new String[]{nicConfFilePath, ipmpIf.getInterfaceName(), node});
                this.m_errorMsgList.add(errorMsg);
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(errorMsg));
                this.m_resultSet.addResult(node, 3);
            }
            if (isNICFileAbsentOnNode) {
                ReportUtil.writeRecord(node, ReportUtil.NOTEXIST, ReportUtil.FAILED);
                continue;
            }
            ReportUtil.writeRecord(node, ReportUtil.EXIST, ReportUtil.PASSED);
        }
        if (nicConfFileMissingNodes.size() > 0) {
            result = false;
            Trace.out((String)("The NIC configuration files were found missing for ipmp interfaces on nodes:" + VerificationUtil.strCollection2String(nicConfFileMissingNodes)));
            VerificationLogData.log("The NIC configuration files were found missing for ipmp interfaces on nodes:" + VerificationUtil.strCollection2String(nicConfFileMissingNodes));
            String errorMsg = s_gMsgBundle.getMessage("1522", true, (Object[])new String[]{VerificationUtil.strCollection2String(nicConfFileMissingNodes)});
            this.m_resultSet.addErrorDescription(new ErrorDescription(errorMsg));
            this.m_errorMsgList.add(errorMsg);
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1520", false, (Object[])new String[]{VerificationUtil.strCollection2String(nicConfFileMissingNodes)}));
        } else {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1519", false));
        }
        for (String errorMsg : this.m_errorMsgList) {
            ReportUtil.printError(errorMsg);
        }
        this.m_errorMsgList.clear();
        return result;
    }

    private boolean performMpathdDaemonLivelinessCheck(String[] nodeListToCheckDaemon) {
        boolean isDaemonAlive = false;
        Vector<String> daemonAliveNodes = new Vector<String>();
        TaskDaemonLiveliness taskMpathdDaemon = new TaskDaemonLiveliness(nodeListToCheckDaemon, daemonAliveNodes);
        taskMpathdDaemon.setDaemonName("in.mpathd");
        taskMpathdDaemon.perform();
        ResultSet mpathdResultSet = taskMpathdDaemon.getResultSet();
        if (mpathdResultSet.allSuccess()) {
            Trace.out((String)"in.mpathd is running/alive on all nodes");
            VerificationLogData.log("in.mpathd is running/alive on all nodes");
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1514", false, (Object[])new String[]{"in.mpathd"}));
            isDaemonAlive = true;
        } else {
            if (this.isFixupReqd()) {
                this.generateFixups(mpathdResultSet);
            }
            Trace.out((String)"in.mpathd is not running/alive on some of the nodes");
            VerificationLogData.log("in.mpathd is not running/alive on some of the nodes");
            String[] failedNodes = mpathdResultSet.getFailureNodes();
            if (failedNodes != null && failedNodes.length > 0) {
                for (String failedNode : failedNodes) {
                    String errorMsg;
                    Result failedNodeResult = mpathdResultSet.getResult(failedNode);
                    if (failedNodeResult.getStatus() == 3) {
                        errorMsg = s_gMsgBundle.getMessage("1515", true, (Object[])new String[]{"in.mpathd", failedNode});
                        failedNodeResult.addErrorDescription(new ErrorDescription(errorMsg));
                        this.m_errorMsgList.add(errorMsg);
                        Trace.out((String)("in.mpathd is not running/alive on the node " + failedNode));
                        VerificationLogData.log("in.mpathd is not running/alive on the node " + failedNode);
                        continue;
                    }
                    if (failedNodeResult.getStatus() != 2) continue;
                    errorMsg = s_gMsgBundle.getMessage("1516", true, (Object[])new String[]{"in.mpathd", failedNode});
                    failedNodeResult.addErrorDescription(new ErrorDescription(errorMsg));
                    this.m_errorMsgList.add(errorMsg);
                    Trace.out((String)("in.mpathd status could not be determined on the node " + failedNode));
                    VerificationLogData.log("in.mpathd status could not be determined on the node " + failedNode);
                }
                String errorMsg = s_gMsgBundle.getMessage("1517", true, (Object[])new String[]{"in.mpathd", VerificationUtil.strArr2List(failedNodes)});
                this.m_errorMsgList.add(errorMsg);
                mpathdResultSet.addErrorDescription(new ErrorDescription(errorMsg));
            }
        }
        for (String errorMsg : this.m_errorMsgList) {
            ReportUtil.printError(errorMsg);
        }
        this.m_errorMsgList.clear();
        this.m_resultSet.uploadResultSet(mpathdResultSet);
        return isDaemonAlive;
    }

    private boolean performDeprecatedtatusCheck() {
        boolean result = true;
        ArrayList<String> nodesWithDeprecatedIPMPInterfaces = new ArrayList<String>();
        ReportUtil.blankln();
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("1523", false));
        VerificationUtil.traceAndLog("Performing deprecated status check for the IPMP interfaces");
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.COMMENT);
        for (String node : this.m_nodeSpecificParticipatingIPMPInterfaceTable.keySet()) {
            ArrayList<String> deprecatedInterfacesOnNode = new ArrayList<String>();
            for (NetworkInfo ipmpIf : this.m_nodeSpecificParticipatingIPMPInterfaceTable.get(node)) {
                if (!ipmpIf.isDeprecated()) continue;
                result = false;
                if (!deprecatedInterfacesOnNode.contains(ipmpIf.getInterfaceName())) {
                    deprecatedInterfacesOnNode.add(ipmpIf.getInterfaceName());
                }
                if (!nodesWithDeprecatedIPMPInterfaces.contains(node)) {
                    nodesWithDeprecatedIPMPInterfaces.add(node);
                }
                String errorMsg = s_gMsgBundle.getMessage("1526", true, (Object[])new String[]{ipmpIf.getInterfaceName(), ipmpIf.getGroupName(), node});
                this.m_warningMsgList.add(errorMsg);
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(errorMsg));
                this.m_resultSet.addResult(node, 4);
                Trace.out((String)("IPMP interface " + ipmpIf.getInterfaceName() + " participating in an ipmp group " + ipmpIf.getGroupName() + " has a deprecated flag set on node " + node));
                VerificationLogData.log("IPMP interface " + ipmpIf.getInterfaceName() + " participating in an ipmp group " + ipmpIf.getGroupName() + " has a deprecated flag set on node " + node);
            }
            if (deprecatedInterfacesOnNode.size() > 0) {
                ReportUtil.writeRecord(node, ReportUtil.WARNING, VerificationUtil.strCollection2String(deprecatedInterfacesOnNode));
                continue;
            }
            ReportUtil.writeRecord(node, ReportUtil.PASSED, ReportUtil.PASSED);
        }
        if (nodesWithDeprecatedIPMPInterfaces.size() > 0) {
            this.m_resultSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("1527", true, (Object[])new String[]{VerificationUtil.strCollection2String(nodesWithDeprecatedIPMPInterfaces)})));
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1525", false, (Object[])new String[]{VerificationUtil.strCollection2String(nodesWithDeprecatedIPMPInterfaces)}));
        } else {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1524", false));
        }
        for (String warningMsg : this.m_warningMsgList) {
            ReportUtil.printWarning(warningMsg);
        }
        this.m_warningMsgList.clear();
        return result;
    }

    private boolean performSubnetAndMacAddressCheck() {
        boolean result = true;
        ArrayList<String> nodesWithPUBSubnetMissmatch = new ArrayList<String>();
        ArrayList<String> nodesWithPVTSubnetMissmatch = new ArrayList<String>();
        ArrayList<String> nodesWithNonUnqMacAddress = new ArrayList<String>();
        ArrayList<String> nodesWithPubIpmpInterfaces = new ArrayList<String>();
        ArrayList<String> nodesWithPvtIpmpInterfaces = new ArrayList<String>();
        Hashtable classifiedPvtSubnetWithIfList = new Hashtable();
        Hashtable classifiedPubSubnetWithIfList = new Hashtable();
        for (String node : this.m_nodeSpecificParticipatingIPMPInterfaceTable.keySet()) {
            String errorMsg;
            ArrayList<InetAddress> missingSubnetList;
            String ifName;
            ArrayList ifNameList;
            Hashtable configPubIpmpIfNameWithSubnetListForNode = new Hashtable();
            Hashtable configPvtIpmpIfNameWithSubnetListForNode = new Hashtable();
            Hashtable nodeMacAddressIfListTable = new Hashtable();
            for (NetworkInfo networkInfo : this.m_nodeSpecificParticipatingIPMPInterfaceTable.get(node)) {
                List<InetAddress> ipmpIfSubnetList = networkInfo.getConfiguredSubnets();
                String ipmpIfMacAddress = networkInfo.getMacAddress();
                if (!VerificationUtil.isStringGood(ipmpIfMacAddress)) {
                    ipmpIfMacAddress = "UNDEFINED_MAC_ADDRESS";
                }
                Iterator<InetAddress> ipmpIfName = networkInfo.getInterfaceName();
                if (ipmpIfSubnetList != null && !ipmpIfSubnetList.isEmpty()) {
                    ArrayList<InetAddress> subnetAddressList;
                    if (this.m_globalPrivateInterfaceList.contains(ipmpIfName) || this.m_nodeSpecificPrivateInterfaceList.containsKey(node) && this.m_nodeSpecificPrivateInterfaceList.get(node).contains(ipmpIfName)) {
                        if (!nodesWithPvtIpmpInterfaces.contains(node)) {
                            nodesWithPvtIpmpInterfaces.add(node);
                        }
                        Trace.out((String)("Ipmp interface " + ipmpIfName + " is privately classified with subnets (" + sTaskCheckIPMPSettings.inetAddressCollectionToString(ipmpIfSubnetList) + ") and hence adding to private interface list to process for node " + node));
                        for (InetAddress ipmpIfSubnetAddress : ipmpIfSubnetList) {
                            if (configPvtIpmpIfNameWithSubnetListForNode.containsKey(ipmpIfName)) {
                                if (((List)configPvtIpmpIfNameWithSubnetListForNode.get(ipmpIfName)).contains(ipmpIfSubnetAddress)) continue;
                                ((List)configPvtIpmpIfNameWithSubnetListForNode.get(ipmpIfName)).add(ipmpIfSubnetAddress);
                                continue;
                            }
                            subnetAddressList = new ArrayList<InetAddress>();
                            subnetAddressList.add(ipmpIfSubnetAddress);
                            configPvtIpmpIfNameWithSubnetListForNode.put(ipmpIfName, subnetAddressList);
                        }
                    } else {
                        if (!nodesWithPubIpmpInterfaces.contains(node)) {
                            nodesWithPubIpmpInterfaces.add(node);
                        }
                        Trace.out((String)("Ipmp interface " + ipmpIfName + " is publicly classified with subnets (" + sTaskCheckIPMPSettings.inetAddressCollectionToString(ipmpIfSubnetList) + ") and hence adding to public interface list to process for node " + node));
                        for (InetAddress ipmpIfSubnetAddress : ipmpIfSubnetList) {
                            if (configPubIpmpIfNameWithSubnetListForNode.containsKey(ipmpIfName)) {
                                if (((List)configPubIpmpIfNameWithSubnetListForNode.get(ipmpIfName)).contains(ipmpIfSubnetAddress)) continue;
                                ((List)configPubIpmpIfNameWithSubnetListForNode.get(ipmpIfName)).add(ipmpIfSubnetAddress);
                                continue;
                            }
                            subnetAddressList = new ArrayList();
                            subnetAddressList.add(ipmpIfSubnetAddress);
                            configPubIpmpIfNameWithSubnetListForNode.put(ipmpIfName, subnetAddressList);
                        }
                    }
                }
                if (!VerificationUtil.isStringGood(ipmpIfMacAddress)) continue;
                if (nodeMacAddressIfListTable.containsKey(ipmpIfMacAddress)) {
                    ((HashSet)nodeMacAddressIfListTable.get(ipmpIfMacAddress)).add(ipmpIfName);
                    continue;
                }
                HashSet<Iterator<InetAddress>> ifNameList2 = new HashSet<Iterator<InetAddress>>();
                ifNameList2.add(ipmpIfName);
                nodeMacAddressIfListTable.put(ipmpIfMacAddress, ifNameList2);
            }
            if (!configPubIpmpIfNameWithSubnetListForNode.isEmpty()) {
                for (NetworkInfo networkInfo : this.m_globalPublicInterfaceList) {
                    List<InetAddress> globalPubIfSubnetAddrList = networkInfo.getConfiguredSubnets();
                    String ifName2 = networkInfo.getInterfaceName();
                    for (InetAddress publicSubnetAddress : globalPubIfSubnetAddrList) {
                        if (!classifiedPubSubnetWithIfList.containsKey(publicSubnetAddress)) {
                            ifNameList = new ArrayList();
                            classifiedPubSubnetWithIfList.put(publicSubnetAddress, ifNameList);
                        }
                        if (((List)classifiedPubSubnetWithIfList.get(publicSubnetAddress)).contains(ifName2)) continue;
                        ((List)classifiedPubSubnetWithIfList.get(publicSubnetAddress)).add(ifName2);
                    }
                }
                if (this.m_nodeSpecificPublicInterfaceList.containsKey(node)) {
                    for (NetworkInfo networkInfo : this.m_nodeSpecificPublicInterfaceList.get(node)) {
                        List<InetAddress> nodePubIfSubnetAddrList = networkInfo.getConfiguredSubnets();
                        ifName = networkInfo.getInterfaceName();
                        for (InetAddress publicSubnetAddress : nodePubIfSubnetAddrList) {
                            if (!classifiedPubSubnetWithIfList.containsKey(publicSubnetAddress)) {
                                ifNameList = new ArrayList();
                                classifiedPubSubnetWithIfList.put(publicSubnetAddress, ifNameList);
                            }
                            if (((List)classifiedPubSubnetWithIfList.get(publicSubnetAddress)).contains(ifName)) continue;
                            ((List)classifiedPubSubnetWithIfList.get(publicSubnetAddress)).add(ifName);
                        }
                    }
                }
                if (!classifiedPubSubnetWithIfList.isEmpty()) {
                    Iterator<NetworkInfo> publicIpmpIfsWithMissingSubnetList = new Hashtable();
                    Trace.out((String)("Filtering the miss-matching subnet by comparing ipmp interface's subnets with classified public subnets (" + sTaskCheckIPMPSettings.inetAddressCollectionToString(classifiedPubSubnetWithIfList.keySet()) + ")"));
                    for (String publicIpmpIf : configPubIpmpIfNameWithSubnetListForNode.keySet()) {
                        List publicIpmpIfSubnetList = (List)configPubIpmpIfNameWithSubnetListForNode.get(publicIpmpIf);
                        for (InetAddress classifiedPubSubnet : classifiedPubSubnetWithIfList.keySet()) {
                            if (publicIpmpIfSubnetList.contains(classifiedPubSubnet)) continue;
                            if (((Hashtable)((Object)publicIpmpIfsWithMissingSubnetList)).containsKey(publicIpmpIf)) {
                                if (((List)((Hashtable)((Object)publicIpmpIfsWithMissingSubnetList)).get(publicIpmpIf)).contains(classifiedPubSubnet)) continue;
                                ((List)((Hashtable)((Object)publicIpmpIfsWithMissingSubnetList)).get(publicIpmpIf)).add(classifiedPubSubnet);
                                continue;
                            }
                            missingSubnetList = new ArrayList<InetAddress>();
                            missingSubnetList.add(classifiedPubSubnet);
                            ((Hashtable)((Object)publicIpmpIfsWithMissingSubnetList)).put(publicIpmpIf, missingSubnetList);
                        }
                    }
                    if (!((Hashtable)((Object)publicIpmpIfsWithMissingSubnetList)).isEmpty()) {
                        result = false;
                        if (!nodesWithPUBSubnetMissmatch.contains(node)) {
                            nodesWithPUBSubnetMissmatch.add(node);
                        }
                        for (String ifName2 : ((Hashtable)((Object)publicIpmpIfsWithMissingSubnetList)).keySet()) {
                            Trace.out((String)("The public ipmp interface " + ifName2 + " does not have the matching subnet " + sTaskCheckIPMPSettings.inetAddressCollectionToString((Collection)((Hashtable)((Object)publicIpmpIfsWithMissingSubnetList)).get(ifName2)) + " configured on node " + node));
                            VerificationLogData.log("The public ipmp interface " + ifName2 + " does not have the matching subnet " + sTaskCheckIPMPSettings.inetAddressCollectionToString((Collection)((Hashtable)((Object)publicIpmpIfsWithMissingSubnetList)).get(ifName2)) + " configured on node " + node);
                            errorMsg = s_gMsgBundle.getMessage("1533", true, (Object[])new String[]{ifName2, sTaskCheckIPMPSettings.inetAddressCollectionToString((Collection)((Hashtable)((Object)publicIpmpIfsWithMissingSubnetList)).get(ifName2)), node});
                            this.m_resultSet.addErrorDescription(node, new ErrorDescription(errorMsg));
                            this.m_resultSet.addResult(node, 3);
                            this.m_errorMsgList.add(errorMsg);
                        }
                    }
                } else {
                    Trace.out((String)"The classified public subnets could not be retrieved");
                }
            }
            if (!configPvtIpmpIfNameWithSubnetListForNode.isEmpty()) {
                for (NetworkInfo networkInfo : this.m_globalPrivateInterfaceList) {
                    List<InetAddress> globalPvtIfSubnetAddrList = networkInfo.getConfiguredSubnets();
                    ifName = networkInfo.getInterfaceName();
                    for (InetAddress privateSubnetAddress : globalPvtIfSubnetAddrList) {
                        if (!classifiedPvtSubnetWithIfList.containsKey(privateSubnetAddress)) {
                            ifNameList = new ArrayList();
                            classifiedPvtSubnetWithIfList.put(privateSubnetAddress, ifNameList);
                        }
                        if (((List)classifiedPvtSubnetWithIfList.get(privateSubnetAddress)).contains(ifName)) continue;
                        ((List)classifiedPvtSubnetWithIfList.get(privateSubnetAddress)).add(ifName);
                    }
                }
                if (this.m_nodeSpecificPrivateInterfaceList.containsKey(node)) {
                    for (NetworkInfo networkInfo : this.m_nodeSpecificPrivateInterfaceList.get(node)) {
                        List<InetAddress> nodePvtIfSubnetAddrList = networkInfo.getConfiguredSubnets();
                        ifName = networkInfo.getInterfaceName();
                        for (InetAddress privateSubnetAddress : nodePvtIfSubnetAddrList) {
                            if (!classifiedPvtSubnetWithIfList.containsKey(privateSubnetAddress)) {
                                ifNameList = new ArrayList();
                                classifiedPvtSubnetWithIfList.put(privateSubnetAddress, ifNameList);
                            }
                            if (((List)classifiedPvtSubnetWithIfList.get(privateSubnetAddress)).contains(ifName)) continue;
                            ((List)classifiedPvtSubnetWithIfList.get(privateSubnetAddress)).add(ifName);
                        }
                    }
                }
                if (!classifiedPvtSubnetWithIfList.isEmpty()) {
                    Hashtable privateIpmpIfsWithMissingSubnetList = new Hashtable();
                    Trace.out((String)("Filtering the miss-matching subnet by comparing with IPMP interface's configured subnets with classified private subnets (" + sTaskCheckIPMPSettings.inetAddressCollectionToString(classifiedPvtSubnetWithIfList.keySet()) + ")"));
                    for (String privateIpmpIf : configPvtIpmpIfNameWithSubnetListForNode.keySet()) {
                        List privateIpmpIfSubnetList = (List)configPvtIpmpIfNameWithSubnetListForNode.get(privateIpmpIf);
                        for (InetAddress classifiedPvtSubnet : classifiedPvtSubnetWithIfList.keySet()) {
                            if (privateIpmpIfSubnetList.contains(classifiedPvtSubnet)) continue;
                            if (privateIpmpIfsWithMissingSubnetList.containsKey(privateIpmpIf)) {
                                if (((List)privateIpmpIfsWithMissingSubnetList.get(privateIpmpIf)).contains(classifiedPvtSubnet)) continue;
                                ((List)privateIpmpIfsWithMissingSubnetList.get(privateIpmpIf)).add(classifiedPvtSubnet);
                                continue;
                            }
                            missingSubnetList = new ArrayList();
                            missingSubnetList.add(classifiedPvtSubnet);
                            privateIpmpIfsWithMissingSubnetList.put(privateIpmpIf, missingSubnetList);
                        }
                    }
                    if (!privateIpmpIfsWithMissingSubnetList.isEmpty()) {
                        result = false;
                        if (!nodesWithPVTSubnetMissmatch.contains(node)) {
                            nodesWithPVTSubnetMissmatch.add(node);
                        }
                        for (String ifName2 : privateIpmpIfsWithMissingSubnetList.keySet()) {
                            Trace.out((String)("The private ipmp interfaces " + ifName2 + " do not have the Matching subnets " + sTaskCheckIPMPSettings.inetAddressCollectionToString((Collection)privateIpmpIfsWithMissingSubnetList.get(ifName2)) + " configured on node " + node));
                            VerificationLogData.log("The private ipmp interfaces " + ifName2 + " do not have the Matching subnets " + sTaskCheckIPMPSettings.inetAddressCollectionToString((Collection)privateIpmpIfsWithMissingSubnetList.get(ifName2)) + " configured on node " + node);
                            errorMsg = s_gMsgBundle.getMessage("1538", true, (Object[])new String[]{ifName2, sTaskCheckIPMPSettings.inetAddressCollectionToString((Collection)privateIpmpIfsWithMissingSubnetList.get(ifName2)), node});
                            this.m_resultSet.addErrorDescription(node, new ErrorDescription(errorMsg));
                            this.m_resultSet.addResult(node, 3);
                            this.m_errorMsgList.add(errorMsg);
                        }
                    }
                } else {
                    Trace.out((String)"The classified private subnets could not be retrieved");
                }
            }
            if (nodeMacAddressIfListTable.size() <= 0 || nodeMacAddressIfListTable.size() == this.m_nodeSpecificParticipatingIPMPInterfaceTable.get(node).size()) continue;
            Trace.out((String)"Some of the ipmp interfaces may not have an unique MAC/Hardware address");
            HashMap nonUniqueMACAddressInterfacesMap = new HashMap();
            for (String macAddress : nodeMacAddressIfListTable.keySet()) {
                if (((HashSet)nodeMacAddressIfListTable.get(macAddress)).size() <= 1) continue;
                nonUniqueMACAddressInterfacesMap.put(macAddress, nodeMacAddressIfListTable.get(macAddress));
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (nonUniqueMACAddressInterfacesMap.isEmpty()) continue;
            result = false;
            if (!nodesWithNonUnqMacAddress.contains(node)) {
                nodesWithNonUnqMacAddress.add(node);
            }
            for (String inconsistentMACAddress : nonUniqueMACAddressInterfacesMap.keySet()) {
                Set inconsistentInterfacesForThisMACAddress = (Set)nonUniqueMACAddressInterfacesMap.get(inconsistentMACAddress);
                VerificationUtil.traceAndLog("The ipmp interfaces " + VerificationUtil.strCollection2String(inconsistentInterfacesForThisMACAddress) + " share the MAC/Hardware address " + inconsistentMACAddress + " on node " + node);
                String errorMsg2 = s_gMsgBundle.getMessage("1543", true, (Object[])new String[]{VerificationUtil.strCollection2String(inconsistentInterfacesForThisMACAddress), inconsistentMACAddress, node});
                stringBuilder.append(errorMsg2);
            }
            if (stringBuilder.length() <= 0) continue;
            this.m_resultSet.addErrorDescription(node, new ErrorDescription(stringBuilder.toString()));
            this.m_resultSet.addResult(node, 3);
            this.m_errorMsgList.add(stringBuilder.toString());
        }
        ReportUtil.blankln();
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("1540", false));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS);
        for (String node : this.m_nodeSpecificParticipatingIPMPInterfaceTable.keySet()) {
            if (nodesWithNonUnqMacAddress.contains(node)) {
                ReportUtil.writeRecord(node, ReportUtil.FAILED);
                continue;
            }
            ReportUtil.writeRecord(node, ReportUtil.PASSED);
        }
        if (nodesWithNonUnqMacAddress.size() > 0) {
            this.m_resultSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("1544", true, (Object[])new String[]{VerificationUtil.strCollection2String(nodesWithNonUnqMacAddress)})));
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1542", false, (Object[])new String[]{VerificationUtil.strCollection2String(nodesWithNonUnqMacAddress)}));
        } else {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1541", false));
        }
        if (!nodesWithPvtIpmpInterfaces.isEmpty()) {
            ReportUtil.blankln();
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1535", false, (Object[])new String[]{sTaskCheckIPMPSettings.inetAddressCollectionToString(classifiedPvtSubnetWithIfList.keySet())}));
            ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS);
            for (String node : nodesWithPvtIpmpInterfaces) {
                if (nodesWithPVTSubnetMissmatch.contains(node)) {
                    ReportUtil.writeRecord(node, ReportUtil.FAILED);
                    continue;
                }
                ReportUtil.writeRecord(node, ReportUtil.PASSED);
            }
            if (nodesWithPVTSubnetMissmatch.size() > 0) {
                this.m_resultSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("1539", true, (Object[])new String[]{VerificationUtil.strCollection2String(nodesWithPVTSubnetMissmatch)})));
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("1537", false, (Object[])new String[]{VerificationUtil.strCollection2String(nodesWithPVTSubnetMissmatch)}));
            } else {
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("1536", false));
            }
        }
        if (!nodesWithPubIpmpInterfaces.isEmpty()) {
            ReportUtil.blankln();
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1530", false, (Object[])new String[]{sTaskCheckIPMPSettings.inetAddressCollectionToString(classifiedPubSubnetWithIfList.keySet())}));
            ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS);
            for (String node : nodesWithPubIpmpInterfaces) {
                if (nodesWithPUBSubnetMissmatch.contains(node)) {
                    ReportUtil.writeRecord(node, ReportUtil.FAILED);
                    continue;
                }
                ReportUtil.writeRecord(node, ReportUtil.PASSED);
            }
            if (nodesWithPUBSubnetMissmatch.size() > 0) {
                this.m_resultSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("1534", true, (Object[])new String[]{VerificationUtil.strCollection2String(nodesWithPUBSubnetMissmatch)})));
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("1532", false, (Object[])new String[]{VerificationUtil.strCollection2String(nodesWithPUBSubnetMissmatch)}));
            } else {
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("1531", false));
            }
        }
        for (String errorMsg : this.m_errorMsgList) {
            ReportUtil.printError(errorMsg);
        }
        this.m_errorMsgList.clear();
        return result;
    }

    private boolean performSol11SpecificIPMPCheck() {
        boolean result = true;
        ArrayList<String> reqNotMetNodes = new ArrayList<String>();
        for (String node : this.m_nodeSpecificParticipatingIPMPInterfaceTable.keySet()) {
            ArrayList<String> pvtIfList = new ArrayList<String>();
            for (NetworkInfo globalPrivateIf : this.m_globalPrivateInterfaceList) {
                String globalPvtIfName = globalPrivateIf.getInterfaceName();
                if (pvtIfList.contains(globalPvtIfName)) continue;
                pvtIfList.add(globalPvtIfName);
            }
            for (NetworkInfo ipmpIf : this.m_nodeSpecificParticipatingIPMPInterfaceTable.get(node)) {
                String ipmpIfName = ipmpIf.getInterfaceName();
                List<NetworkInfo> nodeSpecificPvtIfs = this.m_nodeSpecificPrivateInterfaceList.get(node);
                if (null != nodeSpecificPvtIfs && !nodeSpecificPvtIfs.isEmpty()) {
                    for (NetworkInfo nodePrivateIf : nodeSpecificPvtIfs) {
                        String nodePvtIfName = nodePrivateIf.getInterfaceName();
                        if (pvtIfList.contains(nodePvtIfName)) continue;
                        pvtIfList.add(nodePvtIfName);
                    }
                }
                for (String ipmpPvtIfName : pvtIfList) {
                    if (!ipmpPvtIfName.equalsIgnoreCase(ipmpIfName)) continue;
                    result = false;
                    if (!reqNotMetNodes.contains(node)) {
                        reqNotMetNodes.add(node);
                    }
                    Trace.out((String)("The privately classified interface " + ipmpIfName + " participates in a ipmp group " + ipmpIf.getGroupName() + " on node " + node));
                    VerificationLogData.logWarning("The privately classified interface " + ipmpIfName + " participates in a ipmp group " + ipmpIf.getGroupName() + " on node " + node);
                    String errorMsg = s_gMsgBundle.getMessage("1528", true, (Object[])new String[]{ipmpIfName, ipmpIf.getGroupName(), node});
                    this.m_errorMsgList.add(errorMsg);
                    this.m_resultSet.addErrorDescription(node, new ErrorDescription(errorMsg));
                    this.m_resultSet.addResult(node, 4);
                }
            }
        }
        if (reqNotMetNodes.size() > 0) {
            this.m_resultSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("1529", true, (Object[])new String[]{VerificationUtil.strCollection2String(reqNotMetNodes)})));
        }
        for (String warningMsg : this.m_errorMsgList) {
            ReportUtil.printWarning(warningMsg);
        }
        this.m_errorMsgList.clear();
        return result;
    }

    private boolean validateInterfaceConsistency(String node, List<NetworkInfo> ipmpInterfaces) {
        boolean isConsistent = true;
        Trace.out((String)("The List of IPMP interfaces for node  " + node + " is :"));
        for (NetworkInfo ifInfo : ipmpInterfaces) {
            Trace.out((String)("\n[" + ifInfo.getInterfaceName() + "] participates in " + "IPMP Group name (" + ifInfo.getGroupName() + ")"));
        }
        List<NetworkInfo> configuredPublicInterfaces = this.getPublicIfListForNode(node);
        List<NetworkInfo> configuredPrivateInterfaces = this.getPrivateIfListForNode(node);
        Hashtable<String, List<NetworkInfo>> groupIfListTable = new Hashtable<String, List<NetworkInfo>>();
        for (NetworkInfo ipmpIf : ipmpInterfaces) {
            String groupName = ipmpIf.getGroupName();
            if (!VerificationUtil.isStringGood(groupName)) continue;
            String ifName = ipmpIf.getInterfaceName();
            if (groupIfListTable.containsKey(groupName)) {
                if (VerificationUtil.isStringGood(ifName)) {
                    groupIfListTable.get(groupName).add(ipmpIf);
                    continue;
                }
                VerificationUtil.traceAndLog("Empty/Null interface name found. Not adding this interface to IPMP group");
                continue;
            }
            ArrayList<NetworkInfo> listOfInterfacesForGroup = new ArrayList<NetworkInfo>();
            if (VerificationUtil.isStringGood(ifName)) {
                listOfInterfacesForGroup.add(ipmpIf);
                groupIfListTable.put(groupName, listOfInterfacesForGroup);
                continue;
            }
            VerificationUtil.traceAndLog("Empty/Null interface name found. Not adding this interface to IPMP group");
        }
        if (this.checkInterfaceExistInIPMPGroups(groupIfListTable, configuredPublicInterfaces)) {
            Trace.out((String)"One of the interfaces in current public network classification is participating in IPMP group");
            isConsistent = this.checkInterfaceConsistencyNode(node, groupIfListTable, configuredPublicInterfaces, true);
        }
        if (this.checkInterfaceExistInIPMPGroups(groupIfListTable, configuredPrivateInterfaces)) {
            Trace.out((String)"One of the interfaces in current private network classification is participating in IPMP group");
            isConsistent = this.checkInterfaceConsistencyNode(node, groupIfListTable, configuredPrivateInterfaces, false);
        }
        if (isConsistent) {
            this.m_resultSet.addResult(node, 1);
            ReportUtil.writeRecord(node, ReportUtil.PASSED, ReportUtil.MATCHED);
        } else {
            ReportUtil.writeRecord(node, ReportUtil.FAILED, s_gMsgBundle.getMessage("1506", false));
            this.m_resultSet.addResult(node, 3);
        }
        return isConsistent;
    }

    private boolean checkInterfaceConsistencyNode(String node, Hashtable<String, List<NetworkInfo>> ipmpInterfaces, List<NetworkInfo> interfacesToVerify, boolean checkPublic) {
        boolean isConsistent = true;
        Trace.out((String)("Checking the IPMP interface consistency for node " + node));
        Trace.out(ipmpInterfaces);
        Set<String> groupNames = ipmpInterfaces.keySet();
        for (String group : groupNames) {
            List<NetworkInfo> ipmpInterfaceListForGroup = ipmpInterfaces.get(group);
            ArrayList<String> additionalParticipatingInterfaces = new ArrayList<String>();
            List<NetworkInfo> commonIpmpInterfaces = this.getCommonElements(ipmpInterfaceListForGroup, interfacesToVerify);
            Trace.out((String)("Number of matching interfaces between IPMP group " + group + " and current interface list is " + commonIpmpInterfaces.size()));
            if (commonIpmpInterfaces.size() <= 0) continue;
            if (!this.m_nodeSpecificParticipatingIPMPInterfaceTable.contains(node)) {
                Iterator<NetworkInfo> ipmpInterfaceListForNode = new ArrayList();
                this.m_nodeSpecificParticipatingIPMPInterfaceTable.put(node, (List<NetworkInfo>)((Object)ipmpInterfaceListForNode));
            }
            for (NetworkInfo networkInfo : commonIpmpInterfaces) {
                if (this.m_nodeSpecificParticipatingIPMPInterfaceTable.get(node).contains(networkInfo)) continue;
                this.m_nodeSpecificParticipatingIPMPInterfaceTable.get(node).add(networkInfo);
            }
            if (commonIpmpInterfaces.size() == ipmpInterfaceListForGroup.size()) {
                Trace.out((String)("CONSISTENT : on node " + node + " the IPMP group " + group + " contains all the configured " + (checkPublic ? "PUBLIC" : "PRIVATE") + " interfaces as members of failover group"));
                continue;
            }
            if (Trace.getCurrentTraceLevel() == 5) {
                Trace.out((String)("INCONSISTENT : on node " + node + " IPMP group " + group + " contains all the configured " + (checkPublic ? "PUBLIC" : "PRIVATE") + " interfaces as members of failover group and has additional interfaces"));
            }
            for (NetworkInfo networkInfo : ipmpInterfaceListForGroup) {
                boolean found = false;
                String ipmpIfName = networkInfo.getInterfaceName();
                Trace.out((String)("checking if " + ipmpIfName + " exists in  " + interfacesToVerify));
                for (NetworkInfo ifdata : interfacesToVerify) {
                    if (!ifdata.getInterfaceName().equals(ipmpIfName)) continue;
                    found = true;
                }
                if (found) continue;
                Trace.out((String)("Additional interface " + ipmpIfName));
                if (additionalParticipatingInterfaces.contains(ipmpIfName)) continue;
                additionalParticipatingInterfaces.add(ipmpIfName);
            }
            if (additionalParticipatingInterfaces.size() <= 0) continue;
            isConsistent = false;
            Trace.out((String)("On node " + node + " The IPMP group " + group + " in which all the configured " + (checkPublic ? "PUBLIC" : "PRIVATE") + " Interfaces participate has following additional Interfaces " + additionalParticipatingInterfaces));
            ArrayList<String> ipmpIfList = new ArrayList<String>();
            for (NetworkInfo ipmpIf3 : ipmpInterfaceListForGroup) {
                ipmpIfList.add(ipmpIf3.getInterfaceName());
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (NetworkInfo ifdata : interfacesToVerify) {
                arrayList.add(ifdata.getInterfaceName() + "/" + ifdata.getConfiguredSubnetListAsString());
            }
            String nodeConfiguredIfList = VerificationUtil.strList2List(arrayList);
            String additionalIpmpFailoverIfList = VerificationUtil.strList2List(additionalParticipatingInterfaces);
            String message = null;
            message = checkPublic ? s_gMsgBundle.getMessage("1509", true, (Object[])new String[]{group, VerificationUtil.strList2List(ipmpIfList), node, additionalIpmpFailoverIfList, nodeConfiguredIfList}) : s_gMsgBundle.getMessage("1508", true, (Object[])new String[]{group, VerificationUtil.strList2List(ipmpIfList), node, additionalIpmpFailoverIfList, nodeConfiguredIfList});
            this.m_errorMsgList.add(message);
            this.m_resultSet.addResult(node, 3);
            this.m_resultSet.addErrorDescription(node, new ErrorDescription(message));
        }
        return isConsistent;
    }

    private void retrieveNetworkInterfaceList(ResultSet currentConfigResultSet) {
        try {
            ResultSet resultSet = new ResultSet();
            Set<NetworkInfo> clusterNetworks = NetworkUtility.getNetworkInfo(resultSet);
            if (NetworkDataDiscovery.hasNetworkTypeInClusterNetworks(clusterNetworks, NetworkConstants.NetworkType.PUBLIC.getValue())) {
                this.updateNodeSpecificInterfaceList(clusterNetworks, NetworkConstants.NetworkType.PUBLIC);
                this.updateNodeSpecificInterfaceList(clusterNetworks, NetworkConstants.NetworkType.PRIVATE);
            }
        }
        catch (CVUException cvuException) {
            Trace.out((String)("Caught CVUException, Could not retrieve interface classification, Error is:\n" + cvuException.getMessage()));
            currentConfigResultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(s_gMsgBundle.getMessage("1512", true) + Constants.LINE_SEPARATOR + cvuException.getMessage()));
            currentConfigResultSet.addResult(this.m_nodeList, 2);
        }
        if (this.m_globalPrivateInterfaceList.isEmpty() && this.m_globalPublicInterfaceList.isEmpty() && this.m_nodeSpecificPrivateInterfaceList.isEmpty() && this.m_nodeSpecificPublicInterfaceList.isEmpty()) {
            if (m_isCLImode && this.m_isPre) {
                currentConfigResultSet.addResult(this.m_nodeList, 4);
                ErrorDescription errDesc = new ErrorDescription(s_gMsgBundle.getMessage("1546", true));
                currentConfigResultSet.addErrorDescription(this.m_nodeList, errDesc);
                Trace.out((String)"The current selection of public/private network interfaces was not specified on commandline");
                VerificationLogData.logWarning("The current selection of public/private network interfaces was not specified on commandline");
            } else {
                currentConfigResultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(s_gMsgBundle.getMessage("1512", true)));
                currentConfigResultSet.addResult(this.m_nodeList, 3);
                Trace.out((String)"The current selection of public/private network interfaces was not available inside the retrieved network classification information");
                VerificationLogData.logError("The current selection of public/private network interfaces was not available inside the retrieved network classification information");
            }
        } else {
            currentConfigResultSet.addResult(this.m_nodeList, 1);
        }
    }

    private List<NetworkInfo> getPublicIfListForNode(String node) {
        ArrayList<NetworkInfo> ifList = new ArrayList<NetworkInfo>();
        if (!this.m_globalPublicInterfaceList.isEmpty()) {
            ifList.addAll(this.m_globalPublicInterfaceList);
        }
        if (!this.m_nodeSpecificPublicInterfaceList.isEmpty() && this.m_nodeSpecificPublicInterfaceList.containsKey(node)) {
            ifList.addAll((Collection<NetworkInfo>)this.m_nodeSpecificPublicInterfaceList.get(node));
        }
        return ifList;
    }

    private List<NetworkInfo> getPrivateIfListForNode(String node) {
        ArrayList<NetworkInfo> ifList = new ArrayList<NetworkInfo>();
        if (!this.m_globalPrivateInterfaceList.isEmpty()) {
            ifList.addAll(this.m_globalPrivateInterfaceList);
        }
        if (!this.m_nodeSpecificPrivateInterfaceList.isEmpty() && this.m_nodeSpecificPrivateInterfaceList.containsKey(node)) {
            ifList.addAll((Collection<NetworkInfo>)this.m_nodeSpecificPrivateInterfaceList.get(node));
        }
        return ifList;
    }

    private boolean checkInterfaceExistInIPMPGroups(Hashtable<String, List<NetworkInfo>> ipmpGroupInterfaceListPair, List<NetworkInfo> interfaceList) {
        boolean ret = false;
        Set<String> groups = ipmpGroupInterfaceListPair.keySet();
        for (String group : groups) {
            if (this.getCommonElements(ipmpGroupInterfaceListPair.get(group), interfaceList).size() <= 0) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private List<NetworkInfo> getCommonElements(List<NetworkInfo> list1, List<NetworkInfo> list2) {
        ArrayList<NetworkInfo> commonIpmpInterfaces = new ArrayList<NetworkInfo>();
        for (NetworkInfo ifinformation1 : list1) {
            for (NetworkInfo ifinformation2 : list2) {
                if (!ifinformation1.getInterfaceName().equals(ifinformation2.getInterfaceName()) || ifinformation1.getMacAddress().equals(ifinformation2.getMacAddress())) continue;
                commonIpmpInterfaces.add(ifinformation1);
            }
        }
        return commonIpmpInterfaces;
    }

    private boolean compareOSRelease(int requiredMajor, int requiredMinor) {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet osReleaseResSet = new ResultSet();
        Trace.out((String)"Getting OS release from the nodes");
        globalExec.getKernelVersion(this.m_nodeList, osReleaseResSet);
        Hashtable t = osReleaseResSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() != 1) continue;
            String currentVersion = (String)result.getResultInfoSet().firstElement();
            int currentMajor = 0;
            int currentMinor = 0;
            Trace.out((String)("Available OS Release on node " + node + "is (" + currentVersion + ")"));
            if (VerificationUtil.isStringGood(currentVersion)) {
                if ((currentVersion = currentVersion.trim()).contains(".")) {
                    String majorString = currentVersion.substring(0, currentVersion.indexOf("."));
                    Trace.out((String)("majorString=" + majorString));
                    currentMajor = Integer.parseInt(majorString);
                    String minorString = currentVersion.substring(majorString.length() + 1);
                    Trace.out((String)("minorString=" + minorString));
                    currentMinor = minorString.contains(".") ? Integer.parseInt(minorString.substring(0, minorString.indexOf("."))) : Integer.parseInt(minorString);
                } else {
                    currentMajor = Integer.parseInt(currentVersion);
                }
            }
            Trace.out((String)("The current Major number is " + currentMajor + "\nThe Current Minor number is " + currentMinor));
            if (currentMajor < requiredMajor || currentMinor < requiredMinor) continue;
            return true;
        }
        return false;
    }

    private static String inetAddressCollectionToString(Collection<InetAddress> collection) {
        String collectionStr = "";
        if (collection != null) {
            ArrayList<String> addressList = new ArrayList<String>();
            for (InetAddress address : collection) {
                addressList.add(address.getHostAddress());
            }
            collectionStr = VerificationUtil.strCollection2String(addressList);
        }
        return collectionStr;
    }

    private void generateFixups(ResultSet daemonResultSet) {
        FixupData mpathdFixupData = new FixupData(null);
        String[] failedNodes = daemonResultSet.getFailureNodes();
        Trace.out((String)"Generating fixup for running the in.mpathd daemon");
        VerificationLogData.logInfo("Generating fixup for running the in.mpathd daemon");
        if (failedNodes != null && failedNodes.length > 0) {
            for (String failedNode : failedNodes) {
                Result failedNodeResult = daemonResultSet.getResult(failedNode);
                if (failedNodeResult.getStatus() != 3) continue;
                mpathdFixupData.addParticipatingNode(failedNode);
            }
            this.setFixupData(mpathdFixupData);
        }
    }

    private void updateNodeSpecificInterfaceList(Set<NetworkInfo> clusterNetworks, NetworkConstants.NetworkType networkType) {
        Set<NetworkInfo> networks = NetworkDataDiscovery.getClusterNetworksByType(clusterNetworks, networkType);
        String networkTypeString = NetworkConstants.NetworkType.getStringValue(networkType.getValue());
        List<Object> globalInterfaceList = new ArrayList();
        Hashtable<Object, Object> nodeSpecificGlobalInterfaceList = new Hashtable();
        if (networkType == NetworkConstants.NetworkType.PUBLIC) {
            globalInterfaceList = this.m_globalPublicInterfaceList;
            nodeSpecificGlobalInterfaceList = this.m_nodeSpecificPublicInterfaceList;
        } else {
            globalInterfaceList = this.m_globalPrivateInterfaceList;
            nodeSpecificGlobalInterfaceList = this.m_nodeSpecificPrivateInterfaceList;
        }
        if (NetworkUtility.isNetworksSetGood(networks)) {
            for (NetworkInfo network : networks) {
                String ifName = network.getInterfaceName();
                Trace.out((String)("Adding ifname " + ifName + " to " + networkTypeString + " list"));
                if (network.isIfNameGlobalLogicalInterface()) {
                    globalInterfaceList.add(network);
                    Trace.out((String)("Added in global " + networkTypeString + " list"));
                    continue;
                }
                String scope = network.getInterfaceScope();
                if (!VerificationUtil.isStringGood(scope)) {
                    Trace.out((String)("The scope of an interface " + ifName + " is not known, Skipping this interface"));
                    continue;
                }
                if (nodeSpecificGlobalInterfaceList.containsKey(scope)) {
                    ((List)nodeSpecificGlobalInterfaceList.get(scope)).add(network);
                } else {
                    ArrayList<NetworkInfo> ifDataList = new ArrayList<NetworkInfo>();
                    ifDataList.add(network);
                    nodeSpecificGlobalInterfaceList.put(scope, ifDataList);
                }
                Trace.out((String)("Added in " + networkTypeString + " list of node " + scope));
            }
        }
        if (networkType == NetworkConstants.NetworkType.PUBLIC) {
            this.m_globalPublicInterfaceList = globalInterfaceList;
            this.m_nodeSpecificPublicInterfaceList = nodeSpecificGlobalInterfaceList;
        } else {
            this.m_globalPrivateInterfaceList = globalInterfaceList;
            this.m_nodeSpecificPrivateInterfaceList = nodeSpecificGlobalInterfaceList;
        }
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("1500", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("1501", false);
    }
}

