/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.engine.task.TaskCheckEnvVariable;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskCheckEnvVariable {
    private TaskCheckEnvVariable m_taskenv;
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");

    public sTaskCheckEnvVariable(TaskCheckEnvVariable taskenv) {
        this.m_taskenv = taskenv;
    }

    public boolean checkEnvVariable(Hashtable<String, Integer> maxVarLenOnNode, Vector<String> varSetNodes, Vector<String> varNotSetNodes, Vector<String> lenExceedNodes, ResultSet evResultSet) {
        String envVarValue = null;
        String errMsg = null;
        int envValueLen = 0;
        boolean envVarSet = false;
        ResultSet varResultSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        Trace.out((String)("sTaskCheckEnvVariable:: Performing Environment Variable verification for variable (" + this.m_taskenv.m_envVarName + ") on UNIX... "));
        globalExec.getSysParam(this.m_taskenv.m_nodeList, this.m_taskenv.m_envVarName, varResultSet);
        TaskAnonymousProxy anonymousTask = new TaskAnonymousProxy(this.m_taskenv.m_envVarName, this.m_taskenv.m_nodeList, this.m_taskenv, varResultSet);
        anonymousTask.perform();
        Hashtable hostsTable = new Hashtable();
        Hashtable ht = varResultSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            envVarSet = false;
            envVarValue = null;
            envValueLen = 0;
            Result result = (Result)ht.get(node);
            Trace.out((String)("sTaskCheckEnvVariable::Examine the values retrieved for Node : " + node));
            if (result.getStatus() == 1) {
                envVarValue = (String)result.getResultInfoSet().elementAt(0);
                if (envVarValue != null && envVarValue.length() > 0) {
                    envValueLen = envVarValue.trim().length();
                    envVarSet = true;
                } else {
                    envVarSet = false;
                    envValueLen = 0;
                }
                Trace.out((String)("sTaskCheckEnvVariable:: Read Variable " + this.m_taskenv.m_envVarName + " from node: " + node + " length (" + envValueLen + ") Value :" + envVarValue));
            } else if (result.getStatus() == 3) {
                Trace.out((String)("sTaskCheckEnvVariable:: Environment Variable " + this.m_taskenv.m_envVarName + " not found to be set on node: " + node));
                envVarSet = false;
                envValueLen = 0;
            } else {
                Trace.out((String)("sTaskCheckEnvVariable:: Could not read Environment variable " + this.m_taskenv.m_envVarName + " from node : " + node));
                errMsg = s_msgBundle.getMessage("3918", true, (Object[])new String[]{this.m_taskenv.m_envVarName, node});
                evResultSet.addErrorDescription(new ErrorDescription(errMsg));
                evResultSet.addResult(node, 2);
                maxVarLenOnNode.put(node, envValueLen);
                continue;
            }
            if (!envVarSet) {
                if (!this.m_taskenv.m_set) {
                    evResultSet.addResult(node, 1);
                } else {
                    evResultSet.addResult(node, 3);
                }
                varNotSetNodes.add(node);
                maxVarLenOnNode.put(node, envValueLen);
                continue;
            }
            maxVarLenOnNode.put(node, envValueLen);
            varSetNodes.add(node);
            if (!this.m_taskenv.m_set) {
                evResultSet.addResult(node, 3);
                continue;
            }
            if (this.m_taskenv.m_maxLength > 0 && envValueLen > this.m_taskenv.m_maxLength) {
                lenExceedNodes.add(node);
                evResultSet.addResult(node, 3);
                continue;
            }
            evResultSet.addResult(node, 1);
        }
        return evResultSet.allSuccess();
    }
}

