/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskAdminPrivileges;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.engine.task.TaskGroupExistence;
import oracle.ops.verification.framework.engine.task.TaskGroupMembership;
import oracle.ops.verification.framework.engine.task.TaskUserExistence;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.InvalidEnvironmentException;
import oracle.ops.verification.framework.util.InventoryFilePointerException;
import oracle.ops.verification.framework.util.VerificationUtil;

class sAdminPriv
implements VerificationConstants {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static final String USER_EXISTS = "Yes";
    private static final String USER_MISSING = "No";
    private static final String GROUP_EXISTS = "Yes";
    private static final String GROUP_MISSING = "No";
    private static final String IN_GROUP_PRIMARY = "Yes-Yes";
    private static final String IN_GROUP_SECONDARY = "Yes-No";
    private static final String NOT_IN_GROUP = "No";
    private static final String YES = ReportUtil.YES;
    private static final String NO = ReportUtil.NO;
    private static final String UNKNOWN = ReportUtil.UNKNOWN;
    private static final String NOT_APPLICABLE = ReportUtil.NOT_APPLICABLE;
    private static final String FAILED = ReportUtil.FAILED;
    private static final String PASSED = ReportUtil.PASSED;
    private static final String EXIST = ReportUtil.EXIST;
    private static final String NOTEXIST = ReportUtil.NOTEXIST;
    private static final String INVENTORY_GROUP_PROPERTY = "inst_group";
    private String[] m_nodeList;
    private String m_operation;
    private String m_osdba;
    private String m_asmDbaGrp;
    private String m_asmAdminGrp;
    private String m_oraInv;
    private String m_oracleHome;
    private TaskAdminPrivileges m_taskAdminPriv;
    private ResultSet m_superResultSet;
    private ResultSet m_admPrvResultSet;
    private boolean m_checkASM = false;

    protected sAdminPriv(String[] nodeList, String operation, ResultSet admPrvResultSet, TaskAdminPrivileges taskAdminPriv) {
        this.m_nodeList = nodeList;
        this.m_operation = operation;
        this.m_taskAdminPriv = taskAdminPriv;
        this.m_superResultSet = this.m_taskAdminPriv.getResultSet();
        this.m_admPrvResultSet = admPrvResultSet;
    }

    protected boolean checkAdminPriv() {
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4012", false));
        this.performAdminPrivChecks();
        if (this.m_admPrvResultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4300", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4301", false));
        return false;
    }

    void performAdminPrivChecks() {
        String userName = System.getProperty("user.name");
        ResultSet userResultSet = new ResultSet();
        ResultSet groupResultSet = new ResultSet();
        ResultSet userInGroupRS = new ResultSet();
        if (this.m_operation.equalsIgnoreCase("db_inst")) {
            this.m_osdba = this.m_taskAdminPriv.getOSDBA();
            if (this.m_osdba == null) {
                this.m_osdba = VerificationUtil.getDefaultDbaGroup();
            }
            this.checkUserExistence(this.m_nodeList, userName, userResultSet);
            this.m_admPrvResultSet.addResultSetData(userResultSet);
            if (!userResultSet.anySuccess()) {
                return;
            }
            this.m_oraInv = this.getOracleInventoryGroup();
            if (this.m_oraInv == null) {
                String errorMessage = s_msgBundle.getMessage("0049", false);
                ReportUtil.printError(errorMessage);
                this.m_superResultSet.addResult(this.m_nodeList, 2);
                this.m_superResultSet.addErrorDescription(new ErrorDescription(errorMessage));
                return;
            }
            Trace.out((String)("m_oraInv = " + this.m_oraInv));
            this.checkGroupExistence(this.m_nodeList, this.m_oraInv, groupResultSet);
            boolean totalFailOrainstGrp = !groupResultSet.anySuccess();
            this.m_admPrvResultSet.addResultSetData(groupResultSet);
            if (!totalFailOrainstGrp) {
                this.checkUserGroupRelation(this.m_nodeList, userName, this.m_oraInv, 1, userResultSet, groupResultSet, userInGroupRS);
            }
            this.m_admPrvResultSet.addResultSetData(userInGroupRS);
            if (!this.m_osdba.equalsIgnoreCase(this.m_oraInv)) {
                groupResultSet = new ResultSet();
                this.checkGroupExistence(this.m_nodeList, this.m_osdba, groupResultSet);
                this.m_admPrvResultSet.addResultSetData(groupResultSet);
                if (groupResultSet.anySuccess()) {
                    userInGroupRS = new ResultSet();
                    this.checkUserGroupRelation(this.m_nodeList, userName, this.m_osdba, 3, userResultSet, groupResultSet, userInGroupRS);
                    this.m_admPrvResultSet.addResultSetData(userInGroupRS);
                }
            }
            if (this.m_checkASM) {
                NativeSystem nativeSystem = new SystemFactory().CreateSystem();
                String crsHomeForASM = VerificationUtil.getCRSHome();
                String asmGroup = null;
                try {
                    asmGroup = nativeSystem.getASMAdminGroup(crsHomeForASM);
                }
                catch (NativeException e) {
                    Trace.out((String)("ERROR: Problem in getting ASMADMIN group from CRS Home: '" + crsHomeForASM + "'"));
                    Trace.out((Exception)((Object)e));
                    String errorMsg = s_gMsgBundle.getMessage("10488", true, (Object[])new String[]{crsHomeForASM});
                    errorMsg = errorMsg + LSEP + e.getMessage();
                    ReportUtil.printError(errorMsg);
                    this.m_superResultSet.addResult(this.m_nodeList, 2);
                    this.m_superResultSet.addErrorDescription(new ErrorDescription(errorMsg));
                    return;
                }
                if (asmGroup == null) {
                    String errorMsg = s_gMsgBundle.getMessage("10488", true, (Object[])new String[]{crsHomeForASM});
                    ReportUtil.printError(errorMsg);
                    this.m_superResultSet.addResult(this.m_nodeList, 2);
                    this.m_superResultSet.addErrorDescription(new ErrorDescription(errorMsg));
                    return;
                }
                try {
                    String currentGroup = VerificationUtil.getCurrentGroup();
                    if (VerificationUtil.isStringGood(currentGroup) && asmGroup.equals(currentGroup)) {
                        String errorMsg = s_gMsgBundle.getMessage("10489", true);
                        ReportUtil.printError(errorMsg);
                        this.m_superResultSet.addResult(this.m_nodeList, 3);
                        this.m_superResultSet.addErrorDescription(new ErrorDescription(errorMsg));
                        return;
                    }
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5153", false));
                    this.m_superResultSet.addResult(this.m_nodeList, 1);
                    return;
                }
                catch (InvalidEnvironmentException iee) {
                    String errorMsg = iee.getMessage();
                    VerificationUtil.traceAndLogWarning(errorMsg);
                    this.m_superResultSet.addResult(this.m_nodeList, 4);
                    ErrorDescription errDesc = new ErrorDescription(errorMsg);
                    this.m_superResultSet.addErrorDescription(this.m_nodeList, errDesc);
                    ReportUtil.printError(errorMsg);
                }
            }
        } else if (this.m_operation.equalsIgnoreCase("crs_inst") || this.m_operation.equalsIgnoreCase("ha_config")) {
            this.m_oraInv = this.m_taskAdminPriv.getOraInv();
            if (this.m_oraInv == null) {
                Result result = new Result(VerificationUtil.getLocalNode());
                this.m_oraInv = VerificationUtil.getDefaultOraInvGroup(result);
                if (this.m_oraInv == null) {
                    String errorMessage = s_gMsgBundle.getMessage("10467", true);
                    ReportUtil.processAlert(VerificationUtil.LSEP + ReportUtil.ERROR + VerificationUtil.LSEP + errorMessage);
                    this.m_superResultSet.addResult(this.m_nodeList, 2);
                    this.m_superResultSet.addErrorDescription(new ErrorDescription(errorMessage));
                    if (result.getErrors().size() > 0) {
                        this.m_superResultSet.addErrorDescription(result.getNode(), (ErrorDescription)((Object)result.getErrors()));
                    }
                    return;
                }
            }
            this.checkUserExistence(this.m_nodeList, userName, userResultSet);
            this.m_admPrvResultSet.addResultSetData(userResultSet);
            if (!userResultSet.anySuccess()) {
                return;
            }
            boolean totalOraInvGroupFailure = false;
            this.checkGroupExistence(this.m_nodeList, this.m_oraInv, groupResultSet);
            this.m_admPrvResultSet.addResultSetData(groupResultSet);
            if (!groupResultSet.anySuccess()) {
                totalOraInvGroupFailure = true;
            }
            if (!totalOraInvGroupFailure) {
                this.checkUserGroupRelation(this.m_nodeList, userName, this.m_oraInv, 1, userResultSet, groupResultSet, userInGroupRS);
                this.m_admPrvResultSet.addResultSetData(userInGroupRS);
            }
            if ((this.m_asmAdminGrp = this.m_taskAdminPriv.getASMADMINGRP()) == null) {
                this.m_asmAdminGrp = VerificationUtil.getDefaultAsmAdminGroup();
            }
            if ((this.m_asmDbaGrp = this.m_taskAdminPriv.getASMDBAGRP()) == null) {
                this.m_asmDbaGrp = VerificationUtil.getDefaultAsmDbaGroup();
            }
            if (!this.m_asmDbaGrp.equalsIgnoreCase(this.m_oraInv)) {
                groupResultSet = new ResultSet();
                this.checkGroupExistence(this.m_nodeList, this.m_asmDbaGrp, groupResultSet);
                this.m_admPrvResultSet.addResultSetData(groupResultSet);
                if (groupResultSet.anySuccess()) {
                    userInGroupRS = new ResultSet();
                    this.checkUserGroupRelation(this.m_nodeList, userName, this.m_asmDbaGrp, 3, userResultSet, groupResultSet, userInGroupRS);
                    this.m_admPrvResultSet.addResultSetData(userInGroupRS);
                }
            }
            if (!this.m_asmAdminGrp.equalsIgnoreCase(this.m_oraInv) && !this.m_asmAdminGrp.equalsIgnoreCase(this.m_asmDbaGrp)) {
                groupResultSet = new ResultSet();
                this.checkGroupExistence(this.m_nodeList, this.m_asmAdminGrp, groupResultSet);
                this.m_admPrvResultSet.addResultSetData(groupResultSet);
                if (groupResultSet.anySuccess()) {
                    userInGroupRS = new ResultSet();
                    this.checkUserGroupRelation(this.m_nodeList, userName, this.m_asmAdminGrp, 3, userResultSet, groupResultSet, userInGroupRS);
                    this.m_admPrvResultSet.addResultSetData(userInGroupRS);
                }
            }
        } else if (this.m_operation.equalsIgnoreCase("db_config")) {
            this.checkUserExistence(this.m_nodeList, userName, userResultSet);
            this.m_admPrvResultSet.addResultSetData(userResultSet);
            if (!userResultSet.anySuccess()) {
                return;
            }
            this.m_oracleHome = this.m_taskAdminPriv.getOracleHome();
            ResultSet ohomeExistRS = new ResultSet();
            VerificationUtil.validateOracleHome(this.m_nodeList, this.m_oracleHome, ohomeExistRS);
            TaskAnonymousProxy valOracleHome = new TaskAnonymousProxy(this.m_oracleHome, this.m_nodeList, this.m_taskAdminPriv, ohomeExistRS);
            valOracleHome.perform();
            this.m_admPrvResultSet.addResultSetData(ohomeExistRS);
            if (ohomeExistRS.anyFailure()) {
                return;
            }
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            try {
                this.m_osdba = nativeSystem.getOracleGroup(this.m_oracleHome);
            }
            catch (Exception e) {
                Trace.out((String)("ERROR: Problem in getting OSDBA group from Oracle Home: '" + this.m_oracleHome + "'"));
                Trace.out((Exception)e);
                String errorMsg = s_msgBundle.getMessage("4013", false, (Object[])new String[]{this.m_oracleHome});
                ReportUtil.printError(errorMsg);
                this.m_superResultSet.addResult(this.m_nodeList, 2);
                this.m_superResultSet.addErrorDescription(new ErrorDescription(errorMsg));
                return;
            }
            if (this.m_osdba == null) {
                String errorMsg = s_msgBundle.getMessage("4013", false, (Object[])new String[]{this.m_oracleHome});
                ReportUtil.printError(errorMsg);
                this.m_superResultSet.addResult(this.m_nodeList, 2);
                this.m_superResultSet.addErrorDescription(new ErrorDescription(errorMsg));
                return;
            }
            this.m_oraInv = this.getOracleInventoryGroup();
            if (this.m_oraInv == null) {
                String errorMsg = s_msgBundle.getMessage("0049", false);
                ReportUtil.printError(errorMsg);
                this.m_superResultSet.addResult(this.m_nodeList, 2);
                this.m_superResultSet.addErrorDescription(new ErrorDescription(errorMsg));
                return;
            }
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"m_osdba =%s, m_oraInv=%s", (Object[])new Object[]{this.m_osdba, this.m_oraInv});
            }
            this.checkGroupExistence(this.m_nodeList, this.m_oraInv, groupResultSet);
            boolean totalFailOrainstGrp = !groupResultSet.anySuccess();
            this.m_admPrvResultSet.addResultSetData(groupResultSet);
            if (!totalFailOrainstGrp) {
                this.checkUserGroupRelation(this.m_nodeList, userName, this.m_oraInv, 1, userResultSet, groupResultSet, userInGroupRS);
            }
            this.m_admPrvResultSet.addResultSetData(userInGroupRS);
            if (this.m_osdba.equalsIgnoreCase(this.m_oraInv)) {
                return;
            }
            groupResultSet = new ResultSet();
            this.checkGroupExistence(this.m_nodeList, this.m_osdba, groupResultSet);
            this.m_admPrvResultSet.addResultSetData(groupResultSet);
            if (!groupResultSet.anySuccess()) {
                return;
            }
            userInGroupRS = new ResultSet();
            this.checkUserGroupRelation(this.m_nodeList, userName, this.m_osdba, 3, userResultSet, groupResultSet, userInGroupRS);
            this.m_admPrvResultSet.addResultSetData(userInGroupRS);
        }
    }

    private void checkUserExistence(String[] nodeList, String userName, ResultSet userResultSet) {
        TaskUserExistence taskUsrExist = TaskUserExistence.generate(userName, nodeList);
        this.m_taskAdminPriv.addChildTask(taskUsrExist);
        taskUsrExist.perform();
        userResultSet.addResultSetData(taskUsrExist.getResultSet());
    }

    private void checkGroupExistence(String[] nodeList, String groupName, ResultSet groupResultSet) {
        TaskGroupExistence taskGrpExist = TaskGroupExistence.generate(groupName, nodeList);
        this.m_taskAdminPriv.addChildTask(taskGrpExist);
        taskGrpExist.perform();
        groupResultSet.addResultSetData(taskGrpExist.getResultSet());
    }

    private void checkUserInGroupExistence(String[] nodeList, String userName, String groupName, int groupType, ResultSet usrInGrpResultSet) {
        TaskGroupMembership taskGrpMembr = TaskGroupMembership.generate(userName, groupName, groupType == 1, nodeList);
        this.m_taskAdminPriv.addChildTask(taskGrpMembr);
        taskGrpMembr.perform();
        usrInGrpResultSet.addResultSetData(taskGrpMembr.getResultSet());
    }

    private void checkUserGroupRelation(String[] nodeList, String userName, String groupName, int groupType, ResultSet userResultSet, ResultSet groupResultSet, ResultSet usrInGrpResultSet) {
        Vector<String> usrGrpNodeVect = new Vector<String>();
        Hashtable ut = userResultSet.getResultTable();
        Enumeration ue = ut.keys();
        while (ue.hasMoreElements()) {
            String node = (String)ue.nextElement();
            if (userResultSet.getResult(node).getStatus() != 1 || groupResultSet.getResult(node).getStatus() != 1) continue;
            usrGrpNodeVect.add(node);
        }
        if (usrGrpNodeVect.size() == 0) {
            Trace.out((String)("Both User:'" + userName + "' & Group:'" + groupName + "' don't exist on any node "));
        } else {
            Trace.out((String)("Both User:'" + userName + "' & Group:'" + groupName + "' exist on: " + VerificationUtil.strVect2List(usrGrpNodeVect)));
            String[] usrGrpNodeArr = usrGrpNodeVect.toArray(new String[usrGrpNodeVect.size()]);
            this.checkUserInGroupExistence(usrGrpNodeArr, userName, groupName, groupType, usrInGrpResultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOracleInventoryGroup() {
        String invCfgFilePtr = null;
        try {
            invCfgFilePtr = VerificationUtil.getInventoryConfigFilePointer();
        }
        catch (InventoryFilePointerException ifpe) {
            Trace.out((Exception)ifpe);
            ReportUtil.printError(ifpe.getMessage());
            this.m_superResultSet.addResult(this.m_nodeList, 2);
            this.m_superResultSet.addErrorDescription(new ErrorDescription(ifpe.getMessage()));
            return null;
        }
        Trace.out((String)("Inventory Config File's name is:'" + invCfgFilePtr + "'"));
        File configFile = new File(invCfgFilePtr);
        if (!configFile.exists()) {
            Trace.out((String)("Inventory Config File '" + invCfgFilePtr + "' doesn't exist"));
            String errMsg = s_msgBundle.getMessage("4025", true, (Object[])new String[]{invCfgFilePtr});
            ReportUtil.printError(errMsg);
            this.m_superResultSet.addResult(this.m_nodeList, 2);
            this.m_superResultSet.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(configFile.getAbsolutePath());
            Properties props = new Properties();
            props.load(fis);
            Enumeration<?> e = props.propertyNames();
            String propName = null;
            String propValue = null;
            while (e.hasMoreElements()) {
                propName = (String)e.nextElement();
                propValue = props.getProperty(propName);
                if (!propName.trim().equalsIgnoreCase(INVENTORY_GROUP_PROPERTY)) continue;
                Trace.out((String)("Oracle Inventory Group is-->" + propValue));
                String string = propValue;
                return string;
            }
        }
        catch (IOException e) {
            Trace.out((Exception)e);
            ReportUtil.printError(s_msgBundle.getMessage("4026", false, (Object[])new String[]{invCfgFilePtr}));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    Trace.out((Exception)e);
                }
            }
        }
        ReportUtil.printError(s_msgBundle.getMessage("4027", false, (Object[])new String[]{INVENTORY_GROUP_PROPERTY, invCfgFilePtr}));
        return null;
    }
}

