/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.ops.mgmt.trace.Trace;

public class TimeServerNode {
    String m_node;
    String m_remoteServer;
    String m_remoteServerID;
    int m_stratum;
    String m_type;
    int m_when;
    int m_poll;
    int m_reach;
    float m_delay;
    float m_offset;
    float m_jitter;

    public TimeServerNode(String node) {
        this.m_node = node;
    }

    public boolean addDataToNode(String tsLine, boolean isChrony) {
        if (!isChrony) {
            return this.addDataToNode(tsLine);
        }
        String[] vals = tsLine.split("\\s+");
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("TimeServerNode:addDataToNode():Parsing line:" + tsLine));
        }
        if (vals.length < 8) {
            Trace.out((String)("skipping " + tsLine + " for not enough values"));
            return false;
        }
        this.m_remoteServerID = vals[1];
        int offsetBeginIndex = tsLine.indexOf(91);
        int offsetEndIndex = tsLine.indexOf(93);
        if (offsetBeginIndex == -1 || offsetEndIndex == -1) {
            Trace.out((String)("skipping line " + tsLine));
            return false;
        }
        if (offsetEndIndex < offsetBeginIndex) {
            Trace.out((String)("skipping line " + tsLine));
            return false;
        }
        if (offsetBeginIndex + 1 == offsetEndIndex) {
            Trace.out((String)("line is " + tsLine));
            this.m_offset = 0.0f;
            return true;
        }
        String fullOffsetStr = tsLine.substring(offsetBeginIndex + 1, offsetEndIndex);
        String strOffset = fullOffsetStr.trim();
        int length = strOffset.length();
        int multiplyingFactor = 1000;
        String units = strOffset.substring(length - 2);
        String offSet = strOffset.substring(0, length - 2);
        if ("ns".equalsIgnoreCase(units)) {
            multiplyingFactor = 0;
        } else if ("us".equalsIgnoreCase(units)) {
            multiplyingFactor = 0;
        } else if ("ms".equalsIgnoreCase(units)) {
            multiplyingFactor = 1;
        } else {
            offSet = fullOffsetStr.substring(0, length - 1);
        }
        this.m_offset = this.parseFloat(offSet) * (float)multiplyingFactor;
        return true;
    }

    public boolean addDataToNode(String tsLine) {
        if (tsLine.length() < 2) {
            return false;
        }
        String[] vals = tsLine.substring(1).split("\\s+");
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("TimeServerNode:addDataToNode():Parsing line:" + tsLine));
        }
        if (vals.length < 10) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"TimeServerNode:addDataToNode(): Not enough values");
            }
            return false;
        }
        this.m_remoteServer = vals[0];
        this.m_remoteServerID = vals[1];
        this.m_stratum = this.parseInt(vals[2]);
        this.m_type = vals[3];
        this.m_when = this.parseInt(vals[4]);
        this.m_poll = this.parseInt(vals[5]);
        this.m_reach = this.parseInt(vals[6]);
        this.m_delay = this.parseFloat(vals[7]);
        this.m_offset = this.parseFloat(vals[8]);
        this.m_jitter = this.parseFloat(vals[9]);
        return true;
    }

    private int parseInt(String strval) {
        int ret;
        block2: {
            ret = 0;
            try {
                ret = Integer.parseInt(strval);
            }
            catch (NumberFormatException e) {
                if (!Trace.isLevelEnabled((int)5)) break block2;
                Trace.out((String)("Exception during number conversion of string >" + strval + "<"));
            }
        }
        return ret;
    }

    private float parseFloat(String strval) {
        float ret;
        block2: {
            ret = 0.0f;
            try {
                ret = Float.parseFloat(strval);
            }
            catch (NumberFormatException e) {
                if (!Trace.isLevelEnabled((int)5)) break block2;
                Trace.out((String)("Exception during number conversion of string >" + strval + "<"));
            }
        }
        return ret;
    }

    public float getOffset() {
        return this.m_offset;
    }

    public String getRemoteServer() {
        return this.m_remoteServerID;
    }
}

