/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.cluster.common.NodeRole;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.util.CollectionGroup;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.NoSuchCRSHomeException;
import oracle.ops.mgmt.cluster.NoSuchExecutableException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.cluster.VoteDiskInfo;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.RunGenericCommand;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskSharedStorageAccess;
import oracle.ops.verification.framework.engine.task.sTaskFreeSpace;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.ASMDiskGroup;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.storage.VerifyStorage;
import oracle.ops.verification.framework.util.ASMDGRedundancy;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.ASMUtils;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.ClusterwareUtil;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class TaskVotingDisk
extends Task {
    private VoteDiskInfo[] m_voteDiskList = null;
    private boolean m_isPreReq = false;
    private boolean m_isRolling = false;
    private boolean m_isUpgrade = false;
    private boolean m_isAddNode = false;
    private boolean m_usingASM = false;
    private String m_vDiskGroup = null;
    private List<String> m_voteDiskPaths = null;
    private List<String> m_vdiASMPaths = new ArrayList<String>();
    private boolean m_couldNotFindCRSVersion = false;
    private String m_destinationVersion = null;
    private String m_crsReleaseVersion = null;
    private Version m_crsActiveVersion = null;
    private static final String VDISK_DG_TEMPLATE = "VOTINGFILE";

    public TaskVotingDisk(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        this.m_isPreReq = this.m_globalContext.isPreCRS();
        switch (this.m_globalContext.getVerificationType()) {
            case PREREQ_CRS_INST: 
            case BESTPRACTICE_PRE_CRS_INST: {
                if (this.m_globalContext.isRollingUpgrade()) {
                    this.m_isUpgrade = true;
                    this.m_isRolling = true;
                    this.m_crsActiveVersion = VerificationUtil.getCRSActiveVersionObj();
                    this.setDestinationVersion(this.m_globalContext.getRequestedRelease());
                } else {
                    try {
                        this.m_voteDiskPaths = ClusterwareUtil.getVoteDiskLocations();
                    }
                    catch (ClusterInfoException e) {
                        Trace.out((String)"Failed to retrieve the vote disk locations");
                        Trace.out((Exception)((Object)e));
                    }
                    this.m_isRolling = this.m_globalContext.isRolling();
                    this.m_isUpgrade = this.m_globalContext.isUpgrade();
                }
                if (!this.m_isUpgrade || this.m_crsActiveVersion == null || Version.isPre12101((Version)this.m_crsActiveVersion)) break;
                Trace.out((String)"Upgrade case from >= 12.1 source home. Setting severity to FATAL");
                this.setSeverity(SeverityType.FATAL);
                break;
            }
            case POSTREQ_CRS_INST: 
            case BESTPRACTICE_POSTREQ_CRS_INST: 
            case COMPONENT_VDISK_INTEGRITY: {
                this.m_crsActiveVersion = VerificationUtil.getCRSActiveVersionObj();
                break;
            }
            case PREREQ_NODE_ADD: {
                this.setPreReq(true);
                this.setAddNode();
                if (this.m_globalContext.isBigCluster()) {
                    this.setNodeList(VerificationUtil.filterHubNodeList(VerificationUtil.addLocalNodeToNodeList(this.m_nodeList)));
                } else {
                    this.setNodeList(VerificationUtil.addLocalNodeToNodeList(this.m_nodeList));
                }
                try {
                    Trace.out((String)"Getting Voting Disk locations from 'ClusterInfo'");
                    this.m_crsActiveVersion = VerificationUtil.getCRSActiveVersionObj();
                    ClusterInfo ci = new ClusterInfo(VerificationUtil.getCRSHome(), this.m_crsActiveVersion);
                    this.m_voteDiskList = ci.getVoteDiskLocations();
                }
                catch (ClusterInfoException e) {
                    Trace.out((String)"Failed to retrieve the vote disk locations");
                    Trace.out((Exception)((Object)e));
                }
                break;
            }
            default: {
                if (!this.m_isPreReq) {
                    Trace.out((String)"Not a prereq scenario, obtaining the CRS active version.");
                    this.m_crsActiveVersion = VerificationUtil.getCRSActiveVersionObj();
                    break;
                }
                Trace.out((String)"Its a pre CRS install scenario, Not attempting to obtaig the CRS active version.");
            }
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (VerificationType.PREREQ_CRS_INST.equals((Object)this.m_globalContext.getVerificationType()) && VerificationUtil.isBaselineCollectionMode()) {
            return false;
        }
        switch (this.m_globalContext.getVerificationType()) {
            case PREREQ_CRS_INST: 
            case BESTPRACTICE_PRE_CRS_INST: 
            case PREREQ_NODE_ADD: {
                return this.m_globalContext.isRollingUpgrade() || this.m_voteDiskPaths != null && this.m_voteDiskPaths.size() > 0;
            }
            case POSTREQ_CRS_INST: 
            case BESTPRACTICE_POSTREQ_CRS_INST: 
            case COMPONENT_VDISK_INTEGRITY: {
                return true;
            }
        }
        return false;
    }

    public TaskVotingDisk(String[] nodeList) {
        this(null, 1);
        this.m_nodeList = nodeList;
    }

    public TaskVotingDisk(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(null, 1);
        this.m_nodeList = nodeList;
    }

    public TaskVotingDisk(MultiTaskHandler multiTaskHandler) {
        this(multiTaskHandler, 1);
    }

    public TaskVotingDisk(MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(multiTaskHandler, actionOnCompletion);
    }

    public void setPreReq(boolean isPreReq) {
        this.m_isPreReq = isPreReq;
    }

    public void setDiskPaths(String[] vdPaths) {
        this.m_voteDiskPaths = new ArrayList<String>(Arrays.asList(vdPaths));
    }

    public void setDiskList(VoteDiskInfo[] vdList) {
        this.m_voteDiskList = vdList;
    }

    public void setisRolling(boolean isRolling) {
        this.m_isRolling = isRolling;
    }

    public void setisUpgrade(boolean isUpgrade) {
        this.m_isUpgrade = isUpgrade;
    }

    public boolean isM_couldNotFindCRSVersion() {
        return this.m_couldNotFindCRSVersion;
    }

    private ResultSet performSharedStorageAccessForVDiskLocsPre() {
        ResultSet sharedStorageAccessOfVdiskPathsResSet = new ResultSet(1);
        ArrayList<String> badVoteDiskPaths = new ArrayList<String>();
        if (this.m_voteDiskPaths != null && this.m_voteDiskPaths.size() > 0) {
            for (String path : this.m_voteDiskPaths) {
                if (this.m_crsReleaseVersion != null && VerificationUtil.isVersionPost(this.m_crsReleaseVersion, "12.1")) {
                    if (!(VerificationUtil.isASMPath(path) || path.startsWith("ORCL:") || path.startsWith("AFD:"))) {
                        String badVDiskMsg = s_gMsgBundle.getMessage("10541", true, (Object[])new String[]{path});
                        VerificationLogData.logError("NON-ASM path not supported after 12.1: " + badVDiskMsg);
                        ErrorDescription errDesc = new ErrorDescription(badVDiskMsg);
                        ReportUtil.printError(badVDiskMsg);
                        this.m_resultSet.addErrorDescription(errDesc);
                        this.m_resultSet.addResult(this.m_nodeList, 3);
                        Trace.out((String)("Removing path '" + path + "' from m_voteDiskPaths"));
                        badVoteDiskPaths.add(path);
                        continue;
                    }
                    Trace.out((String)("Path: '" + path + "' is managed by ASM"));
                    continue;
                }
                if (VerificationUtil.isPlatformWindows()) {
                    Vector<String> succNodes = new Vector<String>();
                    Vector<String> failNodes = new Vector<String>();
                    String drvPath = path.substring(0, path.indexOf(FSEP) + 1);
                    boolean pExist = VerificationUtil.pathExists(this.m_nodeList, drvPath, 0, succNodes, failNodes);
                    if (succNodes.size() == 0) continue;
                }
                TaskSharedStorageAccess taskSSAccessVdisk = new TaskSharedStorageAccess(this.m_nodeList);
                taskSSAccessVdisk.setStorageIDlist(new String[]{path});
                taskSSAccessVdisk.setCheckWritableFS(false);
                taskSSAccessVdisk.setVDiskLocationFlag(true);
                this.addChildTask(taskSSAccessVdisk);
                taskSSAccessVdisk.perform();
                sharedStorageAccessOfVdiskPathsResSet.uploadResultSet(taskSSAccessVdisk.getResultSet());
            }
            this.m_voteDiskPaths.removeAll(badVoteDiskPaths);
        }
        return sharedStorageAccessOfVdiskPathsResSet;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean performTask() {
        String[] validNodeList22;
        String[] allRIMNodes;
        String cause = null;
        ErrorDescription errDesc = null;
        StorageInfo stInfo = null;
        String[] validNodes = null;
        String notSharedMsg = null;
        ArrayList<Object> voteDskLocs = new ArrayList<Object>();
        ArrayList<String> voteDskLocsASM = new ArrayList<String>();
        ArrayList<String> voteDskLocsSTAMP = new ArrayList<String>();
        ArrayList<Object> voteDskLocs_orig = new ArrayList<Object>();
        Hashtable<String, List<String>> vdiGroups = new Hashtable<String, List<String>>();
        Vector<String> failNodeVect = new Vector<String>();
        Vector<String> succNodeVect = new Vector<String>();
        boolean isNTAddNodeOCFS = false;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        Trace.out((String)"ENTRY");
        this.m_resultSet.setStatus(1);
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5429", false));
        this.m_crsReleaseVersion = VerificationUtil.getCRSReleaseVersion(VerificationUtil.getCRSHome(), false);
        if (!VerificationUtil.isStringGood(this.m_crsReleaseVersion)) {
            this.m_crsReleaseVersion = this.m_destinationVersion;
        }
        boolean isBigCluster = this.m_nodeMgr.isBigCluster();
        if (this.m_isPreReq && !this.m_isUpgrade) {
            Trace.out((String)("Performing the shared storage accessibility checks for Vote disk locations " + VerificationUtil.strList2List(this.m_voteDiskPaths)));
            ResultSet vdsikPathSSAResSet = this.performSharedStorageAccessForVDiskLocsPre();
            vdsikPathSSAResSet.traceResultSet("<=== Shared storage accessibility check result for the Vote disk paths====>");
            this.m_resultSet.uploadResultSet(vdsikPathSSAResSet);
        }
        if (!this.m_isPreReq || this.m_isUpgrade) {
            VerificationUtil.isCRSInstalled(this.m_nodeList, succNodeVect, failNodeVect);
            if (succNodeVect.size() != 0) {
                validNodes = succNodeVect.toArray(new String[succNodeVect.size()]);
                if (failNodeVect.size() != 0) {
                    String failMsg = s_msgBundle.getMessage("4038", true) + VerificationUtil.strVect2List(failNodeVect);
                    errDesc = new ErrorDescription(failMsg);
                    ReportUtil.printWarning(failMsg);
                    this.m_resultSet.addErrorDescription(failNodeVect, errDesc);
                    this.m_resultSet.addResult(failNodeVect, 4);
                    ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                    ReportUtil.sureprintNodelist(validNodes);
                }
            }
            if (isBigCluster) {
                String[] validHubNodes = null;
                String[] validRIMNodes = null;
                String[] allHubNodes = null;
                allRIMNodes = null;
                if (!this.m_isAddNode) {
                    allHubNodes = CVUHelperUtil.getNodeNames(NodeRole.HUB);
                    allRIMNodes = CVUHelperUtil.getNodeNames(NodeRole.RIM);
                } else {
                    try {
                        allHubNodes = this.m_nodeMgr.getHubCapableNodes(this.m_nodeList);
                        Trace.out((String)("HubCapableNodes are: " + VerificationUtil.strArr2List(allHubNodes)));
                        if (allHubNodes == null || allHubNodes.length < 2) {
                            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5432", false));
                            return true;
                        }
                    }
                    catch (NodeManagerException e) {
                        Trace.out((String)("Node manger exception " + e.getMessage()));
                    }
                }
                if (allHubNodes == null || allHubNodes.length == 0) {
                    String failMsg = LSEP + s_gMsgBundle.getMessage("1051", true) + LSEP + s_msgBundle.getMessage("5447", true);
                    ReportUtil.printError(failMsg);
                    errDesc = new ErrorDescription(failMsg);
                    this.m_resultSet.addErrorDescription(errDesc);
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    Trace.out((String)"No valid HUB nodes found.");
                    return false;
                }
                validNodeList22 = new ArrayList();
                validNodeList22.addAll(Arrays.asList(validNodes));
                validNodeList22.retainAll(Arrays.asList(allHubNodes));
                validHubNodes = validNodeList22.toArray(new String[0]);
                validNodeList22.clear();
                validNodeList22.addAll(Arrays.asList(validNodes));
                validNodeList22.retainAll(Arrays.asList(allRIMNodes));
                validRIMNodes = validNodeList22.toArray(new String[0]);
                this.m_resultSet.addResult(validRIMNodes, 1);
                validNodes = validHubNodes;
            }
        } else {
            validNodes = this.m_nodeList;
        }
        if (validNodes == null) {
            notSharedMsg = LSEP + s_msgBundle.getMessage("4037", true) + LSEP + s_msgBundle.getMessage("5447", true);
            ReportUtil.printError(notSharedMsg);
            errDesc = new ErrorDescription(notSharedMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            Trace.out((String)"No valid nodes found.");
            return false;
        }
        errDesc = new ErrorDescription("5431", s_msgBundle);
        if (!this.m_isPreReq || this.m_isUpgrade) {
            Trace.out((String)"This is a post crs or pre upgrade scenario, checking CRS active version");
            if (this.m_crsActiveVersion == null) {
                cause = s_msgBundle.getMessage("5434", true);
                ReportUtil.printError(cause);
                ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5431", true));
                this.m_resultSet.addResult(this.m_nodeList, 2);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + cause);
                this.m_resultSet.addErrorDescription(errDesc);
                Trace.out((String)"No Active CRS version found.");
                this.m_couldNotFindCRSVersion = true;
                return false;
            }
            try {
                void var22_60;
                void var22_58;
                void var21_42;
                String crsHome = VerificationUtil.getCRSHome();
                if (crsHome == null) {
                    String errMsg = s_msgBundle.getMessage("5301", true);
                    ErrorDescription errorDesc = new ErrorDescription(errMsg);
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
                    ReportUtil.printError(errMsg);
                    return false;
                }
                Trace.out((String)("crshome obtained is :" + crsHome));
                boolean votingDiskListObtained = false;
                if (isBigCluster && this.m_nodeMgr.isActiveRimNode(m_localNode)) {
                    this.m_voteDiskList = VerificationUtil.getVoteDiskListFromNode(crsHome, this.m_nodeList[0]);
                    votingDiskListObtained = true;
                    Trace.out((String)("obtained vote disk list from node: '" + this.m_nodeList[0] + "'"));
                }
                if (!votingDiskListObtained) {
                    Trace.out((String)"Getting Voting Disk locations from 'ClusterInfo'");
                    ClusterInfo ci = new ClusterInfo(VerificationUtil.getCRSHome(), this.m_crsActiveVersion);
                    this.m_voteDiskList = ci.getVoteDiskLocations();
                }
                ArrayList<String> vDiskPathList = new ArrayList<String>();
                allRIMNodes = this.m_voteDiskList;
                int validNodeList22 = allRIMNodes.length;
                boolean bl = false;
                while (var21_42 < validNodeList22) {
                    String string = allRIMNodes[var21_42];
                    vDiskPathList.add(string.getPath());
                    if (string.isASMPath() == 1 && this.m_vDiskGroup == null) {
                        this.m_vDiskGroup = string.getGroup();
                    }
                    ++var21_42;
                }
                CollectionElement locationElement = new CollectionElement(s_gMsgBundle.getMessage("11608", false), VerificationUtil.strCollection2String(vDiskPathList), null, null, "", 1);
                validNodeList22 = this.m_nodeList;
                int n = validNodeList22.length;
                boolean bl2 = false;
                while (var22_58 < n) {
                    String string = validNodeList22[var22_58];
                    this.m_resultSet.addCollectionElement(string, locationElement);
                    ++var22_58;
                }
                validNodeList22 = this.m_voteDiskList;
                int n2 = validNodeList22.length;
                boolean bl3 = false;
                while (var22_60 < n2) {
                    String string = validNodeList22[var22_60];
                    if (string.isASMPath() == 1) {
                        if (string.getPath().contains("ORCL:") || string.getPath().contains("AFD:")) {
                            Trace.out((String)("Processing vote disk STAMP: " + string.getPath()));
                            voteDskLocsSTAMP.add(string.getPath());
                        } else {
                            Trace.out((String)("Voting Disk location on ASM: " + string.toString()));
                            this.m_usingASM = true;
                            List<String> vlPaths = null;
                            if (vdiGroups.containsKey(string.getGroup())) {
                                vlPaths = (List)vdiGroups.get(string.getGroup());
                                if (!vlPaths.contains(string.getPath())) {
                                    vlPaths.add(string.getPath());
                                }
                                if (!this.m_vdiASMPaths.contains(string.getPath())) {
                                    this.m_vdiASMPaths.add(string.getPath());
                                }
                                vdiGroups.remove(string.getGroup());
                                vdiGroups.put(string.getGroup(), vlPaths);
                            } else {
                                vlPaths = new ArrayList<String>();
                                vlPaths.add(string.getPath());
                                vdiGroups.put(string.getGroup(), vlPaths);
                                if (!this.m_vdiASMPaths.contains(string.getPath())) {
                                    this.m_vdiASMPaths.add(string.getPath());
                                }
                            }
                        }
                    } else {
                        String path = string.getPath();
                        Trace.out((String)("Processing vote disk loc: " + path));
                        if (!VerificationUtil.isASMPath(path)) {
                            if (this.m_crsReleaseVersion != null && VerificationUtil.isVersionPost(this.m_crsReleaseVersion, "12.1")) {
                                String string2 = s_gMsgBundle.getMessage("10541", true, (Object[])new String[]{path});
                                VerificationLogData.logError("NON-ASM path not supported after 12.1: " + string2);
                                errDesc = new ErrorDescription(string2);
                                ReportUtil.printError(string2);
                                this.m_resultSet.addErrorDescription(errDesc);
                                this.m_resultSet.addResult(this.m_nodeList, 3);
                            } else {
                                voteDskLocs.add(string.getPath());
                            }
                        }
                    }
                    ++var22_60;
                }
            }
            catch (NoSuchCRSHomeException nocrsh) {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + nocrsh.getMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                Trace.out((String)("NOSUCHCRSHOMEEXCEPTION: \n" + errDesc.getErrorMessage()));
                Trace.stackTrace();
                ReportUtil.printError(errDesc.getErrorMessage());
                return false;
            }
            catch (NoSuchExecutableException nsee) {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + nsee.getMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("NOSUCHEXECUTABLEEXCEPTION: \n" + errDesc.getErrorMessage()));
                    Trace.stackTrace();
                }
                ReportUtil.printError(errDesc.getErrorMessage());
                return false;
            }
            catch (ClusterInfoException cie) {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + cie.getMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("CLUSTERINFOEXCEPTION: \n" + errDesc.getErrorMessage()));
                    Trace.stackTrace();
                }
                ReportUtil.printError(errDesc.getErrorMessage());
                return false;
            }
            catch (VerificationException ve) {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + ve.getMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                Trace.out((String)("verificaiton failed :" + errDesc.getErrorMessage()));
                ReportUtil.printError(errDesc.getErrorMessage());
                return false;
            }
        } else if (this.m_voteDiskList != null) {
            Trace.out((String)("Processing m_voteDiskList of size: " + this.m_voteDiskList.length));
            for (VoteDiskInfo vdiLobj : this.m_voteDiskList) {
                if (vdiLobj.isASMPath() == 1) {
                    if (vdiLobj.getPath().contains("ORCL:") || vdiLobj.getPath().contains("AFD:")) {
                        Trace.out((String)("Processing vote disk STAMP: " + vdiLobj.getPath()));
                        voteDskLocsSTAMP.add(vdiLobj.getPath());
                        continue;
                    }
                    Trace.out((String)("Voting Disk location on ASM: " + vdiLobj.toString()));
                    this.m_usingASM = true;
                    List<String> vlPaths = null;
                    if (vdiGroups.containsKey(vdiLobj.getGroup())) {
                        vlPaths = (List)vdiGroups.get(vdiLobj.getGroup());
                        if (!vlPaths.contains(vdiLobj.getPath())) {
                            vlPaths.add(vdiLobj.getPath());
                        }
                        if (!this.m_vdiASMPaths.contains(vdiLobj.getPath())) {
                            this.m_vdiASMPaths.add(vdiLobj.getPath());
                        }
                        vdiGroups.remove(vdiLobj.getGroup());
                        vdiGroups.put(vdiLobj.getGroup(), vlPaths);
                        continue;
                    }
                    vlPaths = new ArrayList<String>();
                    vlPaths.add(vdiLobj.getPath());
                    vdiGroups.put(vdiLobj.getGroup(), vlPaths);
                    if (this.m_vdiASMPaths.contains(vdiLobj.getPath())) continue;
                    this.m_vdiASMPaths.add(vdiLobj.getPath());
                    continue;
                }
                String path = vdiLobj.getPath();
                Trace.out((String)("Processing vote disk loc: " + path));
                if (VerificationUtil.isASMPath(path)) continue;
                if (this.m_crsReleaseVersion != null && VerificationUtil.isVersionPost(this.m_crsReleaseVersion, "12.1")) {
                    String string = s_gMsgBundle.getMessage("10541", true, (Object[])new String[]{path});
                    VerificationLogData.logError("NON-ASM path not supported after 12.1: " + string);
                    errDesc = new ErrorDescription(string);
                    ReportUtil.printError(string);
                    this.m_resultSet.addErrorDescription(errDesc);
                    this.m_resultSet.addResult(this.m_nodeList, 3);
                    continue;
                }
                voteDskLocs.add(vdiLobj.getPath());
            }
        } else if (this.m_voteDiskPaths != null) {
            Trace.out((String)("Processing m_voteDiskPaths of size: " + this.m_voteDiskPaths.size()));
            for (String vdPath : this.m_voteDiskPaths) {
                if (VerificationUtil.isASMPath(vdPath)) {
                    Trace.out((String)("Processing Vote disk ASM path: '" + vdPath + "'"));
                    voteDskLocsASM.add(vdPath);
                    this.m_usingASM = true;
                    continue;
                }
                Trace.out((String)("Processing Vote disk path: '" + vdPath + "'"));
                voteDskLocs.add(vdPath);
            }
        } else {
            this.m_resultSet.addResult(this.m_nodeList, 1);
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5432", false));
            return true;
        }
        Vector<Object> uniqueLocs = new Vector<Object>();
        Object voteDILoc = null;
        Object shareLoc = null;
        List<StorageInfo> stInfoLst = null;
        Trace.out((String)("Voting Disk locations collected:\nvoteDskLocsSTAMP: <" + ((Object)voteDskLocsSTAMP).toString() + ">" + "\nvoteDskLocsASM: <" + ((Object)voteDskLocsASM).toString() + ">" + "\nvoteDskLocs: <" + ((Object)voteDskLocs).toString() + ">" + "\nm_vdiASMPaths: <" + this.m_vdiASMPaths.toString() + ">"));
        voteDskLocs_orig.addAll(voteDskLocs);
        if (validNodes != null && validNodes.length > 0 && voteDskLocsSTAMP != null && voteDskLocsSTAMP.size() > 0) {
            ArrayList<String> deviceList = new ArrayList<String>();
            deviceList.addAll(voteDskLocsSTAMP);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ResultSet resultSet = StorageUtil.processASMDiskStamps(this.m_nodeList, deviceList, arrayList, arrayList2);
            if (resultSet.anyFailure()) {
                this.m_resultSet.uploadResultSet(resultSet);
                List<VerificationError> errorList = this.m_resultSet.getErrors();
                String[] stringArray = this.m_resultSet.getFailureNodes();
                if (stringArray != null && stringArray.length > 0) {
                    for (String node : stringArray) {
                        Result result = this.m_resultSet.getResult(node);
                        if (result == null) continue;
                        errorList.addAll(result.getErrors());
                    }
                }
                String[] stringArray2 = errorList.iterator();
                while (stringArray2.hasNext()) {
                    VerificationError err = (VerificationError)stringArray2.next();
                    ReportUtil.printError(err.getErrorMessage());
                }
                Trace.out((String)"Failed to resolve one or more ASM stamps to device path");
                VerificationLogData.log("Failed to resolve one or more ASM stamps to device path");
                return false;
            }
            if (!arrayList.isEmpty()) {
                Trace.out((String)("The devices managed by ASM are (" + arrayList + ") and the complete device list is (" + deviceList + ")"));
                VerificationLogData.log("The devices managed by ASM are (" + arrayList + ") and the complete device list is (" + deviceList + ")");
                if (!arrayList2.isEmpty()) {
                    Trace.out((String)("The resolved device path list is (" + arrayList2 + ") and the complete device list is (" + deviceList + ")"));
                    VerificationLogData.log("The resolved device path list is (" + arrayList2 + ") and the complete device list is (" + deviceList + ")");
                }
                this.m_usingASM = true;
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("10522", false, (Object[])new String[]{VerificationUtil.strCollection2String(arrayList)}));
            }
            if (arrayList.size() == deviceList.size()) {
                Trace.out((String)("Device list (" + deviceList + ") are managed by ASM as (" + arrayList + ")"));
                voteDskLocsSTAMP.clear();
                VerificationLogData.log("Device list (" + deviceList + ") are managed by ASM as (" + arrayList + ")");
                this.m_resultSet.setStatus(1);
            }
            if (arrayList2.size() > 0) {
                voteDskLocsSTAMP.clear();
                for (String string : arrayList2) {
                    if (voteDskLocs.contains(string)) continue;
                    voteDskLocs.add(string);
                    voteDskLocs_orig.add(string);
                }
            }
        }
        Trace.out((String)("Voting Disk locations that need to be verified further:\nvoteDskLocs: <" + ((Object)voteDskLocs).toString() + ">"));
        for (int i = 0; i < voteDskLocs.size(); ++i) {
            void var21_49;
            void var22_66;
            void var23_79;
            String string = (String)voteDskLocs.get(i);
            try {
                stInfoLst = new TypeFinder().getStorageInstance(string, validNodes);
            }
            catch (StorageException storageException) {
                Trace.out((String)("StorageException attempting to get storage type for: " + string));
                if (uniqueLocs.contains(string)) continue;
                uniqueLocs.add(string);
                continue;
            }
            boolean bl = false;
            Object var23_78 = null;
            int stInfoType = 0;
            for (StorageInfo stInfoChk : stInfoLst) {
                stInfo = stInfoChk;
                if (stInfo.isPolicySet() || stInfo.isLockSet()) {
                    String msgID = stInfo.isPolicySet() ? "7037" : "7038";
                    String policyErrMsg = LSEP + s_msgBundle.getMessage(msgID, true, (Object[])new String[]{string}) + stInfo.getNode();
                    ReportUtil.printError(policyErrMsg);
                    errDesc = new ErrorDescription(policyErrMsg);
                    this.m_resultSet.addErrorDescription(errDesc);
                    this.m_resultSet.addResult(stInfo.getNode(), 3);
                }
                if (var23_79 == null) {
                    stInfoType = stInfoChk.getType();
                    if (stInfoType == 1) {
                        String string3 = stInfoChk.getOrigPath();
                        continue;
                    }
                    String string4 = stInfoChk.getPath();
                    continue;
                }
                if (stInfoType == 0) {
                    stInfoType = stInfoChk.getType();
                    continue;
                }
                if (VerificationUtil.isVersionPost(this.m_destinationVersion, "12.1") && 1 == stInfoChk.getType()) {
                    String msg = s_gMsgBundle.getMessage("6025", true, (Object[])new String[]{stInfoChk.getOrigPath()});
                    ErrorDescription errorDesc = new ErrorDescription(msg);
                    this.m_resultSet.addResult(this.m_nodeList, 3);
                    this.m_resultSet.addErrorDescription(errorDesc);
                    ReportUtil.printError(msg + LSEP);
                    boolean bl4 = true;
                    break;
                }
                if (var23_79.equals(stInfoChk.getType() == 1 ? stInfoChk.getOrigPath() : stInfoChk.getPath()) && stInfoType == stInfoChk.getType()) continue;
                notSharedMsg = LSEP + s_msgBundle.getMessage("5448", true, (Object[])new String[]{string});
                ReportUtil.printError(notSharedMsg);
                errDesc = new ErrorDescription(notSharedMsg);
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(validNodes, 3);
                boolean bl5 = true;
                Trace.out((String)("stInfoPath: " + (String)var23_79 + " stInfoChk path: " + (stInfoChk.getType() == 1 ? stInfoChk.getOrigPath() : stInfoChk.getPath()) + " stInfoType: " + stInfoType + " stInfoChk type: " + stInfoChk.getType()));
                break;
            }
            if (var22_66 != false) continue;
            if (VerificationUtil.isStringGood((String)var23_79) && string != var23_79 && !this.m_isUpgrade) {
                void var21_48 = var23_79;
                voteDskLocs.set(i, var21_48);
            }
            if (stInfo.getType() == 1) {
                if (uniqueLocs.contains(var21_49)) continue;
                uniqueLocs.add(var21_49);
                continue;
            }
            sTaskFreeSpace sTaskFreeSpace2 = new sTaskFreeSpace();
            Command[] cmdArray = new Command[1];
            ResultSet resultSet = new ResultSet(1);
            boolean bl6 = true;
            String cmd = sTaskFreeSpace2.getCommand((String)var21_49);
            cmdArray[0] = new RunGenericCommand(m_localNode, cmd);
            boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
            Hashtable t = resultSet.getResultTable();
            Enumeration e = t.keys();
            String fileSystem = "UNKNOWN";
            while (e.hasMoreElements()) {
                String string5 = (String)e.nextElement();
                Result result = (Result)t.get(string5);
                if (result.getStatus() == 2) {
                    fileSystem = "UNKNOWN";
                    continue;
                }
                String cmdOut = VerificationUtil.fetchVerificationValue((String)result.getResultInfoSet().firstElement());
                fileSystem = sTaskFreeSpace2.getData(cmdOut, 0);
            }
            if (!fileSystem.contentEquals("UNKNOWN") && !uniqueLocs.contains(fileSystem)) {
                uniqueLocs.add(fileSystem);
            } else {
                uniqueLocs.add(var21_49);
            }
            VerifyStorage verifyStorage = new VerifyStorage();
            int storageType = stInfo.getType();
            Trace.out((String)("_st_ = " + stInfo.getType()));
            switch (storageType) {
                case 2: 
                case 7: {
                    if (nativeSystem.isUnixSystem() || !this.m_isAddNode) break;
                    Trace.out((String)"type determined as ocfs on nt in add node");
                    bl6 = false;
                    isNTAddNodeOCFS = true;
                    break;
                }
                case 1: 
                case 8: 
                case 13: {
                    break;
                }
                default: {
                    bl6 = false;
                }
            }
            if (validNodes == null || !bl6 || this.m_vdiASMPaths.contains(var21_49)) continue;
            try {
                if (verifyStorage.isShared((String)var21_49, validNodes, OracleFileType.RAC_OCR_VDISK, this.m_crsActiveVersion.toString4())) continue;
                notSharedMsg = LSEP + s_msgBundle.getMessage("5448", false, (Object[])new String[]{var21_49});
                ReportUtil.printError(notSharedMsg);
                errDesc = new ErrorDescription(notSharedMsg);
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(validNodes, 3);
                Trace.out((String)("Vote Disk location not shared: " + (String)var21_49));
                continue;
            }
            catch (StorageException se) {
                Trace.out((String)("STORAGEEXCEPTION:(could not check voting disk sharedness\n" + se));
                if (null != se.getMessage()) {
                    Trace.out((String)("StorageException message: " + se.getMessage()));
                    notSharedMsg = LSEP + s_msgBundle.getMessage("7020", false, (Object[])new String[]{var21_49}) + " " + VerificationUtil.strArr2List(validNodes) + LSEP + se.getMessage();
                } else {
                    notSharedMsg = LSEP + s_msgBundle.getMessage("7020", false, (Object[])new String[]{var21_49}) + " " + VerificationUtil.strArr2List(validNodes);
                }
                ReportUtil.printError(notSharedMsg);
                errDesc = new ErrorDescription(notSharedMsg);
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(validNodes, 2);
                continue;
            }
            catch (MultiNodeException mne) {
                Trace.out((String)("MULTINODEEXCEPTION:(could not check voting disk sharedness\n" + mne));
                if (null != mne.getMessage()) {
                    Trace.out((String)("MultiNodeException message: " + mne.getMessage()));
                    notSharedMsg = LSEP + s_msgBundle.getMessage("7020", true, (Object[])new String[]{var21_49}) + " " + VerificationUtil.strArr2List(validNodes) + LSEP + mne.getMessage();
                } else {
                    notSharedMsg = LSEP + s_msgBundle.getMessage("7020", true, (Object[])new String[]{var21_49}) + " " + VerificationUtil.strArr2List(validNodes);
                }
                ReportUtil.printError(notSharedMsg);
                errDesc = new ErrorDescription(notSharedMsg);
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(validNodes, 2);
            }
        }
        if (!this.m_usingASM && (voteDskLocs.size() == 0 || voteDskLocs.size() == 2 || uniqueLocs.size() < voteDskLocs.size() && uniqueLocs.size() < 3)) {
            Trace.out((String)("\n ** Voting disk configuration does not meet oracle recommendations. **\n ** Number of voting disk(s) found: " + voteDskLocs.size() + " ** Number of uniqueLocs found: " + uniqueLocs.size()));
            Trace.out((String)"\n ** Voting disk location(s) checked: ");
            if (voteDskLocs.size() != 0) {
                for (String string : voteDskLocs) {
                    Trace.out((String)string);
                }
            }
            Trace.out((String)"\n ** Unique location(s) checked: ");
            if (uniqueLocs.size() != 0) {
                for (String string : uniqueLocs) {
                    Trace.out((String)string);
                }
            }
            String errMsg = null;
            errMsg = !Version.isPre112((Version)this.m_crsActiveVersion) ? s_msgBundle.getMessage("5430", true) : s_msgBundle.getMessage("5435", true);
            errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 4);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.printWarning(errMsg);
        }
        if (this.m_usingASM && VerificationUtil.isStringGood(this.m_vDiskGroup) && !CVUHelperUtil.isASMFar()) {
            int vfCount = this.m_voteDiskList.length;
            Result result = new Result(m_localNode);
            ResultSet resultSet = new ResultSet();
            ASMDGRedundancy aSMDGRedundancy = ASMUtils.getASMDiskGroupRedundancy(this.m_vDiskGroup, result);
            resultSet.addResult(m_localNode, result);
            VerificationUtil.traceAndLog("Voting files count : " + vfCount + ", Redundancy of ASM diskgroup used for voting files : " + (Object)((Object)aSMDGRedundancy));
            if (aSMDGRedundancy != null) {
                int expectedCount = aSMDGRedundancy.getIdealLowLimit();
                if (vfCount < expectedCount) {
                    resultSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("13383", true, (Object[])new String[]{this.m_vDiskGroup, aSMDGRedundancy.toString(), String.valueOf(expectedCount), String.valueOf(vfCount)})));
                    resultSet.setStatus(4);
                    this.m_resultSet.addResultSetData(resultSet);
                }
            } else {
                this.m_resultSet.addResultSetData(resultSet);
            }
        }
        for (String string : this.m_vdiASMPaths) {
            if (VerificationUtil.isASMPath(string) || voteDskLocs.contains(string)) continue;
            voteDskLocs.add(string);
            voteDskLocs_orig.add(string);
        }
        if (nativeSystem.isUnixSystem() && voteDskLocs.size() > 0) {
            Trace.out((String)("Checking owner, group and perms for Voting Disk locations:\nvoteDskLocs: <" + ((Object)voteDskLocs).toString() + ">"));
            int k = -1;
            for (String string : voteDskLocs) {
                boolean bl;
                ++k;
                boolean bl7 = false;
                Trace.out((String)("Checking voting disk location: " + string));
                if (this.m_vdiASMPaths.size() > 0 && this.m_vdiASMPaths.contains(string)) {
                    Trace.out((String)("Setting 'isASMPath' to true for: '" + string + "'"));
                    bl = true;
                }
                ResultSet fileInfoResultSet = new ResultSet(1);
                Hashtable<String, Hashtable<String, FileInfo>> hashtable = VerificationUtil.getFileAttributes(validNodes, string, fileInfoResultSet);
                if (!isNTAddNodeOCFS) {
                    this.m_resultSet.uploadResultSet(fileInfoResultSet);
                }
                if (hashtable == null || hashtable.isEmpty()) continue;
                String owner = null;
                String group = null;
                String perms = null;
                if (!this.m_isPreReq && !this.m_isUpgrade || this.m_isAddNode) {
                    Trace.out((String)"Getting owner from TaskUSMUdevChecks.getVDiskOwner()");
                    owner = TaskVotingDisk.getVDiskOwner();
                    if (bl) {
                        Trace.out((String)"Getting ASM group/perms");
                        try {
                            Trace.out((String)"  VerificationUtil.getASMAdminGroup() ");
                            group = VerificationUtil.getASMAdminGroup();
                        }
                        catch (CVUException ce) {
                            Trace.out((String)("CVUEXCEPTION: getting ASM admin group ::" + ce.getMessage()));
                        }
                        if (!VerificationUtil.isStringGood(group)) {
                            Trace.out((String)"  VDMUtil.getDefaultAsmAdminGroup() ");
                            group = VDMUtil.getDefaultAsmAdminGroup();
                        }
                        Trace.out((String)"  VDMUtil.getDefaultAsmDisksPermissions()");
                        perms = VDMUtil.getDefaultAsmDisksPermissions();
                    } else {
                        Trace.out((String)"Getting DEFAULT group/perms from: \n  VerificationUtil.getOraInventoryGroup() \n  VDMUtil.getDefaultVDiskPermissions()");
                        group = VerificationUtil.getOraInventoryGroup();
                        perms = VDMUtil.getDefaultVDiskPermissions();
                    }
                }
                Trace.out((String)("Checking vdLoc: '" + string + "' Owner: '" + owner + "' Group: '" + group + "' Perms: '" + perms + "' " + "on nodes: '" + VerificationUtil.strArr2List(validNodes) + "'"));
                ResultSet chkFileAttRes = new ResultSet(1);
                Hashtable<String, List<String>> hashtable2 = VerificationUtil.checkFileAttributes(validNodes, string, hashtable, owner, group, perms, chkFileAttRes);
                this.m_resultSet.addCollectionElements(chkFileAttRes.getCollectionElements());
                for (String node : validNodes) {
                    List<CollectionElement> list;
                    List<CollectionElement> list2 = list = chkFileAttRes.getResult(node) != null ? chkFileAttRes.getResult(node).getCollectionElements() : null;
                    if (list == null) continue;
                    for (CollectionElement ce : list) {
                        this.m_resultSet.addCollectionElement(node, ce);
                    }
                }
                Trace.out((String)("failedNodes.keySet().size() = [" + hashtable2.keySet().size() + "]"));
                if (!isNTAddNodeOCFS && hashtable2.keySet().size() != 0) {
                    String string6 = s_msgBundle.getMessage("5449", true, (Object[])new String[]{(String)voteDskLocs_orig.get(k) + (((String)voteDskLocs_orig.get(k)).contentEquals(string) ? "" : "(" + string + ")")});
                    ReportUtil.printError(string6);
                    ReportUtil.sureprintNodelist(hashtable2.keySet().toArray(new String[0]));
                    for (String node : hashtable2.keySet()) {
                        List<String> failedNodeErrors = hashtable2.get(node);
                        ReportUtil.sureprintln(LSEP + "\t" + node + ":" + VerificationUtil.strCollection2String(failedNodeErrors, ";"));
                        this.m_resultSet.addResult(node, 3);
                        this.m_resultSet.addErrorDescription(node, new ErrorDescription(string6));
                        for (String error : failedNodeErrors) {
                            this.m_resultSet.addErrorDescription(node, new ErrorDescription(error));
                        }
                    }
                    for (String string7 : chkFileAttRes.getSuccNodes()) {
                        this.m_resultSet.addResult(string7, chkFileAttRes.getResult(string7));
                    }
                    continue;
                }
                if (hashtable2.keySet().size() == 0) {
                    this.m_resultSet.uploadResultSet(chkFileAttRes);
                    continue;
                }
                Trace.out((String)"NT ocfs add node. upload successful nodes");
                for (String node : chkFileAttRes.getSuccNodes()) {
                    this.m_resultSet.addResult(node, chkFileAttRes.getResult(node));
                }
            }
        }
        Trace.out((String)("m_usingASM: " + this.m_usingASM + " m_isPreReq: " + this.m_isPreReq + " m_isUpgrade: " + this.m_isUpgrade + " m_isRolling: " + this.m_isRolling));
        if (this.m_usingASM && !this.m_isPreReq && !this.m_isUpgrade || this.m_usingASM && this.m_isUpgrade && this.m_isRolling) {
            void var22_71;
            String errMsg = new String("");
            ASMDiskGroupsUtil aSMDiskGroupsUtil = new ASMDiskGroupsUtil();
            ArrayList arrayList = new ArrayList();
            Object var23_86 = null;
            Trace.out((String)("vdiGroups.size() = [" + vdiGroups.size() + "]"));
            if (validNodes != null && validNodes.length > 0) {
                List<String> list = ClusterwareUtil.getCRSRunningNodes(validNodes, new ResultSet());
            }
            if (var22_71.size() > 0 && vdiGroups.size() != 0) {
                String[] stringArray = var22_71.toArray(new String[var22_71.size()]);
                ASMDiskGroupsUtil dgutil = new ASMDiskGroupsUtil();
                Hashtable<String, List<ASMDiskGroup>> hashtable = new Hashtable<String, List<ASMDiskGroup>>();
                try {
                    ResultSet getDiskGroupsRS = new ResultSet(1);
                    Trace.out((String)"Calling ASMDiskGroupsUtil::getDiskGroups()");
                    dgutil.getDiskGroups(stringArray, getDiskGroupsRS, hashtable);
                    for (String node : hashtable.keySet()) {
                        Trace.out((String)("Disk groups retrieved from node '" + node + "' are:"));
                        for (ASMDiskGroup aSMDiskGroup : hashtable.get(node)) {
                            Trace.out((String)aSMDiskGroup.toString());
                        }
                    }
                    if (!getDiskGroupsRS.allSuccess()) {
                        for (VerificationError vfe : getDiskGroupsRS.getErrors()) {
                            errMsg = errMsg + LSEP + vfe.getErrorMessage();
                        }
                        if (VerificationUtil.isStringGood(errMsg)) {
                            ReportUtil.printError(errMsg);
                        }
                    }
                    this.m_resultSet.uploadResultSet(getDiskGroupsRS);
                    for (Iterator<Object> iterator : stringArray) {
                        boolean bl = false;
                        List<ASMDiskGroup> dgl = hashtable.get(iterator);
                        if (dgl == null) {
                            Trace.out((String)("DiskGroup list is null for node '" + iterator + "'"));
                        } else {
                            Trace.out((String)("Number of DiskGroups found for node '" + iterator + "' =" + dgl.size()));
                        }
                        for (String vdGroup : vdiGroups.keySet()) {
                            Trace.out((String)("Verifying ASM disk group '" + vdGroup + "'"));
                            if (dgl != null && dgl.size() > 0) {
                                for (ASMDiskGroup dg1 : dgl) {
                                    Trace.out((String)("Comparing with existing DiskGroup '" + dg1.getName() + "'"));
                                    if (!dg1.getName().equalsIgnoreCase(vdGroup)) continue;
                                    bl = true;
                                    break;
                                }
                            }
                            if (bl) continue;
                            List list = (List)vdiGroups.get(vdGroup);
                            for (String vdPathLoc : list) {
                                errMsg = LSEP + s_msgBundle.getMessage("5157", true, (Object[])new String[]{vdGroup, vdPathLoc, iterator}) + LSEP;
                                ReportUtil.printError(errMsg);
                                this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                                this.m_resultSet.addResult((String)((Object)iterator), 3);
                            }
                        }
                    }
                }
                catch (ASMDiskGroupsUtilException e2) {
                    errMsg = LSEP + s_msgBundle.getMessage("5131", true) + LSEP + e2.getMessage();
                    ReportUtil.printError(errMsg);
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                    this.m_resultSet.addResult(stringArray, 2);
                }
            }
        }
        Trace.out((String)"EXIT");
        if (!this.m_resultSet.allSuccess()) {
            Trace.out((String)"m_resultSet has errors: ");
            this.m_resultSet.traceResultSet("Returning result set:");
        }
        if (this.m_resultSet.allSuccess()) {
            Trace.out((String)"VotingDisk PASSED.");
            this.m_resultSet.addResult(this.m_nodeList, 1);
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5432", false));
            return true;
        }
        Trace.out((String)"VotingDisk FAILED.");
        this.m_resultSet.addResult(this.m_nodeList, 3);
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5431", true));
        errDesc = new ErrorDescription("5431", s_msgBundle);
        this.m_resultSet.addErrorDescription(errDesc);
        return false;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("9502", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("9603", false);
    }

    public static String getVDiskOwner() {
        Result result = new Result(m_localNode);
        return VerificationUtil.getCRSUser(m_localNode, result, false);
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }

    public void setDestinationVersion(String destinationVersion) {
        this.m_destinationVersion = destinationVersion;
    }

    public void setAddNode() {
        this.m_isAddNode = true;
    }

    @Override
    public CollectionGroup getCollectionGroup() {
        return CollectionGroup.OCR_COLLECTION;
    }
}

