/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskUsersWithSameID
extends Task {
    private String m_uid;

    public TaskUsersWithSameID(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("ID".equals(argName)) {
                this.m_uid = argVal;
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return VerificationUtil.isStringGood(this.m_uid);
    }

    public TaskUsersWithSameID(String[] nodeList, String userID) {
        super(nodeList, null, 1);
        this.m_uid = userID;
    }

    @Override
    public boolean performTask() {
        String errMsg = null;
        ReportUtil.println(LSEP + s_msgBundle.getMessage("4131", false, (Object[])new String[]{this.m_uid}));
        GlobalExecution globalExec = new GlobalExecution();
        ErrorDescription errDesc = new ErrorDescription();
        ResultSet uidRsltSet = new ResultSet();
        globalExec.checkMultipleUID(this.m_nodeList, this.m_uid, uidRsltSet);
        Hashtable ht = uidRsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 3) {
                Vector resultInfo = result.getResultInfoSet();
                String users = "";
                users = (String)resultInfo.lastElement();
                errMsg = s_msgBundle.getMessage("4132", true, (Object[])new String[]{users, this.m_uid, node});
                result.addErrorDescription(new ErrorDescription(errMsg, s_msgBundle, "4132"));
                ReportUtil.sureprintln(errMsg);
            }
            this.m_resultSet.addResult(node, result);
        }
        this.m_resultSet.setStatus();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("4133", false, (Object[])new String[]{this.m_uid}));
            return true;
        }
        errMsg = s_msgBundle.getMessage("4134", false, (Object[])new String[]{this.m_uid});
        ReportUtil.printResult(errMsg);
        return false;
    }

    @Override
    public String getTaskID() {
        return "CHECK_USERS_WITH_SAME_ID";
    }

    @Override
    public String getTaskName() {
        return this.getTaskID() + "_" + this.m_uid;
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4138", false, (Object[])new String[]{this.m_uid});
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4137", false) + ": " + this.m_uid;
    }
}

