/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.ParamPreReqNodeAddDel;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.UserEquivCheckType;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.fixup.FixupData;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.RemoteShellException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskUserEquivalence
extends Task {
    private EnumSet<UserEquivCheckType> m_userEquivCheckTypeSet;
    static final String SRVM_PROPERTY_REMOTESHELL = "oracle.srvm.remoteshell";
    static final String SRVM_PROPERTY_REMOTECOPY = "oracle.srvm.remotecp";
    static final String ORACLE_SRVM_REMOTESHELL = "ORACLE_SRVM_REMOTESHELL";
    static final String ORACLE_SRVM_REMOTECOPY = "ORACLE_SRVM_REMOTECOPY";
    static final String DUMMY_NODE_NAME = "@NODE_HERE@";
    static final String STAR_EQUIVALENCE_CHECK = "IS_STAR_SSH_CHECK";
    static final String LOCAL_NODE_EQUIVALENCE_CHECK = "IS_LOCAL_NODE_EQUIVALENCE";
    private boolean m_setupUserEquivalence = false;
    private boolean m_isStarUserEquivalence = false;
    private boolean m_isLocalEquivalence = true;

    public TaskUserEquivalence(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        switch (this.m_globalContext.getVerificationType()) {
            case COMPONENT_ADMIN_PRIVILEGES: {
                ParamManager paramMgr = this.m_globalContext.getParamManager();
                String operation = paramMgr.getAdminPrivOperation();
                this.setCheckLocalEquivalence(true);
                if (operation.equalsIgnoreCase("user_equiv")) {
                    this.setCheckStarEquivalence(true);
                }
                this.m_setupUserEquivalence = this.isFixupReqd();
                break;
            }
            case PREREQ_NODE_ADD: 
            case PREREQ_RACNODE_ADD: 
            case POSTREQ_NODE_ADD: {
                ParamPreReqNodeAddDel paramNodeAddDel = (ParamPreReqNodeAddDel)this.m_globalContext.getParamPrereq();
                if (paramNodeAddDel == null) break;
                this.setNodeList(paramNodeAddDel.getValidNewClusterNodes());
                break;
            }
            default: {
                ExecutableInfo execInfo = this.m_ctx.getExecInfo();
                for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
                    String argName = arg.getArgName();
                    String argVal = arg.getArgVal(true);
                    boolean argBool = Boolean.parseBoolean(argVal);
                    if (STAR_EQUIVALENCE_CHECK.equals(argName)) {
                        this.setCheckStarEquivalence(argBool);
                        this.m_setupUserEquivalence = this.isFixupReqd();
                    }
                    if (!LOCAL_NODE_EQUIVALENCE_CHECK.equals(argName)) continue;
                    this.setCheckLocalEquivalence(argBool);
                    this.m_setupUserEquivalence = this.isFixupReqd();
                }
            }
        }
        if (!VerificationUtil.isPlatformWindows()) {
            this.setUserEquivCheckTypeSet(EnumSet.of(UserEquivCheckType.CV_EQUIV_SSH));
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return !VerificationType.PREREQ_CRS_INST.equals((Object)this.m_globalContext.getVerificationType()) || !VerificationUtil.isBaselineCollectionMode();
    }

    public TaskUserEquivalence(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskUserEquivalence(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskUserEquivalence(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setCheckStarEquivalence(boolean isStarUserEquivalance) {
        Trace.out((String)"enabling all cluster node equivalence check");
        this.m_isStarUserEquivalence = isStarUserEquivalance;
    }

    public void setCheckLocalEquivalence(boolean isCheckNodeEquivalence) {
        Trace.out((String)"enabling local node equivalence check");
        this.m_isLocalEquivalence = isCheckNodeEquivalence;
    }

    @Override
    public boolean performTask() {
        List<String> failureNodes;
        Trace.out((String)("performing user equivalence task with local node equivalence: " + this.m_isLocalEquivalence + " cluster wide equivalence: " + this.m_isStarUserEquivalence));
        if (this.m_globalContext.isUpgrade()) {
            Trace.out((String)"UPGRADE CASE: Marking Severity of this task to FATAL");
            this.setSeverity(SeverityType.FATAL);
        }
        if (!this.m_isLocalEquivalence && !this.m_isStarUserEquivalence) {
            Trace.out((String)"nothing to check and verify is being called");
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        Vector<String> succNodeVect = new Vector<String>();
        Vector<String> userEquivVector = new Vector<String>();
        Vector<String> failNodeVect = new Vector<String>();
        ResultSet userEquivResultSet = new ResultSet();
        boolean userEquivResult = false;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String userName = System.getProperty("user.name");
        String[] reachableNodeArr = this.m_nodeList;
        if (this.m_isLocalEquivalence) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4004", false));
        } else {
            ReportUtil.println(LSEP + s_gMsgBundle.getMessage("1700", false, (Object[])new String[]{userName}));
        }
        Trace.out((String)"Going to perform User Equivalence verification ...");
        ReportUtil.println(LSEP + s_msgBundle.getMessage("4005", false, (Object[])new String[]{userName}));
        String oldRemoteShellProperty = null;
        boolean propertyChanged = false;
        boolean xwinCheckRequested = false;
        if (this.m_userEquivCheckTypeSet != null) {
            boolean sshRequested = false;
            boolean rshRequested = false;
            for (UserEquivCheckType ctEnum : this.m_userEquivCheckTypeSet) {
                if (ctEnum == UserEquivCheckType.CV_EQUIV_RSH) {
                    rshRequested = true;
                }
                if (ctEnum == UserEquivCheckType.CV_EQUIV_SSH) {
                    sshRequested = true;
                }
                if (ctEnum != UserEquivCheckType.CV_EQUIV_XWIN) continue;
                xwinCheckRequested = true;
            }
            Trace.out((String)("user equivalence check type specified. rsh = " + rshRequested + " ssh = " + sshRequested + " xwin = " + xwinCheckRequested));
            if (sshRequested && !rshRequested) {
                String remoteSsh = this.getRemoteSsh(reachableNodeArr, this.m_resultSet);
                if (remoteSsh == null) {
                    return false;
                }
                propertyChanged = true;
                oldRemoteShellProperty = System.setProperty(SRVM_PROPERTY_REMOTESHELL, remoteSsh);
                propertyChanged = !remoteSsh.equals(oldRemoteShellProperty);
                Vector<String> remoteNodeVect = new Vector<String>();
                for (int i = 0; i < reachableNodeArr.length; ++i) {
                    if (VerificationUtil.isLocalNode(reachableNodeArr[i])) {
                        this.m_resultSet.addResult(reachableNodeArr[i], 1);
                        Trace.out((String)("Skipping " + reachableNodeArr[i] + " as local node"));
                        succNodeVect.add(reachableNodeArr[i]);
                        userEquivVector.add(reachableNodeArr[i]);
                        continue;
                    }
                    remoteNodeVect.add(reachableNodeArr[i]);
                }
                reachableNodeArr = remoteNodeVect.toArray(new String[0]);
            } else if (rshRequested && !sshRequested) {
                String remoteRsh = this.getRemoteRsh(reachableNodeArr, this.m_resultSet);
                if (remoteRsh == null) {
                    return false;
                }
                oldRemoteShellProperty = System.setProperty(SRVM_PROPERTY_REMOTESHELL, remoteRsh);
                boolean bl = propertyChanged = !remoteRsh.equals(oldRemoteShellProperty);
            }
        }
        if (propertyChanged) {
            Trace.out((String)"Remote shell property changed. Resetting shell to be used");
            nativeSys.resetRemoteShellCmd();
        }
        if (this.m_isLocalEquivalence) {
            Trace.out((String)"Performing user equivalence task on local node... ");
            if (reachableNodeArr != null && reachableNodeArr.length > 0) {
                String localnode = VerificationUtil.getLocalNode();
                int validRSAFilePerms = 1;
                String userHomeDir = System.getProperty("user.home");
                String sshPrvKeyFile = userHomeDir + FSEP + ".ssh" + FSEP + "id_rsa";
                if (!VerificationUtil.isPlatformWindows() && (reachableNodeArr.length == 1 && !reachableNodeArr[0].equals(localnode) || reachableNodeArr.length > 1) && new File(sshPrvKeyFile).exists()) {
                    String filePerms = null;
                    try {
                        Path path = Paths.get(sshPrvKeyFile, new String[0]);
                        PosixFileAttributes attrs = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]).readAttributes();
                        filePerms = PosixFilePermissions.toString(attrs.permissions());
                    }
                    catch (IOException ioe) {
                        Trace.out((String)("Failed to get the file attributes:" + ioe.getMessage()));
                        this.m_resultSet.addResult(localnode, 2);
                        String errMsg = s_msgBundle.getMessage("5323", true, (Object[])new String[]{sshPrvKeyFile}) + LSEP + ioe.getMessage();
                        this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                        return false;
                    }
                    if (VerificationUtil.isStringGood(filePerms) && filePerms.length() > 8) {
                        String errorMsg;
                        String fileGroupPerms = filePerms.substring(3, 6);
                        String fileOthersPerms = filePerms.substring(6, 9);
                        if (!fileGroupPerms.equals("---")) {
                            String expectedFileGroupPerms = new FileInfo.Permissions("000").toStringGroup();
                            this.m_resultSet.addResult(localnode, 3);
                            errorMsg = s_gMsgBundle.getMessage("13381", true, (Object[])new String[]{sshPrvKeyFile, localnode, expectedFileGroupPerms, fileGroupPerms});
                            this.m_resultSet.addErrorDescription(new ErrorDescription(errorMsg));
                            VerificationUtil.traceAndLogError("Incorrect group permissionsfound for ssh prviate key file (" + sshPrvKeyFile + ") on node (" + localnode + ") Expected (" + expectedFileGroupPerms + ") current (" + fileGroupPerms + ")");
                            validRSAFilePerms = 0;
                        }
                        if (!fileOthersPerms.equals("---")) {
                            String expectedFileOthersPerms = new FileInfo.Permissions("000").toStringOthers();
                            this.m_resultSet.addResult(localnode, 3);
                            errorMsg = s_gMsgBundle.getMessage("13382", true, (Object[])new String[]{sshPrvKeyFile, localnode, expectedFileOthersPerms, fileOthersPerms});
                            this.m_resultSet.addErrorDescription(new ErrorDescription(errorMsg));
                            VerificationUtil.traceAndLogError("Incorrect others permissions found for ssh prviate key file (" + sshPrvKeyFile + ") on node (" + localnode + ") Expected (" + expectedFileOthersPerms + ") current (" + fileOthersPerms + ")");
                            validRSAFilePerms = 0;
                        }
                    }
                }
                if (validRSAFilePerms == 0) {
                    return false;
                }
                userEquivResult = new GlobalExecution().checkUserEquiv(reachableNodeArr, true, xwinCheckRequested, userEquivResultSet);
                if (!this.m_isStarUserEquivalence && propertyChanged) {
                    this.restoreOldShellProperty(oldRemoteShellProperty, nativeSys);
                }
                this.m_resultSet.addResultSetData(userEquivResultSet);
                Trace.out((String)"User equivalence check finished");
                ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8018", false));
                Hashtable t = userEquivResultSet.getResultTable();
                Enumeration e = t.keys();
                while (e.hasMoreElements()) {
                    String node = (String)e.nextElement();
                    Result result = (Result)t.get(node);
                    if (result.getStatus() == 1) {
                        ReportUtil.writeRecord(node, ReportUtil.PASSED);
                        succNodeVect.add(node);
                        userEquivVector.add(node);
                        continue;
                    }
                    failNodeVect.add(node);
                    ReportUtil.writeRecord(node, ReportUtil.FAILED);
                    Trace.out((String)("User Equivalence couldn't be performed on node: " + node));
                }
            } else {
                userEquivResultSet.addResult(this.m_nodeList, 1);
            }
            if (userEquivResultSet.getStatus() == 1) {
                ReportUtil.printResult(s_msgBundle.getMessage("4006", false, (Object[])new String[]{userName}));
            } else {
                for (String node : userEquivResultSet.getFailureNodes()) {
                    Result result = userEquivResultSet.getResult(node);
                    String errInfo = result.getErrorInfoString();
                    String errMsg = s_gMsgBundle.getMessage("2019", true, (Object[])new String[]{userName, m_localNode, node});
                    if (VerificationUtil.isStringGood(errInfo)) {
                        errMsg = errMsg + LSEP + errInfo;
                    } else {
                        Trace.out((String)(node + ": NO INFORMATION AVAILABLE"));
                    }
                    ReportUtil.sureprintln(errMsg);
                    result.addErrorDescription(new ErrorDescription(errMsg));
                }
            }
            this.m_resultSet.addResultSetData(userEquivResultSet);
            if (succNodeVect.size() == 0) {
                ReportUtil.printError(s_msgBundle.getMessage("4008", true) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            if (failNodeVect.size() != 0) {
                ReportUtil.printWarning(s_msgBundle.getMessage("4009", false));
                ReportUtil.sureprintNodelist(failNodeVect);
                ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                ReportUtil.sureprintNodelist(succNodeVect);
            }
            reachableNodeArr = userEquivVector.toArray(new String[0]);
        } else {
            userEquivResult = true;
        }
        boolean ret = true;
        if (!this.m_isStarUserEquivalence) {
            ret = userEquivResult;
        } else if (reachableNodeArr.length <= 1) {
            Trace.out((String)"skipping star user equivalence because only one node is reachable");
            this.m_resultSet.addResult(reachableNodeArr, 1);
            ret = userEquivResult;
        } else {
            if (!this.checkSSHPrivateKeyFilePermissions(reachableNodeArr)) {
                return false;
            }
            ret = userEquivResult & this.performStarUserEquivalence(nativeSys, userName, reachableNodeArr, propertyChanged, oldRemoteShellProperty);
        }
        if (this.m_setupUserEquivalence && this.isFixupReqd() && (failureNodes = this.m_resultSet.getFailedNodes()) != null && !failureNodes.isEmpty()) {
            FixupData fixupDataObj = new FixupData(failureNodes);
            this.setFixupData(fixupDataObj);
        }
        return ret;
    }

    private boolean checkSSHPrivateKeyFilePermissions(String[] nodeList) {
        boolean retVal = true;
        ResultSet permRsltSet = new ResultSet();
        String userHomeDir = System.getProperty("user.home");
        String sshPrvKeyFile = userHomeDir + FSEP + ".ssh" + FSEP + "id_rsa";
        Hashtable<String, FileInfo> nodeFileAttrTable = VerificationUtil.getFileAttributes(sshPrvKeyFile, nodeList, permRsltSet);
        this.m_resultSet.addResultSetData(permRsltSet);
        if (!permRsltSet.allSuccess()) {
            VerificationUtil.traceAndLogError("Failed to get the file attributes on one or more nodes");
            retVal = false;
        }
        if (nodeFileAttrTable != null) {
            for (String node : nodeFileAttrTable.keySet()) {
                FileInfo fileInfo = nodeFileAttrTable.get(node);
                if (fileInfo.getStatus().equals("0")) {
                    String errorMsg;
                    FileInfo.Permissions nodeFilePerms = fileInfo.getFilePermissionsObj();
                    Trace.out((String)("SSH private key file (" + sshPrvKeyFile + ") has " + "permissions (" + nodeFilePerms.toString() + ") on node (" + node + ")"));
                    boolean incorrectPerms = false;
                    if (nodeFilePerms.isGroupReadable() || nodeFilePerms.isGroupWritable() || nodeFilePerms.isGroupExecutable()) {
                        incorrectPerms = true;
                        String fileGroupPerms = nodeFilePerms.toStringGroup();
                        String expectedFileGroupPerms = new FileInfo.Permissions("000").toStringGroup();
                        this.m_resultSet.addResult(node, 3);
                        errorMsg = s_gMsgBundle.getMessage("13381", true, (Object[])new String[]{sshPrvKeyFile, node, expectedFileGroupPerms, fileGroupPerms});
                        this.m_resultSet.addErrorDescription(new ErrorDescription(errorMsg));
                        VerificationUtil.traceAndLogError("Incorrect group permissions found for ssh prviate key file (" + sshPrvKeyFile + ") on" + " node (" + node + ") Expected (" + expectedFileGroupPerms + ") current (" + fileGroupPerms + ")");
                        retVal = false;
                    }
                    if (nodeFilePerms.isOthersReadable() || nodeFilePerms.isOthersWritable() || nodeFilePerms.isOthersExecutable()) {
                        incorrectPerms = true;
                        String fileOthersPerms = nodeFilePerms.toStringOthers();
                        String expectedFileOthersPerms = new FileInfo.Permissions("000").toStringOthers();
                        this.m_resultSet.addResult(node, 3);
                        errorMsg = s_gMsgBundle.getMessage("13382", true, (Object[])new String[]{sshPrvKeyFile, node, expectedFileOthersPerms, fileOthersPerms});
                        this.m_resultSet.addErrorDescription(new ErrorDescription(errorMsg));
                        VerificationUtil.traceAndLogError("Incorrect others permissions found for ssh prviate key file (" + sshPrvKeyFile + ") on" + " node (" + node + ") Expected (" + expectedFileOthersPerms + ") current (" + fileOthersPerms + ")");
                        retVal = false;
                    }
                    if (incorrectPerms) continue;
                    this.m_resultSet.addResult(node, 1);
                    continue;
                }
                this.m_resultSet.addResult(node, 1);
            }
        }
        return retVal;
    }

    private boolean performStarUserEquivalence(NativeSystem nativeSys, String userName, String[] reachableNodeArr, boolean isPropertyChanged, String oldRemoteShellProperty) {
        ResultSet userEquivResultSet = new ResultSet();
        ArrayList masterErrorList = new ArrayList();
        String baseSshCmd = null;
        try {
            baseSshCmd = nativeSys.getNodeAccessiblityCommand(DUMMY_NODE_NAME);
        }
        catch (RemoteShellException e) {
            Trace.out((String)("remote shell not initialized: " + e.getMessage()));
            String errMsg = s_gMsgBundle.getMessage("1703", true, (Object[])new String[]{userName}) + LSEP + e.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ReportUtil.sureprintln(errMsg);
            return false;
        }
        Trace.out((String)"performing user equivalence on remote nodes");
        String proxyName = s_gMsgBundle.getMessage("1704", false, (Object[])new String[]{userName});
        boolean userEquivResult = new GlobalExecution().checkRemoteUserEquiv(reachableNodeArr, baseSshCmd, userEquivResultSet);
        TaskAnonymousProxy tStarUserEquiv = new TaskAnonymousProxy(proxyName, reachableNodeArr, this, userEquivResultSet);
        tStarUserEquiv.perform();
        this.m_resultSet.uploadResultSet(userEquivResultSet);
        ReportUtil.writeColHeaders(s_gMsgBundle.getMessage("0405", false), s_gMsgBundle.getMessage("0406", false), s_msgBundle.getMessage("8018", false));
        for (int i = 0; i < reachableNodeArr.length; ++i) {
            String sourceNode = reachableNodeArr[i];
            if (VerificationUtil.isLocalNode(sourceNode)) {
                Trace.out((String)("skipping " + sourceNode + " as it is local node"));
                continue;
            }
            Result sourceResult = userEquivResultSet.getResult(sourceNode);
            int resultStatus = sourceResult.getStatus();
            ArrayList<ErrorDescription> errorList = new ArrayList<ErrorDescription>();
            ArrayList<String> failedNodeList = new ArrayList<String>();
            List<CollectionElement> nodeCollection = sourceResult.getCollectionElements();
            for (CollectionElement colElem : nodeCollection) {
                String destNode = colElem.getNode();
                ReportUtil.writeRecord(sourceNode, destNode, colElem.getStatusString());
                if (colElem.getStatus() == 1) continue;
                failedNodeList.add(destNode);
                errorList.addAll(colElem.getErrorDescriptionList());
            }
            if (resultStatus == 1 && failedNodeList.size() == 0) {
                Trace.out((String)("ssh to all nodes successful from node " + sourceNode));
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("1702", false, (Object[])new String[]{userName, sourceNode}));
                continue;
            }
            if (resultStatus == 3) {
                Trace.out((String)("ssh to some nodes failed node " + sourceNode));
            } else if (resultStatus == 2) {
                Trace.out((String)("all ssh check failed on node " + sourceNode));
            } else {
                Trace.out((String)("status and error mis-match on node " + sourceNode));
                this.m_resultSet.addResult(sourceNode, 3);
            }
            String errMsg = s_gMsgBundle.getMessage("1701", true, (Object[])new String[]{userName, sourceNode, VerificationUtil.strList2List(failedNodeList)});
            for (ErrorDescription errDesc : errorList) {
                errMsg = errMsg + LSEP + errDesc.getErrorMessage();
            }
            ReportUtil.printError(errMsg);
            this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
        }
        if (isPropertyChanged) {
            this.restoreOldShellProperty(oldRemoteShellProperty, nativeSys);
        }
        return userEquivResult;
    }

    private void restoreOldShellProperty(String oldRemoteShellProperty, NativeSystem nativeSys) {
        if (oldRemoteShellProperty != null) {
            System.setProperty(SRVM_PROPERTY_REMOTESHELL, oldRemoteShellProperty);
        } else {
            System.clearProperty(SRVM_PROPERTY_REMOTESHELL);
        }
        Trace.out((String)"Remote shell property changed. Restore shell");
        nativeSys.resetRemoteShellCmd();
    }

    @Override
    public String getTaskID() {
        return "CHECK_USER_EQUIVALENCE";
    }

    @Override
    public String getTaskName() {
        return this.getTaskID();
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4429", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4480", false);
    }

    private String getRemoteSsh(String[] nodeArr, ResultSet resultSet) {
        String val = VerificationUtil.getConfiguredValue(ORACLE_SRVM_REMOTESHELL, true);
        String remoteShell = null;
        if (val != null && val.trim().length() != 0) {
            Trace.out((String)("using user configured shell " + val));
            String fileName = this.verifyRemoteShellFile(nodeArr, resultSet, val);
            if (fileName == null) {
                Trace.out((String)"user configured shell file not found");
                return null;
            }
            if (fileName.equalsIgnoreCase("ssh")) {
                remoteShell = val;
            }
        }
        if (remoteShell == null) {
            remoteShell = this.verifyRemoteShellFile(nodeArr, resultSet, VDMUtil.getDefaultSsh());
            Trace.out((String)("remote shell file " + remoteShell));
        }
        return remoteShell;
    }

    private String getRemoteRsh(String[] nodeArr, ResultSet resultSet) {
        String val = VerificationUtil.getConfiguredValue(ORACLE_SRVM_REMOTESHELL, true);
        String remoteShell = null;
        if (val != null && val.trim().length() != 0) {
            Trace.out((String)("user configured remote shell " + val));
            String fileName = this.verifyRemoteShellFile(nodeArr, resultSet, val);
            if (fileName == null) {
                Trace.out((String)"remote shell file not found");
                return null;
            }
            if (fileName.equalsIgnoreCase("rsh")) {
                remoteShell = val;
            }
        }
        if (remoteShell == null) {
            remoteShell = this.verifyRemoteShellFile(nodeArr, resultSet, VDMUtil.getDefaultRsh());
            Trace.out((String)("default remote shell file " + remoteShell));
        }
        return remoteShell;
    }

    private String verifyRemoteShellFile(String[] nodeArr, ResultSet resultSet, String absoluteFileName) {
        File userFile = new File(absoluteFileName);
        Object[] fileArg = new String[]{absoluteFileName};
        String fileName = userFile.getName();
        if (!fileName.equals("ssh") && !fileName.equals("rsh")) {
            String errorMsg = MessageBundle.getMessageBundle((String)"Prkc").getMessage("1042", false, fileArg);
            ReportUtil.println(errorMsg);
            resultSet.addResult(nodeArr, 2);
            resultSet.addErrorDescription(nodeArr, new ErrorDescription(errorMsg));
            ReportUtil.processAlert(s_msgBundle.getMessage("0007", false));
            return null;
        }
        if (!userFile.isFile()) {
            String errorMsg = s_msgBundle.getMessage("0040", true, fileArg);
            ReportUtil.println(errorMsg);
            ErrorDescription errDesc = new ErrorDescription(errorMsg, s_msgBundle, "0040");
            resultSet.addResult(nodeArr, 2);
            resultSet.addErrorDescription(nodeArr, errDesc);
            ReportUtil.println(s_msgBundle.getMessage("0007", false));
            return null;
        }
        return absoluteFileName;
    }

    public EnumSet<UserEquivCheckType> getUserEquivCheckTypeSet() {
        return this.m_userEquivCheckTypeSet;
    }

    public void setUserEquivCheckTypeSet(EnumSet<UserEquivCheckType> equivCheckTypeSet) {
        this.m_userEquivCheckTypeSet = equivCheckTypeSet;
    }
}

