/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.List;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.RangeOfValue;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.helper.CVUHelperConstants;

public class TaskUpgradeSuitability
extends Task
implements CVUHelperConstants {
    private String m_home;
    private String m_destVersion;
    private List<RangeOfValue> m_srcHomeVersions;

    public TaskUpgradeSuitability(List<RangeOfValue> srcHomeVersions) {
        this(CVUVariables.getValue(CVUVariableConstants.oracle_install_crs_configuredCRSHome), srcHomeVersions, CVUVariables.getValue(CVUVariableConstants.DEST_VERSION) != null ? CVUVariables.getValue(CVUVariableConstants.DEST_VERSION) : "12.2.0.1.0");
    }

    public TaskUpgradeSuitability(String home, List<RangeOfValue> srcHomeVersions, String destVersion) {
        this.m_srcHomeVersions = srcHomeVersions;
        this.m_home = home;
        this.m_destVersion = destVersion;
        Trace.out((int)5, (String)"m_home=%s, m_destVersion=%s", (Object[])new Object[]{this.m_home, this.m_destVersion});
    }

    @Override
    public boolean performTask() {
        ReportUtil.blankln();
        ReportUtil.println(s_gMsgBundle.getMessage("1272", false, (Object[])new String[]{this.m_home, this.m_destVersion}));
        String requiredVersion = "";
        String node = this.m_nodeList[0];
        String homeVersion = null;
        homeVersion = VerificationUtil.isHAConfigured() ? VerificationUtil.getSIHAReleaseVersion(true) : VerificationUtil.getCRSReleaseVersion(this.m_home, node);
        VerificationLogData.log("Node=" + node + " homeVersion=" + homeVersion);
        if (homeVersion == null) {
            ErrorDescription errDesc = new ErrorDescription("5316", new String[]{node}, s_msgBundle);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            String msg = s_msgBundle.getMessage("5316", true, (Object[])new String[]{node});
            ReportUtil.printError(msg + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        boolean isSuitable = false;
        for (RangeOfValue srcHomeVersionRange : this.m_srcHomeVersions) {
            try {
                if (!srcHomeVersionRange.contains(homeVersion)) continue;
                isSuitable = true;
                this.m_resultSet.addResult(this.m_nodeList, 1);
                VerificationLogData.log("Found source home range " + srcHomeVersionRange + " that contains the homeVersion=" + homeVersion);
                break;
            }
            catch (InvalidRangeManipulationException e) {
                isSuitable = false;
            }
        }
        if (!isSuitable) {
            VerificationLogData.log("Did not find a source home range that contain the homeVersion=" + homeVersion);
            String[] versionTokens = homeVersion.split("\\.");
            String homeVersionMajorMinor = null;
            if (versionTokens.length > 1) {
                homeVersionMajorMinor = versionTokens[0] + "." + versionTokens[1];
            }
            for (RangeOfValue srcHomeVersionRange : this.m_srcHomeVersions) {
                if (srcHomeVersionRange.getMinValue().startsWith(homeVersionMajorMinor)) {
                    requiredVersion = srcHomeVersionRange.getMinValue();
                    break;
                }
                if (!VerificationUtil.isVersionPost(srcHomeVersionRange.getMinValue(), homeVersionMajorMinor)) continue;
                if (!VerificationUtil.isStringGood(requiredVersion)) {
                    requiredVersion = srcHomeVersionRange.getMinValue();
                    continue;
                }
                if (!VerificationUtil.isVersionPre(srcHomeVersionRange.getMinValue(), requiredVersion)) continue;
                requiredVersion = srcHomeVersionRange.getMinValue();
            }
            VerificationLogData.log("requiredVersion determined to be " + requiredVersion);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            String msg = s_gMsgBundle.getMessage("1274", true, (Object[])new String[]{this.m_home, this.m_destVersion});
            if (VerificationUtil.isStringGood(requiredVersion)) {
                msg = msg + " " + s_gMsgBundle.getMessage("1276", false, (Object[])new String[]{requiredVersion, this.m_destVersion});
            }
            this.m_resultSet.addErrorDescription(new ErrorDescription(msg));
        }
        if (this.m_resultSet.allSuccess()) {
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("1275", false, (Object[])new String[]{this.m_home, this.m_destVersion}));
            ReportUtil.printResult(s_gMsgBundle.getMessage("1273", false, (Object[])new String[]{this.m_home, this.m_destVersion}));
            return true;
        }
        String requiredVersionMsg = "";
        if (VerificationUtil.isStringGood(requiredVersion)) {
            requiredVersionMsg = requiredVersionMsg + " " + s_gMsgBundle.getMessage("1276", false, (Object[])new String[]{requiredVersion, this.m_destVersion});
        }
        this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("1277", false, (Object[])new String[]{this.m_home, this.m_destVersion}) + requiredVersionMsg);
        ReportUtil.printResult(s_gMsgBundle.getMessage("1274", false, (Object[])new String[]{this.m_home, this.m_destVersion}) + requiredVersionMsg);
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("1271", false, (Object[])new String[]{this.m_home, this.m_destVersion});
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("1270", false);
    }
}

