/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskUpgCheckASMDiscoveryString;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskUpgCheckASMDiscoveryString
extends Task {
    private sTaskUpgCheckASMDiscoveryString s_sTaskUpgCheckASMDiscoveryString;

    public TaskUpgCheckASMDiscoveryString(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        this.s_sTaskUpgCheckASMDiscoveryString = new sTaskUpgCheckASMDiscoveryString(this.m_nodeList);
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("IS_SIHA".equals(argName) && VerificationUtil.isStringGood(argVal)) {
                if (!"true".equalsIgnoreCase(argVal)) continue;
                this.s_sTaskUpgCheckASMDiscoveryString.setSIHAMode();
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return !VerificationUtil.isASMLibConfigured(this.m_nodeList) && !VerificationUtil.isODASystem() && !VerificationUtil.isExadataSystem();
    }

    public TaskUpgCheckASMDiscoveryString(String[] nodeList) {
        super(nodeList);
        this.setSeverity(SeverityType.IGNORABLE);
        this.s_sTaskUpgCheckASMDiscoveryString = new sTaskUpgCheckASMDiscoveryString(nodeList);
    }

    @Override
    public boolean performTask() {
        this.s_sTaskUpgCheckASMDiscoveryString.performTask();
        this.m_resultSet.uploadResultSet(this.s_sTaskUpgCheckASMDiscoveryString.m_resultSet);
        return this.m_resultSet.allSuccess();
    }

    public void setSIHAMode() {
        this.s_sTaskUpgCheckASMDiscoveryString.setSIHAMode();
    }

    @Override
    public String getDefaultElementName() {
        return this.s_sTaskUpgCheckASMDiscoveryString.getDefaultElementName();
    }

    @Override
    public String getDefaultDescription() {
        return this.s_sTaskUpgCheckASMDiscoveryString.getDefaultDescription();
    }
}

