/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.VoteDiskInfo;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.RunGenericCommand;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskFreeSpace;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.storage.USMDevInfo;
import oracle.ops.verification.framework.storage.USMDevInfoException;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

public class TaskUSMUdevChecks
extends Task {
    private String m_owner = null;
    private String m_group = null;
    private String m_perms = null;
    private StorageEntity m_stEntity = StorageEntity.USM;
    private String[] m_UdevCheckPaths = new String[0];
    private String[] m_UdevCheckFileSystems = new String[0];
    private List<String> m_UnsupportedUDEVKeywords = new ArrayList<String>(Arrays.asList("ID_SERIAL_RAW", "ID_SERIAL", "ID_SERIAL_SHORT", "ID_WWN", "ID_WWN_VENDOR_EXTENSION", "ID_WWN_WITH_EXTENSION", "ID_SCSI_SERIAL", "PROGRAM"));
    private static final int UDEV_CHUNK_SIZE = 10;
    private HashMap<String, StorageInfo> fileSystemtoStInfo = new HashMap();
    private HashMap<String, String> diskPathtoFileSystem = new HashMap();
    private List<String> validatedUdevPath = new ArrayList<String>();
    List<String> udevPathsList = new ArrayList<String>();
    private String m_stEntityString = s_msgBundle.getMessage("9803", false);
    private boolean m_hdrPrinted = false;
    private static final String TAG_USMDEV = "USMDEV";
    private static final String STRING_CSS_USER = "CSS_USER";
    private String m_asmDiskOwner = null;
    private String m_asmDiskGroup = null;
    private String m_asmDiskPermissions = null;

    public TaskUSMUdevChecks(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("ENTITY".equals(argName)) {
                this.m_stEntity = StorageEntity.valueOf(argVal);
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
        switch (this.m_stEntity) {
            case OCR: {
                this.setOCRUDevCheck();
                break;
            }
            case USM: {
                this.setUSMUDevCheck();
                break;
            }
            case VDISK: {
                this.setVDiskUDevCheck();
                break;
            }
            case ASM: {
                this.setASMDiskUDevCheck();
            }
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (VerificationUtil.isUDEVSupported()) {
            if (this.m_stEntity == StorageEntity.VDISK && this.m_globalContext.isUpgrade() && !this.m_globalContext.isRolling()) {
                Trace.out((String)"Udev check being skipped for voting locations. This is an upgrade scenario with not rolling.");
                return false;
            }
            return true;
        }
        return false;
    }

    public TaskUSMUdevChecks(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskUSMUdevChecks(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskUSMUdevChecks(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing udev checks for USM ");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5191", false, (Object[])new String[]{this.m_stEntityString}));
        this.performUdevChecks();
        if (this.m_resultSet.allSuccess()) {
            Trace.out((String)"ResultSet shows alll Success");
            ReportUtil.printResult(s_msgBundle.getMessage("5178", false, (Object[])new String[]{this.m_stEntityString}));
            ReportUtil.sureblankln();
            return true;
        }
        Trace.out((String)"ResultSet shows at least one failure");
        ReportUtil.printResult(s_msgBundle.getMessage("5179", false, (Object[])new String[]{this.m_stEntityString}));
        ReportUtil.sureblankln();
        return false;
    }

    private void performUdevChecks() {
        String cmdOut;
        Result result;
        String node;
        Enumeration e;
        Hashtable t;
        Command[] cmdArray;
        Trace.out((int)2, (String)"Entry");
        if (!this.getStorageAttributes()) {
            Trace.out((String)"Failed to get storage attributes. Cannot proceed with Udev attributes checks.");
            ReportUtil.printError(s_msgBundle.getMessage("9806", true));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        ClusterInfo ci = null;
        VoteDiskInfo[] vdiskArr = null;
        String[] ocrLocations = null;
        ArrayList<String> pathList = new ArrayList<String>();
        ArrayList<String> fileSystemList = new ArrayList<String>();
        StorageInfo stInfo = null;
        String voteLoc = null;
        String ocrLoc = null;
        String fileSystem = null;
        String savFileSystem = null;
        int i = 0;
        if (this.isOCRUDevCheck()) {
            Trace.out((String)"Doing OCRUdevCheck");
            ResultSet resultSet = new ResultSet();
            ocrLocations = VerificationUtil.getOCRLocations(VerificationUtil.getCRSActiveVersionObj(), resultSet);
            for (i = 0; i < ocrLocations.length; ++i) {
                ocrLoc = ocrLocations[i];
                Trace.out((String)("OCR location Path " + i + " = " + ocrLoc));
                if (ocrLoc == null || VerificationUtil.isASMPath(ocrLoc)) continue;
                try {
                    stInfo = new TypeFinder().getStorageInstance(ocrLoc);
                }
                catch (StorageException e2) {
                    Trace.out((String)("StorageException attempting to get storage type for: " + ocrLoc));
                    continue;
                }
                fileSystem = ocrLoc;
                while (stInfo.getType() == 5) {
                    sTaskFreeSpace sTask = new sTaskFreeSpace();
                    cmdArray = new Command[1];
                    ResultSet freeSpcRsltSet = new ResultSet();
                    String cmd = sTask.getCommand(ocrLoc);
                    cmdArray[0] = new RunGenericCommand(m_localNode, cmd);
                    boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, freeSpcRsltSet);
                    t = freeSpcRsltSet.getResultTable();
                    e = t.keys();
                    fileSystem = "UNKNOWN";
                    while (e.hasMoreElements()) {
                        node = (String)e.nextElement();
                        result = (Result)t.get(node);
                        if (result.getStatus() != 1) continue;
                        cmdOut = VerificationUtil.fetchVerificationValue((String)result.getResultInfoSet().firstElement());
                        fileSystem = sTask.getData(cmdOut, 0);
                        Trace.out((String)("Parsing ocrLoc: " + ocrLoc + " to: " + fileSystem));
                    }
                    if (savFileSystem == null) {
                        savFileSystem = fileSystem;
                    } else {
                        if (fileSystem.contentEquals(savFileSystem)) break;
                        savFileSystem = fileSystem;
                    }
                    try {
                        stInfo = new TypeFinder().getStorageInstance(fileSystem);
                    }
                    catch (StorageException se) {
                        Trace.out((String)("StorageException getting storage type for: " + fileSystem));
                        break;
                    }
                }
                if (stInfo.getType() != 1) continue;
                pathList.add(ocrLoc);
                fileSystemList.add(fileSystem);
                this.diskPathtoFileSystem.put(stInfo.getPath(), ocrLoc);
                Trace.out((String)("diskPathtoFileSystem:\n hashmap<string:devPath,string:userPath>:'" + this.diskPathtoFileSystem + "'"));
                this.fileSystemtoStInfo.put(fileSystem, stInfo);
                if (fileSystem.contentEquals(ocrLoc)) continue;
                if (this.fileSystemtoStInfo.containsKey(ocrLoc)) {
                    StorageInfo storedStInfo = this.fileSystemtoStInfo.get(ocrLoc);
                    Trace.out((String)("Processing two storage info objects referring to the same location: \nStInfo(1): '" + stInfo.toString() + "'\nStInfo(2): '" + storedStInfo.toString() + "'"));
                    continue;
                }
                this.fileSystemtoStInfo.put(ocrLoc, stInfo);
            }
        } else if (this.isVDiskUDevCheck()) {
            Trace.out((String)"Doing VDiskUdevCheck");
            String crsHome = VerificationUtil.getCRSHome();
            if (crsHome == null) {
                String errMsg = s_msgBundle.getMessage("5301", true);
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
                ReportUtil.printError(errMsg);
                return;
            }
            Trace.out((String)("crshome obtained is :" + crsHome));
            try {
                boolean votingDiskListObtained = false;
                boolean isBigCluster = this.m_nodeMgr.isBigCluster();
                if (isBigCluster && this.m_nodeMgr.isActiveRimNode(m_localNode)) {
                    vdiskArr = VerificationUtil.getVoteDiskListFromNode(crsHome, this.m_nodeList[0]);
                    votingDiskListObtained = true;
                    Trace.out((String)"obtained vote disk list from hub");
                }
                if (!votingDiskListObtained) {
                    ci = new ClusterInfo(VerificationUtil.getCRSHome());
                    vdiskArr = ci.getVoteDiskLocations(VerificationUtil.getCRSActiveVersionObj());
                }
            }
            catch (ClusterInfoException cie) {
                Trace.out((String)"ClusterInfoException trying to get voting disk locations");
                ReportUtil.printError(s_msgBundle.getMessage("5197", true) + cie.getMessage());
                this.m_resultSet.addResult(this.m_nodeList, 2);
                return;
            }
            catch (VerificationException ve) {
                this.m_resultSet.addResult(m_localNode, 2);
                ErrorDescription errDesc = new ErrorDescription(ve.getMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                Trace.out((String)("verificaiton failed :" + errDesc.getErrorMessage()));
                ReportUtil.printError(errDesc.getErrorMessage());
                return;
            }
            Trace.out((String)("No of Voting disks found = " + vdiskArr.length));
            for (i = 0; i < vdiskArr.length; ++i) {
                Trace.out((String)("Voting Disk Path " + i + " = " + vdiskArr[i].getPath()));
                if (vdiskArr[i].isASMPath() == 1) continue;
                voteLoc = vdiskArr[i].getPath();
                try {
                    stInfo = new TypeFinder().getStorageInstance(voteLoc);
                }
                catch (StorageException e3) {
                    Trace.out((String)("StorageException attempting to get storage type for: " + voteLoc));
                    continue;
                }
                fileSystem = voteLoc;
                while (stInfo.getType() == 5) {
                    sTaskFreeSpace sTask = new sTaskFreeSpace();
                    cmdArray = new Command[1];
                    ResultSet freeSpcRsltSet = new ResultSet();
                    String cmd = sTask.getCommand(voteLoc);
                    cmdArray[0] = new RunGenericCommand(m_localNode, cmd);
                    boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, freeSpcRsltSet);
                    t = freeSpcRsltSet.getResultTable();
                    e = t.keys();
                    fileSystem = "UNKNOWN";
                    while (e.hasMoreElements()) {
                        node = (String)e.nextElement();
                        result = (Result)t.get(node);
                        if (result.getStatus() != 1) continue;
                        cmdOut = VerificationUtil.fetchVerificationValue((String)result.getResultInfoSet().firstElement());
                        fileSystem = sTask.getData(cmdOut, 0);
                        Trace.out((String)("Parsing VoteLoc: " + voteLoc + " to: " + fileSystem));
                    }
                    if (savFileSystem == null) {
                        savFileSystem = fileSystem;
                    } else {
                        if (fileSystem.contentEquals(savFileSystem)) break;
                        savFileSystem = fileSystem;
                    }
                    try {
                        stInfo = new TypeFinder().getStorageInstance(fileSystem);
                    }
                    catch (StorageException se) {
                        Trace.out((String)("StorageException getting storage type for: " + fileSystem));
                        break;
                    }
                }
                if (stInfo.getType() != 1) continue;
                pathList.add(voteLoc);
                fileSystemList.add(fileSystem);
                this.diskPathtoFileSystem.put(stInfo.getPath(), voteLoc);
                Trace.out((String)("diskPathtoFileSystem:\n hashmap<string:devPath,string:userPath>:'" + this.diskPathtoFileSystem + "'"));
                this.fileSystemtoStInfo.put(fileSystem, stInfo);
                if (fileSystem.contentEquals(voteLoc)) continue;
                if (this.fileSystemtoStInfo.containsKey(voteLoc)) {
                    StorageInfo storedStInfo = this.fileSystemtoStInfo.get(voteLoc);
                    Trace.out((String)("Processing two storage info objects referring to the same location: \nStInfo(1): '" + stInfo.toString() + "'\nStInfo(2): '" + storedStInfo.toString() + "'"));
                    continue;
                }
                this.fileSystemtoStInfo.put(voteLoc, stInfo);
            }
        } else if (this.isASMDiskUDevCheck() && this.m_UdevCheckPaths != null) {
            Trace.out((String)"Doing ASMDiskUdevCheck");
            for (i = 0; i < this.m_UdevCheckPaths.length; ++i) {
                Trace.out((String)("Disk Path " + i + " = " + this.m_UdevCheckPaths[i]));
                try {
                    stInfo = new TypeFinder().getStorageInstance(this.m_UdevCheckPaths[i]);
                }
                catch (StorageException e4) {
                    continue;
                }
                fileSystem = this.m_UdevCheckPaths[i];
                while (stInfo.getType() == 5) {
                    sTaskFreeSpace sTask = new sTaskFreeSpace();
                    Command[] cmdArray2 = new Command[1];
                    ResultSet freeSpcRsltSet = new ResultSet();
                    String cmd = sTask.getCommand(this.m_UdevCheckPaths[i]);
                    cmdArray2[0] = new RunGenericCommand(m_localNode, cmd);
                    boolean cmdResult = new GlobalHandler().submit(cmdArray2, 0, freeSpcRsltSet);
                    Hashtable t2 = freeSpcRsltSet.getResultTable();
                    Enumeration e5 = t2.keys();
                    fileSystem = "UNKNOWN";
                    while (e5.hasMoreElements()) {
                        String node2 = (String)e5.nextElement();
                        Result result2 = (Result)t2.get(node2);
                        if (result2.getStatus() != 1) continue;
                        String cmdOut2 = VerificationUtil.fetchVerificationValue((String)result2.getResultInfoSet().firstElement());
                        fileSystem = sTask.getData(cmdOut2, 0);
                        Trace.out((String)("Parsing Disk location: " + this.m_UdevCheckPaths[i] + " to: " + fileSystem));
                    }
                    if (savFileSystem == null) {
                        savFileSystem = fileSystem;
                    } else {
                        if (fileSystem.contentEquals(savFileSystem)) break;
                        savFileSystem = fileSystem;
                    }
                    try {
                        stInfo = new TypeFinder().getStorageInstance(fileSystem);
                    }
                    catch (StorageException se) {
                        Trace.out((String)("StorageException getting storage type for: " + fileSystem));
                        break;
                    }
                }
                if (stInfo.getType() != 1) continue;
                Trace.out((String)("Using path: '" + this.m_UdevCheckPaths[i] + "' for UDEV check"));
                pathList.add(this.m_UdevCheckPaths[i]);
                fileSystemList.add(fileSystem);
                this.diskPathtoFileSystem.put(stInfo.getPath(), this.m_UdevCheckPaths[i]);
                Trace.out((String)("diskPathtoFileSystem:\n hashmap<string:devPath,string:userPath>:'" + this.diskPathtoFileSystem + "'"));
                this.fileSystemtoStInfo.put(fileSystem, stInfo);
                if (!fileSystem.contentEquals(this.m_UdevCheckPaths[i])) {
                    if (this.fileSystemtoStInfo.containsKey(this.m_UdevCheckPaths[i])) {
                        StorageInfo storedStInfo = this.fileSystemtoStInfo.get(this.m_UdevCheckPaths[i]);
                        Trace.out((String)("Processing two storage info objects referring to the same location: \nStInfo(1): '" + stInfo.toString() + "'\nStInfo(2): '" + storedStInfo.toString() + "'"));
                        continue;
                    }
                    this.fileSystemtoStInfo.put(this.m_UdevCheckPaths[i], stInfo);
                    continue;
                }
                Trace.out((String)("Adding device path: '" + stInfo.getName() + "' to the pathList for fileSystem: '" + fileSystem + "'"));
                pathList.add(stInfo.getName());
            }
        }
        Trace.out((String)("pathList: '" + pathList + "'"));
        Vector nonMapperDevs = new Vector();
        for (int j = 0; j < pathList.size(); ++j) {
            if (((String)pathList.get(j)).matches("^/+dev/+mapper\\S*") || ((String)pathList.get(j)).matches("^/+dev/+mpath\\S*")) continue;
            nonMapperDevs.add(pathList.get(j));
        }
        this.m_UdevCheckPaths = nonMapperDevs.toArray(new String[nonMapperDevs.size()]);
        this.m_UdevCheckFileSystems = fileSystemList.toArray(new String[fileSystemList.size()]);
        if (this.m_UdevCheckPaths.length == 0) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"m_UdevCheckPaths is empty!!");
            }
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return;
        }
        ResultSet udevResultSet = new ResultSet();
        this.getUdevAttributes(this.m_nodeList, udevResultSet);
        this.m_resultSet.addResultSetData(udevResultSet);
        if (udevResultSet.anySuccess()) {
            if (this.isUSMUDevCheck()) {
                this.reportUdevCheckResult(udevResultSet);
            } else if (this.isAnyLocationOnDisk()) {
                this.reportUdevPathCheckResult(udevResultSet);
            }
        }
    }

    private boolean getStorageAttributes() {
        switch (this.m_stEntity) {
            case USM: {
                this.m_owner = VerificationUtil.getUSMDeviceOwner();
                try {
                    this.m_group = VerificationUtil.getASMAdminGroup(null);
                }
                catch (CVUException ce) {
                    Trace.out((String)("Exception occured while getting ASM admin group ::" + ce.getMessage()));
                    ReportUtil.printError(ce.getMessage());
                    return false;
                }
                this.m_perms = this.getUSMDevPerms();
                break;
            }
            case OCR: {
                this.m_owner = VerificationUtil.getOCROwner();
                this.m_group = this.getOCRGroup();
                this.m_perms = VerificationUtil.getOCRPermissions();
                break;
            }
            case VDISK: {
                this.m_owner = TaskUSMUdevChecks.getVDiskOwner();
                this.m_group = this.getVDiskGroup();
                this.m_perms = VerificationUtil.getVDiskPermissions();
                break;
            }
            case ASM: {
                this.m_owner = this.getASMDiskOwner();
                this.m_group = this.getASMDiskGroup();
                this.m_perms = this.getASMDiskPermissions();
                break;
            }
        }
        return this.m_owner != null && this.m_group != null && this.m_perms != null;
    }

    private void reportUdevCheckResult(ResultSet resultSet) {
        this.reportUdevCheckResult(resultSet, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void reportUdevCheckResult(ResultSet resultSet, String path2Check) {
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        String hdrName = s_msgBundle.getMessage("5180", false);
        String hdrOwner = s_msgBundle.getMessage("5181", false);
        String hdrGroup = s_msgBundle.getMessage("5182", false);
        String hdrPerms = s_msgBundle.getMessage("5183", false);
        String hdrResult = s_msgBundle.getMessage("5192", false);
        boolean pathSpecified = path2Check != null;
        String distID = VerificationUtil.getUniqueDistributionID();
        USMDevInfo usmDev = null;
        if (!pathSpecified) {
            Trace.out((String)"'path2Check' is NULL!!, not expected!\n");
            return;
        }
        Trace.out((String)("'path2Check' is: '" + path2Check + "'"));
        while (true) {
            int i;
            Vector udevVect;
            String node;
            block15: {
                if (!e.hasMoreElements()) {
                    return;
                }
                node = (String)e.nextElement();
                Result result = (Result)t.get(node);
                if (result.getStatus() == 1) {
                    udevVect = result.getResultInfoSet();
                    if (udevVect.size() > 0) {
                        i = udevVect.size();
                        break block15;
                    } else {
                        Trace.out((String)("No udev entries found on node " + node));
                        String devErrMsg = s_msgBundle.getMessage("5185", true, (Object[])new String[]{node});
                        ReportUtil.sureprintln(devErrMsg);
                        this.m_resultSet.addErrorDescription(node, new ErrorDescription(devErrMsg));
                        this.m_resultSet.addResult(node, 3);
                        continue;
                    }
                }
                Trace.out((String)("Check for UDev device entries failed on node " + node));
                String devErrMsg = s_msgBundle.getMessage("5186", true, (Object[])new String[]{node});
                ReportUtil.sureprintln(devErrMsg);
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(devErrMsg));
                this.m_resultSet.addResult(node, 2);
                continue;
            }
            for (int j = 0; j < udevVect.size(); ++j, --i) {
                String udevStr;
                boolean warnRule;
                Vector<String> unmatch;
                boolean match;
                Boolean pathFoundinUdev = false;
                Trace.out((String)("udevVect size: " + udevVect.size() + " i: " + i + " j: " + j));
                if (distID.startsWith("SUSE")) {
                    usmDev = (USMDevInfo)udevVect.get(j);
                    Trace.out((String)("Getting SUSE udevVect object: " + j));
                } else {
                    usmDev = (USMDevInfo)udevVect.get(i - 1);
                    Trace.out((String)("Getting udevVect object: " + (i - 1)));
                }
                Trace.out((String)("diskPathtoFileSystem: \n" + this.diskPathtoFileSystem));
                pathFoundinUdev = usmDev.match(path2Check);
                Trace.out((String)("pathFoundinUdev: '" + pathFoundinUdev + "'\npath2Check: '" + path2Check + "'" + "\nFound USMDevInfo: '" + usmDev + "'"));
                if (!pathFoundinUdev.booleanValue()) continue;
                if (this.validatedUdevPath.contains(path2Check)) {
                    Trace.out((String)("specified path '" + path2Check + "' already passed."));
                    continue;
                }
                String fileSysPath = this.diskPathtoFileSystem.get(path2Check);
                if (VerificationUtil.isStringGood(fileSysPath)) {
                    Trace.out((String)("Checking to see if path '" + fileSysPath + "' has already been processed with '" + path2Check + "'."));
                    if (this.validatedUdevPath.contains(fileSysPath)) {
                        Trace.out((String)("path '" + fileSysPath + "' already processed."));
                        continue;
                    }
                }
                if (match = this.compareAttrib(usmDev, unmatch = new Vector<String>(), path2Check, warnRule = false)) {
                    Trace.out((String)("Check for path(device) " + path2Check + "(" + usmDev.getName() + ") passed."));
                    this.validatedUdevPath.add(path2Check);
                    Trace.out((String)("validatedUdevPath's: " + this.validatedUdevPath));
                    if (!this.m_hdrPrinted) {
                        this.m_hdrPrinted = true;
                        ReportUtil.writeColHeaders(hdrName, hdrOwner, hdrGroup, hdrPerms, hdrResult);
                    }
                    ReportUtil.writeRecord(usmDev.getName(), usmDev.getOwner(), usmDev.getGroup(), usmDev.getPerms(), ReportUtil.PASSED);
                    break;
                }
                StorageInfo fsSI = this.fileSystemtoStInfo.get(path2Check);
                if (usmDev.getName().contentEquals("*") && fsSI != null && this.udevPathsList.contains(udevStr = fsSI.getName().replaceFirst("/dev/", ""))) {
                    Trace.out((String)("Path: '" + path2Check + "' failed, but " + "path '/dev/" + udevStr + "' will be checked" + " later which matches '" + path2Check + "'"));
                    continue;
                }
                this.validatedUdevPath.add(path2Check);
                Trace.out((String)("validatedUdevPath's: " + this.validatedUdevPath));
                Trace.out((String)("Check for device " + usmDev.getName() + " failed."));
                String displayPath = "";
                String nodeHdr = s_msgBundle.getMessage("8058", false) + ": " + node;
                displayPath = this.diskPathtoFileSystem.containsKey(path2Check) ? this.diskPathtoFileSystem.get(path2Check) + "(" + path2Check + ")" : path2Check;
                Trace.out((String)("displayPath: '" + displayPath + "'"));
                ReportUtil.sureprintln(nodeHdr);
                String udevFile = usmDev.getFile();
                String udevRule = usmDev.getRule();
                String msg = s_msgBundle.getMessage("5184", true, (Object[])new String[]{node + ":" + displayPath, unmatch.toString(), udevFile, udevRule});
                ReportUtil.sureprintln(msg);
                ErrorDescription errorDesc = new ErrorDescription(msg);
                this.m_resultSet.addResult(this.m_nodeList, warnRule ? 3 : 4);
                this.m_resultSet.addErrorDescription(node, errorDesc);
                break;
            }
            ReportUtil.blankln();
        }
    }

    private boolean isAnyLocationOnDisk() {
        Vector<String> diskList = new Vector<String>();
        StorageInfo stInfo = null;
        for (String path2Check : this.m_UdevCheckPaths) {
            if (VerificationUtil.isASMPath(path2Check)) {
                Trace.out((String)("Skipping ASM path: " + path2Check));
                continue;
            }
            Trace.out((String)("Checking storage type for location " + path2Check));
            try {
                stInfo = new TypeFinder().getStorageInstance(path2Check);
            }
            catch (StorageException e) {
                Trace.out((String)("StorageException attempting to get storage type for " + path2Check));
                String exceptionMsg = s_msgBundle.getMessage("9800", true, (Object[])new String[]{path2Check}) + LSEP + e.getMessage();
                ReportUtil.sureprintln(exceptionMsg);
                ReportUtil.sureblankln();
                this.m_resultSet.addErrorDescription(m_localNode, new ErrorDescription(exceptionMsg));
                this.m_resultSet.addResult(m_localNode, 2);
                continue;
            }
            if (stInfo.getType() == 1) {
                Trace.out((String)("Location '" + path2Check + "' is of type DISK," + "checking device path '" + stInfo.getPath() + "'"));
                diskList.add(path2Check);
                diskList.add(stInfo.getPath());
                if (!this.udevPathsList.contains(path2Check)) {
                    this.udevPathsList.add(path2Check.replaceFirst("/dev/", ""));
                }
                if (!this.udevPathsList.contains(stInfo.getPath())) {
                    this.udevPathsList.add(stInfo.getPath().replaceFirst("/dev/", ""));
                }
                if (!path2Check.contentEquals(stInfo.getPath())) {
                    this.diskPathtoFileSystem.put(stInfo.getPath(), path2Check);
                }
                Trace.out((String)("diskPathtoFileSystem:\n hashmap<string:devPath,string:userPath>:'" + this.diskPathtoFileSystem + "'"));
                continue;
            }
            Trace.out((String)("Storage " + path2Check + "is not of type DISK, skipping Udev checks"));
        }
        if (diskList.size() > 0) {
            this.m_UdevCheckPaths = diskList.toArray(new String[diskList.size()]);
            return true;
        }
        return false;
    }

    private void reportUdevPathCheckResult(ResultSet resultSet) {
        String pathToFileSystem = null;
        ArrayList<String> noDupeUdevPaths = new ArrayList<String>();
        Trace.out((String)("m_UdevCheckPaths: '" + VerificationUtil.strArr2List(this.m_UdevCheckPaths) + "' validatedUdevPath: '" + this.validatedUdevPath + "'"));
        for (String udevPathEntry : this.m_UdevCheckPaths) {
            if (noDupeUdevPaths.contains(udevPathEntry)) {
                Trace.out((String)("Removing duplicate entry: '" + udevPathEntry + "'"));
                continue;
            }
            if (this.validatedUdevPath.contains(udevPathEntry)) {
                Trace.out((String)("Remove validated path '" + udevPathEntry + "' from check list"));
                continue;
            }
            if (this.diskPathtoFileSystem.containsKey(udevPathEntry)) {
                pathToFileSystem = this.diskPathtoFileSystem.get(udevPathEntry);
                if (this.validatedUdevPath.contains(pathToFileSystem)) {
                    Trace.out((String)("Remove validated path '" + udevPathEntry + "' (which was validated via path '" + pathToFileSystem + "') from check list"));
                    continue;
                }
                Trace.out((String)("Adding '" + udevPathEntry + "' to path check list but it may be validated when" + " path '" + pathToFileSystem + "' is checked..."));
                noDupeUdevPaths.add(udevPathEntry);
                continue;
            }
            noDupeUdevPaths.add(udevPathEntry);
            Trace.out((String)("Adding '" + udevPathEntry + "' to path check list"));
        }
        for (String path2Check : this.m_UdevCheckPaths = noDupeUdevPaths.toArray(new String[noDupeUdevPaths.size()])) {
            Trace.out((String)("Checking and reporting result for path " + path2Check));
            pathToFileSystem = this.diskPathtoFileSystem.get(path2Check);
            if (this.validatedUdevPath.contains(pathToFileSystem)) {
                Trace.out((String)("path2Check: '" + path2Check + "' already validated with: '" + pathToFileSystem + "'"));
                continue;
            }
            ReportUtil.sureprintln(s_msgBundle.getMessage("5198", false, (Object[])new String[]{path2Check}));
            this.reportUdevCheckResult(resultSet, path2Check);
        }
    }

    private boolean compareAttrib(USMDevInfo usmDev, Vector<String> unmatch, String path2Check, boolean warnRule) {
        boolean match = true;
        String Found = s_msgBundle.getMessage("0052", false);
        String Expected = s_msgBundle.getMessage("0053", false);
        ArrayList<String> foundUnsupportedKeyword = new ArrayList<String>();
        String upperUDEVRule = usmDev.getDevLine().toUpperCase();
        for (String keyword : this.m_UnsupportedUDEVKeywords) {
            if (!upperUDEVRule.contains(keyword)) continue;
            foundUnsupportedKeyword.add(keyword);
        }
        if (foundUnsupportedKeyword.size() > 0) {
            Trace.out((String)("UDEV RULE contains a keywords that cannot be processed: " + usmDev.getDevLine()));
            match = false;
            warnRule = true;
            unmatch.add(new String(s_gMsgBundle.getMessage("1052", true, (Object[])new String[]{path2Check, ((Object)foundUnsupportedKeyword).toString().replaceAll("\\[|\\]", "")})));
            return match;
        }
        if (!usmDev.getOwner().equals(this.m_owner)) {
            Trace.out((int)5, (String)("Owners NOT equal: usmDev '" + usmDev.getOwner() + "' m_owner '" + this.m_owner + "'"));
            match = false;
            unmatch.add(new String(s_msgBundle.getMessage("5181", false) + ": " + Found + "'" + usmDev.getOwner() + "' " + Expected + "'" + this.m_owner + "'"));
        }
        if (!usmDev.getGroup().equals(this.m_group)) {
            Trace.out((int)5, (String)("Groups NOT equal: usmDev '" + usmDev.getGroup() + "' m_group '" + this.m_group + "'"));
            match = false;
            unmatch.add(new String(s_msgBundle.getMessage("5182", false) + ": " + Found + "'" + usmDev.getGroup() + "' " + Expected + "'" + this.m_group + "'"));
        }
        if (Integer.parseInt(usmDev.getPerms(), 8) != Integer.parseInt(this.m_perms, 8)) {
            Trace.out((int)5, (String)("Perms NOT equal: usmDev '" + usmDev.getPerms() + "' m_perms '" + this.m_perms + "'"));
            match = false;
            unmatch.add(new String(s_msgBundle.getMessage("5183", false) + ": " + Found + "'" + usmDev.getPerms() + "' " + Expected + "'" + this.m_perms + "'"));
        }
        return match;
    }

    private String getUSMDevPerms() {
        return VerificationUtil.getDefaultUSMDevPerms();
    }

    private boolean checkSubUdevAttributes(String[] nodeList, ResultSet resultSet, String udevList) {
        Trace.out((int)2, (String)"Entry");
        VerificationCommand[] udevCmdArray = new VerificationCommand[nodeList.length];
        Trace.out((String)("Node List to udevCommand " + Arrays.asList(nodeList)));
        Trace.out((String)("\nm_UdevCheckPaths: " + VerificationUtil.strArr2List(this.m_UdevCheckPaths) + "\nm_UdevCheckFileSystems: " + VerificationUtil.strArr2List(this.m_UdevCheckFileSystems) + "\nudevList: " + udevList + "\n"));
        for (int j = 0; j < nodeList.length; ++j) {
            String[] arg = null;
            String[] env = null;
            if (this.isUSMUDevCheck()) {
                arg = new String[]{"-getusmdevinfo", udevList};
                Trace.out((String)(" Get usm device info command args: (Node: " + nodeList[j] + ") " + Arrays.asList(arg)));
            } else {
                arg = new String[]{"-getudevinfo", udevList};
                Trace.out((String)(" Get udev info command args: " + Arrays.asList(arg)));
            }
            udevCmdArray[j] = new VerificationCommand(nodeList[j], arg, env);
        }
        new GlobalHandler().submit((Command[])udevCmdArray, 0, resultSet);
        if (!resultSet.anySuccess()) {
            Trace.out((String)"Global failure executing getusmdevinfo command. ");
            String message = s_msgBundle.getMessage("5187", true);
            ErrorDescription errorDesc = new ErrorDescription(message);
            resultSet.addErrorDescription(nodeList, errorDesc);
            ReportUtil.printError(message);
            this.m_resultSet.addResult(nodeList, 2);
            return false;
        }
        Trace.out((String)("Process output from " + nodeList.length + " nodes."));
        for (int nodeIndex = 0; nodeIndex < nodeList.length; ++nodeIndex) {
            VerificationCommand udevCmd = udevCmdArray[nodeIndex];
            String node = udevCmd.getNode();
            Result result = udevCmd.getResult();
            Trace.out((String)("\n Processing node: " + node + "\n VfyCode: " + udevCmd.getVfyCode() + "\n Status: " + result.getStatus() + "\n"));
            if (udevCmd.getVfyCode() == 0 && result.getStatus() == 1) {
                String output = udevCmd.getOutput();
                Vector<USMDevInfo> usmdevVect = new Vector<USMDevInfo>();
                this.parseUsmDevCmdOutput(output, usmdevVect, node);
                result.addResultInfo(usmdevVect);
                Trace.out((String)("Output from get udev usm command is =" + output));
                for (USMDevInfo usmdevtrace : usmdevVect) {
                    Trace.out((String)("USMDevInfo: " + usmdevtrace.toString()));
                }
                continue;
            }
            Trace.out((String)("\n Result data:\n " + result.traceResultInfo() + "\n"));
            String message = s_msgBundle.getMessage("9802", true, (Object[])new String[]{node});
            String errmsg = udevCmd.getError();
            ErrorDescription errorDesc = null;
            if (errmsg != null) {
                Trace.out((String)("\n Error msg: " + errmsg + "\n"));
                errorDesc = new ErrorDescription(message + VerificationConstants.LINE_SEPARATOR + errmsg);
                ReportUtil.printError(message + VerificationConstants.LINE_SEPARATOR + errmsg);
            } else {
                Trace.out((String)"\n Error msg is NULL");
                errorDesc = new ErrorDescription(message);
                ReportUtil.printError(message);
            }
            resultSet.addErrorDescription(node, errorDesc);
            resultSet.getResult(node).setStatus(3);
        }
        resultSet.setStatus();
        return true;
    }

    private boolean getUdevAttributes(String[] nodeList, ResultSet resultSet) {
        int i;
        Trace.out((int)2, (String)"Entry");
        VerificationCommand[] udevCmdArray = new VerificationCommand[nodeList.length];
        boolean retVal = false;
        String[] udevPaths = null;
        String udevList = null;
        int index = 0;
        int nextIndex = 10;
        int udevPathsLength = 0;
        Trace.out((String)("Node List to udevCommand " + Arrays.asList(nodeList)));
        Trace.out((String)("fileSystemtoStInfo:\n hashmap<string:filesystem,storageInfo:filesystem>:'" + this.fileSystemtoStInfo + "'"));
        Trace.out((String)("diskPathtoFileSystem:\n hashmap<string:devPath,string:userPath>:'" + this.diskPathtoFileSystem + "'"));
        if (this.m_UdevCheckFileSystems != null && this.m_UdevCheckFileSystems.length != 0) {
            for (i = 0; i < this.m_UdevCheckFileSystems.length; ++i) {
                String fsPath = this.m_UdevCheckFileSystems[i].replaceFirst("/dev/", "");
                if (this.udevPathsList.contains(fsPath)) continue;
                this.udevPathsList.add(fsPath);
                Trace.out((String)("Adding FS path to UDEV list: '" + fsPath + "'"));
            }
        }
        if (this.m_UdevCheckPaths != null && this.m_UdevCheckPaths.length != 0) {
            for (i = 0; i < this.m_UdevCheckPaths.length; ++i) {
                String diskPath = this.m_UdevCheckPaths[i].replaceFirst("/dev/", "");
                if (!this.udevPathsList.contains(diskPath)) {
                    Trace.out((String)("Adding disk path to UDEV list: '" + diskPath + "'"));
                    this.udevPathsList.add(diskPath);
                    continue;
                }
                Trace.out((String)("diskPath: '" + diskPath + "' already in UDEV list"));
            }
        }
        udevPaths = this.udevPathsList.toArray(new String[this.udevPathsList.size()]);
        udevList = VerificationUtil.strArr2List(udevPaths);
        Trace.out((String)("\nm_UdevCheckPaths: " + VerificationUtil.strArr2List(this.m_UdevCheckPaths) + "\nm_UdevCheckFileSystems: " + VerificationUtil.strArr2List(this.m_UdevCheckFileSystems) + "\nudevList: " + udevList + "\n"));
        udevPathsLength = udevPaths.length;
        while (index < udevPathsLength) {
            if (nextIndex > udevPathsLength) {
                nextIndex = udevPathsLength;
            }
            if (!(retVal = this.checkSubUdevAttributes(nodeList, resultSet, udevList = VerificationUtil.strArr2List(Arrays.copyOfRange(udevPaths, index, nextIndex))))) {
                return retVal;
            }
            index += 10;
            nextIndex += 10;
        }
        resultSet.setStatus();
        return true;
    }

    public void parseUsmDevCmdOutput(String output, Vector<USMDevInfo> usmdevVect, String node) {
        Vector usmDevStr = null;
        try {
            usmDevStr = GenericUtil.getAllStrByTags(output, TAG_USMDEV);
        }
        catch (ParsingException e) {
            Trace.out((int)5, (String)("Error parsing device command output:" + usmDevStr));
            this.m_resultSet.addResult(node, 2);
            this.m_resultSet.getResult(node).setHasResultValues(true);
            this.m_resultSet.getResult(node).setActualValue(usmDevStr.toString() + e);
            this.m_resultSet.setStatus();
        }
        if (usmDevStr.size() > 0) {
            for (int i = 0; i < usmDevStr.size(); ++i) {
                String strUDEV = (String)usmDevStr.get(i);
                Trace.out((String)("Device String [" + i + "]=" + strUDEV));
                if (strUDEV.indexOf("#") != -1 && strUDEV.indexOf("#") < strUDEV.indexOf("KERNEL")) {
                    Trace.out((int)5, (String)("COMMENT CHAR BEFORE DATA, SKIPPING:\n " + strUDEV));
                    continue;
                }
                boolean ret = false;
                USMDevInfo usminfo = null;
                try {
                    usminfo = new USMDevInfo();
                    ret = usminfo.parse((String)usmDevStr.get(i));
                }
                catch (USMDevInfoException e) {
                    Trace.out((int)5, (String)("Error parsing the following output on node " + node + ": \"" + (String)usmDevStr.get(i) + "\""));
                }
                if (ret) {
                    Trace.out((String)("Adding new USMDevInfo to node vector: Node '" + node + "' USMDevInfo: \n" + usminfo.toString()));
                    usmdevVect.add(usminfo);
                    continue;
                }
                Trace.out((int)5, (String)("Error parsing the following output on node " + node + ": \"" + (String)usmDevStr.get(i) + "\""));
            }
            Vector<USMDevInfo> udevVect_nodupes = new Vector<USMDevInfo>();
            ArrayList<String> udevLines = new ArrayList<String>();
            USMDevInfo usmDev = null;
            for (int k = 0; k < usmdevVect.size(); ++k) {
                usmDev = usmdevVect.get(k);
                if (!(udevLines.contains(usmDev.getDevLine()) || usmDev.getDevLine().indexOf(35) != -1 && usmDev.getDevLine().indexOf("KERNEL") >= usmDev.getDevLine().indexOf(35))) {
                    Trace.out((String)("Adding usmDev to list: \n" + usmDev.getDevLine()));
                    udevVect_nodupes.add(usmDev);
                    udevLines.add(usmDev.getDevLine());
                    continue;
                }
                Trace.out((String)("Removing duplicate/commented udev entry for: \n" + usmDev.getDevLine()));
            }
            usmdevVect.clear();
            usmdevVect.addAll(udevVect_nodupes);
        }
    }

    public void setOwner(String owner) {
        this.m_owner = owner;
    }

    public void setGroup(String group1) {
        this.m_group = group1;
    }

    public void setPerms(String perms) {
        this.m_perms = perms;
    }

    public void setUSMUDevCheck() {
        this.m_stEntity = StorageEntity.USM;
        this.m_stEntityString = s_msgBundle.getMessage("9803", false);
    }

    public void setOCRUDevCheck() {
        this.m_stEntity = StorageEntity.OCR;
        this.m_stEntityString = s_msgBundle.getMessage("9804", false);
    }

    public void setVDiskUDevCheck() {
        this.m_stEntity = StorageEntity.VDISK;
        this.m_stEntityString = s_msgBundle.getMessage("9805", false);
    }

    public void setASMDiskUDevCheck() {
        this.m_stEntity = StorageEntity.ASM;
        this.m_stEntityString = s_msgBundle.getMessage("9812", false);
    }

    public boolean isUSMUDevCheck() {
        return this.m_stEntity == StorageEntity.USM;
    }

    public boolean isOCRUDevCheck() {
        return this.m_stEntity == StorageEntity.OCR;
    }

    public boolean isVDiskUDevCheck() {
        return this.m_stEntity == StorageEntity.VDISK;
    }

    public boolean isASMDiskUDevCheck() {
        return this.m_stEntity == StorageEntity.ASM;
    }

    public void setUdevCheckPaths(String[] udevCheckPaths) {
        this.m_UdevCheckPaths = udevCheckPaths;
    }

    @Override
    public String getDefaultElementName() {
        StringBuffer sb = new StringBuffer(s_msgBundle.getMessage("4449", false));
        sb.append("(" + this.m_stEntityString + ")");
        Trace.out((String)("DefaultElementName: '" + sb.toString() + "'"));
        return sb.toString();
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4499", false);
    }

    public static String getVDiskOwner() {
        Result result = new Result(m_localNode);
        return VerificationUtil.getCRSUser(m_localNode, result, false);
    }

    public String getVDiskGroup() {
        return VerificationUtil.getOraInventoryGroup();
    }

    public String getOCRGroup() {
        return VerificationUtil.getOraInventoryGroup();
    }

    public void setASMDiskOwner(String asmDiskOwner) {
        this.m_asmDiskOwner = asmDiskOwner;
    }

    public String getASMDiskOwner() {
        return this.m_asmDiskOwner;
    }

    public void setASMDiskGroup(String asmDiskGroup) {
        this.m_asmDiskGroup = asmDiskGroup;
    }

    public String getASMDiskGroup() {
        return this.m_asmDiskGroup;
    }

    public void setASMDiskPermissions(String asmDiskPermissions) {
        this.m_asmDiskPermissions = asmDiskPermissions;
    }

    public String getASMDiskPermissions() {
        return this.m_asmDiskPermissions;
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }

    private static enum StorageEntity {
        USM,
        OCR,
        VDISK,
        ASM;

    }
}

