/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskTimeZoneSetting
extends Task {
    public static final int PRE = 0;
    public static final int POST = 1;
    private int m_tasktype = 0;
    public final String filePrefix = "/crs/install/s_crsconfig_";
    public final String fileSuffix = "_env.txt";

    public TaskTimeZoneSetting(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        this.m_tasktype = this.m_globalContext.isPreCRS() && !this.m_globalContext.isUpgrade() ? 0 : 1;
        VerificationType vType = this.m_globalContext.getVerificationType();
        switch (vType) {
            case PREREQ_NODE_ADD: 
            case PREREQ_RACNODE_ADD: {
                this.setNodeList(VerificationUtil.addLocalNodeToNodeList(this.m_nodeList));
            }
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (VerificationType.PREREQ_CRS_INST.equals((Object)this.m_globalContext.getVerificationType()) && VerificationUtil.isBaselineCollectionMode()) {
            return false;
        }
        if (this.m_globalContext.isPreCRS() && !this.m_globalContext.isUpgrade()) {
            return true;
        }
        String actCRSVer = VerificationUtil.getCRSActiveVersion();
        if (VerificationUtil.isStringGood(actCRSVer)) {
            if (!VerificationUtil.isVersionPre(actCRSVer, "11.2")) {
                VerificationUtil.traceAndLog("Source home CRS version is greater than or equal to 11.2, adding Time zone settings checks");
                return true;
            }
            VerificationUtil.traceAndLog("Source home CRS version is pre 11.2, NOT adding Time zone settings checks");
            return false;
        }
        VerificationUtil.traceAndLog("Source home CRS version could not be retrieved and hence not adding Time zone settings checks");
        return false;
    }

    public TaskTimeZoneSetting(String[] nodeList) {
        super(nodeList, null, 1);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    public void setTaskType(int type) {
        this.m_tasktype = type;
    }

    @Override
    public boolean performTask() {
        ErrorDescription ed;
        CollectionElement collectionElement = null;
        String nodeName = null;
        ReportUtil.println(s_msgBundle.getMessage("1000", false, (Object[])new String[]{this.getDefaultElementName()}));
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet tzRsltSet = new ResultSet();
        Vector<String> noCfg = new Vector<String>();
        Vector<String> noTZCfg = new Vector<String>();
        Vector<String> noTZFile = new Vector<String>();
        Vector<CollectionElement> successNodes = new Vector<CollectionElement>();
        Hashtable cfgPaths = new Hashtable();
        if (this.m_tasktype == 1) {
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            if (nativeSystem.isUnixSystem()) {
                String crsHome = VerificationUtil.getCRSHome();
                if (crsHome == null) {
                    ReportUtil.printError(s_msgBundle.getMessage("9001", true));
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    return false;
                }
                cfgPaths = this.getCfgPath(crsHome);
            }
            globalExec.timeZoneConsistency(this.m_nodeList, tzRsltSet, cfgPaths);
        } else {
            globalExec.timeZoneConsistency(this.m_nodeList, tzRsltSet);
        }
        Hashtable ht = tzRsltSet.getResultTable();
        Enumeration e = ht.keys();
        String timeZone = null;
        Hashtable<Object, Vector<Object>> timeZoneList = new Hashtable<Object, Vector<Object>>();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            collectionElement = new CollectionElement(this.getElementName(), null, "", null, this.getDefaultDescription(), 5);
            this.m_resultSet.addCollectionElement(node, collectionElement);
            if (result.getStatus() == 1) {
                successNodes.add(collectionElement);
                timeZone = (String)result.getResultInfoSet().firstElement();
                Trace.out((String)("Result.OPERATION_SUCCESSFUL:: Time Zone = " + timeZone + "on node " + node));
                VerificationUtil.updateResultMap(timeZoneList, timeZone, node);
                collectionElement.setStatus(1);
                collectionElement.setValue(timeZone);
                this.m_resultSet.addResult(node, 1);
                continue;
            }
            if (result.getStatus() == 3) {
                collectionElement.setStatus(3);
                String vres = (String)result.getResultInfoSet().firstElement();
                if (vres.equals("1")) {
                    noCfg.add(node);
                    continue;
                }
                if (vres.equals("2")) {
                    noTZCfg.add(node);
                    continue;
                }
                if (!vres.equals("3")) continue;
                noTZFile.add(node);
                continue;
            }
            this.m_resultSet.addResult(node, result.getStatus());
            String exectaskOutput = result.getErrorInfoString();
            String errMsg = VerificationUtil.fetchError(exectaskOutput);
            this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
        }
        if (timeZoneList.size() > 1) {
            String nodeAryStr = null;
            int ovrAllStatus = this.m_resultSet.getStatus();
            Enumeration keys1 = timeZoneList.keys();
            String erMsg0 = s_msgBundle.getMessage("5479", true);
            ReportUtil.printError(erMsg0);
            StringBuilder totalMsg = new StringBuilder();
            totalMsg.append(erMsg0);
            totalMsg.append(LSEP);
            while (keys1.hasMoreElements()) {
                String key = (String)keys1.nextElement();
                nodeAryStr = VerificationUtil.strVect2List((Vector)timeZoneList.get(key));
                for (int i = 0; i < ((Vector)timeZoneList.get(key)).size(); ++i) {
                    nodeName = (String)timeZoneList.get(key).get(i);
                    collectionElement = this.m_resultSet.getResult(nodeName).getCollectionElements().get(0);
                    if (collectionElement != null) {
                        collectionElement.updateCollectionElement(erMsg0);
                    }
                    collectionElement.setStatus(3);
                }
                String erMsg = s_msgBundle.getMessage("5480", false, (Object[])new String[]{key, nodeAryStr});
                ReportUtil.sureprintln(erMsg);
                this.m_resultSet.addResult(timeZoneList.get(key), 3);
                totalMsg.append(erMsg);
                totalMsg.append(LSEP);
            }
            ed = new ErrorDescription(totalMsg.toString());
            this.m_resultSet.addErrorDescription(ed);
        }
        if (noCfg.size() > 0) {
            String errMsg = null;
            int nsz = noCfg.size();
            for (int k = 0; k < nsz; ++k) {
                String currNode = (String)noCfg.elementAt(k);
                String cfgPath = (String)cfgPaths.get(currNode);
                errMsg = s_gMsgBundle.getMessage("1196", true, (Object[])new String[]{cfgPath, currNode});
                ReportUtil.sureprintln(errMsg);
                this.m_resultSet.addResult(currNode, 3);
                this.m_resultSet.addErrorDescription(currNode, new ErrorDescription(errMsg));
                collectionElement = this.m_resultSet.getResult(currNode).getCollectionElements().get(0);
                if (collectionElement == null) continue;
                collectionElement.updateCollectionElement(errMsg);
            }
            for (CollectionElement element : successNodes) {
                element.updateCollectionElement(s_msgBundle.getMessage("5479", true));
                element.setStatus(3);
            }
        }
        if (noTZFile.size() > 0) {
            int nsz = noTZFile.size();
            String tzFileLoc = VerificationUtil.getTZFileLoc();
            String tzFileName = System.getenv("TZ");
            tzFileLoc = tzFileLoc + tzFileName;
            for (int k = 0; k < nsz; ++k) {
                String currNode = (String)noTZFile.elementAt(k);
                this.m_resultSet.addResult(currNode, 3);
                String errMsg = s_msgBundle.getMessage("5498", true, (Object[])new String[]{tzFileLoc, currNode});
                ErrorDescription ed2 = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(currNode, ed2);
                ReportUtil.sureprintln(errMsg);
                collectionElement = this.m_resultSet.getResult(currNode).getCollectionElements().get(0);
                if (collectionElement == null) continue;
                collectionElement.updateCollectionElement(errMsg);
            }
            for (CollectionElement element : successNodes) {
                element.updateCollectionElement(s_msgBundle.getMessage("5479", true));
                element.setStatus(3);
            }
        }
        if (noTZCfg.size() > 0) {
            int nsz = noTZCfg.size();
            if (nsz == this.m_nodeList.length) {
                this.m_resultSet.addResult(this.m_nodeList, 1);
            } else {
                for (int k = 0; k < nsz; ++k) {
                    String currNode = (String)noTZCfg.elementAt(k);
                    String cfgPath = (String)cfgPaths.get(currNode);
                    this.m_resultSet.addResult(currNode, 3);
                    String errMsg = s_msgBundle.getMessage("5478", true, (Object[])new String[]{cfgPath, currNode});
                    ed = new ErrorDescription(errMsg);
                    this.m_resultSet.addErrorDescription(currNode, ed);
                    ReportUtil.sureprintln(errMsg);
                    collectionElement = this.m_resultSet.getResult(currNode).getCollectionElements().get(0);
                    if (collectionElement == null) continue;
                    collectionElement.updateCollectionElement(errMsg);
                }
                for (CollectionElement element : successNodes) {
                    element.updateCollectionElement(s_msgBundle.getMessage("5479", true));
                    element.setStatus(3);
                }
            }
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1001", false, (Object[])new String[]{this.getDefaultElementName()}));
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1003", false, (Object[])new String[]{this.getDefaultElementName()}));
        return false;
    }

    private Hashtable getCfgPath(String crsHome) {
        Hashtable<String, String> cfgFiles = new Hashtable<String, String>();
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            String hostName = VerificationUtil.getNodeName(this.m_nodeList[i]);
            cfgFiles.put(this.m_nodeList[i], crsHome + "/crs/install/s_crsconfig_" + hostName + "_env.txt");
        }
        return cfgFiles;
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("5483", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("5484", false);
    }
}

