/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Vector;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.Constraint;
import oracle.ops.verification.framework.config.ConstraintDataSegment;
import oracle.ops.verification.framework.config.InvalidConstraintDataException;
import oracle.ops.verification.framework.config.InvalidDataSegmentException;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.config.VerificationDataManager;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskSystemRequirements
extends Task {
    private String m_product;
    private String m_release;
    private String[] m_CFSstorageLocation;
    private String m_OCRlocation;
    private String m_VdiskLocation;
    private String m_CRSHomeLocation;
    private String m_OracleHomeLocation;

    public TaskSystemRequirements(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskSystemRequirements(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskSystemRequirements(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setCFSstorageLocation(String[] cfsStorageLocation) {
        this.m_CFSstorageLocation = cfsStorageLocation;
    }

    public void setCRSHomeLocation(String crsHomeLocation) {
        this.m_CRSHomeLocation = crsHomeLocation;
    }

    public void setOracleHomeLocation(String oracleHomeLocation) {
        this.m_OracleHomeLocation = oracleHomeLocation;
    }

    public void setOCRlocation(String ocrLocation) {
        this.m_OCRlocation = ocrLocation;
    }

    public void setVdiskLocation(String vdiskLocation) {
        this.m_VdiskLocation = vdiskLocation;
    }

    public void setProduct(String product) {
        this.m_product = product;
    }

    public void setRelease(String release) {
        this.m_release = release;
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing System Requirements Verification Task... ");
        VerificationDataManager vdm = VerificationDataManager.getInstance();
        boolean anyFailure = false;
        if (this.m_product == null || this.m_product.trim().length() <= 0) {
            Trace.out((String)"==== ERROR: Null or empty product-name ====");
            String failMsg = s_msgBundle.getMessage("4701", false);
            ReportUtil.sureprintln(failMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(failMsg));
            return false;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4700", false) + " '" + this.m_product + "'...");
        String branchName = this.m_product.equals("crs") ? VDMUtil.getSysReqBranchNameForCrs() : VDMUtil.getSysReqBranchNameForDatabase();
        try {
            ConstraintDataSegment cds = (ConstraintDataSegment)vdm.getDataSegment("constraint_data");
            if (cds == null) {
                Trace.out((String)"==== ERROR: NULL CDS returned from VDM");
                ReportUtil.sureprintln(s_msgBundle.getMessage("4703", false));
                this.m_resultSet.addResult(this.m_nodeList, 2);
                return false;
            }
            Vector constraints = cds.getBranch(branchName);
            if (constraints == null) {
                Trace.out((String)"No checks registered for this product.");
                ReportUtil.sureprintln(s_msgBundle.getMessage("4702", false));
                this.m_resultSet.addResult(this.m_nodeList, 2);
                return false;
            }
            for (int i = 0; i < constraints.size(); ++i) {
                ResultSet rsltSet = new ResultSet();
                Constraint con = (Constraint)constraints.elementAt(i);
                Trace.out((String)("About to apply constraint: " + con));
                boolean conStatus = con.applyConstraint(this.m_nodeList, rsltSet);
                if (rsltSet.getStatus() != 1) {
                    anyFailure = true;
                }
                this.m_resultSet.addResultSetData(rsltSet);
                con.report(rsltSet);
            }
        }
        catch (InvalidDataSegmentException e) {
            Trace.stackTrace((Throwable)e);
            ReportUtil.sureprintln("ERROR: " + e.getMessage());
            anyFailure = true;
        }
        catch (InvalidConstraintDataException e) {
            Trace.stackTrace((Throwable)e);
            ReportUtil.sureprintln("ERROR: " + e.getMessage());
            anyFailure = true;
        }
        ReportUtil.sureblankln();
        if (!anyFailure) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("4704", false) + " '" + this.m_product + "'");
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("4705", false) + " '" + this.m_product + "'");
        }
        return !anyFailure;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4435", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4486", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        sb.append("\n    Product: " + this.m_product);
        sb.append("\n    Release: " + this.m_release);
        sb.append("\n    CFSstorageLocation: " + VerificationUtil.strArr2List(this.m_CFSstorageLocation));
        sb.append("\n    OCRLocation: " + this.m_OCRlocation);
        sb.append("\n    CRSHomeLocation: " + this.m_CRSHomeLocation);
        sb.append("\n    OracleHomeLocation: " + this.m_OracleHomeLocation);
        return sb.toString();
    }
}

