/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.database.DatabaseConnectInfo;
import oracle.jdbc.driver.OracleConnection;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.DatabaseTask;
import oracle.ops.verification.framework.engine.task.DatabaseTaskException;
import oracle.ops.verification.framework.report.ReportUtil;

public class TaskStaleSchema
extends DatabaseTask {
    private static final String m_procQuery = "BEGIN StaleSchemaStats(); END;";
    private static final String m_query = "SELECT value FROM cvu_results WHERE test = 'StaleSchemaStats' AND key = 'StaleSchemas'";

    public TaskStaleSchema(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        super.init();
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return this.m_isDBInfoInitialized;
    }

    public TaskStaleSchema(Version crsVer, Collection<DatabaseConnectInfo> dbConInfo) {
        super(crsVer, dbConInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean performTask() {
        boolean retVal = true;
        Trace.out((String)"Performing shared Stale Schema check...");
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11142", false));
        this.m_resultSet.setStatus(1);
        for (String database : this.databases()) {
            String errMsg;
            String staleSchemas;
            block12: {
                DatabaseTaskException ex = null;
                staleSchemas = null;
                try {
                    OracleConnection conn = this.getConnection(database);
                    CallableStatement cstmt = conn.prepareCall(m_procQuery);
                    cstmt.executeQuery();
                    Statement stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery(m_query);
                    if (rs.next()) {
                        staleSchemas = rs.getString(1);
                    }
                    rs.close();
                    stmt.close();
                    cstmt.close();
                    if (ex == null) break block12;
                }
                catch (DatabaseTaskException exDT) {
                    block13: {
                        ex = exDT;
                        Trace.out((String)("DatabaseTaskException whilee checking for stale schemas stats in the daatabase " + database + ". message :" + exDT.getMessage()));
                        if (ex == null) break block13;
                        errMsg = s_gMsgBundle.getMessage("11143", true);
                        errMsg = errMsg + LSEP + ((Throwable)ex).getMessage();
                        ReportUtil.sureprintln(errMsg);
                        this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                        this.m_resultSet.setStatus(2);
                        retVal = false;
                        continue;
                    }
                    if (staleSchemas == null || staleSchemas.length() <= 0) continue;
                    errMsg = s_gMsgBundle.getMessage("11144", true, (Object[])new String[]{staleSchemas, database});
                    ReportUtil.sureprintln(errMsg);
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                    this.m_resultSet.setStatus(3);
                    retVal = false;
                    continue;
                }
                catch (SQLException exSql) {
                    block14: {
                        Trace.out((String)("SQLException while checking for stale schemas stats in the daatabase " + database + ". message :" + exSql.getMessage()));
                        if (ex == null) break block14;
                        {
                            catch (Throwable throwable) {
                                if (ex != null) {
                                    String errMsg2 = s_gMsgBundle.getMessage("11143", true);
                                    errMsg2 = errMsg2 + LSEP + ((Throwable)ex).getMessage();
                                    ReportUtil.sureprintln(errMsg2);
                                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg2));
                                    this.m_resultSet.setStatus(2);
                                    retVal = false;
                                } else if (staleSchemas != null && staleSchemas.length() > 0) {
                                    String errMsg3 = s_gMsgBundle.getMessage("11144", true, (Object[])new String[]{staleSchemas, database});
                                    ReportUtil.sureprintln(errMsg3);
                                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg3));
                                    this.m_resultSet.setStatus(3);
                                    retVal = false;
                                }
                                throw throwable;
                            }
                        }
                        errMsg = s_gMsgBundle.getMessage("11143", true);
                        errMsg = errMsg + LSEP + ((Throwable)ex).getMessage();
                        ReportUtil.sureprintln(errMsg);
                        this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                        this.m_resultSet.setStatus(2);
                        retVal = false;
                        continue;
                    }
                    if (staleSchemas == null || staleSchemas.length() <= 0) continue;
                    errMsg = s_gMsgBundle.getMessage("11144", true, (Object[])new String[]{staleSchemas, database});
                    ReportUtil.sureprintln(errMsg);
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                    this.m_resultSet.setStatus(3);
                    retVal = false;
                    continue;
                }
                errMsg = s_gMsgBundle.getMessage("11143", true);
                errMsg = errMsg + LSEP + ((Throwable)ex).getMessage();
                ReportUtil.sureprintln(errMsg);
                this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                this.m_resultSet.setStatus(2);
                retVal = false;
                continue;
            }
            if (staleSchemas == null || staleSchemas.length() <= 0) continue;
            errMsg = s_gMsgBundle.getMessage("11144", true, (Object[])new String[]{staleSchemas, database});
            ReportUtil.sureprintln(errMsg);
            this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
            this.m_resultSet.setStatus(3);
            retVal = false;
        }
        if (retVal) {
            Trace.out((String)"Check for stale database schema stats passed.");
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11145", false));
            this.m_resultSet.setStatus(1);
        }
        return retVal;
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11141", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11140", false);
    }
}

