/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.impl.verification.VerificationFileInfoImpl;
import oracle.cluster.verification.CollectionResultSet;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationFileInfo;
import oracle.cluster.verification.database.DatabaseEdition;
import oracle.cluster.verification.util.CollectionGroup;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.DatabaseInfo;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.CollectionResultImpl;
import oracle.ops.verification.framework.engine.CollectionResultSetImpl;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.CompSoftwareConfigLoader;
import oracle.ops.verification.framework.engine.task.CompSoftwareConfigLoaderException;
import oracle.ops.verification.framework.engine.task.CompsXMLParser;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.VerifyStorage;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.ClusterwareUtil;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class TaskSoftwareDistribution
extends Task {
    private static final String DATABASE_COMPONENT = "database";
    private static final String FILE_STATUS_FAILED = "1";
    private String m_softwareComponent;
    private String m_softwareComponentHome;
    private String m_configFile;
    private String m_release;
    private boolean m_verifyAll = false;
    private static final String HAS_USER = "HAS_USER";
    private static final String SUPERUSER = "SUPERUSER";
    private static final String SUPERUSER_VALUE = "root";
    private static final String SUPERUSER_GROUP_VALUE_AIX = "system";
    private static final String ORACLE_OWNER = "ORACLE_OWNER";
    private CollectionResultSetImpl<List<VerificationFileInfo>> m_rsetFileInfo;
    private Properties crsConfigVariables = new Properties();
    private boolean crsConfigDefsLoaded = false;
    private static final String ORACLE_BASE_VAR = "ORACLE_BASE";
    private Pattern instatiatedVariablePattern = Pattern.compile("([^%]*)%([^%]+)%(.*)");
    private Pattern envVariablePattern = Pattern.compile("([^$]*)\\$([^/$]+)(.*)");

    public TaskSoftwareDistribution(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("COMPONENT".equals(argName)) {
                if ("CRS".equalsIgnoreCase(argVal)) {
                    this.m_softwareComponent = "crs";
                    this.m_softwareComponentHome = this.m_globalContext.getCRSHome();
                    this.m_release = VerificationUtil.getCRSActiveVersion();
                    this.m_collectionGroup = CollectionGroup.CRS_SOFTWARE_COLLECTION;
                    if (VerificationUtil.isCVUResource()) continue;
                    this.setAll(!"true".equalsIgnoreCase(CVUVariables.getValue(CVUVariableConstants.BASELINE_COLLECT_BIN_LIB_FILES)));
                    continue;
                }
                if (!"DATABASE".equalsIgnoreCase(argVal)) continue;
                this.m_softwareComponent = DATABASE_COMPONENT;
                this.m_softwareComponentHome = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
                this.m_release = CVUVariables.getValue(CVUVariableConstants.RAC_VERSION);
                this.m_collectionGroup = CollectionGroup.DB_SOFTWARE_COLLECTION;
                if (VerificationUtil.isCVUResource()) continue;
                this.setAll(!"true".equalsIgnoreCase(CVUVariables.getValue(CVUVariableConstants.BASELINE_COLLECT_BIN_LIB_FILES)));
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
        switch (this.m_globalContext.getVerificationType()) {
            case COMPONENT_SOFTWARE: {
                Trace.out((String)"Comp Software scenario, initiliazing accordingly");
                this.initForCompSoftware();
            }
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        switch (this.m_globalContext.getVerificationType()) {
            case COMPONENT_SOFTWARE: {
                Trace.out((String)("Software component check, returning " + VerificationUtil.isStringGood(this.m_softwareComponentHome)));
                return VerificationUtil.isStringGood(this.m_softwareComponentHome);
            }
        }
        return VerificationUtil.isStringGood(this.m_softwareComponentHome) && (VerificationUtil.isBaselineCollectionMode() || VerificationUtil.isCVUResource());
    }

    private void initForCompSoftware() {
        ParamManager paramManager = this.m_globalContext.getParamManager();
        String product = null;
        String productHome = null;
        String requestedRelease = null;
        boolean m_all = paramManager.checkArgAllSoftware();
        String oracleHome = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
        Trace.out((String)("==== ParamManager reports Oracle Home as: " + oracleHome));
        if (VerificationUtil.isStringGood(oracleHome)) {
            product = DATABASE_COMPONENT;
            productHome = oracleHome;
        } else {
            boolean haConfigured = VerificationUtil.isHAConfigured();
            product = haConfigured ? "ha" : "crs";
            productHome = haConfigured ? VerificationUtil.getHAHome() : VerificationUtil.getCRSHome();
            requestedRelease = this.m_globalContext.getRequestedRelease();
        }
        if (VerificationUtil.isHAConfigured()) {
            this.setNodeList(new String[]{VerificationUtil.getLocalNode()});
        } else {
            ResultSet crsResultSet = new ResultSet();
            List<String> crsConfigNodes = ClusterwareUtil.getCRSConfiguredNodes(this.m_nodeList, crsResultSet);
            this.m_resultSet.addResultSetData(crsResultSet);
            ArrayList<String> succNodes = new ArrayList<String>(crsResultSet.getSuccessfulNodes());
            if (succNodes.size() != crsConfigNodes.size()) {
                succNodes.removeAll(crsConfigNodes);
                ArrayList<String> crsNotConfigNodes = succNodes;
                String errMsg = s_gMsgBundle.getMessage("13400", true, (Object[])new String[]{VerificationUtil.strList2List(crsNotConfigNodes)});
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(crsNotConfigNodes, errDesc);
                this.m_resultSet.addResult(crsNotConfigNodes, 3);
            }
            this.setNodeList(crsConfigNodes.toArray(new String[crsConfigNodes.size()]));
        }
        this.setSoftwareComponent(product);
        this.setSoftwareComponentHome(productHome);
        this.setRelease(requestedRelease);
        this.setAll(m_all);
    }

    public TaskSoftwareDistribution(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskSoftwareDistribution(String[] nodeList, String configFile, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskSoftwareDistribution(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Performing Software verification task... ");
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4375", false));
        this.performSoftwareChecks();
        this.populateCollectionResulSet();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4376", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4377", false));
        return false;
    }

    private void performSoftwareChecks() {
        Hashtable nodeFileHT;
        Result result;
        Hashtable fileInforResultTable;
        String[] validNodeList = this.m_nodeList;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        HashMap compFileList = null;
        DatabaseEdition databaseEdition = DatabaseEdition.STANDARD_EDITION;
        ArrayList<String> homeFiles = new ArrayList<String>();
        ArrayList<String> oracleBaseFiles = new ArrayList<String>();
        ArrayList<String> hostSpecificFiles = new ArrayList<String>();
        Hashtable<String, FileInfo> referenceFileInfoHT = new Hashtable<String, FileInfo>();
        try {
            this.m_configFile = VerificationUtil.getCompSoftwareConfigXmlPath(this.m_softwareComponentHome, this.m_release);
            File softwareConfigFile = new File(this.m_configFile);
            if (!softwareConfigFile.exists()) {
                this.m_configFile = VerificationUtil.getCompSoftwareConfigXmlPath(this.m_release);
            }
            if (DATABASE_COMPONENT.equals(this.m_softwareComponent)) {
                DBUtils dbUtils = new DBUtils(VerificationUtil.getCRSActiveVersionObj());
                List<DatabaseInfo> dbInfoList = null;
                String[] nodesDBHome = null;
                try {
                    dbInfoList = dbUtils.getDatabaseInfos();
                    String canonicalHome = this.m_softwareComponentHome;
                    try {
                        canonicalHome = new File(canonicalHome).getCanonicalPath();
                    }
                    catch (IOException e) {
                        Trace.out((String)("Ignored IOException '" + e.getMessage() + "' while trying to get canonical path for dbhome " + canonicalHome));
                        canonicalHome = this.m_softwareComponentHome;
                    }
                    HashSet<String> dbNodes = new HashSet<String>();
                    for (DatabaseInfo dbInfo : dbInfoList) {
                        try {
                            if ((!nativeSys.isUnixSystem() || !canonicalHome.equals(new File(dbInfo.getHome()).getCanonicalPath())) && (nativeSys.isUnixSystem() || !canonicalHome.equalsIgnoreCase(new File(dbInfo.getHome()).getCanonicalPath()))) continue;
                            dbNodes.addAll(Arrays.asList(dbUtils.getNodes(dbInfo.getUniqueName())));
                        }
                        catch (IOException e) {
                            Trace.out((String)("Ignored IOException '" + e.getMessage() + "' while trying to get canonical path for dbhome " + dbInfo.getHome()));
                        }
                    }
                    nodesDBHome = dbNodes.toArray(new String[0]);
                    if (nodesDBHome == null || nodesDBHome.length == 0) {
                        ResultSet homeValidationRS = new ResultSet();
                        VerificationUtil.validateOracleHome(validNodeList, this.m_softwareComponentHome, homeValidationRS);
                        this.m_resultSet.addResultSetData(homeValidationRS);
                        List<String> succNodes = homeValidationRS.getSuccessfulNodes();
                        List<String> failNodes = homeValidationRS.getFailedNodes();
                        if (succNodes.size() == 0) {
                            List<VerificationError> errors = homeValidationRS.getErrors();
                            for (VerificationError error : errors) {
                                ReportUtil.printError(error.getErrorMessage());
                            }
                            ReportUtil.processAlert(s_msgBundle.getMessage("0007", false));
                            return;
                        }
                        if (failNodes.size() > 0) {
                            this.m_resultSet.addResult(failNodes, 3);
                            List<VerificationError> errors = homeValidationRS.getErrors();
                            for (VerificationError error : errors) {
                                ReportUtil.printError(error.getErrorMessage());
                            }
                            for (String node : failNodes) {
                                List<VerificationError> nodeErrors = homeValidationRS.getResult(node).getErrors();
                                for (VerificationError error : nodeErrors) {
                                    ReportUtil.printError(error.getErrorMessage());
                                }
                            }
                            validNodeList = succNodes.toArray(new String[0]);
                            ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                            ReportUtil.sureprintNodelist(succNodes);
                        }
                    } else {
                        ArrayList<String> tmpNodesDB = new ArrayList<String>(Arrays.asList(validNodeList));
                        ArrayList<String> tmpNodesNA = new ArrayList<String>(Arrays.asList(validNodeList));
                        tmpNodesDB.retainAll(Arrays.asList(nodesDBHome));
                        tmpNodesNA.removeAll(Arrays.asList(nodesDBHome));
                        if (tmpNodesNA.size() > 0) {
                            this.m_resultSet.addResult(tmpNodesNA.toArray(new String[0]), 6);
                            ReportUtil.sureblankln();
                            ReportUtil.printWarning(s_gMsgBundle.getMessage("11937", true, (Object[])new String[]{VerificationUtil.strCollection2String(tmpNodesNA)}));
                            ReportUtil.sureblankln();
                            if (tmpNodesDB.size() > 0) {
                                ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                                ReportUtil.sureprintNodelist(tmpNodesDB);
                            }
                        }
                        if (tmpNodesDB.size() == 0) {
                            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11938", true));
                            ReportUtil.processAlert(s_msgBundle.getMessage("0007", false));
                            return;
                        }
                        validNodeList = tmpNodesDB.toArray(new String[0]);
                    }
                    databaseEdition = dbUtils.getDatabaseEdition(this.m_softwareComponentHome, validNodeList[0]);
                }
                catch (DBUtilsException dbue) {
                    Trace.out((String)("Encountered DBUtilsException while retrieving database configurations:" + dbue.getMessage()));
                    ReportUtil.printWarning(s_gMsgBundle.getMessage("5013", false, (Object[])new String[]{this.m_softwareComponentHome}));
                }
            }
            Trace.out((String)("release[" + this.m_release + "]"));
            List<String> componentsCompsXml = null;
            CompSoftwareConfigLoader loader = null;
            if (!VerificationUtil.isCVUTestEnv()) {
                CompsXMLParser compsParser = new CompsXMLParser(this.m_softwareComponentHome);
                componentsCompsXml = compsParser.parse();
                loader = new CompSoftwareConfigLoader(this.m_configFile, this.m_softwareComponent, databaseEdition, componentsCompsXml);
            } else {
                loader = new CompSoftwareConfigLoader(this.m_configFile, this.m_softwareComponent, databaseEdition);
            }
            compFileList = loader.load(this.m_verifyAll);
            boolean haCompFound = false;
            for (String compName : compFileList.keySet()) {
                if (!"ha".equalsIgnoreCase(compName)) continue;
                haCompFound = true;
                break;
            }
            Iterator compIter = compFileList.keySet().iterator();
            while (compIter.hasNext()) {
                String comp = compIter.next().toString();
                if (this.m_softwareComponent != null) {
                    if (this.m_softwareComponent.equalsIgnoreCase("ha") && !haCompFound && !"crs".equalsIgnoreCase(comp)) {
                        Trace.out((String)("Check for component " + this.m_softwareComponent + " requested. HACopmpFound = " + haCompFound + ". Skipping files for component: " + comp));
                        continue;
                    }
                    if (!this.m_softwareComponent.equalsIgnoreCase(comp)) {
                        Trace.out((String)("Check for component " + this.m_softwareComponent + " requested. Skipping files for component: " + comp));
                        continue;
                    }
                }
                List fileList = (List)compFileList.get(comp);
                Iterator fileListIterator = fileList.iterator();
                boolean oracleBaseFile = false;
                while (fileListIterator.hasNext()) {
                    FileInfo file = (FileInfo)fileListIterator.next();
                    String fileName = file.getFileName();
                    oracleBaseFile = fileName.contains(ORACLE_BASE_VAR);
                    String refOwner = file.getFileOwner();
                    String refGroup = file.getFileGroup();
                    if (this.containsVariables(refOwner)) {
                        refOwner = this.resolveVariables(refOwner);
                    }
                    if (this.containsVariables(refGroup)) {
                        refGroup = refGroup.contains(SUPERUSER) && VerificationUtil.isPlatformAix() ? SUPERUSER_GROUP_VALUE_AIX : this.resolveVariables(refGroup);
                    }
                    file.setFileOwner(refOwner);
                    file.setFileGroup(refGroup);
                    String hostKey = "%HOST%";
                    if (fileName.contains("$HOST") || fileName.contains("%HOST%")) {
                        hostKey = fileName.contains("$HOST") ? "$HOST" : hostKey;
                        fileName = fileName.replaceAll(Pattern.quote(hostKey), "#HOST#");
                    }
                    if (this.containsVariables(fileName)) {
                        fileName = this.resolveVariables(fileName);
                    }
                    if (fileName == null || this.containsVariables(fileName) || this.containsVariables(refOwner) || this.containsVariables(refGroup)) {
                        Trace.out((int)5, (String)"File name=%s, owner=%s ,group=%s will not be checked because either the filename or the reference owner or the reference group has unresolved variables ", (Object[])new Object[]{fileName, refOwner, refGroup});
                        fileListIterator.remove();
                        continue;
                    }
                    if (fileName.contains("#HOST#") || new File(fileName).isAbsolute()) {
                        if (!new File(fileName = fileName.replaceAll("#HOST#", hostKey)).isAbsolute()) {
                            fileName = this.m_softwareComponentHome + File.separator + fileName;
                        }
                        file.setFileName(fileName);
                        hostSpecificFiles.add(file.getFileName());
                    } else if (oracleBaseFile) {
                        file.setFileName(fileName);
                        oracleBaseFiles.add(file.getFileName());
                    } else if (!new File(fileName).isAbsolute()) {
                        fileName = this.m_softwareComponentHome + File.separator + fileName;
                        file.setFileName(fileName);
                        homeFiles.add(file.getFileName());
                    }
                    referenceFileInfoHT.put(fileName, file);
                }
            }
        }
        catch (CompSoftwareConfigLoaderException e) {
            this.m_resultSet.addResult(validNodeList, 2);
            ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("5000", false));
            this.m_resultSet.addErrorDescription(validNodeList, errorDesc);
            ReportUtil.printError(e.getMessage());
            Trace.out((String)("==== Error while reading software distribution configuration: " + e));
            return;
        }
        catch (IOException e) {
            this.m_resultSet.addResult(validNodeList, 2);
            ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("5000", false));
            this.m_resultSet.addErrorDescription(validNodeList, errorDesc);
            ReportUtil.printError(e.getMessage());
            Trace.out((String)("==== Error while reading software distribution configuration: " + e));
            return;
        }
        catch (XmlFilePathException e) {
            this.m_resultSet.addResult(validNodeList, 2);
            ErrorDescription errorDesc = new ErrorDescription(e.getMessage());
            this.m_resultSet.addErrorDescription(validNodeList, errorDesc);
            ReportUtil.printError(e.getMessage());
            Trace.out((String)("==== Error while reading software distribution configuration: " + e));
            return;
        }
        Trace.out((int)1, (String)"Number of home files found = %d", (Object[])new Object[]{homeFiles.size()});
        Trace.out((int)1, (String)"Number of oracle base files found = %d", (Object[])new Object[]{oracleBaseFiles.size()});
        Trace.out((int)1, (String)"Number of host specific files found = %d", (Object[])new Object[]{hostSpecificFiles.size()});
        ArrayList<String> sharedFileList = new ArrayList<String>();
        boolean homeShared = false;
        try {
            if (validNodeList.length > 1 && new VerifyStorage().isShared(this.m_softwareComponentHome, validNodeList, OracleFileType.RAC_SOFTWARE, this.m_release)) {
                homeShared = true;
                Trace.out((int)1, (String)"Home %s is determined to be shared, files will only be verified on node %s", (Object[])new Object[]{this.m_softwareComponentHome, validNodeList[0]});
            }
        }
        catch (StorageException e) {
            Trace.out((Exception)e);
            homeShared = false;
        }
        catch (MultiNodeException e) {
            Trace.out((Exception)e);
            homeShared = false;
        }
        if (homeShared) {
            sharedFileList.addAll(homeFiles);
        } else {
            hostSpecificFiles.addAll(homeFiles);
        }
        if (oracleBaseFiles.size() > 0) {
            boolean oracleBaseShared = false;
            try {
                String oracleBase = this.resolveEnvVariables(ORACLE_BASE_VAR);
                Trace.out((int)1, (String)"ORACLE_BASE resolved to %s", (Object[])new Object[]{oracleBase});
                if (validNodeList.length > 1 && new VerifyStorage().isShared(oracleBase, validNodeList, OracleFileType.RAC_SOFTWARE, this.m_release)) {
                    oracleBaseShared = true;
                    Trace.out((int)1, (String)"Oracle base %s is determined to be shared, files will only be verified on node %s", (Object[])new Object[]{oracleBase, validNodeList[0]});
                }
            }
            catch (StorageException e) {
                Trace.out((Exception)e);
                oracleBaseShared = false;
            }
            catch (MultiNodeException e) {
                Trace.out((Exception)e);
                oracleBaseShared = false;
            }
            catch (IOException e) {
                Trace.out((Exception)e);
                oracleBaseShared = false;
            }
            if (oracleBaseShared) {
                sharedFileList.addAll(oracleBaseFiles);
            } else {
                hostSpecificFiles.addAll(oracleBaseFiles);
            }
        }
        GlobalExecution globalExec = new GlobalExecution();
        Hashtable<String, Hashtable<String, FileInfo>> nodeExecTaskValues = new Hashtable<String, Hashtable<String, FileInfo>>();
        ArrayList<String> refFileList = new ArrayList<String>();
        Trace.out((int)1, (String)"Total number of shared files to be verified = %d", (Object[])new Object[]{sharedFileList.size()});
        Trace.out((int)1, (String)"Total umber of host specific files to be verified = %d", (Object[])new Object[]{hostSpecificFiles.size()});
        if (sharedFileList.size() > 0) {
            ResultSet sharedFilesRS = new ResultSet();
            boolean fileInfoResult = globalExec.getFileInfo(new String[]{validNodeList[0]}, sharedFileList, sharedFilesRS);
            this.m_resultSet.addResultSetData(sharedFilesRS);
            if (!fileInfoResult) {
                ReportUtil.printError(s_msgBundle.getMessage("4160", false));
                this.m_resultSet.addResult(validNodeList, 2);
            } else {
                refFileList.addAll(sharedFileList);
                fileInforResultTable = sharedFilesRS.getResultTable();
                for (String node : this.m_nodeList) {
                    result = (Result)fileInforResultTable.get(node);
                    if (result == null || result.getStatus() != 1) continue;
                    nodeFileHT = (Hashtable)result.getResultInfoSet().elementAt(0);
                    for (String sharingNode : validNodeList) {
                        nodeExecTaskValues.put(sharingNode, nodeFileHT);
                    }
                }
            }
        }
        if (hostSpecificFiles.size() > 0) {
            ResultSet hostSpecificFilesRS = new ResultSet();
            boolean fileInfoResult = globalExec.getFileInfo(validNodeList, hostSpecificFiles, hostSpecificFilesRS);
            this.m_resultSet.addResultSetData(hostSpecificFilesRS);
            if (!fileInfoResult) {
                ReportUtil.printError(s_msgBundle.getMessage("4160", false));
                this.m_resultSet.addResult(validNodeList, 2);
            } else {
                refFileList.addAll(hostSpecificFiles);
                fileInforResultTable = hostSpecificFilesRS.getResultTable();
                for (String node : this.m_nodeList) {
                    result = (Result)fileInforResultTable.get(node);
                    if (result == null || result.getStatus() != 1) continue;
                    nodeFileHT = (Hashtable)result.getResultInfoSet().elementAt(0);
                    nodeExecTaskValues.put(node, nodeFileHT);
                }
            }
        }
        this.reportResults(refFileList, referenceFileInfoHT, nodeExecTaskValues);
        if (!DATABASE_COMPONENT.equals(this.m_softwareComponent) && (VerificationUtil.isBaselineCollectionMode() || VerificationUtil.isCVUResource())) {
            this.collectCriticalFilesAndDirsBaseline(validNodeList);
        }
    }

    private void collectCriticalFilesAndDirsBaseline(String[] validNodeList) {
        String criticalFilesAndDirsStr = VDMUtil.getCriticalFilesAndDirsToBeBaselined();
        if (!VerificationUtil.isStringGood(criticalFilesAndDirsStr)) {
            Trace.out((String)"No critical files/directories defined in admin.xml, skipping collection");
            return;
        }
        Trace.out((String)("collecting baseline for critical files, directories and files under them: " + criticalFilesAndDirsStr));
        String[] criticalFilesAndDirsArray = criticalFilesAndDirsStr.split(",");
        ArrayList<String> criticalDirectoriesList = new ArrayList<String>();
        for (String fileName : criticalFilesAndDirsArray) {
            String hostKey = "%HOST%";
            if (fileName.contains("$HOST") || fileName.contains("%HOST%")) {
                hostKey = fileName.contains("$HOST") ? "$HOST" : hostKey;
                fileName = fileName.replaceAll(Pattern.quote(hostKey), "#HOST#");
            }
            if (this.containsVariables(fileName)) {
                try {
                    fileName = this.resolveVariables(fileName);
                }
                catch (IOException e) {
                    this.m_resultSet.addResult(validNodeList, 2);
                    ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("5000", false));
                    this.m_resultSet.addErrorDescription(validNodeList, errorDesc);
                    ReportUtil.printError(e.getMessage());
                    Trace.out((String)("==== Error while reading software distribution configuration: " + e));
                    return;
                }
            }
            if (fileName == null || this.containsVariables(fileName)) {
                Trace.out((int)5, (String)("File name=" + fileName + " will not be collected because the filename has unresolved variables"));
                continue;
            }
            if (fileName.contains("#HOST#") || new File(fileName).isAbsolute()) {
                fileName = fileName.replaceAll("#HOST#", hostKey);
            }
            criticalDirectoriesList.add(fileName);
        }
        ResultSet criticalDirectoriesRS = new ResultSet();
        boolean fileInfoResult = new GlobalExecution().getFileInfo(validNodeList, criticalDirectoriesList, true, criticalDirectoriesRS);
        this.m_resultSet.addResultSetData(criticalDirectoriesRS);
        if (!fileInfoResult) {
            ReportUtil.printError(s_msgBundle.getMessage("4160", false));
            this.m_resultSet.addResult(validNodeList, 2);
        } else {
            Hashtable fileInforResultTable = criticalDirectoriesRS.getResultTable();
            for (String node : this.m_nodeList) {
                Result result = (Result)fileInforResultTable.get(node);
                if (result == null || result.getStatus() != 1) continue;
                Hashtable nodeFileHT = (Hashtable)result.getResultInfoSet().elementAt(0);
                for (String fileName : nodeFileHT.keySet()) {
                    FileInfo nodeFileInfo = (FileInfo)nodeFileHT.get(fileName);
                    CollectionElement fileCollectionElement = new CollectionElement(fileName, null, null, null, fileName, 1);
                    CollectionElement ownerCollectionElement = new CollectionElement(ReportUtil.OWNER, nodeFileInfo.getFileOwner(), null, null, null, 1);
                    CollectionElement groupCollectionElement = new CollectionElement(ReportUtil.GROUP, nodeFileInfo.getFileGroup(), null, null, null, 1);
                    CollectionElement permissionsCollectionElement = new CollectionElement(ReportUtil.PERMISSION, nodeFileInfo.getFilePermissions(), null, null, null, 1);
                    fileCollectionElement.addChild(ownerCollectionElement);
                    fileCollectionElement.addChild(groupCollectionElement);
                    fileCollectionElement.addChild(permissionsCollectionElement);
                    this.m_resultSet.addCollectionElement(node, fileCollectionElement);
                }
            }
        }
    }

    private boolean containsVariables(String str) {
        if (!VerificationUtil.isStringGood(str)) {
            return false;
        }
        return this.instatiatedVariablePattern.matcher(str).matches() || this.envVariablePattern.matcher(str).matches();
    }

    private String resolveVariables(String str) throws IOException {
        if (!VerificationUtil.isStringGood(str)) {
            return str;
        }
        String returnValue = str;
        if (this.instatiatedVariablePattern.matcher(returnValue).matches()) {
            returnValue = this.resolveInstantaitedVariables(str);
        }
        if (!VerificationUtil.isStringGood(returnValue)) {
            return returnValue;
        }
        if (this.envVariablePattern.matcher(returnValue).matches()) {
            returnValue = this.resolveEnvVariables(returnValue);
        }
        return returnValue;
    }

    private String resolveInstantaitedVariables(String fileName) {
        String returnValue;
        block7: {
            if (fileName == null) {
                return null;
            }
            returnValue = null;
            try {
                Matcher m = this.instatiatedVariablePattern.matcher(fileName);
                if (m.matches()) {
                    while (m.matches()) {
                        returnValue = m.group(1);
                        String resolvableVar = m.group(2);
                        String resolvedValue = this.resolveEnvVariables(resolvableVar);
                        if (resolvedValue == null) {
                            returnValue = null;
                            break block7;
                        }
                        returnValue = returnValue + resolvedValue;
                        returnValue = returnValue + m.group(3);
                        m = this.instatiatedVariablePattern.matcher(returnValue);
                    }
                    break block7;
                }
                returnValue = fileName;
            }
            catch (Exception e) {
                Trace.out((int)5, (String)"IGNORED EXCEPTION : %s : %s during processing of file %s", (Object[])new Object[]{e.getClass(), e.getMessage(), fileName});
            }
        }
        if (returnValue == null) {
            Trace.out((int)5, (String)"Could not expand filename %s", (Object[])new Object[]{fileName});
        }
        return returnValue;
    }

    private String resolveEnvVariables(String variable) throws IOException {
        String returnValue;
        block12: {
            Object returnValueObject;
            if (!VerificationUtil.isStringGood(variable)) {
                return null;
            }
            if (!this.crsConfigDefsLoaded) {
                this.loadCRSConfigDefs();
            }
            if ((returnValueObject = this.crsConfigVariables.get(variable)) == null) {
                if (HAS_USER.equals(variable)) {
                    returnValueObject = this.m_softwareComponent.equals("ha") ? this.crsConfigVariables.get(ORACLE_OWNER) : SUPERUSER_VALUE;
                } else if (SUPERUSER.equals(variable)) {
                    returnValueObject = SUPERUSER_VALUE;
                } else {
                    return null;
                }
            }
            returnValue = String.valueOf(returnValueObject);
            try {
                Matcher m = this.envVariablePattern.matcher(returnValue);
                if (!m.matches()) break block12;
                while (m.matches()) {
                    returnValue = m.group(1);
                    String resolvableVar = m.group(2);
                    String resolvedValue = this.resolveEnvVariables(resolvableVar);
                    if (resolvedValue == null) {
                        returnValue = null;
                        break;
                    }
                    returnValue = returnValue + resolvedValue;
                    returnValue = returnValue + m.group(3);
                    m = this.envVariablePattern.matcher(returnValue);
                }
            }
            catch (Exception e) {
                Trace.out((int)5, (String)"IGNORED EXCEPTION : %s : %s during processing of variable %s", (Object[])new Object[]{e.getClass(), e.getMessage(), returnValue});
            }
        }
        if (returnValue == null) {
            Trace.out((int)5, (String)"Could not expand variable %s", (Object[])new Object[]{returnValue});
        }
        return returnValue;
    }

    private void loadCRSConfigDefs() throws IOException {
        this.crsConfigDefsLoaded = true;
        String fileName = this.m_softwareComponentHome + File.separator + "crs" + File.separator + "install" + File.separator + "crsconfig_params";
        if (new File(fileName).exists()) {
            this.load(this.crsConfigVariables, fileName);
        }
        if (new File(fileName = this.m_softwareComponentHome + File.separator + "crs" + File.separator + "install" + File.separator + "s_crsconfig_defs").exists()) {
            this.load(this.crsConfigVariables, fileName);
        }
    }

    private void load(Properties prop, String fileName) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        String sCurrentLine = null;
        while ((sCurrentLine = br.readLine()) != null) {
            if ((sCurrentLine = sCurrentLine.trim()).startsWith("#") || !VerificationUtil.isStringGood(sCurrentLine)) continue;
            Pattern nameValue = Pattern.compile("([^=]*)=(.*)");
            Matcher m = nameValue.matcher(sCurrentLine);
            if (m.matches()) {
                prop.put(m.group(1), m.group(2));
                continue;
            }
            prop.put(sCurrentLine, "");
        }
    }

    private void reportResults(List<String> refFileList, Hashtable<String, FileInfo> referenceFileInfoHT, Hashtable<String, Hashtable<String, FileInfo>> nodeExecTaskValues) {
        Hashtable nodeBasedResultTable = new Hashtable();
        for (String refFileName : refFileList) {
            ArrayList mismatchAttributeList;
            FileInfo nodeFileInfo;
            Hashtable<String, String> mismatchAttributeMap;
            ErrorDescription error;
            String errorMessage;
            Hashtable<String, Object> fileTable;
            List<Hashtable<String, Object>> nodeFailedFileList;
            FileInfo refFileInfo = referenceFileInfoHT.get(refFileName);
            String refOwner = refFileInfo.getFileOwner();
            String refGroup = refFileInfo.getFileGroup();
            String refPermissions = refFileInfo.getFilePermissions();
            HashMap<String, ArrayList<String>> fileOwnerMap = new HashMap<String, ArrayList<String>>();
            HashMap fileGroupMap = new HashMap();
            HashMap filePermissionsMap = new HashMap();
            ArrayList<String> successfulNodes = new ArrayList<String>();
            Hashtable referenceAttributeMismatchMap = new Hashtable();
            ArrayList<CollectionElement> fileCollectionElementList = new ArrayList<CollectionElement>();
            ArrayList<CollectionElement> ownerCollectionElementList = new ArrayList<CollectionElement>();
            ArrayList<CollectionElement> groupCollectionElementList = new ArrayList<CollectionElement>();
            ArrayList<CollectionElement> permissionsCollectionElementList = new ArrayList<CollectionElement>();
            for (String node : nodeExecTaskValues.keySet()) {
                List<String> nodeList;
                List<Hashtable<String, String>> mismatchAttributeList2;
                Hashtable<String, String> mismatchAttributeMap2;
                ErrorDescription error2;
                String errorMessage2;
                Hashtable<String, FileInfo> nodeFileInfoTable = nodeExecTaskValues.get(node);
                FileInfo nodeFileInfo2 = nodeFileInfoTable.get(refFileName);
                if (nodeFileInfo2 == null) {
                    Trace.out((int)5, (String)("Could not retrieve nodeFileInfo for file: " + refFileName));
                }
                CollectionElement fileCollectionElement = new CollectionElement(refFileName, null, null, null, refFileName, 1);
                CollectionElement ownerCollectionElement = new CollectionElement(ReportUtil.OWNER, null, null, null, refFileName, 1);
                CollectionElement groupCollectionElement = new CollectionElement(ReportUtil.GROUP, null, null, null, refFileName, 1);
                CollectionElement permissionsCollectionElement = new CollectionElement(ReportUtil.PERMISSION, null, null, null, refFileName, 1);
                fileCollectionElement.addChild(ownerCollectionElement);
                fileCollectionElement.addChild(groupCollectionElement);
                fileCollectionElement.addChild(permissionsCollectionElement);
                fileCollectionElementList.add(fileCollectionElement);
                ownerCollectionElementList.add(ownerCollectionElement);
                groupCollectionElementList.add(groupCollectionElement);
                permissionsCollectionElementList.add(permissionsCollectionElement);
                this.m_resultSet.addCollectionElement(node, fileCollectionElement);
                String referenceValue = null;
                if (refOwner != null) {
                    referenceValue = "Owner=" + (String)refOwner;
                    ownerCollectionElement.setExpectedValue(refOwner);
                }
                if (refGroup != null) {
                    referenceValue = referenceValue != null ? referenceValue + "; Group=" + refGroup : "Group=" + refGroup;
                    groupCollectionElement.setExpectedValue(refGroup);
                }
                if (refPermissions != null) {
                    referenceValue = referenceValue != null ? referenceValue + "; Permissions=" + refPermissions : "Permissions=" + refPermissions;
                    permissionsCollectionElement.setExpectedValue(refPermissions);
                }
                if (referenceValue == null) {
                    referenceValue = "EXISTS";
                }
                fileCollectionElement.setExpectedValue(referenceValue);
                if (nodeFileInfo2 == null || FILE_STATUS_FAILED.equals(nodeFileInfo2.getStatus())) {
                    nodeFailedFileList = (List)nodeBasedResultTable.get(node);
                    if (nodeFailedFileList == null) {
                        nodeFailedFileList = new ArrayList();
                        nodeBasedResultTable.put(node, nodeFailedFileList);
                    }
                    fileTable = new Hashtable();
                    fileTable.put("FILE_NAME", refFileName);
                    String errorString = nodeFileInfo2 != null ? nodeFileInfo2.getErrorString() : ReportUtil.NOT_APPLICABLE;
                    fileTable.put("ERROR", errorString);
                    nodeFailedFileList.add(fileTable);
                    this.m_resultSet.addResult(node, 3);
                    fileCollectionElement.setStatus(3);
                    ErrorDescription error3 = new ErrorDescription(s_msgBundle.getMessage("5003", false, (Object[])new String[]{refFileName, node, errorString}));
                    this.m_resultSet.addErrorDescription(node, error3);
                    fileCollectionElement.addErrorDescription(error3);
                    continue;
                }
                String nodeValue = "Owner=" + nodeFileInfo2.getFileOwner() + "; Group=" + nodeFileInfo2.getFileGroup() + "; Permissions=" + nodeFileInfo2.getFilePermissions();
                fileCollectionElement.setValue(nodeValue);
                ownerCollectionElement.setValue(nodeFileInfo2.getFileOwner() == null ? "N/A" : nodeFileInfo2.getFileOwner());
                groupCollectionElement.setValue(nodeFileInfo2.getFileGroup() == null ? "N/A" : nodeFileInfo2.getFileGroup());
                permissionsCollectionElement.setValue(nodeFileInfo2.getFilePermissions() == null ? "N/A" : nodeFileInfo2.getFilePermissions());
                if (refOwner != null) {
                    if (!refOwner.equals(nodeFileInfo2.getFileOwner())) {
                        this.m_resultSet.addResult(node, 3);
                        errorMessage2 = s_gMsgBundle.getMessage("2031", true, (Object[])new String[]{refFileName, node, refOwner, nodeFileInfo2.getFileOwner()});
                        error2 = new ErrorDescription(errorMessage2);
                        this.m_resultSet.addErrorDescription(node, error2);
                        fileCollectionElement.setStatus(3);
                        fileCollectionElement.addErrorDescription(error2);
                        ownerCollectionElement.setStatus(3);
                        ownerCollectionElement.addErrorDescription(error2);
                        mismatchAttributeMap2 = new Hashtable<String, String>();
                        mismatchAttributeMap2.put("ATTRIBUTE", ReportUtil.OWNER);
                        mismatchAttributeMap2.put("MESSAGE", errorMessage2);
                        mismatchAttributeList2 = (ArrayList)referenceAttributeMismatchMap.get(node);
                        if (mismatchAttributeList2 == null) {
                            mismatchAttributeList2 = new ArrayList();
                            referenceAttributeMismatchMap.put(node, mismatchAttributeList2);
                        }
                        mismatchAttributeList2.add(mismatchAttributeMap2);
                    }
                } else if (nodeFileInfo2.getFileOwner() != null) {
                    nodeList = (ArrayList<String>)fileOwnerMap.get(nodeFileInfo2.getFileOwner());
                    if (nodeList == null) {
                        nodeList = new ArrayList<String>();
                        fileOwnerMap.put(nodeFileInfo2.getFileOwner(), (ArrayList<String>)nodeList);
                    }
                    nodeList.add(node);
                }
                if (refGroup != null) {
                    if (!refGroup.equals(nodeFileInfo2.getFileGroup())) {
                        this.m_resultSet.addResult(node, 3);
                        errorMessage2 = s_gMsgBundle.getMessage("2032", true, (Object[])new String[]{refFileName, node, refGroup, nodeFileInfo2.getFileGroup()});
                        error2 = new ErrorDescription(errorMessage2);
                        this.m_resultSet.addErrorDescription(node, error2);
                        fileCollectionElement.setStatus(3);
                        fileCollectionElement.addErrorDescription(error2);
                        groupCollectionElement.setStatus(3);
                        groupCollectionElement.addErrorDescription(error2);
                        mismatchAttributeMap2 = new Hashtable();
                        mismatchAttributeMap2.put("ATTRIBUTE", ReportUtil.GROUP);
                        mismatchAttributeMap2.put("MESSAGE", errorMessage2);
                        mismatchAttributeList2 = (List)referenceAttributeMismatchMap.get(node);
                        if (mismatchAttributeList2 == null) {
                            mismatchAttributeList2 = new ArrayList();
                            referenceAttributeMismatchMap.put(node, mismatchAttributeList2);
                        }
                        mismatchAttributeList2.add(mismatchAttributeMap2);
                    }
                } else if (nodeFileInfo2.getFileGroup() != null) {
                    nodeList = (List)fileGroupMap.get(nodeFileInfo2.getFileGroup());
                    if (nodeList == null) {
                        nodeList = new ArrayList();
                        fileGroupMap.put(nodeFileInfo2.getFileGroup(), nodeList);
                    }
                    nodeList.add(node);
                }
                if (refPermissions != null) {
                    if (Integer.parseInt(refPermissions, 8) != Integer.parseInt(nodeFileInfo2.getFilePermissions(), 8)) {
                        this.m_resultSet.addResult(node, 3);
                        errorMessage2 = s_gMsgBundle.getMessage("2033", true, (Object[])new String[]{refFileName, node, refPermissions, nodeFileInfo2.getFilePermissions()});
                        error2 = new ErrorDescription(errorMessage2);
                        this.m_resultSet.addErrorDescription(node, error2);
                        fileCollectionElement.setStatus(3);
                        fileCollectionElement.addErrorDescription(error2);
                        permissionsCollectionElement.setStatus(3);
                        permissionsCollectionElement.addErrorDescription(error2);
                        mismatchAttributeMap2 = new Hashtable();
                        mismatchAttributeMap2.put("ATTRIBUTE", ReportUtil.PERMISSION);
                        mismatchAttributeMap2.put("MESSAGE", errorMessage2);
                        mismatchAttributeList2 = (List)referenceAttributeMismatchMap.get(node);
                        if (mismatchAttributeList2 == null) {
                            mismatchAttributeList2 = new ArrayList();
                            referenceAttributeMismatchMap.put(node, mismatchAttributeList2);
                        }
                        mismatchAttributeList2.add(mismatchAttributeMap2);
                    }
                } else if (nodeFileInfo2.getFilePermissions() != null) {
                    nodeList = (List)filePermissionsMap.get(nodeFileInfo2.getFilePermissions());
                    if (nodeList == null) {
                        nodeList = new ArrayList();
                        filePermissionsMap.put(nodeFileInfo2.getFilePermissions(), nodeList);
                    }
                    nodeList.add(node);
                }
                successfulNodes.add(node);
            }
            Hashtable nodeAttributeMismatchMap = new Hashtable();
            if (fileOwnerMap.size() > 1) {
                this.m_resultSet.addResult(successfulNodes.toArray(new String[0]), 3);
                errorMessage = s_gMsgBundle.getMessage("2027", true, (Object[])new String[]{refFileName, fileOwnerMap.toString(), VerificationUtil.strCollection2String(successfulNodes)});
                error = new ErrorDescription(errorMessage);
                this.m_resultSet.addErrorDescription(successfulNodes.toArray(new String[0]), error);
                for (CollectionElement element : fileCollectionElementList) {
                    element.setStatus(3);
                    element.addErrorDescription(error);
                }
                for (CollectionElement element : ownerCollectionElementList) {
                    element.setStatus(3);
                    element.addErrorDescription(error);
                }
                for (String node : successfulNodes) {
                    mismatchAttributeMap = new Hashtable();
                    nodeFileInfo = nodeExecTaskValues.get(node).get(refFileName);
                    mismatchAttributeMap.put("ATTRIBUTE", "Owner");
                    mismatchAttributeMap.put("MESSAGE", errorMessage);
                    mismatchAttributeList = (List)nodeAttributeMismatchMap.get(node);
                    if (mismatchAttributeList == null) {
                        mismatchAttributeList = new ArrayList();
                        nodeAttributeMismatchMap.put(node, mismatchAttributeList);
                    }
                    mismatchAttributeList.add(mismatchAttributeMap);
                }
            }
            if (fileGroupMap.size() > 1) {
                this.m_resultSet.addResult(successfulNodes.toArray(new String[0]), 3);
                errorMessage = s_gMsgBundle.getMessage("2028", true, (Object[])new String[]{refFileName, fileGroupMap.toString()});
                error = new ErrorDescription(errorMessage);
                this.m_resultSet.addErrorDescription(successfulNodes.toArray(new String[0]), error);
                for (CollectionElement element : fileCollectionElementList) {
                    element.setStatus(3);
                    element.addErrorDescription(error);
                }
                for (CollectionElement element : groupCollectionElementList) {
                    element.setStatus(3);
                    element.addErrorDescription(error);
                }
                for (String node : successfulNodes) {
                    mismatchAttributeMap = new Hashtable<String, String>();
                    nodeFileInfo = nodeExecTaskValues.get(node).get(refFileName);
                    mismatchAttributeMap.put("ATTRIBUTE", "Group");
                    mismatchAttributeMap.put("MESSAGE", errorMessage);
                    mismatchAttributeList = (ArrayList)nodeAttributeMismatchMap.get(node);
                    if (mismatchAttributeList == null) {
                        mismatchAttributeList = new ArrayList();
                        nodeAttributeMismatchMap.put(node, mismatchAttributeList);
                    }
                    mismatchAttributeList.add(mismatchAttributeMap);
                }
            }
            if (filePermissionsMap.size() > 1) {
                this.m_resultSet.addResult(successfulNodes.toArray(new String[0]), 3);
                errorMessage = s_gMsgBundle.getMessage("2029", true, (Object[])new String[]{refFileName, filePermissionsMap.toString()});
                error = new ErrorDescription(errorMessage);
                this.m_resultSet.addErrorDescription(successfulNodes.toArray(new String[0]), error);
                for (CollectionElement element : fileCollectionElementList) {
                    element.setStatus(3);
                    element.addErrorDescription(error);
                }
                for (CollectionElement element : permissionsCollectionElementList) {
                    element.setStatus(3);
                    element.addErrorDescription(error);
                }
                for (String node : successfulNodes) {
                    mismatchAttributeMap = new Hashtable();
                    nodeFileInfo = nodeExecTaskValues.get(node).get(refFileName);
                    mismatchAttributeMap.put("ATTRIBUTE", "Permissions");
                    mismatchAttributeMap.put("MESSAGE", errorMessage);
                    mismatchAttributeList = (List)nodeAttributeMismatchMap.get(node);
                    if (mismatchAttributeList == null) {
                        mismatchAttributeList = new ArrayList();
                        nodeAttributeMismatchMap.put(node, mismatchAttributeList);
                    }
                    mismatchAttributeList.add(mismatchAttributeMap);
                }
            }
            for (String node : successfulNodes) {
                Object message;
                List nodeMismatchedList = (List)nodeAttributeMismatchMap.get(node);
                List referenceMismatchedList = (List)referenceAttributeMismatchMap.get(node);
                ArrayList attributesMismatched = new ArrayList();
                ArrayList detailedMessage = new ArrayList();
                StringBuffer errorMessage3 = new StringBuffer();
                boolean mismatchFound = false;
                if (nodeMismatchedList != null) {
                    mismatchFound = true;
                    for (Hashtable mismatchedAttributeMap : nodeMismatchedList) {
                        attributesMismatched.add(mismatchedAttributeMap.get("ATTRIBUTE"));
                        detailedMessage.add(mismatchedAttributeMap.get("MESSAGE"));
                    }
                    message = s_gMsgBundle.getMessage("5011", false, (Object[])new String[]{VerificationUtil.strArr2List(attributesMismatched.toArray(new String[0]))});
                    errorMessage3.append((String)message);
                }
                attributesMismatched = new ArrayList();
                if (referenceMismatchedList != null) {
                    mismatchFound = true;
                    for (Hashtable mismatchedAttributeMap : referenceMismatchedList) {
                        attributesMismatched.add(mismatchedAttributeMap.get("ATTRIBUTE"));
                        detailedMessage.add(mismatchedAttributeMap.get("MESSAGE"));
                    }
                    message = s_gMsgBundle.getMessage("5012", false, (Object[])new String[]{VerificationUtil.strArr2List(attributesMismatched.toArray(new String[0]))});
                    if (errorMessage3.length() > 0) {
                        errorMessage3.append(";");
                    }
                    errorMessage3.append((String)message);
                }
                if (!mismatchFound) continue;
                nodeFailedFileList = (ArrayList)nodeBasedResultTable.get(node);
                if (nodeFailedFileList == null) {
                    nodeFailedFileList = new ArrayList();
                    nodeBasedResultTable.put(node, nodeFailedFileList);
                }
                fileTable = new Hashtable<String, Object>();
                fileTable.put("FILE_NAME", refFileName);
                fileTable.put("ERROR", errorMessage3.toString());
                fileTable.put("DETAILED_ERROR", detailedMessage);
                nodeFailedFileList.add(fileTable);
            }
        }
        if (nodeBasedResultTable.size() > 0) {
            ReportUtil.sureblankln();
            for (String node : nodeBasedResultTable.keySet()) {
                ReportUtil.sureprintln(ReportUtil.NODENAME + ": " + node);
                ReportUtil.verboseReportPrintln(ReportUtil.NODENAME + ": " + node);
                int failedCount = 0;
                for (Hashtable failedFileTable : (List)nodeBasedResultTable.get(node)) {
                    List detailedErrors;
                    if (++failedCount < 5 || ReportUtil.isVerbose()) {
                        String fileErrorMsg = "  " + failedFileTable.get("FILE_NAME") + "..." + failedFileTable.get("ERROR");
                        ReportUtil.sureprintln(fileErrorMsg);
                        ReportUtil.verboseReportPrintln(fileErrorMsg);
                    }
                    if ((detailedErrors = (List)failedFileTable.get("DETAILED_ERROR")) == null) continue;
                    for (String detailedError : detailedErrors) {
                        ReportUtil.println("  \t" + detailedError);
                        ReportUtil.verboseReportPrintln("  \t" + detailedError);
                    }
                }
                if (failedCount <= 5 || ReportUtil.isVerbose()) continue;
                String message = s_msgBundle.getMessage("5013", false, (Object[])new String[]{Integer.toString(failedCount - 5)});
                ReportUtil.sureprintln("  " + message);
                ReportUtil.verboseReportPrintln("  " + message);
            }
        }
        String message = s_msgBundle.getMessage("9602", false, (Object[])new String[]{Integer.toString(refFileList.size())});
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(message);
        ReportUtil.verboseReportPrintln(message);
    }

    public void setSoftwareComponent(String softwareComponent) {
        this.m_softwareComponent = softwareComponent;
    }

    public void setSoftwareComponentHome(String softwareComponentHome) {
        this.m_softwareComponentHome = softwareComponentHome;
    }

    private void populateCollectionResulSet() {
        ResultSet resultSet = this.m_resultSet;
        this.m_rsetFileInfo = new CollectionResultSetImpl();
        ArrayList<VerificationFileInfoImpl> filesVerified = null;
        VerificationFileInfoImpl fileInfo = null;
        StringBuffer errStr = null;
        CollectionResultImpl<ArrayList<VerificationFileInfoImpl>> result = null;
        int nodeStatus = 1;
        String attributeName = null;
        Hashtable opResTable = null;
        Iterator nodesIterator = null;
        opResTable = resultSet.getOperationalResultTable();
        nodesIterator = opResTable.keySet().iterator();
        String node = null;
        while (nodesIterator.hasNext()) {
            node = (String)nodesIterator.next();
            filesVerified = new ArrayList<VerificationFileInfoImpl>();
            for (CollectionElement fileElement : ((Result)opResTable.get(node)).getCollectionElements()) {
                errStr = new StringBuffer();
                fileInfo = new VerificationFileInfoImpl(fileElement.getName());
                fileInfo.setStatus(OverallStatus.SUCCESSFUL.toString());
                if (3 == fileElement.getStatus()) {
                    fileInfo.setStatus(OverallStatus.VERIFICATION_FAILED.toString());
                    nodeStatus = 3;
                }
                for (CollectionElement attrElement : fileElement.getChildrens()) {
                    attributeName = attrElement.getName();
                    if (attributeName.equals(ReportUtil.OWNER)) {
                        fileInfo.setRefFileOwner((String)attrElement.getExpectedValue());
                        fileInfo.setFileOwner((String)attrElement.getValue());
                    }
                    if (attributeName.equals(ReportUtil.GROUP)) {
                        fileInfo.setRefFileGroup((String)attrElement.getExpectedValue());
                        fileInfo.setFileGroup((String)attrElement.getValue());
                    }
                    if (!attributeName.equals(ReportUtil.PERMISSION)) continue;
                    fileInfo.setRefFilePermissions((String)attrElement.getExpectedValue());
                    fileInfo.setFilePermissions((String)attrElement.getValue());
                }
                for (ErrorDescription errDsc : fileElement.getErrorDescriptionList()) {
                    errStr.append(errDsc.getErrorMessage() + LSEP);
                }
                fileInfo.setErrorString(errStr.toString());
                filesVerified.add(fileInfo);
            }
            result = new CollectionResultImpl<ArrayList<VerificationFileInfoImpl>>(node, nodeStatus);
            result.setCollectedData(filesVerified);
            this.m_rsetFileInfo.addResult(node, result);
        }
    }

    public CollectionResultSet<List<VerificationFileInfo>> getFileInfoResultSet() {
        return this.m_rsetFileInfo;
    }

    public String getSoftwareComponentHome() {
        return this.m_softwareComponentHome;
    }

    public void setRelease(String release) {
        this.m_release = release;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("1400", false, (Object[])new String[]{this.m_softwareComponentHome});
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("1401", false, (Object[])new String[]{this.m_softwareComponentHome});
    }

    public void setAll(boolean all) {
        this.m_verifyAll = all;
    }
}

