/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.cluster.impl.verification.SharedStorageInfoImpl;
import oracle.cluster.impl.verification.SharedStorageResultSetImpl;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.StorageType;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageCheckContext;
import oracle.ops.verification.framework.storage.StorageData;
import oracle.ops.verification.framework.storage.StorageDataHandler;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.ClusterwareUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskSharedStorageAccess
extends Task {
    protected String[] m_storageIDList = null;
    private boolean m_checkOCFS = false;
    private boolean m_checkACFS = false;
    private boolean m_checkNFSOrNoFS = false;
    private boolean m_checkWritableFS = true;
    private boolean m_isASMpaths = false;
    public List<String> m_discoveryASMPaths = null;
    public StorageThread[] threadList;
    private boolean m_isOCRLocation = false;
    private boolean m_isVDiskLocation = false;
    private boolean m_isASMDeviceCheck = false;
    private SharedStorageResultSetImpl m_ssResSetImpl;
    GlobalVerificationContext m_gCtx = GlobalVerificationContext.getInstance();
    StorageCheckContext m_scCtx = new StorageCheckContext();
    boolean m_isFlexCluster = this.m_gCtx.isBigCluster();
    String[] m_hubNodes = null;
    private Map<String, VerificationResultSet> m_sharednessCheckResultSet;
    private OracleFileType m_oracleFileType = OracleFileType.RAC_DATA_FILES;
    private String m_release = "12.2";
    private boolean m_considerASMStorage = false;
    StorageDescriptor m_storageElementName;
    private Hashtable<String, List<String>> m_diskGroupMap = new Hashtable();
    private boolean m_diskGroupQueried = false;

    public TaskSharedStorageAccess(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        StorageDescriptor storageElementName = StorageDescriptor.ALL;
        switch (this.m_globalContext.getVerificationType()) {
            case COMPONENT_SHARED_STORAGE_ACCESS: {
                ParamManager paramMgr = this.m_globalContext.getParamManager();
                this.setStorageIDlist(paramMgr.getMultiPartArgVal(CVUVariables.getValue(CVUVariableConstants.STORAGE_ID_LIST)));
                this.setOracleFileType(this.getOracleFileType(CVUVariables.getValue(CVUVariableConstants.ORACLE_FILE_TYPE)));
                this.setRelease(this.m_globalContext.getRequestedRelease());
                this.setConsiderASMStorage(paramMgr.checkASM());
                List<String> deviceList = null;
                String deviceString = CVUVariables.getValue(CVUVariableConstants.ASM_DISK_DISCOVERY_STRING);
                if (deviceString != null) {
                    deviceList = Arrays.asList(deviceString.split(","));
                }
                this.setDiscoveryASMPaths(deviceList);
                return;
            }
        }
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("TYPE".equals(argName)) {
                storageElementName = StorageDescriptor.valueOf(argVal);
                VerificationUtil.traceAndLog("Storage Element Type = " + storageElementName.name());
                continue;
            }
            VerificationUtil.traceAndLog("unknown argument. name=" + argName + ". value=" + argVal);
        }
        String[] locations = null;
        ArrayList<String> storageList = new ArrayList<String>();
        switch (storageElementName) {
            case VOTING_DISK: {
                VerificationUtil.traceAndLog("Getting vote disk locations");
                try {
                    locations = ClusterwareUtil.getVoteDiskLocations().toArray(new String[0]);
                    VerificationUtil.traceAndLog("Vote locations =(" + VerificationUtil.strArr2List(locations) + ")");
                }
                catch (ClusterInfoException e) {
                    VerificationUtil.traceAndLog("Failed to retrieve the vote disk locations: '$s'", e.getMessage());
                    Trace.out((Exception)((Object)e));
                }
                this.m_storageElementName = StorageDescriptor.VOTING_DISK;
                this.setCheckWritableFS(false);
                this.setVDiskLocationFlag(true);
                break;
            }
            case OCR: {
                VerificationUtil.traceAndLog("Getting OCR locations");
                try {
                    locations = ClusterwareUtil.getOCRLocations().toArray(new String[0]);
                    VerificationUtil.traceAndLog("OCR locations =(" + VerificationUtil.strArr2List(locations) + ")");
                }
                catch (VerificationException e) {
                    VerificationUtil.traceAndLog("Failed to retrieve the ocr locations");
                }
                this.m_storageElementName = StorageDescriptor.OCR;
                this.setCheckWritableFS(false);
                this.setOCRLocationFlag(true);
                break;
            }
            case DB_FILES: {
                VerificationUtil.traceAndLog("Getting DB Files locations");
                String dbFileLoc = CVUVariables.getValue(CVUVariableConstants.DB_FILE_LOCATION);
                if (dbFileLoc != null && dbFileLoc.length() > 0) {
                    storageList.add(dbFileLoc);
                    this.setOracleFileType(OracleFileType.RAC_DATA_FILES);
                }
                this.m_storageElementName = StorageDescriptor.DB_FILES;
                if (storageList.isEmpty()) break;
                locations = storageList.toArray(new String[0]);
                break;
            }
            default: {
                VerificationUtil.traceAndLog("Getting Storage locations");
                String storageIdList = CVUVariables.getValue(CVUVariableConstants.CLUSTERWARE_STORAGE);
                if (!VerificationUtil.isStringGood(storageIdList)) {
                    storageIdList = CVUVariables.getValue(CVUVariableConstants.STORAGE_ID_LIST);
                } else {
                    this.setOracleFileType(OracleFileType.RAC_OCR_VDISK);
                }
                if (VerificationUtil.isStringGood(storageIdList)) {
                    storageList.addAll(Arrays.asList(VerificationUtil.string2strArr(storageIdList)));
                }
                this.m_storageElementName = null;
            }
        }
        if (locations != null) {
            for (String path : locations) {
                if (VerificationUtil.isPlatformWindows()) {
                    Vector<String> succNodes = new Vector<String>();
                    Vector<String> failNodes = new Vector<String>();
                    String drvPath = path.substring(0, path.indexOf(FSEP) + 1);
                    VerificationUtil.pathExists(this.m_nodeList, drvPath, 0, succNodes, failNodes);
                    if (succNodes.size() == 0) continue;
                    storageList.add(path);
                    continue;
                }
                storageList.add(path);
            }
        }
        VerificationUtil.traceAndLog("Total count of storages is (" + storageList.size() + ")");
        if (!storageList.isEmpty()) {
            this.setStorageIDlist(storageList.toArray(new String[0]));
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (this.m_globalContext.getVerificationType() == VerificationType.PREREQ_FARM_HEALTH) {
            return this.m_storageIDList != null && this.m_storageIDList.length > 0;
        }
        if (this.m_storageElementName != null) {
            switch (this.m_storageElementName) {
                case VOTING_DISK: 
                case OCR: 
                case DB_FILES: {
                    return this.m_storageIDList != null && this.m_storageIDList.length > 0;
                }
            }
        } else if (this.m_storageIDList == null && VerificationUtil.isExadataSystem()) {
            return false;
        }
        return true;
    }

    public TaskSharedStorageAccess(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskSharedStorageAccess(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskSharedStorageAccess(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setStorageID(String storageID) {
        VerificationUtil.traceAndLog("Setting m_storageIDList with storageID='%s'", storageID);
        if (!VerificationUtil.isStringGood(storageID)) {
            this.m_storageIDList = null;
            VerificationUtil.traceAndLog("Setting DISCOVERY mode");
            this.m_scCtx.setDiscovery(true);
        } else {
            this.setStorageIDlist(new String[]{storageID});
            this.m_scCtx.setDiscovery(false);
        }
    }

    public void setStorageIDlist(String[] storageIDList) {
        VerificationUtil.traceAndLog("Setting m_storageIDList='%s'", VerificationUtil.strArr2List(storageIDList));
        this.m_storageIDList = storageIDList;
        if (this.m_storageIDList != null && this.m_storageIDList.length != 0) {
            VerificationUtil.traceAndLog("Setting NON-DISCOVERY mode");
            this.m_scCtx.setDiscovery(false);
        } else {
            this.m_scCtx.setDiscovery(true);
        }
    }

    public void setStorageElementName(StorageDescriptor storageElementName) {
        VerificationUtil.traceAndLog("Setting m_storageElementName='%s'", storageElementName.name());
        this.m_storageElementName = storageElementName;
    }

    public void setOracleFileType(OracleFileType fileType) {
        VerificationUtil.traceAndLog("Setting m_oracleFileType='%s'", fileType.name());
        this.m_oracleFileType = fileType;
        this.m_scCtx.setUsageType(fileType);
    }

    public void setRelease(String release) {
        VerificationUtil.traceAndLog("Setting m_release='%s'", release);
        this.m_release = release;
        this.m_scCtx.setRelease(this.m_release);
    }

    public void setConsiderASMStorage(boolean considerASMStorage) {
        VerificationUtil.traceAndLog("Setting m_considerASMStorage='%s'", considerASMStorage);
        this.m_considerASMStorage = considerASMStorage;
        this.m_scCtx.setConsiderASMStorage(this.m_considerASMStorage);
    }

    public void setCheckOCFS(boolean toCheck) {
        VerificationUtil.traceAndLog("Setting m_checkOCFS='%s'", toCheck);
        this.m_checkOCFS = toCheck;
    }

    public void setCheckACFS(boolean toCheck) {
        VerificationUtil.traceAndLog("Setting m_checkACFS='%s'", toCheck);
        this.m_checkACFS = toCheck;
    }

    public void setCheckNFSOrNoFS(boolean toCheck) {
        VerificationUtil.traceAndLog("Setting m_checkNFSOrNoFS='%s'", toCheck);
        this.m_checkNFSOrNoFS = toCheck;
    }

    public void setCheckWritableFS(boolean toCheck) {
        VerificationUtil.traceAndLog("Setting m_checkWritableFS='%s'", toCheck);
        this.m_checkWritableFS = toCheck;
    }

    public void setASMpaths(boolean isASMpaths) {
        VerificationUtil.traceAndLog("Setting m_isASMpaths='%s'", isASMpaths);
        this.m_isASMpaths = isASMpaths;
    }

    public void setDiscoveryASMPaths(List<String> discoveryASMPaths) {
        VerificationUtil.traceAndLog("Setting m_discoveryASMPaths='%s'", VerificationUtil.strList2List(discoveryASMPaths));
        this.m_discoveryASMPaths = discoveryASMPaths;
        this.m_scCtx.setDiscoveryASMPaths(this.m_discoveryASMPaths);
    }

    @Override
    public boolean performTask() {
        String msg;
        block14: {
            this.m_ssResSetImpl = new SharedStorageResultSetImpl();
            this.m_sharednessCheckResultSet = new HashMap<String, VerificationResultSet>();
            VerificationUtil.traceAndLog("Performing SharedStorage Accessibility verification task... ");
            if (!VerificationUtil.isCVUTestEnv() && this.m_storageIDList != null && this.m_storageIDList.length > 0 && VerificationUtil.isVirtualEnvironment()) {
                HashSet<String> storagesToCheck = new HashSet<String>();
                HashSet<String> storagesToSkip = new HashSet<String>();
                StorageUtil.filterStoragesIfVirtualEnvironment(Arrays.asList(this.m_storageIDList), storagesToCheck, storagesToSkip);
                if (!storagesToSkip.isEmpty()) {
                    VerificationUtil.traceAndLogWarning("Virtual environment detected. Skipped the shared storage check for storages " + VerificationUtil.strCollection2String(storagesToSkip));
                    String warning = s_gMsgBundle.getMessage("1615", true, (Object[])new String[]{VerificationUtil.strCollection2String(storagesToSkip)});
                    this.m_resultSet.addErrorDescription(new ErrorDescription(warning));
                    this.m_resultSet.addResult(this.m_nodeList, 4);
                    for (String path : storagesToSkip) {
                        ResultSet diskRS = new ResultSet();
                        diskRS.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("1615", true, (Object[])new String[]{path})));
                        diskRS.addResult(this.m_nodeList, 4);
                        this.m_sharednessCheckResultSet.put(path, diskRS);
                    }
                }
                if (!storagesToCheck.isEmpty()) {
                    Trace.out((String)("Proceeding with the storages ID list as following:\nintial list :" + VerificationUtil.strArr2List(this.m_storageIDList) + "\nnew list: " + VerificationUtil.strCollection2String(storagesToCheck)));
                    this.m_storageIDList = storagesToCheck.toArray(new String[0]);
                } else {
                    Trace.out((String)("Sharedness check is being skipped for all the Storages " + VerificationUtil.strArr2List(this.m_storageIDList) + " in this virtual environment. Skipping"));
                    return true;
                }
            }
            this.m_scCtx.setDiscovery(null == this.m_storageIDList);
            this.m_scCtx.setUsageType(this.m_oracleFileType);
            this.m_scCtx.setRelease(this.m_release);
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4059", false));
            try {
                NodeManager nm = NodeManagerFactory.getInstance().getNodeManager();
                if (!this.m_isFlexCluster) break block14;
                try {
                    this.m_hubNodes = nm.getConfiguredHubNodes(this.m_nodeList);
                }
                catch (NoSuchNodesException e) {
                    this.m_hubNodes = null;
                }
                VerificationUtil.traceAndLog("Flex Cluster:: m_hubNodes='%s'", VerificationUtil.strArr2List(this.m_hubNodes));
            }
            catch (NodeManagerFactoryException e) {
                Trace.out((Exception)e);
                VerificationLogData.log(e.getMessage());
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
                ReportUtil.printError(e.getMessage());
                return false;
            }
        }
        Task previousTaskReference = null;
        previousTaskReference = ReportUtil.setTaskReference(this);
        if (null == this.m_storageIDList) {
            this.performDiscovery();
        } else {
            this.performSharednessValidation();
        }
        ReportUtil.setTaskReference(previousTaskReference);
        ReportUtil.sureblankln();
        ReportUtil.sureblankln();
        String nodeListStr = VerificationUtil.strArr2List(this.m_nodeList);
        if (this.m_resultSet.allSuccess()) {
            msg = s_msgBundle.getMessage("4099", false, (Object[])new String[]{nodeListStr});
            if (this.m_resultSet.anyWarning()) {
                this.setSeverity(SeverityType.IGNORABLE);
            }
        } else {
            msg = s_msgBundle.getMessage("4100", false, (Object[])new String[]{nodeListStr});
        }
        ReportUtil.sureprintln(msg);
        return this.m_resultSet.allSuccess();
    }

    void performDiscovery() {
        int numNodes = this.m_nodeList.length;
        int minNodesReq = numNodes >= 2 ? 2 : 1;
        VerificationUtil.traceAndLog("minNodesReq=" + minNodesReq);
        StorageDataHandler sdHndlr = new StorageDataHandler(this.m_scCtx);
        ResultSet locRS = new ResultSet();
        HashMap<StorageType, HashMap<String, HashMap<String, StorageData>>> typeStorageMap = new HashMap<StorageType, HashMap<String, HashMap<String, StorageData>>>();
        HashMap<StorageType, List<String>> potentialMatchesMap = new HashMap<StorageType, List<String>>();
        sdHndlr.discoverStorageData(this.m_nodeList, typeStorageMap, potentialMatchesMap, locRS);
        VerificationUtil.traceAndLog("Status=%s", ResultSet.resultsetStatusString(locRS.getStatus()));
        this.displayResultSetErrors(locRS);
        Trace.out((String)("typeStorageMap " + typeStorageMap.size() + "potentialMatchesMap " + potentialMatchesMap.size()));
        if (typeStorageMap.isEmpty() && potentialMatchesMap.isEmpty()) {
            ReportUtil.sureblankln();
            String errMsg = s_msgBundle.getMessage("4150", false);
            ReportUtil.sureprintln(errMsg);
            if (m_isCLImode) {
                this.m_resultSet.addResult(this.m_nodeList, 3);
                this.m_resultSet.addResultSetData(locRS);
                errMsg = s_msgBundle.getMessage("4100", true, (Object[])this.m_nodeList);
                this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
            } else {
                this.m_resultSet.addResult(this.m_nodeList, 1);
            }
        } else if (!typeStorageMap.isEmpty()) {
            this.printDiscoveryResult(typeStorageMap, minNodesReq);
            this.m_resultSet.addResult(this.m_nodeList, 1);
        }
        if (!potentialMatchesMap.isEmpty()) {
            for (StorageType stType : potentialMatchesMap.keySet()) {
                List<String> sdList = potentialMatchesMap.get((Object)stType);
                if (sdList.size() <= 0) continue;
                ReportUtil.reportPrintln(LSEP + LSEP + s_gMsgBundle.getMessage("0828", false, (Object[])new String[]{stType.toString()}));
                String potentialMatchStorageList = "";
                Iterator<String> stIdIterator = sdList.iterator();
                while (stIdIterator.hasNext()) {
                    String stId = stIdIterator.next();
                    potentialMatchStorageList = potentialMatchStorageList + stId;
                    if (!stIdIterator.hasNext()) continue;
                    potentialMatchStorageList = potentialMatchStorageList + ",";
                }
                ReportUtil.reportPrintln(LSEP + s_gMsgBundle.getMessage("0829", false, (Object[])new String[]{potentialMatchStorageList}) + LSEP);
                this.m_resultSet.addResult(this.m_nodeList, 1);
            }
        }
        this.m_ssResSetImpl.addResultSetData(this.m_resultSet);
    }

    void performSharednessValidation() {
        int numStorage = this.m_storageIDList.length;
        this.threadList = new StorageThread[numStorage];
        for (int i = 0; i < numStorage; ++i) {
            this.threadList[i] = new StorageThread(this.m_nodeList, this.m_storageIDList[i]);
            this.threadList[i].setName("t_" + this.m_storageIDList[i]);
            StorageThread t = this.threadList[i];
            VerificationUtil.traceAndLog("==> Running " + t.getName());
            t.start();
        }
        boolean threadFailure = false;
        try {
            for (int i = 0; i < numStorage; ++i) {
                VerificationUtil.traceAndLog("==> Waiting to join " + this.threadList[i].getName());
                this.threadList[i].join();
                VerificationUtil.traceAndLog("==> Joined " + this.threadList[i].getName());
            }
        }
        catch (InterruptedException e) {
            VerificationUtil.traceAndLog("\n THREADLIST.JOIN FAILED \n" + e);
            ReportUtil.printError(s_msgBundle.getMessage("4060", true));
            ErrorDescription errDesc = new ErrorDescription("4060", s_msgBundle);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(errDesc);
            threadFailure = true;
        }
        if (!threadFailure) {
            for (int i = 0; i < numStorage; ++i) {
                StorageThread t = this.threadList[i];
                String path = t.getStoragePath();
                t.printMessage();
                ResultSet stChkRS = new ResultSet();
                ResultSet threadRS = t.getResultSet();
                threadRS.traceResultSet("Storage Thread for '" + path + "'");
                if (threadRS.allSuccess() && !threadRS.anyWarning()) {
                    stChkRS.addResult(t.getSuccNodeList(), 1);
                } else {
                    stChkRS.addResultSetData(threadRS);
                }
                this.m_sharednessCheckResultSet.put(t.getStoragePath(), stChkRS);
                this.m_resultSet.addResultSetData(stChkRS);
            }
        }
    }

    private void printDiscoveryResult(HashMap<StorageType, HashMap<String, HashMap<String, StorageData>>> typeStorageMap, int minNodesReqd) {
        for (StorageType stType : typeStorageMap.keySet()) {
            HashMap<String, HashMap<String, StorageData>> idNodeSDmap = typeStorageMap.get((Object)stType);
            VerificationUtil.traceAndLog("Inspecting storage type '%s' ; Count of devices='%s'", stType.name(), idNodeSDmap.size());
            for (String id : idNodeSDmap.keySet()) {
                HashMap<String, StorageData> nodeSDmap = idNodeSDmap.get(id);
                String[] nodeArr = nodeSDmap.keySet().toArray(new String[0]);
                List<String> nodeList = Arrays.asList(nodeArr);
                int nodeCount = nodeArr.length;
                String nodeListStr = VerificationUtil.strArr2List(nodeArr);
                VerificationUtil.traceAndLog("Inspecting storage device '%s' ; Count of nodes='%s'", id, nodeCount);
                if (nodeCount < minNodesReqd) {
                    VerificationUtil.traceAndLog("Skipping device '%s' ; minimum node requirement not met", id);
                    continue;
                }
                if (this.m_hubNodes != null) {
                    VerificationUtil.traceAndLog("Checking sharedness across hub nodes ; m_hubNodes='%s'" + VerificationUtil.strArr2List(this.m_hubNodes));
                    ArrayList<String> leftOutHubList = new ArrayList<String>();
                    leftOutHubList.addAll(Arrays.asList(this.m_hubNodes));
                    leftOutHubList.removeAll(nodeList);
                    if (leftOutHubList.size() > 0) {
                        VerificationUtil.traceAndLog("Skipped '%s' ; not shared by hub nodes: '%s'", id, VerificationUtil.strCollection2String(leftOutHubList));
                        continue;
                    }
                }
                ReportUtil.sureblankln();
                ReportUtil.surewriteColHeaders(StorageUtil.getTypeStr(StorageDataHandler.getTypeIntFromEnum(stType)), s_msgBundle.getMessage("8502", false, (Object[])new String[]{String.valueOf(nodeCount)}));
                List<String> lines = TaskSharedStorageAccess.spreadToLines(30, nodeList, " ");
                boolean isIDprinted = false;
                for (String line : lines) {
                    if (!isIDprinted) {
                        if (stType == StorageType.DISK) {
                            String diskGroup = this.getDiskGroup(id);
                            if (VerificationUtil.isStringGood(diskGroup) && !diskGroup.equals("#")) {
                                ReportUtil.surewriteRecord(id + "[+" + diskGroup + "]", line);
                            } else {
                                ReportUtil.surewriteRecord(id, line);
                            }
                        } else {
                            ReportUtil.surewriteRecord(id, line);
                        }
                        isIDprinted = true;
                        continue;
                    }
                    ReportUtil.surewriteRecord("", line);
                }
                this.m_ssResSetImpl.addSharedStorageInfo(new SharedStorageInfoImpl(stType, id, nodeArr));
            }
        }
    }

    private static List<String> spreadToLines(int maxChars, Collection<String> strList, String seperator) {
        int curLen = 0;
        int numCharsLeft = maxChars;
        int sepSize = seperator.length();
        StringBuffer sb = null;
        ArrayList<String> tempList = new ArrayList<String>();
        ArrayList<String> resultLines = new ArrayList<String>();
        Iterator<String> strIter = strList.iterator();
        int cIndex = 0;
        while (strIter.hasNext()) {
            String curStr = strIter.next();
            curLen = curStr.length() + sepSize;
            if (numCharsLeft - curLen <= 0) {
                sb = new StringBuffer();
                Iterator iter = tempList.iterator();
                while (iter.hasNext()) {
                    String str = (String)iter.next();
                    iter.remove();
                    sb.append(str + seperator);
                }
                resultLines.add(sb.toString());
                numCharsLeft = maxChars;
            }
            tempList.add(curStr);
            numCharsLeft -= curLen;
            ++cIndex;
        }
        Iterator iter = tempList.iterator();
        if (iter.hasNext()) {
            sb = new StringBuffer();
            while (iter.hasNext()) {
                String str = (String)iter.next();
                sb.append(str + seperator);
            }
            resultLines.add(sb.toString());
        }
        return resultLines;
    }

    private String getDiskGroup(String path) {
        if (!this.m_diskGroupQueried) {
            this.m_diskGroupQueried = true;
            if (VerificationUtil.isVersionPost(this.m_release, "11.2") && (VerificationUtil.isCRSConfigured() || VerificationUtil.isHAConfigured())) {
                ResultSet diskGroupRS = new ResultSet();
                try {
                    Hashtable<String, Hashtable<String, List<String>>> htdg = new Hashtable<String, Hashtable<String, List<String>>>();
                    boolean result = new ASMDiskGroupsUtil().getDiskGroupsDiskMap(new String[]{this.m_nodeList[0]}, diskGroupRS, htdg);
                    if (result) {
                        this.m_diskGroupMap = htdg.get(this.m_nodeList[0]);
                    }
                }
                catch (ASMDiskGroupsUtilException e) {
                    VerificationUtil.traceAndLog("IGNORED: %s: $s", e.getClass(), e.getMessage());
                }
            }
        }
        if (this.m_diskGroupMap != null) {
            Enumeration<String> keys = this.m_diskGroupMap.keys();
            while (keys.hasMoreElements()) {
                String diskGroup = keys.nextElement();
                if (!this.m_diskGroupMap.get(diskGroup).contains(path)) continue;
                return diskGroup;
            }
        }
        return null;
    }

    public SharedStorageResultSetImpl getSharedStorageResultSetImpl() {
        return this.m_ssResSetImpl;
    }

    public Map<String, VerificationResultSet> getSharednessCheckResultSet() {
        return this.m_sharednessCheckResultSet;
    }

    public void setOCRLocationFlag(boolean isOCRLoc) {
        this.m_isOCRLocation = isOCRLoc;
        if (this.m_isOCRLocation) {
            this.m_oracleFileType = OracleFileType.RAC_OCR_VDISK;
            this.setStorageElementName(StorageDescriptor.OCR);
        }
    }

    public boolean isOCRLocation() {
        return this.m_isOCRLocation;
    }

    public void setVDiskLocationFlag(boolean isVDiskLoc) {
        this.m_isVDiskLocation = isVDiskLoc;
        if (this.m_isVDiskLocation) {
            this.m_oracleFileType = OracleFileType.RAC_OCR_VDISK;
            this.setStorageElementName(StorageDescriptor.VOTING_DISK);
        }
    }

    public void setASMDeviceCheck(boolean isASMDeviceCheck) {
        this.m_isASMDeviceCheck = isASMDeviceCheck;
    }

    public boolean isVDiskLocation() {
        return this.m_isVDiskLocation;
    }

    @Override
    public String getDefaultElementName() {
        if (null == this.m_storageIDList) {
            return s_msgBundle.getMessage("4427", false);
        }
        return s_msgBundle.getMessage("4426", false) + (this.m_storageElementName == null ? "" : ":" + (Object)((Object)this.m_storageElementName)) + ":" + VerificationUtil.strArr2List(this.m_storageIDList);
    }

    @Override
    public String getTaskID() {
        return "SHARED_STORAGE";
    }

    @Override
    public String getDefaultDescription() {
        if (null == this.m_storageIDList) {
            return s_msgBundle.getMessage("4478", false);
        }
        return s_msgBundle.getMessage(this.getStorageSpecificDescMsgID(), false);
    }

    private String getStorageSpecificDescMsgID() {
        if (this.m_storageElementName == null) {
            return "4477";
        }
        switch (this.m_storageElementName) {
            case OCR: {
                return "5459";
            }
            case VOTING_DISK: {
                return "5460";
            }
        }
        return "4477";
    }

    private OracleFileType getOracleFileType(String typeFlag) {
        if ("software".equals(typeFlag)) {
            return OracleFileType.RAC_SOFTWARE;
        }
        if ("data".equals(typeFlag)) {
            return OracleFileType.RAC_DATA_FILES;
        }
        if ("ocr_vdisk".equals(typeFlag)) {
            return OracleFileType.RAC_OCR_VDISK;
        }
        return OracleFileType.RAC_DATA_FILES;
    }

    void displayResultSetErrors(ResultSet rSet) {
        List<VerificationError> allErrors = rSet.getGlobalAndNodeErrorList();
        for (VerificationError vErr : allErrors) {
            String errMsg = vErr.getErrorMessage();
            if (vErr.isWarning()) {
                ReportUtil.printWarning(errMsg);
                continue;
            }
            ReportUtil.sureprintln(errMsg);
        }
    }

    boolean isStorageTypeConsistent(HashMap<String, StorageData> nodeSDmap, String suppliedID) {
        Iterator<String> stIterator = nodeSDmap.keySet().iterator();
        boolean firstEntry = true;
        StorageType savedStorageType = StorageType.UNKNOWN;
        while (stIterator.hasNext()) {
            String node = stIterator.next();
            StorageData stData = nodeSDmap.get(node);
            String derivedPath = stData.getEffectiveID();
            if (derivedPath != null && VerificationUtil.isSubsetPath(derivedPath, suppliedID)) {
                Trace.out((int)1, (String)("derivedPath=" + derivedPath + "; suppliedID=" + suppliedID));
                return false;
            }
            StorageType storageType = stData.getStorageTypeEnum();
            if (storageType == StorageType.UNKNOWN) {
                return false;
            }
            if (firstEntry) {
                savedStorageType = storageType;
                firstEntry = false;
                continue;
            }
            if (storageType == savedStorageType) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        sb.append("\n    StorageIDList: " + VerificationUtil.strArr2List(this.m_storageIDList));
        return sb.toString();
    }

    public class StorageThread
    extends Thread {
        protected ResultSet t_resultSet = new ResultSet();
        protected String[] t_nodeList;
        private List<String> t_succNodeList = new ArrayList<String>();
        protected String t_storageID;
        protected HashMap<String, StorageData> t_nodeSDmap;
        protected HashMap<String, StorageData> t_succNodeSDmap;
        private boolean t_isShared = false;
        StorageType t_storageType;
        protected String t_derivedPath;
        protected String t_effectiveSharedPath;
        private boolean b_useDerivedPath = false;
        private boolean b_fileSystemExists = false;
        private StorageType t_fileSystem;
        private boolean b_hasRWPerms;

        public StorageThread(String[] nodeList, String storageID) {
            this.t_nodeList = nodeList;
            this.t_storageID = storageID;
        }

        @Override
        public void run() {
            Result rslt;
            StorageDataHandler sdHndlr = new StorageDataHandler(TaskSharedStorageAccess.this.m_scCtx);
            this.t_nodeSDmap = sdHndlr.getStorageData(this.t_storageID, this.t_nodeList);
            ResultSet locRS = new ResultSet();
            sdHndlr.checkSharedness(this.t_nodeSDmap, this.t_nodeList.length, this.t_succNodeList, locRS);
            locRS.traceResultSet("After sharedness check of '" + this.t_storageID + "'");
            this.t_isShared = locRS.allSuccess() && !locRS.anyWarning();
            VerificationUtil.traceAndLog("t_isShared='%s' t_succNodeList='%s'", this.t_isShared, VerificationUtil.strList2List(this.t_succNodeList));
            if (!this.t_isShared) {
                this.t_resultSet.addResultSetData(locRS);
                if (TaskSharedStorageAccess.this.m_oracleFileType != null && TaskSharedStorageAccess.this.isStorageTypeConsistent(this.t_nodeSDmap, this.t_storageID)) {
                    locRS = new ResultSet();
                    sdHndlr.checkUsageCompatibility(this.t_nodeSDmap, locRS);
                    if (!locRS.allSuccess()) {
                        VerificationUtil.traceAndLog("Storage type is not compatible with Oracle Usage");
                        this.t_resultSet.addResultSetData(locRS);
                    }
                }
                return;
            }
            this.t_resultSet.addResult(this.t_succNodeList, 1);
            this.t_succNodeSDmap = new HashMap();
            for (String sucNode : this.t_succNodeList) {
                this.t_succNodeSDmap.put(sucNode, this.t_nodeSDmap.get(sucNode));
            }
            String node = this.t_succNodeSDmap.keySet().iterator().next();
            StorageData stData = this.t_succNodeSDmap.get(node);
            this.t_derivedPath = stData.getEffectiveID();
            this.b_useDerivedPath = this.t_derivedPath != null && VerificationUtil.isSubsetPath(this.t_derivedPath, this.t_storageID);
            this.t_effectiveSharedPath = this.b_useDerivedPath ? this.t_derivedPath : this.t_storageID;
            VerificationUtil.traceAndLog("t_derivedPath=%s; b_useDerivedPath=%s", this.t_derivedPath, this.b_useDerivedPath);
            VerificationUtil.traceAndLog("OriginalPath from StorageData=" + stData.getSuppliedID());
            this.t_storageType = stData.getStorageType().getValue();
            String stTypeInStr = StorageUtil.getTypeStr(StorageDataHandler.getTypeIntFromEnum(this.t_storageType));
            VerificationUtil.traceAndLog("Storage Type: " + stTypeInStr);
            VerificationUtil.traceAndLog("Storage Data: " + VerificationConstants.LSEP + stData.toString());
            if (TaskSharedStorageAccess.this.m_oracleFileType != null) {
                locRS = new ResultSet();
                sdHndlr.checkUsageCompatibility(this.t_succNodeSDmap, locRS);
                if (!locRS.allSuccess()) {
                    VerificationUtil.traceAndLog("Storage type is not compatible with Oracle Usage");
                    this.t_resultSet.addResultSetData(locRS);
                    return;
                }
            }
            locRS = new ResultSet();
            sdHndlr.checkStorageAttributes(this.t_succNodeSDmap, locRS);
            if (!locRS.allSuccess()) {
                VerificationUtil.traceAndLog("Storage attributes validation failed on at least one node");
                this.t_resultSet.addResultSetData(locRS);
                return;
            }
            if (this.t_storageType != StorageType.ASMDG) {
                File file;
                rslt = new Result(node);
                StorageType t_fileSystem = sdHndlr.getFileSystem(node, this.t_effectiveSharedPath, rslt);
                if (rslt.getStatus() == 2) {
                    VerificationUtil.traceAndLog("File system type could not be determined successfully");
                    this.t_resultSet.addResult(this.t_nodeList, 2);
                    this.t_resultSet.addErrorDescription(new ErrorDescription(VerificationUtil.errorCollection2String(rslt.getErrors())));
                    return;
                }
                if (rslt.getStatus() == 3) {
                    VerificationUtil.traceAndLog("File system does not exist");
                    this.b_fileSystemExists = false;
                } else {
                    VerificationUtil.traceAndLog("File system of type '%s' exists on path ", t_fileSystem.name());
                    this.b_fileSystemExists = true;
                }
                if (TaskSharedStorageAccess.this.m_checkOCFS && t_fileSystem != StorageType.OCFS && t_fileSystem != StorageType.OCFS2) {
                    VerificationUtil.traceAndLog("File system is not found to be OCFS or OCFS2");
                    String errMsg = Task.s_msgBundle.getMessage("7019", true, (Object[])new String[]{this.t_effectiveSharedPath});
                    this.t_resultSet.addResult(this.t_nodeList, 3);
                    this.t_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                    return;
                }
                if (TaskSharedStorageAccess.this.m_checkACFS && t_fileSystem != StorageType.ACFS) {
                    VerificationUtil.traceAndLog("File system is not found to be ACFS");
                    String errMsg = Task.s_gMsgBundle.getMessage("1299", true, (Object[])new String[]{this.t_effectiveSharedPath});
                    this.t_resultSet.addResult(this.t_nodeList, 3);
                    this.t_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                    return;
                }
                if (TaskSharedStorageAccess.this.m_checkNFSOrNoFS && this.b_fileSystemExists && t_fileSystem != StorageType.NFS) {
                    VerificationUtil.traceAndLog("File system exists and is not of type NFS");
                    String errMsg = Task.s_gMsgBundle.getMessage("0360", true, (Object[])new String[]{this.t_effectiveSharedPath});
                    this.t_resultSet.addResult(this.t_nodeList, 3);
                    this.t_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                    return;
                }
                if (TaskSharedStorageAccess.this.m_checkWritableFS && ((file = new File(this.t_effectiveSharedPath)).isDirectory() || file.isFile())) {
                    if (!file.canWrite()) {
                        String errMsg = Task.s_msgBundle.getMessage("0020", true, (Object[])new String[]{this.t_effectiveSharedPath});
                        ErrorDescription errDesc = new ErrorDescription(errMsg);
                        if (TaskSharedStorageAccess.this.m_oracleFileType == OracleFileType.RAC_DATA_FILES || TaskSharedStorageAccess.this.m_oracleFileType == OracleFileType.SI_DATA_FILES) {
                            this.t_resultSet.addResult(TaskSharedStorageAccess.this.m_nodeList, 3);
                        } else {
                            VerificationUtil.traceAndLog("Marking it as a WARNING");
                            errDesc.setWarning();
                            this.t_resultSet.addResult(TaskSharedStorageAccess.this.m_nodeList, 4);
                        }
                        this.t_resultSet.addErrorDescription(errDesc);
                    }
                    return;
                }
            }
            if ((TaskSharedStorageAccess.this.m_isOCRLocation || TaskSharedStorageAccess.this.m_isVDiskLocation) && this.t_storageType == StorageType.DISK && sdHndlr.getNumDiskPartitions(stData) > 0) {
                String errMsg = TaskSharedStorageAccess.this.m_isOCRLocation ? Task.s_msgBundle.getMessage("4211", true, (Object[])new String[]{this.t_effectiveSharedPath}) : Task.s_msgBundle.getMessage("4212", true, (Object[])new String[]{this.t_effectiveSharedPath});
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                VerificationUtil.traceAndLog("Marking it as a WARNING");
                this.t_resultSet.addErrorDescription(errDesc);
                this.t_resultSet.addResult(TaskSharedStorageAccess.this.m_nodeList, 4);
                return;
            }
            if (TaskSharedStorageAccess.this.m_oracleFileType == OracleFileType.RAC_DATA_FILES || TaskSharedStorageAccess.this.m_oracleFileType == OracleFileType.SI_DATA_FILES) {
                String user = System.getProperty("user.name");
                for (String node1 : this.t_succNodeSDmap.keySet()) {
                    StorageData stData1 = this.t_succNodeSDmap.get(node1);
                    rslt = new Result(node1);
                    this.b_hasRWPerms = sdHndlr.hasReadWritePerms(node1, stData1, user, rslt);
                    if (rslt.getStatus() == 2) {
                        VerificationUtil.traceAndLog("Failed to check Read Write permisisons on node '%s'", node1);
                        this.t_resultSet.addResult(node1, 2);
                        this.t_resultSet.addErrorDescription(new ErrorDescription(VerificationUtil.errorCollection2String(rslt.getErrors())));
                        return;
                    }
                    if (this.b_hasRWPerms) continue;
                    String dbLoc = stData1.getSuppliedID();
                    String perms = (String)rslt.getResultInfoSet().elementAt(0);
                    VerificationUtil.traceAndLog("Database file location '%s' does not have read write access on node '%s' perms='%s'", dbLoc, node1, perms);
                    String errMsg = Task.s_gMsgBundle.getMessage("0822", true, (Object[])new String[]{dbLoc, user, node, perms});
                    this.t_resultSet.addErrorDescription(node1, new ErrorDescription(errMsg));
                    this.t_resultSet.addResult(node1, 3);
                    return;
                }
            }
            if (TaskSharedStorageAccess.this.m_hubNodes != null) {
                ArrayList<String> leftOutHubList = new ArrayList<String>();
                leftOutHubList.addAll(Arrays.asList(TaskSharedStorageAccess.this.m_hubNodes));
                leftOutHubList.removeAll(this.t_succNodeList);
                if (leftOutHubList.size() > 0) {
                    String hubNodesStr = VerificationUtil.strCollection2String(leftOutHubList);
                    VerificationUtil.traceAndLog("Path %s is not shared by the following hub nodes: %s", this.t_storageID, hubNodesStr);
                    String errMsg = Task.s_gMsgBundle.getMessage("11112", true, (Object[])new String[]{this.t_storageID, hubNodesStr});
                    this.t_resultSet.addResult(leftOutHubList, 3);
                    this.t_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                }
            }
        }

        public Vector<StorageInfo> getStorageInfoVector() {
            Vector<StorageInfo> siVect = new Vector<StorageInfo>();
            for (String node : this.t_nodeSDmap.keySet()) {
                StorageData stData = this.t_nodeSDmap.get(node);
                StorageInfo stInfo = new TypeFinder().stData2stInfo(stData, node);
                if (stInfo == null) continue;
                siVect.add(stInfo);
            }
            return siVect;
        }

        public ResultSet getResultSet() {
            return this.t_resultSet;
        }

        public String getStoragePath() {
            return this.t_storageID;
        }

        public Collection<String> getSuccNodeList() {
            return this.t_succNodeList;
        }

        protected boolean isShared() {
            return this.t_isShared;
        }

        public void printMessage() {
            String displayTxt;
            if (this.t_isShared) {
                if (this.b_useDerivedPath) {
                    VerificationUtil.traceAndLog("Path '" + this.t_storageID + "' does not exist on at least one node but '" + this.t_effectiveSharedPath + "' exists on all the nodes and is shared");
                    displayTxt = VerificationConstants.LSEP + Task.s_gMsgBundle.getMessage("1298", false, (Object[])new String[]{this.t_storageID, this.t_effectiveSharedPath});
                    ReportUtil.sureprintln(displayTxt);
                } else {
                    String displayPath = this.t_effectiveSharedPath;
                    String diskGroup = TaskSharedStorageAccess.this.getDiskGroup(displayPath);
                    if (diskGroup != null) {
                        displayPath = displayPath + " [+" + diskGroup + "]";
                    }
                    displayTxt = VerificationConstants.LSEP + Task.s_msgBundle.getMessage("4061", false, (Object[])new String[]{displayPath});
                    this.t_resultSet.addResult(this.t_nodeList, 1);
                    ReportUtil.sureprintln(displayTxt);
                }
            }
            if (this.t_resultSet.getStatus() != 1) {
                if (this.t_resultSet.getStatus() == 4) {
                    TaskSharedStorageAccess.this.displayResultSetErrors(this.t_resultSet);
                } else if (this.t_resultSet.getStatus() == 2) {
                    TaskSharedStorageAccess.this.displayResultSetErrors(this.t_resultSet);
                } else if (this.t_resultSet.getStatus() == 3) {
                    if (this.t_isShared) {
                        TaskSharedStorageAccess.this.displayResultSetErrors(this.t_resultSet);
                    } else {
                        displayTxt = VerificationConstants.LSEP + Task.s_msgBundle.getMessage("4062", false, (Object[])new String[]{this.t_storageID});
                        ReportUtil.sureprintln(displayTxt);
                    }
                }
            }
        }
    }

    public static enum StorageDescriptor {
        OCR(VerificationUtil.getMessageBundle("Prvf").getMessage("5457", false)),
        VOTING_DISK(VerificationUtil.getMessageBundle("Prvf").getMessage("5458", false)),
        DB_FILES("DB_FILES"),
        ALL("ALL");

        private String m_desc;

        private StorageDescriptor(String desc) {
            this.m_desc = desc;
        }

        public String toString() {
            return this.m_desc;
        }
    }
}

