/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.network.DHCPServerType;
import oracle.cluster.resources.PrCiMsgID;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskNameService;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkDataDiscovery;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.helper.CVUHelperConstants;

public class TaskScan
extends Task
implements CVUHelperConstants {
    private static final String TASK_TYPE = "SCAN";
    private final String TNSPING_EXE = "tnsping ";
    private final String TNSPING_ERR_PATTERN = "^TNS-[0-9]+:.*";
    private final String TNSPING_SUCC_PATTERN = "^OK \\([0-9]+ .*\\)";
    private static int MIN_SCAN_IPS = 3;
    private String m_localName = null;
    private boolean m_isPreCRS = false;
    private HashMap<String, Set<NetworkInfo>> m_nodeNetworksMap = null;

    public TaskScan(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        this.setIsPreCRS(this.m_globalContext.isPreCRS());
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (VerificationUtil.isCVUTestEnv() && VerificationUtil.isStringGood(VerificationUtil.getEnv("SKIP_ALL_SCAN_VIP_VALIDATION"))) {
            return false;
        }
        if (VerificationUtil.isODALiteEnv()) {
            VerificationUtil.traceAndLog("skipping SCAN check in ODALite env");
            return false;
        }
        VerificationType vType = this.m_globalContext.getVerificationType();
        if (vType != null) {
            switch (vType) {
                case PREREQ_FARM_HEALTH: {
                    if (!VerificationUtil.isStringGood(CVUVariables.getValue(CVUVariableConstants.SCAN_NAME))) {
                        ReportUtil.printWarning(s_gMsgBundle.getMessage("11755", true, (Object[])new String[]{CVUVariableConstants.SCAN_NAME.toString(), this.m_globalContext.getParamManager().getInstallConfigFile()}));
                        VerificationUtil.traceAndLog("The property (" + CVUVariableConstants.SCAN_NAME.toString() + ") is not defined. Check is not applicable");
                        return false;
                    }
                    return true;
                }
            }
        }
        if (this.m_isPreCRS) {
            return VerificationUtil.isStringGood(CVUVariables.getValue(CVUVariableConstants.SCAN_NAME)) && VerificationUtil.isStringGood(CVUVariables.getValue(CVUVariableConstants.INTERCONNECT_LIST)) && !this.m_globalContext.isDHCPConfigured();
        }
        String actCRSVer = VerificationUtil.getCRSActiveVersion();
        if (VerificationUtil.isStringGood(actCRSVer)) {
            if (!VerificationUtil.isVersionPre(actCRSVer, "11.2")) {
                VerificationUtil.traceAndLog("Source home CRS version is greater than or equal to 11.2, adding SCAN related checks");
                return true;
            }
            VerificationUtil.traceAndLog("Source home CRS version is pre 11.2, NOT adding SCAN related checks");
            return false;
        }
        VerificationUtil.traceAndLog("Source home CRS version could not be retrieved and hence not adding SCAN related checks");
        return false;
    }

    public TaskScan(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskScan(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskScan(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    public boolean initializeNetworkDetails(HashMap<String, Set<NetworkInfo>> globalNodeNetworksMap) {
        boolean retVal = true;
        if (NetworkUtility.isNetworksMapGood(globalNodeNetworksMap)) {
            this.m_nodeNetworksMap = globalNodeNetworksMap;
            retVal = true;
        } else {
            ResultSet networksResultSet = new ResultSet();
            this.m_nodeNetworksMap = NetworkDataDiscovery.getNodeNetworksMap(this.m_nodeList, networksResultSet);
            if (!NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMap)) {
                Trace.out((String)"Could not discover the network details successfully while initializing the network details for SCAN checks");
                NetworkUtility.reportResultSet(networksResultSet, this.m_resultSet, true);
                retVal = false;
            }
        }
        return retVal;
    }

    public void setIsPreCRS(boolean isPreCRS) {
        this.m_isPreCRS = isPreCRS;
    }

    @Override
    public boolean performTask() {
        boolean retVal = true;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        this.m_resultSet.addResult(this.m_nodeList, 1);
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5050", false));
        ResultSet networkResultSet = new ResultSet();
        this.m_nodeNetworksMap = NetworkDataDiscovery.getNodeNetworksMap(this.m_nodeList, networkResultSet);
        if (!NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMap)) {
            Trace.out((String)("Could not discover the network details successfully during SCAN checks on nodes " + VerificationUtil.strArr2List(this.m_nodeList)));
            NetworkUtility.reportResultSet(networkResultSet, this.m_resultSet, true);
            return false;
        }
        HashSet<String> validNodeList = new HashSet<String>();
        boolean hasNetworks = NetworkDataDiscovery.checkForNetworkExistenceOnAllNodes(null, null, this.m_nodeList, validNodeList, this.m_resultSet, TASK_TYPE);
        if (!hasNetworks) {
            return false;
        }
        retVal = this.m_isPreCRS ? this.performTaskPre() : this.performTaskPost();
        if (retVal) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5058", false));
        } else {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5054", false));
        }
        return retVal;
    }

    /*
     * WARNING - void declaration
     */
    public boolean performTaskPost() {
        NativeSystem nativeSystem;
        boolean performNslookupForScan;
        String errorMessage = null;
        LinkedList<ErrorDescription> errorDetails = new LinkedList<ErrorDescription>();
        boolean isResourceRunning = true;
        ErrorDescription errDesc = null;
        String exeHome = VerificationUtil.getCRSHome();
        Version crsVer = VerificationUtil.getCRSActiveVersionObj();
        if (exeHome != null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("exeHome = '" + exeHome + "'"));
            }
        } else {
            errorMessage = s_msgBundle.getMessage("5301", true);
            ErrorDescription errorDesc = new ErrorDescription(errorMessage);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(errorMessage);
            return false;
        }
        this.m_localName = this.m_nodeList[0];
        ResultSet scanResultSet = new ResultSet();
        String[] scanDetailsArr = CVUHelperUtil.getScanInfo(this.m_nodeList, scanResultSet);
        if (!scanResultSet.allSuccess()) {
            this.m_resultSet.overwriteResultSet(scanResultSet);
            return false;
        }
        List<Scan> scans = null;
        if (Version.isPre12c((Version)crsVer)) {
            Trace.out((String)"getting Scan details in pre 12g way");
            List<scanData> sd = this.getScanDetailsPre12(scanDetailsArr);
            if (sd.size() > 0) {
                Scan s = new Scan();
                s.sName = sd.get(0).getVIPName();
                HashSet<NetworkInfo> clusterNetworks = new HashSet<NetworkInfo>();
                if (!NetworkUtility.getPublicClusterNetworks(clusterNetworks, this.m_nodeList, this.m_resultSet)) {
                    return false;
                }
                if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
                    return true;
                }
                s.netIpv4Subnet = NetworkDataDiscovery.getClusterNetworkSubnets(clusterNetworks).get(0);
                s.sdList = sd;
                scans = new ArrayList<Scan>();
                scans.add(s);
            }
        } else {
            Trace.out((String)"getting Scan details in 12g way");
            scans = this.getScanDetails(scanDetailsArr);
        }
        if (scans == null || scans.size() == 0) {
            errorMessage = s_msgBundle.getMessage("5053", true);
            ErrorDescription errorDesc = new ErrorDescription(errorMessage);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(errorMessage);
            return false;
        }
        boolean headerPrinted = false;
        List portIDList = null;
        boolean portsMatch = true;
        boolean portserrorMessage = false;
        for (Scan scan : scans) {
            if (headerPrinted) {
                ReportUtil.blankln();
            }
            List<scanData> scanDetails = scan.sdList;
            Iterator<scanData> iterator = scanDetails.iterator();
            while (iterator.hasNext()) {
                List<String> inputNodeList;
                scanData scanItem = iterator.next();
                if (!headerPrinted) {
                    headerPrinted = true;
                    ReportUtil.writeColHeaders(s_msgBundle.getMessage("4658", false), s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8003", false), s_msgBundle.getMessage("8059", false), s_msgBundle.getMessage("8060", false), s_msgBundle.getMessage("8003", false));
                }
                if (portIDList == null) {
                    portIDList = scanItem.getPortList();
                } else {
                    portsMatch = this.matchPorts(portIDList, scanItem.getPortList());
                }
                String string = scanItem.getVipRunning() ? "true" : "false";
                String lsnrRunning = scanItem.getLsnrRunning() ? "true" : "false";
                String portID = VerificationUtil.strCollection2String(portIDList);
                ReportUtil.writeRecord(scanItem.getVIPName(), scanItem.getLsnrNode(), string, scanItem.getLsnrName(), portID, lsnrRunning);
                if (!scanItem.getLsnrRunning() || !scanItem.getVipRunning()) {
                    isResourceRunning = false;
                    errDesc = new ErrorDescription("5056", new String[]{scanItem.getLsnrName()}, s_msgBundle);
                    errorDetails.add(errDesc);
                    this.m_resultSet.addResult(this.m_localName, 3);
                    this.m_resultSet.getResult(this.m_localName).addErrorDescription(errDesc);
                }
                if (!scanItem.getLsnrRunning() && !Version.isPre12c((Version)crsVer) && (inputNodeList = Arrays.asList(this.m_nodeList)).contains(scanItem.getLsnrNode()) && !VerificationUtil.isPlatformWindows()) {
                    ResultSet lsnrRsltSet = this.checkScanLsnrSocketFileAttributes(scanItem.getLsnrNode(), scanItem.getLsnrName());
                    this.m_resultSet.addResultSetData(lsnrRsltSet);
                }
                if (portsMatch || portserrorMessage) continue;
                isResourceRunning = false;
                portserrorMessage = true;
                errDesc = new ErrorDescription("5057", new String[]{scanItem.getLsnrName()}, s_msgBundle);
                errorDetails.add(errDesc);
                this.m_resultSet.addResult(this.m_localName, 3);
                this.m_resultSet.getResult(this.m_localName).addErrorDescription(errDesc);
            }
            if (Version.isPre12c((Version)crsVer)) continue;
            String string = VerificationUtil.getDefaultOracleUser();
            String crsUser = VerificationUtil.getCRSUser(new Result(m_localNode), VerificationUtil.isHAConfigured());
            Trace.out((String)("Current user : " + string + ", CRS user : " + (String)crsUser));
            VerificationType verificationType = this.m_globalContext.getVerificationType();
            Trace.out((String)("Verification type : " + verificationType.toString()));
            if (crsUser != null && string != null && crsUser.trim().equals(string.trim()) || VerificationUtil.isPlatformWindows() && verificationType != VerificationType.PREREQ_DB_INST && verificationType != VerificationType.PREREQ_DB_CONFIG) {
                Trace.out((String)"Verifying VNCR parameter to check the cluster nodes are  allowed to register with the scan listeners");
                this.checkVNCRParameter(scanDetails, exeHome);
            }
            Trace.out((String)"Checking Reg invited nodes for scan lsnrs");
            this.checkRegInvitedNodes(scanDetails);
        }
        for (ErrorDescription errorMessages : errorDetails) {
            ReportUtil.printError(errorMessages.getErrorMessage());
        }
        if (!this.m_resultSet.anyFailure()) {
            Trace.out((String)"about to run tnsping check");
            for (Scan scan : scans) {
                this.performTnsPingCheck(scan.sdList, exeHome);
            }
        } else {
            Trace.out((String)"skipping tnsping check");
        }
        if (this.m_resultSet.getStatus() == 1 && this.m_nodeList.length > 2) {
            HashSet<String> scanVIPRunningNodes = new HashSet<String>();
            int countScanVips = 0;
            for (Scan scan : scans) {
                for (scanData scanData2 : scan.sdList) {
                    ++countScanVips;
                    scanVIPRunningNodes.add(scanData2.getVipRunNode());
                }
            }
            if (countScanVips > 1 && scanVIPRunningNodes.size() == 1) {
                void var17_31;
                Iterator itr = scanVIPRunningNodes.iterator();
                Object var17_29 = null;
                if (itr.hasNext()) {
                    String string = (String)itr.next();
                }
                errorMessage = s_msgBundle.getMessage("5065", true, (Object[])new String[]{var17_31});
                errDesc = new ErrorDescription(errorMessage);
                this.m_resultSet.addResult(this.m_localName, 4);
                this.m_resultSet.getResult(this.m_localName).addErrorDescription(errDesc);
                ReportUtil.println(errorMessage);
            }
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        boolean bl = performNslookupForScan = (nativeSystem = new SystemFactory().CreateSystem()).isUnixSystem() && (!VerificationUtil.isEngineeredSystem() || VerificationUtil.isEngineeredSystem() && VerificationUtil.isNameServerConfigured());
        if (performNslookupForScan) {
            boolean oraDevEnv = VerificationUtil.isCVUTestEnv();
            String string = new String("bigip-bug.us.oracle.com");
            Trace.out((int)5, (String)("ora dev env: '" + oraDevEnv + "'"));
            ArrayList<void> scanVIPNameList = new ArrayList<void>();
            for (Scan scan : scans) {
                void var17_34;
                Trace.out((int)5, (String)("\nScan name : \n" + scan.sName));
                if (!oraDevEnv) {
                    String string2 = scan.sName;
                }
                if (scanVIPNameList.contains(var17_34)) continue;
                scanVIPNameList.add(var17_34);
                TaskNameService taskNS = new TaskNameService(this.m_nodeList, (String)var17_34);
                this.addChildTask(taskNS);
                String taskNameStr = s_msgBundle.getMessage("9503", false) + " '" + (String)var17_34 + "'";
                taskNS.setElementName(taskNameStr);
                taskNS.perform();
                scan.scanVIPAdressListFromDNS = taskNS.getScanVIPAddressListFromDNS();
                this.m_resultSet.uploadResultSet(taskNS.getResultSet());
            }
        }
        block9: for (Scan scan : scans) {
            void var19_50;
            if ((scan.netIpv4Subnet == null || scan.netIPv4DhcpType != DHCPServerType.NONE) && (scan.netIpv6Subnet == null || scan.netIpv6DhcpType != DHCPServerType.NONE)) continue;
            InetAddress[] scanVips = null;
            boolean bl2 = false;
            try {
                if (VerificationUtil.isCVUTestEnv()) {
                    Trace.out((String)"We are in test env. SCAN VIP consistency won't succeed. Return.");
                    continue;
                }
                if (performNslookupForScan) {
                    ArrayList<InetAddress> scanVipList = new ArrayList<InetAddress>();
                    Trace.out((String)("Resolved scan VIPs from DNS : " + scan.scanVIPAdressListFromDNS));
                    for (String scanVIP : scan.scanVIPAdressListFromDNS) {
                        scanVipList.add(InetAddress.getByName(scanVIP));
                    }
                    scanVips = scanVipList.toArray(new InetAddress[scanVipList.size()]);
                } else {
                    scanVips = InetAddress.getAllByName(scan.sName);
                }
            }
            catch (UnknownHostException uhe) {
                errorMessage = s_gMsgBundle.getMessage("11374", true, (Object[])new String[]{scan.sName});
                errDesc = new ErrorDescription(errorMessage);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                this.m_resultSet.addErrorDescription(errDesc);
                ReportUtil.printError(errorMessage);
                continue;
            }
            for (InetAddress ipscan : scanVips) {
                if (scan.netIpv4Subnet != null && ipscan instanceof Inet4Address) {
                    ++var19_50;
                }
                if (scan.netIpv6Subnet == null || !(ipscan instanceof Inet6Address)) continue;
                ++var19_50;
            }
            if (var19_50 != scan.getVipAddrsSize()) {
                errorMessage = s_gMsgBundle.getMessage("11372", true, (Object[])new String[]{scan.sName});
                errDesc = new ErrorDescription(errorMessage);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                this.m_resultSet.addErrorDescription(errDesc);
                ReportUtil.printError(errorMessage);
                return false;
            }
            scanData firstSD = scan.sdList.get(0);
            boolean ipv4Present = firstSD.l_scanIpv4Address != null;
            boolean ipv6Present = firstSD.l_scanIpv6Address != null;
            Trace.out((String)("frst scan Data: " + firstSD.toString()));
            for (scanData sd : scan.sdList) {
                if (sd.l_scanIpv4Address != null == ipv4Present && sd.l_scanIpv6Address != null == ipv6Present) continue;
                Trace.out((String)("mismatched scanData :" + sd.toString()));
                errorMessage = s_msgBundle.getMessage("11373", true, (Object[])new String[]{scan.sName});
                this.m_resultSet.addResult(this.m_nodeList, 3);
                this.m_resultSet.addErrorDescription(errDesc);
                ReportUtil.printError(errorMessage);
                continue block9;
            }
        }
        HashSet<String> subnets = new HashSet<String>();
        for (Scan scan : scans) {
            if (scan.netIpv4Subnet != null) {
                subnets.add(scan.netIpv4Subnet);
            }
            if (scan.netIpv6Subnet == null) continue;
            subnets.add(scan.netIpv6Subnet);
        }
        Set<NetworkInfo> set = NetworkUtility.createClusterNetworksBasedOnSubnets(subnets.toArray(new String[0]));
        if (!VerificationUtil.isOPC()) {
            this.performSubnetCheck(scans, set);
        } else {
            Trace.out((String)"skipping subnet check in OPC");
        }
        if (isResourceRunning && this.m_resultSet.allSuccess()) {
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return true;
        }
        this.m_resultSet.addResult(this.m_nodeList, 3);
        return false;
    }

    private boolean matchPorts(List<Integer> portList1, List<Integer> portList2) {
        if (portList1 == null && portList2 == null) {
            return true;
        }
        if (portList1 == null && portList2 != null) {
            return false;
        }
        if (portList1 != null && portList2 == null) {
            return false;
        }
        if (portList1.size() != portList2.size()) {
            return false;
        }
        boolean matches = true;
        for (int i = 0; i < portList1.size(); ++i) {
            matches &= portList2.contains(portList1.get(i));
        }
        return matches;
    }

    private List<scanData> getScanDetailsPre12(String[] helperOut) {
        LinkedList<scanData> scanDetails = new LinkedList<scanData>();
        String[] scanDetailsArr = helperOut;
        ArrayList<String> scanNameList = new ArrayList<String>();
        if (scanDetailsArr != null && scanDetailsArr.length > 0) {
            Trace.out((String)("there are " + scanDetailsArr.length + " scan info"));
            for (int i = 0; i < scanDetailsArr.length; ++i) {
                String[] addrArray;
                Trace.out((String)("scan details = " + scanDetailsArr[i]));
                String scanLine = VerificationUtil.fetchTextByTags(scanDetailsArr[i], null, "<SCN_DETAILS>", "</SCN_DETAILS>");
                if (scanLine == null || scanLine.length() == 0) {
                    Trace.out((String)"not processing as scan info");
                    continue;
                }
                String scanName = VerificationUtil.fetchTextByTags(scanLine, null, "<SCN_NME>", "</SCN_NME>");
                String scanUserAssignedName = VerificationUtil.fetchTextByTags(scanDetailsArr[i], null, "<USR_ASGN_NAME>", "</USR_ASGN_NAME>");
                String scanAddress = VerificationUtil.fetchTextByTags(scanLine, null, "<SCN_ADDR>", "</SCN_ADDR>");
                if (VerificationUtil.isOPC() && (addrArray = scanAddress.split("/")).length == 2) {
                    scanAddress = addrArray[1];
                }
                String runNode = VerificationUtil.fetchTextByTags(scanLine, null, "<RUN_NODE>", "</RUN_NODE>");
                String lsnrName = VerificationUtil.fetchTextByTags(scanLine, null, "<LSNR_NME>", "</LSNR_NME>");
                String portStr = VerificationUtil.fetchTextByTags(scanLine, null, "<LSNR_PORT>", "</LSNR_PORT>");
                String vipRunStr = VerificationUtil.fetchTextByTags(scanLine, null, "<VIP_RUN>", "</VIP_RUN>");
                boolean vipRun = false;
                if (vipRunStr != null && vipRunStr.length() != 0) {
                    vipRun = Boolean.valueOf(vipRunStr);
                }
                String lsnrRunStr = VerificationUtil.fetchTextByTags(scanLine, null, "<LSNR_RUN>", "</LSNR_RUN>");
                boolean lsnrRun = false;
                if (lsnrRunStr != null && lsnrRunStr.length() != 0) {
                    lsnrRun = Boolean.valueOf(lsnrRunStr);
                }
                if (scanUserAssignedName == null || scanNameList.contains(scanUserAssignedName)) continue;
                scanNameList.add(scanUserAssignedName);
                scanDetails.add(new scanData(scanName, scanUserAssignedName, scanAddress, null, runNode, runNode, lsnrName, portStr.trim(), null, vipRun, lsnrRun));
            }
        }
        return scanDetails;
    }

    private List<Scan> getScanDetails(String[] helperOut) {
        ArrayList<Scan> scans = new ArrayList<Scan>();
        if (helperOut == null || helperOut.length == 0) {
            Trace.out((String)"No scan data");
            return scans;
        }
        for (String scanLine : helperOut) {
            String[] subnets;
            String sName = null;
            DHCPServerType netIpv4DhcpType = null;
            String netIpv4Subnet = null;
            DHCPServerType netIpv6DhcpType = null;
            String netIpv6Subnet = null;
            Trace.out((String)("scan details = " + scanLine));
            sName = VerificationUtil.fetchTextByTags(scanLine, "<SCN_NME>", "</SCN_NME>");
            Trace.out((String)("sName=" + sName));
            if (sName == null || sName.length() == 0) {
                Trace.out((String)"scanName is invalid. not processing scan info");
                continue;
            }
            String netDeatails = VerificationUtil.fetchTextByTags(scanLine, "<NET_DETAILS>", "</NET_DETAILS>");
            Trace.out((String)("netDeatails=" + netDeatails));
            if (netDeatails == null || netDeatails.length() == 0) {
                Trace.out((String)"netDeatails is invalid. not processing scan info");
                continue;
            }
            String dhcpType = VerificationUtil.fetchTextByTags(netDeatails, "<DHCP_TYPE_IPV4>", "</DHCP_TYPE_IPV4>");
            if (dhcpType != null && dhcpType.length() > 0) {
                netIpv4DhcpType = DHCPServerType.getMember((String)dhcpType);
            }
            if ((dhcpType = VerificationUtil.fetchTextByTags(netDeatails, "<DHCP_TYPE_IPV6>", "</DHCP_TYPE_IPV6>")) != null && dhcpType.length() > 0) {
                netIpv6DhcpType = DHCPServerType.getMember((String)dhcpType);
            }
            String strSubnets = VerificationUtil.fetchTextByTags(netDeatails, "<SUBNETS>", "</SUBNETS>");
            Trace.out((String)("strSubnets = " + strSubnets));
            if (strSubnets == null || strSubnets.length() == 0) {
                Trace.out((String)"strSubnets is not valid. not processing scan info");
                continue;
            }
            for (String strSubnet : subnets = VerificationUtil.fetchTextByTagsRepeat(strSubnets, "<SUBNET_DETAILS>", "</SUBNET_DETAILS>")) {
                Trace.out((String)("strSubnet= " + strSubnet));
                String subnetType = VerificationUtil.fetchTextByTags(strSubnet, "<SUBNET_TYPE>", "</SUBNET_TYPE>");
                String subnet = VerificationUtil.fetchTextByTags(strSubnet, "<SUBNET>", "</SUBNET>");
                IPAddressUtil.IPAddrType addrType = IPAddressUtil.getIPAddrTypeMember((String)subnetType);
                if (addrType == IPAddressUtil.IPAddrType.IPv4) {
                    netIpv4Subnet = subnet;
                    continue;
                }
                if (addrType != IPAddressUtil.IPAddrType.IPv6) continue;
                netIpv6Subnet = subnet;
            }
            String[] sVipDetails = VerificationUtil.fetchTextByTagsRepeat(scanLine, "<SCN_DETAILS>", "</SCN_DETAILS>");
            LinkedList<scanData> sdList = new LinkedList<scanData>();
            for (String sVipDetail : sVipDetails) {
                String[] vipAddrs;
                Object vipName = null;
                String scanIpv4Address = null;
                String scanIpv6Addres = null;
                String vipUserAssignedName = null;
                String vipRunNode = null;
                String lsnrNode = null;
                String lsnrName = null;
                int portNum = -1;
                boolean vipRunning = false;
                boolean lsnrRunning = false;
                Trace.out((String)("sVipDetail : " + sVipDetail));
                vipUserAssignedName = VerificationUtil.fetchTextByTags(sVipDetail, "<USR_ASGN_NAME>", "</USR_ASGN_NAME>");
                for (String vipAddr : vipAddrs = VerificationUtil.fetchTextByTagsRepeat(sVipDetail, "<SCN_ADDR_DETAILS>", "</SCN_ADDR_DETAILS>")) {
                    IPAddressUtil.IPAddrType addrType;
                    String[] addrArray;
                    Trace.out((String)("vipAddr = " + vipAddr));
                    String strAddrType = VerificationUtil.fetchTextByTags(vipAddr, "<ADDR_TYPE>", "</ADDR_TYPE>");
                    String strAddr = VerificationUtil.fetchTextByTags(vipAddr, "<SCN_ADDR>", "</SCN_ADDR>");
                    if (VerificationUtil.isOPC() && (addrArray = strAddr.split("/")).length == 2) {
                        strAddr = addrArray[1];
                    }
                    if ((addrType = IPAddressUtil.getIPAddrTypeMember((String)strAddrType)) == IPAddressUtil.IPAddrType.IPv4) {
                        scanIpv4Address = strAddr;
                        continue;
                    }
                    if (addrType != IPAddressUtil.IPAddrType.IPv6) continue;
                    scanIpv6Addres = strAddr;
                }
                vipRunNode = VerificationUtil.fetchTextByTags(sVipDetail, "<RUN_NODE>", "</RUN_NODE>");
                lsnrName = VerificationUtil.fetchTextByTags(sVipDetail, "<LSNR_NME>", "</LSNR_NME>");
                String strPort = VerificationUtil.fetchTextByTags(sVipDetail, "<LSNR_PORT>", "</LSNR_PORT>");
                String lsnrNodeInfo = VerificationUtil.fetchTextByTags(sVipDetail, "<LSNR_NODE_STATUS>", "</LSNR_NODE_STATUS>");
                if (VerificationUtil.isStringGood(lsnrNodeInfo)) {
                    lsnrNode = lsnrNodeInfo.substring(0, lsnrNodeInfo.indexOf(","));
                }
                String regInvitedNodes = VerificationUtil.fetchTextByTags(sVipDetail, "<REG_INVITED_NODES>", "</REG_INVITED_NODES>");
                String strRun = VerificationUtil.fetchTextByTags(sVipDetail, "<VIP_RUN>", "</VIP_RUN>");
                if (strRun != null && strRun.length() != 0) {
                    vipRunning = Boolean.valueOf(strRun);
                }
                if ((strRun = VerificationUtil.fetchTextByTags(sVipDetail, "<LSNR_RUN>", "</LSNR_RUN>")) != null && strRun.length() != 0) {
                    lsnrRunning = Boolean.valueOf(strRun);
                }
                scanData sd = new scanData(sName, vipUserAssignedName, scanIpv4Address, scanIpv6Addres, vipRunNode, lsnrNode, lsnrName, strPort.trim(), regInvitedNodes, vipRunning, lsnrRunning);
                sdList.add(sd);
            }
            Scan s = new Scan();
            s.sName = sName;
            s.netIPv4DhcpType = netIpv4DhcpType;
            s.netIpv4Subnet = netIpv4Subnet;
            s.netIpv6DhcpType = netIpv6DhcpType;
            s.netIpv6Subnet = netIpv6Subnet;
            s.sdList = sdList;
            Trace.out((String)("s :" + s));
            scans.add(s);
        }
        return scans;
    }

    private void performTnsPingCheck(List<scanData> scanDetails, String exeHome) {
        String tnsPingPath = exeHome + FSEP + "bin" + FSEP + "tnsping ";
        ArrayList<scanData> runningLsnrList = new ArrayList<scanData>();
        StringBuffer errSB = new StringBuffer();
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        boolean isUnix = nativeSystem.isUnixSystem();
        for (scanData scanItem : scanDetails) {
            if (!scanItem.getLsnrRunning()) continue;
            runningLsnrList.add(scanItem);
        }
        if (runningLsnrList.size() == 0) {
            return;
        }
        String scanMsg = LSEP + s_msgBundle.getMessage("5066", false);
        Task previousTaskReference = ReportUtil.setTaskReference(this);
        ReportUtil.sureprintln(scanMsg);
        if (ReportUtil.isVerbose()) {
            ReportUtil.reportFormatPrintln(scanMsg);
        }
        ReportUtil.setTaskReference(previousTaskReference);
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8059", false), s_msgBundle.getMessage("8061", false));
        for (scanData lsnrItem : runningLsnrList) {
            String connectString = null;
            String displayConnectString = null;
            String scanVIP = lsnrItem.getAddress();
            List portIDList = null;
            if (scanVIP == null) {
                Trace.out((String)("ipv4 address was not found for scan VIP name: " + lsnrItem.getVIPName() + ". Getting ipv6 address"));
                scanVIP = lsnrItem.getIpv6Address();
            }
            if (scanVIP == null) {
                String errorMessage = s_msgBundle.getMessage("5053", true);
                errSB.append(LSEP + errorMessage);
                ErrorDescription errDesc = new ErrorDescription(errorMessage);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
                continue;
            }
            if (scanVIP.startsWith("/")) {
                scanVIP = scanVIP.substring(1);
            }
            portIDList = lsnrItem.getPortList();
            for (int i = 0; i < portIDList.size(); ++i) {
                if (isUnix) {
                    connectString = "\\'\\(DESCRIPTION=\\(ADDRESS=\\(PROTOCOL=tcp\\)\\(HOST=" + scanVIP + "\\)\\(PORT=" + portIDList.get(i) + "\\)\\)\\)\\'";
                    if (!VerificationUtil.isLocalNode(this.m_localName)) {
                        connectString = "\"" + connectString + "\"";
                    }
                    displayConnectString = "'(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=" + scanVIP + ")(PORT=" + portIDList.get(i) + ")))'";
                } else {
                    connectString = "\"(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=" + scanVIP + ")(PORT=" + portIDList.get(i) + ")))\"";
                    displayConnectString = "\"(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=" + scanVIP + ")(PORT=" + portIDList.get(i) + ")))\"";
                }
                String lsnrName = lsnrItem.getLsnrName();
                String tnsPingCmd = tnsPingPath + connectString;
                String displayCmd = tnsPingPath + displayConnectString;
                Trace.out((String)("cmd = " + tnsPingCmd));
                Trace.out((String)("running tnsping from node " + this.m_localName));
                ResultSet rsltSet = new ResultSet();
                GlobalExecution globalExec = new GlobalExecution();
                if (isUnix) {
                    if (!VerificationUtil.isCVUTestEnv()) {
                        tnsPingCmd = "LD_LIBRARY_PATH= " + tnsPingCmd;
                    }
                    tnsPingCmd = "-cv_oh " + exeHome + " " + tnsPingCmd;
                    Trace.out((String)("tnsPingCmd='" + tnsPingCmd + "'"));
                }
                globalExec.runExe(new String[]{this.m_localName}, tnsPingCmd, rsltSet);
                Hashtable rsltTab = rsltSet.getResultTable();
                Enumeration e = rsltTab.keys();
                while (e.hasMoreElements()) {
                    boolean parseFlag = false;
                    String reportStatus = ReportUtil.YES;
                    String node = (String)e.nextElement();
                    Result result = (Result)rsltTab.get(node);
                    if (result.getStatus() == 1) {
                        String output = VerificationUtil.fetchVerificationValue((String)result.getResultInfoSet().get(1));
                        boolean execRes = VerificationUtil.fetchExecResult((String)result.getResultInfoSet().get(1));
                        output = output.trim();
                        Trace.out((String)("\nCommand output for: " + node + "\nOutput: " + output + "\n"));
                        Trace.out((String)("execResult = " + execRes));
                        if (output == null || output.length() == 0) {
                            Trace.out((String)"no output or command failed");
                            this.m_resultSet.addResult(node, 2);
                            String errorMessage = s_msgBundle.getMessage("5713", true, (Object[])new String[]{displayCmd, node});
                            ErrorDescription errDesc = new ErrorDescription(errorMessage);
                            this.m_resultSet.addErrorDescription(node, errDesc);
                            errSB.append(LSEP + errorMessage);
                            reportStatus = ReportUtil.NO;
                        } else {
                            String[] outlist = (String[])result.getResultInfoSet().get(0);
                            Vector outLines = new Vector();
                            for (int l = 0; l < outlist.length; ++l) {
                                outLines.addAll(VerificationUtil.getTokens(outlist[l], LSEP));
                            }
                            for (String line : outLines) {
                                if (line.matches("^OK \\([0-9]+ .*\\)")) {
                                    parseFlag = true;
                                    Trace.out((String)("tns ping success line = " + line));
                                    reportStatus = ReportUtil.YES;
                                    this.m_resultSet.addResult(node, 1);
                                    break;
                                }
                                if (line.matches("^TNS-[0-9]+:.*")) {
                                    parseFlag = true;
                                    reportStatus = ReportUtil.NO;
                                    Trace.out((String)("tns ping error line =" + line));
                                    String errorMessage = s_msgBundle.getMessage("5067", true, (Object[])new String[]{lsnrName, node}) + LSEP + line;
                                    errSB.append(LSEP + errorMessage);
                                    this.m_resultSet.addResult(node, 3);
                                    ErrorDescription errDesc = new ErrorDescription(errorMessage);
                                    this.m_resultSet.addErrorDescription(node, errDesc);
                                    break;
                                }
                                Trace.out((String)("out line=" + line));
                            }
                            if (!parseFlag) {
                                ErrorDescription errDesc;
                                String errorMessage = s_msgBundle.getMessage("5714", true, (Object[])new String[]{displayCmd, output});
                                errSB.append(LSEP + errorMessage);
                                if (!execRes) {
                                    reportStatus = ReportUtil.NO;
                                    this.m_resultSet.addResult(node, 3);
                                    errDesc = new ErrorDescription(errorMessage);
                                    this.m_resultSet.addErrorDescription(node, errDesc);
                                    Trace.out((String)"output not parsed and exit status not 0");
                                } else {
                                    reportStatus = ReportUtil.YES;
                                    this.m_resultSet.addResult(node, 1);
                                    errDesc = new ErrorDescription(errorMessage);
                                    this.m_resultSet.addErrorDescription(node, errDesc);
                                    Trace.out((String)"successful because of exit status");
                                }
                            }
                        }
                    } else {
                        reportStatus = ReportUtil.NO;
                        this.m_resultSet.addResult(node, 2);
                        String errorMessage = s_msgBundle.getMessage("5713", true, (Object[])new String[]{displayCmd, node});
                        ErrorDescription errDesc = new ErrorDescription(errorMessage);
                        this.m_resultSet.addErrorDescription(node, errDesc);
                        errSB.append(LSEP + errorMessage);
                    }
                    ReportUtil.writeRecord(node, lsnrName, reportStatus);
                }
            }
        }
        if (errSB.length() != 0) {
            ReportUtil.sureprintln(errSB.toString());
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5068", false));
        }
    }

    private ResultSet checkScanLsnrSocketFileAttributes(String lsnrNode, String lsnrName) {
        ResultSet permsCheckRes = new ResultSet();
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        String lsnrSocketFileName = VerificationUtil.getDomainSocketsDir() + FSEP + "s" + lsnrName.trim();
        Trace.out((String)"Chekcing scan lsnr socket file attributes");
        VerificationUtil.pathExists(new String[]{lsnrNode}, lsnrSocketFileName, 0, succNodes, failNodes);
        if (!succNodes.isEmpty()) {
            Hashtable<String, FileInfo> nodeHomePathAttrTable = VerificationUtil.getFileAttributes(lsnrSocketFileName, succNodes.toArray(new String[0]), permsCheckRes);
            FileInfo fileInfo = nodeHomePathAttrTable.get(lsnrNode);
            if (fileInfo != null) {
                String filePermissions = fileInfo.getFilePermissions();
                String fileOwner = fileInfo.getFileOwner();
                Trace.out((String)("scan lsnr socket file : " + lsnrSocketFileName + " has permissions " + filePermissions + "Owner : " + fileOwner + " on node " + lsnrNode));
                String expectedPerms = "0777";
                String expectedPerms1 = "777";
                if (!filePermissions.trim().equals(expectedPerms) && !filePermissions.trim().equals(expectedPerms1)) {
                    Trace.out((String)(lsnrSocketFileName + " file does not have " + "expected permissions :" + expectedPerms));
                    String errMsg = s_gMsgBundle.getMessage("11382", true, (Object[])new String[]{lsnrSocketFileName, lsnrNode, expectedPerms, filePermissions});
                    permsCheckRes.addErrorDescription(lsnrNode, new ErrorDescription(errMsg));
                    permsCheckRes.addResult(lsnrNode, 3);
                }
                Result result = new Result(lsnrNode);
                String crsUser = VerificationUtil.getCRSUser(lsnrNode, result, false);
                permsCheckRes.addResult(lsnrNode, result);
                Trace.out((String)("CRS user is : " + crsUser + " on node " + lsnrNode));
                if (VerificationUtil.isStringGood(crsUser) && VerificationUtil.isStringGood(fileOwner) && !crsUser.equals(fileOwner)) {
                    Trace.out((String)(lsnrSocketFileName + " file owner " + fileOwner + " is not the crs user :" + crsUser));
                    String errMsg = s_gMsgBundle.getMessage("11383", true, (Object[])new String[]{lsnrSocketFileName, lsnrNode, crsUser, fileOwner});
                    permsCheckRes.addErrorDescription(lsnrNode, new ErrorDescription(errMsg));
                    permsCheckRes.addResult(lsnrNode, 3);
                }
            }
        } else {
            Trace.out((String)("scan lsnr socket file " + lsnrSocketFileName + " does not exist on node " + lsnrNode + " Ignore and return."));
        }
        return permsCheckRes;
    }

    private void checkVNCRParameter(List<scanData> scanDetails, String crsHome) {
        HashMap<String, String> scanNodeLsnrMap = new HashMap<String, String>();
        HashMap<String, List> scanLsnrInvitedNodesMap = new HashMap<String, List>();
        for (scanData sd : scanDetails) {
            if (!sd.l_lsnrRunning || !VerificationUtil.isStringGood(sd.l_lsnrNode) || !VerificationUtil.isStringGood(sd.l_lsnrName)) continue;
            scanNodeLsnrMap.put(sd.l_lsnrNode, sd.l_lsnrName);
            scanLsnrInvitedNodesMap.put(sd.l_lsnrNode, sd.l_regInvitedNodes);
        }
        Set<Object> scanLsnrRunningNodes = new HashSet();
        if (!scanNodeLsnrMap.isEmpty()) {
            scanLsnrRunningNodes = scanNodeLsnrMap.keySet();
            scanLsnrRunningNodes.retainAll(Arrays.asList(this.m_nodeList));
        }
        if (scanLsnrRunningNodes.isEmpty()) {
            Trace.out((String)"Not found any scan lsnr running nodes. return.");
            return;
        }
        Trace.out((String)("Scan Lsnr running on nodes : " + scanLsnrRunningNodes));
        String[] clusterNodes = VerificationUtil.getNodelistFromOlsnodes();
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet resultSet = new ResultSet();
        String paramName = "VALID_NODE_CHECKING_REGISTRATION";
        String tnsAdminPath = VerificationUtil.getEnv("TNS_ADMIN");
        if (!VerificationUtil.isStringGood(tnsAdminPath) || VerificationUtil.isCVUTestEnv()) {
            tnsAdminPath = crsHome + FSEP + "network" + FSEP + "admin";
        }
        String lsnrCmd = !VerificationUtil.isPlatformWindows() ? "TNS_ADMIN=" + tnsAdminPath + " -cv_oh " + crsHome + " " + crsHome + FSEP + "bin" + FSEP + "lsnrctl" : "-cv_oh " + crsHome + " " + crsHome + FSEP + "bin" + FSEP + "lsnrctl.exe";
        String ldLibPath = VerificationUtil.getEnv("LD_LIBRARY_PATH");
        if (!VerificationUtil.isStringGood(ldLibPath)) {
            ldLibPath = crsHome + FSEP + "lib";
        }
        String[] env = new String[]{"LD_LIBRARY_PATH=" + ldLibPath};
        for (String string : scanLsnrRunningNodes) {
            String lsnrName = (String)scanNodeLsnrMap.get(string);
            String cmd = lsnrCmd + " show " + paramName + " " + lsnrName;
            Hashtable lsnrOutput = globalExec.runExeWithOutput(new String[]{string}, cmd, env, resultSet, false);
            Result result = resultSet.getResult(string);
            if (result != null && (result.getStatus() == 1 || result.getStatus() == 4)) {
                String execOut = (String)lsnrOutput.get(string);
                String lsnrCmdOut = VerificationUtil.fetchVerificationValue(execOut);
                String exitStat = VerificationUtil.fetchVerificationResult(execOut);
                Trace.out((String)("lsnrctl cmd on node:" + string + " retruned:" + lsnrCmdOut));
                Trace.out((String)("exitStat=" + exitStat));
                if (exitStat != null && exitStat.contentEquals("0")) {
                    String vncrValue = null;
                    if (VerificationUtil.isStringGood(lsnrCmdOut)) {
                        String[] lines;
                        for (String line : lines = lsnrCmdOut.split(LSEP)) {
                            if (!line.toUpperCase().contains(paramName)) continue;
                            Trace.out((String)("output line : " + line));
                            String[] vncrArr = line.split("\\s+");
                            vncrValue = vncrArr[vncrArr.length - 1];
                            Trace.out((String)("VNCR parameter set to : " + vncrValue));
                        }
                    }
                    if (!VerificationUtil.isStringGood(vncrValue) || !vncrValue.equalsIgnoreCase("ON") && !vncrValue.equals("1") && !vncrValue.equalsIgnoreCase("LOCAL")) continue;
                    Trace.out((String)"VNCR parameter for scan listeners enabled to allow registration only from local node IP addresses");
                    List lsnrInvitedNodes = (List)scanLsnrInvitedNodesMap.get(string);
                    if (lsnrInvitedNodes == null) continue;
                    ArrayList<String> nodesNotAllowedForReg = new ArrayList<String>();
                    boolean vncrEnabledLocal = false;
                    Trace.out((String)("lsnr invited nodes:'" + lsnrInvitedNodes));
                    if (!lsnrInvitedNodes.isEmpty() && clusterNodes != null) {
                        for (String clusterNode : clusterNodes) {
                            if (lsnrInvitedNodes.contains(clusterNode) || clusterNode.equals(string)) continue;
                            nodesNotAllowedForReg.add(clusterNode);
                            vncrEnabledLocal = true;
                        }
                    } else if (clusterNodes != null) {
                        nodesNotAllowedForReg.addAll(Arrays.asList(clusterNodes));
                        vncrEnabledLocal = true;
                    }
                    if (vncrEnabledLocal) {
                        Trace.out((String)"VNCR enabled to LOCAl in listener.ora file and all the clsuter nodes are not part of the  REGISTRATION_INVITED_NODES param");
                        String errMsg = s_gMsgBundle.getMessage("11381", true, (Object[])new String[]{lsnrName, vncrValue, string, VerificationUtil.strList2List(nodesNotAllowedForReg)});
                        this.m_resultSet.addErrorDescription(string, new ErrorDescription(errMsg));
                        this.m_resultSet.addResult(string, 3);
                        continue;
                    }
                    Trace.out((String)"REGISTRATION_INVITED_NODES contains all cluster nodes to allow register with scan lsnrs.");
                    continue;
                }
                Trace.out((String)("\ncommand: " + lsnrCmd + " failed on node '" + string + "'"));
                String errMsg = s_msgBundle.getMessage("5718", true, (Object[])new String[]{lsnrCmd, string, lsnrCmdOut});
                this.m_resultSet.addErrorDescription(string, new ErrorDescription(errMsg));
                this.m_resultSet.addResult(string, 2);
                continue;
            }
            Trace.out((String)("Failed to execute exectask command on node :" + string));
            String errMsg = s_msgBundle.getMessage("5302", true, (Object[])new String[]{string}) + LSEP + result.getExecutionErrorDetails();
            this.m_resultSet.addErrorDescription(string, new ErrorDescription(errMsg));
            this.m_resultSet.addResult(string, result);
        }
    }

    private void checkRegInvitedNodes(List<scanData> scanDetails) {
        HashMap scanNodeLsnrMap = new HashMap();
        HashMap scanLsnrInvitedNodesMap = new HashMap();
        for (scanData sd : scanDetails) {
            ArrayList<String> unresolvableNodes = new ArrayList<String>();
            if (sd.l_regInvitedNodes.isEmpty()) {
                Trace.out((String)("Not set the invited nodes for the scan lsnr: " + sd.l_lsnrName));
                continue;
            }
            Trace.out((String)("Validating reg invited nodes for scan lsnr:" + sd.l_lsnrName));
            for (String nodeName : sd.l_regInvitedNodes) {
                boolean invalidNodeName = false;
                Trace.out((String)("Checking " + nodeName + " is valid or not"));
                if (nodeName.endsWith("*")) {
                    String[] tokens = nodeName.split("\\.");
                    if (tokens.length > 4) {
                        invalidNodeName = true;
                    } else {
                        for (int i = 0; i < tokens.length - 1; ++i) {
                            if (tokens[i].matches("\\d+") && (!tokens[i].matches("\\d+") || tokens[i].length() <= 3)) continue;
                            Trace.out((String)("Found invalid token " + tokens[i]));
                            invalidNodeName = true;
                            break;
                        }
                        String lastToken = tokens[tokens.length - 1];
                        if (!(lastToken = lastToken.substring(0, lastToken.indexOf("*"))).matches("\\d+")) {
                            Trace.out((String)("Found invalid token " + lastToken));
                            invalidNodeName = true;
                        }
                    }
                } else {
                    int index = nodeName.lastIndexOf("/");
                    if (index != -1) {
                        nodeName = nodeName.substring(0, index);
                    }
                    InetAddress ipAddress = null;
                    try {
                        ipAddress = InetAddress.getByName(nodeName.trim());
                    }
                    catch (UnknownHostException uhe) {
                        Trace.out((String)(nodeName + " is not resolvable"));
                        invalidNodeName = true;
                    }
                }
                if (!invalidNodeName) continue;
                unresolvableNodes.add(nodeName);
            }
            if (unresolvableNodes.isEmpty()) continue;
            Trace.out((String)("Registration invited nodes for scan lsnr " + sd.l_lsnrName + " contains unresolvable nodes :" + unresolvableNodes));
            String unresolvNodes = VerificationUtil.strList2List(unresolvableNodes);
            String errMsg = s_gMsgBundle.getMessage("11384", true, (Object[])new String[]{sd.l_lsnrName, unresolvNodes});
            this.m_resultSet.addErrorDescription(sd.l_lsnrNode, new ErrorDescription(errMsg));
            if (!sd.l_lsnrRunning) {
                this.m_resultSet.addResult(sd.l_lsnrNode, 3);
                continue;
            }
            this.m_resultSet.addResult(sd.l_lsnrNode, 4);
        }
    }

    private boolean performTaskPre() {
        boolean retVal = true;
        String scanName = null;
        String errorMessage = null;
        try {
            InetAddress[] scanAddrs;
            ResultSet networksResultSet = new ResultSet();
            Set<NetworkInfo> clusterNetworks = NetworkDataDiscovery.getClusterNetworksFromCVUVariable(networksResultSet);
            if (!NetworkUtility.isNetworksSetGood(clusterNetworks) || networksResultSet.anyFailure()) {
                Trace.out((String)"Could not get cluster networks from CVU variable during SCAN pre checks");
                NetworkUtility.reportResultSet(networksResultSet, this.m_resultSet, true);
                return false;
            }
            if (!NetworkDataDiscovery.hasNetworkTypeInClusterNetworks(clusterNetworks, NetworkConstants.NetworkType.PUBLIC.getValue())) {
                Trace.out((String)"No public cluster networks found during SCAN pre checks.  Hence returning success");
                return true;
            }
            clusterNetworks = NetworkDataDiscovery.getClusterNetworksByType(clusterNetworks, NetworkConstants.NetworkType.PUBLIC);
            String pubSubnet = NetworkDataDiscovery.getClusterNetworkSubnets(clusterNetworks).get(0);
            IPAddressUtil.IPAddrType ipType = IPAddressUtil.getIPAddrTypeFromIPAddress((String)pubSubnet);
            scanName = CVUVariables.getValue(CVUVariableConstants.SCAN_NAME);
            Scan s = new Scan();
            s.sName = scanName;
            if (ipType == IPAddressUtil.IPAddrType.IPv6) {
                s.netIpv6Subnet = pubSubnet;
                s.netIpv6DhcpType = DHCPServerType.getMember((String)"static");
            } else {
                s.netIpv4Subnet = pubSubnet;
                s.netIPv4DhcpType = DHCPServerType.getMember((String)"static");
            }
            s.sdList = new ArrayList<scanData>();
            for (InetAddress scanAddr : scanAddrs = InetAddress.getAllByName(scanName)) {
                Trace.out((String)("scanAddr = " + scanAddr));
                String addressIpv4 = null;
                String addressIpv6 = null;
                if (scanAddr instanceof Inet4Address) {
                    addressIpv4 = scanAddr.getHostAddress();
                    Trace.out((String)("addressIpv4=" + addressIpv4 + " is an ipv4 address"));
                } else {
                    addressIpv6 = scanAddr.getHostAddress();
                    Trace.out((String)("addressIpv6=" + addressIpv6 + " is an ipv6 address"));
                }
                scanData sd = new scanData(scanName, scanName, addressIpv4, addressIpv6, null, null, null, null, null, false, false);
                s.sdList.add(sd);
            }
            ArrayList<Scan> scans = new ArrayList<Scan>();
            scans.add(s);
            retVal = this.performSubnetCheck(scans, clusterNetworks);
        }
        catch (CVUException cvuException) {
            errorMessage = cvuException.getMessage();
            Trace.out((String)"CVUException occured");
            ResultSet.updateResultSetWithErrorDescription(errorMessage, this.m_resultSet, this.m_nodeList, false, true);
            errorMessage = s_gMsgBundle.getMessage("11374", true, (Object[])new String[]{scanName});
            retVal = false;
        }
        catch (UnknownHostException unknownHostException) {
            Trace.out((String)("UnknownHostException occured. message: " + unknownHostException.getMessage()));
            errorMessage = unknownHostException.getMessage();
            ResultSet.updateResultSetWithErrorDescription(errorMessage, this.m_resultSet, this.m_nodeList, false, true);
            errorMessage = s_gMsgBundle.getMessage("11374", true, (Object[])new String[]{scanName});
            retVal = false;
        }
        if (!retVal) {
            ResultSet.updateResultSetWithErrorDescription(errorMessage, this.m_resultSet, this.m_nodeList, false, true);
        } else {
            this.m_resultSet.addResult(this.m_nodeList, 1);
        }
        return retVal;
    }

    private boolean performSubnetCheck(List<Scan> scans, Set<NetworkInfo> clusterNetworks) {
        boolean retVal = true;
        HashSet<NetworkInfo> matchingNetworksOnNode = new HashSet();
        ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("11365", false));
        clusterNetworks = NetworkDataDiscovery.getClusterNetworksByType(clusterNetworks, NetworkConstants.NetworkType.PUBLIC);
        Trace.out((String)("Getting the networks matching the public cluster network on node " + this.m_nodeList[0]));
        ResultSet networksResultSet = new ResultSet();
        matchingNetworksOnNode = NetworkDataDiscovery.getMatchingNetworksOnNode(this.m_nodeNetworksMap, clusterNetworks, this.m_nodeList[0], this.m_resultSet);
        if (!NetworkUtility.isNetworksSetGood(matchingNetworksOnNode) || networksResultSet.anyFailure()) {
            Trace.out((String)"Could not discover the matching network details during SCAN subnet check");
            NetworkUtility.reportResultSet(networksResultSet, this.m_resultSet, true);
            return false;
        }
        if (!NetworkUtility.isNetworksSetGood(matchingNetworksOnNode = NetworkDataDiscovery.getNetworksWithStatusUp(matchingNetworksOnNode))) {
            Trace.out((String)"Could not find any matching network with status UP");
            String errorMessage = s_gMsgBundle.getMessage("11086", true, (Object[])new String[]{this.m_nodeList[0]});
            ResultSet.updateResultSetWithErrorDescription(errorMessage, this.m_resultSet, this.m_nodeList, true, true);
            return false;
        }
        for (Scan scan : scans) {
            List<scanData> activeSDs;
            Trace.out((String)("checking SCAN IP addresses of SCAN " + scan.sName));
            ArrayList<scanData> badSdList = new ArrayList<scanData>();
            Trace.out((String)"classifying scan ips by subnet");
            Map<String, List<scanData>> subnetMap = this.classifyVIPsBySubnet(scan, matchingNetworksOnNode, badSdList);
            if (badSdList.size() != 0) {
                StringBuilder ipv4Ips = new StringBuilder();
                StringBuilder ipv6Ips = new StringBuilder();
                for (scanData sd : badSdList) {
                    if (sd.l_scanIpv4Address != null) {
                        if (ipv4Ips.length() != 0) {
                            ipv4Ips.append(',');
                        }
                        ipv4Ips.append(sd.l_scanIpv4Address);
                    }
                    if (sd.l_scanIpv6Address == null) continue;
                    if (ipv6Ips.length() != 0) {
                        ipv6Ips.append(',');
                    }
                    ipv6Ips.append(sd.l_scanIpv6Address);
                }
                String errorMessage = null;
                if (ipv4Ips.length() != 0) {
                    Trace.out((String)("SCAN IPs " + ipv4Ips + " can not be on any of the " + "public subnets " + scan.netIpv4Subnet));
                    errorMessage = this.m_isPreCRS ? s_gMsgBundle.getMessage("11366", true, (Object[])new String[]{ipv4Ips.toString(), scan.sName, scan.netIpv4Subnet}) : s_gMsgBundle.getMessage("11367", true, (Object[])new String[]{ipv4Ips.toString(), scan.sName, scan.netIpv4Subnet});
                    ResultSet.updateResultSetWithErrorDescription(errorMessage, this.m_resultSet, this.m_nodeList, true, true);
                    retVal = false;
                }
                if (ipv6Ips.length() != 0) {
                    Trace.out((String)("SCAN IPs " + ipv6Ips + " can not be on any of the " + "public subnets " + scan.netIpv6Subnet));
                    errorMessage = this.m_isPreCRS ? s_gMsgBundle.getMessage("11366", true, (Object[])new String[]{ipv6Ips.toString(), scan.sName, scan.netIpv6Subnet}) : s_gMsgBundle.getMessage("11367", true, (Object[])new String[]{ipv6Ips.toString(), scan.sName, scan.netIpv6Subnet});
                    ResultSet.updateResultSetWithErrorDescription(errorMessage, this.m_resultSet, this.m_nodeList, true, true);
                    retVal = false;
                }
            }
            if (badSdList.size() == scan.sdList.size()) {
                Trace.out((String)"All SCAN IP addresses are bad.");
                retVal = false;
                continue;
            }
            if (scan.netIpv4Subnet != null && scan.netIPv4DhcpType != DHCPServerType.NONE || scan.netIpv6Subnet != null && scan.netIpv6DhcpType != DHCPServerType.AUTOCONFIG) {
                Trace.out((String)"SCAN VIP are not GNS configured. skip minimun number of SCAN VIPs check");
                continue;
            }
            for (String subnet : subnetMap.keySet()) {
                List<scanData> sdList = subnetMap.get(subnet);
                if (sdList.size() >= MIN_SCAN_IPS || sdList.size() == 1 && VerificationUtil.isCVUTestEnv()) continue;
                String strScanIps = this.getScanIps(sdList);
                String ipsNeeded = Integer.toString(MIN_SCAN_IPS - sdList.size());
                Trace.out((String)("Scan Ips must be more than " + ipsNeeded + " but only " + strScanIps + " were found on subnet " + subnet));
                String errorMessage = s_gMsgBundle.getMessage("11368", true, (Object[])new String[]{String.valueOf(MIN_SCAN_IPS), scan.sName, strScanIps});
                this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errorMessage));
                ReportUtil.printWarning(errorMessage);
                this.m_resultSet.addResult(this.m_nodeList, 4);
                retVal = false;
            }
            if (!this.m_isPreCRS || VerificationUtil.isUpgrade() || (activeSDs = this.checkReachability(scan.sdList, true)).size() <= 0) continue;
            String errorMessage = s_gMsgBundle.getMessage("11369", true, (Object[])new String[]{this.getScanIps(activeSDs), scan.sName});
            ResultSet.updateResultSetWithErrorDescription(errorMessage, this.m_resultSet, this.m_nodeList, true, false);
            ReportUtil.sureprintln(errorMessage);
            retVal = false;
        }
        if (retVal) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11370", false));
        } else {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11371", false));
        }
        return retVal;
    }

    private List<scanData> checkReachability(List<scanData> sdList, boolean bActive) {
        ClusterCmd cmd = new ClusterCmd();
        ArrayList<scanData> retVals = new ArrayList<scanData>();
        String[] nodes = null;
        for (scanData sd : sdList) {
            try {
                if (sd.l_scanIpv4Address != null && sd.l_scanIpv6Address != null) {
                    nodes = new String[]{sd.l_scanIpv4Address, sd.l_scanIpv6Address};
                } else if (sd.l_scanIpv4Address != null) {
                    nodes = new String[]{sd.l_scanIpv4Address};
                } else if (sd.l_scanIpv6Address != null) {
                    nodes = new String[]{sd.l_scanIpv6Address};
                } else {
                    Trace.out((String)("both addresses are null. scanData: " + sd.toString()));
                    continue;
                }
                if (cmd.areNodesAlive(nodes, 30, null) != bActive) continue;
                retVals.add(sd);
            }
            catch (ClusterException cex) {
                VerificationUtil.traceAndLogError("CLUSTEREXCEPTION: " + cex.getMessage() + "\n" + Trace.getStackTrace((Throwable)cex));
                if (bActive) continue;
                retVals.add(sd);
            }
            catch (RemoteFileOperationException rex) {
                VerificationUtil.traceAndLogError("REMOTEFILEOPERATIONEXCEPTION: callingareNodesAlive message:" + rex.getMessage() + "\n" + Trace.getStackTrace((Throwable)rex));
                if (bActive) continue;
                retVals.add(sd);
            }
        }
        return retVals;
    }

    private String getScanIps(List<scanData> sdList) {
        String scanIPs = null;
        for (scanData sd : sdList) {
            if (scanIPs == null) {
                scanIPs = sd.getAddress();
                continue;
            }
            scanIPs = scanIPs + "," + sd.getAddress();
        }
        return scanIPs == null ? "" : scanIPs;
    }

    private Map<String, List<scanData>> classifyVIPsBySubnet(Scan scan, Set<NetworkInfo> networks, List<scanData> badSdList) {
        HashMap<String, List<scanData>> subnetMap = new HashMap<String, List<scanData>>();
        List<scanData> sdList = scan.sdList;
        List<scanData> sds = null;
        for (scanData sd : sdList) {
            InetAddress scanIPv4 = null;
            InetAddress scanIPv6 = null;
            String scanIP = null;
            try {
                if (sd.l_scanIpv4Address != null) {
                    scanIP = sd.l_scanIpv4Address.replaceFirst("/", "");
                    scanIPv4 = InetAddress.getByName(scanIP);
                }
                if (sd.l_scanIpv6Address != null) {
                    scanIP = sd.l_scanIpv6Address.replaceFirst("/", "");
                    scanIPv6 = InetAddress.getByName(scanIP);
                }
                InetAddress subnetIPv4 = null;
                InetAddress subnetIPv6 = null;
                for (NetworkInfo network : networks) {
                    if (scanIPv4 != null && NetworkUtility.isIPV4(network, false) && this.checkSubNetwork(scanIPv4, network)) {
                        subnetIPv4 = network.getSubnet();
                    }
                    if (scanIPv6 == null || !NetworkUtility.isIPV6(network, false) || !this.checkSubNetwork(scanIPv6, network)) continue;
                    subnetIPv6 = network.getSubnet();
                }
                scanData badSd = null;
                Trace.out((String)("scanIPv4 = " + scanIPv4 + ", subnetIPv4 = " + subnetIPv4 + ", scan.netIpv4Subnet = " + scan.netIpv4Subnet));
                if (!(scanIPv4 == null || subnetIPv4 != null && subnetIPv4.equals(InetAddress.getByName(scan.netIpv4Subnet)))) {
                    Trace.out((String)("Scan VIP4 " + scanIPv4 + " did not have any " + "common subnet"));
                    badSd = new scanData(sd);
                    badSd.l_scanIpv6Address = null;
                    badSdList.add(badSd);
                }
                Trace.out((String)("scanIPv6 = " + scanIPv6 + ", subnetIPv6 = " + subnetIPv6 + ", scan.netIpv6Subnet = " + scan.netIpv6Subnet));
                if (!(scanIPv6 == null || subnetIPv6 != null && subnetIPv6.equals(InetAddress.getByName(scan.netIpv6Subnet)))) {
                    badSd = new scanData(sd);
                    badSd.l_scanIpv4Address = null;
                    Trace.out((String)("Scan VIP6" + scanIPv6 + " did not have any common subnet"));
                    badSdList.add(badSd);
                }
                if (badSd != null) continue;
                Trace.out((String)("adding " + sd.l_vipUserAssignedName + " to subnet map " + subnetIPv4 + " and/or " + subnetIPv6));
                if (subnetIPv4 != null) {
                    sds = (ArrayList<scanData>)subnetMap.get(subnetIPv4.getHostAddress());
                    if (sds == null) {
                        sds = new ArrayList<scanData>();
                        subnetMap.put(subnetIPv4.getHostAddress(), sds);
                    }
                    sds.add(sd);
                }
                if (subnetIPv6 == null) continue;
                sds = (List)subnetMap.get(subnetIPv6.getHostAddress());
                if (sds == null) {
                    sds = new ArrayList();
                    subnetMap.put(subnetIPv6.getHostAddress(), sds);
                }
                sds.add(sd);
            }
            catch (UnknownHostException uhEx) {
                Trace.out((String)("UnknownHostException occured while getting scan address: " + sd.getAddress()));
                Trace.out((Exception)uhEx);
                this.m_resultSet.addErrorDescription(new ErrorDescription(uhEx.getMessage()));
            }
        }
        return subnetMap;
    }

    private boolean checkSubNetwork(InetAddress scanIP, NetworkInfo network) throws UnknownHostException {
        byte[] netmask;
        int i = 0;
        byte[] ip1 = scanIP.getAddress();
        if (ip1.length != (netmask = network.getSubnetMask().getAddress()).length) {
            Trace.out((String)("scanIP '" + scanIP + "' and  NetworkInfo '" + network.toString() + "' are not same type of address family"));
            String errorMessage = MessageBundle.getMessage((MessageKey)PrCiMsgID.IPADDR_SUBNETMASK_LENGTH_MISMATCH, (boolean)true, (Object[])new Object[]{scanIP, network.getSubnetMaskAsString()});
            ReportUtil.sureprintln(errorMessage);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(errorMessage);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        byte[] subnet = new byte[ip1.length];
        for (i = 0; i < ip1.length; ++i) {
            subnet[i] = (byte)(ip1[i] & netmask[i]);
        }
        byte[] ifSubnet = network.getSubnet().getAddress();
        for (i = 0; i < ifSubnet.length && subnet[i] == ifSubnet[i]; ++i) {
        }
        return i == ifSubnet.length;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("9500", false);
    }

    @Override
    public String getTaskID() {
        return TASK_TYPE;
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("9600", false);
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }

    private class Scan {
        String sName = null;
        DHCPServerType netIPv4DhcpType;
        String netIpv4Subnet = null;
        DHCPServerType netIpv6DhcpType;
        String netIpv6Subnet = null;
        List<scanData> sdList = new ArrayList<scanData>();
        HashSet<String> scanVIPAdressListFromDNS = new HashSet();

        private Scan() {
        }

        public String getSubnets() {
            StringBuilder subnets = new StringBuilder();
            if (this.netIpv4Subnet != null) {
                subnets.append(this.netIpv4Subnet);
            }
            if (subnets.length() != 0 && this.netIpv6Subnet != null) {
                subnets.append(',');
            }
            if (this.netIpv6Subnet != null) {
                subnets.append(this.netIpv6Subnet);
            }
            return subnets.toString();
        }

        public int getVipAddrsSize() {
            int nVipSize = 0;
            for (scanData sd : this.sdList) {
                if (sd.getAddress() != null) {
                    ++nVipSize;
                }
                if (sd.getIpv6Address() == null) continue;
                ++nVipSize;
            }
            return nVipSize;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\nscanName: ");
            sb.append(this.sName);
            sb.append("\nnetIPv4DhcpType: ");
            sb.append(this.netIPv4DhcpType);
            sb.append("\nnetIpv4Subnet: ");
            sb.append(this.netIpv4Subnet);
            sb.append("\nnetIpv6DhcpType: ");
            sb.append(this.netIpv6DhcpType);
            sb.append("\nnetIpv6Subnet: ");
            sb.append(this.netIpv6Subnet);
            for (scanData sd : this.sdList) {
                sb.append("\n===============");
                sb.append(sd.toString());
            }
            return sb.toString();
        }
    }

    private class scanData {
        private String l_vipName;
        private String l_scanIpv4Address;
        private String l_scanIpv6Address;
        private String l_vipUserAssignedName;
        private String l_vipRunNode;
        private String l_lsnrNode;
        private String l_lsnrName;
        private List<Integer> l_portNumList = new ArrayList<Integer>();
        private List<String> l_regInvitedNodes = new ArrayList<String>();
        private boolean l_vipRunning;
        private boolean l_lsnrRunning;

        private scanData(String vipName, String userAssignedName, String addressIpv4, String addressIpv6, String vipRunNode, String lsnrNode, String lsnrName, String portNumList, String regInvitedNodes, boolean vipRunning, boolean lsnrRunning) {
            this.l_vipName = vipName;
            this.l_vipUserAssignedName = userAssignedName;
            this.l_scanIpv4Address = addressIpv4;
            this.l_scanIpv6Address = addressIpv6;
            this.l_vipRunNode = vipRunNode;
            this.l_lsnrNode = lsnrNode;
            this.l_lsnrName = lsnrName;
            if (VerificationUtil.isStringGood(portNumList)) {
                String[] portNumStrArray = portNumList.split("\\s+");
                for (int i = 0; i < portNumStrArray.length; ++i) {
                    try {
                        this.l_portNumList.add(Integer.parseInt(portNumStrArray[i]));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        Trace.out((String)nfe.getMessage());
                    }
                }
            }
            if (VerificationUtil.isStringGood(regInvitedNodes)) {
                this.l_regInvitedNodes.addAll(Arrays.asList(VerificationUtil.string2strArr(regInvitedNodes.trim())));
            }
            this.l_vipRunning = vipRunning;
            this.l_lsnrRunning = lsnrRunning;
        }

        private scanData(scanData sd) {
            this.l_vipName = sd.l_vipName;
            this.l_vipUserAssignedName = sd.l_vipUserAssignedName;
            this.l_scanIpv4Address = sd.l_scanIpv4Address;
            this.l_scanIpv6Address = sd.l_scanIpv6Address;
            this.l_vipRunNode = sd.l_vipRunNode;
            this.l_lsnrName = sd.l_lsnrName;
            for (int i = 0; i < sd.l_portNumList.size(); ++i) {
                this.l_portNumList.add(sd.l_portNumList.get(i));
            }
            this.l_vipRunning = sd.l_vipRunning;
            this.l_lsnrRunning = sd.l_lsnrRunning;
        }

        private String getAddress() {
            return this.l_scanIpv4Address;
        }

        private String getIpv6Address() {
            return this.l_scanIpv6Address;
        }

        private String getVIPName() {
            return this.l_vipName;
        }

        private String getUserAssignedName() {
            return this.l_vipUserAssignedName;
        }

        private String getVipRunNode() {
            return this.l_vipRunNode;
        }

        private String getLsnrNode() {
            return this.l_lsnrNode;
        }

        private String getLsnrName() {
            return this.l_lsnrName;
        }

        private List<Integer> getPortList() {
            return this.l_portNumList;
        }

        private List<String> getRegInvitedNodes() {
            return this.l_regInvitedNodes;
        }

        private boolean getVipRunning() {
            return this.l_vipRunning;
        }

        private boolean getLsnrRunning() {
            return this.l_lsnrRunning;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n    vipName: " + this.l_vipName);
            sb.append("\n    ipv4Address: " + this.l_scanIpv4Address);
            sb.append("\n    ipv6Address: " + this.l_scanIpv6Address);
            sb.append("\n    vipRunNode: " + this.l_vipRunNode);
            sb.append("\n    lsnrNode: " + this.l_lsnrNode);
            sb.append("\n    lsnrName: " + this.l_lsnrName);
            sb.append("\n    port: " + this.l_portNumList);
            sb.append("\n    vipRunning: " + this.l_vipRunning);
            sb.append("\n    lsnrRunning: " + this.l_lsnrRunning);
            sb.append("\n");
            return sb.toString();
        }
    }
}

