/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskResolvConfIntegrity;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskResolvConfIntegrity
extends Task {
    sTaskResolvConfIntegrity s_sTaskResolvConfIntegrity;

    public TaskResolvConfIntegrity(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        this.s_sTaskResolvConfIntegrity = new sTaskResolvConfIntegrity(this.m_nodeList, null, 1);
        VerificationType vType = this.m_globalContext.getVerificationType();
        switch (vType) {
            case PREREQ_RACNODE_ADD: 
            case PREREQ_NODE_ADD: {
                String[] addNodeList = VerificationUtil.addLocalNodeToNodeList(this.m_nodeList);
                this.setNodeList(addNodeList);
                this.s_sTaskResolvConfIntegrity.setNodeList(addNodeList);
            }
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (VerificationUtil.skipTask(this)) {
            VerificationUtil.traceAndLog("This task " + this.getDefaultTaskID() + " is requested to be skipped" + " and hence not added to the taskList");
            return false;
        }
        VerificationType vType = this.m_globalContext.getVerificationType();
        switch (vType) {
            case PREREQ_CRS_INST: {
                if (!this.m_globalContext.isCRSSoftwareOnlyInstall()) break;
                VerificationUtil.traceAndLog("Skipping Resolve conf integrity check as this is a software only install.");
                return false;
            }
        }
        return true;
    }

    public TaskResolvConfIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskResolvConfIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskResolvConfIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.s_sTaskResolvConfIntegrity = new sTaskResolvConfIntegrity(this.m_nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public String getDefaultDescription() {
        return this.s_sTaskResolvConfIntegrity != null ? this.s_sTaskResolvConfIntegrity.getDefaultDescription() : s_msgBundle.getMessage("5633", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("5633", false);
    }

    @Override
    public String getTaskID() {
        return "RESOLV_CONF";
    }

    @Override
    public boolean performTask() {
        String msg;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!nativeSystem.isUnixSystem()) {
            return true;
        }
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("2006", false, (Object[])new String[]{this.s_sTaskResolvConfIntegrity.getResolvConfLocation()}) + VerificationConstants.LSEP);
        if (this.hasRunBefore()) {
            this.init();
        }
        this.s_sTaskResolvConfIntegrity.performTask();
        this.m_resultSet.uploadResultSet(this.s_sTaskResolvConfIntegrity.getResultSet());
        ResultSet ssResolvConf = this.s_sTaskResolvConfIntegrity.getResultSet();
        String[] failNodes = (String[])ssResolvConf.getFailedNodes().toArray();
        if (ssResolvConf.allSuccess() || failNodes.length == 0) {
            msg = s_gMsgBundle.getMessage("2007", false, (Object[])new String[]{this.s_sTaskResolvConfIntegrity.getResolvConfLocation()}) + VerificationConstants.LSEP;
        } else {
            msg = s_gMsgBundle.getMessage("2008", false, (Object[])new String[]{this.s_sTaskResolvConfIntegrity.getResolvConfLocation()}) + VerificationConstants.LSEP;
            Trace.out((String)("RESLOV_CONF failed on nodes: '" + VerificationUtil.strArr2List(failNodes) + "'"));
            this.m_resultSet.addResult(failNodes, 3);
            this.m_resultSet.addErrorDescription(failNodes, new ErrorDescription(msg));
        }
        ReportUtil.sureprintln(VerificationConstants.LINE_SEPARATOR + msg);
        return this.m_resultSet.allSuccess();
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }
}

