/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.fixup.FixupData;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskPinNodes
extends Task {
    String chkPinHost = null;

    public TaskPinNodes(VerificationTaskContext ctx) {
        super(ctx);
    }

    public TaskPinNodes(String[] nodeList) {
        super(nodeList);
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        String actCRSVer;
        String reqRel = VerificationUtil.getRequestedRelease();
        return reqRel != null && (reqRel.equalsIgnoreCase("10gR1") || reqRel.equalsIgnoreCase("10.1") || reqRel.equalsIgnoreCase("10gR2") || reqRel.equalsIgnoreCase("10.2") || reqRel.equalsIgnoreCase("11gR1") || reqRel.equalsIgnoreCase("11.1")) && this.m_globalContext.isCRSConfigured() && VerificationUtil.isVersionPost(actCRSVer = VerificationUtil.getCRSActiveVersion(), "11.2");
    }

    @Override
    public boolean performTask() {
        GlobalExecution globalExec = new GlobalExecution();
        ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
        ResultSet pinRsltSet = new ResultSet();
        String crsHome = null;
        ArrayList<String> nodeList = null;
        Trace.out((String)"ENTRY");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4364", false));
        crsHome = VerificationUtil.getCRSHome();
        if (crsHome == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Failed to retrieve CRS home");
            }
            this.m_resultSet.addErrorDescription(new ErrorDescription("5301", s_msgBundle));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        Trace.out((String)("CRS home is: '" + crsHome + "'"));
        try {
            Version verCRSSoft;
            if (clusterwareInfo.isCRSRunning(crsHome) && ((verCRSSoft = VerificationUtil.getCRSSoftwareVersionObj()) == null || verCRSSoft != null && Version.isPre112((Version)verCRSSoft))) {
                if (verCRSSoft == null) {
                    Trace.out((String)"CRS version is null.");
                } else {
                    Trace.out((String)("Version specified was : " + verCRSSoft.toString()));
                }
                return true;
            }
        }
        catch (InstallException ie) {
            Trace.out((String)("CRS is not configured \n" + ie.getMessage()));
            this.m_resultSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("1016", true)));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        nodeList = new ArrayList<String>(Arrays.asList(this.m_nodeList));
        this.chkPinHost = this.m_nodeList.length == 0 ? m_localNode : this.m_nodeList[0];
        String cmdSpec = crsHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + new SystemFactory().CreateSystem().getExeName("olsnodes") + " -t -n";
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("\nCommand Syntax: " + cmdSpec + "\nCommand Host: '" + this.chkPinHost + "'"));
        }
        ResultSet chkPinResultSet = new ResultSet();
        Hashtable chkPinOutput = globalExec.runExeWithOutput(new String[]{this.chkPinHost}, cmdSpec, chkPinResultSet);
        String output = (String)chkPinOutput.get(this.chkPinHost);
        String cmdOutput = VerificationUtil.fetchVerificationValue(output);
        String exitStat = VerificationUtil.fetchVerificationResult(output);
        if (exitStat != null && exitStat.contentEquals("0")) {
            String[] chkPinOutputLines;
            Trace.out((int)5, (String)"Command succeeded");
            ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.COMMENT);
            for (String outLine : chkPinOutputLines = VerificationUtil.string2strArr(cmdOutput, VerificationUtil.LINE_SEPARATOR)) {
                String comment;
                String pinStatus;
                StringTokenizer st = new StringTokenizer(outLine);
                if (outLine.length() == 0 || st.countTokens() < 3) continue;
                String nodePinName = st.nextToken();
                String nodePinNum = st.nextToken();
                String nodePinStatus = st.nextToken();
                Trace.out((int)5, (String)("\nPinName: '" + nodePinName + "'" + "\nPinNum: '" + nodePinNum + "'" + "\nPinStatus: '" + nodePinStatus + "'"));
                if (!nodeList.contains(nodePinName)) continue;
                if (nodePinStatus.contentEquals("Pinned")) {
                    Trace.out((int)5, (String)"Verification Successful!");
                    nodeList.remove(nodePinName);
                    pinStatus = ReportUtil.PINNED;
                    comment = ReportUtil.PASSED;
                    this.m_resultSet.addResult(nodePinName, 1);
                } else if (nodePinStatus.contentEquals("Unpinned")) {
                    Trace.out((int)5, (String)"Verification FAILED!");
                    pinStatus = ReportUtil.NOT_PINNED;
                    comment = ReportUtil.FAILED;
                    this.m_resultSet.addResult(nodePinName, 3);
                } else {
                    Trace.out((int)5, (String)("No Pinned/Unpinned state!: \n" + outLine));
                    continue;
                }
                ReportUtil.writeRecord(nodePinName, pinStatus, comment);
            }
        } else {
            Trace.out((int)5, (String)"Command FAILED!");
            String pinStatus = ReportUtil.UNKNOWN;
            String comment = ReportUtil.UNKNOWN;
            ErrorDescription errDesc = new ErrorDescription("4363", s_msgBundle);
            for (String errNode : this.m_nodeList) {
                Trace.out((String)("olsnodes command failed on node: '" + errNode + "'"));
                this.m_resultSet.addResult(errNode, 2);
                this.m_resultSet.getResult(errNode).addErrorDescription(errDesc);
                ReportUtil.writeRecord(errNode, pinStatus, comment);
            }
            return false;
        }
        if (nodeList.size() > 0 && this.isFixupReqd()) {
            FixupData fixGrpMemShpData = new FixupData(null);
            Result result = new Result(this.chkPinHost);
            Trace.out((String)"Generating fixup for pinning the nodes");
            VerificationLogData.logInfo("Generating the fixup for pinning the nodes");
            fixGrpMemShpData.addParticipatingNode(this.chkPinHost);
            String crshome = VerificationUtil.getCRSHome(this.chkPinHost, result);
            if (result.getStatus() == 1 && VerificationUtil.isStringGood(crshome)) {
                fixGrpMemShpData.addFixupInstruction("CRSHOME", crshome);
            } else {
                ErrorDescription fixupGenFailedErrorDesc = new ErrorDescription(s_msgBundle.getMessage("5301", true));
                fixGrpMemShpData.addFixupGenerationFailedNode(this.chkPinHost, fixupGenFailedErrorDesc);
            }
            this.setFixupData(fixGrpMemShpData);
        }
        if (this.m_resultSet.allSuccess()) {
            Trace.out((int)5, (String)"Returning TRUE");
            ReportUtil.sureprintln(s_msgBundle.getMessage("4362", false));
            return true;
        }
        Trace.out((int)5, (String)"Returning FALSE");
        ReportUtil.printError(s_msgBundle.getMessage("4363", true));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4562", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4563", false);
    }
}

