/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.fixup.FixupData;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.engine.task.TaskPeerCompatibility;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.ClusterwareUtil;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.RangeOfValue;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskPackage
extends TaskPeerCompatibility
implements PeerCompatibleTask {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1055", false);
    private String PSMISC_PKG_NAME = "psmisc";
    private boolean m_mute = false;
    private String m_name;
    private String m_val;
    private String m_arch;
    private RangeOfValue m_range;
    private boolean m_isCvuqdiskPkg;
    private boolean m_hasReferenceVersion = true;

    public TaskPackage(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("NAME".equals(argName)) {
                this.m_name = argVal;
                continue;
            }
            if ("VERSION".equals(argName)) {
                this.m_val = argVal;
                if (!VerificationUtil.isStringGood(this.m_val) || !this.m_val.equals("...")) continue;
                this.m_val = null;
                this.m_hasReferenceVersion = false;
                continue;
            }
            if ("ARCH".equals(argName)) {
                this.m_arch = VerificationUtil.isStringGood(argVal) ? argVal : null;
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
        if (VerificationUtil.isStringGood(this.m_name)) {
            this.m_isCvuqdiskPkg = this.m_name.matches("cvuqdisk");
        }
        if (this.m_globalContext.isNodeAdd()) {
            Trace.out((String)("Reinitializing the node list for node add scenario. Current nodeList (" + VerificationUtil.strArr2List(this.m_nodeList)));
            this.setNodeListForNodeAdd();
            Trace.out((String)("Reinitialized node list for node add scenario as nodeList (" + VerificationUtil.strArr2List(this.m_nodeList)));
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (this.m_isCvuqdiskPkg) {
            return this.isCVUQDiskPacakageCheckApplicable();
        }
        if (VerificationUtil.isStringGood(this.m_name) && this.m_name.equalsIgnoreCase(this.PSMISC_PKG_NAME)) {
            if (VerificationUtil.isPlatformLinux()) {
                String[] nodesWith6digitPID = VerificationUtil.getNodesWith6digitPID(this.m_nodeList);
                if (nodesWith6digitPID != null && nodesWith6digitPID.length > 0) {
                    this.setNodeList(nodesWith6digitPID);
                    return true;
                }
                Trace.out((String)"No nodes with 6 digits PID, psmisc package check is not applicable");
            }
            return false;
        }
        return VerificationUtil.isStringGood(this.m_name);
    }

    private boolean isCVUQDiskPacakageCheckApplicable() {
        if (!VerificationUtil.isPlatformLinux()) {
            Trace.out((String)"CVUQDisk package not applicable. Non Linux platform");
            return false;
        }
        boolean isCellOSSetup = VerificationUtil.isCellOSSetup();
        boolean isVirtualEnv = VerificationUtil.isVirtualEnvironment();
        if (isCellOSSetup || isVirtualEnv && !VerificationUtil.isCVUTestEnv()) {
            Trace.out((String)("CVUQDisk package is not applicable on engineered systems with cell setup or on virtual environment. Is Cell OS setup : " + isCellOSSetup + ", Is virtual env : " + isVirtualEnv));
            return false;
        }
        boolean cvuqdiskRequired = false;
        if (this.m_globalContext.isASMCheck() || CVUVariables.getValue(CVUVariableConstants.ASM_DISKGROUP_DISKS) != null || CVUVariables.getValue(CVUVariableConstants.ASM_DISK_DISCOVERY_STRING) != null) {
            cvuqdiskRequired = true;
        }
        if (!cvuqdiskRequired) {
            String[] ocrLocations = null;
            try {
                ocrLocations = ClusterwareUtil.getOCRLocations().toArray(new String[0]);
            }
            catch (VerificationException e) {
                Trace.out((String)"Failed to retrieve the ocr locations");
                Trace.out((Exception)e);
            }
            if (ocrLocations != null) {
                cvuqdiskRequired = true;
            }
        }
        if (!cvuqdiskRequired) {
            String[] votLocArr = null;
            try {
                votLocArr = ClusterwareUtil.getVoteDiskLocations().toArray(new String[0]);
            }
            catch (ClusterInfoException e) {
                Trace.out((String)"Failed to retrieve the vote disk locations");
                Trace.out((Exception)((Object)e));
            }
            if (votLocArr != null) {
                cvuqdiskRequired = true;
            }
        }
        if (cvuqdiskRequired && !this.m_globalContext.isCVUQdiskPackageCheckAdded()) {
            this.m_globalContext.setCVUQdiskPackageCheckAdded(true);
        }
        return cvuqdiskRequired;
    }

    public TaskPackage(String name, String val, String arch) {
        Trace.out((String)("name = " + name + ", val = " + val + ", arch=" + arch));
        this.m_name = name;
        this.m_val = val;
        if (VerificationUtil.isStringGood(val) && val.equals("...")) {
            this.m_val = null;
            this.m_hasReferenceVersion = false;
        }
        this.m_arch = arch;
        this.m_isCvuqdiskPkg = this.m_name.matches("cvuqdisk");
    }

    public TaskPackage(String name, RangeOfValue range, String arch) {
        Trace.out((String)("name = " + name + ", range = " + range + ", arch=" + arch));
        this.m_name = name;
        this.m_range = range;
        this.m_arch = arch;
        this.m_isCvuqdiskPkg = this.m_name.matches("cvuqdisk");
    }

    public void setMute(boolean flag) {
        this.m_mute = flag;
    }

    @Override
    public boolean performTask() {
        String requiredPackage = null;
        String requiredPackageWithVersion = null;
        requiredPackage = this.m_name;
        FixupData fixupData = null;
        if (this.isFixupReqd() && this.m_name.matches("cvuqdisk")) {
            fixupData = new FixupData(null);
        }
        if (this.m_arch != null && this.m_arch.length() > 0) {
            requiredPackage = requiredPackage + "(" + this.m_arch + ")";
        }
        requiredPackageWithVersion = requiredPackage;
        if (VerificationUtil.isStringGood(this.m_val)) {
            if (this.m_hasReferenceVersion) {
                requiredPackageWithVersion = requiredPackageWithVersion + "-" + this.m_val;
            }
        } else if (this.m_range != null) {
            requiredPackageWithVersion = requiredPackageWithVersion + ": " + this.m_range.toString();
        }
        ResultSet rsltSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.getPackage(this.m_nodeList, this.m_name, rsltSet);
        this.m_resultSet.addResultSetData(rsltSet);
        if (!this.m_mute) {
            ReportUtil.blankln();
            ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, requiredPackage}));
            ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.STATUS);
        }
        Hashtable ht = rsltSet.getResultTable();
        Enumeration e = ht.keys();
        String pkgStatus = ReportUtil.MISSING;
        String nstatus = null;
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            boolean verificationFailed = false;
            String node = (String)e.nextElement();
            ArrayList<String> pkgsFound = new ArrayList<String>();
            Result result = (Result)ht.get(node);
            CollectionElement collectionElement = new CollectionElement(this.getElementName(), null, null, null, this.getDefaultDescription(), 5);
            this.m_resultSet.addCollectionElement(node, collectionElement);
            if (result.getStatus() == 3) {
                verificationFailed = true;
                pkgStatus = ReportUtil.MISSING;
                errDesc = this.m_isCvuqdiskPkg ? new ErrorDescription("11550", new String[]{requiredPackage, node}, s_gMsgBundle) : new ErrorDescription("7532", new String[]{requiredPackage, node}, s_msgBundle);
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(requiredPackageWithVersion);
                this.m_resultSet.getResult(node).setActualValue(pkgStatus);
                this.m_resultSet.getResult(node).setStatus(3);
                collectionElement.setExpectedValue(requiredPackageWithVersion);
                collectionElement.setStatus(3);
                collectionElement.addErrorDescription(errDesc);
                nstatus = ReportUtil.FAILED;
            } else if (result.getStatus() == 1) {
                boolean requiredPkgFound = false;
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(requiredPackageWithVersion);
                this.m_resultSet.getResult(node).setStatus(1);
                Object pkgStatusObj = result.getResultInfoSet().elementAt(0);
                if (pkgStatusObj instanceof String) {
                    pkgStatus = (String)pkgStatusObj;
                    requiredPkgFound = this.matchesVersionRequirement(pkgStatus.substring(this.m_name.length() + "-".length()), null);
                    pkgsFound.add(pkgStatus);
                } else {
                    List packageInfoList = (List)pkgStatusObj;
                    boolean first = true;
                    for (HashMap pkgInfo : packageInfoList) {
                        String avlPkgName = (String)pkgInfo.get("NAME");
                        String avlPkgArch = (String)pkgInfo.get("ARCH");
                        String avlPkgVersion = (String)pkgInfo.get("VERSION");
                        if (!this.matchesArchitectureRequirement(avlPkgArch)) {
                            Trace.out((String)("Package = " + avlPkgName + " Version=" + avlPkgVersion + " Available arch " + avlPkgArch + "' did not meet required architecture =" + this.m_arch));
                            continue;
                        }
                        if (first) {
                            first = true;
                            pkgStatus = avlPkgName;
                            if (this.m_arch != null && this.m_arch.length() > 0) {
                                pkgStatus = pkgStatus + "(" + avlPkgArch + ")";
                            }
                            pkgStatus = pkgStatus + "-" + avlPkgVersion;
                        }
                        pkgsFound.add(avlPkgName + "(" + avlPkgArch + ")" + "-" + avlPkgVersion);
                        if (!this.matchesVersionRequirement(avlPkgVersion, avlPkgArch)) continue;
                        requiredPkgFound = true;
                        pkgStatus = avlPkgName;
                        if (this.m_arch != null && this.m_arch.length() > 0) {
                            pkgStatus = pkgStatus + "(" + avlPkgArch + ")";
                        }
                        pkgStatus = pkgStatus + "-" + avlPkgVersion;
                    }
                }
                if (requiredPkgFound) {
                    nstatus = ReportUtil.PASSED;
                    if (!this.m_hasReferenceVersion) {
                        pkgStatus = requiredPackageWithVersion;
                    }
                    this.m_resultSet.getResult(node).setActualValue(pkgStatus);
                    this.m_resultSet.getResult(node).setStatus(1);
                    collectionElement.setValue(pkgStatus);
                    collectionElement.setExpectedValue(requiredPackageWithVersion);
                    collectionElement.setStatus(1);
                } else if (pkgsFound.size() > 0) {
                    verificationFailed = true;
                    nstatus = ReportUtil.FAILED;
                    errDesc = this.m_isCvuqdiskPkg ? new ErrorDescription("11551", new String[]{this.m_name, node, requiredPackageWithVersion, pkgStatus}, s_gMsgBundle) : new ErrorDescription("7533", new String[]{this.m_name, node, requiredPackageWithVersion, pkgStatus}, s_msgBundle);
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                    this.m_resultSet.getResult(node).setActualValue(pkgStatus);
                    this.m_resultSet.addResult(node, 3);
                    this.m_resultSet.getResult(node).setActualValue(pkgStatus);
                    collectionElement.setValue(pkgStatus);
                    collectionElement.setExpectedValue(requiredPackageWithVersion);
                    collectionElement.setStatus(3);
                    collectionElement.addErrorDescription(errDesc);
                } else {
                    verificationFailed = true;
                    pkgStatus = ReportUtil.MISSING;
                    errDesc = this.m_isCvuqdiskPkg ? new ErrorDescription("11550", new String[]{requiredPackageWithVersion, node}, s_gMsgBundle) : new ErrorDescription("7532", new String[]{requiredPackageWithVersion, node}, s_msgBundle);
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                    this.m_resultSet.getResult(node).setHasResultValues(true);
                    this.m_resultSet.getResult(node).setActualValue(pkgStatus);
                    this.m_resultSet.addResult(node, 3);
                    nstatus = ReportUtil.FAILED;
                    collectionElement.setValue(pkgStatus);
                    collectionElement.setExpectedValue(requiredPackageWithVersion);
                    collectionElement.setStatus(3);
                    collectionElement.addErrorDescription(errDesc);
                }
            } else {
                pkgStatus = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7534", false, (Object[])new String[]{this.m_name, node}));
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                nstatus = ReportUtil.UNKNOWN;
                collectionElement.setValue(pkgStatus);
                collectionElement.setStatus(2);
                collectionElement.setExpectedValue(requiredPackageWithVersion);
                collectionElement.addErrorDescription(errDesc);
            }
            if (verificationFailed && fixupData != null) {
                Trace.out((String)("Generating fix-up for package: \"cvuqdisk\" on node " + node));
                fixupData.addParticipatingNode(node);
            }
            if (this.m_mute) continue;
            ReportUtil.writeRecord(node, pkgStatus, requiredPackageWithVersion, nstatus);
        }
        if (this.m_resultSet.getStatus() == 1) {
            if (!this.m_mute) {
                ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, requiredPackage}));
            }
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0318", false, (Object[])new String[]{requiredPackage}));
        } else {
            if (fixupData != null) {
                Trace.out((String)("Adding the generated fixup data for Task Package package name (" + this.m_name + ")"));
                VerificationLogData.logInfo("Adding the generated fixup data for Task Package package name (" + this.m_name + ")");
                fixupData.addFixupInstruction("NAME", "cvuqdisk-1.0.10-1.rpm");
                fixupData.addFixupInstruction("LOC", VerificationUtil.getCVUSubDirPath());
                fixupData.addFixupInstruction("GROUP", VerificationUtil.getCVUQDiskGroup());
                this.setFixupData(fixupData);
            }
            ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, requiredPackage}));
            ReportUtil.printErrorNodes(this.m_resultSet);
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0319", false, (Object[])new String[]{requiredPackage, VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
        }
        return this.m_resultSet.allSuccess();
    }

    private boolean matchesVersionRequirement(String avlPkgVersion, String avlPkgArch) {
        boolean matched = true;
        if (!this.m_hasReferenceVersion) {
            Trace.out((String)("Version is ignorable for the package " + this.m_name));
            matched = true;
        } else if (VerificationUtil.isStringGood(this.m_val)) {
            matched &= VerificationUtil.compareVersions(avlPkgVersion, this.m_val, "-") >= 0;
        } else if (this.m_range != null) {
            try {
                matched &= this.m_range.contains(avlPkgVersion);
            }
            catch (InvalidRangeManipulationException e) {
                Trace.out((Exception)e);
            }
        } else {
            matched &= false;
        }
        if (matched) {
            Trace.out((String)("Package version meets the requirement. Package Architecture specified. Required Arch = " + this.m_arch + " Available Arch =" + avlPkgArch));
            matched &= this.matchesArchitectureRequirement(avlPkgArch);
        }
        return matched;
    }

    private boolean matchesArchitectureRequirement(String arch) {
        if (this.m_arch != null && this.m_arch.length() > 0) {
            String archRegEx = this.m_arch.replaceAll("\\*", ".*");
            archRegEx = archRegEx.replaceAll("\\?", ".?");
            return Pattern.matches(archRegEx, arch);
        }
        return true;
    }

    @Override
    public String getDefaultElementName() {
        String pkgName = this.m_name;
        if (this.m_val != null) {
            pkgName = pkgName + "-" + this.m_val;
        }
        if (this.m_arch != null) {
            pkgName = pkgName + " (" + this.m_arch + ")";
        }
        return s_msgBundle.getMessage("4415", false) + ": " + pkgName;
    }

    @Override
    public String getDefaultDescription() {
        String pkgName = this.m_name;
        if (this.m_val != null) {
            pkgName = pkgName + "-" + this.m_val;
        }
        if (this.m_arch != null) {
            pkgName = pkgName + " (" + this.m_arch + ")";
        }
        return s_msgBundle.getMessage("4466", false, (Object[])new String[]{pkgName});
    }

    @Override
    public ResultSet performPeer() throws VerificationException {
        ResultSet rsltSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.getPackage(this.m_nodeList, this.m_name, rsltSet);
        Hashtable ht = rsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 3) {
                result.getResultInfoSet().add(0, ReportUtil.MISSING);
                result.setStatus(1);
                continue;
            }
            if (result.getStatus() != 1) continue;
            Object pkgStatusObj = result.getResultInfoSet().elementAt(0);
            ArrayList<String> pkgsFound = new ArrayList<String>();
            if (pkgStatusObj instanceof String) continue;
            List packageInfoList = (List)pkgStatusObj;
            for (HashMap pkgInfo : packageInfoList) {
                String avlPkgName = (String)pkgInfo.get("NAME");
                String avlPkgArch = (String)pkgInfo.get("ARCH");
                String avlPkgVersion = (String)pkgInfo.get("VERSION");
                String avlPkg = avlPkgName + "-" + avlPkgVersion;
                if (this.m_arch != null && this.m_arch.length() > 0) {
                    avlPkg = avlPkg + " (" + avlPkgArch + ")";
                }
                pkgsFound.add(avlPkg);
            }
            if (pkgsFound.size() > 1) {
                Collections.sort(pkgsFound);
            }
            result.getResultInfoSet().add(0, VerificationUtil.strCollection2String(pkgsFound));
        }
        return rsltSet;
    }

    @Override
    public String getTaskID() {
        return "CHECK_PACKAGE_EXISTENCE_" + this.m_name;
    }

    @Override
    public String getTaskName() {
        return this.getTaskID();
    }

    @Override
    public String getElementDisplayName() {
        String name = this.m_name;
        if (this.m_arch != null) {
            name = name + " (" + this.m_arch + ")";
        }
        return s_msgBundle.getMessage("9975", false, (Object[])new String[]{name});
    }

    @Override
    protected boolean matchesReferenceNode(Object nodeValue, Object referenceNodeValue) {
        String[] refNodePackages;
        if (nodeValue == referenceNodeValue) {
            return true;
        }
        if (nodeValue == null || referenceNodeValue == null) {
            return false;
        }
        String[] nodePackages = String.valueOf(nodeValue).split(",");
        if (nodePackages.length != (refNodePackages = String.valueOf(referenceNodeValue).split(",")).length) {
            return false;
        }
        boolean matched = true;
        for (int i = 0; i < nodePackages.length; ++i) {
            matched &= VerificationUtil.compareVersions(nodePackages[i], refNodePackages[i], "-") >= 0;
        }
        return matched;
    }

    private void setNodeListForNodeAdd() {
        try {
            NodeManager nodeMgr = NodeManagerFactory.getInstance().getNodeManager();
            boolean bigCluster = nodeMgr.isBigCluster();
            if (bigCluster) {
                Trace.out((String)"Checking for HUB nodes for TaskVotingDisk...");
                String[] hubNodes = nodeMgr.getConfiguredHubNodes(this.m_nodeList);
                ArrayList<String> nodeList = new ArrayList<String>(Arrays.asList(hubNodes));
                nodeList.add(VerificationUtil.getLocalNode());
                this.setNodeList(nodeList.toArray(new String[0]));
                return;
            }
        }
        catch (NodeManagerException nmEx) {
            Trace.out((String)("NODEMANAGEREXCEPTION: " + nmEx.getMessage()));
        }
        String validNewClusterNodes = CVUVariables.getValue(CVUVariableConstants.VALID_NEW_CLUSTER_NODES);
        if (VerificationUtil.isStringGood(validNewClusterNodes)) {
            this.setNodeList(VerificationUtil.string2strArr(validNewClusterNodes));
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TaskPackage)) {
            return false;
        }
        TaskPackage otherTaskPackage = (TaskPackage)obj;
        try {
            if (this.m_name.equals(otherTaskPackage.m_name) && (this.m_arch == null && otherTaskPackage.m_arch == null || this.m_arch != null && this.m_arch.equals(otherTaskPackage.m_arch)) && this.m_isCvuqdiskPkg == otherTaskPackage.m_isCvuqdiskPkg && (this.m_val == null && otherTaskPackage.m_val == null || this.m_val != null && this.m_val.equals(otherTaskPackage.m_val)) && this.m_hasReferenceVersion == otherTaskPackage.m_hasReferenceVersion && (this.m_range == null && otherTaskPackage.m_range == null || this.m_range != null && this.m_range.equals(otherTaskPackage.m_range))) {
                return true;
            }
        }
        catch (InvalidRangeManipulationException e) {
            Trace.out((Exception)e);
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + this.m_name.hashCode();
        if (this.m_arch != null) {
            result = result * 31 + this.m_arch.hashCode();
        }
        if (this.m_val != null) {
            result = result * 31 + this.m_val.hashCode();
        }
        return result;
    }
}

