/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.cluster.verification.util.CollectionGroup;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.DatabaseInfo;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.VerifyStorage;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

public class TaskOraclePatchCollection
extends Task {
    private String m_softwareComponent;
    private String m_softwareComponentHome;
    private String m_release;

    public TaskOraclePatchCollection(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("COMPONENT".equals(argName)) {
                if ("CRS".equalsIgnoreCase(argVal)) {
                    this.m_softwareComponent = "crs";
                    this.m_softwareComponentHome = this.m_globalContext.getCRSHome();
                    this.m_release = VerificationUtil.getCRSActiveVersion();
                    this.m_collectionGroup = CollectionGroup.CRS_PATCH_COLLECTION;
                    continue;
                }
                if (!"DATABASE".equalsIgnoreCase(argVal)) continue;
                this.m_softwareComponent = "database";
                this.m_softwareComponentHome = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
                this.m_release = CVUVariables.getValue(CVUVariableConstants.RAC_VERSION);
                this.m_collectionGroup = CollectionGroup.DB_PATCH_COLLECTION;
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return VerificationUtil.isStringGood(this.m_softwareComponentHome) && (VerificationUtil.isBaselineCollectionMode() || VerificationUtil.isCVUResource());
    }

    public TaskOraclePatchCollection(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskOraclePatchCollection(String[] nodeList, String configFile, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskOraclePatchCollection(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        boolean retVal = true;
        Trace.out((String)"Performing patch collection... ");
        this.m_resultSet.addResult(this.m_nodeList, 1);
        if (this.m_softwareComponent.equalsIgnoreCase("database")) {
            List<DatabaseInfo> databaseInfos;
            ArrayList<String> processedHomes;
            List<Object> policyDBHomes;
            HashMap<Object, Object> adminDBInfoMap;
            block25: {
                adminDBInfoMap = new HashMap();
                policyDBHomes = new ArrayList();
                processedHomes = new ArrayList<String>();
                String databaseInfo = null;
                try {
                    DBUtils dbUtils;
                    Version version = VerificationUtil.getCRSActiveVersionObj();
                    if (version == null) {
                        version = new Version();
                    }
                    if ((databaseInfos = (dbUtils = new DBUtils(version)).getDatabaseInfos()).size() > 0) {
                        ResultSet dbRsltSet = new ResultSet();
                        databaseInfo = CVUHelperUtil.getAdminAndPolicyDBInfo(dbRsltSet);
                        this.m_resultSet.addResultSetData(dbRsltSet);
                        if (VerificationUtil.isStringGood(databaseInfo)) {
                            adminDBInfoMap = this.getAdminDBInfo(databaseInfo);
                            policyDBHomes = this.getPolicyDBInfo(databaseInfo);
                        }
                        break block25;
                    }
                    Trace.out((String)"No Databases exists. Nothing to collect. Return");
                    return true;
                }
                catch (DBUtilsException de) {
                    VerificationUtil.traceAndLog("Failed to get the databases" + de.getMessage());
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    this.m_resultSet.addErrorDescription(new ErrorDescription(de.getMessage()));
                    return false;
                }
            }
            for (DatabaseInfo dbInfo : databaseInfos) {
                String oracleHome = dbInfo.getHome();
                String dbVersion = dbInfo.getVersionString();
                String[] nodeList = this.m_nodeList;
                if (processedHomes.contains(oracleHome)) {
                    Trace.out((String)("Oracle home " + oracleHome + " is already processed"));
                    continue;
                }
                try {
                    VerifyStorage verifyStorage = new VerifyStorage();
                    if (verifyStorage.isACFS(m_localNode, oracleHome)) {
                        VerificationUtil.traceAndLog("Oracle Home " + oracleHome + " put on ACFS file system");
                        NodeManager nodeMgr = NodeManagerFactory.getInstance().getNodeManager();
                        if (nodeMgr.isBigCluster()) {
                            Trace.out((String)"Getting HUB nodes to retrieve oracle patch list");
                            nodeList = nodeMgr.getConfiguredHubNodes(this.m_nodeList);
                        }
                    } else if (policyDBHomes.contains(oracleHome)) {
                        Trace.out((String)(oracleHome + " is policy managed DB home." + " Consider all the nodes to validate oracle home"));
                    } else {
                        List nodes = (List)adminDBInfoMap.get(oracleHome);
                        Trace.out((String)("Admin DB configured nodes : " + nodes));
                        if (nodes != null && nodes.size() > 0) {
                            nodes.retainAll(Arrays.asList(this.m_nodeList));
                        }
                        if (nodes != null && nodes.size() > 0) {
                            nodeList = nodes.toArray(new String[nodes.size()]);
                        } else {
                            Trace.out((String)"Admin DB Exits. But not configured in the given  nodes list");
                            continue;
                        }
                    }
                    ResultSet orclHomeRsltSet = new ResultSet();
                    VerificationUtil.validateOracleHome(nodeList, oracleHome, orclHomeRsltSet);
                    this.m_resultSet.addResultSetData(orclHomeRsltSet);
                    nodeList = orclHomeRsltSet.getSuccNodes();
                    if (nodeList.length > 0) {
                        Trace.out((String)("Software home " + oracleHome + " exists on nodes: " + Arrays.asList(nodeList)));
                        Trace.out((String)("Collecting patches for the home : " + oracleHome));
                        this.collectPatches(nodeList, oracleHome, dbVersion);
                    } else {
                        Trace.out((String)("Oracle home " + oracleHome + " does not exist on all applicable nodes"));
                        retVal = false;
                    }
                    processedHomes.add(oracleHome);
                }
                catch (StorageException se) {
                    VerificationUtil.traceAndLog("Failed to retrieve the storage type of Oracle Home " + oracleHome);
                    String errStr = s_gMsgBundle.getMessage("11420", true, (Object[])new String[]{oracleHome});
                    if (VerificationUtil.isStringGood(se.getMessage())) {
                        errStr = errStr + LSEP + se.getMessage();
                    }
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errStr));
                    retVal &= false;
                }
                catch (NodeManagerFactoryException nmEx) {
                    Trace.out((String)("NodeManagerFactoryException: " + nmEx.getMessage()));
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    this.m_resultSet.addErrorDescription(new ErrorDescription(nmEx.getMessage()));
                    retVal &= false;
                }
                catch (NoSuchNodesException ne) {
                    Trace.out((String)("NoSuchNodesException : " + ne.getMessage()));
                    retVal &= true;
                }
            }
        } else if (this.m_softwareComponent.equalsIgnoreCase("crs")) {
            this.collectPatches(this.m_nodeList, this.m_softwareComponentHome, this.m_release);
        }
        return retVal;
    }

    private void collectPatches(String[] nodeList, String softwareComponentHome, String release) {
        ResultSet resultSet = new ResultSet();
        Hashtable<String, Hashtable<String, List<String>>> nodeWisePatchList = CVUHelperUtil.getOraclePatchList(nodeList, softwareComponentHome, release, resultSet);
        this.m_resultSet.addResultSetData(resultSet);
        if (resultSet.anySuccess()) {
            for (String node : nodeWisePatchList.keySet()) {
                Hashtable<String, List<String>> patchTable = nodeWisePatchList.get(node);
                for (String patchId : patchTable.keySet()) {
                    CollectionElement patchCE = new CollectionElement(patchId, null, null, null, patchId, 1);
                    List<String> bugList = patchTable.get(patchId);
                    String bugListStr = "";
                    if (bugList != null && bugList.size() > 0) {
                        Collections.sort(bugList);
                    }
                    bugListStr = VerificationUtil.strCollection2String(bugList);
                    CollectionElement bugListCE = new CollectionElement("BUG_LIST", bugListStr, null, null, "BUG_LIST", 1);
                    patchCE.addChild(bugListCE);
                    this.m_resultSet.addCollectionElement(node, patchCE);
                }
            }
        }
    }

    private HashMap<String, List<String>> getAdminDBInfo(String databaseInfo) {
        HashMap<String, List<String>> adminDBInfoMap = new HashMap<String, List<String>>();
        String adminDBInfo = VerificationUtil.fetchTextByTags(databaseInfo, "<ADMIN_DBINFO>", "</ADMIN_DBINFO>");
        if (VerificationUtil.isStringGood(adminDBInfo)) {
            String[] adminDBInfoArr;
            Trace.out((String)"Admin managed databases exists in the cluster");
            for (String dbInfo : adminDBInfoArr = VerificationUtil.fetchTextByTagsRepeat(adminDBInfo, "<DB_INFO>", "</DB_INFO>")) {
                try {
                    String[] nodeInstanceInfo;
                    ArrayList<String> adminDBConfiguredNodes = new ArrayList<String>();
                    for (String nodeInstance : nodeInstanceInfo = VerificationUtil.string2strArr(GenericUtil.getValueByKey(dbInfo, "NODE_INSTANCE_INFO"), " ")) {
                        String[] nodeInstanceArr = VerificationUtil.string2strArr(nodeInstance, ":");
                        if (nodeInstanceArr.length <= 0) continue;
                        adminDBConfiguredNodes.add(nodeInstanceArr[0].toLowerCase());
                    }
                    if (adminDBConfiguredNodes.size() <= 0) continue;
                    String[] dbHomeInfo = null;
                    int index = dbInfo.indexOf("<NODE_INSTANCE_INFO");
                    if (index != -1) {
                        dbHomeInfo = VerificationUtil.string2strArr(dbInfo.substring(0, index - 1));
                    }
                    if (dbHomeInfo == null || dbHomeInfo.length <= 1) continue;
                    String dbHome = dbHomeInfo[1].trim();
                    Trace.out((String)("DB home: " + dbHome));
                    List<String> dbConfigNodes = adminDBInfoMap.get(dbHome);
                    if (dbConfigNodes != null) {
                        dbConfigNodes.addAll(adminDBConfiguredNodes);
                        continue;
                    }
                    dbConfigNodes = new ArrayList<String>();
                    dbConfigNodes.addAll(adminDBConfiguredNodes);
                    adminDBInfoMap.put(dbHome, dbConfigNodes);
                }
                catch (ParsingException p) {
                    String errMsg = s_gMsgBundle.getMessage("11870", true) + LSEP + p.getMessage();
                    VerificationUtil.traceAndLog(errMsg);
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errMsg));
                }
            }
        }
        return adminDBInfoMap;
    }

    private List<String> getPolicyDBInfo(String databaseInfo) {
        ArrayList<String> policyDBHomes = new ArrayList<String>();
        String policyDBInfo = VerificationUtil.fetchTextByTags(databaseInfo, "<POLICY_DBINFO>", "</POLICY_DBINFO>");
        if (VerificationUtil.isStringGood(policyDBInfo)) {
            String[] policyDBInfoArr;
            Trace.out((String)"Policy managed databases exists in the cluster");
            for (String dbInfo : policyDBInfoArr = VerificationUtil.fetchTextByTagsRepeat(policyDBInfo, "<DB_INFO>", "</DB_INFO>")) {
                String[] dbHomeInfo = VerificationUtil.string2strArr(dbInfo);
                if (dbHomeInfo.length <= 1) continue;
                String dbHome = dbHomeInfo[1].trim();
                Trace.out((String)("DB home :" + dbHome));
                policyDBHomes.add(dbHome);
            }
        }
        return policyDBHomes;
    }

    public void setSoftwareComponent(String softwareComponent) {
        this.m_softwareComponent = softwareComponent;
    }

    public void setSoftwareComponentHome(String softwareComponentHome) {
        this.m_softwareComponentHome = softwareComponentHome;
    }

    public String getSoftwareComponentHome() {
        return this.m_softwareComponentHome;
    }

    public void setRelease(String release) {
        this.m_release = release;
    }

    @Override
    public String getDefaultElementName() {
        if (this.m_softwareComponent.equalsIgnoreCase("database")) {
            return s_gMsgBundle.getMessage("11669", false, (Object[])new String[]{this.m_softwareComponentHome});
        }
        return s_gMsgBundle.getMessage("11667", false, (Object[])new String[]{this.m_softwareComponentHome});
    }

    @Override
    public String getDefaultDescription() {
        if (this.m_softwareComponent.equalsIgnoreCase("database")) {
            return s_gMsgBundle.getMessage("11670", false, (Object[])new String[]{this.m_softwareComponentHome});
        }
        return s_gMsgBundle.getMessage("11668", false, (Object[])new String[]{this.m_softwareComponentHome});
    }
}

