/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.verification.CollectionResultSet;
import oracle.cluster.verification.CollectionValueUnavailableException;
import oracle.cluster.verification.NodeResultStatus;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.ClusterwareUtil;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.helper.CVUHelperConstants;

public class TaskOraclePatch
extends Task
implements CVUHelperConstants {
    private String m_reqOraclePatch;
    private String m_home;
    private String m_giHome = null;
    private String m_giVersion = null;
    private boolean m_dummyTask = false;
    private boolean m_isRACHome = false;
    private final String OPATCH_STATUS_HELPER_ARG = "-getOPatchStatus";

    public TaskOraclePatch(VerificationType vType, String home, String reqdPatch) {
        this(vType, home, reqdPatch, false);
    }

    public TaskOraclePatch(VerificationType vType, String home, String reqdPatch, boolean isRACHome) {
        this(home, reqdPatch, isRACHome);
    }

    public TaskOraclePatch(String home, String reqdPatch, boolean isRACHome) {
        this.m_home = home;
        this.m_reqOraclePatch = reqdPatch;
        this.m_isRACHome = isRACHome;
        if (this.m_globalContext.isUpgrade()) {
            Trace.out((String)"Upgrade scenario. setting severity to FATAL");
            this.setSeverity(SeverityType.FATAL);
        }
    }

    public TaskOraclePatch(VerificationType vType, String home, boolean dummyTask) {
        this(vType, home, null, false);
        this.m_dummyTask = dummyTask;
    }

    @Override
    public boolean performTask() {
        ReportUtil.blankln();
        if (this.m_dummyTask) {
            String msg = s_gMsgBundle.getMessage("1255", false, (Object[])new String[]{this.m_home});
            ReportUtil.sureprintln(msg);
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return true;
        }
        ArrayList<String> nodeExecErrors = new ArrayList<String>();
        ReportUtil.println(s_gMsgBundle.getMessage("1250", false, (Object[])new String[]{this.getDisplayString(this.m_reqOraclePatch), this.m_home}));
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet commandRS = new ResultSet();
        this.getCRSHomeInfo(commandRS);
        String cmd = null;
        if (commandRS.getStatus() == 1) {
            cmd = this.getCommand(this.m_home);
            globalExec.runGenericCmd(this.m_nodeList, cmd, this.m_resultSet);
        } else {
            for (VerificationError error : commandRS.getErrors()) {
                nodeExecErrors.add(error.getErrorMessage());
            }
            this.m_resultSet.addResultSetData(commandRS);
        }
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.APPLIED, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        Hashtable t = this.m_resultSet.getResultTable();
        Enumeration e = t.keys();
        for (String node : this.m_nodeList) {
            Result result = (Result)t.get(node);
            String sPatchAppl = ReportUtil.MISSING;
            if (result != null && result.getStatus() == 1) {
                String[] cmdOut = (String[])result.getResultInfoSet().get(1);
                String match = this.isPatchInstalled(cmdOut, this.m_reqOraclePatch, result, cmd);
                if (match != null) {
                    sPatchAppl = match;
                    ReportUtil.writeRecord(node, sPatchAppl, this.getDisplayString(this.m_reqOraclePatch), ReportUtil.PASSED);
                    this.m_resultSet.getResult(node).setHasResultValues(true);
                    this.m_resultSet.getResult(node).setExpectedValue(this.getDisplayString(this.m_reqOraclePatch));
                    this.m_resultSet.getResult(node).setActualValue(sPatchAppl);
                } else if (result.getStatus() != 2) {
                    ReportUtil.writeRecord(node, sPatchAppl, this.getDisplayString(this.m_reqOraclePatch), ReportUtil.FAILED);
                    ErrorDescription errDesc = new ErrorDescription(s_gMsgBundle.getMessage("1261", true, (Object[])new String[]{node, this.m_home, this.m_reqOraclePatch}), s_gMsgBundle, "1261");
                    this.m_resultSet.addResult(node, 3);
                    this.m_resultSet.getResult(node).setExpectedValue(this.getDisplayString(this.m_reqOraclePatch));
                    this.m_resultSet.getResult(node).setActualValue(sPatchAppl);
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                }
            } else {
                ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, this.getDisplayString(this.m_reqOraclePatch), ReportUtil.FAILED);
                ErrorDescription errDesc = new ErrorDescription(s_gMsgBundle.getMessage("1262", true, (Object[])new String[]{node, this.m_home, this.m_reqOraclePatch}));
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + result.getExecutionErrorDetails());
                result.addErrorDescription(errDesc);
                this.m_resultSet.addErrorDescription(node, errDesc);
            }
            for (VerificationError error : result.getErrors()) {
                nodeExecErrors.add(error.getErrorMessage());
            }
        }
        boolean retVal = false;
        if (this.m_resultSet.allSuccess()) {
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("1258", false, (Object[])new String[]{this.getDisplayString(this.m_reqOraclePatch), this.m_home}));
            ReportUtil.printResult(s_gMsgBundle.getMessage("1256", false, (Object[])new String[]{this.getDisplayString(this.m_reqOraclePatch), this.m_home}));
            retVal = true;
        } else {
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("1259", false, (Object[])new String[]{this.getDisplayString(this.m_reqOraclePatch), this.m_home, VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
            ReportUtil.printResult(s_gMsgBundle.getMessage("1257", false, (Object[])new String[]{this.getDisplayString(this.m_reqOraclePatch), this.m_home}));
            ReportUtil.printErrorNodes(this.m_resultSet);
            retVal = false;
        }
        if (nodeExecErrors.size() > 0) {
            ReportUtil.sureblankln();
            for (String error : nodeExecErrors) {
                ReportUtil.sureprintln(error);
            }
            ReportUtil.sureblankln();
        }
        return retVal;
    }

    public String getHome() {
        return this.m_home;
    }

    private String getDisplayString(String requiredPatch) {
        String ORStr = s_msgBundle.getMessage("7025", false) + " ";
        return requiredPatch.replaceAll(Pattern.quote("|"), ORStr);
    }

    @Override
    public String getTaskID() {
        return "OraclePatch_" + this.m_reqOraclePatch;
    }

    private String getCommand(String home) {
        Trace.out((Object)"Method entry. home=%s", (String)home);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String command = null;
        String version = null;
        if (VerificationUtil.isVersionPost(this.m_giVersion, "11.2.0.3")) {
            String requiredPatches = this.m_reqOraclePatch;
            if (requiredPatches.indexOf(124) > 0) {
                requiredPatches = this.m_reqOraclePatch.replaceAll(Pattern.quote("|"), ",");
                if (!nativeSystem.isUnixSystem()) {
                    requiredPatches = "\"" + requiredPatches + "\"";
                }
            }
            String cvuHelper = nativeSystem.getScriptFileName("cvuhelper");
            version = this.m_giVersion;
            if (this.m_isRACHome && !VerificationUtil.isStringGood(version = CVUVariables.getValue(CVUVariableConstants.RAC_VERSION))) {
                try {
                    DBUtils dbUtils = new DBUtils(VerificationUtil.getVersionObject(this.m_giVersion));
                    version = dbUtils.getDBVersion(this.m_home).toString4();
                }
                catch (ConfigurationException e) {
                    Trace.out((String)"Ignoring the following exception");
                    Trace.out((Exception)((Object)e));
                    version = this.m_giVersion;
                }
                catch (DBUtilsException e) {
                    Trace.out((String)"Ignoring the following exctpion");
                    Trace.out((Exception)e);
                    version = this.m_giVersion;
                }
            }
            String helperVersion = CVUHelperUtil.getHelperVersion(this.m_home, version, "-getOPatchStatus");
            command = VerificationUtil.getCVUSubDirPath() + cvuHelper + " " + home + " " + helperVersion + " " + VerificationUtil.getCVUSubDirPath() + CVUHelperUtil.getHelperJarFile(helperVersion) + " " + this.m_giHome + " " + "-getOPatchStatus" + " " + home + " " + requiredPatches;
        } else {
            command = home + VerificationUtil.FSEP + "OPatch" + VerificationUtil.FSEP + "opatch" + " lsinv -oh " + home;
            if (VerificationUtil.isPlatformAix() && VerificationUtil.isVersionPre(this.m_giVersion, "11.2")) {
                command = "JAVA_COMPILER=NONE " + command;
            }
        }
        Trace.out((String)"GI version=%s, helper command used=%s", (Object[])new Object[]{this.m_giVersion, command});
        return command;
    }

    private void getCRSHomeInfo(ResultSet rs) {
        if (VerificationUtil.isCRSConfigured()) {
            CollectionResultSet<String> homeCRS = ClusterwareUtil.getCRSHome(this.m_nodeList);
            try {
                if (!homeCRS.getOverallStatus().equals((Object)OverallStatus.SUCCESSFUL) || !homeCRS.getNodeCollectionResults().get(this.m_nodeList[0]).getNodeResultStatus().equals((Object)NodeResultStatus.SUCCESSFUL)) {
                    rs.setStatus(3);
                    for (VerificationError error : homeCRS.getErrors()) {
                        rs.addErrorDescription((ErrorDescription)error);
                    }
                    rs.addErrorDescription(new ErrorDescription(s_msgBundle.getMessage("5301", true)));
                    return;
                }
                rs.addResult(this.m_nodeList, 1);
                rs.setStatus(1);
                this.m_giHome = homeCRS.getNodeCollectionResults().get(this.m_nodeList[0]).getCollectedValue();
                this.m_giVersion = VerificationUtil.getCRSReleaseVersion(this.m_giHome, this.m_nodeList[0]);
            }
            catch (CollectionValueUnavailableException e) {
                rs.setStatus(3);
                rs.addErrorDescription(new ErrorDescription(e.getMessage()));
                return;
            }
        } else if (VerificationUtil.isHAConfigured()) {
            this.m_giHome = VerificationUtil.getHAHome();
            if (this.m_giHome == null) {
                rs.setStatus(3);
                rs.addErrorDescription(new ErrorDescription(s_msgBundle.getMessage("5307", true)));
                return;
            }
            rs.setStatus(1);
            this.m_giVersion = VerificationUtil.getSIHAReleaseVersion();
        }
    }

    private String isPatchInstalled(String[] cmdOut, String requiredPatch, Result result, String cmd) {
        Trace.out((String)"Method entry. requiredPatch=%s, cmd=%s", (Object[])new Object[]{requiredPatch, cmd});
        if (VerificationUtil.isVersionPost(this.m_giVersion, "11.2.0.3")) {
            return this.isPatchInstalledOPatchAPI(cmdOut, result, cmd);
        }
        return this.isPatchInstalledOPatchCLI(cmdOut, requiredPatch, result, cmd);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String isPatchInstalledOPatchAPI(String[] output, Result result, String cmd) {
        String[] patchDetailsArr = null;
        String[] errorArray = null;
        String errMsg = null;
        String match = null;
        if (output.length != 0 && VerificationUtil.strArr2List(output).indexOf("CVH_OUT") >= 0) {
            String outputStr = VerificationUtil.strArr2List(output);
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"error during cvu helper execution");
                errorArray = CVUHelperUtil.fetchError(output);
                errMsg = s_gMsgBundle.getMessage("1262", true, (Object[])new String[]{result.getNode(), this.m_home, this.m_reqOraclePatch}) + LSEP + VerificationUtil.strArr2List(errorArray);
                result.addErrorDescription(new ErrorDescription(errMsg));
                result.setStatus(2);
                return null;
            }
            if (status == 1) {
                Trace.out((String)"partial success with data collection");
                patchDetailsArr = CVUHelperUtil.fetchOutput(output);
                errorArray = CVUHelperUtil.fetchError(output);
                errMsg = s_gMsgBundle.getMessage("1262", true, (Object[])new String[]{result.getNode(), this.m_home, this.m_reqOraclePatch}) + LSEP + VerificationUtil.strArr2List(errorArray);
                result.addErrorDescription(new ErrorDescription(errMsg));
                result.setStatus(2);
                return null;
            }
        } else {
            errMsg = s_gMsgBundle.getMessage("1260", true, (Object[])new String[]{cmd});
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        Trace.out((String)"all data collected");
        patchDetailsArr = CVUHelperUtil.fetchOutput(output);
        Pattern p = Pattern.compile("([^:]*):installed$");
        String[] stringArray = patchDetailsArr;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String patchDeails = stringArray[n2];
            Matcher m = p.matcher(patchDeails);
            if (m.matches()) {
                return m.group(1);
            }
            ++n2;
        }
        return match;
    }

    private String isPatchInstalledOPatchCLI(String[] cmdOut, String requiredPatch, Result result, String cmd) {
        String[] requiredPatches;
        ArrayList<String> patchList = new ArrayList<String>();
        for (String cmdOutList : cmdOut) {
            Pattern p = Pattern.compile("^Patch([\\s]*)([\\d]*)([\\s]*)(.*)");
            Matcher m = p.matcher(cmdOutList);
            if (!m.matches()) continue;
            String patch = m.group(2);
            patchList.add(patch);
        }
        String match = null;
        for (String requiredPatchStr : requiredPatches = requiredPatch.split(Pattern.quote("|"))) {
            if (!patchList.contains(requiredPatchStr)) continue;
            match = requiredPatchStr;
        }
        if (match == null) {
            for (String cmdOutList : cmdOut) {
                for (String requiredPatchStr : requiredPatches) {
                    if (cmdOutList.indexOf(requiredPatchStr) < 0) continue;
                    match = requiredPatchStr;
                    return match;
                }
            }
        }
        return match;
    }

    @Override
    public void setSeverity(SeverityType taskSeverity) {
        if (SeverityType.FATAL == this.m_taskSeverity && this.m_globalContext.isUpgrade() && !VerificationUtil.isCVUTestEnv() && !Utils.isDevelopmentEnv()) {
            Trace.out((String)"Cannot overwrite severity. Task must remain FATAL for upgrade");
        } else {
            super.setSeverity(taskSeverity);
        }
    }

    @Override
    public String getDefaultElementName() {
        String requiredPatch = null;
        requiredPatch = this.m_dummyTask ? "N/A" : this.getDisplayString(this.m_reqOraclePatch);
        return s_gMsgBundle.getMessage("1251", false) + ":" + requiredPatch;
    }

    @Override
    public String getDefaultDescription() {
        if (this.m_dummyTask) {
            return s_gMsgBundle.getMessage("1255", false, (Object[])new String[]{this.m_home});
        }
        return s_gMsgBundle.getMessage("1252", false, (Object[])new String[]{this.getDisplayString(this.m_reqOraclePatch), this.m_home});
    }
}

