/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskOnsConfData;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskOnsConfIntegrity
extends Task {
    final String CONF_FILE = "ons.config";
    final String m_localPort = "^localport[\\s]+.*";
    final String m_remotePort = "^remoteport[\\s]+.*";
    final String m_localField = "^localport[\\s]+";
    final String m_remoteField = "^remoteport[\\s]+";
    String m_onsConfFile = null;
    Map<String, TaskOnsConfData> m_allNodeOnsConf;
    List<String> m_confOKVector;
    boolean m_onsConfMissingAllNodes = false;

    public TaskOnsConfIntegrity(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        String actCRSVer = VerificationUtil.getCRSActiveVersion();
        return this.m_globalContext.isUpgrade() && VerificationUtil.isStringGood(actCRSVer) && VerificationUtil.isVersionPre(actCRSVer, "11.2");
    }

    public TaskOnsConfIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskOnsConfIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
        this.m_allNodeOnsConf = new HashMap<String, TaskOnsConfData>();
        this.m_confOKVector = new ArrayList<String>();
    }

    public TaskOnsConfIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.m_allNodeOnsConf = new HashMap<String, TaskOnsConfData>();
        this.m_confOKVector = new ArrayList<String>();
    }

    @Override
    public String getTaskID() {
        return "ONS_CONF";
    }

    @Override
    public boolean performTask() {
        String msg;
        Trace.out((String)"Performing ons.config integrity verification task");
        Trace.out((String)"Trying to get CRSHome");
        String crsHome = VerificationUtil.getCRSHome();
        if (crsHome == null) {
            Trace.out((String)"Failed to get CRSHome");
            String msg2 = s_msgBundle.getMessage("5301", true);
            ReportUtil.printError(msg2);
            ErrorDescription errDesc = new ErrorDescription(msg2);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        this.m_onsConfFile = crsHome + FSEP + "opmn" + FSEP + "conf" + FSEP + "ons.config";
        Trace.out((String)("Ons config file location" + this.m_onsConfFile));
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11918", false, (Object[])new String[]{this.m_onsConfFile}) + VerificationConstants.LSEP);
        if (!this.prepareNodeOnsConfMap()) {
            return false;
        }
        if (!this.performPortValidation()) {
            return false;
        }
        if (this.m_resultSet.allSuccess()) {
            Trace.out((String)"status is true");
        }
        String[] failNodes = (String[])this.m_resultSet.getFailedNodes().toArray();
        if (this.m_resultSet.allSuccess() || failNodes.length == 0) {
            msg = s_gMsgBundle.getMessage("11922", false, (Object[])new String[]{this.m_onsConfFile}) + VerificationConstants.LSEP;
        } else {
            msg = s_gMsgBundle.getMessage("11923", false, (Object[])new String[]{this.m_onsConfFile}) + VerificationConstants.LSEP;
            Trace.out((String)("ONS_CONF failed on nodes: '" + VerificationUtil.strArr2List(failNodes) + "'"));
        }
        ReportUtil.sureprintln(VerificationConstants.LINE_SEPARATOR + msg);
        if (this.m_resultSet.allSuccess()) {
            Trace.out((String)"status is true");
            return true;
        }
        Trace.out((String)"status is false");
        return false;
    }

    private boolean prepareNodeOnsConfMap() {
        boolean status = true;
        String scratchPath = VerificationUtil.getCVUSubDirPath() + "scratch";
        File tempArea = new File(scratchPath);
        if (!tempArea.exists()) {
            tempArea.mkdirs();
        }
        if (!tempArea.isDirectory()) {
            tempArea.delete();
            tempArea.mkdir();
        }
        if (!tempArea.exists() || !tempArea.isDirectory()) {
            Trace.out((String)("Couldn't create " + tempArea.getName()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            String msg = s_gMsgBundle.getMessage("11919", true, (Object[])new String[]{scratchPath});
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            return false;
        }
        Trace.out((String)("Ons config file location" + this.m_onsConfFile));
        ArrayList<String> onsConfnotExistNodes = new ArrayList<String>();
        ArrayList<String> onsConfExistNodes = new ArrayList<String>();
        ClusterCmd clusterCmd = new ClusterCmd();
        for (String node : this.m_nodeList) {
            boolean copyStatus = false;
            Trace.out((String)("copying file from node:" + (String)node));
            try {
                boolean currentNodeStatus = clusterCmd.fileExists(node, this.m_onsConfFile);
                if (!currentNodeStatus) {
                    Trace.out((String)("ons.config does not exists on node" + (String)node));
                    onsConfnotExistNodes.add(node);
                    continue;
                }
                onsConfExistNodes.add(node);
                copyStatus = clusterCmd.copyFileFromNode(node, this.m_onsConfFile, scratchPath + "/ons.config_" + (String)node);
                Trace.out((String)("copy status = " + copyStatus));
                if (!copyStatus) continue;
                this.m_confOKVector.add(node);
            }
            catch (ClusterException e) {
                Trace.out((String)"ClusterException while looking for ons.config");
                this.m_resultSet.addResult(node, 2);
                String msg = s_gMsgBundle.getMessage("11921", true, (Object[])new String[]{this.m_onsConfFile, node, m_localNode}) + LSEP + e.getMessage();
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(msg));
                ReportUtil.printError(msg);
                status = false;
            }
        }
        if (onsConfnotExistNodes.size() > 0 && onsConfExistNodes.size() > 0) {
            Trace.out((String)"ons.conf exists on some nodes");
            String msg = s_gMsgBundle.getMessage("11914", true, (Object[])new String[]{this.m_onsConfFile, VerificationUtil.strList2List(onsConfnotExistNodes)});
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addResult(onsConfnotExistNodes.toArray(new String[0]), 3);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
            ReportUtil.sureprintNodelist(onsConfExistNodes.toArray(new String[0]));
            ReportUtil.sureprintln("");
        } else if (onsConfExistNodes.size() == 0) {
            Trace.out((String)"no ons.config on any node");
            ReportUtil.printError(s_gMsgBundle.getMessage("11915", false, (Object[])new String[]{this.m_onsConfFile}));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_onsConfMissingAllNodes = false;
            return false;
        }
        if (this.m_confOKVector.size() == 0) {
            return false;
        }
        ArrayList<String> remotePortMissingNodes = new ArrayList<String>();
        ArrayList<String> remotePortNotMissingNodes = new ArrayList<String>();
        ArrayList<String> copyConfOKVector = new ArrayList<String>(this.m_confOKVector);
        for (String node : copyConfOKVector) {
            ErrorDescription errDesc;
            boolean badConfFile = false;
            boolean remotePortFound = false;
            ArrayList<String> badOnsConfLines = new ArrayList<String>();
            TaskOnsConfData curOnsConfData = new TaskOnsConfData();
            curOnsConfData.setNodeName(node);
            Trace.out((String)("Parsing ons.config of node:" + node));
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(scratchPath + FSEP + "ons.config_" + node));
                while ((line = in.readLine()) != null) {
                    String[] tokens;
                    if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith(";")) continue;
                    int index = line.indexOf("#");
                    if (index != -1) {
                        line = line.substring(0, index).trim();
                    }
                    if ((index = line.indexOf(";")) != -1) {
                        line = line.substring(0, index).trim();
                    }
                    if ((line = VerificationUtil.strArr2String(tokens = line.split("="), " ")).matches("^localport[\\s]+.*")) {
                        String[] localArr = line.split("^localport[\\s]+");
                        if (localArr.length != 2) {
                            badConfFile = true;
                            badOnsConfLines.add(line);
                            continue;
                        }
                        String localPort = localArr[1].trim();
                        Trace.out((String)("local port  = " + localPort));
                        if (localPort != null) {
                            curOnsConfData.setLocalPort(localPort);
                            continue;
                        }
                        badConfFile = true;
                        badOnsConfLines.add(line);
                        continue;
                    }
                    if (!line.matches("^remoteport[\\s]+.*")) continue;
                    String[] remoteArr = line.split("^remoteport[\\s]+");
                    if (remoteArr.length != 2) {
                        badConfFile = true;
                        badOnsConfLines.add(line);
                        continue;
                    }
                    String remotePort = remoteArr[1].trim();
                    remotePortFound = true;
                    remotePortNotMissingNodes.add(node);
                    Trace.out((String)("remote port  = " + remotePort));
                    if (remotePort != null) {
                        curOnsConfData.setRemotePort(remotePort);
                        continue;
                    }
                    badConfFile = true;
                    badOnsConfLines.add(line);
                }
                if (!remotePortFound) {
                    remotePortMissingNodes.add(node);
                }
                if (!badConfFile) {
                    Trace.out((String)("status on node " + node + " is " + status));
                    this.m_allNodeOnsConf.put(node, curOnsConfData);
                } else {
                    badOnsConfLines.add(0, node);
                    String msg = s_gMsgBundle.getMessage("11913", true, (Object[])new String[]{node, this.m_onsConfFile});
                    msg = msg + LSEP + VerificationUtil.strCollection2String(badOnsConfLines, VerificationConstants.LSEP);
                    errDesc = new ErrorDescription(msg);
                    this.m_resultSet.addErrorDescription(node, errDesc);
                    this.m_resultSet.addResult(node, 3);
                    ReportUtil.printError(msg);
                    this.m_confOKVector.remove(node);
                    VerificationLogData.logError("bad ons.conf lines on node:" + node + LSEP + msg);
                    status = false;
                }
                in.close();
            }
            catch (IOException e) {
                Trace.out((String)("IOException while reading copied ons.config for node :" + node));
                this.m_resultSet.addResult(node, 2);
                String msg = s_gMsgBundle.getMessage("11935", true, (Object[])new String[]{this.m_onsConfFile, node}) + VerificationConstants.LSEP + e.getMessage();
                errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(msg);
                this.m_confOKVector.remove(node);
                VerificationLogData.logError("could not read ons.conf on node:" + node + LSEP + msg);
                status = false;
            }
        }
        if (remotePortMissingNodes.size() > 0) {
            String msg = s_gMsgBundle.getMessage("12809", true, (Object[])new String[]{VerificationUtil.strList2List(remotePortMissingNodes), this.m_onsConfFile});
            ErrorDescription errDesc = new ErrorDescription(msg);
            String[] failedNodeArr = remotePortMissingNodes.toArray(new String[0]);
            this.m_resultSet.addResult(failedNodeArr, 3);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            status = false;
        }
        return status;
    }

    public boolean performPortValidation() {
        ResultSet locRes = new ResultSet();
        boolean status = true;
        ArrayList<String> onsLocalRemoteSameNodes = new ArrayList<String>();
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11934", false));
        for (String node : this.m_confOKVector) {
            String local = this.m_allNodeOnsConf.get(node).getLocalPort();
            String remote = this.m_allNodeOnsConf.get(node).getRemotePort();
            Trace.out((String)("local port on node " + node + " is" + (String)local));
            Trace.out((String)("remote port on node " + node + "is " + remote));
            if (local.equals(remote)) {
                Trace.out((String)("local and remote ports are the same on " + node));
                onsLocalRemoteSameNodes.add(node);
                continue;
            }
            locRes.addResult(node, 1);
        }
        if (onsLocalRemoteSameNodes.size() > 0) {
            String[] onsLocalRemoteSameNodesArray = onsLocalRemoteSameNodes.toArray(new String[0]);
            String msg = s_gMsgBundle.getMessage("11924", true, (Object[])new String[]{VerificationUtil.strList2List(onsLocalRemoteSameNodes)});
            ErrorDescription errDesc = new ErrorDescription(msg);
            locRes.addResult(onsLocalRemoteSameNodesArray, 3);
            locRes.addErrorDescription(onsLocalRemoteSameNodesArray, errDesc);
            ReportUtil.printError(msg);
        }
        this.m_resultSet.uploadResultSet(locRes);
        locRes = new ResultSet();
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11936", false));
        Hashtable<Object, Vector<Object>> remoteTable = new Hashtable<Object, Vector<Object>>();
        for (String node : this.m_confOKVector) {
            VerificationUtil.updateResultMap(remoteTable, this.m_allNodeOnsConf.get(node).getRemotePort(), node);
        }
        if (remoteTable.size() == 1) {
            Trace.out((String)"Remote ports match on all nodes");
            locRes.addResult(this.m_confOKVector, 1);
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11933", false, (Object[])new String[]{this.m_onsConfFile}));
        } else {
            StringBuilder msg = new StringBuilder();
            msg.append(s_gMsgBundle.getMessage("11928", true, (Object[])new String[]{this.m_onsConfFile}) + LSEP);
            Enumeration<Object> e = remoteTable.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String nodeListStr = VerificationUtil.strVect2List(remoteTable.get(key));
                msg.append(s_gMsgBundle.getMessage("11929", false, (Object[])new String[]{key, nodeListStr}) + LSEP);
            }
            locRes.addResult(this.m_confOKVector, 3);
            locRes.addErrorDescription(new ErrorDescription(msg.toString()));
            ReportUtil.printError(msg.toString());
            status = false;
        }
        this.m_resultSet.uploadResultSet(locRes);
        return status;
    }

    private void cleanScratchDirectory(String scratchPath) {
        ArrayList<String> failedDeletes = new ArrayList<String>();
        for (String node : this.m_nodeList) {
            String tempLocation = scratchPath + "/ons.config_" + node;
            File onsConf = new File(tempLocation);
            Trace.out((String)"Cleaning scratch dir");
            if (!onsConf.exists() || onsConf.delete()) continue;
            failedDeletes.add(tempLocation);
        }
        if (failedDeletes.size() > 0) {
            String msg = s_gMsgBundle.getMessage("11920", true, (Object[])new String[]{VerificationUtil.strList2List(failedDeletes)});
            ReportUtil.sureprintln(msg);
        }
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11916", false, (Object[])new String[]{this.m_onsConfFile});
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11917", false);
    }
}

