/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.OSVerCompatXMLDocument;
import oracle.ops.verification.framework.engine.task.OSVerCompatXMLDocumentException;
import oracle.ops.verification.framework.engine.task.OSVerCompatXMLEntry;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskOSVersionCompatibility
extends Task {
    private String m_release;

    public TaskOSVersionCompatibility(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskOSVersionCompatibility(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskOSVersionCompatibility(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public String getDefaultDescription() {
        Object[] msgParams = new String[]{this.m_release};
        return s_msgBundle.getMessage("4495", false, msgParams);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4442", false);
    }

    public void setRelease(String releaseval) {
        this.m_release = releaseval;
    }

    @Override
    public boolean performTask() {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Performing OS Version Compatibility for CRS version " + this.m_release));
        }
        this.performOSVersionCompatibility();
        if (this.m_resultSet.allSuccess()) {
            Trace.out((String)"ResultSet shows alll Success");
            ReportUtil.printResult(s_msgBundle.getMessage("4381", false));
            ReportUtil.sureblankln();
            return true;
        }
        Trace.out((String)"ResultSet shows at least one failure");
        ReportUtil.printResult(s_msgBundle.getMessage("4382", false));
        ReportUtil.sureblankln();
        return false;
    }

    private void performOSVersionCompatibility() {
        List<OSVerCompatXMLEntry> osVerList = null;
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet knlverRsltSet = new ResultSet();
        String xmlDocument = null;
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4380", false));
        try {
            xmlDocument = VerificationUtil.getOSVersionCompatXmlPath();
            OSVerCompatXMLDocument ovcxml = new OSVerCompatXMLDocument(xmlDocument);
            Trace.out((String)("Loading xml document " + xmlDocument));
            osVerList = ovcxml.load(this.m_release);
            Trace.out((String)"Getting OS release from the nodes");
            globalExec.getKernelVersion(this.m_nodeList, knlverRsltSet);
            Trace.out((String)"Uploading the task-level result set");
            this.m_resultSet.addResultSetData(knlverRsltSet);
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8054", false), s_msgBundle.getMessage("8001", false));
            Trace.out((String)"Comparing node version with list of supported versions");
            Hashtable t = knlverRsltSet.getResultTable();
            Enumeration e = t.keys();
            while (e.hasMoreElements()) {
                ErrorDescription errDesc;
                String node = (String)e.nextElement();
                Result result = (Result)t.get(node);
                if (result.getStatus() == 1) {
                    String avl = (String)result.getResultInfoSet().firstElement();
                    boolean match = false;
                    Trace.out((String)("Result.OPERATION_SUCCESSFUL:: available kernel version=" + avl));
                    for (int i = 0; i < osVerList.size(); ++i) {
                        if (osVerList.get(i).compareVersion(avl) != 0) continue;
                        Trace.out((String)("Version match found : " + avl));
                        match = true;
                        break;
                    }
                    if (match) {
                        ReportUtil.writeRecord(node, avl, ReportUtil.PASSED);
                        if (Trace.isTraceEnabled()) {
                            Trace.out((String)("Result.VERIFICATION_SUCCESSFUL:: available value for OS version is " + avl));
                        }
                        this.m_resultSet.getResult(node).setHasResultValues(true);
                        this.m_resultSet.getResult(node).setActualValue(avl);
                        continue;
                    }
                    Trace.out((String)("OS Version match NOT found for " + avl));
                    ReportUtil.writeRecord(node, avl, ReportUtil.FAILED);
                    if (Trace.isTraceEnabled()) {
                        Trace.out((String)("Result.VERIFICATION_FAILED:: available value for OS version is " + avl));
                    }
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("4954", true, (Object[])new String[]{avl, node}));
                    this.m_resultSet.addResult(node, 3);
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                    this.m_resultSet.getResult(node).setHasResultValues(true);
                    this.m_resultSet.getResult(node).setActualValue(avl.toString());
                    continue;
                }
                Trace.out((String)("FAILED:: result.getStatus()=" + result.getStatus()));
                ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, ReportUtil.FAILED);
                errDesc = new ErrorDescription(s_msgBundle.getMessage("4950", true, (Object[])new String[]{node}));
                this.m_resultSet.addResult(node, 3);
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
            }
        }
        catch (XmlFilePathException e) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            String exceptionMsg = s_msgBundle.getMessage("4960", true, (Object[])new String[]{xmlDocument}) + e.getMessage();
            ErrorDescription errDesc = new ErrorDescription(exceptionMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(exceptionMsg);
            return;
        }
        catch (OSVerCompatXMLDocumentException e) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            String exceptionMsg = s_msgBundle.getMessage("4956", true, (Object[])new String[]{xmlDocument}) + e.getMessage();
            ErrorDescription errDesc = new ErrorDescription(exceptionMsg);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            ReportUtil.sureprintln(exceptionMsg);
            Trace.out((String)("==Error while processing Supported OS Versions document==" + e));
            return;
        }
    }
}

