/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.database.DatabaseConnectInfo;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.DatabaseInfo;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultKeyType;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.DatabaseTask;
import oracle.ops.verification.framework.engine.task.DatabaseTaskException;
import oracle.ops.verification.framework.engine.task.TaskGroupExistence;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskOSDbGroupsExistence
extends DatabaseTask {
    private static final String[] m_osgroups = new String[]{"OSDBA", "OSOPER", "OSBACKUPDBA", "OSDGDBA", "OSKMDBA"};
    private static final String[] m_osgroups_pre_121 = new String[]{"OSDBA", "OSOPER"};
    private static final String[] m_oskeys = new String[]{"-d", "-o", "-b", "-g", "-k"};
    private static final String[] m_osasmgroups = new String[]{"OSASM", "OSDBA for ASM"};
    private static final String[] m_osasmkeys = new String[]{"-a", "-d"};
    private String[] m_groupnames;

    public TaskOSDbGroupsExistence(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return this.m_isDBInfoInitialized;
    }

    @Override
    protected void init() {
        super.init();
    }

    public TaskOSDbGroupsExistence(Version crsVer, Collection<DatabaseConnectInfo> dbConInfo) {
        super(crsVer, dbConInfo);
    }

    @Override
    public boolean performTask() {
        boolean retVal = true;
        ArrayList<String> failedDBList = new ArrayList<String>();
        ArrayList<String> failedNodeList = new ArrayList<String>();
        String failedDB = "";
        String commaString = "";
        Trace.out((String)"Performing OSDB groups consistency check...");
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11313", false));
        for (String database : this.databases()) {
            ErrorDescription errDesc;
            String errMsg;
            try {
                String[] nodeList = this.m_dbUtils.getNodes(database);
                DatabaseInfo dbInfo = this.getDatabaseInfo(database);
                String oraHome = dbInfo.getHome();
                String asmHome = this.getASMHome();
                String[] osgroups = m_osgroups;
                if (Version.isPre12c((Version)dbInfo.getVersion())) {
                    osgroups = m_osgroups_pre_121;
                }
                if (!this.verifyGroupConsistency(nodeList, oraHome, database, osgroups, m_oskeys) && !this.verifyGroupConsistency(nodeList, asmHome, database, m_osasmgroups, m_osasmkeys)) {
                    retVal &= false;
                    Trace.out((String)("Check for consistency failed for database " + database + "."));
                    String errMsg2 = s_gMsgBundle.getMessage("11317", false, (Object[])new String[]{database});
                    ReportUtil.sureprintln(errMsg2);
                    ErrorDescription errDesc2 = new ErrorDescription(errMsg2);
                    this.m_resultSet.addErrorDescription(database, errDesc2);
                    this.m_resultSet.addResult(database, 3, ResultKeyType.DB_INSTANCE);
                    for (String node : nodeList) {
                        if (failedNodeList.contains(node)) continue;
                        failedNodeList.add(node);
                    }
                } else {
                    Trace.out((String)("Check for OSDB consistency passed for database " + database + "."));
                    ReportUtil.sureprintln(s_gMsgBundle.getMessage("11316", false, (Object[])new String[]{database}));
                    this.m_resultSet.addResult(database, 1, ResultKeyType.DB_INSTANCE);
                }
            }
            catch (DBUtilsException duEx) {
                Trace.out((String)("DBUtilsException while verifying OSDB groups for database " + database + ". message :" + duEx.getMessage()));
                errMsg = s_gMsgBundle.getMessage("11318", true, (Object[])new String[]{duEx.getMessage()});
                ReportUtil.sureprintln(errMsg);
                this.m_resultSet.addResult(database, 2, ResultKeyType.DB_INSTANCE);
                errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(database, errDesc);
                VerificationLogData.log(errMsg);
                retVal &= false;
            }
            catch (DatabaseTaskException dbEx) {
                Trace.out((String)("DatabaseTaskException while verifying OSDB groups for database " + database + ". message :" + dbEx.getMessage()));
                errMsg = s_gMsgBundle.getMessage("11318", true, (Object[])new String[]{dbEx.getMessage()});
                ReportUtil.sureprintln(errMsg);
                this.m_resultSet.addResult(database, 2, ResultKeyType.DB_INSTANCE);
                errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(database, errDesc);
                VerificationLogData.log(errMsg);
                retVal &= false;
            }
            if (retVal) continue;
            failedDBList.add(database);
            failedDB = failedDB + commaString + database;
            commaString = ", ";
        }
        if (retVal) {
            Trace.out((String)"Check for OSDB groups consistency passed");
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11315", false));
            this.m_resultSet.addResult(this.databases(), 1, ResultKeyType.DB_INSTANCE);
        } else {
            Trace.out((String)"Check for OSDB groups consistency failed");
            failedDBList.trimToSize();
            String errMsg = s_gMsgBundle.getMessage("11330", true, (Object[])new String[]{failedDB, VerificationUtil.strList2List(failedNodeList)});
            ReportUtil.sureprintln(errMsg);
            this.m_resultSet.addResult(failedDBList.toArray(new String[0]), 3, ResultKeyType.DB_INSTANCE);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            VerificationLogData.log(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
        }
        return retVal;
    }

    private boolean verifyGroupConsistency(String[] nodeList, String oraHome, String database, String[] groups, String[] keys) {
        Trace.out((String)"Start consistency  check...");
        boolean retVal = true;
        boolean groupCheckPassed = true;
        String groupValue = "";
        ArrayList<String> failedNodeList = new ArrayList<String>();
        TaskGroupExistence tGrpExistence = null;
        for (int i = 0; i < groups.length; ++i) {
            Trace.out((String)("Starting consistency check for group " + groups[i]));
            Hashtable<Object, Vector<Object>> grpTable = new Hashtable<Object, Vector<Object>>();
            this.m_groupnames = this.getOSDBGrp(nodeList, oraHome, keys[i], database);
            for (int j = 0; j < this.m_groupnames.length; ++j) {
                if (j == 0) {
                    groupValue = this.m_groupnames[j];
                }
                if (!this.m_groupnames[j].equals(groupValue)) {
                    Trace.out((String)("Group " + groups[i] + " not consistent in node " + nodeList[j]));
                    retVal &= false;
                    groupCheckPassed &= false;
                }
                VerificationUtil.updateResultMap(grpTable, this.m_groupnames[j], nodeList[j]);
            }
            if (!groupCheckPassed) {
                failedNodeList.addAll(Arrays.asList(nodeList));
            } else if (groupValue.trim().length() > 0) {
                tGrpExistence = TaskGroupExistence.generate(groupValue, nodeList);
                this.addChildTask(tGrpExistence);
                if (!tGrpExistence.perform()) {
                    this.m_resultSet.uploadResultSet(tGrpExistence.getResultSet());
                    failedNodeList.addAll(this.m_resultSet.getFailedNodes());
                    retVal &= false;
                    groupCheckPassed &= false;
                } else {
                    Trace.out((String)("Check for existance of group " + groups[i] + " for database " + database + " passed"));
                }
            }
            if (groupCheckPassed) {
                Trace.out((String)("Group " + groups[i] + " passed consistency check for database " + database + "."));
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("11319", false, (Object[])new String[]{groups[i], database}));
            } else {
                failedNodeList.trimToSize();
                String failNodes = VerificationUtil.strList2List(failedNodeList);
                String errMsg = s_gMsgBundle.getMessage("11320", false, (Object[])new String[]{groups[i], failNodes, database});
                ReportUtil.sureprintln(errMsg);
                Enumeration<Object> e = grpTable.keys();
                StringBuffer osGrpNamesDisplayString = new StringBuffer();
                boolean first = true;
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    Vector<Object> nodeVector = grpTable.get(key);
                    String nodes = VerificationUtil.strVect2List(nodeVector);
                    if (first) {
                        first = false;
                        osGrpNamesDisplayString.append("[");
                    } else {
                        osGrpNamesDisplayString.append("; ");
                    }
                    osGrpNamesDisplayString.append(groups[i] + ":" + key + ":" + nodes);
                    String errorMessage = s_gMsgBundle.getMessage("11331", false, (Object[])new String[]{groups[i], key, nodes});
                    ReportUtil.sureprintln(errorMessage);
                }
                osGrpNamesDisplayString.append("]");
                this.m_resultSet.addResult(database, 3, ResultKeyType.DB_INSTANCE);
                ErrorDescription errDesc = new ErrorDescription(errMsg + " " + osGrpNamesDisplayString);
                this.m_resultSet.addErrorDescription(database, errDesc);
                failedNodeList.clear();
            }
            groupCheckPassed = true;
        }
        return retVal;
    }

    private String[] getOSDBGrp(String[] nodeList, String homeLocation, String keyArg, String database) {
        int i;
        String[] dbaGrp = new String[nodeList.length];
        for (int i2 = 0; i2 < nodeList.length; ++i2) {
            dbaGrp[i2] = "";
        }
        VerificationCommand[] command = new VerificationCommand[nodeList.length];
        String[] args = new String[]{"-rungencmd", "" + homeLocation + FSEP + "bin" + FSEP + "osdbagrp", keyArg};
        ResultSet rs = new ResultSet();
        for (i = 0; i < nodeList.length; ++i) {
            command[i] = new VerificationCommand(nodeList[i], args, null);
        }
        Trace.out((String)("Command sent: osdbagrp " + keyArg));
        new GlobalHandler().submit((Command[])command, 0, rs);
        if (rs.allSuccess()) {
            for (i = 0; i < command.length; ++i) {
                dbaGrp[i] = command[i].getOutput();
                Trace.out((String)("Response from osdbagrp for node  " + nodeList[i] + ": " + dbaGrp[i]));
            }
            return dbaGrp;
        }
        String cause = "";
        for (VerificationError vfe : rs.getErrors()) {
            String errMsg = vfe.getErrorMessage().replace("|", LSEP);
            cause = cause + LSEP + VerificationUtil.fetchVerificationValue(errMsg);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(database, 2, ResultKeyType.DB_INSTANCE);
            this.m_resultSet.addErrorDescription(database, errDesc);
            Trace.out((String)("Error message from osdbagrp:" + cause));
        }
        return dbaGrp;
    }

    private String getASMHome() {
        String asmHome = null;
        Trace.out((String)"Calling VerificationUtil.getCRSActiveVersionObj()");
        Version curVer = VerificationUtil.getCRSActiveVersionObj();
        Result result = new Result(m_localNode);
        if (curVer != null && Version.isPre112((Version)curVer)) {
            asmHome = CVUHelperUtil.getASMhome(result);
            if (!VerificationUtil.isStringGood(asmHome)) {
                if (result.getStatus() != 2) {
                    Trace.out((String)"There is no ASM configured on any of the cluster nodes, considering RAC/DB home for running osdbagrp utility, Skipping the check for OSASM group");
                    asmHome = CVUVariables.getValue(CVUVariableConstants.CV_RAC_HOME);
                    Trace.out((String)("Using home " + asmHome + " to run the osdba utility from"));
                } else {
                    Trace.out((String)"Failed to retrieve the configured ASM Home using CVU helper.");
                    VerificationLogData.logError("Failed to retrieve the configured ASM Home using CVU helper.");
                }
            } else {
                Trace.out((String)("Successfully retrieved the ASM Home using CVU helper as (" + asmHome + ")"));
                VerificationLogData.logFine("Successfully retrieved the ASM Home using CVU helper as (" + asmHome + ")");
            }
        } else {
            asmHome = VerificationUtil.getCRSHome(m_localNode, result);
        }
        return asmHome;
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11312", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11311", false);
    }
}

