/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskOLRIntegrity
extends Task {
    private static final String OLR_PROPERTY_OLRCONFIGLOC = "olrconfig_loc";
    private static final String OLR_PROPERTY_CRS_HOME = "crs_home";
    private static final String FILE_STATUS_FAILED = "1";
    private static boolean s_unix = new SystemFactory().CreateSystem().isUnixSystem();
    public String m_homeType = new String("BOTH");

    public TaskOLRIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskOLRIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskOLRIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public TaskOLRIntegrity(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("HOME_TYPE".equals(argName)) {
                this.m_homeType = argVal;
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        VerificationType vType = this.m_globalContext.getVerificationType();
        switch (vType) {
            case PREREQ_SI_DB_INST: 
            case POSTREQ_SI_HA_CONFIG: {
                return VerificationUtil.isStringGood(this.m_homeType) && this.m_globalContext.isHAConfigured();
            }
            case COMPONENT_OLR_INTEGRITY: {
                return true;
            }
        }
        return VerificationUtil.isStringGood(this.m_homeType);
    }

    public void setHomeType(String homeType) {
        this.m_homeType = homeType;
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing OLR Integrity verification task... ");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4109", false));
        this.performOLRIntegrityChecks();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printWarning(s_msgBundle.getMessage("4198", false));
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4110", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4111", false));
        return false;
    }

    void performOLRIntegrityChecks() {
        String olrHome = null;
        ResultSet olrConfigRS = new ResultSet();
        ArrayList<String> nodeList = new ArrayList<String>();
        String[] validNodeArr = null;
        String[] nodeArr = new String[]{m_localNode};
        if (this.m_globalContext.isUpgrade() && !this.m_globalContext.isRolling()) {
            olrHome = VerificationUtil.getHAorCRSHome(nodeArr, this.m_homeType, nodeList, olrConfigRS);
            validNodeArr = this.m_nodeList;
        } else {
            olrHome = VerificationUtil.getHAorCRSHome(this.m_nodeList, this.m_homeType, nodeList, olrConfigRS);
            validNodeArr = nodeList.toArray(new String[nodeList.size()]);
        }
        if (olrHome == null) {
            Trace.out((int)5, (String)"Could not determine OLR home...");
            this.m_resultSet.addResultSetData(olrConfigRS);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        Trace.out((String)("OLR home is: '" + olrHome + "'"));
        this.performOLRConfigurationChecks(validNodeArr, olrConfigRS, olrHome);
        this.m_resultSet.addResultSetData(olrConfigRS);
    }

    private void performOLRConfigurationChecks(String[] nodeList, ResultSet resultSet, String haHome) {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        GlobalExecution globalExec = new GlobalExecution();
        Hashtable failedOlrLocNodes = new Hashtable();
        String[] olrExistNodes = null;
        String[] olrNotExistNodes = null;
        String errMsg = null;
        ErrorDescription errDesc = null;
        String olrLocFileName = null;
        if (s_unix) {
            Version version = null;
            version = VerificationUtil.isHAConfigured() ? VerificationUtil.getSIHAReleaseVersionObj() : VerificationUtil.getCRSSoftwareVersionObj();
            olrLocFileName = nativeSys.getOLRConfigLocation("localnode", version);
            ArrayList<String> fileList = new ArrayList<String>();
            fileList.add(olrLocFileName);
            Trace.out((int)5, (String)("olrLocFileName: '" + olrLocFileName + "'"));
            ResultSet olrLocFileInfoResultSet = new ResultSet();
            int fileInfoResult = globalExec.getFileInfo(nodeList, fileList, olrLocFileInfoResultSet) ? 1 : 0;
            Trace.out((String)"After calling globalExec.getFileInfo() ... ");
            if (fileInfoResult == 0) {
                olrLocFileInfoResultSet.addResult(nodeList, 2);
                errDesc = new ErrorDescription("4160", s_msgBundle);
                olrLocFileInfoResultSet.addErrorDescription(errDesc);
                ReportUtil.printError(s_msgBundle.getMessage("4160", false) + LSEP);
                resultSet.addResultSetData(olrLocFileInfoResultSet);
                return;
            }
            resultSet.addResultSetData(olrLocFileInfoResultSet);
            olrExistNodes = (String[])olrLocFileInfoResultSet.getSuccessfulNodes().toArray();
            olrNotExistNodes = (String[])olrLocFileInfoResultSet.getFailedNodes().toArray();
            Trace.out((String)("olrExistNodes::length=" + olrExistNodes.length + "; Nodes: \"" + VerificationUtil.strArr2List(olrExistNodes) + "\"" + LSEP + "olrNotExistNodes::length=" + olrNotExistNodes.length + "; Nodes: \"" + VerificationUtil.strArr2List(olrNotExistNodes) + "\""));
            if (olrLocFileInfoResultSet.allSuccess()) {
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("2037", false, (Object[])new String[]{olrLocFileName}));
            }
            Trace.out((String)"Checking olr.loc attributes");
            String olrLocOwner = VDMUtil.getDefaultOlrLocOwner();
            String olrLocGroup = VerificationUtil.getOraInventoryGroup();
            String olrPermissions = null;
            olrPermissions = VerificationUtil.isHAConfigured() ? VDMUtil.getDefaultOlrLocSIHAPermissions() : VDMUtil.getDefaultOlrLocPermissions();
            this.checkFileAttributes(olrExistNodes, olrLocFileName, olrLocFileInfoResultSet, olrLocOwner, olrLocGroup, olrPermissions);
            resultSet.addResultSetData(olrLocFileInfoResultSet);
            if (olrLocFileInfoResultSet.allSuccess()) {
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("2039", false, (Object[])new String[]{olrLocFileName}));
            } else if (this.m_globalContext.isUpgrade()) {
                Trace.out((String)"UPGRADE CASE: Marking Severity of this task to FATAL");
                this.setSeverity(SeverityType.FATAL);
            }
        } else {
            ArrayList<String> olrExistNodesList = new ArrayList<String>();
            ArrayList<String> olrNotExistNodesList = new ArrayList<String>();
            for (String node : nodeList) {
                NativeResult keyExistsResult;
                olrLocFileName = nativeSys.getOLRConfigLocation(node, null);
                if (!nativeSys.regKeyExists(node, olrLocFileName, keyExistsResult = new NativeResult())) {
                    olrNotExistNodesList.add(node);
                    resultSet.addResult(node, 3);
                    if (!keyExistsResult.getStatus()) {
                        Object[] args = new String[]{olrLocFileName, node, keyExistsResult.getOSString()};
                        errMsg = s_gMsgBundle.getMessage("4001", true, args);
                    } else {
                        errMsg = s_gMsgBundle.getMessage("4000", true, (Object[])new String[]{olrLocFileName, node});
                    }
                    ReportUtil.sureprintln(errMsg);
                    resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                    continue;
                }
                resultSet.addResult(node, 1);
                olrExistNodesList.add(node);
            }
            olrExistNodes = olrExistNodesList.toArray(new String[olrExistNodesList.size()]);
            if (olrNotExistNodesList.size() == 0) {
                ReportUtil.println(s_gMsgBundle.getMessage("2041", false));
            } else if (this.m_globalContext.isUpgrade()) {
                Trace.out((String)"UPGRADE CASE: Marking Severity of this task to FATAL");
                this.setSeverity(SeverityType.FATAL);
            }
        }
        String olrFileName = null;
        String cmdSpec = haHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + nativeSys.getExeName("ocrcheck") + " -config -local";
        Trace.out((String)("Command Syntax: " + cmdSpec));
        ResultSet olrCheckResultSet = new ResultSet();
        Hashtable olrCheckOutput = globalExec.runExeWithOutput(olrExistNodes, cmdSpec, olrCheckResultSet);
        String olrGroup = VerificationUtil.getOraInventoryGroup();
        String olrPermission = VDMUtil.getDefaultOlrPermissions();
        String olrOwner = null;
        olrOwner = VerificationUtil.isHAConfigured() ? this.getOracleUser(haHome, nodeList) : VDMUtil.getDefaultOlrOwnerCRS();
        for (String node : olrExistNodes) {
            Pattern p;
            Matcher m;
            String output = (String)olrCheckOutput.get(node);
            String valText = VerificationUtil.fetchVerificationValue(output);
            String exitStat = VerificationUtil.fetchVerificationResult(output);
            if (exitStat != null && exitStat.contentEquals("0") && (m = (p = Pattern.compile("([^:]*):([\\s]+)Device/File Name([^:]+): (.*)")).matcher(valText.trim())).matches()) {
                olrFileName = m.group(4).trim();
            }
            if (olrFileName == null) {
                resultSet.addResult(node, 2);
                errMsg = s_gMsgBundle.getMessage("2042", true, (Object[])new String[]{node});
                String errDetailsMsg = resultSet.getResult(node).getExecutionErrorDetails();
                if (VerificationUtil.isStringGood(errDetailsMsg)) {
                    errMsg = errMsg + LSEP + errDetailsMsg;
                }
                resultSet.addErrorDescription(new ErrorDescription(errMsg));
                ReportUtil.sureprintln(errMsg);
                Trace.out((String)("Node: " + node + " Output: " + output + " valText: '" + valText + "' " + "exitStat: '" + exitStat + "'"));
                continue;
            }
            Trace.out((String)("olrFileName = " + olrFileName));
            ResultSet olrResultSet = new ResultSet();
            Trace.out((String)("Checking for attributes of OLR file '" + olrFileName + "'"));
            ArrayList<String> olrFileList = new ArrayList<String>();
            olrFileList.add(olrFileName);
            ResultSet olrFileInfoResultSet = new ResultSet();
            boolean olrFileInfoResult = globalExec.getFileInfo(new String[]{node}, olrFileList, olrFileInfoResultSet);
            Trace.out((String)"After calling globalExec.getFileInfo() ... ");
            if (!olrFileInfoResult) {
                String message = s_msgBundle.getMessage("4160", true) + LSEP;
                resultSet.addResult(node, 2);
                errDesc = new ErrorDescription("4160", s_msgBundle);
                resultSet.addErrorDescription(errDesc);
                continue;
            }
            Hashtable fileInforResultTable = olrFileInfoResultSet.getResultTable();
            Result result = (Result)fileInforResultTable.get(node);
            resultSet.addResult(node, result);
            if (!s_unix) continue;
            Trace.out((String)"Checking olr attributes");
            HashMap<String, CollectionElement> fileAttrCollectionElementHM = this.checkFileAttributes(new String[]{node}, olrFileName, olrFileInfoResultSet, olrOwner, olrGroup, olrPermission);
            HashMap<String, CollectionElement> olrConfigCollectionElementHM = this.checkOlRLocProperties(node, olrLocFileName, OLR_PROPERTY_OLRCONFIGLOC, olrFileInfoResultSet);
            HashMap<String, CollectionElement> olrCRSHomeCollectionElementHM = this.checkOlRLocProperties(node, olrLocFileName, OLR_PROPERTY_CRS_HOME, olrFileInfoResultSet);
            for (String collectionNode : fileAttrCollectionElementHM.keySet()) {
                CollectionElement fileAttrCE = fileAttrCollectionElementHM.get(collectionNode);
                CollectionElement olrConfigCE = olrConfigCollectionElementHM.get(collectionNode);
                CollectionElement olrCRSHomeCE = olrCRSHomeCollectionElementHM.get(collectionNode);
                if (olrConfigCE != null) {
                    fileAttrCE.addChild(olrConfigCE);
                }
                if (olrCRSHomeCE != null) {
                    fileAttrCE.addChild(olrCRSHomeCE);
                }
                olrFileInfoResultSet.addCollectionElement(collectionNode, fileAttrCE);
            }
            resultSet.addResultSetData(olrFileInfoResultSet);
            Trace.out((String)("Check passed for attributes of OLR file '" + olrFileName + "'"));
            if (olrFileInfoResultSet.allSuccess()) {
                resultSet.addResult(nodeList, 1);
                continue;
            }
            if (!this.m_globalContext.isUpgrade()) continue;
            Trace.out((String)"UPGRADE CASE: Marking Severity of this task to FATAL");
            this.setSeverity(SeverityType.FATAL);
        }
    }

    private HashMap<String, CollectionElement> checkFileAttributes(String[] validNodeArr, String fileName, ResultSet fileInfoResultSet, String refOwner, String refGroup, String refPermissions) {
        String referenceValue = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        Hashtable fileInforResultTable = fileInfoResultSet.getResultTable();
        HashMap<String, CollectionElement> fileAttributeHashMap = new HashMap<String, CollectionElement>();
        for (String node : validNodeArr) {
            ErrorDescription errDesc;
            String errMsg;
            Result result = (Result)fileInforResultTable.get(node);
            CollectionElement collectionElement = new CollectionElement(fileName, null, refPermissions, null, fileName, 1);
            fileAttributeHashMap.put(node, collectionElement);
            CollectionElement ownerCollectionElement = new CollectionElement(ReportUtil.OWNER, null, null, null, ReportUtil.OWNER, 1);
            CollectionElement groupCollectionElement = new CollectionElement(ReportUtil.GROUP, null, null, null, ReportUtil.GROUP, 1);
            CollectionElement permissionsCollectionElement = new CollectionElement(ReportUtil.PERMISSION, null, null, null, ReportUtil.PERMISSION, 1);
            collectionElement.addChild(ownerCollectionElement);
            collectionElement.addChild(groupCollectionElement);
            collectionElement.addChild(permissionsCollectionElement);
            if (s_unix) {
                if (refOwner != null) {
                    referenceValue = "Owner=" + refOwner;
                    ownerCollectionElement.setExpectedValue(refOwner);
                }
                if (refGroup != null) {
                    referenceValue = referenceValue != null ? referenceValue + "; Group=" + refGroup : "Group=" + refGroup;
                    groupCollectionElement.setExpectedValue(refGroup);
                }
                if (refPermissions != null) {
                    referenceValue = referenceValue != null ? referenceValue + "; Permissions=" + refPermissions : "Permissions=" + refPermissions;
                    permissionsCollectionElement.setExpectedValue(refPermissions);
                }
            }
            collectionElement.setExpectedValue(referenceValue);
            if (result != null && result.getStatus() == 1) {
                Hashtable nodeFileList = (Hashtable)result.getResultInfoSet().elementAt(0);
                FileInfo nodeFileInfo = (FileInfo)nodeFileList.get(fileName);
                if (FILE_STATUS_FAILED.equals(nodeFileInfo.getStatus())) {
                    fileInfoResultSet.addResult(node, 2);
                    errMsg = s_gMsgBundle.getMessage("2030", true, (Object[])new String[]{fileName, node}) + LSEP + nodeFileInfo.getErrorString();
                    errDesc = new ErrorDescription(errMsg);
                    fileInfoResultSet.addErrorDescription(node, errDesc);
                    ReportUtil.sureprintln(errMsg);
                    collectionElement.setStatus(3);
                    collectionElement.addErrorDescription(errDesc);
                    ownerCollectionElement.setStatus(3);
                    ownerCollectionElement.addErrorDescription(errDesc);
                    groupCollectionElement.setStatus(3);
                    groupCollectionElement.addErrorDescription(errDesc);
                    permissionsCollectionElement.setStatus(3);
                    permissionsCollectionElement.addErrorDescription(errDesc);
                    continue;
                }
                collectionElement.setValue("Owner=" + nodeFileInfo.getFileOwner() + "; Group=" + nodeFileInfo.getFileGroup() + "; Permissions=" + nodeFileInfo.getFilePermissions());
                ownerCollectionElement.setValue(nodeFileInfo.getFileOwner() == null ? "N/A" : nodeFileInfo.getFileOwner());
                groupCollectionElement.setValue(nodeFileInfo.getFileGroup() == null ? "N/A" : nodeFileInfo.getFileGroup());
                permissionsCollectionElement.setValue(nodeFileInfo.getFilePermissions() == null ? "N/A" : nodeFileInfo.getFilePermissions());
                if (refOwner != null && refOwner.length() > 0 && !nodeFileInfo.getFileOwner().equalsIgnoreCase(refOwner)) {
                    fileInfoResultSet.addResult(node, 3);
                    errMsg = s_gMsgBundle.getMessage("2031", true, (Object[])new String[]{fileName, node, refOwner, nodeFileInfo.getFileOwner()});
                    errDesc = new ErrorDescription(errMsg);
                    ReportUtil.sureprintln(errMsg);
                    fileInfoResultSet.addErrorDescription(node, errDesc);
                    collectionElement.setStatus(3);
                    collectionElement.addErrorDescription(errDesc);
                    ownerCollectionElement.setStatus(3);
                    ownerCollectionElement.addErrorDescription(errDesc);
                }
                if (refGroup != null && refGroup.length() > 0 && !nodeFileInfo.getFileGroup().equalsIgnoreCase(refGroup)) {
                    fileInfoResultSet.addResult(node, 3);
                    errMsg = s_gMsgBundle.getMessage("2032", true, (Object[])new String[]{fileName, node, refGroup, nodeFileInfo.getFileGroup()});
                    errDesc = new ErrorDescription(errMsg);
                    fileInfoResultSet.addErrorDescription(node, errDesc);
                    ReportUtil.sureprintln(errMsg);
                    collectionElement.setStatus(3);
                    collectionElement.addErrorDescription(errDesc);
                    groupCollectionElement.setStatus(3);
                    groupCollectionElement.addErrorDescription(errDesc);
                }
                if (refPermissions == null || refPermissions.length() <= 0 || Integer.parseInt(refPermissions, 8) == Integer.parseInt(nodeFileInfo.getFilePermissions(), 8)) continue;
                fileInfoResultSet.addResult(node, 3);
                errMsg = s_gMsgBundle.getMessage("2033", true, (Object[])new String[]{fileName, node, refPermissions, nodeFileInfo.getFilePermissions()});
                errDesc = new ErrorDescription(errMsg);
                fileInfoResultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(errMsg);
                collectionElement.setStatus(3);
                collectionElement.addErrorDescription(errDesc);
                permissionsCollectionElement.setStatus(3);
                permissionsCollectionElement.addErrorDescription(errDesc);
                continue;
            }
            fileInfoResultSet.addResult(node, 2);
            errMsg = s_gMsgBundle.getMessage("2030", true, (Object[])new String[]{fileName, node});
            errDesc = new ErrorDescription(errMsg);
            fileInfoResultSet.addErrorDescription(node, errDesc);
            ReportUtil.sureprintln(errMsg);
            collectionElement.setStatus(2);
            collectionElement.addErrorDescription(errDesc);
            ownerCollectionElement.setStatus(2);
            ownerCollectionElement.addErrorDescription(errDesc);
            groupCollectionElement.setStatus(2);
            groupCollectionElement.addErrorDescription(errDesc);
            permissionsCollectionElement.setStatus(2);
            permissionsCollectionElement.addErrorDescription(errDesc);
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return fileAttributeHashMap;
    }

    private HashMap<String, CollectionElement> checkOlRLocProperties(String node, String olrFileName, String olrProperty, ResultSet resultSet) {
        HashMap<String, CollectionElement> collectionHM = new HashMap<String, CollectionElement>();
        String fileName = "";
        String[] tokens = null;
        Result result = null;
        Hashtable fileInfoResultTable = null;
        String valueProperty = null;
        tokens = olrFileName.split(FILE_SEPARATOR);
        if (tokens != null) {
            fileName = tokens[tokens.length - 1];
        }
        fileInfoResultTable = resultSet.getResultTable();
        Result existingResult = (Result)fileInfoResultTable.get(node);
        result = new Result(node);
        valueProperty = VerificationUtil.isLocalNode(node) ? VerificationUtil.getOLRPropertyValueLocalNode(olrProperty, result, true) : VerificationUtil.getOLRPropertyValue(node, olrProperty, result, true);
        if (result.getStatus() != 1) {
            for (VerificationError vErr : result.getErrors()) {
                existingResult.addErrorDescription((ErrorDescription)vErr);
            }
            existingResult.setStatusConditionally(result.getStatus());
        }
        Trace.out((String)(olrProperty + "=" + valueProperty));
        CollectionElement collectionElement = new CollectionElement(olrProperty, valueProperty, "N/A", null, valueProperty, 1);
        collectionHM.put(node, collectionElement);
        return collectionHM;
    }

    private String getOracleUser(String haHome, String[] nodeList) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        String oracleBinary = haHome + File.separator + "bin" + File.separator + new SystemFactory().CreateSystem().getExeName("oracle");
        GlobalExecution globalExec = new GlobalExecution();
        List<String> fileList = Arrays.asList(oracleBinary);
        ResultSet resultSet = new ResultSet();
        boolean fileInfoResult = globalExec.getFileInfo(nodeList, fileList, resultSet);
        Trace.out((String)"After calling globalExec.getFileInfo() ... ");
        if (!fileInfoResult) {
            return null;
        }
        for (String node : nodeList) {
            Result result = (Result)resultSet.getResultTable().get(node);
            if (result == null || result.getStatus() != 1) continue;
            Hashtable nodeFileList = (Hashtable)result.getResultInfoSet().elementAt(0);
            boolean nodeFailed = false;
            FileInfo nodeFileInfo = (FileInfo)nodeFileList.get(oracleBinary);
            if (FILE_STATUS_FAILED.equals(nodeFileInfo.getStatus())) continue;
            return nodeFileInfo.getFileOwner();
        }
        return null;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4436", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4487", false);
    }
}

