/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OIFCFGResult;
import oracle.cluster.cmdtools.OIFCFGUtil;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.impl.verification.NetworkInterfaceInfoImpl;
import oracle.cluster.impl.verification.NodeConnectivityResultSetImpl;
import oracle.cluster.impl.verification.SubnetAndInterfaceInfoImpl;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.ParamPreReqNodeAddDel;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.engine.task.TaskHostsFile;
import oracle.ops.verification.framework.engine.task.TaskIPPacketSizeCheck;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.network.ConMatrix;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkDataDiscovery;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.network.Subnet;
import oracle.ops.verification.framework.network.TCPMatrix;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskNodeConnectivity
extends Task {
    public static final int NODECON = 0;
    public static final int NODEREACH = 1;
    public static final String LSEP = System.getProperty("line.separator");
    public static final String IPCON_KEY = "IPCON";
    public static final String INFCON_KEY = "INFCON";
    public static final String NODEREACH_KEY = "NODEREACH";
    public static final String LINK_LOCAL_ADDRESS = "169.254.";
    public static final String LINK_LOCAL_ADDRESS_NETMASK1 = "255.255.0.0";
    public static final String LINK_LOCAL_ADDRESS_NETMASK2 = "255.255.128.0";
    public static final String LINK_LOCAL_ADDRESS_NETMASK3 = "255.255.192.0";
    private static final String TASK_TYPE = "Node connectivity";
    public static final String HW_TYPE_INFINIBAND = "32";
    private String[] m_IPAddrList;
    private HashMap<String, Set<NetworkInfo>> m_globalNodeNetworksMap = null;
    private HashMap<String, Set<NetworkInfo>> m_nodeNetworksMapForUserProvidedNetworks = null;
    private HashMap<String, Set<NetworkInfo>> m_subnetNetworksMapForUserProvidedNetworks = null;
    private HashMap<String, Set<NetworkInfo>> m_globalSubnetNetworksMap = null;
    private Set<NetworkInfo> m_networksToConsider = null;
    private int m_taskType = 0;
    private String m_srcNode = null;
    private VerifyNetwork m_vfyNet = new VerifyNetwork();
    private NodeConnectivityResultSetImpl m_nodeConResSetImpl;
    private Hashtable<String, HashMap<String, List<String>>> m_nodeWiseIPMPGroupsWithParticipatingNICList;
    private boolean m_interfaceProvidedByUser = false;
    private boolean m_subnetProvidedByUser = false;

    public TaskNodeConnectivity(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("TYPE".equals(argName)) {
                if (argVal.equalsIgnoreCase("NODECON")) {
                    this.m_taskType = 0;
                    continue;
                }
                if (!argVal.equalsIgnoreCase(NODEREACH_KEY)) continue;
                this.m_taskType = 1;
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
        VerificationType vType = this.m_globalContext.getVerificationType();
        ParamPreReqNodeAddDel paramNodeAddDel = null;
        switch (vType) {
            case PREREQ_NODE_ADD: 
            case PREREQ_RACNODE_ADD: 
            case POSTREQ_NODE_ADD: {
                paramNodeAddDel = (ParamPreReqNodeAddDel)this.m_globalContext.getParamPrereq();
                if (paramNodeAddDel == null) break;
                this.setNodeList(paramNodeAddDel.getValidNewClusterNodes());
                break;
            }
            case PREREQ_FARM_HEALTH: {
                if (VerificationUtil.isStringGood(CVUVariables.getValue(CVUVariableConstants.INTERCONNECT_LIST))) break;
                return;
            }
            case COMPONENT_NODE_CONNECTIVITY: {
                String netArg = null;
                String[] interfaceList = this.m_globalContext.getParamManager().getMultiPartArgVal(CVUVariables.getValue(CVUVariableConstants.INTERFACE_LIST));
                String[] ipAddrList = this.m_globalContext.getParamManager().getMultiPartArgVal(CVUVariables.getValue(CVUVariableConstants.IP_LIST));
                netArg = CVUVariables.getValue(CVUVariableConstants.NETWORK_LIST);
                if (netArg != null) {
                    Trace.out((String)"Using the Network information provided as part of the command line input");
                    break;
                }
                if (ipAddrList != null) {
                    this.setIPAddrList(ipAddrList);
                    break;
                }
                if (interfaceList != null) {
                    Trace.out((String)("user has specified interfaces " + interfaceList));
                    this.setNetworksToConsider(NetworkUtility.createClusterNetworksBasedOnNetworkNames(interfaceList));
                    break;
                }
                Trace.out((String)"Networks not provided hence all networks will be considered");
                break;
            }
            case COMPONENT_NODE_REACHABILITY: {
                this.setSourceNode(CVUVariables.getValue(CVUVariableConstants.SOURCE_NODE));
                return;
            }
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (VerificationType.PREREQ_CRS_INST.equals((Object)this.m_globalContext.getVerificationType()) && VerificationUtil.isBaselineCollectionMode()) {
            return false;
        }
        if (VerificationUtil.isOPC() || VerificationUtil.isODALiteEnv()) {
            VerificationUtil.traceAndLog("skipping node connectivity task in  OPC/ODALite environment");
            return false;
        }
        if (VerificationUtil.skipTask(this)) {
            VerificationUtil.traceAndLog("This task " + this.getDefaultTaskID() + " is requested to be skipped" + " and hence not added to the taskList");
            return false;
        }
        VerificationType vType = this.m_globalContext.getVerificationType();
        switch (vType) {
            case PREREQ_CRS_INST: {
                if (!this.m_globalContext.isCRSSoftwareOnlyInstall()) break;
                Trace.out((String)"Skipping node connectivity as this is a software only install.");
                return false;
            }
            case PREREQ_FARM_HEALTH: {
                if (!VerificationUtil.isStringGood(CVUVariables.getValue(CVUVariableConstants.INTERCONNECT_LIST))) {
                    ReportUtil.printError(s_gMsgBundle.getMessage("11755", true, (Object[])new String[]{CVUVariableConstants.INTERCONNECT_LIST.toString(), this.m_globalContext.getParamManager().getInstallConfigFile()}));
                    Trace.out((String)"INTERCONNECT_LIST variable not defined, Hence this task is not applicable");
                    return false;
                }
                return true;
            }
            case POSTREQ_NODE_ADD: {
                ResultSet networksResultSet = new ResultSet();
                try {
                    if (NetworkUtility.isNetworksSetGood(NetworkUtility.getNetworkInfo(networksResultSet))) {
                        Trace.out((String)"Adding Node connectivity for post node add scenario");
                        return true;
                    }
                    Trace.out((String)"Failed to get the network configuration, NOT Adding Node connectivity for post node add scenario");
                    return false;
                }
                catch (CVUException cvuException) {
                    Trace.out((String)"Failed to get the network configuration, NOT Adding Node connectivity for post node add scenario");
                    return false;
                }
            }
        }
        return true;
    }

    public TaskNodeConnectivity() {
        this(null, 1);
    }

    public TaskNodeConnectivity(MultiTaskHandler multiTaskHandler) {
        this(multiTaskHandler, 1);
    }

    public TaskNodeConnectivity(MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(multiTaskHandler, actionOnCompletion);
    }

    public TaskNodeConnectivity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskNodeConnectivity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskNodeConnectivity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setNetworksToConsider(Set<NetworkInfo> networksToConsider) {
        for (NetworkInfo nInfo : networksToConsider) {
            Trace.out((String)("nInfo " + nInfo.getInterfaceName()));
        }
        if (NetworkUtility.isNetworksSetGood(networksToConsider)) {
            Trace.out((String)"user has provided networks");
            VerificationUtil.logNetworkInterfaces(networksToConsider);
            ResultSet networksResultSet = new ResultSet();
            networksToConsider = NetworkUtility.expandSubnetIPv6Addresses(networksToConsider);
            if (VerificationUtil.isCVUTestEnv()) {
                networksToConsider = NetworkUtility.skipIPv6LinkLocalAndLoopbackAddresses(networksToConsider);
            }
            if (!NetworkUtility.isNetworksSetGood(this.m_networksToConsider)) {
                this.m_networksToConsider = networksToConsider;
            } else {
                this.m_networksToConsider.addAll(networksToConsider);
            }
            Trace.out((String)"user has provided following networks");
            VerificationUtil.logNetworkInterfaces(this.m_networksToConsider);
            for (NetworkInfo network : this.m_networksToConsider) {
                if (VerificationUtil.isStringGood(network.getInterfaceName())) {
                    this.m_interfaceProvidedByUser = true;
                }
                if (!VerificationUtil.isStringGood(network.getSubnetAsString())) continue;
                this.m_subnetProvidedByUser = true;
            }
        }
    }

    public boolean setNetworksToConsider(List<String> networks, boolean areSubnets) {
        if (networks == null || networks.isEmpty()) {
            return false;
        }
        HashSet<NetworkInfo> networksToConsider = new HashSet<NetworkInfo>();
        for (String name : networks) {
            NetworkInfo network = new NetworkInfo();
            if (areSubnets) {
                network.setInterfaceName("");
                network.setSubnet(name);
                this.m_subnetProvidedByUser = true;
            } else {
                network.setInterfaceName(name);
            }
            networksToConsider.add(network);
        }
        this.m_networksToConsider = networksToConsider;
        this.setNetworksToConsider(this.m_networksToConsider);
        return true;
    }

    public boolean initializeNetworkDetails() {
        boolean retVal = true;
        ResultSet networksResultSet = new ResultSet();
        this.clean();
        HashMap<String, Set<NetworkInfo>> nodeNetworksMap = new HashMap();
        VerificationType vType = this.m_globalContext.getVerificationType();
        Trace.out((String)("Setting the network details required for the task. Verification Type is: " + (Object)((Object)vType)));
        Set<NetworkInfo> clusterNetworks = new HashSet<NetworkInfo>();
        switch (vType) {
            case PREREQ_FARM_HEALTH: {
                if (!VerificationUtil.isStringGood(CVUVariables.getValue(CVUVariableConstants.INTERCONNECT_LIST))) {
                    return true;
                }
            }
            case PREREQ_NODE_ADD: 
            case PREREQ_RACNODE_ADD: 
            case POSTREQ_NODE_ADD: {
                ParamPreReqNodeAddDel paramNodeAddDel = null;
                paramNodeAddDel = (ParamPreReqNodeAddDel)this.m_globalContext.getParamPrereq();
                if (paramNodeAddDel == null) break;
                this.setNodeList(paramNodeAddDel.getValidNewClusterNodes());
            }
        }
        this.m_globalNodeNetworksMap = NetworkDataDiscovery.getNodeNetworksMap(this.m_nodeList, networksResultSet);
        if (!NetworkUtility.isNetworksMapGood(this.m_globalNodeNetworksMap)) {
            Trace.out((String)"Could not discover the network details successfully during node connectivity checks");
            NetworkUtility.reportResultSet(networksResultSet, this.m_resultSet, true);
            return false;
        }
        if (VerificationUtil.isCRSConfigured() || VerificationUtil.isInterconnectListDefined() || VerificationUtil.isCLIMode() && CVUVariables.getValue(CVUVariableConstants.NETWORK_LIST) != null) {
            try {
                networksResultSet = new ResultSet();
                clusterNetworks = NetworkUtility.getNetworkInfo(networksResultSet);
                if (!NetworkUtility.isNetworksSetGood(clusterNetworks) && networksResultSet.anyFailure()) {
                    Trace.out((String)"Could not get the cluster network details successfully during node connectivity checks");
                    NetworkUtility.reportResultSet(networksResultSet, this.m_resultSet, true);
                    return false;
                }
            }
            catch (CVUException cvuEx) {
                String errMsg = cvuEx.getMessage();
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                ReportUtil.printError(errMsg);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(errDesc);
                Trace.out((String)("Exception occured while getting network info. msg=" + cvuEx.getMessage()));
                return false;
            }
        }
        if (NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            Trace.out((String)"Setting user specificed network details for node connectivity");
            this.setNetworksToConsider(clusterNetworks);
        }
        if (NetworkUtility.isNetworksSetGood(this.m_networksToConsider)) {
            Trace.out((String)"user provided networks");
            VerificationUtil.logNetworkInterfaces(this.m_networksToConsider);
            this.m_nodeNetworksMapForUserProvidedNetworks = NetworkDataDiscovery.getMatchingNodeNetworksMapOnNodes(this.m_globalNodeNetworksMap, this.m_networksToConsider, this.m_nodeList);
            nodeNetworksMap = this.m_nodeNetworksMapForUserProvidedNetworks;
            this.m_subnetNetworksMapForUserProvidedNetworks = NetworkDataDiscovery.getSubnetNetworksMap(this.m_nodeNetworksMapForUserProvidedNetworks, networksResultSet);
        } else {
            Trace.out((String)"no user provided networks");
            nodeNetworksMap = this.m_globalNodeNetworksMap;
            this.m_globalSubnetNetworksMap = NetworkDataDiscovery.getSubnetNetworksMap(nodeNetworksMap, networksResultSet);
        }
        if (!NetworkUtility.isNetworksMapGood(nodeNetworksMap)) {
            if (!NetworkUtility.isNetworksSetGood(this.m_networksToConsider)) {
                Trace.out((String)"Could not find valid interfaces on one or more nodes during node connectivity checks");
                ErrorDescription errDesc = new ErrorDescription();
                errDesc = new ErrorDescription(s_msgBundle.getMessage("6011", false, (Object[])new String[]{VerificationUtil.strArr2List(this.m_nodeList)}));
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(errDesc);
                ReportUtil.printError(errDesc.getErrorMessage());
                retVal = false;
            } else {
                HashSet<String> interfaceNames = new HashSet<String>();
                HashSet<String> subnetIds = new HashSet<String>();
                for (String networkName : NetworkDataDiscovery.getClusterNetworkNames(this.m_networksToConsider)) {
                    if (!VerificationUtil.isStringGood(networkName)) continue;
                    interfaceNames.add(networkName);
                }
                if (interfaceNames.isEmpty()) {
                    interfaceNames.add("ALL");
                }
                for (String subnet : NetworkDataDiscovery.getClusterNetworkSubnets(this.m_networksToConsider)) {
                    if (!VerificationUtil.isStringGood(subnet)) continue;
                    subnetIds.add(subnet);
                }
                String errorMessage = "";
                errorMessage = subnetIds.isEmpty() ? s_gMsgBundle.getMessage("11049", true, (Object[])new String[]{VerificationUtil.strList2List(new ArrayList<String>(interfaceNames)), VerificationUtil.strArr2List(this.m_nodeList)}) : s_gMsgBundle.getMessage("11081", true, (Object[])new String[]{VerificationUtil.strList2List(new ArrayList<String>(interfaceNames)), VerificationUtil.strList2List(new ArrayList<String>(subnetIds)), VerificationUtil.strArr2List(this.m_nodeList)});
                ResultSet.updateResultSetWithErrorDescription(errorMessage, networksResultSet, this.m_nodeList, true, true);
                NetworkUtility.reportResultSet(networksResultSet, this.m_resultSet, true);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                retVal = false;
            }
        }
        return retVal;
    }

    private boolean checkNetworksDetailsWithStatusUp() {
        Set<NetworkInfo> matchingNetworks = null;
        boolean retVal = true;
        HashSet<NetworkInfo> allFailedNetworks = new HashSet<NetworkInfo>();
        Trace.out((String)"Checking for network status started..");
        if (!NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMapForUserProvidedNetworks)) {
            for (String node : this.m_globalNodeNetworksMap.keySet()) {
                for (NetworkInfo networkInfo : this.m_globalNodeNetworksMap.get(node)) {
                    if (networkInfo.getStatus() == 22) continue;
                    allFailedNetworks.add(networkInfo);
                }
            }
        } else {
            for (NetworkInfo networkToConsider : this.m_networksToConsider) {
                String networkName = networkToConsider.getInterfaceName();
                String string = networkToConsider.getSubnetAsString();
                for (String node : this.m_nodeList) {
                    matchingNetworks = NetworkDataDiscovery.getNetworksBySubnetAndName(this.m_nodeNetworksMapForUserProvidedNetworks, node, string, networkName);
                    if (!NetworkUtility.isNetworksSetGood(matchingNetworks)) continue;
                    for (NetworkInfo network : matchingNetworks) {
                        if (network.getStatus() == 22) continue;
                        allFailedNetworks.add(network);
                    }
                }
            }
        }
        if (allFailedNetworks.size() > 0) {
            HashMap<Object, Object> failedNodeNetworkDetails = new HashMap();
            failedNodeNetworkDetails = NetworkUtility.getFailedNodeNetworkDetailsMap(allFailedNetworks);
            if (!failedNodeNetworkDetails.isEmpty()) {
                Set<Object> failedNodes = failedNodeNetworkDetails.keySet();
                Trace.out((String)("One or more interfaces on the following nodes have status down " + failedNodes.toArray(new String[0])));
                for (String string : failedNodeNetworkDetails.keySet()) {
                    String failedNetworkNames = VerificationUtil.strArr2List(NetworkUtility.getNetworkNamesFromFailedNodeNetworkDetails((List)failedNodeNetworkDetails.get(string)));
                    String ipAddresses = VerificationUtil.strArr2List(NetworkUtility.getIPAddressesFromFailedNodeNetworkDetails((List)failedNodeNetworkDetails.get(string)));
                    Trace.out((String)("Node " + string + " do not have status UP for the " + "following interfaces " + failedNetworkNames));
                    ErrorDescription errorDescription = new ErrorDescription(s_gMsgBundle.getMessage("11065", true, (Object[])new String[]{failedNetworkNames, string}));
                    this.m_resultSet.addErrorDescription(errorDescription);
                }
                Trace.out((String)("Checking for network status completed..some interfaces have status down on following nodes: " + VerificationUtil.strArr2List(failedNodeNetworkDetails.keySet().toArray(new String[0]))));
                this.m_resultSet.addResult(failedNodes.toArray(new String[0]), 4);
                retVal = false;
            } else {
                Trace.out((String)"Checking for network status completed.  All networks  have status as UP ");
                retVal = true;
            }
        } else {
            Trace.out((String)"Checking for network status completed.  All networks  have status as UP ");
            retVal = true;
        }
        this.updateNodeNetworksMapWithOnlyStatusUpNetworks();
        return retVal;
    }

    public void setIPAddrList(String[] IPAddrList) {
        this.m_IPAddrList = IPAddrList;
    }

    public void setTaskType(int type) {
        this.m_taskType = type;
    }

    public void setSourceNode(String srcNode) {
        this.m_srcNode = srcNode;
    }

    public NodeConnectivityResultSetImpl getNodeConnectivityResultSetImpl() {
        return this.m_nodeConResSetImpl;
    }

    @Override
    public void clean() {
        Trace.out((String)"Clearing cached network details'");
        this.m_subnetNetworksMapForUserProvidedNetworks = null;
        this.m_nodeNetworksMapForUserProvidedNetworks = null;
        this.m_globalNodeNetworksMap = null;
    }

    @Override
    public boolean performTask() {
        this.m_nodeConResSetImpl = new NodeConnectivityResultSetImpl();
        this.m_nodeWiseIPMPGroupsWithParticipatingNICList = null;
        boolean retVal = true;
        if (this.m_nodeList == null || this.m_nodeList.length == 0) {
            VerificationUtil.traceAndLog("NULL 'nodelist'");
            this.m_resultSet.addResult(m_localNode, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription("7515", s_msgBundle));
            return false;
        }
        if (this.m_IPAddrList != null && this.m_IPAddrList.length != this.m_nodeList.length) {
            Trace.out((String)"Address node mismatch");
            ReportUtil.printError(s_msgBundle.getMessage("4079", false) + LSEP);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription("4079", s_msgBundle));
            return false;
        }
        this.m_resultSet.addResult(this.m_nodeList, 1);
        if (VerificationUtil.isUpgrade() && this.isRolling()) {
            String currentCrsVer = VerificationUtil.getCRSActiveVersion();
            Trace.out((String)("It is a Rolling Upgrade scenario with an active CRS version as " + currentCrsVer));
            if (currentCrsVer != null && VerificationUtil.isVersionPre(currentCrsVer, "11.2")) {
                Trace.out((String)("Performing the Private IP and Private subnet check as it is an upgrade from pre 11.2 CRS with version " + currentCrsVer));
                retVal &= this.performPrivateIPSubnetCheckForUpgrade();
            } else {
                Trace.out((String)("Not performing the Private IP and Private subnet check even though it is an upgrade scenario with rolling upgrade the CRS version " + currentCrsVer + " is found to be post 11.2"));
            }
        }
        if (this.m_taskType == 0) {
            VerificationUtil.traceAndLog("Performing Node Connectivity verification task... " + LSEP);
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4063", false));
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            if (nativeSystem.isUnixSystem()) {
                TaskHostsFile taskNHF = new TaskHostsFile(this.m_nodeList);
                this.addChildTask(taskNHF);
                taskNHF.perform();
                this.m_resultSet.uploadResultSet(taskNHF.getResultSet());
            }
            Trace.out((String)"Initializing network details..");
            if (!this.initializeNetworkDetails()) {
                Trace.out((String)"Setting network details failed");
                this.m_resultSet.addResult(this.m_nodeList, 2);
                ReportUtil.printResult(s_msgBundle.getMessage("4087", false));
                return false;
            }
            Trace.out((String)"Initialized network details successfully");
            Trace.out((String)"Check network existence on all nodes");
            HashSet<String> validNodeList = new HashSet<String>();
            ResultSet networksResultSet = new ResultSet();
            retVal = NetworkUtility.isNetworksSetGood(this.m_networksToConsider) ? (retVal &= NetworkDataDiscovery.checkForNetworkExistenceOnAllNodes(this.m_nodeNetworksMapForUserProvidedNetworks, this.m_networksToConsider, this.m_nodeList, validNodeList, networksResultSet, TASK_TYPE)) : (retVal &= NetworkDataDiscovery.checkForNetworkExistenceOnAllNodes(this.m_globalNodeNetworksMap, null, this.m_nodeList, validNodeList, networksResultSet, TASK_TYPE));
            this.m_resultSet.addResultSetData(networksResultSet);
            if (validNodeList == null || validNodeList.isEmpty()) {
                ReportUtil.printResult(s_msgBundle.getMessage("4087", false));
                return false;
            }
            Trace.out((String)("Proceeding with the valid node list : " + validNodeList + " to perform the network checks"));
            this.m_nodeList = validNodeList.toArray(new String[0]);
            VerificationUtil.traceAndLog("Check Network details status UP");
            retVal &= this.checkNetworksDetailsWithStatusUp();
            if (VerificationUtil.isHAIPSupported() && !VerificationUtil.isCRSConfigured() && !NetworkUtility.isPureIPv6Env(this.m_nodeNetworksMapForUserProvidedNetworks)) {
                VerificationUtil.traceAndLog("Performing link-local address check on the interfaces..");
                retVal &= this.checkForLinkLocalAddresses();
            }
            if (VerificationUtil.getCurrentOS().equalsIgnoreCase("AIX") && !VerificationUtil.isCVUTestEnv() && VerificationUtil.isInterconnectListDefined()) {
                VerificationUtil.traceAndLog("Performing Monitor option check for AIX interfaces..");
                VerificationUtil.traceAndLog("Monitor option check " + ((retVal &= this.checkForMonitorOptionInPrivateInterfaces()) ? "passed" : "failed"));
            }
            if (VerificationUtil.isExadataSystem()) {
                if (VerificationUtil.isInterconnectListDefined()) {
                    VerificationUtil.traceAndLog(LSEP + "Performing non-infiniband check on the exadata interfaces..");
                    retVal &= this.checkForNonInfiniBandInterfaces();
                }
                VerificationUtil.traceAndLog("Performing ping6 check");
                retVal &= this.performPing6SuidCheck();
            }
            if (NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMapForUserProvidedNetworks)) {
                retVal &= this.verifyInterfaceConnectivity();
            } else {
                Trace.out((String)"No cluster networks provided.  Hence considering all networks across the nodes");
                retVal &= this.verifyNodeConnectivity();
            }
            if (this.m_nodeList.length > 1) {
                retVal &= this.performSubnetMaskConsistencyCheck();
            }
            if (VerificationUtil.isCRSConfigured() || VerificationUtil.isInterconnectListDefined()) {
                retVal &= this.performSubnetOverlapCheck();
            }
            retVal &= this.checkForSameIPOnMultipleNICS();
            ReportUtil.sureblankln();
            if (!this.m_resultSet.anyFailure()) {
                ReportUtil.printResult(s_msgBundle.getMessage("4086", false));
            } else {
                ReportUtil.printResult(s_msgBundle.getMessage("4087", false));
            }
        } else if (this.m_taskType == 1) {
            VerificationUtil.traceAndLog("_nw_:Performing Node Reachability verification task... " + LSEP);
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4078", false));
            boolean[] nodeConArray = new boolean[this.m_nodeList.length];
            String[] nodeErrorArray = new String[this.m_nodeList.length];
            VerifyNetwork vfyNet = new VerifyNetwork();
            if (this.m_srcNode != null) {
                if (!VerificationUtil.isUserEquivalenceOnNode(this.m_srcNode, true)) {
                    Trace.out((String)("Node Reach Equivalence check failed from source node." + LSEP));
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(s_msgBundle.getMessage("4083", true, (Object[])new String[]{this.m_srcNode})));
                    return false;
                }
                Trace.out((String)("Performing Node Reachability from source node..." + LSEP));
                retVal = vfyNet.checkReachFromSrcNode(this.m_nodeList, nodeConArray, this.m_srcNode, nodeErrorArray);
            } else {
                try {
                    this.m_srcNode = VerificationUtil.getNodeName(m_localNode);
                    Trace.out((String)("Performing Node Reachability from local node..." + LSEP));
                    retVal = vfyNet.checkReachFromLocalNode(this.m_nodeList, nodeConArray, nodeErrorArray);
                }
                catch (NetworkException ne) {
                    ReportUtil.sureprintln(ne.getMessage());
                    Trace.out((String)("NETWORK EXCEPTION: " + ne.getMessage()));
                    this.m_resultSet.addErrorDescription(new ErrorDescription(ne.getMessage()));
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    return false;
                }
            }
            for (int i = 0; i < this.m_nodeList.length; ++i) {
                String node = this.m_nodeList[i];
                if (nodeConArray[i]) {
                    this.m_resultSet.addResult(node, 1);
                    continue;
                }
                Trace.out((String)("Node " + this.m_nodeList[i] + " is not reachable"));
                ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("4083", true, (Object[])new String[]{this.m_srcNode}) + LSEP + nodeErrorArray[i]);
                this.m_resultSet.addResult(node, 2);
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
            }
            this.reportNodeReach(this.m_srcNode, this.m_nodeList, nodeConArray, nodeErrorArray, retVal);
        }
        ReportUtil.sureblankln();
        return retVal;
    }

    private boolean verifyNodeConnectivity() {
        Subnet okSubnet;
        Iterator<Subnet> okSubnetIter;
        ConMatrix matrix;
        TCPMatrix tcpMatrix;
        Vector<ConMatrix> matrixList;
        boolean retVal = false;
        boolean foundVIPOk = false;
        boolean foundValidSubnets = false;
        boolean foundPrivate = false;
        boolean foundPrivateSameName = false;
        int numOkNodes = this.m_nodeList.length;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        HashMap<Object, Object> nodeNetworksMap = new HashMap();
        HashMap<String, Set<NetworkInfo>> subnetNetworksMap = new HashMap();
        if (NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMapForUserProvidedNetworks)) {
            nodeNetworksMap = this.m_nodeNetworksMapForUserProvidedNetworks;
            subnetNetworksMap = this.m_subnetNetworksMapForUserProvidedNetworks;
        } else {
            nodeNetworksMap = this.m_globalNodeNetworksMap;
            subnetNetworksMap = this.m_globalSubnetNetworksMap;
        }
        if (nodeNetworksMap == null) {
            return false;
        }
        if (0 == nodeNetworksMap.size()) {
            for (int i = 0; i < this.m_nodeList.length; ++i) {
                String node = this.m_nodeList[i];
                this.m_resultSet.addResult(node, 2);
                String errMsg = s_msgBundle.getMessage("4087", false);
                String cause = s_msgBundle.getMessage("6011", false, (Object[])new String[]{node});
                String action = s_msgBundle.getMessage("6012", false, (Object[])new String[]{node});
                Trace.out((String)("No OK nodes: " + errMsg));
                this.m_resultSet.getResult(node).addErrorDescription(new ErrorDescription(errMsg, cause, action));
            }
            ReportUtil.printError(s_msgBundle.getMessage("4080", true));
            return false;
        }
        this.reportNetworkInfo(nodeNetworksMap);
        ReportUtil.sureblankln();
        boolean mtuRetVal = this.performMTUConsistencyCheck();
        Collection<Object> tcpMatrixList = null;
        List<Subnet> infinibandSubnetList = null;
        List<Subnet> subnets = this.getSpecifiedSubnetList(subnetNetworksMap);
        if (mtuRetVal && VerificationUtil.isPlatformLinux()) {
            TaskIPPacketSizeCheck ipPacketCheck = new TaskIPPacketSizeCheck(this.m_nodeList, subnets);
            this.addChildTask(ipPacketCheck);
            mtuRetVal &= ipPacketCheck.perform();
            this.m_resultSet.uploadResultSet(ipPacketCheck.getResultSet());
        }
        tcpMatrixList = new Vector();
        Vector<ConMatrix> rdsMatrixList = new Vector<ConMatrix>(subnets.size());
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)("subnetList size: " + subnets.size()));
        }
        if (m_isAPImode) {
            this.getNodeConnAPIData(subnets);
        }
        try {
            matrixList = new Vector<ConMatrix>(subnets.size());
            ResultSet subnetConnectivityResultSet = new ResultSet();
            foundValidSubnets = this.m_vfyNet.checkSubnetConnectivity(subnets, matrixList, subnetConnectivityResultSet, false);
            if (!foundValidSubnets || subnetConnectivityResultSet.anyWarning() || subnetConnectivityResultSet.anyFailure()) {
                VerificationUtil.traceAndLog("Failures found during subnets connectivity check");
                this.m_resultSet.addResultSetData(subnetConnectivityResultSet);
                this.m_resultSet.setStatus(4);
            }
            if (!VerificationUtil.isYodaInBMCEnvironment()) {
                tcpMatrixList = this.m_vfyNet.checkSubnetTCPConnectivity(subnets);
            }
            if (VerificationUtil.isExadataSystem()) {
                infinibandSubnetList = this.performRDSPingCheck(subnets, rdsMatrixList);
            }
        }
        catch (NetworkException ne) {
            Trace.out((String)("NETWORK EXCEPTION: " + ne.getMessage()));
            ReportUtil.printError(ne.getMessage());
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(ne.getMessage()));
            retVal = false;
            return false;
        }
        Iterator<ConMatrix> matrixIter = matrixList.iterator();
        Iterator<Object> tcpMatrixIter = tcpMatrixList.iterator();
        Iterator<ConMatrix> rdsMatrixIter = rdsMatrixList.iterator();
        for (ConMatrix conMatrix : matrixList) {
            Trace.out((String)("Report ping connectivity for subnet " + conMatrix.getKey()));
            this.reportNodeCon(conMatrix);
        }
        if (tcpMatrixIter.hasNext()) {
            for (Subnet subnet : subnets) {
                tcpMatrix = (TCPMatrix)tcpMatrixIter.next();
                Trace.out((String)("Report TCP connectivity for subnet " + subnet.getSubnet()));
                this.reportTCPCon(subnet.getSubnet(), tcpMatrix);
            }
        }
        if (infinibandSubnetList != null) {
            for (Subnet subnet : infinibandSubnetList) {
                ConMatrix rdsMatrix = rdsMatrixIter.next();
                this.reportRDSCon(subnet.getSubnet(), rdsMatrix);
            }
        }
        matrixIter = matrixList.iterator();
        for (Subnet subnet : subnets) {
            matrix = matrixIter.next();
            if (matrix.getStatus() != 1) continue;
            boolean warningIssued = false;
            okSubnetIter = subnet.getVIPOkSubnets(numOkNodes).iterator();
            block7: while (okSubnetIter.hasNext()) {
                Trace.out((String)"Found VIP Ok");
                foundVIPOk = true;
                warningIssued = false;
                okSubnet = okSubnetIter.next();
                this.reportVIPOkInterfaces(okSubnet);
                for (String node : subnet.getNodes()) {
                    for (NetworkInfo network : subnet.getNetworksByNode(node)) {
                        if ((network.getSubnetGatewayAsString() != null || network.getDefaultGatewayAsString() != null) && (network.getSubnetGatewayAsString() == null || network.getDefaultGatewayAsString() == null || !network.getSubnetGatewayAsString().equals("0.0.0.0") || !network.getDefaultGatewayAsString().equals("UNKNOWN"))) continue;
                        String errMsg = s_msgBundle.getMessage("6019", false, (Object[])new String[]{okSubnet.getSubnet()});
                        this.m_resultSet.addResult(node, 4);
                        this.m_resultSet.getResult(node).addErrorDescription(new ErrorDescription(errMsg));
                        Trace.out((String)("No Gateway: " + errMsg));
                        ReportUtil.printWarning(errMsg);
                        warningIssued = true;
                        break;
                    }
                    if (!warningIssued) continue;
                    continue block7;
                }
            }
        }
        matrixIter = matrixList.iterator();
        tcpMatrixIter = tcpMatrixList.iterator();
        for (Subnet subnet : subnets) {
            boolean tcpSuccess = true;
            if (tcpMatrixIter.hasNext()) {
                tcpMatrix = (TCPMatrix)tcpMatrixIter.next();
                tcpSuccess = tcpMatrix.isAllSuccess();
            }
            if ((matrix = matrixIter.next()).getStatus() != 1 || !tcpSuccess) continue;
            okSubnetIter = subnet.getPrivateOkSubnets(numOkNodes, true).iterator();
            while (okSubnetIter.hasNext()) {
                foundPrivateSameName = true;
                okSubnet = okSubnetIter.next();
                this.reportPrivateOkInterfaces(okSubnet);
            }
        }
        if (!foundPrivateSameName) {
            matrixIter = matrixList.iterator();
            tcpMatrixIter = tcpMatrixList.iterator();
            for (Subnet subnet : subnets) {
                boolean tcpSuccess = true;
                if (tcpMatrixIter.hasNext()) {
                    tcpMatrix = (TCPMatrix)tcpMatrixIter.next();
                    tcpSuccess = tcpMatrix.isAllSuccess();
                }
                if ((matrix = matrixIter.next()).getStatus() != 1 || !tcpSuccess) continue;
                okSubnetIter = subnet.getPrivateOkSubnets(numOkNodes, false).iterator();
                while (okSubnetIter.hasNext()) {
                    foundPrivate = true;
                    okSubnet = okSubnetIter.next();
                    this.reportPrivateOkInterfaces(okSubnet);
                }
            }
        }
        if (!foundVIPOk) {
            ReportUtil.printWarning(s_msgBundle.getMessage("4101", false));
        }
        if (!foundPrivateSameName && foundPrivate) {
            ReportUtil.printWarning(s_msgBundle.getMessage("4103", false));
        } else if (!foundPrivateSameName) {
            ReportUtil.printWarning(s_msgBundle.getMessage("4102", false));
        }
        boolean bl = retVal = numOkNodes == this.m_nodeList.length && foundValidSubnets;
        if (retVal) {
            this.m_resultSet.addResult(this.m_nodeList, 1);
        } else if (this.m_resultSet.getStatus() != 3) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
        }
        retVal = retVal && mtuRetVal;
        return retVal;
    }

    private boolean verifyInterfaceConnectivity() {
        boolean retVal = true;
        List<Subnet> infinibandSubnetList = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        HashMap<String, Set<NetworkInfo>> nodeNetworksMap = this.m_nodeNetworksMapForUserProvidedNetworks;
        HashMap<String, Set<NetworkInfo>> subnetNetworksMap = this.m_subnetNetworksMapForUserProvidedNetworks;
        subnetNetworksMap = NetworkDataDiscovery.removeLogicalInterfaceSyntax(subnetNetworksMap);
        if (nodeNetworksMap.size() == 0) {
            String errMsg = s_msgBundle.getMessage("4080", true);
            this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errMsg));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ReportUtil.printError(errMsg + LSEP);
            return false;
        }
        for (String node : this.m_nodeList) {
            Set<NetworkInfo> networks = nodeNetworksMap.get(node);
            if (NetworkUtility.isNetworksSetGood(networks)) continue;
            String errMsg = s_msgBundle.getMessage("6003", true, (Object[])new String[]{node});
            this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
            this.m_resultSet.addResult(node, 2);
        }
        this.reportNetworkInfo(nodeNetworksMap);
        ReportUtil.blankln();
        boolean mtuRetVal = this.performMTUConsistencyCheck();
        boolean subnetRetVal = this.performSubnetExistanceCheck();
        List<Subnet> subnets = this.getSpecifiedSubnetList(subnetNetworksMap);
        Vector<ConMatrix> matrixList = new Vector<ConMatrix>(subnets.size());
        Collection<Object> tcpMatrixList = new Vector(subnets.size());
        Vector<ConMatrix> rdsMatrixList = new Vector<ConMatrix>(subnets.size());
        Collection<Subnet> haipSubnets = null;
        Trace.out((String)("subnetList size: " + subnets.size()));
        if (m_isAPImode) {
            this.getNodeConnAPIData(subnets);
        }
        try {
            ResultSet subnetConnectivityResultSet;
            boolean foundValidSubnets;
            if (VerificationUtil.isCRSConfigured()) {
                VerificationUtil.traceAndLog("Check if any HAIP addresses to ping");
                Set<NetworkInfo> haipNetworks = this.getHaipNetworks();
                if (NetworkUtility.isNetworksSetGood(haipNetworks)) {
                    VerificationUtil.traceAndLog("Found private HAIP addresses to ping");
                    haipSubnets = Subnet.classifyToSubnets(haipNetworks, false);
                    if (haipSubnets != null && !haipSubnets.isEmpty()) {
                        subnets.addAll(haipSubnets);
                    }
                }
            }
            if (!(foundValidSubnets = this.m_vfyNet.checkSubnetConnectivity(subnets, matrixList, subnetConnectivityResultSet = new ResultSet(), false)) || subnetConnectivityResultSet.anyFailure() || subnetConnectivityResultSet.anyWarning()) {
                VerificationUtil.traceAndLog("Failures found during subnets connectivity check");
                this.m_resultSet.addResultSetData(subnetConnectivityResultSet);
                this.m_resultSet.setStatus(4);
            }
            if (haipSubnets != null && !haipSubnets.isEmpty()) {
                subnets.removeAll(haipSubnets);
            }
            if (!VerificationUtil.isYodaInBMCEnvironment()) {
                tcpMatrixList = this.m_vfyNet.checkSubnetTCPConnectivity(subnets);
            }
            if (VerificationUtil.isExadataSystem()) {
                infinibandSubnetList = this.performRDSPingCheck(subnets, rdsMatrixList);
            }
        }
        catch (NetworkException ne) {
            Trace.out((String)("NETWORK EXCEPTION: " + ne));
            ReportUtil.printError(ne.getMessage());
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(ne.getMessage()));
            return false;
        }
        Iterator<ConMatrix> matrixIter = matrixList.iterator();
        Iterator<Object> tcpMatrixIter = tcpMatrixList.iterator();
        Iterator<ConMatrix> rdsMatrixIter = rdsMatrixList.iterator();
        for (ConMatrix conMatrix : matrixList) {
            Trace.out((String)("Report ping connectivity for subnet " + conMatrix.getKey()));
            if (conMatrix.getStatus() != 1) {
                Trace.out((String)(" Matrix status: " + conMatrix.getStatus()));
                retVal = false;
            }
            this.reportNodeCon(conMatrix);
        }
        if (tcpMatrixIter.hasNext()) {
            for (Subnet subnet : subnets) {
                TCPMatrix tcpMatrix = (TCPMatrix)tcpMatrixIter.next();
                ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("11062", false, (Object[])new String[]{subnet.getSubnet()}));
                if (!tcpMatrix.isAllSuccess()) {
                    Trace.out((String)("TCP isAllSuccess: " + tcpMatrix.isAllSuccess()));
                    retVal = false;
                }
                this.reportTCPCon(subnet.getSubnet(), tcpMatrix);
            }
        }
        if (infinibandSubnetList != null) {
            for (Subnet subnet : infinibandSubnetList) {
                ConMatrix rdsMatrix = rdsMatrixIter.next();
                this.reportRDSCon(subnet.getSubnet(), rdsMatrix);
            }
        }
        this.m_resultSet.traceResultSet("... verifyInterfaceConnectivity results ...");
        if (mtuRetVal && VerificationUtil.isPlatformLinux()) {
            TaskIPPacketSizeCheck ipPacketCheck = new TaskIPPacketSizeCheck(this.m_nodeList, subnets);
            this.addChildTask(ipPacketCheck);
            mtuRetVal &= ipPacketCheck.perform();
            this.m_resultSet.uploadResultSet(ipPacketCheck.getResultSet());
        }
        Trace.out((String)("MTU consistency return value : " + mtuRetVal + "Subnet existence return value : " + subnetRetVal + " Return value : " + retVal));
        return retVal && mtuRetVal && subnetRetVal;
    }

    private boolean performSubnetMaskConsistencyCheck() {
        boolean retVal = true;
        ResultSet subnetMaskRS = null;
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11057", false));
        HashMap<Object, Object> subnetNetworksMap = new HashMap();
        subnetNetworksMap = NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMapForUserProvidedNetworks) ? this.m_subnetNetworksMapForUserProvidedNetworks : this.m_globalSubnetNetworksMap;
        for (String string : subnetNetworksMap.keySet()) {
            subnetMaskRS = new ResultSet();
            HashMap subnetMaskNetworksMap = new HashMap();
            Trace.out((String)("trying to check subnetmask is same for subnet:" + string));
            for (NetworkInfo network : (Set)subnetNetworksMap.get(string)) {
                HashSet<NetworkInfo> subnetMasksMatchingNetworks = new HashSet<NetworkInfo>();
                String netMask = network.getSubnetMaskAsString();
                if (subnetMaskNetworksMap.containsKey(netMask)) {
                    subnetMasksMatchingNetworks.addAll((Collection)subnetMaskNetworksMap.get(netMask));
                }
                subnetMasksMatchingNetworks.add(network);
                subnetMaskNetworksMap.put(netMask, subnetMasksMatchingNetworks);
            }
            if (subnetMaskNetworksMap != null && subnetMaskNetworksMap.size() > 1) {
                retVal = false;
                Trace.out((String)("subnet:" + string + " has more than one subnet mask"));
                String msgMultpleSubnets = s_gMsgBundle.getMessage("11055", true, (Object[])new String[]{string});
                for (String subnetMask : subnetMaskNetworksMap.keySet()) {
                    Set<String> nodes = NetworkDataDiscovery.getClusterNetworkNodeNames((Set)subnetMaskNetworksMap.get(subnetMask));
                    List<String> subnetMasks = NetworkDataDiscovery.getClusterNetworkSubnetMasks((Set)subnetMaskNetworksMap.get(subnetMask));
                    Trace.out((String)("Subnet number " + string + " is configured using " + "subnet mask " + subnetMask + "on nodes " + nodes));
                    String msg = s_gMsgBundle.getMessage("11056", true, (Object[])new String[]{string, VerificationUtil.strList2List(new ArrayList<String>(subnetMasks)), VerificationUtil.strArr2List(nodes.toArray(new String[0]))});
                    ReportUtil.sureprintln(msg);
                    msgMultpleSubnets = msgMultpleSubnets + LSEP + msg;
                }
                ResultSet.updateResultSetWithErrorDescription(msgMultpleSubnets, subnetMaskRS, this.m_nodeList, true, true);
            } else {
                String msg = s_gMsgBundle.getMessage("11059", false, (Object[])new String[]{string});
                ReportUtil.sureprintln(msg);
                subnetMaskRS.addResult(this.m_nodeList, 1);
            }
            TaskAnonymousProxy subnetMaskTask = new TaskAnonymousProxy(s_gMsgBundle.getMessage("11063", false, (Object[])new String[]{string}), this.m_nodeList, this);
            subnetMaskTask.performAnonymousTask(subnetMaskRS);
        }
        if (retVal) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11058", false));
        } else {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11060", false));
        }
        return retVal;
    }

    private List<String> getActiveInterfaceListOnNode(String node, String subnet) {
        List<String> activeIfList = new ArrayList<String>();
        Set<NetworkInfo> matchingNetworks = new HashSet<NetworkInfo>();
        HashMap<String, Set<NetworkInfo>> nodeNetworksMap = new HashMap();
        nodeNetworksMap = NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMapForUserProvidedNetworks) ? this.m_nodeNetworksMapForUserProvidedNetworks : this.m_globalNodeNetworksMap;
        if (subnet != null) {
            Trace.out((String)("getting all interfaces  on subnet  on node " + node));
            matchingNetworks = NetworkDataDiscovery.getNetworksBySubnet(nodeNetworksMap, subnet, node);
        }
        if (NetworkUtility.isNetworksSetGood(matchingNetworks)) {
            activeIfList = NetworkDataDiscovery.getClusterNetworkNames(matchingNetworks);
        }
        return activeIfList;
    }

    private boolean performSubnetExistanceCheck() {
        boolean retVal = true;
        HashSet<String> badNodeList = new HashSet<String>();
        for (NetworkInfo network : this.m_networksToConsider) {
            if (!VerificationUtil.isStringGood(network.getSubnetAsString()) || !this.m_nodeMgr.isBigCluster() || network.getNetworkType() != NetworkConstants.NetworkType.PUBLIC.getValue()) continue;
            Trace.out((String)("This is big cluster. skipping existance check for public subnet=" + network.getSubnetAsString()));
        }
        Set<Object> matchingNetworks = new HashSet();
        for (NetworkInfo network : this.m_networksToConsider) {
            boolean bWarn;
            String networkName = network.getInterfaceName();
            String subnet = network.getSubnetAsString();
            for (String node : this.m_nodeNetworksMapForUserProvidedNetworks.keySet()) {
                Trace.out((String)("getting all interfaces " + networkName + " on subnet " + subnet + " on node " + node));
                matchingNetworks = this.m_nodeNetworksMapForUserProvidedNetworks.get(node);
                if (NetworkUtility.isNetworksSetGood(matchingNetworks)) continue;
                if (subnet == null) {
                    Trace.out((String)("could not find any matching networks on node" + node + " for the interface " + networkName));
                } else {
                    Trace.out((String)("could not find any matching networks on node" + node + " for the interface " + networkName + " and subnet " + subnet));
                }
                List<String> ipmpInterfacesOnNodeforParticipatingGroupOfIfName = this.getInterfacesParticipatingInIPMPGroup(node, networkName);
                List<String> activeInterfaceForSubnetOnNode = this.getActiveInterfaceListOnNode(node, subnet);
                if (ipmpInterfacesOnNodeforParticipatingGroupOfIfName != null && ipmpInterfacesOnNodeforParticipatingGroupOfIfName.contains(networkName) && !ipmpInterfacesOnNodeforParticipatingGroupOfIfName.isEmpty() && !activeInterfaceForSubnetOnNode.isEmpty()) {
                    boolean hasParticipatingActiveInterfaceConfigured = false;
                    for (String activeInterface : activeInterfaceForSubnetOnNode) {
                        if (!ipmpInterfacesOnNodeforParticipatingGroupOfIfName.contains(activeInterface)) continue;
                        Trace.out((String)("The interface (" + activeInterface + ") configured " + "for this subnet is active on node (" + node + ") and is also part of ipmp group in which the " + "inactive interface (" + networkName + ") also participates." + " For IPMP configuration on solaris this is fine scenario " + "and hence skipping this inactive interface"));
                        hasParticipatingActiveInterfaceConfigured = true;
                    }
                    if (hasParticipatingActiveInterfaceConfigured) {
                        Trace.out((String)("Node: " + node + " has inactive interface '" + networkName + "' which is a part of IPMP group. Skipping...."));
                        continue;
                    }
                    badNodeList.add(node);
                    Trace.out((String)("Node: " + node + " has no '" + networkName + "' interfaces and neither does IPMP group have any " + "actively configured interfaces"));
                    continue;
                }
                badNodeList.add(node);
                Trace.out((String)("Node: " + node + " has no '" + networkName + "' interfaces!"));
            }
            if (badNodeList.size() <= 0) continue;
            int networkType = network.getNetworkType();
            String msg = null;
            msg = subnet == null ? s_gMsgBundle.getMessage("11049", true, (Object[])new String[]{networkName, VerificationUtil.strList2List(new ArrayList<String>(badNodeList))}) : s_gMsgBundle.getMessage("11050", true, (Object[])new String[]{networkName, subnet, VerificationUtil.strList2List(new ArrayList<String>(badNodeList))});
            boolean bl = bWarn = networkType != 1 && networkType != 2;
            if (bWarn) {
                ReportUtil.printWarning(msg);
            } else {
                ReportUtil.printError(msg);
            }
            ErrorDescription errDesc = new ErrorDescription(msg);
            Trace.out((String)("Found Bad node(s): " + errDesc.getErrorMessage()));
            String[] nodeList = badNodeList.toArray(new String[0]);
            if (bWarn) {
                this.m_resultSet.addResult(nodeList, 4);
            } else {
                this.m_resultSet.addResult(nodeList, 3);
            }
            this.m_resultSet.addErrorDescription(nodeList, errDesc);
            retVal = false;
        }
        return retVal;
    }

    private boolean performSubnetOverlapCheck() {
        boolean retVal = true;
        HashMap<String, Set<NetworkInfo>> nodeNetworksMap = new HashMap();
        nodeNetworksMap = NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMapForUserProvidedNetworks) ? this.m_nodeNetworksMapForUserProvidedNetworks : this.m_globalNodeNetworksMap;
        if (!NetworkUtility.isNetworksMapGood(nodeNetworksMap)) {
            Trace.out((String)"Empty node-networks information during subnet overlap check");
            return false;
        }
        Trace.out((String)"Subnet overlapping check started");
        retVal = NetworkUtility.areSubnetsOverlapping(nodeNetworksMap, this.m_resultSet);
        VerificationUtil.traceAndLog("Subnet overlapping check " + (retVal ? "passed" : "failed"));
        return retVal;
    }

    private boolean checkForSameIPOnMultipleNICS() {
        boolean retVal = true;
        HashMap<String, Vector<NetworkInfo>> ipAddrMap = new HashMap<String, Vector<NetworkInfo>>();
        HashMap<String, Set<NetworkInfo>> nodeNetworksMap = new HashMap();
        Trace.out((String)"Same IP on multiple interfaces check started");
        nodeNetworksMap = NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMapForUserProvidedNetworks) ? this.m_nodeNetworksMapForUserProvidedNetworks : this.m_globalNodeNetworksMap;
        if (!NetworkUtility.isNetworksMapGood(nodeNetworksMap)) {
            Trace.out((String)"Empty node-networks information");
            return false;
        }
        HashSet allNetworks = new HashSet();
        for (String node : nodeNetworksMap.keySet()) {
            allNetworks.addAll(nodeNetworksMap.get(node));
        }
        Trace.out((String)"Prepare IP address map for the interfaces");
        for (NetworkInfo network : allNetworks) {
            String ipAddr = network.getIPAsString();
            Vector<NetworkInfo> tmpIfList = (Vector<NetworkInfo>)ipAddrMap.get(ipAddr);
            if (tmpIfList == null) {
                tmpIfList = new Vector<NetworkInfo>();
                ipAddrMap.put(ipAddr, tmpIfList);
            }
            tmpIfList.add(network);
        }
        for (String ipAddr : ipAddrMap.keySet()) {
            Collection tempNetworks = (Collection)ipAddrMap.get(ipAddr);
            if (tempNetworks.size() <= 1) continue;
            Trace.out((String)("IP address " + ipAddr + " is same on one or more network interfaces "));
            HashSet<String> nodes = new HashSet<String>();
            HashSet<String> failedNetworks = new HashSet<String>();
            for (NetworkInfo network : tempNetworks) {
                nodes.add(network.getNodeName());
                failedNetworks.add(network.getInterfaceName());
            }
            String[] nodeArray = nodes.toArray(new String[0]);
            String errorMessage = s_gMsgBundle.getMessage("1172", true, (Object[])new String[]{ipAddr, VerificationUtil.strArr2List(failedNetworks.toArray(new String[0])), VerificationUtil.strArr2List(nodeArray)});
            ResultSet.updateResultSetWithErrorDescription(errorMessage, this.m_resultSet, nodeArray, true, true);
            retVal = false;
        }
        VerificationUtil.traceAndLog("Same IP address on multiple interfaces check " + (retVal ? "passed" : "failed"));
        return retVal;
    }

    private boolean checkForLinkLocalAddresses() {
        HashMap<String, List<String[]>> failedNodeNetworkDetails;
        boolean retVal = true;
        ResultSet networksResultSet = new ResultSet();
        HashSet<NetworkInfo> failedNetworks = new HashSet<NetworkInfo>();
        Trace.out((String)"Checking for link-local addresses started..");
        HashMap<String, Set<NetworkInfo>> nodeNetworksMap = NetworkDataDiscovery.getNodeNetworksMap(this.m_nodeList, networksResultSet);
        if (!NetworkUtility.isNetworksMapGood(nodeNetworksMap)) {
            Trace.out((String)"Empty node-networks information");
            this.m_resultSet.addResultSetData(networksResultSet);
            return false;
        }
        for (String node : nodeNetworksMap.keySet()) {
            for (NetworkInfo network : nodeNetworksMap.get(node)) {
                if (!network.getIPAsString().startsWith(LINK_LOCAL_ADDRESS)) continue;
                Trace.out((String)("Interface " + network.getInterfaceName() + " on the node " + network.getNodeName() + " has link-local address: " + network.getIPAsString()));
                failedNetworks.add(network);
            }
        }
        if (failedNetworks.size() > 0 && !(failedNodeNetworkDetails = NetworkUtility.getFailedNodeNetworkDetailsMap(failedNetworks)).isEmpty()) {
            for (String node : failedNodeNetworkDetails.keySet()) {
                List<String[]> networkList = failedNodeNetworkDetails.get(node);
                if (networkList.size() <= 2) continue;
                String interfaces = VerificationUtil.strArr2List(networkList.get(0));
                String subnets = VerificationUtil.strArr2List(networkList.get(1));
                String ipAddresses = VerificationUtil.strArr2List(networkList.get(2));
                Trace.out((String)("Node " + node + " has link-local address on the " + "following interfaces " + interfaces + "with IP addresses " + ipAddresses + ", subnet Ids " + subnets));
                String errMsg = s_gMsgBundle.getMessage("11069", true, (Object[])new String[]{ipAddresses, interfaces, node});
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, errorDesc);
                this.m_resultSet.addResult(node, 4);
                ReportUtil.printWarning(errMsg);
                retVal = false;
            }
        }
        VerificationUtil.traceAndLog("Link local address check " + (retVal ? "passed" : "failed"));
        return retVal;
    }

    private boolean performPing6SuidCheck() {
        boolean ipv6Exists = false;
        HashMap<Object, Object> nodeNetworksMap = new HashMap();
        HashMap<String, Set<NetworkInfo>> subnetNetworksMap = new HashMap();
        if (NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMapForUserProvidedNetworks)) {
            nodeNetworksMap = this.m_nodeNetworksMapForUserProvidedNetworks;
            subnetNetworksMap = this.m_subnetNetworksMapForUserProvidedNetworks;
        } else {
            nodeNetworksMap = this.m_globalNodeNetworksMap;
            subnetNetworksMap = this.m_globalSubnetNetworksMap;
        }
        if (this.m_interfaceProvidedByUser) {
            block0: for (String string : nodeNetworksMap.keySet()) {
                for (NetworkInfo network : (Set)nodeNetworksMap.get(string)) {
                    if (!NetworkUtility.isIPV6(network, false)) continue;
                    ipv6Exists = true;
                    continue block0;
                }
            }
        } else {
            List<Subnet> subnets = this.getSpecifiedSubnetList(subnetNetworksMap);
            for (Subnet subnet : subnets) {
                if (!IPAddressUtil.isIPv6AddressString((String)subnet.getSubnet())) continue;
                ipv6Exists = true;
                break;
            }
        }
        if (ipv6Exists) {
            return this.checkPing6SUID();
        }
        Trace.out((String)"No ipv6 interfaces exists. Skipping the suid check for ping6");
        return true;
    }

    private boolean checkPing6SUID() {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet resultSet = new ResultSet();
        ArrayList<String> ping6ExistNodes = new ArrayList<String>();
        ArrayList<String> operationFailedNodes = new ArrayList<String>();
        String filePath = "/usr/sbin/ping ";
        boolean retVal = true;
        globalExec.checkFileExistence(this.m_nodeList, filePath, resultSet);
        NetworkUtility.reportResultSet(resultSet, this.m_resultSet, true);
        Hashtable ht = resultSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                ping6ExistNodes.add(node);
                continue;
            }
            if (result.getStatus() != 2) continue;
            String errMsg = s_msgBundle.getMessage("5310", true, (Object[])new String[]{filePath, node}) + LSEP + result.getErrMessage();
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(node, errorDesc);
            ReportUtil.printError(errMsg);
            operationFailedNodes.add(node);
            retVal = false;
        }
        if (operationFailedNodes.size() == 0) {
            if (ping6ExistNodes.size() == 0) {
                Trace.out((String)"No single node has the ping6 binary file. Skipping the check setuid for ping6");
                retVal = true;
            } else {
                Trace.out((String)("checking the suid for ping6 on nodes : " + VerificationUtil.strList2List(ping6ExistNodes)));
                resultSet.clear();
                String[] nodeList = ping6ExistNodes.toArray(new String[0]);
                retVal = VerificationUtil.checkSetUID(nodeList, filePath, resultSet);
                NetworkUtility.reportResultSet(resultSet, this.m_resultSet, true);
            }
        }
        return retVal;
    }

    private boolean checkForNonInfiniBandInterfaces() {
        boolean retVal = true;
        HashSet<NetworkInfo> allFailedNetworks = new HashSet<NetworkInfo>();
        HashMap<String, Set<NetworkInfo>> nodeNetworksMap = new HashMap();
        nodeNetworksMap = NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMapForUserProvidedNetworks) ? this.m_nodeNetworksMapForUserProvidedNetworks : this.m_globalNodeNetworksMap;
        Trace.out((String)"Checking for non-infiniband type on private networks started..");
        if (VerificationUtil.isCRSConfigured()) {
            Set<NetworkInfo> clusterNetworks = NetworkDataDiscovery.getClusterNetworks(m_localNode, this.m_resultSet);
            if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
                Trace.out((String)"Cluster networks fetched is null or empty");
                return false;
            }
            HashMap<String, Set<NetworkInfo>> matchingNodeNetworksMap = NetworkDataDiscovery.getMatchingNodeNetworksMapOnNodes(nodeNetworksMap, clusterNetworks, this.m_nodeList);
            for (String string : matchingNodeNetworksMap.keySet()) {
                for (NetworkInfo network : matchingNodeNetworksMap.get(string)) {
                    if (!NetworkUtility.isSameType(network.getNetworkType(), NetworkConstants.NetworkType.PRIVATE.getValue()) || !network.getHardwareType().equalsIgnoreCase("InfiniBand")) continue;
                    Trace.out((String)("Private interface " + network.getInterfaceName() + " on the node " + network.getNodeName() + " is not Infiniband type: " + network.getHardwareType()));
                    allFailedNetworks.add(network);
                }
            }
        }
        if (allFailedNetworks.size() > 0) {
            HashMap<Object, Object> failedNodeNetworkDetails = new HashMap();
            failedNodeNetworkDetails = NetworkUtility.getFailedNodeNetworkDetailsMap(allFailedNetworks);
            if (!failedNodeNetworkDetails.isEmpty()) {
                Set<Object> failedNodes = failedNodeNetworkDetails.keySet();
                Trace.out((String)("One or more private interfaces on the following nodes have non infiniband interface type " + failedNodes.toArray(new String[0])));
                for (String string : failedNodeNetworkDetails.keySet()) {
                    String failedNetworkNames = VerificationUtil.strArr2List(NetworkUtility.getNetworkNamesFromFailedNodeNetworkDetails((List)failedNodeNetworkDetails.get(string)));
                    String ipAddresses = VerificationUtil.strArr2List(NetworkUtility.getIPAddressesFromFailedNodeNetworkDetails((List)failedNodeNetworkDetails.get(string)));
                    String subnets = VerificationUtil.strArr2List(NetworkUtility.getSubnetsFromFailedNodeNetworkDetails((List)failedNodeNetworkDetails.get(string)));
                    String subnetMasks = VerificationUtil.strArr2List(NetworkUtility.getSubnetMasksFromFailedNodeNetworkDetails((List)failedNodeNetworkDetails.get(string)));
                    Trace.out((String)("Node " + string + " has non infiniband interface type " + "on the following private networks " + failedNetworkNames + "with IP addresses " + ipAddresses + " and" + " subnet Ids " + subnets + " and subnet masks " + subnetMasks + " respectively"));
                    String errorMessage = s_gMsgBundle.getMessage("11072", true, (Object[])new String[]{failedNetworkNames, ipAddresses, subnets, subnetMasks, string});
                    ErrorDescription errorDescription = new ErrorDescription(errorMessage);
                    this.m_resultSet.addErrorDescription(errorDescription);
                }
                VerificationUtil.traceAndLog("Checking for non-infiniband type on private networks failed. Some interfaces have non-infiniband type on the following nodes " + VerificationUtil.strArr2List(failedNodeNetworkDetails.keySet().toArray(new String[0])));
                this.m_resultSet.addResult(failedNodeNetworkDetails.keySet().toArray(new String[0]), 3);
                retVal = false;
            } else {
                VerificationUtil.traceAndLog("Checking for non-infiniband type on private networks passed.  None of the private networks have non infiniband type");
                retVal = true;
            }
        }
        return retVal;
    }

    private boolean performMTUConsistencyCheck() {
        boolean retVal = true;
        HashSet<NetworkInfo> allPrivateNetworks = new HashSet<NetworkInfo>();
        HashSet<NetworkInfo> allNonPrivateNetworks = new HashSet<NetworkInfo>();
        HashMap<String, Set<NetworkInfo>> nodeNetworksMap = new HashMap();
        HashMap<String, Set<NetworkInfo>> subnetNetworksMap = new HashMap();
        if (NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMapForUserProvidedNetworks)) {
            nodeNetworksMap = this.m_nodeNetworksMapForUserProvidedNetworks;
            subnetNetworksMap = this.m_subnetNetworksMapForUserProvidedNetworks;
        } else {
            nodeNetworksMap = this.m_globalNodeNetworksMap;
            subnetNetworksMap = this.m_globalSubnetNetworksMap;
        }
        if (!NetworkUtility.isNetworksMapGood(nodeNetworksMap)) {
            return false;
        }
        Collection<Subnet> subnetsCollection = Subnet.classifyToSubnets(subnetNetworksMap);
        ArrayList<Subnet> subnets = new ArrayList<Subnet>(subnetsCollection);
        for (Subnet subnet : subnets) {
            boolean found = false;
            boolean isPrivate = false;
            String strSubnet = subnet.getSubnet();
            if (this.m_subnetProvidedByUser) {
                for (NetworkInfo network : this.m_networksToConsider) {
                    if (!network.getSubnetAsString().equals(strSubnet)) continue;
                    found = true;
                    isPrivate = NetworkUtility.isSameType(network.getNetworkType(), NetworkConstants.NetworkType.PRIVATE.getValue());
                    break;
                }
                if (!found) continue;
                if (isPrivate) {
                    allPrivateNetworks.addAll(subnet.getNetworks());
                    continue;
                }
                allNonPrivateNetworks.addAll(subnet.getNetworks());
                continue;
            }
            allNonPrivateNetworks.addAll(subnet.getNetworks());
        }
        if (NetworkUtility.isNetworksSetGood(allPrivateNetworks)) {
            Trace.out((String)"Performing mtu consistancy check for all cluster interconnect interfaces");
            retVal &= this.reportMtuMismatchAcrossPrivateNetworks(allPrivateNetworks);
        }
        if (NetworkUtility.isNetworksSetGood(allNonPrivateNetworks)) {
            Trace.out((String)"Performing mtu consistancy check for subnets");
            retVal &= this.reportMtuMismatchAcrossSubnets(allNonPrivateNetworks);
        }
        return retVal;
    }

    private boolean reportMtuMismatchAcrossPrivateNetworks(Set<NetworkInfo> allPrivateNetworks) {
        boolean retVal = true;
        HashMap mtuNetworkMap = new HashMap();
        HashMap<String, Set<NetworkInfo>> subnetNetworkMap = NetworkDataDiscovery.getSubnetNetworksMap(allPrivateNetworks);
        if (ReportUtil.isVerbose()) {
            this.reportNetworkMTUDetails(allPrivateNetworks, true);
        }
        for (NetworkInfo network : allPrivateNetworks) {
            int mtuValue = network.getMTU();
            Set<NetworkInfo> networksValues = new HashSet<NetworkInfo>();
            if (mtuNetworkMap.containsKey(mtuValue)) {
                networksValues = (Set)mtuNetworkMap.get(mtuValue);
            }
            networksValues.add(network);
            mtuNetworkMap.put(mtuValue, networksValues);
        }
        if (mtuNetworkMap.size() > 1) {
            int highestNetworksWithGivenMTUValue = 0;
            HashSet allNetworks = new HashSet();
            for (Object mtuValue : mtuNetworkMap.keySet()) {
                Trace.out((String)("MTU Value: " + mtuValue + " its size " + ((Set)mtuNetworkMap.get(mtuValue)).size()));
            }
            int commonMtu = 0;
            for (Integer mtuValue : mtuNetworkMap.keySet()) {
                allNetworks.addAll((Collection)mtuNetworkMap.get(mtuValue));
                if (highestNetworksWithGivenMTUValue >= ((Set)mtuNetworkMap.get(mtuValue)).size()) continue;
                commonMtu = mtuValue;
                highestNetworksWithGivenMTUValue = ((Set)mtuNetworkMap.get(mtuValue)).size();
                Trace.out((String)("MTU Value " + mtuValue + " seems to be the common value " + "in most of the networks "));
            }
            if (NetworkUtility.isNetworksSetGood(allPrivateNetworks)) {
                HashMap<Object, Object> failedNodeNetworkDetails = new HashMap();
                failedNodeNetworkDetails = NetworkUtility.getFailedNodeNetworkDetailsMap(allPrivateNetworks);
                if (!failedNodeNetworkDetails.isEmpty()) {
                    Set<Object> failedNodes = failedNodeNetworkDetails.keySet();
                    Trace.out((String)("One or more private interfaces on the following nodes have different MTU value " + VerificationUtil.strArr2List(failedNodes.toArray(new String[0]))));
                    for (String string : failedNodeNetworkDetails.keySet()) {
                        String failedNetworkNames = VerificationUtil.strArr2List(NetworkUtility.getNetworkNamesFromFailedNodeNetworkDetails((List)failedNodeNetworkDetails.get(string)));
                        String subnets = VerificationUtil.strArr2List(NetworkUtility.getSubnetsFromFailedNodeNetworkDetails((List)failedNodeNetworkDetails.get(string)));
                        String mtuValues = VerificationUtil.strArr2List(NetworkUtility.getMtuValuesFromFailedNodeNetworkDetails((List)failedNodeNetworkDetails.get(string)));
                        Trace.out((String)("Node " + string + " has different MTU values " + "on the following private networks " + failedNetworkNames + " with subnet Ids " + subnets + " and MTU values " + mtuValues + " respectively"));
                        String errorMessage = s_gMsgBundle.getMessage("11061", true, (Object[])new String[]{failedNetworkNames, subnets, mtuValues, string, String.valueOf(commonMtu)});
                        ErrorDescription errorDescription = new ErrorDescription(errorMessage);
                        ReportUtil.printError(errorDescription.getErrorMessage());
                        this.m_resultSet.addErrorDescription(errorDescription);
                    }
                    VerificationUtil.traceAndLog("Checking for same MTU values on private networks failed. There is no common MTU across the networks on the following nodes " + VerificationUtil.strArr2List(failedNodeNetworkDetails.keySet().toArray(new String[0])));
                    this.m_resultSet.addResult(failedNodeNetworkDetails.keySet().toArray(new String[0]), 3);
                    ReportUtil.printResult(s_gMsgBundle.getMessage("11085", false, (Object[])new String[]{VerificationUtil.strList2List(new ArrayList<String>(subnetNetworkMap.keySet()))}));
                    retVal = false;
                }
            }
        } else {
            VerificationUtil.traceAndLog("Checking for same MTU values on private networks passed. There is a common MTU across the networks on the all the nodes ");
            retVal = true;
            ReportUtil.printResult(s_gMsgBundle.getMessage("11084", false, (Object[])new String[]{VerificationUtil.strList2List(new ArrayList<String>(subnetNetworkMap.keySet()))}));
        }
        return retVal;
    }

    private boolean reportMtuMismatchAcrossSubnets(Set<NetworkInfo> allNonPrivateNetworks) {
        boolean retVal = true;
        HashMap<String, Set<NetworkInfo>> subnetNetworksMap = NetworkDataDiscovery.getSubnetNetworksMap(allNonPrivateNetworks);
        if (ReportUtil.isVerbose()) {
            this.reportNetworkMTUDetails(allNonPrivateNetworks, false);
        }
        for (String subnet : subnetNetworksMap.keySet()) {
            HashMap mtuNetworkMap = new HashMap();
            Trace.out((String)("Subnet being checked for MTU is: " + subnet));
            Set<NetworkInfo> networksWithinSubnet = subnetNetworksMap.get(subnet);
            for (NetworkInfo network : networksWithinSubnet) {
                int mtuValue = network.getMTU();
                Trace.out((String)("MTU on " + network.getInterfaceName() + " is " + mtuValue));
                Set<NetworkInfo> networksValues = new HashSet<NetworkInfo>();
                if (mtuNetworkMap.containsKey(mtuValue)) {
                    networksValues = (Set)mtuNetworkMap.get(mtuValue);
                }
                networksValues.add(network);
                mtuNetworkMap.put(mtuValue, networksValues);
            }
            int commonMtu = 0;
            if (mtuNetworkMap.size() > 1) {
                int highestNetworksWithGivenMTUValue = 0;
                HashSet allNetworks = new HashSet();
                for (Integer n : mtuNetworkMap.keySet()) {
                    allNetworks.addAll((Collection)mtuNetworkMap.get(n));
                    if (highestNetworksWithGivenMTUValue >= ((Set)mtuNetworkMap.get(n)).size()) continue;
                    commonMtu = n;
                    highestNetworksWithGivenMTUValue = ((Set)mtuNetworkMap.get(n)).size();
                    Trace.out((String)("MTU Value " + n + " seems to be the most common value " + " within the subnet " + subnet));
                }
            }
            if (mtuNetworkMap.size() > 1 && networksWithinSubnet.size() > 1) {
                HashMap<Object, Object> failedNodeNetworkDetails = new HashMap();
                failedNodeNetworkDetails = NetworkUtility.getFailedNodeNetworkDetailsMap(networksWithinSubnet);
                if (!failedNodeNetworkDetails.isEmpty()) {
                    Set<Object> failedNodes = failedNodeNetworkDetails.keySet();
                    Trace.out((String)("One or more interfaces on the following nodes have different MTU value within the subnet " + subnet + " : " + VerificationUtil.strArr2List(failedNodes.toArray(new String[0]))));
                    for (String string : failedNodeNetworkDetails.keySet()) {
                        String failedNetworkNames = VerificationUtil.strArr2List(NetworkUtility.getNetworkNamesFromFailedNodeNetworkDetails((List)failedNodeNetworkDetails.get(string)));
                        String subnets = VerificationUtil.strArr2List(NetworkUtility.getSubnetsFromFailedNodeNetworkDetails((List)failedNodeNetworkDetails.get(string)));
                        String mtuValues = VerificationUtil.strArr2List(NetworkUtility.getMtuValuesFromFailedNodeNetworkDetails((List)failedNodeNetworkDetails.get(string)));
                        Trace.out((String)("Node " + string + " has different MTU values " + "on the following networks " + failedNetworkNames + " for the subnet " + subnet + " and MTU values " + mtuValues + " respectively"));
                        String errorMessage = s_gMsgBundle.getMessage("11077", true, (Object[])new String[]{failedNetworkNames, subnets, mtuValues, string, String.valueOf(commonMtu)});
                        ErrorDescription errorDescription = new ErrorDescription(errorMessage);
                        this.m_resultSet.addErrorDescription(errorDescription);
                    }
                    VerificationUtil.traceAndLog("Checking for same MTU values on non-private networks failed. There is no common MTU across the networks on the following nodes " + VerificationUtil.strArr2List(failedNodeNetworkDetails.keySet().toArray(new String[0])));
                    this.m_resultSet.addResult(failedNodeNetworkDetails.keySet().toArray(new String[0]), 4);
                    retVal = false;
                }
                ReportUtil.printResult(s_gMsgBundle.getMessage("11085", false, (Object[])new String[]{subnet}));
                retVal = false;
                continue;
            }
            VerificationUtil.traceAndLog("Checking for same MTU values on non-private networks passed. There is a common MTU across the same subnets on all the nodes ");
            ReportUtil.printResult(s_gMsgBundle.getMessage("11084", false, (Object[])new String[]{subnet}));
            retVal = true;
        }
        return retVal;
    }

    private void reportVIPOkInterfaces(Subnet subnet) {
        ReportUtil.sureprintln("");
        ReportUtil.sureprintln(s_msgBundle.getMessage("4104", false, (Object[])new String[]{subnet.getSubnet()}));
        this.reportInterfacesInSubnet(subnet);
    }

    private void reportPrivateOkInterfaces(Subnet subnet) {
        ReportUtil.sureprintln("");
        ReportUtil.sureprintln(s_msgBundle.getMessage("4105", false, (Object[])new String[]{subnet.getSubnet()}));
        this.reportInterfacesInSubnet(subnet);
    }

    private void reportInterfacesInSubnet(Subnet subnet) {
        for (String node : subnet.getNodes()) {
            ReportUtil.sureprint(node);
            for (NetworkInfo network : subnet.getNetworksByNode(node)) {
                ReportUtil.sureprint(" " + network.getInterfaceName() + ":" + network.getIPAsString());
            }
            ReportUtil.sureprintln("");
        }
    }

    private void reportNodeReach(String srcNode, String[] nodeList, boolean[] nodeConArray, String[] nodeErrorArray, boolean succ) {
        ReportUtil.println(LSEP + s_msgBundle.getMessage("4081", false, (Object[])new String[]{srcNode}));
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8004", false), s_msgBundle.getMessage("8005", false));
        for (int i = 0; i < nodeList.length; ++i) {
            ReportUtil.writeRecord(nodeList[i], this.bool2YesNo(nodeConArray[i]));
        }
        if (succ) {
            ReportUtil.printResult(s_msgBundle.getMessage("4082", false, (Object[])new String[]{srcNode}));
        } else {
            StringBuilder printNodeErr = new StringBuilder();
            for (int i = 0; i < nodeErrorArray.length; ++i) {
                if (nodeErrorArray[i] == null) continue;
                printNodeErr.append(nodeErrorArray[i] + LSEP);
            }
            if (printNodeErr.toString().length() > 0) {
                ReportUtil.sureprintln(printNodeErr.toString());
            }
            ReportUtil.printResult(s_msgBundle.getMessage("4083", true, (Object[])new String[]{srcNode}));
            if (printNodeErr.toString().length() == 0) {
                ReportUtil.printErrorNodes(this.m_resultSet);
            }
        }
    }

    private void reportBadIP(ConMatrix matrix) {
        String[] IPList = matrix.getIPList();
        String[] nodeList = matrix.getNodeList();
        String[] interfaceList = matrix.getInterfaceList();
        boolean[][] conTable = matrix.getMatrixForOutput();
        for (int i = 0; i < nodeList.length; ++i) {
            String msg;
            if (conTable[i][i]) continue;
            if (interfaceList != null) {
                msg = s_msgBundle.getMessage("4084", false, (Object[])new String[]{interfaceList[i] + " : " + IPList[i] + " [" + matrix.getKey() + "] ", nodeList[i]});
            } else {
                Trace.out((String)("Interface unavailable: " + matrix.toString()));
                msg = s_msgBundle.getMessage("4084", false, (Object[])new String[]{"<unavailable> : " + IPList[i] + " [" + matrix.getKey() + "] ", nodeList[i]});
            }
            ReportUtil.printWarning(msg);
            this.m_resultSet.addResult(nodeList[i], 4);
            Trace.out((String)("BadIP: " + msg));
        }
    }

    private void reportMatrix(ConMatrix matrix, boolean isRDSMatrix) {
        String[] IPList = matrix.getIPList();
        String[] nodeList = matrix.getNodeList();
        String[] interfaceList = matrix.getInterfaceList();
        boolean[][] conTable = matrix.getMatrixForOutput();
        boolean headerPrinted = false;
        this.reportBadIP(matrix);
        if (nodeList.length <= 0) {
            return;
        }
        Trace.out((String)(" isRDSMatrix :: " + isRDSMatrix));
        for (int i = 0; i < nodeList.length; ++i) {
            for (int j = i; j < nodeList.length; ++j) {
                if (i == j) continue;
                if (ReportUtil.isVerbose()) {
                    if (!headerPrinted) {
                        ReportUtil.writeColHeaders_2eq(s_msgBundle.getMessage("8006", false), s_msgBundle.getMessage("8007", false), s_msgBundle.getMessage("8008", false));
                        headerPrinted = true;
                    }
                    if (interfaceList != null) {
                        ReportUtil.writeRecord_2eq(nodeList[i] + "[" + interfaceList[i] + ":" + IPList[i] + "]", nodeList[j] + "[" + interfaceList[j] + ":" + IPList[j] + "]", this.bool2YesNo(conTable[i][j]));
                    } else {
                        ReportUtil.writeRecord_2eq(nodeList[i] + "[" + IPList[i] + "]", nodeList[j] + "[" + IPList[j] + "]", this.bool2YesNo(conTable[i][j]));
                    }
                }
                if (!conTable[i][j]) {
                    String errMsg = null;
                    errMsg = interfaceList != null ? s_gMsgBundle.getMessage(isRDSMatrix ? "11893" : "11891", true, (Object[])new String[]{interfaceList[i], IPList[i], nodeList[i], interfaceList[j], IPList[j], nodeList[j], matrix.getKey()}) : s_gMsgBundle.getMessage(isRDSMatrix ? "11894" : "11892", true, (Object[])new String[]{IPList[i], nodeList[i], IPList[j], nodeList[j], matrix.getKey()});
                    ReportUtil.printError(errMsg);
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                    this.m_resultSet.addResult(nodeList[i], 4);
                    Trace.out((String)("Failed connectivity: " + errMsg));
                    continue;
                }
                this.m_resultSet.addResult(nodeList[i], 1);
                Trace.out((String)("Passed connectivity: " + nodeList[i]));
            }
        }
    }

    private void reportTCPMatrix(TCPMatrix matrix) {
        String[] ipList = matrix.getIPAddresses();
        String[] nodeList = matrix.getNodes();
        Result[] rsSrvList = matrix.getTCPServerResuls();
        Result[][] rsTCPConStatus = matrix.getTCPConMatrix();
        boolean headerPrinted = false;
        String srcNode = null;
        String destNode = null;
        for (int i = 0; i < ipList.length; ++i) {
            if (!headerPrinted && ReportUtil.getOldFormat()) {
                ReportUtil.writeColHeaders_2eq(s_msgBundle.getMessage("8006", false), s_msgBundle.getMessage("8007", false), s_msgBundle.getMessage("8008", false));
                headerPrinted = true;
            }
            destNode = nodeList[i] + " : " + ipList[i];
            if (rsSrvList[i].getStatus() != 1) {
                for (int j = 0; j < ipList.length; ++j) {
                    srcNode = nodeList[j] + " : " + ipList[j];
                    if (!ReportUtil.getOldFormat()) continue;
                    ReportUtil.writeRecord_2eq(srcNode, destNode, ReportUtil.FAILED);
                }
                String errMsg = null;
                for (VerificationError vErr : rsSrvList[i].getErrors()) {
                    if (errMsg == null) {
                        errMsg = vErr.getErrorMessage();
                        continue;
                    }
                    errMsg = errMsg + LSEP + vErr.getErrorMessage();
                }
                Trace.out((String)("TCP server on " + destNode + " is failed with error " + errMsg));
                ReportUtil.printError(errMsg);
                this.m_resultSet.addResult(nodeList[i], 2);
                this.m_resultSet.addErrorDescription(nodeList[i], new ErrorDescription(errMsg));
                continue;
            }
            boolean exectaskError = false;
            for (int j = 0; j < ipList.length; ++j) {
                String errMsg;
                srcNode = nodeList[j] + " : " + ipList[j];
                if (rsTCPConStatus[j][i] == null) {
                    Trace.out((String)("TCP connectivity from " + srcNode + " to " + destNode + " does not exists"));
                    exectaskError = true;
                    continue;
                }
                if (rsTCPConStatus[j][i].getStatus() == 1) {
                    if (!ReportUtil.getOldFormat()) continue;
                    ReportUtil.writeRecord_2eq(srcNode, destNode, ReportUtil.PASSED);
                    continue;
                }
                if (rsTCPConStatus[j][i].getStatus() == 3 || rsTCPConStatus[j][i].getStatus() == 2) {
                    if (ReportUtil.getOldFormat()) {
                        ReportUtil.writeRecord_2eq(srcNode, destNode, ReportUtil.FAILED);
                    }
                    errMsg = null;
                    errMsg = s_gMsgBundle.getMessage("11067", true, (Object[])new String[]{nodeList[j], ipList[j], nodeList[i], ipList[i]});
                    Trace.out((String)("TCP connectivity from " + srcNode + " to " + destNode + " does not exists"));
                    for (VerificationError vErr : rsTCPConStatus[j][i].getErrors()) {
                        if (errMsg == null) {
                            errMsg = vErr.getErrorMessage();
                            continue;
                        }
                        errMsg = errMsg + LSEP + vErr.getErrorMessage();
                    }
                    ReportUtil.printError(errMsg);
                    this.m_resultSet.addResult(nodeList[j], 3);
                    this.m_resultSet.addErrorDescription(nodeList[j], new ErrorDescription(errMsg));
                    continue;
                }
                if (ReportUtil.getOldFormat()) {
                    ReportUtil.writeRecord_2eq(srcNode, destNode, ReportUtil.FAILED);
                }
                errMsg = null;
                for (VerificationError vErr : rsTCPConStatus[j][i].getErrors()) {
                    if (errMsg == null) {
                        errMsg = vErr.getErrorMessage();
                        continue;
                    }
                    errMsg = errMsg + LSEP + vErr.getErrorMessage();
                }
                Trace.out((String)("exectask -chkTCPclientEx is failed on node " + nodeList[j] + " with IP " + ipList[j]));
                ReportUtil.printError(errMsg);
                this.m_resultSet.addResult(nodeList[j], 3);
                this.m_resultSet.addErrorDescription(nodeList[j], new ErrorDescription(errMsg));
            }
            if (!exectaskError) continue;
            Trace.out((String)"Check exectask logs for more information on command execution status for failed IP addresses.");
        }
    }

    private String bool2YesNo(boolean booleanValue) {
        if (booleanValue) {
            return ReportUtil.YES;
        }
        return ReportUtil.NO;
    }

    private void reportNodeCon(ConMatrix matrix) {
        ReportUtil.println(LSEP + s_msgBundle.getMessage("4091", false, (Object[])new String[]{matrix.getKey()}));
        this.reportMatrix(matrix, false);
        String[] nodeList = matrix.getUniqueNodeList();
        if (matrix.getStatus() == 1) {
            ReportUtil.printResult(s_msgBundle.getMessage("4092", false, (Object[])new String[]{matrix.getKey(), VerificationUtil.strArr2List(nodeList)}));
        } else {
            ErrorDescription errDesc = new ErrorDescription(s_gMsgBundle.getMessage("11078", true, (Object[])new String[]{matrix.getKey()}));
            this.m_resultSet.addResult(m_localNode, 4);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.printResult(errDesc.getErrorMessage());
        }
    }

    private void reportTCPCon(String subnet, TCPMatrix matrix) {
        ReportUtil.println(LSEP + LSEP + s_msgBundle.getMessage("4120", false, (Object[])new String[]{subnet}));
        Trace.out((String)("Results - " + matrix.toString()));
        this.reportTCPMatrix(matrix);
        if (matrix.isAllSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("4121", false, (Object[])new String[]{subnet}) + LSEP);
        } else {
            ReportUtil.printResult(s_msgBundle.getMessage("4122", false, (Object[])new String[]{subnet}) + LSEP);
        }
    }

    private void reportRDSCon(String subnet, ConMatrix matrix) {
        ReportUtil.println(LSEP + LSEP + s_gMsgBundle.getMessage("11896", false, (Object[])new String[]{subnet}));
        Trace.out((String)("Results - " + matrix.toString()));
        this.reportMatrix(matrix, true);
        if (matrix.getStatus() == 1) {
            ReportUtil.printResult(s_gMsgBundle.getMessage("11897", false, (Object[])new String[]{subnet}) + LSEP);
        } else {
            ReportUtil.printResult(s_gMsgBundle.getMessage("11898", false, (Object[])new String[]{subnet}) + LSEP);
        }
    }

    public void reportNetworkInfo(HashMap<String, Set<NetworkInfo>> nodeNetworksMap) {
        for (String node : nodeNetworksMap.keySet()) {
            boolean headerPrinted = false;
            if (!headerPrinted) {
                headerPrinted = true;
                ReportUtil.println(LSEP + LSEP + s_msgBundle.getMessage("4094", false, (Object[])new String[]{node}));
                if (ReportUtil.isVerbose()) {
                    ReportUtil.reportPrintln(LSEP + s_msgBundle.getMessage("4094", false, (Object[])new String[]{node}));
                }
            }
            if (!nodeNetworksMap.isEmpty()) {
                ReportUtil.writeColHeaders(s_msgBundle.getMessage("8009", false), s_msgBundle.getMessage("8010", false), s_msgBundle.getMessage("8011", false), s_msgBundle.getMessage("8050", false), s_msgBundle.getMessage("8051", false), s_msgBundle.getMessage("8049", false), s_msgBundle.getMessage("8052", false));
            }
            for (NetworkInfo network : nodeNetworksMap.get(node)) {
                ReportUtil.writeRecord(network.getInterfaceName(), network.getIPAsString(), network.getSubnetAsString(), network.getSubnetGatewayAsString(), network.getDefaultGatewayAsString(), network.getMacAddress(), String.valueOf(network.getMTU()));
            }
        }
    }

    @Override
    public String getDefaultElementName() {
        if (this.m_taskType == 0) {
            return s_msgBundle.getMessage("4402", false);
        }
        return s_msgBundle.getMessage("4401", false);
    }

    @Override
    public String getTaskID() {
        if (this.m_taskType == 0) {
            return "NODE_CONN";
        }
        return "NODE_REACH";
    }

    @Override
    public String getDefaultDescription() {
        if (this.m_taskType == 0) {
            if (this.m_networksToConsider != null) {
                return s_msgBundle.getMessage("4534", false, (Object[])new String[]{VerificationUtil.strList2List(NetworkDataDiscovery.getClusterNetworkSubnets(this.m_networksToConsider))});
            }
            return s_msgBundle.getMessage("4452", false);
        }
        return s_msgBundle.getMessage("4451", false);
    }

    public String toString() {
        StringBuffer networkDetails = new StringBuffer();
        HashSet<String> networkNames = new HashSet<String>();
        networkDetails.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        if (NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMapForUserProvidedNetworks)) {
            for (String node : this.m_nodeNetworksMapForUserProvidedNetworks.keySet()) {
                networkNames.addAll(NetworkDataDiscovery.getClusterNetworkNames(this.m_nodeNetworksMapForUserProvidedNetworks.get(node)));
            }
        } else if (NetworkUtility.isNetworksMapGood(this.m_globalNodeNetworksMap)) {
            for (String node : this.m_globalNodeNetworksMap.keySet()) {
                networkNames.addAll(NetworkDataDiscovery.getClusterNetworkNames(this.m_globalNodeNetworksMap.get(node)));
            }
        }
        networkDetails.append(LSEP + "InterfaceList: " + VerificationUtil.strList2List(new ArrayList<String>(networkNames)));
        networkDetails.append(LSEP + "IPAddressList: " + VerificationUtil.strArr2List(this.m_IPAddrList));
        networkDetails.append(LSEP + "TaskType: " + (this.m_taskType == 0 ? "NODECON" : NODEREACH_KEY));
        networkDetails.append(LSEP + "SourceNode: " + this.m_srcNode);
        return networkDetails.toString();
    }

    public void getNodeConnAPIData(List<Subnet> subnetList) {
        ArrayList<SubnetAndInterfaceInfoImpl> allSubAndInterfaceInfo = new ArrayList<SubnetAndInterfaceInfoImpl>(1);
        ArrayList<SubnetAndInterfaceInfoImpl> vipSubAndInterfaceInfo = new ArrayList<SubnetAndInterfaceInfoImpl>(1);
        ArrayList<SubnetAndInterfaceInfoImpl> privateSubAndInterfaceInfo = new ArrayList<SubnetAndInterfaceInfoImpl>(1);
        Trace.out((String)("subnetList.size(): " + subnetList.size() + LSEP));
        for (int j = 0; j < subnetList.size(); ++j) {
            String action;
            String cause;
            String errMsg;
            InetAddress inetAddr = null;
            InetAddress inetAddrSubnet = null;
            InetAddress inetAddrSubnet2 = null;
            NetworkInfo inf2 = null;
            int netType = 4;
            ArrayList<NetworkInterfaceInfoImpl> interfaceInfo = new ArrayList<NetworkInterfaceInfoImpl>();
            Subnet subnet = subnetList.get(j);
            String subnetName = subnet.getSubnet();
            Trace.out((String)("Subnet: #" + j + " Name: " + subnetName));
            try {
                inetAddrSubnet = InetAddress.getByName(subnetName);
            }
            catch (UnknownHostException uhe) {
                Trace.out((String)("Subnet: Unknown Host Exception... " + LSEP));
                errMsg = s_msgBundle.getMessage("6013", false);
                cause = s_msgBundle.getMessage("6014", false, (Object[])new String[]{subnetName});
                action = s_msgBundle.getMessage("6016", false, (Object[])new String[]{subnetName});
                Trace.out((String)errMsg);
                this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg, cause, action));
                this.m_resultSet.addResult(this.m_nodeList, 2);
            }
            for (NetworkInfo inf2 : subnet.getNetworks()) {
                try {
                    inetAddrSubnet2 = InetAddress.getByName(inf2.getSubnetMaskAsString());
                }
                catch (UnknownHostException uhe) {
                    Trace.out((String)("Mask: Unknown Host Exception... " + LSEP));
                    errMsg = s_msgBundle.getMessage("6013", false);
                    cause = s_msgBundle.getMessage("6015", false, (Object[])new String[]{inf2.getSubnetMaskAsString()});
                    action = s_msgBundle.getMessage("6016", false, (Object[])new String[]{subnetName});
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg, cause, action));
                    Trace.out((String)errMsg);
                    this.m_resultSet.addResult(m_localNode, 4);
                }
                Trace.out((String)("Interface Name: " + inf2.getInterfaceName() + " Type: " + inf2.getNetworkType()));
                netType = inf2.getNetworkType();
                try {
                    inetAddr = InetAddress.getByName(inf2.getIPAsString());
                }
                catch (UnknownHostException uhe) {
                    Trace.out((String)("IP: Unknown Host Exception... " + LSEP));
                    errMsg = s_msgBundle.getMessage("6013", false);
                    cause = s_msgBundle.getMessage("6017", false, (Object[])new String[]{inf2.getIPAsString()});
                    action = s_msgBundle.getMessage("6012", false, (Object[])new String[]{inf2.getNodeName()});
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg, cause, action));
                    Trace.out((String)errMsg);
                    this.m_resultSet.addResult(m_localNode, 4);
                }
                NetworkInterfaceInfoImpl newInterface = new NetworkInterfaceInfoImpl(inf2.getInterfaceName(), inetAddr, inf2.getNodeName());
                interfaceInfo.add(newInterface);
            }
            Trace.out((String)("Number of Interface's: " + interfaceInfo.size()));
            SubnetAndInterfaceInfoImpl newSubnet = new SubnetAndInterfaceInfoImpl(inetAddrSubnet.getAddress(), inetAddrSubnet2.getAddress(), netType, interfaceInfo);
            allSubAndInterfaceInfo.add(newSubnet);
            if (newSubnet.getSubnetType() == 1) {
                privateSubAndInterfaceInfo.add(newSubnet);
                continue;
            }
            vipSubAndInterfaceInfo.add(newSubnet);
        }
        this.m_nodeConResSetImpl.setVIPInterfaces(vipSubAndInterfaceInfo);
        this.m_nodeConResSetImpl.setPrivateInterfaces(privateSubAndInterfaceInfo);
        this.m_nodeConResSetImpl.setAvailableSubnets(allSubAndInterfaceInfo);
        if (allSubAndInterfaceInfo == null) {
            ErrorDescription errDesc = new ErrorDescription("6005", s_msgBundle);
            Trace.out((String)("No subnet or interface info. " + LSEP + errDesc.getErrorMessage()));
            this.m_resultSet.addResult(m_localNode, 4);
            this.m_resultSet.addErrorDescription(errDesc);
        } else if (vipSubAndInterfaceInfo == null) {
            ErrorDescription errDesc = new ErrorDescription("4101", s_msgBundle);
            Trace.out((String)("No VIP subnet or interface info. " + LSEP + errDesc.getErrorMessage()));
            this.m_resultSet.addResult(m_localNode, 4);
            this.m_resultSet.addErrorDescription(errDesc);
        } else if (privateSubAndInterfaceInfo == null) {
            ErrorDescription errDesc = new ErrorDescription("4102", s_msgBundle);
            Trace.out((String)("No private subnet or interface info. " + LSEP + errDesc.getErrorMessage()));
            this.m_resultSet.addResult(m_localNode, 4);
            this.m_resultSet.addErrorDescription(errDesc);
        }
    }

    private boolean isRolling() {
        String isROLLING_value = CVUVariables.getValue(CVUVariableConstants.ISROLLING);
        return isROLLING_value != null && isROLLING_value.equalsIgnoreCase("true");
    }

    private boolean performPrivateIPSubnetCheckForUpgrade() {
        Trace.out((String)"Performing check to verify if private IP addresses retrieved using OLSNODES fall into the same private subnet of an existing configuration");
        boolean result = true;
        List<OIFCFGResult> cluIfs = null;
        HashMap nodePrivateHostMap = null;
        ClusterwareInfo cluInfo = new ClusterwareInfo();
        String crsHome = VerificationUtil.getCRSHome();
        String oifcfgLoc = crsHome + FSEP + "bin";
        try {
            OIFCFGUtil oifcfgUtil = new OIFCFGUtil(oifcfgLoc);
            List oifcfgInterfaceList = cluInfo.listInterfaces(this.m_nodeList[0], oifcfgLoc, false);
            String strCrsVer = VerificationUtil.getCRSReleaseVersion(crsHome, false);
            Version crsVer = VerificationUtil.getVersionObject(strCrsVer);
            List tmpOifcfgResultList = cluInfo.listClusterInterfaces(oifcfgLoc, crsVer);
            cluIfs = VerificationUtil.resolveSubNetMask(tmpOifcfgResultList, oifcfgInterfaceList, oifcfgUtil);
            nodePrivateHostMap = cluInfo.getClusterPrivateHostnames(crsHome);
        }
        catch (InstallException ie) {
            Trace.out((String)("Caught InstallException, Could not run command tool. Error is " + ie.getMessage()));
            this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(s_gMsgBundle.getMessage("1512", true) + VerificationConstants.LINE_SEPARATOR + ie.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        catch (CmdToolUtilException e) {
            Trace.out((String)("Caught InstallException, Could not run command tool. Error is " + e.getMessage()));
            this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(s_gMsgBundle.getMessage("1512", true) + VerificationUtil.LINE_SEPARATOR + e.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        catch (ConfigurationException ce) {
            Trace.out((String)("Caught ConfigurationException while getting crsVer. Error is " + ce.getMessage()));
            this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(s_gMsgBundle.getMessage("1512", true) + VerificationConstants.LINE_SEPARATOR + ce.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        Hashtable<InetAddress, InetAddress> privateSubnetAndMasktable = new Hashtable<InetAddress, InetAddress>();
        Trace.out((String)("Retrieved total " + cluIfs.size() + " if objects"));
        for (OIFCFGResult ifObj : cluIfs) {
            boolean isPrivate = ifObj.getInterfaceType().toLowerCase().contains("cluster_interconnect");
            boolean isGlobal = ifObj.getNodeScope().equalsIgnoreCase("global");
            if (!isPrivate || !isGlobal) continue;
            Trace.out((String)("adding subnet:" + ifObj.getSubnet() + ", mask:" + ifObj.getSubnetMask() + " to privateSubnetAndMasktable"));
            privateSubnetAndMasktable.put(ifObj.getSubnet(), ifObj.getSubnetMask());
        }
        block7: for (String node : this.m_nodeList) {
            String privateHostForNode = null;
            if (nodePrivateHostMap.containsKey(node)) {
                privateHostForNode = (String)nodePrivateHostMap.get(node);
            }
            InetAddress[] nodePrivateIpArray = null;
            if (privateHostForNode != null && privateHostForNode.trim().length() > 0) {
                try {
                    nodePrivateIpArray = InetAddress.getAllByName(privateHostForNode);
                }
                catch (UnknownHostException e) {
                    Trace.out((String)("Failed to retrieve the IP address for node " + node + " with private host name " + privateHostForNode));
                    String errorMessage = s_gMsgBundle.getMessage("1171", true, (Object[])new String[]{privateHostForNode, node});
                    ResultSet.updateResultSetWithErrorDescription(errorMessage, this.m_resultSet, new String[]{node}, true, true);
                    result = false;
                    continue;
                }
            }
            if (privateSubnetAndMasktable.isEmpty() || nodePrivateIpArray == null || nodePrivateIpArray.length == 0 || privateHostForNode == null) {
                Trace.out((String)"Either the private IP, private subnet or private subnet mask is found to be null or empty");
                String errorMessage = s_gMsgBundle.getMessage("1513", true, (Object[])new String[]{node});
                ResultSet.updateResultSetWithErrorDescription(errorMessage, this.m_resultSet, new String[]{node}, true, true);
                result = false;
                continue;
            }
            for (InetAddress nodePrivateIp : nodePrivateIpArray) {
                if (!this.checkPrivateIPWithSubnet(nodePrivateIp, privateSubnetAndMasktable)) {
                    Trace.out((String)("The private hostname " + privateHostForNode + " with IP " + nodePrivateIp.toString() + " is not part of any private subnets currently configured "));
                    this.m_resultSet.addResult(node, 3);
                    String errMsg = s_gMsgBundle.getMessage("1170", true, (Object[])new String[]{privateHostForNode, nodePrivateIp.toString(), node});
                    this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                    ReportUtil.sureprintln(errMsg);
                    result = false;
                    continue block7;
                }
                Trace.out((String)("The private hostname " + privateHostForNode + " with IP " + nodePrivateIp.toString() + " is part of one of the configured private subnet "));
            }
        }
        return result;
    }

    private boolean checkPrivateIPWithSubnet(InetAddress privateIP, Hashtable<InetAddress, InetAddress> privateSubnetAndMaskTable) {
        int i = 0;
        boolean result = false;
        Set<InetAddress> privateSubnetSet = privateSubnetAndMaskTable.keySet();
        for (InetAddress subnet : privateSubnetSet) {
            byte[] netmaskBytes;
            InetAddress subnetMask = privateSubnetAndMaskTable.get(subnet);
            byte[] privateIpBytes = privateIP.getAddress();
            if (privateIpBytes.length != (netmaskBytes = subnetMask.getAddress()).length) {
                Trace.out((String)("privateIP(name=" + privateIP.getHostName() + ",IP=" + privateIP.getHostAddress() + ") and subnet=" + subnet + ",netmask=" + subnetMask + " are not same type of address family"));
                result = false;
            }
            byte[] privateIpSubnet = new byte[privateIpBytes.length];
            for (i = 0; i < privateIpBytes.length; ++i) {
                privateIpSubnet[i] = (byte)(privateIpBytes[i] & netmaskBytes[i]);
            }
            byte[] ifSubnet = subnet.getAddress();
            for (i = 0; i < privateIpSubnet.length && privateIpSubnet[i] == ifSubnet[i]; ++i) {
            }
            if (i != privateIpSubnet.length) continue;
            Trace.out((String)("privateIP(name=" + privateIP.getHostName() + ",IP=" + privateIP.getHostAddress() + ") and subnet=" + subnet + ",netmask=" + subnetMask + " are same type of address family and hence returning true"));
            return true;
        }
        return result;
    }

    private List<String> getInterfacesParticipatingInIPMPGroup(String node, String ifName) {
        if (!VerificationUtil.getCurrentOS().equalsIgnoreCase("Solaris") && !VerificationUtil.getCurrentOS().equalsIgnoreCase("SunOS")) {
            Trace.out((String)"Not a Solaris platform and hence no IPMP. Returning...");
            return null;
        }
        if (this.m_nodeWiseIPMPGroupsWithParticipatingNICList == null) {
            this.m_nodeWiseIPMPGroupsWithParticipatingNICList = new Hashtable();
            HashMap<String, List<NetworkInfo>> allIPMPGroupInterfaceMap = new VerifyNetwork().getIPMPConfigInfo(this.m_nodeList, this.m_resultSet);
            for (String nodeName : allIPMPGroupInterfaceMap.keySet()) {
                List<NetworkInfo> nodeIPMPConfigInfo = allIPMPGroupInterfaceMap.get(nodeName);
                for (NetworkInfo ipmpIfInfo : nodeIPMPConfigInfo) {
                    String group = ipmpIfInfo.getGroupName();
                    String nicName = ipmpIfInfo.getInterfaceName();
                    if (!this.m_nodeWiseIPMPGroupsWithParticipatingNICList.containsKey(nodeName)) {
                        HashMap ipmpGroupWithNics = new HashMap();
                        this.m_nodeWiseIPMPGroupsWithParticipatingNICList.put(nodeName, ipmpGroupWithNics);
                    }
                    if (!this.m_nodeWiseIPMPGroupsWithParticipatingNICList.get(nodeName).containsKey(group)) {
                        ArrayList<String> nicList = new ArrayList<String>();
                        nicList.add(nicName);
                        this.m_nodeWiseIPMPGroupsWithParticipatingNICList.get(nodeName).put(group, nicList);
                    }
                    if (this.m_nodeWiseIPMPGroupsWithParticipatingNICList.get(nodeName).get(group).contains(nicName)) continue;
                    this.m_nodeWiseIPMPGroupsWithParticipatingNICList.get(nodeName).get(group).add(nicName);
                }
            }
        }
        if (this.m_nodeWiseIPMPGroupsWithParticipatingNICList.containsKey(node) && !this.m_nodeWiseIPMPGroupsWithParticipatingNICList.get(node).isEmpty()) {
            for (String group : this.m_nodeWiseIPMPGroupsWithParticipatingNICList.get(node).keySet()) {
                if (!this.m_nodeWiseIPMPGroupsWithParticipatingNICList.get(node).get(group).contains(ifName)) continue;
                Trace.out((String)("The interface (" + ifName + ") is part of an IPMP group (" + group + ") on node (" + node + ") returning other participating " + "interfaces of this group as (" + this.m_nodeWiseIPMPGroupsWithParticipatingNICList.get(node).get(group) + ")"));
                return this.m_nodeWiseIPMPGroupsWithParticipatingNICList.get(node).get(group);
            }
        }
        return null;
    }

    private boolean checkForMonitorOptionInPrivateInterfaces() {
        boolean retVal = true;
        HashSet<String> failedNodeList = new HashSet<String>();
        HashSet<NetworkInfo> allFailedNetworks = new HashSet<NetworkInfo>();
        HashMap<String, Set<NetworkInfo>> nodeNetworksMapToUse = new HashMap();
        Trace.out((String)"Checking for Monitor option on private interfaces started");
        nodeNetworksMapToUse = NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMapForUserProvidedNetworks) ? this.m_nodeNetworksMapForUserProvidedNetworks : this.m_globalNodeNetworksMap;
        if (VerificationUtil.isCRSConfigured()) {
            Set<NetworkInfo> clusterNetworks = NetworkDataDiscovery.getClusterNetworks(m_localNode, this.m_resultSet);
            if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
                Trace.out((String)"Cluster networks fetched is null or empty");
                return false;
            }
            HashMap<String, Set<NetworkInfo>> matchingNodeNetworksMap = NetworkDataDiscovery.getMatchingNodeNetworksMapOnNodes(nodeNetworksMapToUse, clusterNetworks, this.m_nodeList);
            for (String string : matchingNodeNetworksMap.keySet()) {
                for (NetworkInfo network : matchingNodeNetworksMap.get(string)) {
                    if (!NetworkUtility.isSameType(network.getNetworkType(), NetworkConstants.NetworkType.PRIVATE.getValue()) || !network.getHardwareType().equalsIgnoreCase("InfiniBand")) continue;
                    Trace.out((String)("Private interface " + network.getInterfaceName() + " on the node " + network.getNodeName() + " with IP address " + network.getIPAsString() + " do not have MONITOR option set."));
                    failedNodeList.add(string);
                    allFailedNetworks.add(network);
                }
            }
        }
        if (allFailedNetworks.size() > 0) {
            HashMap<Object, Object> failedNodeNetworkDetails = new HashMap();
            failedNodeNetworkDetails = NetworkUtility.getFailedNodeNetworkDetailsMap(allFailedNetworks);
            if (!failedNodeNetworkDetails.isEmpty()) {
                Set<Object> failedNodes = failedNodeNetworkDetails.keySet();
                Trace.out((String)("One or more private interfaces on the following nodes do not have MONITOR option set " + failedNodes.toArray(new String[0])));
                for (String string : failedNodeNetworkDetails.keySet()) {
                    String failedNetworkNames = VerificationUtil.strArr2List(NetworkUtility.getNetworkNamesFromFailedNodeNetworkDetails((List)failedNodeNetworkDetails.get(string)));
                    String ipAddresses = VerificationUtil.strArr2List(NetworkUtility.getIPAddressesFromFailedNodeNetworkDetails((List)failedNodeNetworkDetails.get(string)));
                    String subnets = VerificationUtil.strArr2List(NetworkUtility.getSubnetsFromFailedNodeNetworkDetails((List)failedNodeNetworkDetails.get(string)));
                    String subnetMasks = VerificationUtil.strArr2List(NetworkUtility.getSubnetMasksFromFailedNodeNetworkDetails((List)failedNodeNetworkDetails.get(string)));
                    Trace.out((String)("Node " + string + " do not have MONITOR option set " + "on the following private networks " + failedNetworkNames + "with IP addresses " + ipAddresses + " and" + " subnet Ids " + subnets + " and subnet masks " + subnetMasks + " respectively"));
                    String errorMessage = s_gMsgBundle.getMessage("11074", true, (Object[])new String[]{failedNetworkNames, ipAddresses, subnets, subnetMasks, string});
                    ErrorDescription errorDescription = new ErrorDescription(errorMessage);
                    this.m_resultSet.addErrorDescription(errorDescription);
                }
                VerificationUtil.traceAndLog("Checking for Monitor option on private interfaces failed. Some private interfaces do not have MONITOR option set on the following nodes " + VerificationUtil.strArr2List(failedNodeNetworkDetails.keySet().toArray(new String[0])));
                this.m_resultSet.addResult(failedNodeNetworkDetails.keySet().toArray(new String[0]), 3);
                retVal = false;
            } else {
                VerificationUtil.traceAndLog("Checking for non-infiniband type on private networks passed.  None of the private networks have non infiniband type");
                retVal = true;
            }
        }
        return retVal;
    }

    private void updateNodeNetworksMapWithOnlyStatusUpNetworks() {
        this.m_globalNodeNetworksMap = NetworkDataDiscovery.getNetworksOnNodes(this.m_globalNodeNetworksMap, this.m_globalNodeNetworksMap.keySet().toArray(new String[0]), true);
        this.m_globalSubnetNetworksMap = NetworkDataDiscovery.getSubnetNetworksMap(this.m_globalNodeNetworksMap, this.m_resultSet);
        if (NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMapForUserProvidedNetworks)) {
            this.m_nodeNetworksMapForUserProvidedNetworks = NetworkDataDiscovery.getNetworksOnNodes(this.m_nodeNetworksMapForUserProvidedNetworks, this.m_nodeNetworksMapForUserProvidedNetworks.keySet().toArray(new String[0]), true);
            this.m_subnetNetworksMapForUserProvidedNetworks = NetworkDataDiscovery.getSubnetNetworksMap(this.m_nodeNetworksMapForUserProvidedNetworks, this.m_resultSet);
        }
    }

    private List<Subnet> getSpecifiedSubnetList(HashMap<String, Set<NetworkInfo>> subnetNetworksMap) {
        Collection<Subnet> subnetsCollection = Subnet.classifyToSubnets(subnetNetworksMap);
        ArrayList<Subnet> subnets = new ArrayList<Subnet>(subnetsCollection);
        ArrayList<Subnet> tmpSubnets = new ArrayList<Subnet>();
        if (this.m_subnetProvidedByUser) {
            List<String> subnetListFromUser = NetworkDataDiscovery.getClusterNetworkSubnets(this.m_networksToConsider);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("== subnetList from user: " + subnetListFromUser.toString()));
            }
            for (Subnet chkSubnet : subnets) {
                String strSubnet = chkSubnet.getSubnet();
                if (!subnetListFromUser.contains(strSubnet)) continue;
                Trace.out((String)("adding subnet: '" + strSubnet + "' to tmpSubnet list."));
                tmpSubnets.add(chkSubnet);
            }
            subnets = tmpSubnets;
        }
        return subnets;
    }

    private void logNetworksToBeConsideredDetails() {
        block12: {
            block11: {
                if (!this.m_subnetProvidedByUser && !this.m_interfaceProvidedByUser) break block11;
                if (NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMapForUserProvidedNetworks)) {
                    ReportUtil.sureprintln("Interface details on each node for which node connectivity is being verified");
                    ReportUtil.sureprintln(LSEP);
                    ReportUtil.surewriteColHeaders(s_msgBundle.getMessage("8009", false), s_msgBundle.getMessage("8010", false), s_msgBundle.getMessage("8011", false));
                    for (String node : this.m_nodeNetworksMapForUserProvidedNetworks.keySet()) {
                        ReportUtil.sureprintln("Node: " + node);
                        for (NetworkInfo network : this.m_nodeNetworksMapForUserProvidedNetworks.get(node)) {
                            ReportUtil.surewriteRecord(network.getInterfaceName(), network.getIPAsString(), network.getSubnetAsString());
                        }
                    }
                }
                if (!NetworkUtility.isNetworksMapGood(this.m_subnetNetworksMapForUserProvidedNetworks)) break block12;
                ReportUtil.sureprintln("Subnet Details on which node connectivity is being verified");
                ReportUtil.surewriteColHeaders(s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8009", false), s_msgBundle.getMessage("8010", false));
                for (String subnet : this.m_subnetNetworksMapForUserProvidedNetworks.keySet()) {
                    ReportUtil.sureprintln("Subnet: " + subnet);
                    for (NetworkInfo network : this.m_subnetNetworksMapForUserProvidedNetworks.get(subnet)) {
                        ReportUtil.surewriteRecord(network.getNodeName(), network.getInterfaceName(), network.getIPAsString());
                    }
                }
                break block12;
            }
            if (NetworkUtility.isNetworksMapGood(this.m_globalNodeNetworksMap)) {
                ReportUtil.sureprintln("Interface details on each node for which node connectivity is being verified");
                ReportUtil.surewriteColHeaders(s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8009", false), s_msgBundle.getMessage("8010", false), s_msgBundle.getMessage("8011", false));
                for (String node : this.m_globalNodeNetworksMap.keySet()) {
                    ReportUtil.sureprintln("Node: " + node);
                    for (NetworkInfo network : this.m_globalNodeNetworksMap.get(node)) {
                        ReportUtil.surewriteRecord(network.getInterfaceName(), network.getIPAsString(), network.getSubnetAsString());
                    }
                }
            }
            if (NetworkUtility.isNetworksMapGood(this.m_globalSubnetNetworksMap)) {
                ReportUtil.sureprintln("Subnet Details on which node connectivity is being verified");
                ReportUtil.surewriteColHeaders(s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8009", false), s_msgBundle.getMessage("8010", false), s_msgBundle.getMessage("8011", false));
                for (String subnet : this.m_globalSubnetNetworksMap.keySet()) {
                    ReportUtil.sureprintln("Subnet: " + subnet);
                    for (NetworkInfo network : this.m_globalSubnetNetworksMap.get(subnet)) {
                        ReportUtil.surewriteRecord(network.getNodeName(), network.getInterfaceName(), network.getIPAsString());
                    }
                }
            }
        }
    }

    private void reportNetworkMTUDetails(Set<NetworkInfo> subnetNetworks, boolean isPrivate) {
        block4: {
            HashMap<String, Set<NetworkInfo>> subnetNetworksMap;
            block3: {
                subnetNetworksMap = NetworkDataDiscovery.getSubnetNetworksMap(subnetNetworks);
                if (!isPrivate || !NetworkUtility.isNetworksSetGood(subnetNetworks)) break block3;
                String verboseDescription = LSEP + s_gMsgBundle.getMessage("11083", false, (Object[])new String[]{VerificationUtil.strList2List(new ArrayList<String>(subnetNetworksMap.keySet()))});
                ReportUtil.println(verboseDescription);
                ReportUtil.verboseReportPrintln(verboseDescription);
                ReportUtil.surewriteColHeaders(s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8009", false), s_msgBundle.getMessage("8010", false), s_msgBundle.getMessage("8011", false), s_msgBundle.getMessage("8052", false));
                for (NetworkInfo network : subnetNetworks) {
                    ReportUtil.surewriteRecord(network.getNodeName(), network.getInterfaceName(), network.getIPAsString(), network.getSubnetAsString(), String.valueOf(network.getMTU()));
                }
                break block4;
            }
            if (!NetworkUtility.isNetworksSetGood(subnetNetworks)) break block4;
            for (String subnet : subnetNetworksMap.keySet()) {
                Set<NetworkInfo> networksWithinSubnet = subnetNetworksMap.get(subnet);
                if (!NetworkUtility.isNetworksSetGood(networksWithinSubnet)) continue;
                String verboseDescription = LSEP + s_gMsgBundle.getMessage("11082", false, (Object[])new String[]{subnet});
                ReportUtil.println(verboseDescription);
                ReportUtil.verboseReportPrintln(verboseDescription);
                ReportUtil.surewriteColHeaders(s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8009", false), s_msgBundle.getMessage("8010", false), s_msgBundle.getMessage("8011", false), s_msgBundle.getMessage("8052", false));
                for (NetworkInfo network : networksWithinSubnet) {
                    ReportUtil.surewriteRecord(network.getNodeName(), network.getInterfaceName(), network.getIPAsString(), network.getSubnetAsString(), String.valueOf(network.getMTU()));
                }
            }
        }
    }

    private List<Subnet> performRDSPingCheck(List<Subnet> subnets, Vector<ConMatrix> rdsMatrixList) {
        ArrayList<Subnet> infinibandSubnets = new ArrayList<Subnet>();
        ResultSet resSet = new ResultSet();
        HashSet<NetworkInfo> infiniNetworks = new HashSet<NetworkInfo>();
        for (Subnet subnet : subnets) {
            for (NetworkInfo network : subnet.getNetworks()) {
                if (!network.getHardwareType().equalsIgnoreCase(HW_TYPE_INFINIBAND) || IPAddressUtil.isIPv6AddressString((String)network.getIpAddressTypeAsString())) continue;
                infiniNetworks.add(network);
                Trace.out((String)("Network IP for RDS Ping :: " + network.getIPAsString()));
            }
        }
        infinibandSubnets.addAll(Subnet.classifyToSubnets(infiniNetworks, false));
        if (infinibandSubnets.size() <= 0) {
            return infinibandSubnets;
        }
        try {
            this.m_vfyNet.checkRDSSubnetConnectivity(infinibandSubnets, rdsMatrixList, resSet);
        }
        catch (NetworkException ne) {
            Trace.out((String)("NETWORK EXCEPTION: " + ne.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 4);
            Object[] args = new String[]{"error-network-exception-rds-connectivity"};
            this.m_resultSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("13201", true, args)));
            this.m_resultSet.addErrorDescription(new ErrorDescription(LSEP + ne.getMessage()));
            return infinibandSubnets;
        }
        return infinibandSubnets;
    }

    public Set<NetworkInfo> getHaipNetworks() {
        HashSet<NetworkInfo> haipNetworks = new HashSet<NetworkInfo>();
        if (NetworkUtility.isNetworksMapGood(this.m_globalNodeNetworksMap)) {
            for (String node : this.m_globalNodeNetworksMap.keySet()) {
                for (NetworkInfo network : this.m_globalNodeNetworksMap.get(node)) {
                    if (!NetworkUtility.isSameType(network.getNetworkType(), NetworkConstants.NetworkType.PRIVATE.getValue()) || !network.getIPAsString().contains(LINK_LOCAL_ADDRESS)) continue;
                    haipNetworks.add(network);
                }
            }
        }
        return haipNetworks;
    }
}

