/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.ParamPreReqNodeAddDel;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.operation.ha.HALiterals;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskNodeAppCreation
extends Task
implements HALiterals {
    private String[] m_arrNodesWithCRS;
    private String m_statCmd;
    private Vector m_vAgileNodes;
    private boolean m_isVersionTB = false;
    private boolean m_isPost12c = false;
    private boolean m_deletedResource = false;
    public static final String NODEAPP_VIP = "vip";
    public static final String NODEAPP_ONS = "ons";
    public static final String NODEAPP_GSD = "gsd";
    public static final String NODEAPP_NETWORK = "net1.network";
    public static final String NODEAPP_ALL = "all";
    String[] m_resourceFilterArr = new String[]{" -w \\\"TYPE = ora.cluster_vip_net1.type\\\"", " -w \\\"TYPE = ora.ons.type\\\"", " -w \\\"NAME = ora.net1.network\\\"", " -w \\\"TYPE = ora.gsd.type\\\""};
    public static final int RC_UNKNOWN = -1;
    public static final int RC_EXIST = 0;
    public static final int RC_ONLINE = 1;
    public static final int RC_NOTEXIST = 210;
    public static final int RC_NOCRSD = 184;
    private static final String ERRTXT_184 = "CRS-0184";
    private static final String ERRTXT_202 = "CRS-0202";
    private static final String ERRTXT_210 = "CRS-0210";
    private static final String ERRTXT_4535 = "CRS-4535";
    private static final String ERRTXT_4000 = "CRS-4000";
    private static final String ERRTXT_2613 = "CRS-2613";
    private static final String ERRTXT_4655 = "CRS-4655";
    private static final String NAMETXT = "NAME=";
    private static final String STATETXT = "STATE=";
    private static final String ONLINETXT = "ONLINE";
    private static final String OFFLINETXT = "OFFLINE";
    private static final String RES_PREFIX = "ora.";
    private static final int MAX_CMD_LEN = 180;
    private static final String UNKNOWN_RESOURCE_NAME = "UNKNOWN";
    ResultSet m_nodeAppCriticalRS;
    private Hashtable m_vipHash;
    private Hashtable m_onsHash;
    private Hashtable m_gsdHash;
    private Vector<TaskNACData> m_vipData = null;
    private Vector<TaskNACData> m_gsdData = null;
    private Vector<TaskNACData> m_netData = null;
    private Vector<TaskNACData> m_onsData = null;
    String LSEP = System.getProperty("line.separator");

    public TaskNodeAppCreation(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        VerificationType vfyType = this.m_globalContext.getVerificationType();
        if (vfyType != null) {
            switch (vfyType) {
                case PREREQ_NODE_ADD: 
                case PREREQ_RACNODE_ADD: {
                    String[] nodesWithCRSConf = VerificationUtil.filterCRSConfiguredNodes(VerificationUtil.addLocalNodeToNodeList(this.m_nodeList));
                    String[] hubNodesWithCRSConf = VerificationUtil.filterHubNodeList(nodesWithCRSConf);
                    if (this.m_globalContext.isBigCluster() && hubNodesWithCRSConf != null && hubNodesWithCRSConf.length > 0) {
                        this.setNodeList(hubNodesWithCRSConf);
                        break;
                    }
                    this.setNodeList(nodesWithCRSConf);
                    break;
                }
                case POSTREQ_NODE_ADD: {
                    ParamPreReqNodeAddDel param = (ParamPreReqNodeAddDel)this.m_globalContext.getParamPrereq();
                    if (param == null) break;
                    this.setNodeList(param.getValidNewClusterNodes());
                }
            }
        }
    }

    public TaskNodeAppCreation(String[] nodeList) {
        this(nodeList, null, 1);
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        String releaseVer = null;
        VerificationType vfyType = this.m_globalContext.getVerificationType();
        switch (vfyType) {
            case POSTREQ_CRS_INST: {
                releaseVer = VerificationUtil.getCRSActiveVersion();
                break;
            }
            case PREREQ_DB_INST: {
                releaseVer = this.m_globalContext.getRequestedRelease();
                break;
            }
            case PREREQ_DB_CONFIG: {
                VerificationUtil.traceAndLog("Adding nodeapp creation check for pre DB config stage");
                return true;
            }
            case COMPONENT_NODEAPP_EXISTENCE: {
                VerificationUtil.traceAndLog("Adding nodeapp creation check for NodeApp Component");
                return true;
            }
            default: {
                releaseVer = VerificationUtil.getCRSActiveVersion();
            }
        }
        if (VerificationUtil.isStringGood(releaseVer)) {
            if (!releaseVer.startsWith("10.1") && !"10gR1".equalsIgnoreCase(releaseVer)) {
                VerificationUtil.traceAndLog("Adding nodeapp creation check.");
                return true;
            }
            VerificationUtil.traceAndLog("Source home CRS version is 10.1 and hence not adding nodeapp creation check");
            return false;
        }
        VerificationUtil.traceAndLog("Source home CRS version could not be retrieved and hence not adding node apps creation checks");
        return false;
    }

    public TaskNodeAppCreation(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskNodeAppCreation(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setNodesWithCRS(String[] nodesWithCRS) {
        this.m_arrNodesWithCRS = nodesWithCRS;
    }

    public void setDeletedResource(boolean newVal) {
        this.m_deletedResource = newVal;
    }

    @Override
    public boolean performTask() {
        boolean taskRes = true;
        Trace.out((String)"Performing NodeApp Creation Verification Task... ");
        ReportUtil.sureprintln(this.LSEP + s_msgBundle.getMessage("4550", false));
        ReportUtil.sureblankln();
        this.m_arrNodesWithCRS = VerificationUtil.getNodesWithCRSInstall(this.m_nodeList, this.m_resultSet);
        if (this.m_arrNodesWithCRS == null) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            Trace.out((String)"==== CRS is not installed on any node.");
            return false;
        }
        Trace.out((String)("==== Nodes with CRS installed is: " + this.m_arrNodesWithCRS.length));
        return this.performCommonTask(this.m_arrNodesWithCRS, true);
    }

    public boolean performCommonTask(String[] nodeList, boolean uploadRes) {
        if (this.m_arrNodesWithCRS == null) {
            Trace.out((String)"No nodes with CRS installed identified.");
            return false;
        }
        if (!this.determineCRSVersion(nodeList)) {
            return false;
        }
        if (this.m_isVersionTB) {
            return this.performTBNodeAppsCheck(nodeList, uploadRes);
        }
        if (VerificationUtil.isLocalNodeOperation()) {
            this.m_vAgileNodes = new Vector(1);
            this.m_vAgileNodes.add(m_localNode);
        } else {
            try {
                String[] nodes = VerificationUtil.getUserEquivalentNodes(VerificationUtil.getStaticNodelist());
                this.m_vAgileNodes = new Vector(nodes.length);
                for (int k = 0; k < nodes.length; ++k) {
                    this.m_vAgileNodes.add(nodes[k]);
                }
            }
            catch (NodelistNotFoundException e) {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                ErrorDescription errorDesc = new ErrorDescription("0001", s_msgBundle);
                this.m_resultSet.addErrorDescription(errorDesc);
                Trace.out((String)"==== Could not get the static nodelist.");
                Trace.out((Exception)e);
                ReportUtil.printError(s_msgBundle.getMessage("0001", false));
                return false;
            }
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("\nAgileNode list: " + VerificationUtil.strArr2List(nodeList) + "\n"));
        }
        String crsHome = VerificationUtil.getCRSHome();
        this.m_statCmd = crsHome + FSEP + "bin" + FSEP + "crs_stat ";
        ResultSet vipResultSet = new ResultSet();
        this.m_vipHash = new Hashtable(nodeList.length);
        this.createHashStatus(nodeList, this.m_vipHash);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"\n\n*** ABOUT TO DO VIP APP CHECK ***\n\n");
        }
        this.performAppCheck("VIP", NODEAPP_VIP, this.m_vipHash, vipResultSet, false, nodeList);
        ResultSet onsResultSet = new ResultSet();
        this.m_onsHash = new Hashtable(nodeList.length);
        this.createHashStatus(nodeList, this.m_onsHash);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"\n\n*** ABOUT TO DO ONS APP CHECK ***\n\n");
        }
        this.performAppCheck("ONS", NODEAPP_ONS, this.m_onsHash, onsResultSet, true, nodeList);
        ResultSet gsdResultSet = new ResultSet();
        this.m_gsdHash = new Hashtable(nodeList.length);
        this.createHashStatus(nodeList, this.m_gsdHash);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"\n\n*** ABOUT TO DO GSD APP CHECK ***\n\n");
        }
        this.performAppCheck("GSD", NODEAPP_GSD, this.m_gsdHash, gsdResultSet, true, nodeList);
        if (uploadRes) {
            this.m_resultSet.addResultSetData(vipResultSet);
        }
        return this.m_resultSet.allSuccess();
    }

    boolean performTBNodeAppsCheck(String[] nodeList, boolean uploadRes) {
        int i;
        VerificationCommand[] cmdArray = new VerificationCommand[1];
        Vector<String> resVector = new Vector<String>();
        Vector<String> resVectorCopy = new Vector<String>();
        Vector<String> nodeVector = new Vector<String>();
        this.m_nodeAppCriticalRS = new ResultSet();
        String[] resList = this.getResourceNames(nodeList, NODEAPP_ALL);
        for (i = 0; i < resList.length; ++i) {
            resList[i] = resList[i].trim();
            Trace.out((String)("adding resource :'" + resList[i] + "'"));
            resVector.add(resList[i]);
            resVectorCopy.add(resList[i]);
        }
        if (this.m_deletedResource) {
            for (i = 0; i < this.m_arrNodesWithCRS.length; ++i) {
                nodeVector.add(this.m_arrNodesWithCRS[i]);
            }
        } else {
            for (i = 0; i < nodeList.length; ++i) {
                nodeVector.add(nodeList[i]);
            }
        }
        String crsHome = VerificationUtil.getCRSHome();
        String m_statCmd = crsHome + FSEP + "bin" + FSEP + "crsctl stat res";
        Object env = null;
        String output = null;
        for (String filter : this.m_resourceFilterArr) {
            int vRes;
            ResultSet locRS = new ResultSet();
            String[] arg = new String[]{"-rungencmd", m_statCmd, filter};
            String stCmd1 = m_statCmd + " " + (String)filter;
            Trace.out((String)("Command to runExeWithOutput is --> " + stCmd1));
            GlobalExecution gex = new GlobalExecution();
            Hashtable crsCheckOutput = gex.runExeWithOutput(new String[]{m_localNode}, stCmd1, locRS);
            locRS.setStatus();
            Result result = locRS.getResult(m_localNode);
            boolean cornerErrCondn = false;
            String etOutput = (String)crsCheckOutput.get(m_localNode);
            String fvr = VerificationUtil.fetchVerificationResult(etOutput);
            String valErr = result.getExecutionErrorDetails();
            if (etOutput != null && fvr != null && valErr != null && (vRes = Integer.parseInt(fvr)) == 1) {
                cornerErrCondn = true;
            }
            if (cornerErrCondn || 1 != result.getStatus()) {
                String outMsg;
                Trace.out((String)"couldn't execute 'crsctl stat res' command on local node");
                Trace.out((String)"Enter check for CRS-4535 and CRS-4000");
                String message = "";
                Trace.out((String)("exectask Output is:'" + etOutput + "'"));
                boolean crsStackError = false;
                if (valErr != null && (valErr.indexOf(ERRTXT_4535) != -1 || valErr.indexOf(ERRTXT_4000) != -1)) {
                    crsStackError = true;
                    message = message == "" ? valErr : message + this.LSEP + valErr;
                }
                if (crsStackError) {
                    Trace.out((String)("CRS- error message" + message));
                    outMsg = s_msgBundle.getMessage("4578", true, (Object[])nodeVector.toArray(new String[0])) + this.LSEP + message;
                } else {
                    outMsg = s_msgBundle.getMessage("5303", true, (Object[])new String[]{stCmd1, m_localNode});
                    if (message.length() > 0) {
                        outMsg = outMsg + this.LSEP + message;
                    }
                }
                ReportUtil.printError(outMsg);
                continue;
            }
            String execTaskOut = (String)crsCheckOutput.get(m_localNode);
            String cmdOut = VerificationUtil.fetchVerificationValue(execTaskOut);
            if (cmdOut == null || cmdOut.length() <= 0) continue;
            output = output == null ? cmdOut + this.LSEP : output + cmdOut + this.LSEP;
        }
        if (output == null || output.length() == 0) {
            Trace.out((String)"crsctl stat res didn't produce output");
            String errMsg = s_msgBundle.getMessage("4580", true);
            ReportUtil.println(errMsg);
        } else {
            String[] outlist = VerificationUtil.getTokensAsArray(output, this.LSEP);
            for (int i2 = 0; i2 < outlist.length; ++i2) {
                outlist[i2] = outlist[i2].trim();
                if (!outlist[i2].startsWith(NAMETXT)) continue;
                Trace.out((String)("found '" + (String)outlist[i2] + "'"));
                String resName = ((String)outlist[i2]).substring(NAMETXT.length());
                for (String resource : resVector) {
                    if (!resName.equalsIgnoreCase(resource)) continue;
                    Trace.out((String)(" found resource " + resource));
                    if ((i2 += 3) < outlist.length && ((String)outlist[i2]).startsWith(STATETXT)) {
                        String stateText = ((String)outlist[i2]).substring(STATETXT.length());
                        String[] stateArr = stateText.split(",");
                        if (resource.endsWith(NODEAPP_VIP)) {
                            int nodeNameBegin = resource.indexOf(46);
                            int nodeNameEnd = resource.indexOf(46, nodeNameBegin);
                            String nodeName = resource.substring(nodeNameBegin, nodeNameEnd);
                            if (-1 != stateText.indexOf(ONLINETXT)) {
                                this.updateResourceStatus(this.m_vipData, resource, 1, null);
                            } else {
                                this.updateResourceStatus(this.m_vipData, resource, 0, null);
                            }
                        } else if (resource.endsWith(NODEAPP_ONS) || resource.endsWith(NODEAPP_GSD) || resource.endsWith(NODEAPP_NETWORK)) {
                            int resourceKind = 0;
                            if (resource.endsWith(NODEAPP_GSD)) {
                                resourceKind = 1;
                            }
                            if (resource.endsWith(NODEAPP_NETWORK)) {
                                resourceKind = 2;
                            }
                            block23: for (int j = 0; j < stateArr.length; ++j) {
                                Trace.out((String)("state line is :" + stateArr[j]));
                                String[] stateArrSplit = stateArr[j].trim().split(" ");
                                if (stateArrSplit.length == 1 && stateArr[j].indexOf(OFFLINETXT) != -1) {
                                    Trace.out((String)("resource " + resource + "is offline on all nodes"));
                                    switch (resourceKind) {
                                        case 0: {
                                            for (String nodeName : nodeVector) {
                                                this.updateResourceStatus(this.m_onsData, resource, 0, nodeName);
                                            }
                                            continue block23;
                                        }
                                        case 1: {
                                            for (String nodeName : nodeVector) {
                                                this.updateResourceStatus(this.m_gsdData, resource, 0, nodeName);
                                            }
                                            continue block23;
                                        }
                                        case 2: {
                                            for (String nodeName : nodeVector) {
                                                this.updateResourceStatus(this.m_netData, resource, 0, nodeName);
                                            }
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                String nodeName = stateArrSplit[2];
                                Trace.out((String)("node name obtained is :" + nodeName));
                                if (-1 != stateArr[j].indexOf(ONLINETXT)) {
                                    Trace.out((String)(resource + " online on node " + nodeName));
                                    switch (resourceKind) {
                                        case 0: {
                                            this.updateResourceStatus(this.m_onsData, resource, 1, nodeName);
                                            break;
                                        }
                                        case 1: {
                                            this.updateResourceStatus(this.m_gsdData, resource, 1, nodeName);
                                            break;
                                        }
                                        case 2: {
                                            this.updateResourceStatus(this.m_netData, resource, 1, nodeName);
                                        }
                                    }
                                    continue;
                                }
                                Trace.out((String)(resource + " offline on node " + nodeName));
                                switch (resourceKind) {
                                    case 0: {
                                        this.updateResourceStatus(this.m_onsData, resource, 0, nodeName);
                                        continue block23;
                                    }
                                    case 1: {
                                        this.updateResourceStatus(this.m_gsdData, resource, 0, nodeName);
                                        continue block23;
                                    }
                                    case 2: {
                                        this.updateResourceStatus(this.m_netData, resource, 0, nodeName);
                                    }
                                }
                            }
                        }
                        resVectorCopy.remove(resource);
                        continue;
                    }
                    int trcMax = outlist.length <= i2 + 5 ? outlist.length : i2 + 5;
                    for (int j = i2; j < trcMax; ++j) {
                        Trace.out((String)("crsctl output" + j + "=" + (String)outlist[j]));
                    }
                    String errMesg = s_msgBundle.getMessage("4579", true, (Object[])new String[]{m_statCmd, resource, output});
                    ReportUtil.sureprintln(errMesg);
                    ErrorDescription errDesc = new ErrorDescription(errMesg);
                    this.m_nodeAppCriticalRS.addErrorDescription((String)nodeVector.get(0), errDesc);
                }
            }
        }
        if (resVectorCopy.size() > 0) {
            Trace.out((String)(resVectorCopy.size() + " unresolved resource are present"));
            for (String resource : resVectorCopy) {
                Trace.out((String)("updating status for " + resource + " to not existing"));
                if (resource.endsWith(NODEAPP_ONS)) {
                    for (String nodeName : nodeVector) {
                        this.updateResourceStatus(this.m_onsData, resource, 210, nodeName);
                    }
                    continue;
                }
                if (resource.endsWith(NODEAPP_NETWORK)) {
                    for (String nodeName : nodeVector) {
                        this.updateResourceStatus(this.m_netData, resource, 210, nodeName);
                    }
                    continue;
                }
                if (resource.endsWith(NODEAPP_GSD)) {
                    for (String nodeName : nodeVector) {
                        this.updateResourceStatus(this.m_gsdData, resource, 210, nodeName);
                    }
                    continue;
                }
                this.updateResourceStatus(this.m_vipData, resource, 210, null);
            }
        }
        this.prepareCritialNodeAppResultSet();
        this.displayNodeAppResults();
        if (uploadRes) {
            this.m_resultSet.addResultSetData(this.m_nodeAppCriticalRS);
        }
        if (this.m_nodeAppCriticalRS.allSuccess() && this.m_nodeMgr.isBigCluster()) {
            String[] hubCapableArr = null;
            try {
                hubCapableArr = this.m_nodeMgr.getHubCapableNodes();
            }
            catch (NodeManagerException e) {
                Trace.out((String)("Node manger exception " + e.getMessage()));
            }
            if (hubCapableArr != null) {
                ArrayList<String> hubCapableList = new ArrayList<String>();
                hubCapableList.addAll(Arrays.asList(hubCapableArr));
                List<String> hubList = Arrays.asList(this.m_nodeList);
                hubCapableList.removeAll(hubList);
                if (hubCapableList.size() != 0 && !this.isNetworkDHCP(crsHome)) {
                    ResultSet locrs = new ResultSet();
                    this.performVIPExistanceCheck(hubCapableList, m_localNode, locrs);
                    this.m_nodeAppCriticalRS.addResultSetData(locrs);
                }
            }
        }
        return this.m_nodeAppCriticalRS.allSuccess();
    }

    private boolean isNetworkDHCP(String crsHome) {
        try {
            if (new ClusterwareInfo().isDHCPServerConfigured(crsHome)) {
                Trace.out((String)"dhcp based network resource is running");
                return true;
            }
        }
        catch (InstallException e) {
            Trace.out((String)("error while checking if network is DHCP" + e.getMessage()));
        }
        return false;
    }

    private void performVIPExistanceCheck(List<String> hubCapableLeafList, String localNode, ResultSet locrs) {
        String msg;
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("4612", false, (Object[])new String[]{VerificationUtil.strList2List(hubCapableLeafList)}));
        ArrayList<String> noIPList = new ArrayList<String>();
        ArrayList<String> upIPList = new ArrayList<String>();
        for (String node : hubCapableLeafList) {
            String vipName = node + "-" + NODEAPP_VIP;
            try {
                InetAddress inetAddress = VerificationUtil.isIPv6Cluster(localNode, false) ? Inet6Address.getByName(node) : Inet4Address.getByName(node);
                ClusterCmd clusterCmd = new ClusterCmd();
                clusterCmd.areNodesAlive(new String[]{vipName}, 30, null);
                upIPList.add(node);
                locrs.addResult(node, 1);
            }
            catch (UnknownHostException e) {
                noIPList.add(node);
                locrs.addResult(node, 3);
            }
            catch (RemoteFileOperationException e) {
                Trace.out((String)"vip down as expected");
                locrs.addResult(node, 3);
            }
            catch (ClusterException e) {
                Trace.out((String)"vip down as expected");
                locrs.addResult(node, 1);
            }
            catch (VerificationException e) {
                Trace.out((String)("verification exception while checking if IPv6 cluster" + e.getMessage()));
                locrs.addResult(node, 2);
                locrs.addErrorDescription(node, new ErrorDescription(e.getMessage()));
            }
        }
        if (noIPList.size() > 0) {
            msg = s_gMsgBundle.getMessage("4610", true, (Object[])new String[]{VerificationUtil.strList2List(noIPList)});
            locrs.addErrorDescription(noIPList, new ErrorDescription(msg));
            ReportUtil.sureprintln(msg);
        }
        if (upIPList.size() > 0) {
            msg = s_gMsgBundle.getMessage("4611", true, (Object[])new String[]{VerificationUtil.strList2List(upIPList)});
            locrs.addErrorDescription(upIPList, new ErrorDescription(msg));
            ReportUtil.sureprintln(msg);
        }
        if (locrs.allSuccess()) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("4613", false, (Object[])new String[]{VerificationUtil.strList2List(hubCapableLeafList)}));
        }
    }

    private void displayNodeAppResults() {
        String displayMessage = s_msgBundle.getMessage("4566", false);
        ReportUtil.sureprintln(displayMessage);
        Task previousTaskReference = ReportUtil.setTaskReference(this);
        if (ReportUtil.isVerbose()) {
            ReportUtil.reportFormatPrintln(this.LSEP + this.LSEP + displayMessage);
        }
        this.displayPerNodeResult(this.m_vipData, ReportUtil.YES, "4567", "4581", "4568");
        displayMessage = s_msgBundle.getMessage("4569", false);
        ReportUtil.sureprintln(displayMessage);
        if (ReportUtil.isVerbose()) {
            ReportUtil.reportFormatPrintln(this.LSEP + this.LSEP + displayMessage);
        }
        this.displayPerNodeResult(this.m_netData, ReportUtil.YES, "4570", "4583", "4571");
        if (!this.m_isPost12c) {
            displayMessage = s_msgBundle.getMessage("4572", false);
            ReportUtil.sureprintln(displayMessage);
            if (ReportUtil.isVerbose()) {
                ReportUtil.reportFormatPrintln(this.LSEP + this.LSEP + displayMessage);
            }
            this.displayPerNodeResult(this.m_gsdData, ReportUtil.NO, "4573", "4582", "4574");
        }
        displayMessage = s_msgBundle.getMessage("4575", false);
        ReportUtil.sureprintln(displayMessage);
        if (ReportUtil.isVerbose()) {
            ReportUtil.reportFormatPrintln(this.LSEP + this.LSEP + displayMessage);
        }
        this.displayPerNodeResult(this.m_onsData, ReportUtil.NO, "4576", "4584", "4577");
        ReportUtil.setTaskReference(previousTaskReference);
    }

    private void displayPerNodeResult(Vector<TaskNACData> dataVector, String requiredStr, String failureKey, String offlineKey, String successKey) {
        String msg;
        String nodeList;
        Vector<String> failedNodes = new Vector<String>();
        Vector<String> offlineNodes = new Vector<String>();
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.REQUIRED, s_msgBundle.getMessage("8003", false), ReportUtil.COMMENT);
        for (TaskNACData nacData : dataVector) {
            String runningState;
            String comment;
            String nodeStr = nacData.getNodeName();
            int status = nacData.getStatus();
            switch (status) {
                case 0: {
                    comment = ReportUtil.EXIST;
                    offlineNodes.add(nodeStr);
                    break;
                }
                case 1: {
                    comment = ReportUtil.PASSED;
                    break;
                }
                case 210: {
                    comment = ReportUtil.NOTEXIST;
                    break;
                }
                default: {
                    comment = ReportUtil.FAILED;
                }
            }
            if (status == 1) {
                runningState = ReportUtil.YES;
            } else if (status == 0) {
                runningState = ReportUtil.NO;
            } else {
                runningState = ReportUtil.NO;
                failedNodes.add(nodeStr);
            }
            ReportUtil.writeRecord(nodeStr, requiredStr, runningState, comment);
        }
        if (failedNodes.size() > 0) {
            nodeList = VerificationUtil.strArr2String(failedNodes.toArray(new String[0]), ",");
            if (nodeList.lastIndexOf(",") == nodeList.length() - 1) {
                nodeList = nodeList.substring(0, nodeList.length() - 1);
            }
            msg = s_msgBundle.getMessage(failureKey, true, (Object[])new String[]{nodeList}) + this.LSEP;
            ReportUtil.sureprintln(msg);
        } else if (offlineNodes.size() > 0) {
            nodeList = VerificationUtil.strArr2String(offlineNodes.toArray(new String[0]), ",");
            if (nodeList.lastIndexOf(",") == nodeList.length() - 1) {
                nodeList = nodeList.substring(0, nodeList.length() - 1);
            }
            msg = s_msgBundle.getMessage(offlineKey, false, (Object[])new String[]{nodeList}) + this.LSEP;
            ReportUtil.sureprintln(msg);
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage(successKey, false) + this.LSEP);
        }
    }

    private void updateResourceStatus(Vector<TaskNACData> dataVector, String resource, int status, String nodeName) {
        for (TaskNACData nacData : dataVector) {
            if (nodeName == null && nacData.getName().equalsIgnoreCase(resource)) {
                nacData.setStatus(status);
                continue;
            }
            if (!nacData.getNodeName().equalsIgnoreCase(nodeName) || nacData.getStatus() == 1) continue;
            nacData.setStatus(status);
        }
    }

    private void prepareCritialNodeAppResultSet() {
        this.prepareNodeAppResultSet(NODEAPP_VIP, this.m_nodeAppCriticalRS);
        this.prepareNodeAppResultSet("network", this.m_nodeAppCriticalRS);
    }

    private void prepareNodeAppResultSet(String resourceType, ResultSet rsltSet) {
        if (resourceType.equalsIgnoreCase(NODEAPP_VIP)) {
            this.generateResultSet(this.m_vipData, rsltSet);
        } else if (resourceType.equalsIgnoreCase("network")) {
            this.generateResultSet(this.m_netData, rsltSet);
        } else if (resourceType.equalsIgnoreCase(NODEAPP_ONS)) {
            this.generateResultSet(this.m_onsData, rsltSet);
        } else if (resourceType.equalsIgnoreCase(NODEAPP_GSD)) {
            this.generateResultSet(this.m_gsdData, rsltSet);
        }
    }

    private void generateResultSet(Vector<TaskNACData> dataVector, ResultSet rsltSet) {
        for (TaskNACData nacData : dataVector) {
            int status = nacData.getStatus();
            String nodeName = nacData.getNodeName();
            String errMsg = null;
            ErrorDescription errDesc = null;
            switch (status) {
                case 1: {
                    rsltSet.addResult(nodeName, 1);
                    break;
                }
                case 210: {
                    rsltSet.addResult(nodeName, 3);
                    errMsg = s_msgBundle.getMessage("4555", true, (Object[])new String[]{nacData.getName(), nodeName});
                    errDesc = new ErrorDescription(errMsg);
                    rsltSet.addErrorDescription(nodeName, errDesc);
                    break;
                }
                case 0: {
                    rsltSet.addResult(nodeName, 3);
                    errMsg = s_gMsgBundle.getMessage("13620", true, (Object[])new String[]{nacData.getName(), nodeName});
                    errDesc = new ErrorDescription(errMsg);
                    rsltSet.addErrorDescription(nodeName, errDesc);
                    break;
                }
                default: {
                    rsltSet.addResult(nodeName, 2);
                    errMsg = s_msgBundle.getMessage("4556", true, (Object[])new String[]{nacData.getName(), nodeName});
                    errDesc = new ErrorDescription(errMsg);
                    rsltSet.addErrorDescription(nodeName, errDesc);
                }
            }
            rsltSet.getResult(nodeName).addResultInfo(nacData);
        }
    }

    String[] getResourceNames(String[] nodelist, String appName) {
        Vector<String> resVector = new Vector<String>(nodelist.length);
        String[] resList = null;
        if (this.m_isVersionTB) {
            this.m_vipData = new Vector(nodelist.length);
            this.m_netData = new Vector(nodelist.length);
            this.m_onsData = new Vector(nodelist.length);
            if (!this.m_isPost12c) {
                this.m_gsdData = new Vector(nodelist.length);
            }
            String ons = "ora.ons";
            String network = "ora.net1.network";
            String gsd = "ora.gsd";
            resVector.add(ons);
            resVector.add(network);
            if (!this.m_isPost12c) {
                resVector.add(gsd);
            }
            if (this.m_deletedResource) {
                for (int i = 0; i < nodelist.length; ++i) {
                    String resource = RES_PREFIX + nodelist[i] + "." + NODEAPP_VIP;
                    resVector.add(resource);
                    this.m_vipData.add(new TaskNACData(resource, -1, nodelist[i]));
                    this.m_netData.add(new TaskNACData(network, -1, nodelist[i]));
                    this.m_onsData.add(new TaskNACData(ons, -1, nodelist[i]));
                    if (this.m_isPost12c) continue;
                    this.m_gsdData.add(new TaskNACData(gsd, -1, nodelist[i]));
                }
            } else {
                for (int i = 0; i < this.m_arrNodesWithCRS.length; ++i) {
                    String resource = RES_PREFIX + this.m_arrNodesWithCRS[i] + "." + NODEAPP_VIP;
                    resVector.add(resource);
                    this.m_vipData.add(new TaskNACData(resource, -1, this.m_arrNodesWithCRS[i]));
                    this.m_netData.add(new TaskNACData(network, -1, this.m_arrNodesWithCRS[i]));
                    this.m_onsData.add(new TaskNACData(ons, -1, this.m_arrNodesWithCRS[i]));
                    if (this.m_isPost12c) continue;
                    this.m_gsdData.add(new TaskNACData(gsd, -1, this.m_arrNodesWithCRS[i]));
                }
            }
        } else {
            for (int i = 0; i < nodelist.length; ++i) {
                Trace.out((String)("==== nodelist loop: " + nodelist[i]));
                if (appName.equals(NODEAPP_VIP) || appName.equals("VIP")) {
                    resVector.add(RES_PREFIX + nodelist[i].toLowerCase() + "." + NODEAPP_VIP);
                    continue;
                }
                if (appName.equals(NODEAPP_GSD) || appName.equals("GSD")) {
                    resVector.add(RES_PREFIX + nodelist[i].toLowerCase() + "." + NODEAPP_GSD);
                    continue;
                }
                if (appName.equals(NODEAPP_ONS) || appName.equals("ONS")) {
                    resVector.add(RES_PREFIX + nodelist[i].toLowerCase() + "." + NODEAPP_ONS);
                    continue;
                }
                Trace.out((String)("==== Res. App. unknown: " + appName));
            }
        }
        resList = resVector.toArray(new String[resVector.size()]);
        return resList;
    }

    private boolean removeFromAgileList(String node) {
        boolean result = this.m_vAgileNodes.remove(node);
        Trace.out((String)("==== Removal status of node '" + node + "': " + result));
        return result;
    }

    private String[] getAgileNodelist() {
        String[] agileNodes = this.m_vAgileNodes.toArray(new String[this.m_vAgileNodes.size()]);
        Trace.out((String)("==== Agile node count: " + agileNodes.length));
        for (int i = 0; i < agileNodes.length; ++i) {
            Trace.out((String)("\t" + agileNodes[i]));
        }
        return agileNodes;
    }

    private String getNodenameFromResname(String res) {
        String node = res.substring(res.indexOf(46) + 1, res.lastIndexOf(46));
        Trace.out((String)("Node name '" + node + "' was retrieved from " + res));
        return node;
    }

    private void createHashStatus(String[] nodelist, Hashtable ht) {
        ht.clear();
        for (int i = 0; i < nodelist.length; ++i) {
            ht.put(nodelist[i], new Integer(-1));
        }
    }

    private void performAppCheck(String appName, String appSuffix, Hashtable hash, ResultSet resultSet, boolean optional, String[] nodeList) {
        String[] resList;
        ResultSet tmpRSet = new ResultSet();
        String upappName = appName.toUpperCase();
        String endTag = "";
        if (!ReportUtil.isVerbose()) {
            endTag = optional ? s_msgBundle.getMessage("9404", false) : s_msgBundle.getMessage("9405", false);
            endTag = "(" + endTag + ")";
        }
        ReportUtil.sureprintln(s_msgBundle.getMessage("4551", false, (Object[])new String[]{appName}) + endTag);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("About to get resource names for: \nappName: " + appName + "\nappSuffix: " + appSuffix + "\nnodes with CRS: " + VerificationUtil.strArr2List(this.m_arrNodesWithCRS) + "\nnodes on CMD line: " + VerificationUtil.strArr2List(nodeList) + "\n"));
        }
        if ((resList = this.getResourceNames(nodeList, appSuffix)).length == 0) {
            ReportUtil.printError(s_msgBundle.getMessage("4552", false, (Object[])new String[]{appName}));
            resultSet.addResult(this.m_arrNodesWithCRS, 5);
            for (String node : this.m_arrNodesWithCRS) {
                resultSet.addErrorDescription(node, new ErrorDescription(s_msgBundle.getMessage("4554", true, (Object[])new String[]{appName, node}), s_msgBundle, "4554"));
            }
            return;
        }
        this.checkNodeApp(resList, hash, tmpRSet);
        this.updateResult(resList, appName, hash, resultSet, optional);
        this.reportResult(resultSet, optional);
    }

    private void checkNodeApp(String[] resList, Hashtable statusHT, ResultSet resultSet) {
        Trace.out((String)"==== Checking Nodeapp:");
        Vector<String> vUnresolvedRes = new Vector<String>(resList.length);
        Vector<String> vCurrentUnresolvedRes = new Vector<String>(resList.length);
        for (int k = 0; k < resList.length; ++k) {
            String resource = resList[k];
            vUnresolvedRes.add(resource);
            vCurrentUnresolvedRes.add(resList[k]);
            Trace.out((String)("==== Unresolved res added as: " + resource));
        }
        Trace.out((String)("**** UnRRes count at the beginning : " + vUnresolvedRes.size()));
        String[] agileNodes = this.getAgileNodelist();
        int urResCount = 0;
        int cmdCount = 0;
        String[] cmdList = null;
        String[] cmdNodeList = null;
        int resIndex = 0;
        Hashtable<String, String> commandsHT = new Hashtable<String, String>(agileNodes.length);
        Hashtable nodeToResHT = new Hashtable();
        Hashtable nodeToCurrentUnresolvedResHT = new Hashtable();
        int maxNumberofLoops = agileNodes.length * resList.length + 1;
        Trace.out((String)("max iteration set to :" + maxNumberofLoops));
        while (maxNumberofLoops-- >= 0 && !vUnresolvedRes.isEmpty()) {
            String resName;
            resIndex = 0;
            agileNodes = this.getAgileNodelist();
            Trace.out((String)("==== Number of agile nodes: " + agileNodes.length));
            if (agileNodes.length == 0) {
                Trace.out((String)("==== Responsive node count reached 0.  Could not check these resources: " + VerificationUtil.strVect2List(vUnresolvedRes)));
                break;
            }
            urResCount = vUnresolvedRes.size();
            Trace.out((String)("==== Number of resources to check: " + urResCount));
            nodeToResHT.clear();
            commandsHT.clear();
            boolean bResAvail = true;
            for (int n = 0; n < agileNodes.length && bResAvail; ++n) {
                boolean bLoaded = false;
                String cmdStr = this.m_statCmd;
                String cmdNodeName = agileNodes[n];
                Vector<String> vResListForNode = new Vector<String>();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("Processing AGILE node: " + cmdNodeName + "\ncmdStr: " + cmdStr + "\nagileNodes length: " + agileNodes.length + "\nn: " + n + "bResAvail: " + bResAvail + "\n "));
                }
                int iCapacity = 180 - this.m_statCmd.length();
                while (!bLoaded) {
                    if (resIndex == urResCount) {
                        Trace.out((String)"==== No more resources to load");
                        bResAvail = false;
                        break;
                    }
                    resName = vUnresolvedRes.elementAt(resIndex);
                    if (iCapacity >= resName.length()) {
                        cmdStr = cmdStr + " " + resName;
                        iCapacity -= resName.length();
                        ++resIndex;
                        vResListForNode.add(resName);
                        continue;
                    }
                    bLoaded = true;
                }
                nodeToResHT.put(cmdNodeName, vResListForNode);
                commandsHT.put(cmdNodeName, cmdStr);
                Trace.out((String)("==== Command added: " + cmdStr));
            }
            cmdCount = commandsHT.size();
            cmdList = new String[cmdCount];
            cmdNodeList = new String[cmdCount];
            Enumeration e = commandsHT.keys();
            int index = 0;
            while (e.hasMoreElements()) {
                cmdNodeList[index] = (String)e.nextElement();
                cmdList[index] = (String)commandsHT.get(cmdNodeList[index]);
                ++index;
            }
            Trace.out((String)("==== Executing on " + cmdCount + " nodes."));
            GlobalExecution globalExec = new GlobalExecution();
            Hashtable crsstatOutputHT = globalExec.runExeWithOutput(cmdNodeList, cmdList, resultSet);
            block5: for (int j = 0; j < cmdCount; ++j) {
                String output = (String)crsstatOutputHT.get(cmdNodeList[j]);
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("\nCommand output for: " + cmdNodeList[j] + "\nOutput: " + output + "\n"));
                }
                Vector payloadV = (Vector)nodeToResHT.get(cmdNodeList[j]);
                Hashtable resStatusHT = this.analyzeResult(output, payloadV);
                Enumeration statEnum = resStatusHT.keys();
                Trace.out((String)("status available for " + resStatusHT.size() + "elements"));
                while (statEnum.hasMoreElements()) {
                    resName = (String)statEnum.nextElement();
                    int status = (Integer)resStatusHT.get(resName);
                    String nodename = this.getNodenameFromResname(resName);
                    Trace.out((String)("==== Nodeapp status for '" + nodename + "' is:" + status));
                    if (statusHT.containsKey(nodename)) {
                        statusHT.put(nodename, new Integer(status));
                    } else {
                        Trace.out((String)"Status update in case insensitive way");
                        Enumeration nodeList = statusHT.keys();
                        while (nodeList.hasMoreElements()) {
                            String keyNodeName = (String)nodeList.nextElement();
                            if (!keyNodeName.equalsIgnoreCase(nodename)) continue;
                            Trace.out((String)("Reporting status for node :" + keyNodeName));
                            statusHT.put(keyNodeName, new Integer(status));
                        }
                    }
                    if (status == 0 || status == 210 || status == 1) {
                        Trace.out((String)("==== Resolved resource : " + resName));
                        boolean result = vUnresolvedRes.remove(resName);
                        Trace.out((String)("==== Res removal status : " + result));
                        if (!result) {
                            Trace.out((String)("Problem removing resource : " + resName));
                            this.removeFromAgileList(cmdNodeList[j]);
                        }
                        String resolvedRes = (String)nodeToCurrentUnresolvedResHT.get(nodename);
                        vCurrentUnresolvedRes.remove(resolvedRes);
                        continue;
                    }
                    Trace.out((String)("==== Removing unresponsive node " + cmdNodeList[j]));
                    this.removeFromAgileList(cmdNodeList[j]);
                    continue block5;
                }
            }
            Trace.out((String)("==== Number of node res checked: " + cmdCount));
            Trace.out((String)("=== remaining loop count = " + (maxNumberofLoops - 1)));
        }
        Trace.out((String)(" loops remaining = " + maxNumberofLoops));
    }

    private Hashtable analyzeResult(String output, Vector payLoadV) {
        boolean bOpSuc = true;
        Hashtable<Object, Integer> statusHT = new Hashtable<Object, Integer>(payLoadV.size());
        Trace.out((String)"==== Inside analyzeResult ");
        if (!VerificationUtil.fetchExecResult(output)) {
            Trace.out((String)"==== Execution result is NULL. Status for every one will be marked as: -1");
            bOpSuc = false;
        }
        String exitStatus = VerificationUtil.fetchVerificationResult(output);
        Trace.out((String)("==== Verification result: " + exitStatus));
        if (bOpSuc && exitStatus == null) {
            Trace.out((String)"==== Verification result is NULL. Status for every one will be marked as: -1");
            bOpSuc = false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(output);
        if (!bOpSuc || txtVal == null || txtVal.length() == 0) {
            int status = -1;
            Trace.out((String)("unknown status operation status =" + bOpSuc + "cmd output=" + txtVal));
            for (int i = 0; i < payLoadV.size(); ++i) {
                statusHT.put(payLoadV.elementAt(i), new Integer(status));
            }
            return statusHT;
        }
        boolean res_exists = false;
        boolean res_online = false;
        String resName = null;
        String[] outlist = VerificationUtil.getTokensAsArray(txtVal, "\n");
        for (int l = 0; l < outlist.length; ++l) {
            int i;
            outlist[l] = outlist[l].trim();
            if (outlist[l].startsWith(ERRTXT_184)) {
                int status = 184;
                for (i = 0; i < payLoadV.size(); ++i) {
                    statusHT.put(payLoadV.elementAt(i), new Integer(status));
                }
                Trace.out((String)"==== CRS not available. Marking all the res as NOCRSD before exiting.");
                return statusHT;
            }
            if (outlist[l].startsWith(ERRTXT_202)) {
                int status = 210;
                for (i = 0; i < payLoadV.size(); ++i) {
                    statusHT.put(payLoadV.elementAt(i), new Integer(status));
                }
                Trace.out((String)"==== No resource has been registered. Marking all the res as NOTEXIST before exiting.");
                return statusHT;
            }
            if (outlist[l].startsWith(ERRTXT_210)) {
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"==== Case 210");
                }
                for (int r = 0; r < payLoadV.size(); ++r) {
                    resName = (String)payLoadV.elementAt(r);
                    if (-1 == outlist[l].indexOf(resName)) continue;
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)("==== Marking '" + resName + "' as NOTEXIST"));
                    }
                    statusHT.put(resName, new Integer(210));
                    break;
                }
            }
            if (outlist[l].startsWith(NAMETXT)) {
                resName = outlist[l].substring(NAMETXT.length());
                res_exists = true;
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("==== Marking res '" + resName + "' as EXIST"));
                }
            }
            if (!outlist[l].startsWith(STATETXT)) continue;
            if (-1 != outlist[l].indexOf(ONLINETXT)) {
                res_online = true;
                if (!Trace.isLevelEnabled((int)1)) continue;
                Trace.out((String)("==== " + resName + ": ONLINE"));
                continue;
            }
            res_online = false;
            if (!Trace.isLevelEnabled((int)1)) continue;
            Trace.out((String)("==== " + resName + ": OFFLINE"));
        }
        if (res_exists) {
            if (res_online) {
                statusHT.put(resName, new Integer(1));
            } else {
                statusHT.put(resName, new Integer(0));
            }
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return statusHT;
    }

    private void updateResult(String[] resList, String appName, Hashtable hash, ResultSet resultSet, boolean optional) {
        Enumeration e = hash.keys();
        String resourceName = null;
        while (e.hasMoreElements()) {
            int status;
            String node = (String)e.nextElement();
            for (String resName : resList) {
                if (resName.indexOf(appName.toLowerCase()) == -1 || resName.indexOf(node) == -1) continue;
                resourceName = resName;
                break;
            }
            Result result = resultSet.getResult(node);
            ErrorDescription errorDesc = null;
            Integer resStatus = (Integer)hash.get(node);
            TaskNACData nacData = null;
            if (result == null) {
                result = new Result(node);
            }
            switch (resStatus) {
                case 1: {
                    status = 1;
                    nacData = new TaskNACData(resourceName, 1);
                    result.addResultInfo(nacData);
                    break;
                }
                case 0: {
                    status = optional ? 4 : 3;
                    nacData = new TaskNACData(resourceName, 0);
                    result.addResultInfo(nacData);
                    errorDesc = new ErrorDescription(s_gMsgBundle.getMessage("13620", true, (Object[])new String[]{appName, node}));
                    break;
                }
                case 210: {
                    status = optional ? 4 : 3;
                    nacData = new TaskNACData(resourceName, 210);
                    result.addResultInfo(nacData);
                    errorDesc = new ErrorDescription(s_msgBundle.getMessage("4555", true, (Object[])new String[]{appName, node}), s_msgBundle, "4555");
                    break;
                }
                default: {
                    status = 2;
                    nacData = new TaskNACData(UNKNOWN_RESOURCE_NAME, -1);
                    result.addResultInfo(nacData);
                    errorDesc = new ErrorDescription(s_msgBundle.getMessage("4556", true, (Object[])new String[]{appName, node}), s_msgBundle, "4556");
                }
            }
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("==== App status: " + resStatus + ". Adding Result for node " + node + " with status " + status));
                Trace.out((String)nacData.toString());
            }
            result.setStatus(status);
            resultSet.addResult(node, result);
            if (errorDesc == null) continue;
            resultSet.addErrorDescription(node, errorDesc);
        }
    }

    private void reportResult(ResultSet rsltSet, boolean optional) {
        Hashtable ht = rsltSet.getResultTable();
        Enumeration e = ht.keys();
        String req = optional ? ReportUtil.NO : ReportUtil.YES;
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.REQUIRED, ReportUtil.STATUS, ReportUtil.COMMENT);
        while (e.hasMoreElements()) {
            String comment;
            String appStatus;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                appStatus = ReportUtil.ONLINE;
                comment = ReportUtil.PASSED;
            } else if (result.getStatus() == 3 || result.getStatus() == 4) {
                appStatus = ReportUtil.NOTEXIST;
                comment = optional ? ReportUtil.IGNORED : ReportUtil.FAILED;
            } else {
                appStatus = ReportUtil.UNKNOWN;
                comment = optional ? ReportUtil.IGNORED : ReportUtil.FAILED;
            }
            ReportUtil.writeRecord(node, req, appStatus, comment);
        }
        if (rsltSet.getStatus() == 1) {
            ReportUtil.printResult(s_msgBundle.getMessage("9401", false));
        } else {
            String msgID = optional ? "9403" : "9402";
            ReportUtil.printResult(s_msgBundle.getMessage(msgID, false));
            ReportUtil.printErrorNodes(rsltSet);
        }
        ReportUtil.sureblankln();
    }

    private boolean determineCRSVersion(String[] nodeList) {
        String activeCRSVer = VerificationUtil.getCRSActiveVersion();
        if (activeCRSVer == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Failed to retrieve active version for CRS");
            }
            String errMsg = s_msgBundle.getMessage("5300", false);
            ReportUtil.printError(errMsg);
            this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
            this.m_resultSet.addResult(nodeList, 2);
            return false;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nCRSActiveVersion: " + activeCRSVer));
        }
        if (VerificationUtil.isVersionPost(activeCRSVer, "11.2")) {
            this.m_isVersionTB = true;
        }
        if (VerificationUtil.isVersionPost(activeCRSVer, "12")) {
            this.m_isPost12c = true;
        }
        return true;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4425", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4476", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        return sb.toString();
    }

    @Override
    public ResultSet getResultSet() {
        if (this.m_isVersionTB) {
            return this.m_nodeAppCriticalRS;
        }
        return this.m_resultSet;
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_ACTIVE;
    }

    public class TaskNACData {
        private String na_Name;
        private int na_Status;
        private String na_NodeName;

        public TaskNACData(String name, int status) {
            this.na_Name = name;
            this.na_Status = status;
            this.na_NodeName = null;
        }

        public TaskNACData(String name, int status, String nodeName) {
            this.na_Name = name;
            this.na_Status = status;
            this.na_NodeName = nodeName;
        }

        public String getName() {
            return this.na_Name;
        }

        public int getStatus() {
            return this.na_Status;
        }

        public String getNodeName() {
            return this.na_NodeName;
        }

        public void setStatus(int status) {
            this.na_Status = status;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            String status = null;
            switch (this.na_Status) {
                case 1: {
                    status = "RC_ONLINE";
                    break;
                }
                case 0: {
                    status = "RC_EXIST";
                    break;
                }
                case 210: {
                    status = "RC_NOTEXIST";
                    break;
                }
                default: {
                    status = TaskNodeAppCreation.UNKNOWN_RESOURCE_NAME;
                }
            }
            sb.append("    App Name: '" + this.na_Name + "' Status: " + status);
            return sb.toString();
        }
    }
}

