/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkDataDiscovery;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskNetworkConfigurationConsistency
extends Task
implements VerificationConstants,
VerificationAPIConstants {
    private String m_sourceHome = null;
    private HashMap<String, Set<NetworkInfo>> m_nodeNetworksMap = null;

    public TaskNetworkConfigurationConsistency(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        this.m_sourceHome = this.m_globalContext.getCRSHome();
        ResultSet networkResultSet = new ResultSet();
        this.m_nodeNetworksMap = NetworkDataDiscovery.getNodeNetworksMap(this.m_nodeList, networkResultSet);
        if (!NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMap)) {
            NetworkUtility.reportResultSet(networkResultSet, this.m_resultSet, true);
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return VerificationUtil.isStringGood(this.m_sourceHome);
    }

    public TaskNetworkConfigurationConsistency(String[] nodeList, String sourceHome) {
        super(nodeList, null, 1);
        this.m_sourceHome = sourceHome;
    }

    private boolean checkForNetworkExistenceOnAllNodes(Set<NetworkInfo> clusterNetworks) {
        ErrorDescription errorDescription;
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            Trace.out((String)"No cluster networks found during Network configuration consistency.  Hence returning success");
            return true;
        }
        Set<NetworkInfo> matchingNetworks = null;
        HashSet<NetworkInfo> allUnavailablePrivateNetworks = new HashSet<NetworkInfo>();
        HashSet<NetworkInfo> allUnavailablePublicNetworks = new HashSet<NetworkInfo>();
        HashSet<String> failedNodesPrivate = new HashSet<String>();
        HashSet<String> failedNodesPublic = new HashSet<String>();
        ResultSet networksResultSet = new ResultSet();
        this.m_nodeNetworksMap = NetworkDataDiscovery.getNodeNetworksMap(this.m_nodeList, networksResultSet);
        if (!NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMap)) {
            Trace.out((String)"Could not discover the network details succesfully during network configuration consistency checks");
            NetworkUtility.reportResultSet(networksResultSet, this.m_resultSet, true);
            return false;
        }
        for (NetworkInfo network : clusterNetworks) {
            String networkName = network.getInterfaceName();
            String subnet = network.getSubnetAsString();
            for (String node : this.m_nodeList) {
                matchingNetworks = NetworkDataDiscovery.getNetworksBySubnetAndName(this.m_nodeNetworksMap, node, subnet, networkName);
                if (NetworkUtility.isNetworksSetGood(matchingNetworks)) continue;
                if (network.getNetworkType() == NetworkConstants.NetworkType.PUBLIC.getValue()) {
                    failedNodesPublic.add(node);
                    allUnavailablePublicNetworks.add(network);
                    continue;
                }
                if (network.getNetworkType() != NetworkConstants.NetworkType.PRIVATE.getValue()) continue;
                failedNodesPrivate.add(node);
                allUnavailablePrivateNetworks.add(network);
            }
        }
        String errorMessage = null;
        List<String> subnetList = NetworkDataDiscovery.getClusterNetworkSubnets(allUnavailablePublicNetworks);
        List<String> subnetMasksList = NetworkDataDiscovery.getClusterNetworkSubnetMasks(allUnavailablePublicNetworks);
        if (NetworkUtility.isNetworksSetGood(allUnavailablePublicNetworks)) {
            errorMessage = s_gMsgBundle.getMessage("12856", true, (Object[])new String[]{VerificationUtil.strList2List(subnetList), VerificationUtil.strList2List(subnetMasksList), VerificationUtil.strList2List(new ArrayList<String>(failedNodesPublic))});
            errorDescription = new ErrorDescription(errorMessage);
            ReportUtil.printError(errorMessage);
            this.m_resultSet.addErrorDescription(errorDescription);
            this.m_resultSet.addResult(failedNodesPublic.toArray(new String[0]), 3);
        }
        subnetList = NetworkDataDiscovery.getClusterNetworkSubnets(allUnavailablePrivateNetworks);
        subnetMasksList = NetworkDataDiscovery.getClusterNetworkSubnetMasks(allUnavailablePrivateNetworks);
        if (NetworkUtility.isNetworksSetGood(allUnavailablePrivateNetworks)) {
            errorMessage = s_gMsgBundle.getMessage("12855", true, (Object[])new String[]{VerificationUtil.strList2List(subnetList), VerificationUtil.strList2List(subnetMasksList), VerificationUtil.strList2List(new ArrayList<String>(failedNodesPrivate))});
            errorDescription = new ErrorDescription(errorMessage);
            ReportUtil.printError(errorMessage);
            this.m_resultSet.addErrorDescription(errorDescription);
            this.m_resultSet.addResult(failedNodesPrivate.toArray(new String[0]), 3);
        }
        if (errorMessage != null) {
            ReportUtil.printResult(s_gMsgBundle.getMessage("12853", false));
            return false;
        }
        Trace.out((String)"No mismatch found in current network configuration with the networks on nodes, All configured subnetworks are found on each of the cluster nodes.");
        this.m_resultSet.addResult(this.m_nodeList, 1);
        ReportUtil.printResult(s_gMsgBundle.getMessage("12854", false));
        return true;
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing Network Configuration checks..");
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("12852", false));
        try {
            Trace.out((String)("Getting the network configuration from source crs home (" + this.m_sourceHome + ")"));
            ResultSet networksResultSet = new ResultSet();
            Set<NetworkInfo> clusterNetworks = NetworkDataDiscovery.getClusterNetworks(m_localNode, networksResultSet);
            if (!NetworkUtility.isNetworksSetGood(clusterNetworks) || networksResultSet.anyFailure()) {
                Trace.out((String)"Could not fetch the cluster network details successfully during network configuration consistency checks");
                NetworkUtility.reportResultSet(networksResultSet, this.m_resultSet, true);
                return false;
            }
            return this.checkForNetworkExistenceOnAllNodes(clusterNetworks);
        }
        catch (Exception genericException) {
            Trace.out((String)"Error while getting cluster interfaces");
            Trace.out((String)("exception : " + genericException.getMessage()));
            String errorMessage = s_gMsgBundle.getMessage("12858", true);
            errorMessage = errorMessage + LSEP + genericException.getMessage();
            ReportUtil.sureprintln(errorMessage);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errorMessage);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("12851", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("12850", false);
    }

    @Override
    public String getTaskID() {
        return "NETWORK_CONSISTENCY_CHECKS";
    }
}

