/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.PidOrConfFileData;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.engine.task.TaskDaemonLiveliness;
import oracle.ops.verification.framework.engine.task.sTaskNTP;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.ServiceConfiguration;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskNTP
extends Task {
    final String NTP_SOURCE_QUERY_COMMAND = "/usr/sbin/ntpq -np";
    final String CHRONY_SOURCE_QUERY_COMMAND = "/usr/bin/chronyc sources";
    final String NAME_CHRONY_DAEMON = "chronyd";
    final String REFID_LOCAL_HOST = ".LOCL.";
    boolean m_preCheck = false;
    sTaskNTP s_sTaskNTP = null;
    String m_requestedRelease = null;
    boolean m_isNodeAdd = false;
    boolean m_isDBChecksEnabled = false;
    ResultStatus m_confFileResultStatus = ResultStatus.UNKNOWN;
    ResultStatus m_pidResultStatus = ResultStatus.UNKNOWN;
    Hashtable<String, String> m_foundConfFilesMap = null;
    Hashtable<String, String> m_foundPidFilesMap = null;
    boolean m_isLinux = VerificationUtil.isPlatformLinux();
    boolean m_ignorePTP;

    public TaskNTP(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        VerificationType vType = this.m_globalContext.getVerificationType();
        String reqRel = this.m_globalContext.getRequestedRelease();
        if (vType != null) {
            switch (vType) {
                case PREREQ_CRS_INST: 
                case BESTPRACTICE_PRE_CRS_INST: 
                case POSTREQ_CRS_INST: 
                case BESTPRACTICE_POSTREQ_CRS_INST: 
                case PREREQ_APPLICATION_CLUSTER_INST: 
                case POSTREQ_APPLICATION_CLUSTER_INST: {
                    if (reqRel == null || VerificationUtil.isVersionPost(reqRel, "11.2")) {
                        this.setPreCheck(true);
                    }
                    this.setRequestedRelease(reqRel);
                    break;
                }
                case PREREQ_NODE_ADD: {
                    this.setNodeList(VerificationUtil.addLocalNodeToNodeList(this.m_nodeList));
                    this.setAddNode();
                    break;
                }
                case PREREQ_DB_INST: {
                    if (VerificationUtil.isVersionPost(VerificationUtil.getCRSActiveVersion(), "11.2")) {
                        this.setPreCheck(true);
                    }
                    this.setEnableDBChecks();
                }
            }
        }
        this.s_sTaskNTP = new sTaskNTP(this);
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (VerificationType.PREREQ_CRS_INST.equals((Object)this.m_globalContext.getVerificationType()) && VerificationUtil.isBaselineCollectionMode()) {
            return false;
        }
        VerificationType vType = this.m_globalContext.getVerificationType();
        if (vType != null) {
            switch (vType) {
                case PREREQ_CRS_INST: 
                case BESTPRACTICE_PRE_CRS_INST: 
                case POSTREQ_CRS_INST: 
                case BESTPRACTICE_POSTREQ_CRS_INST: 
                case PREREQ_APPLICATION_CLUSTER_INST: 
                case POSTREQ_APPLICATION_CLUSTER_INST: 
                case PREREQ_NODE_ADD: {
                    return true;
                }
                case PREREQ_DB_INST: {
                    String actCRSVer = VerificationUtil.getCRSActiveVersion();
                    if (actCRSVer != null && VerificationUtil.isVersionPre(actCRSVer, "11.2")) {
                        VerificationUtil.traceAndLog("Source home crs version is Pre 11.2, adding NTP checks");
                        return true;
                    }
                    VerificationUtil.traceAndLog("Source home crs version could not be determined or is post 11.2, Not adding NTP checks");
                    return false;
                }
            }
        } else {
            VerificationUtil.traceAndLog("Verification Type is unknown, returning false");
        }
        return false;
    }

    public TaskNTP(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskNTP(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskNTP(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.s_sTaskNTP = new sTaskNTP(this);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("9601", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("9501", false);
    }

    @Override
    public boolean performTask() {
        this.m_confFileResultStatus = ResultStatus.UNKNOWN;
        this.m_pidResultStatus = ResultStatus.UNKNOWN;
        this.m_foundConfFilesMap = new Hashtable();
        this.m_foundPidFilesMap = new Hashtable();
        Trace.out((String)("Nodes (count = " + this.m_nodeList.length + ") = " + VerificationUtil.strArr2List(this.m_nodeList)));
        this.performNTPChecks();
        if (this.m_resultSet.allSuccess()) {
            Trace.out((String)"ResultSet shows all Success");
            ReportUtil.sureblankln();
            ReportUtil.printResult(s_msgBundle.getMessage("5400", false));
            ReportUtil.sureblankln();
            return true;
        }
        Trace.out((String)"ResultSet shows at least one failure");
        ReportUtil.printResult(s_msgBundle.getMessage("5401", false));
        ReportUtil.sureblankln();
        return false;
    }

    public void performNTPChecks() {
        boolean ret;
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("5422", false));
        boolean isConfFileExists = true;
        boolean isPidFileExists = true;
        boolean isDaemonRunning = true;
        Vector<PidOrConfFileData> pidVector = new Vector<PidOrConfFileData>();
        Vector<PidOrConfFileData> confVector = new Vector<PidOrConfFileData>();
        Vector<TaskDaemonLiveliness> aliveDaemonVector = new Vector<TaskDaemonLiveliness>();
        Vector<TaskDaemonLiveliness> notRunningDaemonVector = new Vector<TaskDaemonLiveliness>();
        ResultSet daemonRS = new ResultSet();
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        boolean isUnix = nativeSystem.isUnixSystem();
        if (isUnix) {
            isConfFileExists = this.peformAllConfigFileOrPidChecks(this.m_nodeList, confVector, true);
            Trace.out((String)("Return value from config file check is " + isConfFileExists));
            if (this.m_isLinux) {
                isPidFileExists = this.peformAllConfigFileOrPidChecks(this.m_nodeList, pidVector, false);
            }
            Trace.out((String)("Return value from pid file check is " + isPidFileExists));
        }
        ResultSet locrs = new ResultSet(1);
        Vector<String> dmnOkVec = new Vector<String>();
        boolean isGenericDaemonCheck = this.s_sTaskNTP.isGenericDaemonCheck(this.m_nodeList, locrs);
        this.m_resultSet.addResultSetData(locrs);
        if (!isGenericDaemonCheck || !locrs.allSuccess()) {
            if (locrs.allSuccess()) {
                Trace.out((String)"Skipping regular daemon check in solaris non-global zone");
                this.s_sTaskNTP.doSolarisNonGlobalZoneDaemonCheck(this.m_nodeList, locrs);
                this.m_resultSet.addResultSetData(locrs);
                return;
            }
            Trace.out((String)"failure in determining type of daemon check");
            return;
        }
        Trace.out((String)"Proceeding with Daemon check...");
        isDaemonRunning = !isUnix ? this.doServiceCheck(daemonRS, this.m_nodeList, dmnOkVec) : this.doDaemonCheck(daemonRS, this.m_nodeList, dmnOkVec, aliveDaemonVector, notRunningDaemonVector);
        Trace.out((String)("ret from doCheck=" + isDaemonRunning + "; dmnOkVec.size()=" + dmnOkVec.size() + "; dmnOkVec:: " + VerificationUtil.strVect2List(dmnOkVec)));
        Trace.out((String)("m_preCheck=" + this.m_preCheck + "; isConfFileExists=" + isConfFileExists + "; isPidFileExists=" + isPidFileExists));
        if (isUnix) {
            if (this.m_isLinux) {
                boolean isPTPconfigured = this.s_sTaskNTP.isPTPconfigured(confVector);
                boolean isPTPrunning = this.s_sTaskNTP.isPTPrunning(pidVector);
                boolean isNTPconfigured = this.s_sTaskNTP.isNTPconfigured(confVector);
                boolean isNTPrunning = this.s_sTaskNTP.isNTPrunning(pidVector);
                Trace.out((String)("isPTPconfigured=" + isPTPconfigured + "; isPTPrunning=" + isPTPrunning + "; isNTPconfigured=" + isNTPconfigured + "; isNTPrunning=" + isNTPrunning));
                this.m_ignorePTP = true;
                if (isPTPconfigured) {
                    if (isPTPrunning) {
                        this.m_ignorePTP = false;
                        this.displayAllConfigOrPidCheckResults(pidVector, false);
                        return;
                    }
                    if (!isNTPconfigured && !isNTPrunning) {
                        this.m_ignorePTP = false;
                        this.displayAllConfigOrPidCheckResults(confVector, true);
                        return;
                    }
                    if (isNTPconfigured && isNTPrunning) {
                        Trace.out((String)"PTP configured, not running; NTP configured & running; Go for NTP/Chrony check");
                    } else {
                        if (isNTPconfigured) {
                            this.m_ignorePTP = false;
                            this.displayAllConfigOrPidCheckResults(confVector, true);
                            return;
                        }
                        Trace.out((String)"PTP configured, not running; NTP configured, not running; Go for NTP/Chrony check");
                    }
                } else {
                    if (isPTPrunning) {
                        this.m_ignorePTP = false;
                        this.displayAllConfigOrPidCheckResults(pidVector, false);
                        return;
                    }
                    Trace.out((String)"PTP not configured, not running; Go for NTP/Chrony check");
                }
            }
            if (!(!this.m_preCheck && !this.m_isNodeAdd || isConfFileExists || this.m_isLinux && isPidFileExists || isDaemonRunning)) {
                Trace.out((String)"PreCheck flag set. Setting overall status to SUCCESSFUL");
                this.displayAllConfigOrPidCheckResults(confVector, true);
                if (this.m_isLinux) {
                    this.displayAllConfigOrPidCheckResults(pidVector, false);
                }
                ReportUtil.println(s_msgBundle.getMessage("5428", false));
                this.m_resultSet.addResult(this.m_nodeList, 1);
                return;
            }
            if ((isConfFileExists || this.m_isLinux && isPidFileExists) && isDaemonRunning) {
                Trace.out((String)"Daemon is running on all the nodes. pid/conf file exist on all nodes");
                if (isConfFileExists) {
                    this.displayAllConfigOrPidCheckResults(confVector, true);
                }
                if (this.m_isLinux && isPidFileExists) {
                    this.displayAllConfigOrPidCheckResults(pidVector, false);
                }
                this.displayDaemonCheckResults(daemonRS, this.m_nodeList, aliveDaemonVector, notRunningDaemonVector);
                ReportUtil.sureprintln(s_msgBundle.getMessage("5491", false));
                this.m_resultSet.uploadResultSet(daemonRS);
            } else if (isDaemonRunning) {
                ResultSet rs;
                boolean isAnySuccess = false;
                boolean isShowConfigResults = false;
                boolean isShowPidResults = false;
                Trace.out((String)"Daemon is running on all nodes but conf/pid doesn't exist on all nodes");
                for (PidOrConfFileData fileData : confVector) {
                    rs = fileData.getResultSet();
                    if (!rs.anySuccess()) continue;
                    isShowConfigResults = true;
                    break;
                }
                if (isShowConfigResults) {
                    isAnySuccess = true;
                    this.displayAllConfigOrPidCheckResults(confVector, true);
                }
                if (this.m_isLinux) {
                    for (PidOrConfFileData fileData : pidVector) {
                        rs = fileData.getResultSet();
                        if (!rs.anySuccess()) continue;
                        isShowPidResults = true;
                        break;
                    }
                }
                if (isShowPidResults) {
                    isAnySuccess = true;
                    this.displayAllConfigOrPidCheckResults(pidVector, false);
                }
                this.displayDaemonCheckResults(daemonRS, this.m_nodeList, aliveDaemonVector, notRunningDaemonVector);
                if (!isAnySuccess && this.m_isLinux) {
                    this.displayNoConfigDaemons(this.m_nodeList, aliveDaemonVector);
                }
            } else {
                this.displayAllConfigOrPidCheckResults(confVector, true);
                if (this.m_isLinux) {
                    this.displayAllConfigOrPidCheckResults(pidVector, false);
                }
                this.displayDaemonCheckResults(daemonRS, this.m_nodeList, aliveDaemonVector, notRunningDaemonVector);
                this.displayConfigAndDaemonResults(this.m_nodeList, confVector, pidVector, aliveDaemonVector);
                if (aliveDaemonVector.size() == 0) {
                    Trace.out((String)"ntpd not running on any nodes. No further checks required");
                    return;
                }
            }
        } else {
            if (!isDaemonRunning) {
                if (this.m_preCheck) {
                    if (daemonRS.allSuccess()) {
                        Trace.out((String)"PreCheck flag set. No daemon is running. Setting overall status to SUCCESSFUL");
                        String successMsg = s_msgBundle.getMessage("5428", false);
                        ReportUtil.sureprintln(successMsg);
                        this.m_resultSet.addResult(this.m_nodeList, 1);
                    } else {
                        this.m_resultSet.addResult(this.m_nodeList, 3);
                    }
                } else {
                    Trace.out((String)"PostCheck set. No service is running. Setting overall status to VERIFICATION_FAILED.");
                    this.m_resultSet.addResult(this.m_nodeList, 3);
                }
            } else {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5491", false));
                Trace.out((String)"service is running on all the nodes.");
            }
            this.m_resultSet.addResultSetData(daemonRS);
            return;
        }
        Trace.out((String)"NTP Daemon or Service is alive. Proceeding with further checks.");
        locrs.clear();
        String version = null;
        if (this.m_preCheck) {
            version = this.m_requestedRelease;
        }
        if (!VerificationUtil.isStringGood(version)) {
            String localNode = null;
            try {
                localNode = VerificationUtil.getLocalNodename();
            }
            catch (NodelistNotFoundException nlnfe) {
                Trace.out((String)"Caught NodelistNotFoundException - Failed to determine the local node name");
            }
            if (VerificationUtil.isStringGood(localNode)) {
                version = VerificationUtil.getCRSReleaseVersion(localNode);
            }
        }
        if (aliveDaemonVector.size() == 1 && !this.isChronyDaemon(aliveDaemonVector.get(0).getDaemonName()) && (this.m_isDBChecksEnabled || VerificationUtil.isStringGood(version) && !VerificationUtil.isVersionPost(version, "11.2")) && !(ret = this.performSlewingCheck(locrs, dmnOkVec))) {
            return;
        }
        ret = this.doPortOpenCheck(locrs, dmnOkVec);
        Trace.out((String)("ret from doPortOpenCheck=" + ret + "; dmnOkVec.size()=" + dmnOkVec.size() + "; dmnOkVec:: " + VerificationUtil.strVect2List(dmnOkVec)));
        this.m_resultSet.uploadResultSet(locrs);
        locrs.clear();
        if (!ret) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5486", true));
            return;
        }
        if (aliveDaemonVector.size() != 1) {
            Trace.out((String)"zero or more than one ntpd running on nodes. No further checks required");
            return;
        }
        if (this.m_isLinux && this.isChronyDaemon(aliveDaemonVector.get(0).getDaemonName())) {
            this.doChronyTimeSourceCheck(locrs, dmnOkVec);
            String taskName = s_gMsgBundle.getMessage("13607", false);
            TaskAnonymousProxy anonTask = new TaskAnonymousProxy(taskName, dmnOkVec.toArray(new String[dmnOkVec.size()]), this);
            anonTask.performAnonymousTask(locrs);
            this.m_resultSet.uploadResultSet(locrs);
            return;
        }
        if (!this.s_sTaskNTP.isNTPQSupported()) {
            return;
        }
        this.doNTPTimeSourceCheck(locrs, dmnOkVec);
        String taskName = s_gMsgBundle.getMessage("13603", false);
        TaskAnonymousProxy anonTask = new TaskAnonymousProxy(taskName, dmnOkVec.toArray(new String[dmnOkVec.size()]), this);
        anonTask.performAnonymousTask(locrs);
        this.m_resultSet.uploadResultSet(locrs);
    }

    private boolean performSlewingCheck(ResultSet locrs, Vector<String> dmnOkVec) {
        boolean ret = this.doSlewingCheck(locrs, dmnOkVec);
        Trace.out((String)("ret from doSlewingCheck=" + ret + "; dmnOkVec.size()=" + dmnOkVec.size() + "; dmnOkVec:: " + VerificationUtil.strVect2List(dmnOkVec)));
        this.m_resultSet.uploadResultSet(locrs);
        locrs.clear();
        if (!VerificationUtil.isPlatformSolaris()) {
            Trace.out((String)("ret from doSlewingSysConfigCheck=" + (ret &= this.doSlewingSysConfigCheck(locrs, dmnOkVec)) + "; dmnOkVec.size()=" + dmnOkVec.size() + "; dmnOkVec:: " + VerificationUtil.strVect2List(dmnOkVec)));
            this.m_resultSet.uploadResultSet(locrs);
            locrs.clear();
        }
        return ret;
    }

    private boolean peformAllConfigFileOrPidChecks(String[] nList, Vector<PidOrConfFileData> pidOrConfDataVector, boolean isConfigCheck) {
        List<String> pidOrConfFileList = isConfigCheck ? this.s_sTaskNTP.getNTPConfigFile() : this.s_sTaskNTP.getDaemonPidFilePath();
        boolean ret = false;
        for (String pidOrConfFile : pidOrConfFileList) {
            Trace.out((String)("status of file " + pidOrConfFile + " is " + (ret |= this.doConfigFileOrPidCheck(nList, pidOrConfFile, pidOrConfDataVector, isConfigCheck))));
        }
        return ret;
    }

    private boolean doConfigFileOrPidCheck(String[] nList, String fileLoc, Vector<PidOrConfFileData> fileDataVector, boolean isConfCheck) {
        ResultStatus successStatus;
        ReportUtil.blankln();
        TaskAnonymousProxy anonymousTask = new TaskAnonymousProxy("'" + fileLoc + "'", nList);
        anonymousTask.setChildTaskLevel(this.getChildTaskLevel() + 1);
        Vector<String> confokVec = new Vector<String>();
        Vector<String> noConfVec = new Vector<String>();
        Vector<String> notRunVec = new Vector<String>();
        ResultSet locrs = new ResultSet();
        Task previousTaskReference = ReportUtil.setTaskReference(anonymousTask);
        ReportUtil.println(s_gMsgBundle.getMessage("1022", false, (Object[])new String[]{fileLoc}));
        Trace.out((String)("Checking availability of NTP config file " + fileLoc + " on all nodes."));
        GlobalExecution globalExec = new GlobalExecution();
        boolean ret = true;
        globalExec.checkFileExistence(nList, fileLoc, locrs);
        Hashtable cfresultHT = locrs.getResultTable();
        Enumeration e = cfresultHT.keys();
        if (ReportUtil.isVerbose()) {
            ReportUtil.reportwriteColHeaders(s_msgBundle.getMessage("8000", false), s_gMsgBundle.getMessage("0404", false));
        }
        if (ReportUtil.getOldFormat()) {
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_gMsgBundle.getMessage("0404", false));
        }
        while (e.hasMoreElements()) {
            String curNode = (String)e.nextElement();
            String fileExists = ReportUtil.NO;
            Trace.out((String)("Analyzing NTP config file chk result for node " + curNode));
            Result result = (Result)cfresultHT.get(curNode);
            if (result != null && 3 == result.getStatus()) {
                Trace.out((String)("configuration file is missing on node " + curNode));
                noConfVec.add(curNode);
                ret &= false;
            } else if (result == null || 1 != result.getStatus()) {
                VerificationUtil.traceAndLog("NTP config file chk did not run on node " + curNode);
                notRunVec.add(curNode);
                ret &= false;
            } else if (result != null && 1 == result.getStatus()) {
                Trace.out((String)("NTP config file found on node " + curNode));
                fileExists = ReportUtil.YES;
                confokVec.add(curNode);
            }
            if (ReportUtil.getOldFormat()) {
                ReportUtil.writeRecord(curNode, fileExists);
            }
            if (!ReportUtil.isVerbose()) continue;
            ReportUtil.reportwriteRecord(curNode, fileExists);
        }
        PidOrConfFileData pidOrConfFileData = new PidOrConfFileData(fileLoc, nList, confokVec, noConfVec, notRunVec, locrs, anonymousTask);
        if (this.m_isLinux) {
            pidOrConfFileData.setIsPTPfile(this.s_sTaskNTP.isPTPfile(fileLoc));
        }
        fileDataVector.add(pidOrConfFileData);
        ReportUtil.setTaskReference(previousTaskReference);
        boolean isAddToFoundMap = false;
        if (locrs.allSuccess()) {
            successStatus = ResultStatus.ALL_SUCCESS;
            isAddToFoundMap = true;
        } else if (locrs.anySuccess()) {
            successStatus = ResultStatus.PARTIAL_SUCCESS;
            isAddToFoundMap = true;
        } else {
            successStatus = ResultStatus.ALL_FAILURE;
        }
        if (isConfCheck) {
            if (this.m_confFileResultStatus.ordinal() > successStatus.ordinal()) {
                this.m_confFileResultStatus = successStatus;
            }
            if (isAddToFoundMap) {
                this.m_foundConfFilesMap.put(fileLoc, VerificationUtil.strCollection2String(confokVec));
            }
        } else {
            if (this.m_pidResultStatus.ordinal() > successStatus.ordinal()) {
                this.m_pidResultStatus = successStatus;
            }
            if (isAddToFoundMap) {
                this.m_foundPidFilesMap.put(fileLoc, VerificationUtil.strCollection2String(confokVec));
            }
        }
        return ret;
    }

    private void displayAllConfigOrPidCheckResults(Vector<PidOrConfFileData> pidOrConfVector, boolean isConfFileCheck) {
        Hashtable<String, String> foundPidOrConfFilesMap;
        ResultStatus successStatus;
        if (isConfFileCheck) {
            successStatus = this.m_confFileResultStatus;
            foundPidOrConfFilesMap = this.m_foundConfFilesMap;
        } else {
            successStatus = this.m_pidResultStatus;
            foundPidOrConfFilesMap = this.m_foundPidFilesMap;
        }
        if (!isConfFileCheck && foundPidOrConfFilesMap.size() > 1) {
            String errMsg = s_gMsgBundle.getMessage("1063", true);
            Set<String> foundPidOrConfFilesSet = foundPidOrConfFilesMap.keySet();
            for (String foundPidOrConfFile : foundPidOrConfFilesSet) {
                errMsg = errMsg + LSEP + s_gMsgBundle.getMessage("1064", false, (Object[])new String[]{foundPidOrConfFile, foundPidOrConfFilesMap.get(foundPidOrConfFile)});
            }
            this.m_resultSet.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(errMsg);
        }
        block5: for (PidOrConfFileData dataItem : pidOrConfVector) {
            if (this.m_isLinux && this.m_ignorePTP && dataItem.isPTPfile()) continue;
            ResultSet locrs = dataItem.getResultSet();
            Vector<String> confokVec = dataItem.getConfokVector();
            String fileLoc = dataItem.getPidOrConfFileName();
            Vector<String> notRunVec = dataItem.getNotRunVector();
            TaskAnonymousProxy anonymousTask = dataItem.getAnonymousTask();
            switch (successStatus) {
                case ALL_SUCCESS: {
                    if (!locrs.allSuccess() && notRunVec.isEmpty()) continue block5;
                    this.addChildTask(anonymousTask);
                    break;
                }
                case PARTIAL_SUCCESS: {
                    if (!locrs.anySuccess()) {
                        Trace.out((String)("Skipping no success results for file location" + fileLoc + " because there are others with partial" + " successes"));
                        if (notRunVec.isEmpty()) continue block5;
                    }
                    this.addChildTask(anonymousTask);
                    break;
                }
                default: {
                    this.addChildTask(anonymousTask);
                }
            }
            Vector<String> noConfVec = dataItem.getNoConfVector();
            String[] nList = dataItem.getNodeList();
            this.displayPidOrConfigFileCheckResult(locrs, anonymousTask, confokVec, noConfVec, notRunVec, nList, fileLoc);
        }
    }

    private void displayPidOrConfigFileCheckResult(ResultSet locrs, TaskAnonymousProxy anonymousTask, Vector<String> confokVec, Vector<String> noConfVec, Vector<String> notRunVec, String[] nList, String fileLoc) {
        Vector<String> noConfMsgVec = new Vector<String>();
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (this.m_isNodeAdd) {
            this.displayConfigFileCheckAddNodeFailure(locrs, fileLoc, confokVec, noConfMsgVec, noConfVec, notRunVec);
            anonymousTask.performAnonymousTask(locrs);
            this.m_resultSet.uploadResultSet(locrs);
            return;
        }
        if (confokVec.isEmpty() && notRunVec.isEmpty() && this.m_preCheck) {
            Trace.out((String)"pre check NTP conf doesn't exist on all nodes");
            locrs.clear();
            locrs.addResult(nList, 1);
            anonymousTask.performAnonymousTask(locrs);
            anonymousTask.getResultSet().traceResultSet("AnonymousTask status ==>");
            this.m_resultSet.uploadResultSet(locrs);
            return;
        }
        if (notRunVec.isEmpty() && noConfVec.isEmpty()) {
            locrs.addResult(confokVec, 1);
            ReportUtil.println(s_msgBundle.getMessage("5404", false, (Object[])new String[]{fileLoc}));
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1023", false, (Object[])new String[]{fileLoc}));
        } else if (confokVec.isEmpty() && (notRunVec.size() == nList.length || noConfVec.size() == nList.length)) {
            Trace.out((String)"config file doesn't exist on all nodes");
            locrs.clear();
            locrs.addResult(this.m_nodeList, 4);
            String errMsg = s_gMsgBundle.getMessage("1019", true, (Object[])new String[]{fileLoc, VerificationUtil.strArr2List(this.m_nodeList)});
            ReportUtil.sureprintln(errMsg);
            locrs.addErrorDescription(new ErrorDescription(errMsg));
            errorMessages.add(errMsg);
        } else {
            String errMsg;
            if (!noConfVec.isEmpty()) {
                errMsg = s_gMsgBundle.getMessage("1019", true, (Object[])new String[]{fileLoc, VerificationUtil.strVect2List(noConfVec)});
                locrs.addResult(noConfVec, 3);
                locrs.addErrorDescription(noConfVec, new ErrorDescription(errMsg));
                errorMessages.add(errMsg);
            }
            if (!notRunVec.isEmpty()) {
                errMsg = s_gMsgBundle.getMessage("1020", true, (Object[])new String[]{fileLoc, VerificationUtil.strVect2List(notRunVec)});
                locrs.addResult(notRunVec, 2);
                locrs.addErrorDescription(notRunVec, new ErrorDescription(errMsg));
                errorMessages.add(errMsg);
            }
        }
        ReportUtil.reportErrors(errorMessages);
        anonymousTask.performAnonymousTask(locrs);
        this.m_resultSet.uploadResultSet(locrs);
    }

    private void displayConfigFileCheckAddNodeFailure(ResultSet locrs, String fileLoc, Vector<String> confokVec, Vector<String> noConfMsgVec, Vector<String> noConfVec, Vector<String> notRunVec) {
        String errMsg;
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (VerificationUtil.inVectorIgnoreCase(confokVec, m_localNode)) {
            if (notRunVec.isEmpty() && noConfVec.isEmpty()) {
                locrs.addResult(confokVec, 1);
                ReportUtil.println(s_msgBundle.getMessage("5404", false, (Object[])new String[]{fileLoc}));
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("1023", false, (Object[])new String[]{fileLoc}));
            } else {
                if (!noConfVec.isEmpty()) {
                    errMsg = s_gMsgBundle.getMessage("1019", true, (Object[])new String[]{fileLoc, VerificationUtil.strVect2List(noConfVec)});
                    locrs.addResult(noConfVec, 3);
                    locrs.addErrorDescription(noConfVec, new ErrorDescription(errMsg));
                    errorMessages.add(errMsg);
                }
                if (!notRunVec.isEmpty()) {
                    errMsg = s_gMsgBundle.getMessage("1020", true, (Object[])new String[]{fileLoc, VerificationUtil.strVect2List(notRunVec)});
                    locrs.addResult(notRunVec, 2);
                    locrs.addErrorDescription(notRunVec, new ErrorDescription(errMsg));
                    errorMessages.add(errMsg);
                }
            }
        }
        if (VerificationUtil.inVectorIgnoreCase(noConfVec, m_localNode)) {
            if (!confokVec.isEmpty()) {
                errMsg = s_gMsgBundle.getMessage("1021", true, (Object[])new String[]{fileLoc, VerificationUtil.strVect2List(confokVec)});
                locrs.addErrorDescription(confokVec, new ErrorDescription(errMsg));
                locrs.addResult(confokVec, 3);
                errorMessages.add(errMsg);
            } else {
                locrs.clear();
                locrs.addResult(this.m_nodeList, 1);
            }
            if (!notRunVec.isEmpty()) {
                errMsg = s_gMsgBundle.getMessage("1020", true, (Object[])new String[]{fileLoc, VerificationUtil.strVect2List(notRunVec)});
                locrs.addResult(notRunVec, 2);
                locrs.addErrorDescription(notRunVec, new ErrorDescription(errMsg));
                errorMessages.add(errMsg);
            }
        }
        if (VerificationUtil.inVectorIgnoreCase(notRunVec, m_localNode)) {
            errMsg = s_gMsgBundle.getMessage("1020", true, (Object[])new String[]{fileLoc, VerificationUtil.strVect2List(notRunVec)});
            locrs.addResult(notRunVec, 2);
            locrs.addErrorDescription(notRunVec, new ErrorDescription(errMsg));
            errorMessages.add(errMsg);
        }
        ReportUtil.reportErrors(errorMessages);
    }

    private boolean doServiceCheck(ResultSet locrs, String[] nlist, Vector<String> srvcOkVec) {
        String[] nodesArray;
        ErrorDescription errorDesc;
        List<String> srvcNames = this.s_sTaskNTP.getNTPDaemonNames();
        boolean ret = true;
        HashMap<String, ResultSet> existServiceResultMap = new HashMap<String, ResultSet>();
        GlobalExecution globalExec = new GlobalExecution();
        for (String srvcName : srvcNames) {
            ResultSet srvcExistResult = new ResultSet();
            globalExec.checkService(nlist, srvcName, srvcExistResult);
            if (!srvcExistResult.anySuccess()) continue;
            Trace.out((String)(srvcName + " exists on some nodes"));
            existServiceResultMap.put(srvcName, srvcExistResult);
        }
        HashMap<String, ResultSet> runningServiceMap = new HashMap<String, ResultSet>();
        HashMap<String, ResultSet> notRunningServiceMap = new HashMap<String, ResultSet>();
        HashMap runningServiceNodesMap = new HashMap();
        HashMap notRunningServiceNodesMap = new HashMap();
        HashMap operationFailedRunningServiceNodesMap = new HashMap();
        for (Map.Entry entry : existServiceResultMap.entrySet()) {
            String srvcName = (String)entry.getKey();
            ResultSet srvcRunningResult = (ResultSet)entry.getValue();
            Iterator runningServiceNodes = new ArrayList();
            ArrayList<String> notRunningServiceNodes = new ArrayList<String>();
            ArrayList<String> operationFailedRunningServiceNodes = new ArrayList<String>();
            Trace.out((String)("Checking if service is running on any node : " + srvcName));
            Hashtable ht = srvcRunningResult.getResultTable();
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                String node = (String)e.nextElement();
                Result result = (Result)ht.get(node);
                Vector servList = result.getResultInfoSet();
                if (result.getStatus() == 1) {
                    if (servList.contains((Object)ServiceConfiguration.ServiceRunning)) {
                        runningServiceNodes.add((String)node);
                        continue;
                    }
                    notRunningServiceNodes.add(node);
                    continue;
                }
                operationFailedRunningServiceNodes.add(node);
            }
            if (runningServiceNodes.size() > 0) {
                runningServiceMap.put(srvcName, srvcRunningResult);
            } else {
                notRunningServiceMap.put(srvcName, srvcRunningResult);
            }
            runningServiceNodesMap.put(srvcName, runningServiceNodes);
            notRunningServiceNodesMap.put(srvcName, notRunningServiceNodes);
            operationFailedRunningServiceNodesMap.put(srvcName, operationFailedRunningServiceNodes);
        }
        ArrayList<String> failureMsg = new ArrayList<String>();
        TaskAnonymousProxy serviceRunningTask = null;
        String errmsg = null;
        if (runningServiceMap.size() > 1 && !this.s_sTaskNTP.canServicesCoexist(runningServiceMap.keySet())) {
            errmsg = s_gMsgBundle.getMessage("10403", true);
            errorDesc = new ErrorDescription(errmsg);
            locrs.addResult(nlist, 3);
            locrs.addErrorDescription(nlist, errorDesc);
            failureMsg.add(errmsg);
            for (String srvcName : runningServiceNodesMap.keySet()) {
                ResultSet finalResultsByService = new ResultSet();
                Trace.out((String)(srvcName + " is running on some nodes"));
                String srvcRunningNodes = VerificationUtil.strList2List((List)runningServiceNodesMap.get(srvcName));
                String[] srvcRunningNodesArray = VerificationUtil.string2strArr(srvcRunningNodes);
                errmsg = s_gMsgBundle.getMessage("10410", false, (Object[])new String[]{srvcName, srvcRunningNodes});
                failureMsg.add(errmsg);
                ErrorDescription errorDescRunningNodes = new ErrorDescription(errmsg);
                finalResultsByService.addErrorDescription(srvcRunningNodesArray, errorDescRunningNodes);
                finalResultsByService.addResult(srvcRunningNodesArray, 3);
                serviceRunningTask = new TaskAnonymousProxy(s_gMsgBundle.getMessage("10406", false, (Object[])new String[]{srvcName}), nlist, this);
                serviceRunningTask.performAnonymousTask(finalResultsByService);
            }
            ret = false;
        } else if (runningServiceMap.size() == 0) {
            VerificationUtil.traceAndLog("no network time services found running on any node");
            if (this.m_preCheck) {
                errmsg = s_msgBundle.getMessage("5496", false);
                failureMsg.add(errmsg);
                locrs.addResult(nlist, 1);
                ret = false;
            } else {
                errmsg = s_gMsgBundle.getMessage("10408", true);
                failureMsg.add(errmsg);
                errorDesc = new ErrorDescription(errmsg);
                locrs.addErrorDescription(errorDesc);
                locrs.addResult(nlist, 3);
                for (Map.Entry entry : notRunningServiceMap.entrySet()) {
                    String srvcName = (String)entry.getKey();
                    ResultSet noSrvcRunningResult = new ResultSet();
                    List notRunningServiceNodes = (List)notRunningServiceNodesMap.get(srvcName);
                    notRunningServiceNodes.addAll((Collection)operationFailedRunningServiceNodesMap.get(srvcName));
                    String[] nRunningList = notRunningServiceNodes.toArray(new String[notRunningServiceNodes.size()]);
                    String nodes = VerificationUtil.strCollection2String(notRunningServiceNodes);
                    errmsg = s_gMsgBundle.getMessage("10404", false, (Object[])new String[]{srvcName, nodes});
                    failureMsg.add(errmsg);
                    nodesArray = VerificationUtil.string2strArr(nodes);
                    ErrorDescription errorDescSrvcNotRunning = new ErrorDescription(errmsg);
                    noSrvcRunningResult.addErrorDescription(errorDescSrvcNotRunning);
                    noSrvcRunningResult.addResult(nodesArray, 3);
                    serviceRunningTask = new TaskAnonymousProxy(s_gMsgBundle.getMessage("10406", false, (Object[])new String[]{srvcName}), nRunningList, this, noSrvcRunningResult);
                    serviceRunningTask.performAnonymousTask(noSrvcRunningResult);
                }
                ret = false;
            }
        } else {
            for (String srvcName : runningServiceMap.keySet()) {
                ResultSet srvcRunningResult = (ResultSet)runningServiceMap.get(srvcName);
                ResultSet srvcRunningFinalRS = new ResultSet();
                VerificationUtil.traceAndLog("service found, check if is running in all nodes: " + srvcName);
                List notRunningServiceNodes = (List)notRunningServiceNodesMap.get(srvcName);
                if (srvcRunningResult.allSuccess() && notRunningServiceNodes.size() == 0) {
                    VerificationUtil.traceAndLog("Service running on all nodes");
                    srvcRunningFinalRS.addResult(nlist, 1);
                    serviceRunningTask = new TaskAnonymousProxy(s_gMsgBundle.getMessage("10406", false, (Object[])new String[]{srvcName}), nlist, this, srvcRunningFinalRS);
                    serviceRunningTask.performAnonymousTask(srvcRunningFinalRS);
                    for (String node : (List)runningServiceNodesMap.get(srvcName)) {
                        if (srvcOkVec.contains(node)) continue;
                        srvcOkVec.add(node);
                    }
                    ret = true;
                } else {
                    List operationFailedRunningServiceNodes;
                    VerificationUtil.traceAndLog("Service not running on all nodes");
                    ArrayList allFailedNodes = new ArrayList();
                    if (notRunningServiceNodes.size() > 0) {
                        allFailedNodes.addAll(notRunningServiceNodes);
                        String nodes = VerificationUtil.strCollection2String(notRunningServiceNodes);
                        errmsg = s_gMsgBundle.getMessage("10404", true, (Object[])new String[]{srvcName, nodes});
                        failureMsg.add(errmsg);
                        ErrorDescription errorDescSrvcNotRunning = new ErrorDescription(errmsg);
                        srvcRunningFinalRS.addErrorDescription(errorDescSrvcNotRunning);
                        nodesArray = VerificationUtil.string2strArr(nodes);
                        srvcRunningFinalRS.addResult(nodesArray, 3);
                    }
                    if ((operationFailedRunningServiceNodes = (List)operationFailedRunningServiceNodesMap.get(srvcName)).size() > 0) {
                        ArrayList<String> serviceNotExistNodes = new ArrayList<String>();
                        ArrayList<String> otherOprFailedNodes = new ArrayList<String>();
                        for (String node : operationFailedRunningServiceNodes) {
                            Result nodeResult = srvcRunningResult.getResult(node);
                            Trace.out((String)("checkservice command execution failed on node " + node));
                            StringBuilder errString = new StringBuilder();
                            List<VerificationError> errList = nodeResult.getErrors();
                            for (VerificationError err : errList) {
                                errString.append(err.getErrorMessage());
                                errString.append(VerificationConstants.LSEP);
                            }
                            failureMsg.add(errString.toString());
                            if (errString.indexOf("1060") != -1) {
                                Trace.out((String)("The network time synchronization service " + srvcName + " does not exist"));
                                serviceNotExistNodes.add(node);
                                continue;
                            }
                            Trace.out((String)("The command exectask -checkservice " + srvcName + ", has failed on node " + node + " with error " + errString.toString()));
                            otherOprFailedNodes.add(node);
                            srvcRunningFinalRS.addResult(node, nodeResult);
                        }
                        if (otherOprFailedNodes.size() > 0) {
                            allFailedNodes.addAll(otherOprFailedNodes);
                            String nodesOprFailed = VerificationUtil.strCollection2String(otherOprFailedNodes);
                            String[] nodesArrayOprFailed = VerificationUtil.string2strArr(nodesOprFailed);
                            errmsg = s_gMsgBundle.getMessage("10405", true, (Object[])new String[]{srvcName, nodesOprFailed});
                            failureMsg.add(errmsg);
                            ErrorDescription errorDescOprFailed = new ErrorDescription(errmsg);
                            srvcRunningFinalRS.addErrorDescription(errorDescOprFailed);
                            srvcRunningFinalRS.addResult(nodesArrayOprFailed, 2);
                        }
                        if (serviceNotExistNodes.size() > 0) {
                            allFailedNodes.addAll(serviceNotExistNodes);
                            String nodesSrvcNotExist = VerificationUtil.strCollection2String(serviceNotExistNodes);
                            String[] nodesArraySrvcNotExists = VerificationUtil.string2strArr(nodesSrvcNotExist);
                            errmsg = s_gMsgBundle.getMessage("10409", true, (Object[])new String[]{srvcName, nodesSrvcNotExist});
                            failureMsg.add(errmsg);
                            ErrorDescription errorDescSrvcNotExists = new ErrorDescription(errmsg);
                            srvcRunningFinalRS.addErrorDescription(errorDescSrvcNotExists);
                            srvcRunningFinalRS.addResult(nodesArraySrvcNotExists, 2);
                        }
                    }
                    String[] failedNodes = allFailedNodes.toArray(new String[allFailedNodes.size()]);
                    serviceRunningTask = new TaskAnonymousProxy(s_gMsgBundle.getMessage("10406", false, (Object[])new String[]{srvcName}), failedNodes, this, srvcRunningFinalRS);
                    serviceRunningTask.performAnonymousTask(srvcRunningFinalRS);
                    ret = false;
                }
                if (srvcOkVec.size() <= 0) continue;
                VerificationUtil.traceAndLog("Check settings in windows registry for service %s ...", srvcName);
                ret = this.s_sTaskNTP.doCheckRegistryKeys(srvcName, srvcOkVec, srvcOkVec.toArray(new String[0]));
            }
        }
        if (failureMsg.size() > 0) {
            ReportUtil.reportErrors(failureMsg);
            VerificationUtil.traceAndLog(VerificationUtil.strList2List(failureMsg));
        }
        return ret;
    }

    private boolean doDaemonCheck(ResultSet locrs, String[] nlist, Vector<String> dmnOkVec, Vector<TaskDaemonLiveliness> aliveDaemonVector, Vector<TaskDaemonLiveliness> notRunningDaemonVector) {
        List<String> dmnNames = this.s_sTaskNTP.getNTPDaemonNames();
        Trace.out((String)("dmnNames: '" + VerificationUtil.strList2List(dmnNames) + "'"));
        this.executeDaemonLiveliness(dmnNames, nlist, dmnOkVec, aliveDaemonVector, notRunningDaemonVector);
        if (aliveDaemonVector.size() == 1) {
            TaskDaemonLiveliness taskDaemonIter = aliveDaemonVector.get(0);
            ResultSet dmnResult = taskDaemonIter.getResultSet();
            return dmnResult.allSuccess();
        }
        return false;
    }

    private boolean displayDaemonCheckResults(ResultSet locrs, String[] nlist, Vector<TaskDaemonLiveliness> aliveDaemonVector, Vector<TaskDaemonLiveliness> notRunningDaemonVector) {
        if (aliveDaemonVector.size() > 1) {
            VerificationUtil.traceAndLog("more than one daemon is running");
            String errmsg = s_msgBundle.getMessage("5499", true);
            for (TaskDaemonLiveliness taskDaemonIter : aliveDaemonVector) {
                String dmnName = taskDaemonIter.getDaemonName();
                Trace.out((String)(dmnName + " is running on some nodes"));
                ResultSet dmnResult = taskDaemonIter.getResultSet();
                String[] dmnRunningNodes = dmnResult.getSuccNodes();
                errmsg = errmsg + LSEP + s_msgBundle.getMessage("5469", false, (Object[])new String[]{dmnName, VerificationUtil.strArr2List(dmnRunningNodes)});
                Trace.out((String)"printing daemon check messages");
                if (ReportUtil.isVerbose()) {
                    taskDaemonIter.displayDaemonCheckStartMessage();
                }
                TaskAnonymousProxy anonymousProxy = new TaskAnonymousProxy(taskDaemonIter.getElementName(), this.m_nodeList, this);
                taskDaemonIter.displayDaemonLivelinessOutput(dmnResult, false, anonymousProxy);
                anonymousProxy.performAnonymousTask(dmnResult);
            }
            ErrorDescription errorDesc = new ErrorDescription(errmsg);
            locrs.addResult(this.m_nodeList, 3);
            locrs.addErrorDescription(errorDesc);
            this.m_resultSet.uploadResultSet(locrs);
            ReportUtil.sureprintln(errmsg);
            return false;
        }
        if (aliveDaemonVector.size() == 0) {
            VerificationUtil.traceAndLog("NTPD's not found on any node by pid based daemon check");
            boolean retVal = false;
            if (this.m_preCheck || this.m_isNodeAdd) {
                String errMsg = s_msgBundle.getMessage("5496", false);
                ReportUtil.printError(errMsg);
                locrs.addResult(this.m_nodeList, 3);
            } else {
                String errmsg = s_gMsgBundle.getMessage("1024", true);
                ErrorDescription errorDesc = new ErrorDescription(errmsg);
                for (TaskDaemonLiveliness taskDaemonIter : notRunningDaemonVector) {
                    Trace.out((String)"printing daemon check messages");
                    ResultSet dmnResult = taskDaemonIter.getResultSet();
                    if (ReportUtil.isVerbose()) {
                        taskDaemonIter.displayDaemonCheckStartMessage();
                    }
                    TaskAnonymousProxy anonymousProxy = new TaskAnonymousProxy(taskDaemonIter.getElementName(), this.m_nodeList, this);
                    taskDaemonIter.displayDaemonLivelinessOutput(dmnResult, false, anonymousProxy);
                    dmnResult.addResult(this.m_nodeList, 3);
                    dmnResult.addErrorDescription(errorDesc);
                    anonymousProxy.performAnonymousTask(dmnResult);
                }
                ReportUtil.printError(errmsg);
                locrs.addResult(this.m_nodeList, 3);
                locrs.addErrorDescription(errorDesc);
            }
            this.m_resultSet.uploadResultSet(locrs);
            return retVal;
        }
        TaskDaemonLiveliness taskDaemonIter = aliveDaemonVector.get(0);
        Trace.out((String)"printing daemon check messages");
        ResultSet dmnResult = taskDaemonIter.getResultSet();
        if (ReportUtil.isVerbose()) {
            taskDaemonIter.displayDaemonCheckStartMessage();
        }
        TaskAnonymousProxy anonymousProxy = new TaskAnonymousProxy(taskDaemonIter.getElementName(), this.m_nodeList, this);
        taskDaemonIter.displayDaemonLivelinessOutput(dmnResult, false, anonymousProxy);
        boolean ret = false;
        String dmnName = taskDaemonIter.getDaemonName();
        Trace.out((String)(dmnName + " is running on some nodes"));
        locrs.uploadResultSet(dmnResult);
        String[] dmnRunningNodes = dmnResult.getSuccNodes();
        if (dmnResult.allSuccess()) {
            Trace.out((String)"NTPD running on all nodes");
            String errmsg = s_msgBundle.getMessage("5497", false);
            locrs.addResult(nlist, 1);
            ret = true;
            ErrorDescription errorDesc = new ErrorDescription(errmsg);
            dmnResult.addResult(nlist, 1);
            dmnResult.addErrorDescription(errorDesc);
            anonymousProxy.getResultSet().overwriteResultSet(dmnResult);
            anonymousProxy.perform();
        } else if (dmnResult.anySuccess()) {
            Trace.out((String)"NTPD running on some nodes");
            String[] dmnNotRunningNodes = dmnResult.getFailureNodes();
            if (this.m_isNodeAdd) {
                locrs.clear();
                boolean retStatus = this.addNodeDaemonFailure(locrs, dmnResult.getFailedNodes(), dmnResult.getSuccessfulNodes());
                anonymousProxy.getResultSet().overwriteResultSet(locrs);
                anonymousProxy.perform();
                this.m_resultSet.uploadResultSet(locrs);
                return retStatus;
            }
            String errmsg = s_msgBundle.getMessage("5493", true, (Object[])new String[]{VerificationUtil.strArr2List(dmnNotRunningNodes)});
            locrs.clear();
            locrs.addResult(dmnRunningNodes, 1);
            locrs.addResult(dmnNotRunningNodes, 3);
            ErrorDescription errDesc = new ErrorDescription(errmsg);
            locrs.addErrorDescription(errDesc);
            ret = false;
            dmnResult.addResult(dmnRunningNodes, 1);
            dmnResult.addResult(dmnNotRunningNodes, 3);
            dmnResult.addErrorDescription(errDesc);
            anonymousProxy.getResultSet().overwriteResultSet(locrs);
            anonymousProxy.perform();
        }
        this.m_resultSet.uploadResultSet(locrs);
        return ret;
    }

    private void executeDaemonLiveliness(List<String> dmnNames, String[] nlist, Vector<String> dmnOkVec, Vector<TaskDaemonLiveliness> aliveDaemonVector, Vector<TaskDaemonLiveliness> notRunningDaemonVector) {
        for (String dmnName : dmnNames) {
            TaskDaemonLiveliness taskDaemon = new TaskDaemonLiveliness(nlist, dmnOkVec);
            String taskNameStr = s_eMsgBundle.getMessage("9904", false, (Object[])new String[]{dmnName});
            taskDaemon.setElementName(taskNameStr);
            taskDaemon.setDaemonName(dmnName);
            ReportUtil.setQuietModeLocal(true);
            taskDaemon.setChildTaskLevel(this.getChildTaskLevel() + 1);
            taskDaemon.performTask();
            ReportUtil.setQuietModeLocal(false);
            if (taskDaemon.getResultSet().anySuccess()) {
                Trace.out((String)(dmnName + " is running on some nodes"));
                aliveDaemonVector.add(taskDaemon);
                continue;
            }
            Trace.out((String)(dmnName + " is not running on any nodes"));
            notRunningDaemonVector.add(taskDaemon);
        }
    }

    private void displayNoConfigDaemons(String[] nlist, Vector<TaskDaemonLiveliness> aliveDaemonVector) {
        ResultSet locrs = new ResultSet();
        for (TaskDaemonLiveliness taskDaemonIter : aliveDaemonVector) {
            String dmnName = taskDaemonIter.getDaemonName();
            String dmnPidPath = this.s_sTaskNTP.getDaemonPidFilePath(dmnName);
            ResultSet dmnResult = taskDaemonIter.getResultSet();
            String[] dmnRunningNodes = dmnResult.getSuccNodes();
            if (dmnRunningNodes.length != 0) {
                VerificationUtil.traceAndLog("daemon " + dmnName + " running without both pid and conf file");
                String errmsg = s_gMsgBundle.getMessage("1029", true, (Object[])new String[]{dmnName, VerificationUtil.strArr2List(dmnRunningNodes), dmnPidPath});
                locrs.addResult(dmnRunningNodes, 3);
                ErrorDescription errorDesc = new ErrorDescription(errmsg);
                locrs.addErrorDescription(dmnRunningNodes, errorDesc);
                locrs.addResult(dmnResult.getFailedNodes(), 1);
                continue;
            }
            Trace.out((String)"daemons not running on all nodes");
            locrs.addResult(nlist, 1);
        }
        String proxyMsg = s_gMsgBundle.getMessage("1061", false);
        TaskAnonymousProxy anonymousProxy = new TaskAnonymousProxy(proxyMsg, nlist, this, locrs);
        anonymousProxy.perform();
        this.m_resultSet.uploadResultSet(locrs);
    }

    private boolean addNodeDaemonFailure(ResultSet locrs, List<String> dmnNotRunningNodes, List<String> dmnRunningNodes) {
        if (VerificationUtil.inListIgnoreCase(dmnNotRunningNodes, m_localNode)) {
            String errmsg = s_msgBundle.getMessage("5493", true, (Object[])new String[]{VerificationUtil.strList2List(dmnRunningNodes)});
            locrs.addResult(dmnNotRunningNodes, 1);
            locrs.addResult(dmnRunningNodes, 3);
            ErrorDescription errDesc = new ErrorDescription(errmsg);
            locrs.addErrorDescription(errDesc);
        } else if (dmnRunningNodes.contains(m_localNode)) {
            String errmsg = s_msgBundle.getMessage("5493", true, (Object[])new String[]{VerificationUtil.strList2List(dmnNotRunningNodes)});
            locrs.addResult(dmnRunningNodes, 1);
            locrs.addResult(dmnNotRunningNodes, 3);
            ErrorDescription errDesc = new ErrorDescription(errmsg);
            locrs.addErrorDescription(errDesc);
        }
        return false;
    }

    private boolean isChronyDaemon(String daemonName) {
        return "chronyd".equals(daemonName);
    }

    private String getNTPSourceQueryCommand() {
        return "/usr/sbin/ntpq -np";
    }

    private String getChronySourceQueryCommand() {
        return "/usr/bin/chronyc sources";
    }

    private void doNTPTimeSourceCheck(ResultSet rs, Vector<String> nodeVec) {
        String[] nodeList = nodeVec.toArray(new String[nodeVec.size()]);
        String stateCmd = this.getNTPSourceQueryCommand();
        VerificationCommand[] cmdArr = new VerificationCommand[nodeList.length];
        ResultSet locrs = new ResultSet();
        for (int i = 0; i < nodeList.length; ++i) {
            String node = nodeList[i];
            String[] arg = new String[]{"-rungencmd", stateCmd};
            cmdArr[i] = new VerificationCommand(node, arg, null);
        }
        new GlobalHandler().submit((Command[])cmdArr, 0, locrs);
        if (!locrs.anySuccess()) {
            VerificationUtil.traceAndLog("Global failure executing commands for getting time sources of ntpd");
            String errMsg = s_gMsgBundle.getMessage("13600", true);
            for (VerificationCommand cmd : cmdArr) {
                String execErr = cmd.fetchExecutionDetailsMessage();
                if (!VerificationUtil.isStringGood(execErr)) continue;
                errMsg = errMsg + LSEP + execErr;
            }
            rs.addResult(nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            rs.addErrorDescription(errDesc);
            return;
        }
        for (VerificationCommand cmd : cmdArr) {
            ErrorDescription errDesc;
            String errMsg;
            String node = cmd.getNode();
            Result result = cmd.getResult();
            int status = result.getStatus();
            int vfyCode = cmd.getVfyCode();
            String output = cmd.getOutput();
            boolean validSourceExists = false;
            ArrayList<String> rejectionList = new ArrayList<String>();
            VerificationUtil.traceAndLog("status=" + Result.resultStatusString(status) + "; vfyCode=" + vfyCode + "; output=" + output);
            if (status == 1 && vfyCode == 0 && output != null) {
                String[] tsLineArray = null;
                String[] lineArray = output.split("\n");
                if (lineArray.length > 2) {
                    tsLineArray = new String[lineArray.length - 2];
                    for (int i = 2; i < lineArray.length; ++i) {
                        tsLineArray[i - 2] = lineArray[i];
                    }
                }
                if (tsLineArray != null) {
                    for (String tsline : tsLineArray) {
                        if (tsline.length() < 2) {
                            VerificationUtil.traceAndLog("Skipped invalid line: " + tsline);
                            continue;
                        }
                        char tallyCode = tsline.charAt(0);
                        String[] tsEntries = tsline.substring(1).split("\\s+");
                        if (tsEntries.length < 2) continue;
                        String remoteVal = tsEntries[0];
                        String refidVal = tsEntries[1];
                        if ('*' == tallyCode && !refidVal.contains(".LOCL.")) {
                            VerificationUtil.traceAndLog("ntpd is in sync with '" + remoteVal + "' on node '" + node + "'");
                            validSourceExists = true;
                            rs.addResult(node, 1);
                            break;
                        }
                        VerificationUtil.traceAndLog("Source '" + remoteVal + "' is rejected on node '" + node + "'");
                        rejectionList.add(remoteVal);
                    }
                }
                if (validSourceExists) continue;
                errMsg = s_gMsgBundle.getMessage("13602", true, (Object[])new String[]{node});
                errDesc = new ErrorDescription(errMsg);
                rs.addResult(node, 3);
                rs.addErrorDescription(node, errDesc);
                continue;
            }
            VerificationUtil.traceAndLog("Command Execution failed");
            errMsg = s_gMsgBundle.getMessage("13601", true, (Object[])new String[]{node});
            String exDetailMsg = cmd.fetchExecutionDetailsMessage();
            if (VerificationUtil.isStringGood(exDetailMsg)) {
                errMsg = errMsg + LSEP + exDetailMsg;
            }
            errDesc = new ErrorDescription(errMsg);
            rs.addResult(node, 2);
            rs.addErrorDescription(node, errDesc);
        }
    }

    private void doChronyTimeSourceCheck(ResultSet rs, Vector<String> nodeVec) {
        String[] nodeList = nodeVec.toArray(new String[nodeVec.size()]);
        String stateCmd = this.getChronySourceQueryCommand();
        VerificationCommand[] cmdArr = new VerificationCommand[nodeList.length];
        ResultSet locrs = new ResultSet();
        for (int i = 0; i < nodeList.length; ++i) {
            String node = nodeList[i];
            String[] arg = new String[]{"-rungencmd", stateCmd};
            cmdArr[i] = new VerificationCommand(node, arg, null);
        }
        new GlobalHandler().submit((Command[])cmdArr, 0, locrs);
        if (!locrs.anySuccess()) {
            VerificationUtil.traceAndLog("Global failure executing commands for getting time sources of chronyd");
            String errMsg = s_gMsgBundle.getMessage("13604", true);
            for (VerificationCommand cmd : cmdArr) {
                String execErr = cmd.fetchExecutionDetailsMessage();
                if (!VerificationUtil.isStringGood(execErr)) continue;
                errMsg = errMsg + LSEP + execErr;
            }
            rs.addResult(nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            rs.addErrorDescription(errDesc);
            return;
        }
        for (VerificationCommand cmd : cmdArr) {
            ErrorDescription errDesc;
            String errMsg;
            String node = cmd.getNode();
            Result result = cmd.getResult();
            int status = result.getStatus();
            int vfyCode = cmd.getVfyCode();
            String output = cmd.getOutput();
            boolean validSourceExists = false;
            ArrayList<String> rejectionList = new ArrayList<String>();
            VerificationUtil.traceAndLog("status=" + Result.resultStatusString(status) + "; vfyCode=" + vfyCode + "; output=" + output);
            if (status == 1 && vfyCode == 0 && output != null) {
                String[] tsLineArray = null;
                String[] lineArray = output.split("\n");
                if (lineArray.length > 3) {
                    tsLineArray = new String[lineArray.length - 3];
                    for (int i = 3; i < lineArray.length; ++i) {
                        tsLineArray[i - 3] = lineArray[i];
                    }
                }
                if (tsLineArray != null) {
                    for (String tsline : tsLineArray) {
                        String[] tsEntries = tsline.split("\\s+");
                        VerificationUtil.traceAndLog("length=" + tsEntries.length);
                        if (tsEntries.length < 2) {
                            VerificationUtil.traceAndLog("Skipped invalid line: " + tsline);
                            continue;
                        }
                        char sourceMode = tsEntries[0].charAt(0);
                        char sourceState = tsEntries[0].charAt(1);
                        String sourceName = tsEntries[1];
                        VerificationUtil.traceAndLog("mode=" + sourceMode + "; state=" + sourceState + "; name=" + sourceName);
                        if (('^' == sourceMode || '=' == sourceMode) && '*' == sourceState) {
                            VerificationUtil.traceAndLog("chronyd is in sync with '" + sourceName + "' on node '" + node + "'");
                            validSourceExists = true;
                            rs.addResult(node, 1);
                            break;
                        }
                        VerificationUtil.traceAndLog("Source '" + sourceName + "' is rejected on node '" + node + "'");
                        rejectionList.add(sourceName);
                    }
                }
                if (validSourceExists) continue;
                errMsg = s_gMsgBundle.getMessage("13606", true, (Object[])new String[]{node});
                errDesc = new ErrorDescription(errMsg);
                rs.addResult(node, 3);
                rs.addErrorDescription(node, errDesc);
                continue;
            }
            VerificationUtil.traceAndLog("Command Execution failed");
            errMsg = s_gMsgBundle.getMessage("13605", true, (Object[])new String[]{node});
            String exDetailMsg = cmd.fetchExecutionDetailsMessage();
            if (VerificationUtil.isStringGood(exDetailMsg)) {
                errMsg = errMsg + LSEP + exDetailMsg;
            }
            errDesc = new ErrorDescription(errMsg);
            rs.addResult(node, 2);
            rs.addErrorDescription(node, errDesc);
        }
    }

    private boolean doSlewingCheck(ResultSet locrs, Vector<String> confokVec) {
        int okVectorSize = confokVec.size();
        String[] okNodeList = confokVec.toArray(new String[okVectorSize]);
        String stateCmd = this.s_sTaskNTP.getNTPDCommandLine("commandline");
        String slewOption = this.s_sTaskNTP.getNTPDSlewingOption();
        String taskName = s_gMsgBundle.getMessage("1078", false, (Object[])new String[]{slewOption});
        TaskAnonymousProxy taskAnon = new TaskAnonymousProxy(taskName, confokVec.toArray(new String[confokVec.size()]), this);
        Task previousTaskReference = ReportUtil.setTaskReference(taskAnon);
        Trace.out((String)("Command : " + stateCmd));
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.runGenericCmd(okNodeList, stateCmd, locrs);
        ReportUtil.println(LSEP + s_msgBundle.getMessage("5444", false, (Object[])new String[]{slewOption}));
        if (!locrs.anySuccess()) {
            VerificationUtil.traceAndLog("Global failure executing NTP Slewing command ");
            String errMsg = s_msgBundle.getMessage("5442", true);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(errorDesc);
            taskAnon.performAnonymousTask(locrs);
            ReportUtil.printError(errMsg);
            return false;
        }
        ReportUtil.println(s_msgBundle.getMessage("5437", false));
        if (ReportUtil.getOldFormat()) {
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("5438", false));
        }
        if (ReportUtil.isVerbose()) {
            ReportUtil.reportwriteColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("5438", false));
        }
        ArrayList<String> opFailedNodeList = new ArrayList<String>();
        ArrayList<String> vfyFailedNodeList = new ArrayList<String>();
        ArrayList<String> successNodeList = new ArrayList<String>();
        Hashtable rsltTab = locrs.getResultTable();
        Enumeration e = rsltTab.keys();
        while (e.hasMoreElements()) {
            String slewedmode = ReportUtil.UNKNOWN;
            String node = (String)e.nextElement();
            Result result = (Result)rsltTab.get(node);
            if (result.getStatus() == 1) {
                String cmdline = VerificationUtil.strArr2List((String[])result.getResultInfoSet().get(1), LSEP);
                if (cmdline != null) {
                    boolean slewingPresent;
                    result.addResultInfo(cmdline);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("NTPD commandline on node " + node + " is =" + cmdline));
                    }
                    if (slewingPresent = this.s_sTaskNTP.parseNTPDCommandLine(cmdline, "commandline")) {
                        Trace.out((String)(" node:" + node + ": is slewed"));
                        locrs.addResult(node, 1);
                        slewedmode = ReportUtil.YES;
                        successNodeList.add(node);
                    } else {
                        VerificationUtil.traceAndLog("node:" + node + ": is not slewed");
                        vfyFailedNodeList.add(node);
                        locrs.addResult(node, 3);
                        slewedmode = ReportUtil.NO;
                    }
                }
            } else {
                locrs.addResult(node, 2);
                VerificationUtil.traceAndLog("NTPD commandline couldn't be obtained from node: '" + node + "'");
                opFailedNodeList.add(node);
                slewedmode = ReportUtil.UNKNOWN;
            }
            if (ReportUtil.getOldFormat()) {
                ReportUtil.writeRecord(node, slewedmode);
            }
            if (!ReportUtil.isVerbose()) continue;
            ReportUtil.reportwriteRecord(node, slewedmode);
        }
        boolean status = true;
        if (locrs.allSuccess()) {
            ReportUtil.printResult(LSEP + s_gMsgBundle.getMessage("1035", false, (Object[])new String[]{slewOption}));
        } else {
            String errMsg;
            ArrayList<String> errorMessages = new ArrayList<String>();
            if (vfyFailedNodeList.size() != 0) {
                errMsg = s_gMsgBundle.getMessage("1032", true, (Object[])new String[]{slewOption, VerificationUtil.strList2List(vfyFailedNodeList)});
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                locrs.addErrorDescription(errDesc);
                errorMessages.add(errMsg);
            }
            if (opFailedNodeList.size() != 0) {
                errMsg = s_gMsgBundle.getMessage("1033", true, (Object[])new String[]{slewOption, VerificationUtil.strList2List(opFailedNodeList)});
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                locrs.addErrorDescription(errDesc);
                errorMessages.add(errMsg);
            }
            if (successNodeList.size() != 0) {
                String succMesg = s_gMsgBundle.getMessage("1034", false, (Object[])new String[]{slewOption, VerificationUtil.strList2List(successNodeList)});
                ReportUtil.sureprintln(succMesg);
            }
            ReportUtil.reportErrors(errorMessages);
            status = false;
        }
        taskAnon.performAnonymousTask(locrs);
        ReportUtil.setTaskReference(previousTaskReference);
        return status;
    }

    private boolean doSlewingSysConfigCheck(ResultSet locrs, Vector<String> confokVec) {
        int okVectorSize = confokVec.size();
        String[] okNodeList = confokVec.toArray(new String[okVectorSize]);
        String bootOptionCmd = this.s_sTaskNTP.getNTPDCommandLine("startup");
        String slewOption = this.s_sTaskNTP.getNTPDSlewingOption();
        String bootConfigFile = this.s_sTaskNTP.getNTPDBootConfigFile();
        String taskName = s_gMsgBundle.getMessage("1079", false, (Object[])new String[]{bootConfigFile, slewOption});
        TaskAnonymousProxy taskAnon = new TaskAnonymousProxy(taskName, confokVec.toArray(new String[confokVec.size()]), this);
        Task previousTaskReference = ReportUtil.setTaskReference(taskAnon);
        Trace.out((String)("Command : " + bootOptionCmd));
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.runGenericCmd(okNodeList, bootOptionCmd, locrs);
        ReportUtil.println(LSEP + s_msgBundle.getMessage("5445", false, (Object[])new String[]{bootConfigFile, slewOption}));
        if (!locrs.anySuccess()) {
            VerificationUtil.traceAndLog("Global failure executing NTP Boot configuration slewing command ");
            String errMsg = s_msgBundle.getMessage("5475", true);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(errorDesc);
            taskAnon.performAnonymousTask(locrs);
            ReportUtil.printError(errMsg);
            return false;
        }
        ReportUtil.println(LSEP + s_msgBundle.getMessage("5471", false));
        if (ReportUtil.getOldFormat()) {
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("5438", false));
        }
        if (ReportUtil.isVerbose()) {
            ReportUtil.reportwriteColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("5438", false));
        }
        ArrayList<String> vfyFailedNodeList = new ArrayList<String>();
        ArrayList<String> opFailedNodeList = new ArrayList<String>();
        ArrayList<String> successNodeList = new ArrayList<String>();
        Hashtable rsltTab = locrs.getResultTable();
        Enumeration e = rsltTab.keys();
        while (e.hasMoreElements()) {
            String slewedmode = ReportUtil.UNKNOWN;
            String node = (String)e.nextElement();
            Result result = (Result)rsltTab.get(node);
            if (result.getStatus() == 1) {
                String bootCmdline = VerificationUtil.strArr2List((String[])result.getResultInfoSet().get(1), LSEP);
                if (bootCmdline != null) {
                    boolean slewingPresent;
                    result.addResultInfo(bootCmdline);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("NTPD boot configuration on node " + node + " is =" + bootCmdline));
                    }
                    if (slewingPresent = this.s_sTaskNTP.parseNTPDCommandLine(bootCmdline, "startup")) {
                        Trace.out((String)(" node:" + node + ": is slewed"));
                        locrs.addResult(node, 1);
                        slewedmode = ReportUtil.YES;
                        successNodeList.add(node);
                    } else {
                        Trace.out((String)("node:" + node + ": is not slewed"));
                        locrs.addResult(node, 3);
                        vfyFailedNodeList.add(node);
                        slewedmode = ReportUtil.NO;
                    }
                }
            } else {
                locrs.addResult(node, 2);
                opFailedNodeList.add(node);
                VerificationUtil.traceAndLog("NTPD boot config couldn't be obtained from node: '" + node + "'");
                slewedmode = ReportUtil.UNKNOWN;
            }
            if (ReportUtil.getOldFormat()) {
                ReportUtil.writeRecord(node, slewedmode);
            }
            if (!ReportUtil.isVerbose()) continue;
            ReportUtil.reportwriteRecord(node, slewedmode);
        }
        boolean status = true;
        if (locrs.allSuccess()) {
            ReportUtil.printResult(LSEP + s_gMsgBundle.getMessage("1039", false, (Object[])new String[]{slewOption, bootConfigFile}));
        } else {
            ErrorDescription errDesc;
            String errMsg;
            if (vfyFailedNodeList.size() != 0) {
                errMsg = s_gMsgBundle.getMessage("1036", true, (Object[])new String[]{bootConfigFile, slewOption, VerificationUtil.strList2List(vfyFailedNodeList)});
                errDesc = new ErrorDescription(errMsg);
                locrs.addErrorDescription(errDesc);
                ReportUtil.printError(errMsg);
            }
            if (opFailedNodeList.size() != 0) {
                errMsg = s_gMsgBundle.getMessage("1037", true, (Object[])new String[]{bootConfigFile, slewOption, VerificationUtil.strList2List(opFailedNodeList)});
                errDesc = new ErrorDescription(errMsg);
                locrs.addErrorDescription(errDesc);
                ReportUtil.printError(errMsg);
            }
            if (successNodeList.size() != 0) {
                String succMsg = s_gMsgBundle.getMessage("1034", false, (Object[])new String[]{slewOption, bootConfigFile, VerificationUtil.strList2List(successNodeList)});
                ReportUtil.sureprintln(succMsg);
            }
            status = false;
        }
        taskAnon.performAnonymousTask(locrs);
        ReportUtil.setTaskReference(previousTaskReference);
        return status;
    }

    private boolean doPortOpenCheck(ResultSet rs, Vector<String> confokVec) {
        int okVectorSize = confokVec.size();
        String[] okNodeList = confokVec.toArray(new String[okVectorSize]);
        GlobalExecution gex = new GlobalExecution();
        String ntpCfg = this.s_sTaskNTP.getCfgFileToSearch();
        boolean ret = false;
        String taskName = s_gMsgBundle.getMessage("1028", false);
        TaskAnonymousProxy taskAnon = new TaskAnonymousProxy(taskName, confokVec.toArray(new String[confokVec.size()]), this);
        Task previousTaskReference = ReportUtil.setTaskReference(taskAnon);
        ret = gex.checkNTPPort(ntpCfg, rs, okNodeList);
        Trace.out((String)("Entered doPortOpenCheck GlobalExec returns " + ret));
        ReportUtil.println(LSEP + s_msgBundle.getMessage("5487", false));
        if (!rs.anySuccess()) {
            VerificationUtil.traceAndLog("Global failure executing NTP Port Open Check command ");
            String errMsg = s_msgBundle.getMessage("5488", true);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            rs.addErrorDescription(errorDesc);
            ReportUtil.printError(errMsg);
            taskAnon.performAnonymousTask(rs);
            return false;
        }
        ReportUtil.println(LSEP + s_msgBundle.getMessage("5489", false));
        if (ReportUtil.getOldFormat()) {
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("5490", false));
        }
        if (ReportUtil.isVerbose()) {
            ReportUtil.reportwriteColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("5490", false));
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (int nodeIndex = 0; nodeIndex < okVectorSize; ++nodeIndex) {
            String errMsg;
            String node = okNodeList[nodeIndex];
            Result r = rs.getResult(node);
            int st = r.getStatus();
            String msg = ReportUtil.UNKNOWN;
            if (st == 1) {
                msg = ReportUtil.YES;
            } else if (st == 2 || st == 3) {
                msg = ReportUtil.NO;
            }
            if (st == 2) {
                errMsg = s_msgBundle.getMessage("5506", true, (Object[])new String[]{node});
                rs.addErrorDescription(new ErrorDescription(errMsg));
                errorMessages.add(errMsg);
            } else if (st == 3) {
                errMsg = s_msgBundle.getMessage("5505", true, (Object[])new String[]{node});
                rs.addErrorDescription(new ErrorDescription(errMsg));
                errorMessages.add(errMsg);
            }
            if (ReportUtil.getOldFormat()) {
                ReportUtil.writeRecord(okNodeList[nodeIndex], msg);
            }
            if (!ReportUtil.isVerbose()) continue;
            ReportUtil.reportwriteRecord(okNodeList[nodeIndex], msg);
        }
        ReportUtil.reportErrors(errorMessages);
        Trace.out((String)("Exiting doPortOpenCheck returns " + ret));
        taskAnon.performAnonymousTask(rs);
        ReportUtil.setTaskReference(previousTaskReference);
        return ret;
    }

    public void setPreCheck(boolean preCheck) {
        this.m_preCheck = preCheck;
    }

    public boolean getPreCheck() {
        return this.m_preCheck;
    }

    public void setRequestedRelease(String reqRel) {
        this.m_requestedRelease = reqRel;
    }

    public void setAddNode() {
        this.m_isNodeAdd = true;
    }

    public void setEnableDBChecks() {
        this.m_isDBChecksEnabled = true;
        Trace.out((String)"enabling slewing check for NTPD : required for database");
    }

    private void displayConfigAndDaemonResults(String[] nodeList, Vector<PidOrConfFileData> confVector, Vector<PidOrConfFileData> pidVector, Vector<TaskDaemonLiveliness> aliveDaemonVector) {
        Trace.out((String)("m_foundConfFilesMap:: size=" + this.m_foundConfFilesMap.size() + "; " + this.m_foundConfFilesMap));
        Trace.out((String)("m_foundPidFilesMap:: size=" + this.m_foundPidFilesMap.size() + "; " + this.m_foundPidFilesMap));
        Trace.out((String)("aliveDaemonVector:: size=" + aliveDaemonVector.size()));
        Trace.out((String)("confVector.size()=" + confVector.size() + "; pidVector.size()=" + pidVector.size()));
        int i = 0;
        for (PidOrConfFileData conf : confVector) {
            Trace.out((String)("confVector(" + i + "):: " + conf));
            ++i;
        }
        i = 0;
        for (PidOrConfFileData pid : pidVector) {
            Trace.out((String)("pidVector(" + i + "):: " + pid));
            ++i;
        }
        if (this.m_foundConfFilesMap.size() > 1 || this.m_foundPidFilesMap.size() > 1 || aliveDaemonVector.size() > 1) {
            return;
        }
        if (aliveDaemonVector.size() == 0) {
            String fileLoc = null;
            Vector<String> confokVec = null;
            if (this.m_foundConfFilesMap.size() == 1) {
                fileLoc = this.m_foundConfFilesMap.keys().nextElement();
                for (PidOrConfFileData confData : confVector) {
                    if (!confData.getPidOrConfFileName().matches(fileLoc)) continue;
                    confokVec = confData.getConfokVector();
                    break;
                }
            } else if (this.m_foundPidFilesMap.size() == 1) {
                fileLoc = this.m_foundPidFilesMap.keys().nextElement();
                for (PidOrConfFileData confData : pidVector) {
                    if (!confData.getPidOrConfFileName().matches(fileLoc)) continue;
                    confokVec = confData.getConfokVector();
                    break;
                }
            }
            if (fileLoc != null) {
                String errMsg = s_gMsgBundle.getMessage("1017", true, (Object[])new String[]{fileLoc, VerificationUtil.strVect2List(confokVec)});
                this.m_resultSet.addResult(confokVec, 3);
                this.m_resultSet.addErrorDescription(confokVec, new ErrorDescription(errMsg));
                ReportUtil.sureprintln(errMsg);
                return;
            }
        } else if (aliveDaemonVector.size() == 1 && pidVector.size() == 0 && confVector.size() == 0) {
            TaskDaemonLiveliness taskDaemonIter = aliveDaemonVector.get(0);
            ResultSet dmnResult = taskDaemonIter.getResultSet();
            String dmnName = taskDaemonIter.getDaemonName();
            String[] dmnRunningNodes = dmnResult.getSuccNodes();
            String errMsg = s_gMsgBundle.getMessage("1018", true, (Object[])new String[]{dmnName, VerificationUtil.strArr2List(dmnRunningNodes)});
            this.m_resultSet.addResult(dmnRunningNodes, 3);
            this.m_resultSet.addErrorDescription(dmnRunningNodes, new ErrorDescription(errMsg));
            ReportUtil.sureprintln(errMsg);
            return;
        }
    }

    private static enum ResultStatus {
        ALL_SUCCESS,
        PARTIAL_SUCCESS,
        ALL_FAILURE,
        UNKNOWN;

    }
}

