/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.engine.task.Step;
import oracle.ops.verification.framework.engine.task.TaskPeerCompatibility;
import oracle.ops.verification.framework.engine.task.sTaskKernelParam;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.InvalidStepException;
import oracle.ops.verification.framework.util.RangeOfValue;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskKernelParam
extends TaskPeerCompatibility
implements PeerCompatibleTask {
    static String CONSTRAINT_NAME = s_msgBundle.getMessage("1060", false);
    String m_paramName;
    String m_expectedValue;
    boolean m_exactEqualTo = false;
    String m_minVal;
    String m_maxVal;
    RangeOfValue m_exepctedRange;
    List<Step> m_expectedStepList = new ArrayList<Step>();
    String m_refElemName;
    Hashtable m_htPhysicalMemoryResult;
    boolean m_physicalMemoryFetched = false;

    TaskKernelParam() {
    }

    public TaskKernelParam(String name, String val) {
        this.m_paramName = name;
        this.m_expectedValue = val;
    }

    public TaskKernelParam(String name, String equalToval, boolean checkExact) {
        this.m_paramName = name;
        this.m_expectedValue = equalToval;
        this.m_exactEqualTo = checkExact;
    }

    public TaskKernelParam(String name, RangeOfValue range) {
        this.m_paramName = name;
        this.m_exepctedRange = range;
    }

    public TaskKernelParam(String name) {
        this.m_paramName = name;
    }

    public void setMinVal(StorageSize minSS) {
        this.m_minVal = Long.toString((long)minSS.sizeIn(StorageUnit.BYTE));
    }

    public void setMaxVal(StorageSize maxSS) {
        this.m_maxVal = Long.toString((long)maxSS.sizeIn(StorageUnit.BYTE));
    }

    public void addStep(RangeOfValue range, StorageUnit unit, float multiplier) throws InvalidStepException {
        Trace.out((String)("Inside addStep: range = " + range + ", unit = " + (Object)((Object)unit) + ", mulitplier = " + multiplier));
        this.m_expectedStepList.add(new Step(range, unit, multiplier));
    }

    @Override
    public boolean performTask() {
        this.performVerification();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_paramName}));
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_paramName}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    private void performVerification() {
        sTaskKernelParam sTask = new sTaskKernelParam(this);
        sTask.performVerification();
        if (this.m_resultSet.allSuccess()) {
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0316", false, (Object[])new String[]{this.m_paramName}));
        } else {
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0317", false, (Object[])new String[]{this.m_paramName, VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
        }
    }

    String getExpectedValue(String node) {
        if (this.m_expectedStepList.size() == 0) {
            return this.m_exepctedRange == null ? this.m_expectedValue : this.m_exepctedRange.toString();
        }
        if (!this.m_physicalMemoryFetched) {
            this.m_physicalMemoryFetched = true;
            GlobalExecution globalExec = new GlobalExecution();
            ResultSet memRsltSet = new ResultSet();
            globalExec.checkMemory(this.m_nodeList, 0L, memRsltSet);
            this.m_resultSet.addResultSetData(memRsltSet);
            this.m_htPhysicalMemoryResult = memRsltSet.getResultTable();
        }
        Result resultMem = (Result)this.m_htPhysicalMemoryResult.get(node);
        Trace.out((String)("resultMem.getStatus() ::" + Result.resultStatusString(resultMem.getStatus())));
        if (resultMem.getStatus() == 1) {
            StorageSize avlMemBytes = (StorageSize)resultMem.getResultInfoSet().firstElement();
            StorageSize reqdSizeSS = null;
            boolean stepFound = false;
            StorageUnit unit = StorageUnit.BYTE;
            for (Step step : this.m_expectedStepList) {
                unit = step.getUnit();
                try {
                    if (!step.getRange().contains(avlMemBytes)) {
                        continue;
                    }
                }
                catch (InvalidRangeManipulationException irme) {
                    if (!Trace.isTraceEnabled()) break;
                    Trace.out((Exception)irme);
                    break;
                }
                stepFound = true;
                Trace.out((String)(" stepFound " + stepFound));
                reqdSizeSS = new StorageSize(avlMemBytes.sizeIn(unit) * (double)step.getMultiplier(), unit);
                if (!Trace.isTraceEnabled()) break;
                Trace.out((String)("multiplier=" + step.getMultiplier() + " avl memory=" + avlMemBytes + " reqd value = " + reqdSizeSS));
                break;
            }
            if (this.m_minVal != null && (reqdSizeSS == null || VerificationUtil.parseStringToNumber(this.m_minVal) > (double)((long)reqdSizeSS.sizeIn(StorageUnit.BYTE)))) {
                return this.m_minVal;
            }
            if (this.m_maxVal != null && (reqdSizeSS == null || VerificationUtil.parseStringToNumber(this.m_maxVal) < (double)((long)reqdSizeSS.sizeIn(StorageUnit.BYTE)))) {
                return this.m_maxVal;
            }
            if (!stepFound) {
                this.m_resultSet.addResult(node, 2);
                ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("9807", true, (Object[])new String[]{this.m_paramName, node}));
                this.m_resultSet.addErrorDescription(node, errDesc);
                return null;
            }
            return Long.toString((long)reqdSizeSS.sizeIn(StorageUnit.BYTE));
        }
        if (resultMem.getStatus() != 1) {
            ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("7531", true, (Object[])new String[]{node}));
            this.m_resultSet.getResult(node).addErrorDescription(errDesc);
        }
        this.m_resultSet.addResult(node, 3);
        return null;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4411", false) + ": " + this.m_paramName;
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4462", false, (Object[])new String[]{this.m_paramName});
    }

    @Override
    public String getTaskID() {
        return "CHECK_KERNEL_PARAMETER_" + this.m_paramName;
    }

    @Override
    public String getTaskName() {
        return this.getTaskID();
    }

    @Override
    public ResultSet performPeer() throws VerificationException {
        ResultSet knlparamRsltSet = new ResultSet();
        sTaskKernelParam sTask = new sTaskKernelParam(this);
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.getKerParam(this.m_nodeList, this.m_paramName, knlparamRsltSet);
        Hashtable t = knlparamRsltSet.getResultTable();
        Enumeration e = t.keys();
        Object reqdValueInString = null;
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            boolean verified = false;
            if (result.getStatus() != 1) continue;
            Object avl = result.getResultInfoSet().elementAt(0);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("AVL = " + avl));
            }
            if (avl == null || avl.toString().trim().length() == 0) {
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("FAILED:: No value returned for param: " + this.m_paramName + " on node:" + node));
                }
                ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("7544", true, (Object[])new String[]{this.m_paramName, node}), s_msgBundle, "7544");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                this.m_resultSet.addResult(node, 2);
                avl = ReportUtil.UNKNOWN;
            } else {
                avl = sTask.getData(avl.toString(), this.m_paramName);
            }
            result.getResultInfoSet().add(0, avl);
        }
        return knlparamRsltSet;
    }

    @Override
    public String getElementDisplayName() {
        return s_msgBundle.getMessage("9974", false, (Object[])new String[]{this.m_paramName});
    }

    @Override
    protected boolean matchesReferenceNode(Object nodeValue, Object referenceNodeValue) {
        if (nodeValue == referenceNodeValue) {
            return true;
        }
        if (nodeValue == null || referenceNodeValue == null) {
            return false;
        }
        if (nodeValue instanceof RangeOfValue) {
            try {
                if (referenceNodeValue instanceof RangeOfValue) {
                    return ((RangeOfValue)nodeValue).contains((RangeOfValue)referenceNodeValue);
                }
                return ((RangeOfValue)nodeValue).contains(referenceNodeValue);
            }
            catch (InvalidRangeManipulationException e) {
                return false;
            }
        }
        return VerificationUtil.parseStringToNumber(nodeValue.toString()) >= VerificationUtil.parseStringToNumber(referenceNodeValue.toString());
    }
}

