/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.RunGenericCommand;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkDataDiscovery;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.Subnet;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CommandsUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskIPPacketSizeCheck
extends Task {
    boolean isJumboEnabled = true;
    List<Subnet> m_subnetList = new ArrayList<Subnet>();
    Hashtable<Subnet, List<NetworkInfo>> m_prvSubnetIfTable = new Hashtable();

    public TaskIPPacketSizeCheck(String[] nodeList, List<Subnet> subnetList) {
        super(nodeList);
        this.m_subnetList = subnetList;
    }

    @Override
    public boolean performTask() {
        ResultSet resultSet = new ResultSet();
        HashSet<Subnet> failedSubnets = new HashSet<Subnet>();
        boolean resultVal = true;
        this.m_resultSet.addResult(this.m_nodeList, 1);
        resultVal = this.checkJumboFrames();
        if (resultVal && this.isJumboEnabled) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("12882", false));
            Enumeration<Subnet> e = this.m_prvSubnetIfTable.keys();
            while (e.hasMoreElements()) {
                Subnet subnet = e.nextElement();
                List<NetworkInfo> privateNetworks = this.m_prvSubnetIfTable.get(subnet);
                if (privateNetworks.size() < 2) {
                    VerificationUtil.traceAndLog("Subnet " + subnet.getSubnet() + " does not have sufficient private interfaces to" + " test MTU size packet goes through subnet");
                    continue;
                }
                Trace.out((String)"Checking if mtu size packet goes through the subnet ");
                boolean cmdSucc = new VerifyNetwork().checkMTUWithoutFragment(privateNetworks, subnet.getSubnet(), resultSet);
                this.m_resultSet.addResultSetData(resultSet);
                if (cmdSucc) continue;
                VerificationUtil.traceAndLog("MTU size packet failed to get through subnet " + subnet.getSubnet() + "without " + "fragmentation in jumbo frame env");
                failedSubnets.add(subnet);
            }
            if (failedSubnets.size() > 0) {
                HashSet nodes = new HashSet();
                ArrayList<String> subnets = new ArrayList<String>();
                for (Subnet subnet : failedSubnets) {
                    nodes.addAll(subnet.getNodes());
                    subnets.add(subnet.getSubnet());
                }
                String errMsg = s_gMsgBundle.getMessage("12884", true, (Object[])new String[]{VerificationUtil.strList2List(new ArrayList<String>(subnets))});
                this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                this.m_resultSet.addResult(nodes, 3);
                ReportUtil.printError(errMsg);
                VerificationUtil.traceAndLog(errMsg);
                resultVal = false;
            }
            if (resultVal) {
                Trace.out((String)"MTU Packet size check passed");
                String msg = s_gMsgBundle.getMessage("12883", false);
                ReportUtil.sureprintln(msg);
            }
        }
        return resultVal;
    }

    private boolean checkJumboFrames() {
        boolean reslt = true;
        String mtuValue = null;
        CommandsUtil cmdUtl = new CommandsUtil();
        for (Subnet subnet : this.m_subnetList) {
            HashSet<NetworkInfo> networks = new HashSet<NetworkInfo>();
            Collection networksCollection = subnet.getNetworks();
            networks.addAll(networksCollection);
            Set<Object> onlyPrivateNetworks = new HashSet();
            onlyPrivateNetworks = NetworkDataDiscovery.getClusterNetworksByType(networks, NetworkConstants.NetworkType.PRIVATE);
            ArrayList<RunGenericCommand> commands = new ArrayList<RunGenericCommand>();
            ResultSet resultSet = new ResultSet();
            HashMap<RunGenericCommand, String> commandInterfaceMap = new HashMap<RunGenericCommand, String>();
            for (NetworkInfo networkInfo : onlyPrivateNetworks) {
                String srcNode = networkInfo.getNodeName();
                String ifName = networkInfo.getInterfaceName();
                String cmd = cmdUtl.getIp() + " -oneline link show " + ifName + " | " + cmdUtl.getGrep() + " -i mtu";
                RunGenericCommand command = new RunGenericCommand(srcNode, cmd);
                commands.add(command);
                commandInterfaceMap.put(command, ifName);
            }
            VerificationCommand[] commandArray = commands.toArray(new VerificationCommand[0]);
            boolean bl = new GlobalHandler().submit((Command[])commandArray, 0, resultSet);
            for (VerificationCommand verificationCommand : commandArray) {
                Result result = verificationCommand.getResult();
                String node = verificationCommand.getNode();
                String interfaceName = (String)commandInterfaceMap.get(verificationCommand);
                String commandExecuted = verificationCommand.getCommandExecuted();
                VerificationUtil.traceAndLog("Command executed: " + commandExecuted);
                if (result.getStatus() == 1) {
                    String cmdOut = VerificationUtil.fetchVerificationValue((String)result.getResultInfoSet().firstElement());
                    String[] ifArray = VerificationUtil.string2strArr(cmdOut, " ");
                    if (ifArray.length > 4) {
                        mtuValue = ifArray[4];
                    }
                    VerificationUtil.traceAndLog("MTU size for interface " + interfaceName + " is :" + mtuValue);
                    try {
                        if (VerificationUtil.isStringGood(mtuValue) && Integer.parseInt(mtuValue) > 1500) {
                            VerificationUtil.traceAndLog("Jumbo frames are enabled for the interface " + interfaceName);
                            this.isJumboEnabled &= true;
                            continue;
                        }
                        VerificationUtil.traceAndLog("Jumbo frames are not enabled for the interface " + interfaceName);
                        this.isJumboEnabled &= false;
                    }
                    catch (NumberFormatException nfe) {
                        Trace.out((String)nfe.getMessage());
                        String mesg = s_gMsgBundle.getMessage("12886", true, (Object[])new String[]{interfaceName, cmdOut}) + LSEP + nfe.getMessage();
                        ErrorDescription errorDesc = new ErrorDescription(mesg);
                        Result nodeResult = new Result(node);
                        nodeResult.addErrorDescription(errorDesc);
                        nodeResult.setStatus(2);
                        this.m_resultSet.addResult(node, nodeResult);
                        ReportUtil.printError(mesg + LSEP);
                        reslt = false;
                    }
                    continue;
                }
                VerificationUtil.traceAndLog("Failed to obtain MTU value for the interface " + interfaceName + "on node " + node);
                String errMsg = s_gMsgBundle.getMessage("12887", true, (Object[])new String[]{interfaceName, commandExecuted, node}) + LSEP + result.getExecutionErrorDetails();
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                Result nodeResult = new Result(node);
                nodeResult.addErrorDescription(errorDesc);
                nodeResult.setStatus(2);
                this.m_resultSet.addResult(node, nodeResult);
                ReportUtil.printError(errMsg + LSEP);
                reslt = false;
            }
            this.m_prvSubnetIfTable.put(subnet, new ArrayList<Object>(onlyPrivateNetworks));
        }
        return reslt;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("12880", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("12881", false);
    }
}

