/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.GNSProperties;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSUtils;
import oracle.cluster.install.InstallException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.verification.ClusterwideCollectionUnavailableException;
import oracle.cluster.verification.CollectionResultSet;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.ParamPreReqNodeAddDel;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.GetAllByNameThread;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUHelperException;
import oracle.ops.verification.framework.util.CVUHelperExec;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.GNSData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.helper.CVUHelperConstants;

public class TaskGNSIntegrity
extends Task
implements CVUHelperConstants {
    boolean m_preCheck = false;
    private String GNS_SCAN_NAME_HELPER_ARG = "-getScanName";
    private String GNS_RESPONSE_SERVER = "Oracle-GNS";
    private boolean m_isAddNode = false;
    private String m_portNumber = "53";
    private String m_compName = "GNS";
    private NetworkConstants.NetworkProtocol m_protocol = NetworkConstants.NetworkProtocol.TCP;
    private String[] m_leafNodeList = null;

    public TaskGNSIntegrity(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        this.m_preCheck = this.m_globalContext.isPreCRS();
        VerificationType vType = this.m_globalContext.getVerificationType();
        switch (vType) {
            case PREREQ_RACNODE_ADD: 
            case PREREQ_NODE_ADD: {
                this.setPreCheck(this.m_globalContext.isPreCRS());
                ParamPreReqNodeAddDel param = (ParamPreReqNodeAddDel)this.m_globalContext.getParamPrereq();
                if (param != null) {
                    this.setNodeList(param.getValidNodes());
                }
                this.setAddNode();
                break;
            }
            case COMPONENT_GNS_INTEGRITY: {
                this.setPreCheck(this.m_globalContext.getParamManager().checkArgGnsPreCrsinst());
                if (this.m_preCheck) break;
                this.setNodeList(VerificationUtil.getNodesWithCRSInstall(this.m_nodeList, this.m_resultSet));
                break;
            }
            case PREREQ_CRS_INST: {
                this.setPreCheck(this.m_globalContext.isPreCRS());
            }
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (VerificationUtil.isODALiteEnv()) {
            VerificationUtil.traceAndLog("skipping GNS integrity check in  ODA Lite environment");
            return false;
        }
        VerificationType vType = this.m_globalContext.getVerificationType();
        boolean isConfiguredGNS = this.m_globalContext.isGNSConfigured();
        String shareGns = CVUVariables.getValue(CVUVariableConstants.USE_SHARED_GNS);
        if (m_isAPImode && shareGns != null && "TRUE".equalsIgnoreCase(shareGns)) {
            return false;
        }
        try {
            this.m_leafNodeList = this.m_nodeMgr.getConfiguredRimNodes(this.m_nodeList);
        }
        catch (NodeManagerException e) {
            Trace.out((String)"no leaf nodes were found");
            this.m_leafNodeList = null;
        }
        switch (vType) {
            case PREREQ_CRS_INST: {
                if (!(this.m_leafNodeList == null || isConfiguredGNS || VerificationUtil.isHealthCheckMode() || VerificationUtil.isBaselineCollectionMode())) {
                    if (this.m_globalContext.isUpgrade()) break;
                    Trace.out((String)"There are leaf nodes but GNS is not configured");
                    return true;
                }
                return isConfiguredGNS;
            }
            case BESTPRACTICE_PRE_CRS_INST: 
            case POSTREQ_HWOS_SETUP: {
                return this.m_globalContext.isGNSConfigured();
            }
            case COMPONENT_GNS_INTEGRITY: {
                return true;
            }
        }
        return this.defaultTaskApplicability();
    }

    public TaskGNSIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskGNSIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskGNSIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing GNS Integrity verification task... ");
        if (this.m_globalContext.isUpgrade() && this.m_leafNodeList != null) {
            Trace.out((String)"UPGRADE CASE: Marking Severity of this task to FATAL");
            this.setSeverity(SeverityType.FATAL);
        }
        if (this.m_globalContext.getVerificationType().equals((Object)VerificationType.PREREQ_CRS_INST) && this.m_leafNodeList != null && !this.m_globalContext.isGNSConfigured() && !this.m_globalContext.isUpgrade()) {
            this.m_resultSet.addResult(this.m_nodeList, 3);
            String msg = s_gMsgBundle.getMessage("1062", true);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        if (this.m_globalContext.getVerificationType() == VerificationType.PREREQ_CRS_INST && VerificationUtil.isStringGood(CVUVariables.getValue(CVUVariableConstants.GNS_VIP_FULL_ADDRESS))) {
            Trace.out((int)1, (String)"dns option is chosen in pre crsinst");
            String gnsVIP = null;
            String gnsIP = null;
            String fullVIP = CVUVariables.getValue(CVUVariableConstants.GNS_VIP_FULL_ADDRESS);
            gnsVIP = fullVIP.substring(0, fullVIP.indexOf("/"));
            try {
                gnsIP = InetAddress.getByName(gnsVIP).getHostAddress();
            }
            catch (UnknownHostException e) {
                Trace.out((String)"uhe while translating gns vip");
                String errMsg = s_msgBundle.getMessage("5227", true, (Object[])new String[]{gnsVIP});
                ReportUtil.sureprintln(errMsg);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
                return false;
            }
            CVUVariables.setValue(CVUVariableConstants.USE_SHARED_GNS, "FALSE");
            CVUVariables.setValue(CVUVariableConstants.GNS_VIP_ADDRESS, gnsVIP);
            CVUVariables.setValue(CVUVariableConstants.GNS_IP_ADDRESS, gnsIP);
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5202", false));
        this.performGNSIntegrityChecks();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5203", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5204", false));
        return false;
    }

    private void performGNSIntegrityChecks() {
        String gnsVIP = null;
        String[] gnsAddress = null;
        GNSUtils gnsUtils = new GNSUtils();
        String gnsDomainName = null;
        String gnsServiceDomainName = null;
        boolean isThereDomain = true;
        boolean isGNSServer = true;
        boolean isDynamicNetwork = false;
        String[] strNets = null;
        String gnsCredFile = null;
        if (!this.m_preCheck) {
            strNets = CVUHelperUtil.checkDynamicNetwork(this.m_resultSet);
            if (strNets != null) {
                for (String dnet : strNets) {
                    if (!Boolean.parseBoolean(dnet)) continue;
                    isDynamicNetwork = true;
                    break;
                }
            } else {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                String msg = s_msgBundle.getMessage("5213", true);
                ReportUtil.sureprintln(msg);
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(errDesc);
                return;
            }
            if (!CVUHelperUtil.getGNSDomainAndVIP(this.m_resultSet, m_localNode)) {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                String msg = s_msgBundle.getMessage("5213", true);
                ReportUtil.sureprintln(msg);
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(errDesc);
                return;
            }
        }
        gnsDomainName = CVUVariables.getValue(CVUVariableConstants.GNS_SUB_DOMAIN);
        gnsServiceDomainName = CVUVariables.getValue(CVUVariableConstants.GNS_SERVICE_SUB_DOMAIN);
        gnsVIP = CVUVariables.getValue(CVUVariableConstants.GNS_VIP_ADDRESS);
        String addrs = CVUVariables.getValue(CVUVariableConstants.GNS_IP_ADDRESS);
        gnsAddress = addrs != null ? VerificationUtil.string2strArr(addrs) : null;
        isThereDomain = VerificationUtil.isStringGood(gnsDomainName);
        gnsCredFile = CVUVariables.getValue(CVUVariableConstants.GNS_CLIENT_DATA_FILE);
        isGNSServer = "FALSE".equalsIgnoreCase(CVUVariables.getValue(CVUVariableConstants.USE_SHARED_GNS));
        Trace.out((int)1, (String)("Config domain=" + gnsDomainName + LSEP + "Service domain=" + gnsServiceDomainName + LSEP + "vip=" + gnsVIP + LSEP + "address=" + VerificationUtil.strArr2String(gnsAddress, ",") + LSEP + "is there domain=" + isThereDomain + LSEP + "GNS server " + isGNSServer + LSEP + "client data file " + gnsCredFile));
        if (this.m_preCheck) {
            if (!isGNSServer) {
                String subtaskValidity = s_gMsgBundle.getMessage("2065", false);
                String subtaskResponse = s_gMsgBundle.getMessage("2066", false);
                TaskAnonymousProxy anonymousTask = null;
                ResultSet locrs = new ResultSet();
                Result res = new Result(m_localNode);
                String crsHome = VerificationUtil.getCRSHome(m_localNode, res);
                String[] gnsServerAddress = null;
                Map gnsAddressesMap = null;
                if (crsHome == null) {
                    ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
                    try {
                        GNSProperties gnsprop = clusterwareInfo.getGNSPropertiesFromManifest(gnsCredFile);
                        gnsDomainName = gnsprop.getGNSSubDomain();
                        gnsAddressesMap = gnsprop.getGNSDiscoveryAddressMap();
                        int ipsCnt = 0;
                        gnsServerAddress = new String[gnsAddressesMap.size()];
                        Iterator iterInet = gnsAddressesMap.values().iterator();
                        InetAddress ipAddress = null;
                        ipAddress = (InetAddress)iterInet.next();
                        gnsServerAddress[ipsCnt++] = ipAddress.getHostAddress();
                        while (iterInet.hasNext()) {
                            ipAddress = (InetAddress)iterInet.next();
                            gnsServerAddress[ipsCnt++] = ipAddress.getHostAddress();
                        }
                    }
                    catch (InstallException ex) {
                        VerificationUtil.traceAndLog("Could not read client data file" + gnsCredFile + ". exception mesg: " + ex.getMessage());
                        String msg = s_gMsgBundle.getMessage("1025", true) + LSEP + ex.getMessage();
                        ReportUtil.sureprintln(msg);
                        ErrorDescription errDesc = new ErrorDescription(msg);
                        locrs.addErrorDescription(errDesc);
                        locrs.addResult(this.m_nodeList, 2);
                        anonymousTask = new TaskAnonymousProxy(subtaskValidity, this.m_nodeList, this);
                        anonymousTask.performAnonymousTask(locrs);
                        return;
                    }
                    catch (CredentialsException ex) {
                        VerificationUtil.traceAndLog("Could not read client data file" + gnsCredFile + ". exception mesg: " + ex.getMessage());
                        String msg = s_gMsgBundle.getMessage("1025", true) + LSEP + ex.getMessage();
                        ReportUtil.sureprintln(msg);
                        ErrorDescription errDesc = new ErrorDescription(msg);
                        locrs.addErrorDescription(errDesc);
                        locrs.addResult(this.m_nodeList, 2);
                        anonymousTask = new TaskAnonymousProxy(subtaskValidity, this.m_nodeList, this);
                        anonymousTask.performAnonymousTask(locrs);
                        return;
                    }
                    catch (NotExistsException ex) {
                        VerificationUtil.traceAndLog("Could not read client data file" + gnsCredFile + ". exception mesg: " + ex.getMessage());
                        String msg = s_gMsgBundle.getMessage("1025", true) + LSEP + ex.getMessage();
                        ReportUtil.sureprintln(msg);
                        ErrorDescription errDesc = new ErrorDescription(msg);
                        locrs.addErrorDescription(errDesc);
                        locrs.addResult(this.m_nodeList, 2);
                        anonymousTask = new TaskAnonymousProxy(subtaskValidity, this.m_nodeList, this);
                        anonymousTask.performAnonymousTask(locrs);
                        return;
                    }
                } else {
                    Result resultCred = new Result(m_localNode);
                    if (!CVUHelperUtil.validateGNSCredential(gnsCredFile, resultCred)) {
                        ErrorDescription errDesc;
                        locrs.addResult(this.m_nodeList, 3);
                        List<VerificationError> errList = resultCred.getErrors();
                        for (VerificationError err : errList) {
                            ReportUtil.sureprintln(err.getErrorMessage());
                            errDesc = (ErrorDescription)err;
                            locrs.addErrorDescription(errDesc);
                        }
                        String msg = s_gMsgBundle.getMessage("1025", true);
                        ReportUtil.sureprintln(msg);
                        errDesc = new ErrorDescription(msg);
                        locrs.addErrorDescription(errDesc);
                        anonymousTask = new TaskAnonymousProxy(subtaskValidity, this.m_nodeList, this);
                        anonymousTask.performAnonymousTask(locrs);
                        return;
                    }
                    gnsDomainName = CVUVariables.getValue(CVUVariableConstants.GNS_SUB_DOMAIN);
                    gnsServerAddress = VerificationUtil.string2strArr(CVUVariables.getValue(CVUVariableConstants.GNS_IP_ADDRESS));
                }
                Trace.out((String)("Domain name readed from client data file " + gnsDomainName + " is read from client data file " + gnsCredFile));
                Trace.out((String)("GNS address from client file " + VerificationUtil.strArr2List(gnsServerAddress)));
                isThereDomain = true;
                if (gnsServerAddress.length > 1 || gnsServerAddress.length == 1 && IPAddressUtil.isIPv4AddressString((String)gnsServerAddress[0])) {
                    String msg;
                    try {
                        InetAddress[] allIPs = null;
                        allIPs = InetAddress.getAllByName(this.GNS_RESPONSE_SERVER + "." + gnsDomainName);
                        Trace.out((String)("Oracle-GNS has " + allIPs.length + " IP's"));
                        if (allIPs.length == 0) {
                            msg = s_msgBundle.getMessage("5218", true, (Object[])new String[]{this.GNS_RESPONSE_SERVER + "." + gnsDomainName});
                            ErrorDescription errDescr = new ErrorDescription(msg);
                            locrs.addErrorDescription(errDescr);
                            locrs.addResult(this.m_nodeList, 3);
                            ReportUtil.sureprintln(LSEP + msg);
                            anonymousTask = new TaskAnonymousProxy(subtaskValidity, this.m_nodeList, this);
                            anonymousTask.performAnonymousTask(locrs);
                        } else {
                            locrs.addResult(this.m_nodeList, 1);
                            anonymousTask = new TaskAnonymousProxy(subtaskValidity, this.m_nodeList, this);
                            anonymousTask.performAnonymousTask(locrs);
                        }
                    }
                    catch (UnknownHostException e) {
                        Trace.out((String)("Could not lookup Oracle-GNS: " + e.toString()));
                        msg = s_msgBundle.getMessage("5217", true, (Object[])new String[]{this.GNS_RESPONSE_SERVER + "." + gnsDomainName});
                        ErrorDescription errDescri = new ErrorDescription(msg);
                        locrs.addErrorDescription(errDescri);
                        ReportUtil.sureprintln(LSEP + msg);
                        locrs.addResult(this.m_nodeList, 3);
                        anonymousTask = new TaskAnonymousProxy(subtaskValidity, this.m_nodeList, this);
                        anonymousTask.performAnonymousTask(locrs);
                    }
                }
                for (int ipsCnt = 0; ipsCnt < gnsServerAddress.length; ++ipsCnt) {
                    locrs.clear();
                    boolean ipType = IPAddressUtil.isIPv4AddressString((String)gnsServerAddress[ipsCnt]);
                    Result resultEchoGns = new Result(m_localNode);
                    List<String> gnsIPs = VerificationUtil.resolveIPAddressbyName(this.GNS_RESPONSE_SERVER + "." + gnsDomainName, gnsServerAddress[ipsCnt], ipType, resultEchoGns);
                    if (gnsIPs != null) continue;
                    Trace.out((String)"Could not lookup Oracle-GNS");
                    String msg = s_gMsgBundle.getMessage("1027", true, (Object[])new String[]{this.GNS_RESPONSE_SERVER + "." + gnsDomainName, gnsServerAddress[ipsCnt]});
                    ErrorDescription errorDescr = new ErrorDescription(msg);
                    locrs.addErrorDescription(errorDescr);
                    locrs.addResult(this.m_nodeList, 3);
                    ReportUtil.sureprintln(msg);
                    anonymousTask = new TaskAnonymousProxy(subtaskResponse, this.m_nodeList, this);
                    anonymousTask.performAnonymousTask(locrs);
                    return;
                }
                locrs.addResult(this.m_nodeList, 1);
                anonymousTask = new TaskAnonymousProxy(subtaskResponse, this.m_nodeList, this);
                anonymousTask.performAnonymousTask(locrs);
            }
        } else if (!isThereDomain && isDynamicNetwork) {
            Trace.out((String)"There is DHCP but not subdomain name");
            String msg = s_gMsgBundle.getMessage("11424", true);
            ReportUtil.sureprintln(msg);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            return;
        }
        Trace.out((String)("There is domain name: " + isThereDomain));
        if (isThereDomain) {
            String subtaskName = s_gMsgBundle.getMessage("2072", false);
            TaskAnonymousProxy anonymousTask = null;
            ResultSet locrs = new ResultSet();
            anonymousTask = new TaskAnonymousProxy(subtaskName, this.m_nodeList, this);
            try {
                ReportUtil.println(s_msgBundle.getMessage("5221", false));
                boolean isValid = GNSUtils.isDomainNameValid((String)gnsDomainName);
                ReportUtil.sureprintln(s_msgBundle.getMessage("5222", false, (Object[])new String[]{gnsDomainName}));
                locrs.addResult(this.m_nodeList, 1);
                anonymousTask.performAnonymousTask(locrs);
            }
            catch (GNSException e) {
                String msg = s_msgBundle.getMessage("5223", true, (Object[])new String[]{gnsDomainName}) + LSEP + e.getMessage();
                ReportUtil.sureprintln(msg);
                locrs.addResult(this.m_nodeList, 2);
                ErrorDescription errDesc = new ErrorDescription(msg);
                locrs.addErrorDescription(errDesc);
                anonymousTask.performAnonymousTask(locrs);
            }
        }
        if (isGNSServer) {
            String[] stringArray;
            Trace.out((String)"starting GNS-VIP subnet check");
            if (this.m_preCheck) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = gnsVIP;
            } else {
                stringArray = gnsAddress;
            }
            this.performGNSVIPSubnetCheck(stringArray);
            Trace.out((String)"starting VIP validity check");
            this.performGNSVIPValidityCheck(this.m_isAddNode || !this.m_preCheck ? gnsAddress[0] : gnsVIP);
            if (!this.m_preCheck) {
                if (isThereDomain && isDynamicNetwork) {
                    Trace.out((String)"starting name resolution check");
                    this.performNameResolutionCheck(gnsDomainName, gnsServiceDomainName, strNets);
                }
                Trace.out((String)"starting post crsinst resource check");
                List<Object> gnsDataList = new ArrayList();
                CollectionResultSet<List<GNSData>> collectRS = CVUHelperUtil.getGNSStatus();
                if (collectRS.getOverallStatus() == OverallStatus.SUCCESSFUL) {
                    try {
                        gnsDataList = collectRS.getCollectedClusterwideValue();
                    }
                    catch (ClusterwideCollectionUnavailableException e) {
                        Trace.out((String)e.getMessage());
                    }
                } else {
                    List<VerificationError> errLst = collectRS.getErrors();
                    this.m_resultSet.uploadResultSet((ResultSet)((Object)collectRS));
                    ReportUtil.reportAllerrors((ResultSet)((Object)collectRS));
                }
                if (gnsDataList.size() > 0) {
                    this.performGNSResourceCheck(gnsDataList);
                    this.performGNSVIPResourceCheck(gnsDataList);
                }
            }
            if (this.m_preCheck && !this.m_globalContext.isUpgrade()) {
                ResultSet portRsltSet = new ResultSet();
                String taskName = s_gMsgBundle.getMessage("0336", false, (Object[])new String[]{this.m_portNumber, this.m_compName});
                TaskAnonymousProxy anonymousProxy = new TaskAnonymousProxy(taskName, this.m_nodeList, this);
                this.checkPortAvailability(portRsltSet);
                anonymousProxy.performAnonymousTask(portRsltSet);
            }
        }
    }

    private void performGNSVIPSubnetCheck(String[] gnsVIP) {
        String msg;
        Object[] gnsInetAddress = null;
        Set<NetworkInfo> networks = null;
        StringBuilder matchingSubNet = new StringBuilder();
        boolean subNetFound = true;
        String gnsVipAddress = null;
        String subtaskName = s_gMsgBundle.getMessage("2073", false);
        TaskAnonymousProxy anonymousTask = null;
        ResultSet locrs = null;
        if (this.m_preCheck && CVUVariables.getValue(CVUVariableConstants.INTERCONNECT_LIST) == null) {
            return;
        }
        locrs = new ResultSet();
        ReportUtil.sureprintln(s_msgBundle.getMessage("5224", false));
        try {
            if (this.m_preCheck) {
                if (IPAddressUtil.isIPAddressString((String)gnsVIP[0])) {
                    gnsInetAddress = new InetAddress[]{InetAddress.getByName(gnsVIP[0])};
                    gnsVipAddress = gnsInetAddress[0].getHostAddress();
                } else {
                    gnsInetAddress = InetAddress.getAllByName(gnsVIP[0]);
                    if (gnsInetAddress.length > 2) {
                        return;
                    }
                    if (gnsInetAddress.length == 2 && gnsInetAddress[0] instanceof Inet4Address == gnsInetAddress[1] instanceof Inet4Address) {
                        return;
                    }
                    gnsVipAddress = gnsInetAddress[0].getHostAddress();
                }
            } else {
                gnsInetAddress = new InetAddress[gnsVIP.length];
                gnsInetAddress[0] = InetAddress.getByName(gnsVIP[0]);
                gnsVipAddress = gnsInetAddress[0].getHostAddress();
                if (gnsVIP.length > 1) {
                    gnsInetAddress[1] = InetAddress.getByName(gnsVIP[1]);
                    gnsVipAddress = gnsVipAddress + "," + ((InetAddress)gnsInetAddress[1]).getHostAddress();
                }
            }
            Trace.out((String)("Inet address for GNSVIP is " + VerificationUtil.objArr2String(gnsInetAddress)));
            networks = VerificationUtil.getIPNetworks("localnode", (InetAddress)gnsInetAddress[0], this.m_preCheck, locrs);
            if (gnsVIP.length > 1) {
                ResultSet rsltSet = new ResultSet();
                Set<NetworkInfo> networksGnsVip = VerificationUtil.getIPNetworks("localnode", (InetAddress)gnsInetAddress[1], this.m_preCheck, rsltSet);
                locrs.addResultSetData(rsltSet);
                networks.addAll(networksGnsVip);
            }
        }
        catch (UnknownHostException e) {
            anonymousTask = new TaskAnonymousProxy(subtaskName, this.m_nodeList, this);
            this.displayGNSFailureMessage(e, anonymousTask, locrs);
            return;
        }
        catch (InstallException e) {
            anonymousTask = new TaskAnonymousProxy(subtaskName, this.m_nodeList, this);
            this.displayGNSFailureMessage((Exception)((Object)e), anonymousTask, locrs);
            return;
        }
        catch (CVUException e) {
            anonymousTask = new TaskAnonymousProxy(subtaskName, this.m_nodeList, this);
            this.displayGNSFailureMessage(e, anonymousTask, locrs);
            return;
        }
        if (!NetworkUtility.isNetworksSetGood(networks)) {
            Trace.out((String)"oifcfg returned empty list");
            subNetFound = false;
        }
        if (subNetFound) {
            Trace.out((String)"matching subnets found");
            for (NetworkInfo network : networks) {
                Trace.out((String)network.toString());
                if (matchingSubNet.indexOf(network.getSubnetAsString()) != -1 || (network.getNetworkType() & NetworkConstants.NetworkType.PUBLIC.getValue()) == 0 && (network.getNetworkType() & NetworkConstants.NetworkType.UNKNOWN.getValue()) == 0) continue;
                if (matchingSubNet.length() != 0) {
                    matchingSubNet.append(", ");
                }
                matchingSubNet.append(network.getSubnet());
            }
            if (matchingSubNet.length() > 0) {
                Trace.out((String)("GNS VIP " + gnsVIP + " match with public sunnets " + matchingSubNet.toString()));
                msg = s_msgBundle.getMessage("5234", false, (Object[])new String[]{matchingSubNet.toString(), gnsVipAddress});
                ReportUtil.sureprintln(msg);
                locrs.addResult(this.m_nodeList, 1);
                anonymousTask = new TaskAnonymousProxy(subtaskName, this.m_nodeList, this);
                anonymousTask.performAnonymousTask(locrs);
                return;
            }
            Trace.out((String)"no matching public subnet");
            subNetFound = false;
        }
        if (!subNetFound) {
            msg = s_msgBundle.getMessage("5233", true, (Object[])new String[]{gnsVipAddress});
            ReportUtil.sureprintln(msg);
            locrs.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(msg);
            locrs.addErrorDescription(errDesc);
            anonymousTask = new TaskAnonymousProxy(subtaskName, this.m_nodeList, this);
            anonymousTask.performAnonymousTask(locrs);
            return;
        }
    }

    private void performGNSVIPValidityCheck(String gnsVIP) {
        Result resultValidVip = new Result(m_localNode);
        String subtaskName = s_gMsgBundle.getMessage("2074", false);
        TaskAnonymousProxy anonymousTask = null;
        anonymousTask = new TaskAnonymousProxy(subtaskName, this.m_nodeList, this);
        ResultSet locrs = new ResultSet();
        if (!IPAddressUtil.isIPAddressString((String)gnsVIP)) {
            ReportUtil.println(s_msgBundle.getMessage("5225", false));
            if (this.m_isAddNode || !this.m_preCheck) {
                Trace.out((String)"about to call isValidGNSVIP");
                CVUHelperUtil.isValidGNSVIP(gnsVIP, false, resultValidVip);
                if (resultValidVip.getStatus() == 2) {
                    String errMsg = "";
                    locrs.addResult(this.m_nodeList, 3);
                    List<VerificationError> errList = resultValidVip.getErrors();
                    for (VerificationError err : errList) {
                        errMsg = errMsg + err.getErrorMessage() + LSEP;
                    }
                    ErrorDescription errDesc = new ErrorDescription(errMsg);
                    locrs.addErrorDescription(errDesc);
                    anonymousTask.performAnonymousTask(locrs);
                    ReportUtil.sureprintln(errMsg);
                    Trace.out((String)("cvuhelper has failed with error " + errMsg));
                    return;
                }
            } else {
                try {
                    boolean isValid = GNSUtils.isValidGNSVIP((String)gnsVIP, (boolean)this.m_preCheck);
                    Trace.out((String)("is valid gnsvip " + isValid));
                }
                catch (GNSException e) {
                    locrs.addResult(this.m_nodeList, 3);
                    ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                    locrs.addErrorDescription(errDesc);
                    anonymousTask.performAnonymousTask(locrs);
                    ReportUtil.sureprintln(e.getMessage());
                    Trace.out((String)("error while checking if gnsvip is valid " + e.getMessage()));
                    return;
                }
            }
            locrs.addResult(this.m_nodeList, 1);
            ReportUtil.sureprintln(s_msgBundle.getMessage("5226", false, (Object[])new String[]{gnsVIP}));
        } else {
            locrs.addResult(this.m_nodeList, 1);
            ReportUtil.sureprintln(s_msgBundle.getMessage("5226", false, (Object[])new String[]{gnsVIP}));
        }
        ReportUtil.println(s_msgBundle.getMessage("5228", false));
        ClusterCmd clusterCmd = new ClusterCmd();
        String[] gnsVIPArr = new String[]{gnsVIP};
        boolean nodeAlive = false;
        try {
            nodeAlive = clusterCmd.areNodesAlive(gnsVIPArr, 5, null);
        }
        catch (RemoteFileOperationException e) {
            if (!this.m_preCheck || this.m_isAddNode) {
                this.displayGNSFailureMessage((Exception)((Object)e), anonymousTask, locrs);
            } else {
                anonymousTask.performAnonymousTask(locrs);
            }
            return;
        }
        catch (ClusterException e) {
            if (!this.m_preCheck || this.m_isAddNode) {
                this.displayGNSFailureMessage((Exception)((Object)e), anonymousTask, locrs);
            } else {
                anonymousTask.performAnonymousTask(locrs);
            }
            return;
        }
        if (nodeAlive && this.m_preCheck && !this.m_isAddNode) {
            if (VerificationUtil.isUpgrade()) {
                locrs.addResult(this.m_nodeList, 4);
            } else {
                locrs.addResult(this.m_nodeList, 3);
            }
            String msg = s_msgBundle.getMessage("5229", true, (Object[])new String[]{gnsVIP});
            ErrorDescription errDesc = new ErrorDescription(msg);
            locrs.addErrorDescription(errDesc);
            anonymousTask.performAnonymousTask(locrs);
            ReportUtil.sureprintln(msg);
            return;
        }
        if (!nodeAlive && !this.m_preCheck) {
            String msg = s_msgBundle.getMessage("5230", true, (Object[])new String[]{gnsVIP});
            ErrorDescription errDesc = new ErrorDescription(msg);
            locrs.addErrorDescription(errDesc);
            locrs.addResult(this.m_nodeList, 3);
            anonymousTask.performAnonymousTask(locrs);
            ReportUtil.sureprintln(msg);
            return;
        }
        locrs.addResult(this.m_nodeList, 1);
        anonymousTask.performAnonymousTask(locrs);
    }

    private void performNameResolutionCheck(String fullyQualifiedConfigDomainName, String fullyQualifiedServiceDomainName, String[] strNets) {
        String subtaskName = s_gMsgBundle.getMessage("2075", false);
        TaskAnonymousProxy anonymousTask = null;
        anonymousTask = new TaskAnonymousProxy(subtaskName, this.m_nodeList, this);
        ResultSet locrs = new ResultSet();
        Hashtable<String, String> addressCheckTable = new Hashtable<String, String>();
        if (Boolean.parseBoolean(strNets[0])) {
            for (String node : this.m_nodeList) {
                addressCheckTable.put(node + "-vip", node);
            }
        }
        for (int cnt = 1; cnt < strNets.length; ++cnt) {
            int netNum = cnt + 1;
            for (String node : this.m_nodeList) {
                addressCheckTable.put(node + "_" + netNum + "-vip", node);
            }
        }
        String[] args = new String[]{this.GNS_SCAN_NAME_HELPER_ARG};
        String[] env = null;
        CVUHelperExec helperExec = null;
        boolean continueParsing = false;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
            continueParsing = true;
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            String errMsg = s_gMsgBundle.getMessage("1009", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(errMsg);
        }
        if (continueParsing) {
            if (helperExec.getExitValue() == 2) {
                Trace.out((String)"cvuhelper failed to execute");
                String errMsg = s_gMsgBundle.getMessage("1005", true, (Object[])new String[]{helperExec.getCommandString()}) + LSEP + helperExec.getErrorString();
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
                ReportUtil.printError(errMsg);
                continueParsing = false;
            }
            if (continueParsing) {
                String[] output = helperExec.getOutput();
                String[] errorArray = null;
                if (output.length != 0) {
                    String outputStr = helperExec.getOutputString();
                    Trace.out((String)outputStr);
                    int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
                    if (status == 2) {
                        Trace.out((String)"error during cvu helper execution");
                        errorArray = CVUHelperUtil.fetchError(output);
                        String errMsg = VerificationUtil.strArr2String(errorArray, LSEP);
                        ErrorDescription errorDesc = new ErrorDescription(errMsg);
                        this.m_resultSet.addResult(this.m_nodeList, 2);
                        this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
                        ReportUtil.printError(errMsg);
                    } else {
                        Trace.out((int)1, (String)"all data collected");
                        String scanName = VerificationUtil.fetchTextByTags(outputStr, null, "<SCN_NME>", "</SCN_NME>");
                        if (!IPAddressUtil.isIPAddressString((String)scanName)) {
                            addressCheckTable.put(scanName, this.m_nodeList[0]);
                        } else {
                            Trace.out((String)"skipping scanName as it is an dotted ip");
                        }
                    }
                } else {
                    Trace.out((String)"cvuhelper failed to execute");
                    String errMsg = s_gMsgBundle.getMessage("1005", true, (Object[])new String[]{helperExec.getCommandString()}) + LSEP + helperExec.getErrorString();
                    ErrorDescription errorDesc = new ErrorDescription(errMsg);
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
                    ReportUtil.printError(errMsg);
                }
            }
        }
        ReportUtil.println(s_msgBundle.getMessage("5214", false, (Object[])new String[]{fullyQualifiedServiceDomainName}));
        ArrayList<GetAllByNameThread> getAllByNameVect = new ArrayList<GetAllByNameThread>();
        Enumeration lookUpNodes = addressCheckTable.keys();
        while (lookUpNodes.hasMoreElements()) {
            String node = (String)lookUpNodes.nextElement();
            String fullyQualifiedMachineName = node;
            if (!fullyQualifiedMachineName.endsWith(fullyQualifiedConfigDomainName) && !fullyQualifiedMachineName.endsWith(fullyQualifiedServiceDomainName)) {
                fullyQualifiedMachineName = fullyQualifiedMachineName + "." + fullyQualifiedServiceDomainName;
            }
            Trace.out((String)("Trying FQMN = " + fullyQualifiedMachineName));
            GetAllByNameThread getByNameThread = new GetAllByNameThread(fullyQualifiedMachineName, (String)addressCheckTable.get(node));
            getAllByNameVect.add(getByNameThread);
            getByNameThread.start();
        }
        for (GetAllByNameThread getByNameThread : getAllByNameVect) {
            ErrorDescription errDesc;
            String msg;
            boolean skipToNextThread = false;
            String errMsg = null;
            try {
                getByNameThread.join();
            }
            catch (InterruptedException e) {
                Trace.out((String)"Interrupt while looking up name");
                errMsg = e.getMessage();
                skipToNextThread = true;
            }
            long checkStartTime = getByNameThread.getCheckStartTime();
            long checkEndTime = getByNameThread.getCheckEndTime();
            String fullyQualifiedMachineName = getByNameThread.getLookupName();
            String node = getByNameThread.getErrNodeName();
            locrs.addResult(node, 1);
            Trace.out((String)("error reporting node is : " + node));
            InetAddress[] allIPs = getByNameThread.getAllIPAddress();
            UnknownHostException uhe = getByNameThread.getUnknownHostException();
            if (errMsg != null) {
                this.m_resultSet.addResult(node, 2);
                msg = s_msgBundle.getMessage("5217", true, (Object[])new String[]{fullyQualifiedMachineName}) + LSEP + errMsg;
                errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(errDesc);
                ReportUtil.sureprintln(msg);
                continue;
            }
            if (uhe != null) {
                Trace.out((String)"UHE while trying to get IP's for FDQN");
                msg = s_msgBundle.getMessage("5218", true, (Object[])new String[]{fullyQualifiedMachineName});
                errDesc = new ErrorDescription(msg);
                locrs.addErrorDescription(errDesc);
                locrs.addResult(node, 4);
                ReportUtil.printWarning(LSEP + msg);
                skipToNextThread = true;
            }
            this.checkTimeIntervals(checkStartTime, checkEndTime, fullyQualifiedMachineName, locrs, node);
            if (skipToNextThread) continue;
            Trace.out((String)("FQDN has " + allIPs.length + "IP's"));
            if (allIPs.length == 0) {
                msg = s_msgBundle.getMessage("5218", true, (Object[])new String[]{fullyQualifiedMachineName});
                errDesc = new ErrorDescription(msg);
                locrs.addErrorDescription(errDesc);
                locrs.addResult(node, 3);
                ReportUtil.sureprintln(LSEP + msg);
                continue;
            }
            String[] allIPStringArray = new String[allIPs.length];
            for (int i = 0; i < allIPs.length; ++i) {
                allIPStringArray[i] = allIPs[i].getHostAddress();
            }
            boolean[] nodeConArray = new boolean[allIPs.length];
            String[] nodeErrorArray = new String[allIPs.length];
            VerifyNetwork vfyNet = new VerifyNetwork();
            boolean reach = false;
            try {
                reach = vfyNet.checkReachFromLocalNode(allIPStringArray, nodeConArray, nodeErrorArray);
            }
            catch (NetworkException e) {
                Trace.out((String)"GNS resolved IP is unreachable");
                String msg2 = e.getMessage();
                ErrorDescription errDesc2 = new ErrorDescription(msg2);
                this.m_resultSet.addErrorDescription(errDesc2);
                ReportUtil.sureprintln(LSEP + msg2);
                return;
            }
            if (reach) {
                locrs.addResult(node, 1);
                ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5215", false));
                continue;
            }
            ArrayList<String> unReachableIPs = new ArrayList<String>();
            String unreachableIPReason = null;
            for (int i = 0; i < allIPs.length; ++i) {
                if (nodeConArray[i]) continue;
                unReachableIPs.add(allIPStringArray[i]);
                unreachableIPReason = unreachableIPReason == null ? nodeErrorArray[i] : unreachableIPReason + LSEP + nodeErrorArray[i];
            }
            String msg3 = s_msgBundle.getMessage("5216", true, (Object[])new String[]{fullyQualifiedMachineName, VerificationUtil.strList2List(unReachableIPs)}) + LSEP + unreachableIPReason;
            locrs.addResult(node, 3);
            ErrorDescription errDesc3 = new ErrorDescription(msg3);
            locrs.addErrorDescription(errDesc3);
            ReportUtil.sureprintln(LSEP + msg3);
        }
        anonymousTask.performAnonymousTask(locrs);
    }

    private void checkTimeIntervals(long checkStartTime, long checkEndTime, String lookupName, ResultSet resultSet, String node) {
        long acceptableDNSResponseTime = 15000L;
        if (checkEndTime - checkStartTime > acceptableDNSResponseTime) {
            Trace.out((String)("currentTime=" + checkEndTime + "Start time =" + checkStartTime));
            String msg = s_msgBundle.getMessage("5827", true, (Object[])new String[]{Long.toString(acceptableDNSResponseTime / 1000L), lookupName});
            resultSet.addResult(node, 3);
            ErrorDescription errDesc = new ErrorDescription(msg);
            resultSet.addErrorDescription(node, errDesc);
            ReportUtil.sureprintln(msg);
        }
    }

    private void performGNSVIPResourceCheck(List<GNSData> gnsDataList) {
        ErrorDescription errDesc;
        String msg;
        ReportUtil.println(s_msgBundle.getMessage("5208", false));
        boolean isGNSVIPRunningOnSameNode = false;
        boolean gnsVIPFirstNodeFound = false;
        ArrayList<String> gnsVIPRunningNodes = new ArrayList<String>();
        ArrayList<String> gnsRunningNodes = new ArrayList<String>();
        String subtaskVipResource = s_gMsgBundle.getMessage("2077", false);
        TaskAnonymousProxy anonymousTask = null;
        ResultSet locrs = new ResultSet();
        Task previousTaskReference = null;
        anonymousTask = new TaskAnonymousProxy(subtaskVipResource, this.m_nodeList, this);
        previousTaskReference = ReportUtil.setTaskReference(anonymousTask);
        if (ReportUtil.getOldFormat()) {
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8003", false), s_msgBundle.getMessage("5207", false));
        } else if (ReportUtil.isVerbose()) {
            ReportUtil.reportwriteColHeaders(s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8003", false), s_msgBundle.getMessage("5207", false));
        }
        Trace.out((String)"starting GNS-VIP resource check");
        for (GNSData gnsData : gnsDataList) {
            String nodeName = gnsData.getNodeName();
            ArrayList vipStateList = new ArrayList();
            boolean isEnabled = gnsData.isGNSVIPEnabled();
            boolean nodeRunningState = gnsData.isGNSVIPRunning();
            if (gnsData.isGNSRunning()) {
                gnsRunningNodes.add(nodeName);
            }
            if (!gnsVIPFirstNodeFound) {
                if (nodeRunningState) {
                    Trace.out((String)("first node with running GNSVIP :" + nodeName));
                    gnsVIPFirstNodeFound = true;
                    gnsVIPRunningNodes.add(nodeName);
                    if (gnsData.isGNSRunning()) {
                        isGNSVIPRunningOnSameNode = true;
                    }
                }
            } else if (nodeRunningState) {
                Trace.out((String)("more than one node running GNS-VIP. Current:" + nodeName + "first:" + (String)gnsVIPRunningNodes.get(0)));
                gnsVIPRunningNodes.add(nodeName);
                isGNSVIPRunningOnSameNode = false;
            }
            if (ReportUtil.getOldFormat()) {
                ReportUtil.writeRecord(nodeName, nodeRunningState ? ReportUtil.YES : ReportUtil.NO, isEnabled ? ReportUtil.YES : ReportUtil.NO);
                continue;
            }
            if (!ReportUtil.isVerbose()) continue;
            ReportUtil.reportwriteRecord(nodeName, nodeRunningState ? ReportUtil.YES : ReportUtil.NO, isEnabled ? ReportUtil.YES : ReportUtil.NO);
        }
        if (isGNSVIPRunningOnSameNode) {
            locrs.addResult(this.m_nodeList, 1);
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5209", false));
        } else if (gnsVIPRunningNodes.size() > 0 && gnsRunningNodes.size() > 0) {
            Trace.out((String)"GNS and GNS-VIP are on different machines");
            locrs.addResult((String)gnsVIPRunningNodes.get(0), 3);
            msg = s_msgBundle.getMessage("5219", true, (Object[])new String[]{VerificationUtil.strList2List(gnsVIPRunningNodes), VerificationUtil.strList2List(gnsRunningNodes)});
            errDesc = new ErrorDescription(msg);
            locrs.getResult((String)gnsVIPRunningNodes.get(0)).addErrorDescription(errDesc);
        } else if (gnsVIPRunningNodes.size() == 0) {
            Trace.out((String)"No GNSVIP on any nodes");
            locrs.addResult(this.m_nodeList, 3);
            msg = s_msgBundle.getMessage("5220", true);
            errDesc = new ErrorDescription(msg);
            locrs.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
        }
        ReportUtil.setTaskReference(previousTaskReference);
        anonymousTask.performAnonymousTask(locrs);
    }

    private void performGNSResourceCheck(List<GNSData> gnsDataList) {
        String msg;
        boolean isGNSRunningOnNode = false;
        ArrayList<String> gnsRunningNodes = new ArrayList<String>();
        String subtaskResource = s_gMsgBundle.getMessage("2076", false);
        TaskAnonymousProxy anonymousTask = null;
        ResultSet locrs = new ResultSet();
        Task previousTaskReference = null;
        anonymousTask = new TaskAnonymousProxy(subtaskResource, this.m_nodeList, this);
        previousTaskReference = ReportUtil.setTaskReference(anonymousTask);
        ReportUtil.println(s_msgBundle.getMessage("5206", false));
        if (ReportUtil.getOldFormat()) {
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8003", false), s_msgBundle.getMessage("5207", false));
        } else if (ReportUtil.isVerbose()) {
            ReportUtil.reportwriteColHeaders(s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8003", false), s_msgBundle.getMessage("5207", false));
        }
        for (GNSData gnsData : gnsDataList) {
            String nodeName = gnsData.getNodeName();
            boolean isEnabled = gnsData.isGNSEnabled();
            boolean nodeRunningState = gnsData.isGNSRunning();
            Trace.out((String)("results for " + nodeName));
            if (!isGNSRunningOnNode) {
                if (nodeRunningState) {
                    Trace.out((String)("first node with running GNS :" + nodeName));
                    gnsRunningNodes.add(nodeName);
                    isGNSRunningOnNode = true;
                }
            } else if (nodeRunningState) {
                Trace.out((String)("more than one node running GNS. Current:" + nodeName + "first:" + (String)gnsRunningNodes.get(0)));
                gnsRunningNodes.add(nodeName);
            }
            if (ReportUtil.getOldFormat()) {
                ReportUtil.writeRecord(nodeName, nodeRunningState ? ReportUtil.YES : ReportUtil.NO, isEnabled ? ReportUtil.YES : ReportUtil.NO);
                continue;
            }
            if (!ReportUtil.isVerbose()) continue;
            ReportUtil.reportwriteRecord(nodeName, nodeRunningState ? ReportUtil.YES : ReportUtil.NO, isEnabled ? ReportUtil.YES : ReportUtil.NO);
        }
        if (gnsRunningNodes.size() > 1) {
            Trace.out((String)"gns running on more than one node");
            locrs.addResult(this.m_nodeList, 3);
            msg = s_msgBundle.getMessage("5210", true, (Object[])new String[]{VerificationUtil.strList2List(gnsRunningNodes)});
            ErrorDescription errDesc = new ErrorDescription(msg);
            ReportUtil.sureprintln(msg);
            locrs.addErrorDescription(errDesc);
        } else if (gnsRunningNodes.size() == 0) {
            Trace.out((String)"No GNS on any nodes");
            locrs.addResult(this.m_nodeList, 3);
            msg = s_msgBundle.getMessage("5211", true);
            ErrorDescription errDesc = new ErrorDescription(msg);
            locrs.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
        } else {
            locrs.addResult(this.m_nodeList, 1);
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5212", false));
        }
        ReportUtil.setTaskReference(previousTaskReference);
        anonymousTask.performAnonymousTask(locrs);
    }

    private void displayGNSFailureMessage(Exception e, TaskAnonymousProxy subTask, ResultSet resultSet) {
        Trace.out((String)("exception : " + e.getMessage()));
        resultSet.addResult(this.m_nodeList, 3);
        String msg = s_msgBundle.getMessage("5213", true) + LSEP + e.getMessage();
        ErrorDescription errDesc = new ErrorDescription(msg);
        resultSet.addErrorDescription(errDesc);
        subTask.performAnonymousTask(resultSet);
        ReportUtil.sureprintln(msg);
    }

    private void checkPortAvailability(ResultSet portRsltSet) {
        GlobalExecution globalExec = new GlobalExecution();
        ArrayList<String> verificationFailedNodes = new ArrayList<String>();
        ResultSet locrs = new ResultSet();
        NetworkConstants.NetworkProtocol protocol = NetworkConstants.NetworkProtocol.UDP;
        String errMsg = null;
        VerificationUtil.traceAndLog("Checking port " + this.m_portNumber + " is available for " + this.m_compName + " component");
        globalExec.checkPortNumber(this.m_nodeList, this.m_portNumber, protocol, locrs);
        Hashtable ht = locrs.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result != null && result.getStatus() == 3) {
                VerificationUtil.traceAndLog("Port " + this.m_portNumber + " Required for " + this.m_compName + "  found busy and used on node " + node);
                verificationFailedNodes.add(node);
                continue;
            }
            if (result != null && result.getStatus() == 1) {
                VerificationUtil.traceAndLog("Port " + this.m_portNumber + " Required for " + this.m_compName + " is available or free on node " + node);
                portRsltSet.addResult(node, 1);
                continue;
            }
            VerificationUtil.traceAndLog("Port " + this.m_portNumber + " Required for " + this.m_compName + " could not be checked on node " + node);
            errMsg = s_gMsgBundle.getMessage("0329", true, (Object[])new String[]{protocol.toString(), this.m_portNumber, node}) + LSEP + result.getExecutionErrorDetails();
            portRsltSet.addErrorDescription(node, new ErrorDescription(errMsg));
            portRsltSet.addResult(node, 3);
            ReportUtil.sureprintln(errMsg);
        }
        if (verificationFailedNodes.size() > 0) {
            errMsg = s_gMsgBundle.getMessage("0330", true, (Object[])new String[]{protocol.toString(), this.m_portNumber, this.m_compName, VerificationUtil.strCollection2String(verificationFailedNodes)});
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            portRsltSet.addErrorDescription(verificationFailedNodes, errDesc);
            portRsltSet.addResult(verificationFailedNodes, 3);
            ReportUtil.printError(errMsg);
        }
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4445", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("5200", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        return sb.toString();
    }

    public void setPreCheck(boolean preCheck) {
        this.m_preCheck = preCheck;
    }

    public boolean getPreCheck() {
        return this.m_preCheck;
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }

    public void setAddNode() {
        this.m_isAddNode = true;
    }

    private boolean defaultTaskApplicability() {
        String actCRSVer = VerificationUtil.getCRSActiveVersion();
        if (VerificationUtil.isStringGood(actCRSVer)) {
            if (!VerificationUtil.isVersionPre(actCRSVer, "11.2")) {
                ResultSet gnsResultSet = new ResultSet();
                String localNode = VerificationUtil.getLocalNode();
                if (CVUHelperUtil.getGNSDomainAndVIP(gnsResultSet, localNode, true)) {
                    VerificationUtil.traceAndLog("GNS Domain and VIP are available, adding GNS integrity check");
                    return true;
                }
                VerificationUtil.traceAndLog("GNS Domain and VIP could not be determined, NOT adding GNS integrity check");
                return false;
            }
            VerificationUtil.traceAndLog("Source home CRS version is pre 11.2, NOT adding GNS integrity checks");
            return false;
        }
        VerificationUtil.traceAndLog("Source home CRS version could not be retrieved and hence NOT adding GNS integrity checks");
        return false;
    }
}

