/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.ParamPreReqNodeAddDel;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.cluster.verification.constraints.XmlTaskFactory;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.engine.factory.parser.TaskFactoryXmlParser;
import oracle.ops.verification.framework.engine.task.ContainerTaskInterface;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskCheckMediaSense;
import oracle.ops.verification.framework.engine.task.TaskClusterwareConfigOutsideHome;
import oracle.ops.verification.framework.engine.task.TaskContainerKernelParams;
import oracle.ops.verification.framework.engine.task.TaskContainerPackages;
import oracle.ops.verification.framework.engine.task.TaskCurrentGroupID;
import oracle.ops.verification.framework.engine.task.TaskDomainSockets;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.engine.task.TaskFreeSpace;
import oracle.ops.verification.framework.engine.task.TaskKernelVersion;
import oracle.ops.verification.framework.engine.task.TaskRunLevel;
import oracle.ops.verification.framework.engine.task.TaskTimeZoneSetting;
import oracle.ops.verification.framework.engine.task.TaskUsersWithSameID;
import oracle.ops.verification.framework.engine.task.sTaskRootConsistency;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.VerifyStorage;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class TaskFactory
implements VerificationAPIConstants {
    private static TaskFactory _taskFactory;
    private TaskFactoryXmlParser m_taskFactoryXmlParser = new TaskFactoryXmlParser();
    private GlobalVerificationContext m_globalContext = GlobalVerificationContext.getInstance();
    static final String FSEP;
    static final String LSEP;

    private TaskFactory() throws TaskFactoryException {
    }

    public static synchronized TaskFactory getInstance() throws TaskFactoryException {
        if (_taskFactory == null) {
            _taskFactory = new TaskFactory();
        }
        return _taskFactory;
    }

    public List<Task> getTaskList(VerificationType vfyType, String[] nodeList, ParamPreReq param, MultiTaskHandler multiTaskHandler) throws TaskFactoryException, PreReqNotSupportedException {
        return this.getTaskList(vfyType, nodeList, param, multiTaskHandler, true);
    }

    public List<Task> getTaskList(VerificationType vfyType, String[] nodeList, ParamPreReq param, MultiTaskHandler multiTaskHandler, boolean clearCache) throws TaskFactoryException, PreReqNotSupportedException {
        List<Task> taskList = this.getTaskList(vfyType, nodeList, param, clearCache);
        for (Task task : taskList) {
            if (task.hasSubtasks()) {
                try {
                    List<VerificationTask> subTaskList = task.getSubtasks();
                    for (VerificationTask subTask : subTaskList) {
                        ((Task)subTask).setMultiTaskHandler(multiTaskHandler);
                    }
                    continue;
                }
                catch (SubtasksUnavailableException e) {
                    throw new TaskFactoryException(e);
                }
            }
            task.setMultiTaskHandler(multiTaskHandler);
        }
        return taskList;
    }

    public List<Task> getTaskList(VerificationType vfyType, String[] nodeList, boolean clearCache) throws TaskFactoryException, PreReqNotSupportedException {
        return this.getTaskList(vfyType, nodeList, (ParamPreReq)null, clearCache);
    }

    public List<Task> getTaskList(VerificationType vfyType, String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        return this.getTaskList(vfyType, nodeList, true);
    }

    public List<Task> getTaskList(VerificationType vfyType, String[] nodeList, MultiTaskHandler multiTaskHandler) throws TaskFactoryException, PreReqNotSupportedException {
        return this.getTaskList(vfyType, nodeList, multiTaskHandler, true);
    }

    public List<Task> getTaskList(VerificationType vfyType, String[] nodeList, MultiTaskHandler multiTaskHandler, boolean clearCache) throws TaskFactoryException, PreReqNotSupportedException {
        return this.getTaskList(vfyType, nodeList, null, multiTaskHandler, clearCache);
    }

    public List<Task> getTaskList(VerificationType vfyType, String[] nodeList, ParamPreReq param) throws TaskFactoryException, PreReqNotSupportedException {
        return this.getTaskList(vfyType, nodeList, param, true);
    }

    public List<Task> getTaskList(VerificationType vfyType, String[] nodeList, ParamPreReq param, boolean clearCache) throws TaskFactoryException, PreReqNotSupportedException {
        if (this.m_globalContext == null) {
            this.m_globalContext = GlobalVerificationContext.getInstance();
        }
        this.m_globalContext.setVerificationType(vfyType);
        if (clearCache) {
            Trace.out((String)"Clearing all cached details");
            VerificationUtil.clearCache();
        }
        try {
            this.m_globalContext.setParamPrereq(param, vfyType);
        }
        catch (VerificationException e) {
            Trace.out((String)("Caught VerificationException while setting the param prereq. Error is :" + e.getMessage()));
            throw new TaskFactoryException(e);
        }
        ArrayList<Task> generatedTaskList = new ArrayList<Task>();
        switch (vfyType) {
            case PREREQ_GENERIC_INST: 
            case SYSREQ_CRS: 
            case SYSREQ_DB: 
            case SYSREQ_SI_HA: 
            case SYSREQ_SI_DB: 
            case PREREQ_APPLICATION_CLUSTER_INST: {
                generatedTaskList.addAll(this.getSystemRequirementTasks(vfyType, param, nodeList));
                break;
            }
            case PREREQ_CRS_INST: {
                generatedTaskList.addAll(this.getSystemRequirementTasks(vfyType, param, nodeList));
                generatedTaskList.addAll(this.getXmlTaskList(vfyType, nodeList));
                break;
            }
            case PREREQ_DB_INST: {
                generatedTaskList.addAll(this.getSystemRequirementTasks(vfyType, param, nodeList));
                generatedTaskList.addAll(this.getXmlTaskList(vfyType, nodeList));
                break;
            }
            case PREREQ_DB_PROV: {
                generatedTaskList.addAll(this.getSystemRequirementTasks(vfyType, param, nodeList));
                generatedTaskList.addAll(this.getXmlTaskList(vfyType, nodeList));
                break;
            }
            case PREREQ_DB_CONFIG: {
                generatedTaskList.addAll(this.getSystemRequirementTasks(vfyType, param, nodeList));
                generatedTaskList.addAll(this.getXmlTaskList(vfyType, nodeList));
                break;
            }
            case PREREQ_SI_HA_INST: {
                generatedTaskList.addAll(this.getSystemRequirementTasks(vfyType, param, nodeList));
                generatedTaskList.addAll(this.getXmlTaskList(vfyType, nodeList));
                break;
            }
            case PREREQ_SI_DB_INST: {
                generatedTaskList.addAll(this.getSystemRequirementTasks(vfyType, param, nodeList));
                generatedTaskList.addAll(this.getXmlTaskList(vfyType, nodeList));
                break;
            }
            case PREREQ_SI_DB_CONFIG: {
                generatedTaskList.addAll(this.getSystemRequirementTasks(vfyType, param, nodeList));
                generatedTaskList.addAll(this.getXmlTaskList(vfyType, nodeList));
                break;
            }
            case PREREQ_SI_HA_CONFIG: {
                generatedTaskList.addAll(this.getSystemRequirementTasks(vfyType, param, nodeList));
                generatedTaskList.addAll(this.getXmlTaskList(vfyType, nodeList));
                break;
            }
            case PREREQ_NODE_ADD: {
                generatedTaskList.addAll(this.getSystemRequirementTasks(vfyType, param, nodeList));
                generatedTaskList.addAll(this.getXmlTaskList(vfyType, nodeList));
                break;
            }
            case PREREQ_RACNODE_ADD: {
                generatedTaskList.addAll(this.getSystemRequirementTasks(vfyType, param, nodeList));
                generatedTaskList.addAll(this.getXmlTaskList(vfyType, nodeList));
                break;
            }
            default: {
                generatedTaskList.addAll(this.getXmlTaskList(vfyType, nodeList));
            }
        }
        ArrayList<Task> finalTaskList = new ArrayList<Task>();
        for (Task t : generatedTaskList) {
            if (t.isContainerTask()) {
                t = ((ContainerTaskInterface)((Object)t)).getContainerObject();
            }
            if (finalTaskList.contains(t)) continue;
            finalTaskList.add(t);
        }
        for (int i = 0; i < finalTaskList.size(); ++i) {
            Task t;
            t = (Task)finalTaskList.get(i);
            if (!t.isContainerTask()) continue;
            Trace.out((String)("Finalizing the container for (" + t.getDefaultTaskID() + ")"));
            Task contTask = ((ContainerTaskInterface)((Object)t)).finalizeContainer();
            finalTaskList.set(i, contTask);
        }
        Trace.out((String)("Following verification checks are generated for this execution.\n" + this.taskListToStringBuffer(finalTaskList, 1).toString()));
        return this.sortTaskList(finalTaskList);
    }

    private List<Task> sortTaskList(List<Task> taskList) {
        ArrayList<Task> mandatoryTaskList = new ArrayList<Task>();
        ArrayList<Task> bestPracticeTaskList = new ArrayList<Task>();
        for (Task t : taskList) {
            if (t.isBestPractice()) {
                bestPracticeTaskList.add(t);
                continue;
            }
            mandatoryTaskList.add(t);
        }
        ArrayList<Task> sortedTaskList = new ArrayList<Task>();
        sortedTaskList.addAll(mandatoryTaskList);
        sortedTaskList.addAll(bestPracticeTaskList);
        return sortedTaskList;
    }

    private StringBuffer taskListToStringBuffer(List<Task> taskList, int index) {
        StringBuffer buffer = new StringBuffer();
        for (Task t : taskList) {
            if (t.hasSubtasks()) {
                List<VerificationTask> list = null;
                try {
                    list = t.getSubtasks();
                    ArrayList<Task> tList = new ArrayList<Task>();
                    for (VerificationTask vTask : list) {
                        tList.add((Task)vTask);
                    }
                    StringBuffer subTaskBuffer = this.taskListToStringBuffer(tList, index);
                    index += tList.size();
                    if (subTaskBuffer == null || subTaskBuffer.length() <= 0) continue;
                    buffer.append("\n (" + t.getTaskID() + ") is container task with following (" + tList.size() + ") subtasks:\n\t");
                    buffer.append(subTaskBuffer.toString());
                }
                catch (SubtasksUnavailableException e) {
                    Trace.out((Exception)e);
                }
                continue;
            }
            buffer.append("(" + index + ") " + t.getTaskName() + "  nodelist: " + VerificationUtil.strArr2List(t.getNodeList()) + "\n");
            ++index;
        }
        return buffer;
    }

    public List<Task> getSystemRequirementTasks(VerificationType vfyType, ParamPreReq param, String[] nodeList) throws PreReqNotSupportedException, TaskFactoryException {
        List<Task> sysReqTaskList = new ArrayList<Task>();
        String[] limitedAddDelNodeList = null;
        switch (vfyType) {
            case PREREQ_GENERIC_INST: 
            case SYSREQ_CRS: 
            case SYSREQ_DB: 
            case SYSREQ_SI_HA: 
            case SYSREQ_SI_DB: 
            case PREREQ_APPLICATION_CLUSTER_INST: 
            case PREREQ_CRS_INST: 
            case PREREQ_DB_INST: 
            case PREREQ_DB_CONFIG: 
            case PREREQ_SI_HA_INST: 
            case PREREQ_SI_DB_INST: 
            case PREREQ_SI_DB_CONFIG: 
            case PREREQ_SI_HA_CONFIG: {
                sysReqTaskList = this.getTaskListSysReq(nodeList, vfyType, limitedAddDelNodeList);
                break;
            }
            case PREREQ_DB_PROV: {
                sysReqTaskList = this.getTaskListSysReq(nodeList, VerificationType.PREREQ_DB_INST, limitedAddDelNodeList);
                ArrayList<Task> dropList = new ArrayList<Task>();
                for (Task task : sysReqTaskList) {
                    if (!(task instanceof TaskContainerPackages) && !(task instanceof TaskContainerKernelParams) && !(task instanceof TaskRunLevel) && !(task instanceof TaskKernelVersion)) continue;
                    dropList.add(task);
                }
                sysReqTaskList.removeAll(dropList);
                break;
            }
            case PREREQ_RACNODE_ADD: {
                sysReqTaskList = this.getTaskListSysReq(VerificationUtil.addLocalNodeToNodeList(nodeList), VerificationType.PREREQ_DB_INST, ((ParamPreReqNodeAddDel)param).getNodes());
                break;
            }
            case PREREQ_NODE_ADD: {
                sysReqTaskList = this.getTaskListSysReq(VerificationUtil.addLocalNodeToNodeList(nodeList), VerificationType.PREREQ_CRS_INST, ((ParamPreReqNodeAddDel)param).getNodes());
                boolean pSharedOnCluster = false;
                String[] clusterNodes = ((ParamPreReqNodeAddDel)param).getValidClusterNodes();
                String crsHome = VerificationUtil.getCRSHome();
                if (clusterNodes == null || clusterNodes.length <= 0 || !VerificationUtil.isStringGood(crsHome)) break;
                try {
                    pSharedOnCluster = new VerifyStorage().isShared(crsHome, clusterNodes.length == 1 ? VerificationUtil.addLocalNodeToNodeList(nodeList) : clusterNodes, OracleFileType.RAC_SOFTWARE, "12.2");
                }
                catch (StorageException se) {
                    Trace.out((String)("STORAGEEXCEPTION: " + se.getMessage()));
                }
                catch (MultiNodeException mne) {
                    Trace.out((String)("MULTINODEEXCEPTION: " + mne.getMessage()));
                }
                if (!pSharedOnCluster) break;
                for (Task sysTask : sysReqTaskList) {
                    String taskName = sysTask.getClass().getName();
                    Trace.out((String)("checking sysReqTaskList entry: '" + taskName + "'"));
                    if (!taskName.contains("TaskContainerFreeSpace") || !sysTask.hasSubtasks()) continue;
                    try {
                        for (VerificationTask verTask : sysTask.getSubtasks()) {
                            TaskFreeSpace taskFS = (TaskFreeSpace)verTask;
                            if (!taskFS.getLocations().contains(crsHome)) continue;
                            Double newSizeVal = new Double(".5");
                            newSizeVal = newSizeVal * (double)nodeList.length;
                            StorageSize newSize = new StorageSize((double)newSizeVal, StorageUnit.GBYTE);
                            Trace.out((String)("sysReqTask[TaskFreeSpace] before change: " + taskFS.toString()));
                            taskFS.setFreeSpace(newSize);
                            Trace.out((String)("sysReqTask[TaskFreeSpace] AFTER change: " + taskFS.toString()));
                        }
                    }
                    catch (SubtasksUnavailableException sue) {
                        Trace.out((String)("SUBTASKSUNAVAILABLEEXCEPTOIN: " + sue.getMessage()));
                        throw new TaskFactoryException(sue);
                    }
                }
                break;
            }
        }
        if (sysReqTaskList == null) {
            sysReqTaskList = new ArrayList();
        }
        return sysReqTaskList;
    }

    private List<Task> getXmlTaskList(VerificationType vfyType, String[] nodeList) throws TaskFactoryException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        try {
            List<Task> xmlTaskList = this.m_taskFactoryXmlParser.getTasks(this.m_globalContext.getRequestedRelease(), VerificationUtil.getUniqueDistributionIDWithException(), vfyType.getID(), nodeList);
            if (xmlTaskList != null) {
                taskList.addAll(xmlTaskList);
            }
        }
        catch (XmlParserException e) {
            throw new TaskFactoryException(e);
        }
        catch (VerificationException e) {
            throw new TaskFactoryException(e);
        }
        return taskList;
    }

    private List<Task> getTaskListSysReq(String[] nodeList, VerificationType verType, String[] limitedAddDelNodeList) throws TaskFactoryException, PreReqNotSupportedException {
        Task[] taskArr;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        Trace.out((String)("verType=" + (Object)((Object)verType)));
        try {
            GlobalVerificationContext gCtx = GlobalVerificationContext.getInstance();
            String release = gCtx.getRequestedRelease();
            if (release == null) {
                release = VerificationUtil.getConfiguredValue("CV_ORACLE_RELEASE", false);
            }
            String xmlFile = release != null ? VerificationUtil.getPreReqXmlPath(verType, release) : VerificationUtil.getPreReqXmlPath(verType);
            Trace.out((String)("Using xmlFile: '" + xmlFile + "'"));
            XmlTaskFactory xtf = XmlTaskFactory.getInstance();
            String cDistID = VerificationUtil.getUniqueDistributionID(verType, xmlFile);
            taskArr = xtf.getTasks(verType, xmlFile, cDistID, nodeList, this.m_globalContext.isLocalNodeCRSRunning(), limitedAddDelNodeList);
            Trace.out((String)("The DistID is: " + cDistID));
        }
        catch (XmlFilePathException xfpe) {
            Trace.out((String)("XMLFILEPATHEXCEPTION: " + xfpe.getMessage()));
            throw new TaskFactoryException(xfpe);
        }
        catch (XmlParserException xpe) {
            Trace.out((String)("XMLPARSEREXCEPTION: " + xpe.getMessage()));
            throw new TaskFactoryException(xpe);
        }
        for (Task task : taskArr) {
            if (task.getNodeList() == null || task.getNodeList().length == 0) {
                Trace.out((int)1, (String)(task.getClass().getSimpleName() + " setting nodelist to: " + VerificationUtil.strArr2List(nodeList)));
                task.setNodeList(nodeList);
            } else {
                Trace.out((int)1, (String)(task.getClass().getSimpleName() + " already has nodelist defined to: " + VerificationUtil.strArr2List(task.getNodeList())));
            }
            if (!task.hasSubtasks()) continue;
            try {
                for (VerificationTask subTask : task.getSubtasks()) {
                    ((Task)subTask).setNodeList(nodeList);
                }
            }
            catch (SubtasksUnavailableException sue) {
                throw new TaskFactoryException(sue);
            }
        }
        ArrayList<Task> taskList = new ArrayList<Task>(Arrays.asList(taskArr));
        if (nativeSystem.isUnixSystem()) {
            if (!verType.equals((Object)VerificationType.PREREQ_DB_CONFIG) && !VerificationUtil.isBaselineCollectionMode()) {
                TaskUsersWithSameID taskMultRootUID = new TaskUsersWithSameID(nodeList, "0");
                taskList.add(taskMultRootUID);
            }
            if ((verType.equals((Object)VerificationType.PREREQ_CRS_INST) || verType.equals((Object)VerificationType.PREREQ_DB_INST) || verType.equals((Object)VerificationType.PREREQ_DB_CONFIG) || verType.equals((Object)VerificationType.PREREQ_SI_HA_INST) || verType.equals((Object)VerificationType.PREREQ_SI_HA_CONFIG)) && !VerificationUtil.isBaselineCollectionMode()) {
                TaskCurrentGroupID taskCurGrpID = new TaskCurrentGroupID();
                taskCurGrpID.setNodeList(nodeList);
                taskList.add(taskCurGrpID);
            }
            if (!verType.equals((Object)VerificationType.PREREQ_DB_CONFIG) && !VerificationUtil.isBaselineCollectionMode()) {
                sTaskRootConsistency sTRC = new sTaskRootConsistency(nodeList);
                taskList.add(sTRC);
            }
        }
        if (!VerificationUtil.isBaselineCollectionMode() && !nativeSystem.isUnixSystem() && (verType.equals((Object)VerificationType.PREREQ_CRS_INST) || verType.equals((Object)VerificationType.PREREQ_DB_INST) || verType.equals((Object)VerificationType.PREREQ_DB_CONFIG) || verType.equals((Object)VerificationType.POSTREQ_CRS_INST))) {
            String osVer = System.getProperty("os.version");
            float currentOsrVersion = 0.0f;
            float postWin2K3OsVer = 6.0f;
            if (VerificationUtil.isStringGood(osVer)) {
                currentOsrVersion = Float.parseFloat(osVer);
            }
            if (currentOsrVersion < postWin2K3OsVer) {
                TaskCheckMediaSense taskMediaSense = new TaskCheckMediaSense(nodeList);
                taskList.add(taskMediaSense);
            } else {
                Trace.out((String)("Not adding the media sense check on windows because the current os version is " + currentOsrVersion + " and OS name is " + System.getProperty("os.name")));
                VerificationLogData.logInfo("Not adding the media sense check on windows because the current os version is " + currentOsrVersion + " and OS name is " + System.getProperty("os.name"));
            }
        }
        if (verType.equals((Object)VerificationType.SYSREQ_CRS)) {
            TaskTimeZoneSetting taskTZ = new TaskTimeZoneSetting(nodeList);
            taskTZ.setTaskType(0);
            taskList.add(taskTZ);
        }
        if (nativeSystem.isUnixSystem() && (VerificationUtil.isBaselineCollectionMode() || VerificationUtil.isCVUResource())) {
            TaskClusterwareConfigOutsideHome clusterwareConfig = new TaskClusterwareConfigOutsideHome();
            clusterwareConfig.setNodeList(nodeList);
            taskList.add(clusterwareConfig);
            TaskDomainSockets taskDomainSockets = new TaskDomainSockets();
            taskDomainSockets.setNodeList(nodeList);
            taskList.add(taskDomainSockets);
        }
        return taskList;
    }

    static {
        FSEP = System.getProperty("file.separator");
        LSEP = System.getProperty("line.separator");
    }
}

