/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskDomainSockets
extends Task {
    List<String> m_listOfUnexpectedFiles = null;
    boolean m_checkFileAbsence = false;

    public TaskDomainSockets(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        this.setCheckFileAbsence(this.m_globalContext.isPreCRS());
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (VerificationType.PREREQ_CRS_INST.equals((Object)this.m_globalContext.getVerificationType()) && VerificationUtil.isBaselineCollectionMode()) {
            return false;
        }
        return !this.m_globalContext.isCRSSoftwareOnlyInstall() && !VerificationUtil.isHealthCheckMode();
    }

    public TaskDomainSockets() {
    }

    @Override
    public boolean performTask() {
        boolean retVal = true;
        ArrayList<String> succNodes = new ArrayList<String>();
        ArrayList<String> failNodes = new ArrayList<String>();
        this.m_resultSet.addResult(this.m_nodeList, 1);
        String path = VerificationUtil.getDomainSocketsDir();
        Trace.out((String)("Domain socket directory=" + path));
        VerificationUtil.pathExists(this.m_nodeList, path, 1, succNodes, failNodes);
        if (succNodes.size() < 1) {
            Trace.out((String)"Domain socket directory does not exist on all the nodes");
            return retVal;
        }
        if (failNodes.size() > 1) {
            Trace.out((String)("Domain socket directory does not exist on some of the nodes: " + VerificationUtil.strCollection2String(failNodes)));
        }
        Trace.out((String)("Performing domain sockets validation on nodes: " + VerificationUtil.strCollection2String(succNodes) + "; m_checkFileAbsence=" + this.m_checkFileAbsence));
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet nodeResultSet = new ResultSet();
        globalExec.getFileInfo(succNodes.toArray(new String[succNodes.size()]), Arrays.asList(path), true, nodeResultSet);
        this.m_resultSet.addResultSetData(nodeResultSet);
        Hashtable fileInforResultTable = nodeResultSet.getResultTable();
        Enumeration e = fileInforResultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)fileInforResultTable.get(node);
            if (result == null || result.getStatus() != 1) continue;
            Hashtable nodeFileHT = (Hashtable)result.getResultInfoSet().elementAt(0);
            Hashtable<String, Hashtable<String, FileInfo>> nodeFileInfoTable = new Hashtable<String, Hashtable<String, FileInfo>>();
            nodeFileInfoTable.put(node, nodeFileHT);
            for (String file : nodeFileHT.keySet()) {
                if (this.m_checkFileAbsence) {
                    Trace.out((String)("Going to validate the expectation of file '" + file + "' on node '" + node + "'"));
                    if (this.isFileUnexpected(file)) {
                        ErrorDescription errDesc = new ErrorDescription("11750", new String[]{file, node}, s_gMsgBundle);
                        this.m_resultSet.addResult(node, 3);
                        ReportUtil.printError(errDesc.getErrorMessage());
                        this.m_resultSet.addErrorDescription(node, errDesc);
                    }
                }
                VerificationUtil.checkFileAttributes(new String[]{node}, file, s_gMsgBundle.getMessage("11182", false), nodeFileInfoTable, null, null, null, this.m_resultSet);
            }
        }
        return retVal;
    }

    boolean isFileUnexpected(String file) {
        if (this.m_listOfUnexpectedFiles == null) {
            this.getListOfUnexpectedFiles();
        }
        for (String fileStart : this.m_listOfUnexpectedFiles) {
            if (!new File(file).getName().startsWith(fileStart)) continue;
            return true;
        }
        return false;
    }

    private void getListOfUnexpectedFiles() {
        this.m_listOfUnexpectedFiles = new ArrayList<String>();
        this.m_listOfUnexpectedFiles.add("ora_gipc");
        this.m_listOfUnexpectedFiles.add("mdnsd");
        this.m_listOfUnexpectedFiles.add("npohasd");
    }

    public void setCheckFileAbsence(boolean checkFileAbsence) {
        this.m_checkFileAbsence = checkFileAbsence;
    }

    @Override
    public String getTaskID() {
        return "DOMAIN_SOCKETS";
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11180", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11181", false);
    }
}

