/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSUtils;
import oracle.cluster.verification.ClusterwideCollectionUnavailableException;
import oracle.cluster.verification.CollectionResultSet;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.ODNSDOutputMonitor;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.network.NetworkDataDiscovery;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.CvunetQueryData;
import oracle.ops.verification.framework.util.GNSData;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskDNSChecks
extends Task
implements VerificationConstants {
    boolean m_server = false;
    boolean m_client = false;
    boolean m_lastClient = false;
    String m_gnsVIP = null;
    String m_gnsIP = null;
    String m_interface = null;
    private final String m_defaultGnsPort = "53";
    String m_gnsPort = "53";
    String m_gnsDomain = null;
    Thread m_serverThread = null;
    boolean m_sucInDirectConnect = false;
    boolean m_configWizard = false;
    private String cmdBinLocation = null;
    private String cmdOdnsdLocation = null;
    private String[] envPath = null;
    String m_localName = null;
    String START_IP_COMMAND = "start ip -A ";
    String STOP_DNS_COMMAND = "stop testdns -address ";
    String STOP_IP_COMMAND = "stop ip -A ";
    String STATUS_IP_COMMAND = "status ip -A ";
    String QUERY_DNS_COMMAND = "query dns -name ";
    String ODNSD_COMMAND = "odnsd";
    String ODNSDLITE_COMMAND = "odnsdlite";
    String CRSCTL_CMD = "crsctl";
    private final String ERRTXT_4000 = "CRS-4000:";
    private final String ERRTXT_4047 = "CRS-4047:";
    private final String ERRTXT_10003 = "CRS-10003:";
    private final String ERRTXT_10004 = "CRS-10004:";
    private final String ERRTXT_10023 = "CRS-10023:";
    private final String ERRTXT_10031 = "CRS-10031:";
    private final String ERRTXT_10032 = "CRS-10032:";
    private final String ERRTXT_10033 = "CRS-10033:";
    private final String ERRTXT_10034 = "CRS-10034:";
    private final String ERRTXT_10035 = "CRS-10035:";
    private final String ERRTXT_10048 = "CRS-10048:";
    private boolean m_isUnix = true;
    private boolean m_isRootCredsAvaliable = true;
    private boolean m_useLightVersion = false;
    private boolean m_isAPIOrRespFilemode = false;
    private boolean m_stopSucceed = true;
    private ConcurrentSkipListSet<String> m_listQueryReceive = new ConcurrentSkipListSet();
    private int m_totalQueryReceive = 0;

    public TaskDNSChecks(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        String[] crsNodes = VerificationUtil.getNodesWithCRSInstall(this.m_nodeList, this.m_resultSet, true);
        if (crsNodes != null && crsNodes.length > 0) {
            this.setNodeList(crsNodes);
        } else {
            this.m_useLightVersion = true;
            this.m_resultSet.clear();
        }
        this.m_isAPIOrRespFilemode = VerificationUtil.isAPIMode() || this.m_globalContext.isResponseFileSupplied();
        Trace.out((String)("lightVersion ? " + this.m_useLightVersion));
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        this.m_isUnix = nativeSystem.isUnixSystem();
        String configOption = CVUVariables.getValue(CVUVariableConstants.POST_SW_INSTALL_API_MODE);
        if (configOption != null && configOption.equalsIgnoreCase("true")) {
            this.m_configWizard = true;
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (VerificationUtil.isODALiteEnv()) {
            VerificationUtil.traceAndLog("skipping DNS check in  ODA Lite environment");
            return false;
        }
        if (this.m_globalContext.getVerificationType() == VerificationType.COMPONENT_DNS_INTEGRITY) {
            Trace.out((String)"comp dns about to start");
            return true;
        }
        if (this.m_isAPIOrRespFilemode && this.m_globalContext.isGNSConfigured() && VerificationUtil.isStringGood(CVUVariables.getValue(CVUVariableConstants.GNS_SUB_DOMAIN)) && !this.m_globalContext.isSharedGNS()) {
            VerificationUtil.traceAndLog("DNS check is been included in API or responsefile mode");
            return true;
        }
        if (this.m_globalContext.getVerificationType() == VerificationType.PREREQ_CRS_INST && VerificationUtil.isStringGood(CVUVariables.getValue(CVUVariableConstants.GNS_SUB_DOMAIN)) && VerificationUtil.isStringGood(CVUVariables.getValue(CVUVariableConstants.GNS_VIP_FULL_ADDRESS))) {
            Trace.out((String)"dns check about to start with prereq type");
            return true;
        }
        Trace.out((String)"DNS is not applicable");
        return false;
    }

    public TaskDNSChecks(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskDNSChecks(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskDNSChecks(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        this.m_isUnix = nativeSystem.isUnixSystem();
        this.m_isAPIOrRespFilemode = VerificationUtil.isAPIMode();
        Trace.out((String)("lightVersion ? " + this.m_useLightVersion));
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("5825", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("5824", false);
    }

    @Override
    public boolean performTask() {
        if (!this.getCmdLineParams()) {
            return false;
        }
        if (this.m_isAPIOrRespFilemode) {
            this.m_nodeList = new String[]{m_localNode};
        }
        boolean status = true;
        boolean ipReachable = false;
        if (this.m_isUnix) {
            try {
                Trace.out((String)"getting root automation configuration");
                if (RootAutomationUtility.isRootExecutionConfigured()) {
                    this.m_rootCreds = RootAutomationUtility.getRootExecutionInfo();
                } else {
                    if (this.m_isAPIOrRespFilemode) {
                        this.setSeverity(SeverityType.IGNORABLE);
                        String errMsg = s_gMsgBundle.getMessage("5821", true);
                        ErrorDescription errDesc = new ErrorDescription(errMsg);
                        this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
                        this.m_resultSet.addResult(this.m_nodeList, 4);
                        return false;
                    }
                    this.m_nodeList = new String[1];
                    this.m_nodeList[0] = m_localNode;
                    this.m_isRootCredsAvaliable = false;
                }
            }
            catch (VerificationException e) {
                Trace.out((String)"root automation not configured");
                ReportUtil.sureprintln(e.getMessage());
                ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(errDesc);
                return false;
            }
        }
        Trace.out((String)("root credentials available ? " + this.m_isRootCredsAvaliable));
        Result resultLocation = new Result(m_localNode);
        CvunetQueryData locationAndEnv = VerificationUtil.getCvunetqueryLocation(resultLocation);
        if (resultLocation.getStatus() != 1) {
            StringBuffer errMsg = new StringBuffer();
            for (VerificationError vErr : resultLocation.getErrors()) {
                errMsg.append(vErr.getErrorMessage());
                errMsg.append(LSEP);
                this.m_resultSet.addErrorDescription(new ErrorDescription(vErr.getErrorMessage()));
            }
            this.m_resultSet.setStatus(2);
            ReportUtil.printError(errMsg.toString());
            return false;
        }
        this.cmdBinLocation = locationAndEnv.getLocation();
        this.cmdOdnsdLocation = this.cmdBinLocation.substring(0, this.cmdBinLocation.lastIndexOf(FSEP));
        this.envPath = locationAndEnv.getEnv();
        this.m_useLightVersion = locationAndEnv.isCvunetquery();
        this.cmdOdnsdLocation = this.m_useLightVersion ? this.cmdOdnsdLocation + FSEP + this.ODNSDLITE_COMMAND : this.cmdOdnsdLocation + FSEP + this.ODNSD_COMMAND;
        Trace.out((String)"checking if gnsd is up on same port");
        if (this.isGNSRunning()) {
            Trace.out((String)"gnsd running on IP and domain we are asked to validate");
            return false;
        }
        if (this.m_server) {
            if (!this.m_isAPIOrRespFilemode) {
                Trace.out((String)"starting the test dns server");
                ReportUtil.sureprintln(s_msgBundle.getMessage("5800", false, (Object[])new String[]{this.m_gnsVIP, this.m_gnsPort}));
                if (this.performServerSideChecks()) {
                    ReportUtil.sureprintln(s_gMsgBundle.getMessage("5804", false, (Object[])new String[]{String.valueOf(this.m_totalQueryReceive)}));
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5804", false));
                    return true;
                }
                ReportUtil.sureprintln(s_msgBundle.getMessage("5805", true));
                return false;
            }
            this.m_serverThread = this.spawnServer();
            if (this.m_serverThread == null) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5805", true));
                return false;
            }
        }
        if (this.m_client) {
            if (status) {
                Trace.out((String)"starting ip reachablility check");
                ReportUtil.sureprintln(s_msgBundle.getMessage("5812", false, (Object[])new String[]{this.m_gnsVIP}));
                if (!this.performIPReachablityCheck()) {
                    Trace.out((String)("ip is not reachable" + this.m_gnsVIP));
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5813", true, (Object[])new String[]{this.m_gnsVIP}));
                    status = false;
                    if (this.m_isAPIOrRespFilemode) {
                        Trace.out((String)"sending stop packet to server");
                        String[] stopDNSCmd = new String[]{this.cmdBinLocation, this.STOP_DNS_COMMAND + this.m_gnsIP};
                        if (!this.m_gnsPort.equalsIgnoreCase("53")) {
                            stopDNSCmd[1] = stopDNSCmd[1] + " -port " + this.m_gnsPort;
                        }
                        ResultSet stopRS = new ResultSet();
                        this.executeCrsctlCommands(stopDNSCmd, crsctlCmdType.StopDNS, stopRS);
                        this.m_resultSet.addResultSetData(stopRS);
                        return status;
                    }
                } else {
                    ipReachable = true;
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5814", false, (Object[])new String[]{this.m_gnsVIP}));
                }
            }
            if (status) {
                Trace.out((String)"checking if odnsd is reachable");
                if (!this.performODNSDReachability(true)) {
                    Trace.out((String)"odnsd is not reachable from client");
                    status = false;
                    ipReachable = false;
                }
            }
            if (status) {
                Trace.out((String)"Checking if test dns is working");
                ReportUtil.sureprintln(s_msgBundle.getMessage("5815", false, (Object[])new String[]{this.m_gnsVIP, this.m_gnsPort}));
                if (!this.performDirectConnectivityCheck()) {
                    Trace.out((String)"test dns not working");
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5816", true, (Object[])new String[]{this.m_gnsVIP, this.m_gnsPort}));
                    status = false;
                } else {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5817", false, (Object[])new String[]{this.m_gnsVIP, this.m_gnsPort}));
                    this.m_sucInDirectConnect = true;
                }
            }
            if (status) {
                Trace.out((String)"Checking DNS delegation for GNS domain");
                ReportUtil.sureprintln(s_msgBundle.getMessage("5818", false));
                if (!this.performGNSDomainLookup()) {
                    Trace.out((String)"Name resolution via gns is not working");
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5819", true, (Object[])new String[]{this.m_gnsDomain}));
                    status = false;
                } else {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5820", false));
                }
            }
            if (ipReachable && this.m_lastClient) {
                ResultSet stopRS;
                Trace.out((String)"sending stop packet to server");
                String[] stopDNSCmd = new String[]{this.cmdBinLocation, this.STOP_DNS_COMMAND + this.m_gnsIP};
                if (!this.m_gnsPort.equalsIgnoreCase("53")) {
                    stopDNSCmd[1] = stopDNSCmd[1] + " -port " + this.m_gnsPort;
                }
                if (!this.executeCrsctlCommands(stopDNSCmd, crsctlCmdType.StopDNS, stopRS = new ResultSet())) {
                    Trace.out((String)"failed stop testdns");
                    status = false;
                    this.m_stopSucceed = false;
                }
                this.m_resultSet.addResultSetData(stopRS);
            }
        }
        if (this.m_isAPIOrRespFilemode) {
            try {
                if (this.m_serverThread.isAlive() && this.m_stopSucceed) {
                    Trace.out((String)"waiting until the server finishes");
                    this.m_serverThread.join();
                }
            }
            catch (InterruptedException e) {
                Trace.out((String)"Interrupted while awaiting odnsd termination");
            }
            if (!status) {
                return status;
            }
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("5804", false, (Object[])new String[]{String.valueOf(this.m_totalQueryReceive)}));
            if (this.m_totalQueryReceive < 2) {
                Trace.out((String)"Two packets were not received");
                status = false;
                String queryReceive = m_localNode + "." + this.m_gnsDomain;
                String errMsg = null;
                errMsg = !this.m_sucInDirectConnect ? s_gMsgBundle.getMessage("5822", true, (Object[])new String[]{queryReceive, this.m_gnsIP, this.m_gnsPort}) : s_gMsgBundle.getMessage("5825", true, (Object[])new String[]{this.m_gnsDomain});
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.clear();
                this.m_resultSet.addErrorDescription(m_localNode, errDesc);
                this.m_resultSet.addResult(m_localNode, 3);
                ReportUtil.sureprintln(errMsg);
            } else {
                this.m_resultSet.addResult(m_localNode, 1);
            }
        }
        return status;
    }

    private boolean performIPReachablityCheck() {
        boolean status = true;
        String statusIPCmd = this.cmdBinLocation + this.STATUS_IP_COMMAND + this.m_gnsIP;
        String[] args = null;
        String output = null;
        HashMap<String, String> nodeOutputMap = new HashMap<String, String>();
        ResultSet locrs = new ResultSet();
        Trace.out((String)"about to check IP reachability");
        if (!this.m_isUnix || !this.m_isRootCredsAvaliable) {
            int i;
            VerificationCommand[] statusIPCmdArr = new VerificationCommand[this.m_nodeList.length];
            args = new String[]{"-rungencmd", this.cmdBinLocation, this.STATUS_IP_COMMAND + this.m_gnsIP};
            String[] pathWin = this.envPath;
            if (this.m_configWizard) {
                pathWin = new String[]{"PATH=" + System.getenv("PATH")};
            }
            for (i = 0; i < this.m_nodeList.length; ++i) {
                statusIPCmdArr[i] = new VerificationCommand(this.m_nodeList[i], args, pathWin);
            }
            Trace.out((String)("about to submit cmd : " + statusIPCmd));
            new GlobalHandler().submit((Command[])statusIPCmdArr, 0, locrs);
            this.m_resultSet.addResultSetData(locrs);
            if (!locrs.anySuccess()) {
                StringBuilder sb = new StringBuilder();
                for (int i2 = 0; i2 < this.m_nodeList.length; ++i2) {
                    output = statusIPCmdArr[i2].getOutput();
                    if (output == null) continue;
                    sb.append(output + LSEP);
                }
                this.displayGlobalFailureErrMsg(statusIPCmd, sb.toString());
                return false;
            }
            for (i = 0; i < this.m_nodeList.length; ++i) {
                Result result = statusIPCmdArr[i].getResult();
                String node = statusIPCmdArr[i].getNode();
                if (result.getStatus() == 1) {
                    output = statusIPCmdArr[i].getOutput();
                    nodeOutputMap.put(this.m_nodeList[i], output);
                    continue;
                }
                output = statusIPCmdArr[i].getOutput();
                if (output == null) {
                    output = "";
                }
                Trace.out((String)("command failed to execute on node " + node));
                String errMsg = s_msgBundle.getMessage("5718", true, (Object[])new String[]{statusIPCmd, node, output});
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(errMsg);
            }
        } else {
            GlobalExecution globalExec = new GlobalExecution();
            boolean rootCmdStatus = false;
            args = (this.STATUS_IP_COMMAND + this.m_gnsIP).split(" ");
            String[] env = new String[]{"LD_LIBRARY_PATH=" + System.getenv("LD_LIBRARY_PATH")};
            try {
                rootCmdStatus = globalExec.runGenericCmdAsRoot(this.m_nodeList, this.cmdBinLocation, env, args, this.m_rootCreds, this.m_defaultTimeout, locrs);
            }
            catch (RootAutomationNotConfiguredException e) {
                ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                locrs.addResult(this.m_nodeList, 2);
                locrs.addErrorDescription(errDesc);
                return false;
            }
            this.m_resultSet.addResultSetData(locrs);
            if (!locrs.anySuccess()) {
                Trace.out((String)"root command execution failed");
                for (int i = 0; i < this.m_nodeList.length; ++i) {
                    List<VerificationError> errList = locrs.getResult(this.m_nodeList[i]).getErrors();
                    StringBuilder sb = new StringBuilder();
                    for (VerificationError vfyErr : errList) {
                        sb.append(vfyErr.getErrorMessage());
                    }
                    ErrorDescription errDesc = new ErrorDescription(sb.toString());
                    Trace.out((String)("error on node " + this.m_nodeList[i] + " is " + sb.toString()));
                    this.m_resultSet.addErrorDescription(this.m_nodeList[i], errDesc);
                    ReportUtil.sureprintln(sb.toString());
                }
                return false;
            }
            for (int i = 0; i < this.m_nodeList.length; ++i) {
                Result result = locrs.getResult(this.m_nodeList[i]);
                if (result.getStatus() == 1) {
                    output = (String)locrs.getResult(this.m_nodeList[i]).getResultInfoSet().get(0);
                    nodeOutputMap.put(this.m_nodeList[i], output);
                    continue;
                }
                List<VerificationError> errList = locrs.getResult(this.m_nodeList[i]).getErrors();
                StringBuilder sb = new StringBuilder();
                for (VerificationError vfyErr : errList) {
                    sb.append(vfyErr.getErrorMessage());
                }
                String errMsg = s_msgBundle.getMessage("5718", true, (Object[])new String[]{statusIPCmd, this.m_nodeList[i], ""}) + LSEP + sb.toString();
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                Trace.out((String)("error on node " + this.m_nodeList[i] + " is " + sb.toString()));
                this.m_resultSet.addErrorDescription(this.m_nodeList[i], errDesc);
                ReportUtil.sureprintln(errMsg);
            }
        }
        for (Map.Entry entry : nodeOutputMap.entrySet()) {
            ErrorDescription errDesc;
            output = (String)entry.getValue();
            String node = (String)entry.getKey();
            Trace.out((String)("output =" + output));
            if (output == null || output.length() == 0) {
                this.displayNoOutputErrorMsg(statusIPCmd, node);
                status = false;
                continue;
            }
            if (output.indexOf("CRS-10003:") != -1) {
                Trace.out((String)"stat successful");
                this.m_resultSet.addResult(node, 1);
                continue;
            }
            if (output.indexOf("CRS-10004:") != -1 || output.indexOf("CRS-4000:") != -1 || output.indexOf("CRS-4047:") != -1) {
                Trace.out((String)"unable to stat IP");
                this.m_resultSet.addResult(node, 3);
                String errMsg = s_msgBundle.getMessage("5821", true, (Object[])new String[]{this.m_gnsVIP}) + LSEP + output;
                errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(errMsg);
                status = false;
                continue;
            }
            Trace.out((String)("parse error output:" + output));
            String errMsg = s_msgBundle.getMessage("5714", true, (Object[])new String[]{statusIPCmd, output});
            this.m_resultSet.addResult(node, 3);
            errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(node, errDesc);
            ReportUtil.sureprintln(errMsg);
            status = false;
        }
        return status;
    }

    private boolean performODNSDReachability(boolean reportError) {
        String node = this.m_nodeList[0];
        ReportUtil.println(s_gMsgBundle.getMessage("5802", false, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort}));
        Trace.out((String)"about to check odnsd reachability");
        try {
            DatagramSocket socket = new DatagramSocket();
            socket.setSoTimeout(3000);
            byte[] sendData = "areYouAliveD6677FD387F7".getBytes();
            DatagramPacket dp = new DatagramPacket(sendData, sendData.length, InetAddress.getByName(this.m_gnsIP), Integer.parseInt(this.m_gnsPort));
            Trace.out((String)"about to send ping packet");
            socket.send(dp);
            byte[] buf = new byte[512];
            dp = new DatagramPacket(buf, buf.length);
            Trace.out((String)"waiting to get response back");
            socket.receive(dp);
            String received = new String(dp.getData(), 0, dp.getLength());
            socket.close();
            Trace.out((String)("Message: " + received));
            if (!received.equals("yesAliveD6677FD387F7") && reportError) {
                Trace.out((String)"response doesn't match the expected output");
                String errMsg = s_msgBundle.getMessage("5816", true, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort});
                this.m_resultSet.addResult(node, 3);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(errMsg);
                return false;
            }
            if (reportError) {
                this.m_resultSet.addResult(node, 1);
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("5803", false, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort}));
                Trace.out((String)"odnsd connect successful");
            }
        }
        catch (UnknownHostException e) {
            Trace.out((String)"UHE while looking for odnsd");
            if (reportError) {
                String errMsg = s_msgBundle.getMessage("5816", true, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort});
                this.m_resultSet.addResult(node, 2);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(errMsg);
            }
            return false;
        }
        catch (IOException e) {
            Trace.out((String)"IOE while looking for odnsd");
            if (reportError) {
                String errMsg = s_msgBundle.getMessage("5816", true, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort});
                this.m_resultSet.addResult(node, 2);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(errMsg);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isGNSRunning() {
        ResultSet gnsResultSet = new ResultSet();
        CollectionResultSet<List<GNSData>> collectRS = CVUHelperUtil.getGNSStatus();
        boolean isCheckGNSVIPAndDomain = false;
        if (collectRS.getOverallStatus() == OverallStatus.SUCCESSFUL) {
            List<Object> gnsDataList = new ArrayList();
            try {
                gnsDataList = collectRS.getCollectedClusterwideValue();
            }
            catch (ClusterwideCollectionUnavailableException e) {
                Trace.out((String)e.getMessage());
            }
            for (GNSData gNSData : gnsDataList) {
                boolean isGNSVIPRunning = gNSData.isGNSVIPRunning();
                boolean isGNSRunning = gNSData.isGNSRunning();
                if (!isGNSVIPRunning && !isGNSRunning) continue;
                Trace.out((String)("GNS VIP status =" + isGNSVIPRunning + "or GNS status=" + isGNSRunning + "is running"));
                isCheckGNSVIPAndDomain = true;
                break;
            }
        } else {
            Trace.out((String)"gns status couldn't be collected. so assume that it is not running/configured");
            return false;
        }
        if (!isCheckGNSVIPAndDomain) {
            Trace.out((String)"GNS and GNS-VIP resource are not up");
            return false;
        }
        if (CVUHelperUtil.getGNSDomainAndVIP(gnsResultSet, this.m_localName, true)) {
            String helperGnsIP = null;
            try {
                String helperGnsVIPName = CVUVariables.getValue(CVUVariableConstants.GNS_VIP_ADDRESS);
                Trace.out((String)("helper returned vipname =" + helperGnsVIPName));
                helperGnsIP = InetAddress.getByName(helperGnsVIPName).getHostAddress();
                Trace.out((String)("helper returned ip =" + helperGnsIP));
            }
            catch (UnknownHostException e) {
                Trace.out((String)("UKE shouldn't happen as we get host name from helper" + e.getMessage()));
            }
            String helperSubdomain = CVUVariables.getValue(CVUVariableConstants.GNS_SUB_DOMAIN);
            Trace.out((String)("helper returned subdomain =" + helperSubdomain));
            if (this.m_gnsIP.equalsIgnoreCase(helperGnsIP) && (!VerificationUtil.isStringGood(helperSubdomain) || this.m_gnsDomain.equalsIgnoreCase(helperSubdomain))) {
                void var6_12;
                Object var6_9 = null;
                if (VerificationUtil.isStringGood(helperSubdomain)) {
                    String string = s_gMsgBundle.getMessage("5818", true, (Object[])new String[]{this.m_gnsVIP, this.m_gnsDomain});
                } else {
                    String string = s_gMsgBundle.getMessage("5824", true, (Object[])new String[]{this.m_gnsVIP});
                }
                ReportUtil.sureprintln((String)var6_12);
                ErrorDescription errDesc = new ErrorDescription((String)var6_12);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
                return true;
            }
        }
        return false;
    }

    private boolean performDirectConnectivityCheck() {
        Trace.out((String)"checking direct look up");
        return this.performDomainNameLookup(this.m_gnsIP);
    }

    private boolean performGNSDomainLookup() {
        Trace.out((String)"checking dns forwarding");
        return this.performDomainNameLookup(null);
    }

    private boolean performDomainNameLookup(String dnsServerAddress) {
        String output;
        boolean status = true;
        String fullHostName = m_localNode + "." + this.m_gnsDomain;
        Object[] queryDNSCmd = new String[]{this.cmdBinLocation, this.QUERY_DNS_COMMAND + fullHostName + " -type A -attempts 1"};
        if (dnsServerAddress != null) {
            queryDNSCmd[1] = queryDNSCmd[1] + " -dnsserver " + dnsServerAddress;
        }
        String[] args = null;
        ResultSet locrs = new ResultSet();
        HashMap<String, String> nodeOutputMap = new HashMap<String, String>();
        Trace.out((String)("Issuing a query to " + dnsServerAddress));
        if (!this.m_isUnix || !this.m_isRootCredsAvaliable) {
            int i;
            VerificationCommand[] queryDNSCmdArr = new VerificationCommand[this.m_nodeList.length];
            args = new String[1 + queryDNSCmd.length];
            args[0] = "-rungencmd";
            System.arraycopy(queryDNSCmd, 0, args, 1, queryDNSCmd.length);
            String[] pathWin = this.envPath;
            if (this.m_configWizard) {
                pathWin = new String[]{"PATH=" + System.getenv("PATH")};
            }
            for (i = 0; i < this.m_nodeList.length; ++i) {
                queryDNSCmdArr[i] = new VerificationCommand(this.m_nodeList[i], args, pathWin);
            }
            Trace.out((String)("about to submit cmd : " + VerificationUtil.objArr2String(queryDNSCmd, " ")));
            new GlobalHandler().submit((Command[])queryDNSCmdArr, 0, locrs);
            this.m_resultSet.addResultSetData(locrs);
            if (!locrs.anySuccess()) {
                StringBuilder sb = new StringBuilder();
                for (int i2 = 0; i2 < this.m_nodeList.length; ++i2) {
                    String output2 = queryDNSCmdArr[i2].getOutput();
                    if (output2 == null) continue;
                    sb.append(output2 + LSEP);
                }
                this.displayGlobalFailureErrMsg(VerificationUtil.objArr2String(queryDNSCmd, " "), sb.toString());
                return false;
            }
            for (i = 0; i < this.m_nodeList.length; ++i) {
                Result result = queryDNSCmdArr[i].getResult();
                String node = queryDNSCmdArr[i].getNode();
                if (result.getStatus() == 1) {
                    output = queryDNSCmdArr[i].getOutput();
                    nodeOutputMap.put(this.m_nodeList[i], output);
                    continue;
                }
                output = queryDNSCmdArr[i].getOutput();
                if (output == null) {
                    output = "";
                }
                Trace.out((String)("command failed to execute on node " + node));
                String errMsg = result.getExecutionErrorDetails();
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(errMsg);
            }
        } else {
            GlobalExecution globalExec = new GlobalExecution();
            boolean rootCmdstatus = false;
            args = queryDNSCmd[1].split(" ");
            String[] env = new String[]{"LD_LIBRARY_PATH=" + System.getenv("LD_LIBRARY_PATH")};
            try {
                Trace.out((String)"about to issue a query");
                rootCmdstatus = globalExec.runGenericCmdAsRoot(this.m_nodeList, queryDNSCmd[0], env, args, this.m_rootCreds, this.m_defaultTimeout, locrs);
            }
            catch (RootAutomationNotConfiguredException e) {
                locrs.addResult(this.m_nodeList, 2);
                ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                locrs.addErrorDescription(errDesc);
                return false;
            }
            this.m_resultSet.addResultSetData(locrs);
            if (!locrs.anySuccess()) {
                Trace.out((String)"root query dns command execution failed");
                for (int i = 0; i < this.m_nodeList.length; ++i) {
                    List<VerificationError> errList = locrs.getResult(this.m_nodeList[i]).getErrors();
                    StringBuilder sb = new StringBuilder();
                    for (VerificationError vfyErr : errList) {
                        sb.append(vfyErr.getErrorMessage());
                    }
                    this.displayGlobalFailureErrMsg(VerificationUtil.objArr2String(queryDNSCmd, " "), sb.toString());
                }
                return false;
            }
            for (int i = 0; i < this.m_nodeList.length; ++i) {
                Result result = locrs.getResult(this.m_nodeList[i]);
                if (result.getStatus() == 1) {
                    output = (String)locrs.getResult(this.m_nodeList[i]).getResultInfoSet().get(0);
                    nodeOutputMap.put(this.m_nodeList[i], output);
                    continue;
                }
                List<VerificationError> errList = locrs.getResult(this.m_nodeList[i]).getErrors();
                StringBuilder sb = new StringBuilder();
                for (VerificationError vfyErr : errList) {
                    sb.append(vfyErr.getErrorMessage());
                }
                String errMsg = result.getExecutionErrorDetails();
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                Trace.out((String)("error on node " + this.m_nodeList[i] + " is " + sb.toString()));
                this.m_resultSet.addErrorDescription(this.m_nodeList[i], errDesc);
                ReportUtil.sureprintln(errMsg);
            }
        }
        for (Map.Entry entry : nodeOutputMap.entrySet()) {
            ErrorDescription errDesc;
            output = (String)entry.getValue();
            String node = (String)entry.getKey();
            Trace.out((String)("output =" + output));
            if (output == null || output.length() == 0) {
                this.displayNoOutputErrorMsg(VerificationUtil.objArr2String(queryDNSCmd, " "), node);
                continue;
            }
            if (output.indexOf("CRS-10035:") != -1 || output.indexOf("CRS-10048:") != -1 || output.indexOf("CRS-10023:") != -1) {
                Trace.out((String)"sent name lookup but no response as expected");
                this.m_resultSet.addResult(node, 1);
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("5800", false, (Object[])new String[]{fullHostName}));
                continue;
            }
            if (output.indexOf("CRS-4047:") != -1) {
                Trace.out((String)"could not complete name lookup");
                this.m_resultSet.addResult(node, 3);
                String errMsg = null;
                errMsg = dnsServerAddress == null ? (this.m_isAPIOrRespFilemode ? s_gMsgBundle.getMessage("5825", true, (Object[])new String[]{this.m_gnsDomain}) : s_msgBundle.getMessage("5823", true, (Object[])new String[]{fullHostName})) : (this.m_isAPIOrRespFilemode ? s_gMsgBundle.getMessage("5822", true, (Object[])new String[]{fullHostName, this.m_gnsIP, this.m_gnsPort}) : s_msgBundle.getMessage("5822", true, (Object[])new String[]{fullHostName, this.m_gnsIP, this.m_gnsPort}));
                errMsg = errMsg + LSEP + output;
                errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(errMsg);
                continue;
            }
            if (output.indexOf(fullHostName) != -1) {
                Trace.out((String)"name resolution successful");
                this.m_resultSet.addResult(node, 1);
                continue;
            }
            this.m_resultSet.addResult(node, 2);
            String errMsg = s_msgBundle.getMessage("5714", true, (Object[])new String[]{VerificationUtil.objArr2String(queryDNSCmd, " "), output});
            errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(node, errDesc);
            ReportUtil.sureprintln(errMsg);
        }
        return status;
    }

    private boolean performServerSideChecks() {
        ResultSet locrs;
        boolean status = true;
        ResultSet resultSet = new ResultSet();
        Trace.out((String)"About to start server side");
        Trace.out((String)("TraceFile: " + Trace.getTraceFile()));
        if (!NetworkUtility.checkIPAvailability(this.m_gnsIP, resultSet)) {
            Trace.out((String)"VIP is not available");
            this.m_resultSet.addResultSetData(resultSet);
            return false;
        }
        String[] startIPCmd = new String[]{this.cmdBinLocation, this.START_IP_COMMAND + this.m_gnsVIP};
        resultSet.clear();
        if (!this.executeCrsctlCommands(startIPCmd, crsctlCmdType.StartIP, resultSet)) {
            Trace.out((String)"failed start IP, ping to the IP");
            ResultSet locrs2 = new ResultSet();
            if (NetworkUtility.checkIPAvailability(this.m_gnsIP, locrs2)) {
                Trace.out((String)"VIP is not available after retry");
                this.m_resultSet.addResultSetData(resultSet);
                return false;
            }
        }
        try {
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        catch (InterruptedException ie) {
            Trace.out((String)"woken out of sleep");
            Trace.out((String)ie.getMessage());
        }
        String logDir = VerificationUtil.getCVHome() + "cv" + FILE_SEPARATOR + "log";
        String traceLoc = VerificationUtil.getTraceLoc();
        if (traceLoc != null) {
            logDir = traceLoc;
        }
        Trace.out((String)"starting test dns server");
        Object[] startTestDNSCmd = new String[]{this.cmdOdnsdLocation, "-logpath " + logDir + " -address " + this.m_gnsIP + " -domain " + this.m_gnsDomain + " -verbose"};
        if (!this.m_gnsPort.equalsIgnoreCase("53")) {
            startTestDNSCmd[1] = startTestDNSCmd[1] + " -port " + this.m_gnsPort;
        }
        Trace.out((String)("about to start command " + VerificationUtil.objArr2String(startTestDNSCmd, " ")));
        Process proc = null;
        String output = null;
        if (!this.m_isUnix || !this.m_isRootCredsAvaliable) {
            Runtime rt = Runtime.getRuntime();
            String[] odnsParams = ((String)startTestDNSCmd[1]).split(" ");
            String[] odnsCommand = new String[odnsParams.length + 1];
            odnsCommand[0] = startTestDNSCmd[0];
            System.arraycopy(odnsParams, 0, odnsCommand, 1, odnsParams.length);
            Trace.out((String)"server is starting without rootcredentials");
            try {
                if (this.m_configWizard) {
                    String[] pathWin = new String[]{"PATH=" + System.getenv("PATH")};
                    proc = rt.exec(odnsCommand, pathWin);
                } else {
                    proc = rt.exec(odnsCommand);
                }
            }
            catch (IOException e) {
                Trace.out((String)("exec exception:" + e.getMessage()));
                this.displayGlobalFailureErrMsg(VerificationUtil.objArr2String(startTestDNSCmd, " "), output);
                status = false;
            }
            ODNSDOutputMonitor outputThread = new ODNSDOutputMonitor(proc, s_gMsgBundle);
            outputThread.start();
            try {
                if (this.m_globalContext.getVerificationType() == VerificationType.COMPONENT_DNS_INTEGRITY) {
                    ReportUtil.reportPrintln(LSEP + s_gMsgBundle.getMessage("5805", false));
                }
                Trace.out((String)"Waiting for odnsd process to complete, no RootCreds or not Unix");
                Thread.yield();
                proc.waitFor();
                outputThread.join();
                this.m_listQueryReceive = outputThread.getListReceivedQuery();
                this.m_totalQueryReceive = outputThread.getTotalReceivedQuery();
            }
            catch (InterruptedException e) {
                Trace.out((String)"Interrupted while awaiting odnsd termination");
            }
        } else {
            String[] nodeArr = new String[]{this.m_nodeList[0]};
            locrs = new ResultSet();
            String[] odnsParams = ((String)startTestDNSCmd[1]).split(" ");
            GlobalExecution globalExec = new GlobalExecution();
            ODNSDOutputMonitor odnsdListener = new ODNSDOutputMonitor(s_gMsgBundle);
            if (this.m_globalContext.getVerificationType() == VerificationType.COMPONENT_DNS_INTEGRITY) {
                ReportUtil.reportPrintln(LSEP + s_gMsgBundle.getMessage("5805", false));
            }
            Trace.out((String)"Waiting for odnsd process to complete (shortly)");
            String[] env = new String[]{"LD_LIBRARY_PATH=" + System.getenv("LD_LIBRARY_PATH"), "ORACLE_HOME=" + System.getenv("ORACLE_HOME")};
            try {
                status = globalExec.runGenericCmdAsRoot(nodeArr, (String)startTestDNSCmd[0], env, odnsParams, this.m_rootCreds, this.m_defaultTimeout, odnsdListener, locrs);
            }
            catch (RootAutomationNotConfiguredException e) {
                status = false;
                locrs.addResult(nodeArr, 2);
                ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                locrs.addErrorDescription(errDesc);
            }
            Trace.out((String)"server has finished");
            Trace.out((String)("TraceFile: " + Trace.getTraceFile()));
            this.m_resultSet.addResultSetData(locrs);
            this.m_listQueryReceive = odnsdListener.getListReceivedQuery();
            this.m_totalQueryReceive = odnsdListener.getTotalReceivedQuery();
        }
        Trace.out((String)("Total number of query received " + this.m_totalQueryReceive));
        String[] stopIPCmd = new String[]{this.cmdBinLocation, this.STOP_IP_COMMAND + this.m_gnsIP + "/" + this.m_interface};
        Trace.out((String)"About to stop the server");
        resultSet.clear();
        if (!this.executeCrsctlCommands(stopIPCmd, crsctlCmdType.StopIP, resultSet)) {
            Trace.out((String)"failed stop IP, look for availability");
            locrs = new ResultSet();
            if (!NetworkUtility.checkIPAvailability(this.m_gnsIP, locrs)) {
                Trace.out((String)"VIP is available after retry");
                this.m_resultSet.addResultSetData(resultSet);
                return false;
            }
            status = true;
        }
        return status;
    }

    private boolean executeCrsctlCommands(String[] execCmd, crsctlCmdType cmdType, ResultSet locrs) {
        String msg;
        String output = null;
        String node = this.m_nodeList[0];
        String[] args = null;
        if (!this.m_isUnix || !this.m_isRootCredsAvaliable) {
            VerificationCommand[] cmdArray = new VerificationCommand[1];
            args = new String[1 + execCmd.length];
            args[0] = "-rungencmd";
            System.arraycopy(execCmd, 0, args, 1, execCmd.length);
            String[] pathWin = this.envPath;
            if (this.m_configWizard) {
                pathWin = new String[]{"PATH=" + System.getenv("PATH")};
            }
            cmdArray[0] = new VerificationCommand(node, args, pathWin);
            Trace.out((String)("about to submit cmd : " + execCmd));
            new GlobalHandler().submit((Command[])cmdArray, 0, locrs);
            if (!locrs.anySuccess()) {
                output = cmdArray[0].getOutput();
                this.displayGlobalFailureErrMsg(VerificationUtil.objArr2String(execCmd, " "), output);
                return false;
            }
            Result result = cmdArray[0].getResult();
            if (result.getStatus() == 1) {
                output = cmdArray[0].getOutput();
            }
        } else {
            String[] nodeArr = new String[]{node};
            GlobalExecution globalExec = new GlobalExecution();
            Trace.out((String)("running " + VerificationUtil.objArr2String(execCmd) + " as root"));
            boolean result = false;
            args = execCmd[1].split(" ");
            String[] env = new String[]{"LD_LIBRARY_PATH=" + System.getenv("LD_LIBRARY_PATH")};
            try {
                result = globalExec.runGenericCmdAsRoot(nodeArr, execCmd[0], env, args, this.m_rootCreds, this.m_defaultTimeout, locrs);
            }
            catch (RootAutomationNotConfiguredException e) {
                locrs.addResult(nodeArr, 2);
                ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                locrs.addErrorDescription(errDesc);
            }
            if (locrs.getStatus() != 1) {
                List<VerificationError> errList = locrs.getResult(this.m_nodeList[0]).getErrors();
                Trace.out((String)"root command execution failed");
                StringBuilder sb = new StringBuilder();
                for (VerificationError vfyErr : errList) {
                    sb.append(vfyErr.getErrorMessage());
                }
                this.displayGlobalFailureErrMsg(VerificationUtil.objArr2String(execCmd, " "), sb.toString());
                return false;
            }
            output = (String)locrs.getResult(this.m_nodeList[0]).getResultInfoSet().get(0);
            output = output.trim();
        }
        Trace.out((String)("output =" + output));
        if (output == null || output.length() == 0) {
            msg = null;
            if (cmdType == crsctlCmdType.StartIP) {
                msg = s_msgBundle.getMessage("5802", false, (Object[])new String[]{this.m_gnsVIP, node});
            } else if (cmdType == crsctlCmdType.StartDNS) {
                msg = s_msgBundle.getMessage("5806", false, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort});
            } else if (cmdType == crsctlCmdType.StopIP) {
                msg = s_msgBundle.getMessage("5808", false, (Object[])new String[]{this.m_gnsIP, node});
            }
            ReportUtil.println(msg);
            locrs.addResult(node, 1);
        } else {
            ErrorDescription errDesc;
            String errMsg;
            if (output.indexOf("CRS-4000:") != -1 || output.indexOf("CRS-4047:") != -1) {
                locrs.addResult(node, 2);
                errMsg = null;
                if (cmdType == crsctlCmdType.StartIP) {
                    errMsg = s_msgBundle.getMessage("5803", true, (Object[])new String[]{this.m_gnsVIP, node});
                } else if (cmdType == crsctlCmdType.StartDNS) {
                    errMsg = s_msgBundle.getMessage("5809", true, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort});
                } else if (cmdType == crsctlCmdType.StopDNS) {
                    errMsg = s_msgBundle.getMessage("5810", true, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort});
                } else if (cmdType == crsctlCmdType.StopIP) {
                    errMsg = s_msgBundle.getMessage("5811", true, (Object[])new String[]{this.m_gnsIP, node});
                }
                errMsg = errMsg + LSEP + output;
                errDesc = new ErrorDescription(errMsg);
                locrs.addErrorDescription(errDesc);
                ReportUtil.sureprintln(errMsg);
                return false;
            }
            if (output.indexOf("CRS-10031:") != -1 || output.indexOf("CRS-10032:") != -1) {
                msg = s_msgBundle.getMessage("5807", false, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort});
                ReportUtil.println(msg);
                locrs.addResult(node, 1);
            } else {
                if (output.indexOf("CRS-10033:") != -1 || output.indexOf("CRS-10034:") != -1) {
                    Trace.out((String)"couldn't stop dns server");
                    locrs.addResult(node, 2);
                    errMsg = s_msgBundle.getMessage("5810", true, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort}) + LSEP + output;
                    errDesc = new ErrorDescription(errMsg);
                    locrs.addErrorDescription(errDesc);
                    ReportUtil.sureprintln(errMsg);
                    return false;
                }
                locrs.addResult(node, 2);
                errMsg = s_msgBundle.getMessage("5714", true, (Object[])new String[]{VerificationUtil.objArr2String(execCmd, " "), output});
                errDesc = new ErrorDescription(errMsg);
                locrs.addErrorDescription(errDesc);
                ReportUtil.sureprintln(errMsg);
                return false;
            }
        }
        return true;
    }

    private boolean getCmdLineParams() {
        String tmpGnsIP;
        if (this.m_isAPIOrRespFilemode) {
            String strNetMask = null;
            Trace.out((String)"DNS task about to run in API mode");
            this.m_server = true;
            this.m_client = true;
            this.m_lastClient = true;
            this.m_gnsIP = CVUVariables.getValue(CVUVariableConstants.GNS_VIP_ADDRESS);
            this.m_gnsDomain = CVUVariables.getValue(CVUVariableConstants.GNS_SUB_DOMAIN);
            Set<NetworkInfo> networkInfo = null;
            try {
                networkInfo = NetworkDataDiscovery.getClusterNetworksFromCVUVariable(this.m_resultSet);
                for (NetworkInfo netInt : networkInfo) {
                    if (netInt.getNetworkType() != 2) continue;
                    strNetMask = netInt.getSubnetMask().getHostAddress();
                    if (this.m_isUnix) {
                        this.m_interface = netInt.getInterfaceName();
                        if ((VerificationUtil.isPlatformAix() || VerificationUtil.isPlatformSolaris()) && IPAddressUtil.isIPv6AddressString((String)strNetMask)) {
                            strNetMask = Integer.toString(IPAddressUtil.getIPv6MaskPrefix((String)strNetMask));
                        }
                    } else {
                        this.m_interface = "\\\"" + netInt.getInterfaceName() + "\\\"";
                    }
                    this.m_gnsVIP = this.m_gnsIP + "/" + strNetMask + "/" + this.m_interface;
                    break;
                }
            }
            catch (IPAddressException e) {
                Trace.out((String)("IPAddressException " + (Object)((Object)e)));
                ReportUtil.sureprintln(e.getMessage());
                ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
                return false;
            }
            catch (CVUException e) {
                Trace.out((String)("CVUException " + e));
                ReportUtil.sureprintln(e.getMessage());
                ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
                return false;
            }
            return true;
        }
        if (this.m_globalContext.getVerificationType() == VerificationType.PREREQ_CRS_INST) {
            this.m_server = true;
            this.m_client = true;
            this.m_lastClient = true;
            this.m_isAPIOrRespFilemode = true;
            this.m_useLightVersion = true;
            Trace.out((String)"DNS task about to run in API mode, the type is PREREQ_CRS_INST");
        } else {
            try {
                ParamManager pm = ParamManager.getInstance();
                this.m_server = pm.checkArgServer();
                this.m_client = pm.checkArgClient();
                this.m_lastClient = pm.checkArgLastClient();
            }
            catch (UninitializedParamManagerException e) {
                Trace.out((Exception)e);
            }
        }
        if (this.m_server) {
            this.m_gnsVIP = CVUVariables.getValue(CVUVariableConstants.GNS_VIP_FULL_ADDRESS);
            if (this.m_isUnix) {
                this.m_interface = this.m_gnsVIP.substring(this.m_gnsVIP.lastIndexOf("/") + 1, this.m_gnsVIP.length());
            } else {
                int lastArgIdx = this.m_gnsVIP.lastIndexOf("/");
                StringBuilder tmpAddress = new StringBuilder(this.m_gnsVIP);
                tmpAddress.insert(lastArgIdx + 1, "\\\"");
                tmpAddress.insert(tmpAddress.length(), "\\\"");
                this.m_gnsVIP = tmpAddress.toString();
                this.m_interface = this.m_gnsVIP.substring(lastArgIdx + 1, this.m_gnsVIP.length());
            }
            tmpGnsIP = this.m_gnsVIP.substring(0, this.m_gnsVIP.indexOf("/"));
            Trace.out((String)("vip = " + tmpGnsIP));
            Trace.out((String)("interface = " + this.m_interface));
        } else {
            tmpGnsIP = this.m_gnsVIP = CVUVariables.getValue(CVUVariableConstants.GNS_VIP_ADDRESS);
        }
        try {
            InetAddress tempGNSInetAddr = InetAddress.getByName(tmpGnsIP);
            this.m_gnsIP = tempGNSInetAddr.getHostAddress();
        }
        catch (UnknownHostException e) {
            Trace.out((String)"uhe while translating gns vip");
            String errMsg = s_msgBundle.getMessage("5227", true, (Object[])new String[]{tmpGnsIP});
            ReportUtil.sureprintln(errMsg);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            return false;
        }
        String inputPort = CVUVariables.getValue(CVUVariableConstants.DNS_PORT);
        if (inputPort != null) {
            this.m_gnsPort = inputPort;
        }
        this.m_gnsDomain = CVUVariables.getValue(CVUVariableConstants.GNS_SUB_DOMAIN);
        try {
            GNSUtils gnsUtils = new GNSUtils();
            boolean errDesc = GNSUtils.isDomainNameValid((String)this.m_gnsDomain);
        }
        catch (GNSException e) {
            String msg = s_msgBundle.getMessage("5826", true, (Object[])new String[]{this.m_gnsDomain}) + LSEP + e.getMessage();
            ReportUtil.sureprintln(msg);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            return false;
        }
        try {
            InetAddress.getByName(this.m_gnsIP);
        }
        catch (UnknownHostException e) {
            String msg = s_msgBundle.getMessage("5227", true, (Object[])new String[]{this.m_gnsIP});
            ReportUtil.sureprintln(msg);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            return false;
        }
        return true;
    }

    private void displayNoOutputErrorMsg(String execCmd, String node) {
        Trace.out((String)("no output from command: " + execCmd + "on node: " + node));
        this.m_resultSet.addResult(node, 2);
        String errMsg = s_msgBundle.getMessage("5713", true, (Object[])new String[]{execCmd, node});
        ErrorDescription errDesc = new ErrorDescription(errMsg);
        this.m_resultSet.addErrorDescription(node, errDesc);
        ReportUtil.sureprintln(errMsg);
    }

    private void displayGlobalFailureErrMsg(String execCmd, String output) {
        Trace.out((String)("Global failure executing command " + execCmd));
        String message = s_msgBundle.getMessage("5801", true, (Object[])new String[]{execCmd});
        if (output != null) {
            message = message + LSEP + output;
        }
        ErrorDescription errorDesc = new ErrorDescription(message);
        this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
        this.m_resultSet.addResult(this.m_nodeList, 2);
        ReportUtil.sureprintln(message);
    }

    private Thread spawnServer() {
        int waitCount = 5;
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet resultSetExec = new ResultSet();
        String procName = this.m_useLightVersion ? this.ODNSDLITE_COMMAND : this.ODNSD_COMMAND;
        Trace.out((String)"starting the test dns server in API mode");
        Thread serverThread = new Thread(){

            @Override
            public void run() {
                TaskDNSChecks.this.performServerSideChecks();
            }
        };
        serverThread.start();
        Thread.yield();
        do {
            try {
                Thread.currentThread();
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                Trace.out((String)"woken out of sleep");
                Trace.out((String)ie.getMessage());
            }
            Trace.out((String)("Wait until odnsd is running try " + waitCount));
        } while (!this.performODNSDReachability(false) && --waitCount > 0 && serverThread.isAlive());
        if (!serverThread.isAlive() || waitCount == 0) {
            Trace.out((String)("The server has failed to start cnt: " + waitCount + " isAlive: " + serverThread.isAlive()));
            return null;
        }
        Trace.out((String)("Server thread has moved to start, waitCount " + waitCount));
        return serverThread;
    }

    public void testAPIMode() {
        if (VerificationUtil.isCVUTestEnv()) {
            this.m_isAPIOrRespFilemode = true;
        }
    }

    private static enum crsctlCmdType {
        StartIP,
        StartDNS,
        StopDNS,
        StopIP;

    }
}

