/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.cluster.sql.DBConnectionException;
import oracle.cluster.sql.SQLFactory;
import oracle.cluster.verification.database.DatabaseConnectInfo;
import oracle.cluster.verification.util.CollectionGroup;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.jdbc.driver.OracleConnection;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultKeyType;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskDBInitParamCollection
extends Task {
    private static String m_dbInitParamQuery = "select i.instance_name, p.name, p.value from gv$parameter p,gv$instance I where p.inst_id = i.inst_id order by i.inst_id ";

    public TaskDBInitParamCollection(VerificationTaskContext ctx) {
        super(ctx);
    }

    public TaskDBInitParamCollection(String[] nodeList) {
        super(nodeList);
    }

    @Override
    public boolean performTask() {
        boolean retVal = true;
        Trace.out((String)"Performing DBInit Param Collection");
        this.executeSQL();
        return retVal;
    }

    @Override
    public CollectionGroup getCollectionGroup() {
        return CollectionGroup.DB_INIT_PARAMETER_COLLECTION;
    }

    private void executeSQL() {
        String dbName = null;
        String dbDescr = null;
        String dbUser = null;
        String dbPwd = null;
        dbName = CVUVariables.getValue(CVUVariableConstants.DB_NAME);
        DatabaseConnectInfo connectionInfo = DatabaseConnectInfo.getDBConnectInfo(dbName);
        try {
            dbDescr = new DBUtils(new Version()).getConnectDescriptor(dbName);
            dbUser = connectionInfo.userName();
            dbPwd = connectionInfo.userPassword();
            Result dbRes = new Result(dbName, ResultKeyType.DB_INSTANCE);
            this.m_resultSet.addResult(dbName, dbRes);
            OracleConnection connection = SQLFactory.getDBConnection((String)dbDescr, (String)dbUser, (String)dbPwd);
            Statement st = connection.createStatement();
            String query = m_dbInitParamQuery;
            Trace.out((String)("executing query: " + query));
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                String instanceName = rs.getString(1);
                String paramName = rs.getString(2);
                String paramValue = rs.getString(3);
                CollectionElement CE = new CollectionElement(paramName, paramValue, null, null, paramName, 1);
                this.m_resultSet.addCollectionElement(instanceName, CE, ResultKeyType.DB_INSTANCE);
            }
            this.m_resultSet.addResult(dbName, 1, ResultKeyType.DB_INSTANCE);
            this.m_resultSet.setStatus(1);
            rs.close();
            st.close();
            connection.close();
        }
        catch (DBConnectionException e) {
            this.m_resultSet.addResult(dbName, 2, ResultKeyType.DB_INSTANCE);
            this.m_resultSet.addErrorDescription(dbName, new ErrorDescription(e.getMessage()));
            Trace.out((String)("DBConnectionException occured. message:" + e.getMessage()));
            Trace.out((Exception)((Object)e));
        }
        catch (SQLException e) {
            this.m_resultSet.addResult(dbName, 2);
            this.m_resultSet.addErrorDescription(dbName, new ErrorDescription(e.getMessage()));
            Trace.out((String)("SQLException occured. message:" + e.getMessage()));
        }
        catch (DBUtilsException e) {
            this.m_resultSet.addResult(dbName, 2, ResultKeyType.DB_INSTANCE);
            this.m_resultSet.addErrorDescription(dbName, new ErrorDescription(e.getMessage()));
            Trace.out((String)("SQLException occured. message:" + e.getMessage()));
        }
    }

    @Override
    public String getTaskID() {
        String dbName = CVUVariables.getValue(CVUVariableConstants.DB_NAME);
        return "DB_INIT_PARAMETER_COLLECTION:" + (VerificationUtil.isStringGood(dbName) ? dbName : "");
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11201", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11202", false);
    }
}

