/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.VerifyStorage;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.helper.CVUHelperConstants;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

public class TaskDBHomeAvailability
extends Task
implements CVUHelperConstants {
    private String[] m_databases = null;
    private List<String> m_adminDBConfiguredNodes = new ArrayList<String>();

    public TaskDBHomeAvailability(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        Version actCRSVerObj = VerificationUtil.getCRSActiveVersionObj();
        if (actCRSVerObj != null) {
            DBUtils dbutils = new DBUtils(actCRSVerObj);
            try {
                this.m_databases = dbutils.getDatabases();
            }
            catch (DBUtilsException dbe) {
                VerificationUtil.traceAndLogError("DBUtilsException occurred while retrieving database list. Error is : " + dbe.getMessage());
            }
        } else {
            VerificationUtil.traceAndLogError("CRS active version found to be null");
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (this.m_databases != null && this.m_databases.length > 0) {
            return true;
        }
        VerificationUtil.traceAndLog("Skipping DB home availability check. No databases to check for.");
        return false;
    }

    public TaskDBHomeAvailability(String[] nodeList) {
        super(nodeList);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    @Override
    public boolean performTask() {
        String errMsg;
        boolean retVal = true;
        Trace.out((String)"Performing database home availability check...");
        this.m_resultSet.addResult(this.m_nodeList, 1);
        ReportUtil.println(s_gMsgBundle.getMessage("11862", false));
        ResultSet dbRsltSet = new ResultSet();
        String databaseInfo = CVUHelperUtil.getAdminAndPolicyDBInfo(dbRsltSet);
        this.m_resultSet.addResultSetData(dbRsltSet);
        if (!VerificationUtil.isStringGood(databaseInfo)) {
            Trace.out((String)"cvuhelper failed to get the DB info");
            return false;
        }
        int resultStatus = RootAutomationUtility.isRootExecutionConfigured() ? 3 : 4;
        String adminDBInfo = VerificationUtil.fetchTextByTags(databaseInfo, "<ADMIN_DBINFO>", "</ADMIN_DBINFO>");
        String policyDBInfo = VerificationUtil.fetchTextByTags(databaseInfo, "<POLICY_DBINFO>", "</POLICY_DBINFO>");
        if (VerificationUtil.isStringGood(adminDBInfo)) {
            String[] adminDBInfoArr;
            Trace.out((String)"Admin managed databases exists in the cluster");
            for (String dbInfo : adminDBInfoArr = VerificationUtil.fetchTextByTagsRepeat(adminDBInfo, "<DB_INFO>", "</DB_INFO>")) {
                try {
                    String[] nodeInstanceInfo;
                    HashMap<String, String> nodeInstanceMap = new HashMap<String, String>();
                    for (String nodeInstance : nodeInstanceInfo = VerificationUtil.string2strArr(GenericUtil.getValueByKey(dbInfo, "NODE_INSTANCE_INFO"), " ")) {
                        String[] nodeInstanceArr = VerificationUtil.string2strArr(nodeInstance, ":");
                        if (nodeInstanceArr.length <= 1) continue;
                        nodeInstanceMap.put(nodeInstanceArr[0].toLowerCase(), nodeInstanceArr[1]);
                    }
                    ArrayList<String> adminDBConfiguredNodes = new ArrayList<String>(nodeInstanceMap.keySet());
                    adminDBConfiguredNodes.retainAll(Arrays.asList(this.m_nodeList));
                    for (String node : adminDBConfiguredNodes) {
                        if (this.m_adminDBConfiguredNodes.contains(node)) continue;
                        this.m_adminDBConfiguredNodes.add(node);
                    }
                    if (adminDBConfiguredNodes.size() > 0) {
                        String[] dbHomeInfo = null;
                        int index = dbInfo.indexOf("<NODE_INSTANCE_INFO");
                        if (index != -1) {
                            dbHomeInfo = VerificationUtil.string2strArr(dbInfo.substring(0, index - 1));
                        }
                        if (dbHomeInfo == null || dbHomeInfo.length <= 1) continue;
                        ArrayList<String> verificationFailedNodeList = new ArrayList<String>();
                        String dbName = dbHomeInfo[0];
                        String oracleHome = dbHomeInfo[1];
                        boolean homeExists = this.checkOracleHomeAvailability(adminDBConfiguredNodes, oracleHome, verificationFailedNodeList);
                        if (homeExists) {
                            Trace.out((String)("Admin managed Database home " + oracleHome + " exists on all the nodes which are being " + " added to the cluster"));
                            continue;
                        }
                        if (verificationFailedNodeList.size() <= 0) continue;
                        VerificationUtil.traceAndLog("Admin managed Database home " + oracleHome + " does not exist on nodes:" + VerificationUtil.strList2List(verificationFailedNodeList) + "  which are being added to the cluster");
                        StringBuffer instanceNames = new StringBuffer("");
                        boolean first = true;
                        for (String node : verificationFailedNodeList) {
                            if (first) {
                                first = false;
                            } else {
                                instanceNames.append(",");
                            }
                            instanceNames.append((String)nodeInstanceMap.get(node));
                        }
                        errMsg = resultStatus == 3 ? s_gMsgBundle.getMessage("11865", true, (Object[])new String[]{oracleHome, dbName, instanceNames.toString(), VerificationUtil.strList2List(verificationFailedNodeList)}) : s_gMsgBundle.getMessage("11866", true, (Object[])new String[]{oracleHome, dbName, instanceNames.toString(), VerificationUtil.strList2List(verificationFailedNodeList)});
                        this.m_resultSet.addResult(verificationFailedNodeList, resultStatus);
                        ErrorDescription errDesc = new ErrorDescription(errMsg);
                        this.m_resultSet.addErrorDescription(errDesc);
                        ReportUtil.sureprintln(errMsg);
                        retVal = false;
                        continue;
                    }
                    Trace.out((String)"Configured admin managed databased not found on the  nodes being added to the cluster");
                }
                catch (ParsingException p) {
                    errMsg = s_gMsgBundle.getMessage("11870", true) + LSEP + p.getMessage();
                    VerificationUtil.traceAndLog(errMsg);
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    ErrorDescription errDesc = new ErrorDescription(errMsg);
                    this.m_resultSet.addErrorDescription(errDesc);
                    ReportUtil.sureprintln(errMsg);
                    retVal = false;
                }
            }
        }
        if (VerificationUtil.isStringGood(policyDBInfo)) {
            String[] policyDBInfoArr;
            Trace.out((String)"Policy managed databases exists in the cluster");
            for (String dbInfo : policyDBInfoArr = VerificationUtil.fetchTextByTagsRepeat(policyDBInfo, "<DB_INFO>", "</DB_INFO>")) {
                String[] dbHomeInfo = VerificationUtil.string2strArr(dbInfo);
                if (dbHomeInfo.length <= 1) continue;
                ArrayList<String> verificationFailedNodeList = new ArrayList<String>();
                String dbname = dbHomeInfo[0];
                String oraclehome = dbHomeInfo[1];
                ArrayList<String> policyDBnodeList = new ArrayList<String>(Arrays.asList(this.m_nodeList));
                policyDBnodeList.removeAll(this.m_adminDBConfiguredNodes);
                boolean homeExists = this.checkOracleHomeAvailability(policyDBnodeList, oraclehome, verificationFailedNodeList);
                if (homeExists) {
                    Trace.out((String)("Policy managed Database home" + oraclehome + " exists on all the nodes which are being added " + " to the cluster"));
                    continue;
                }
                if (verificationFailedNodeList.size() <= 0) continue;
                VerificationUtil.traceAndLog("Policy managed Database home " + oraclehome + " does not exist on nodes:" + VerificationUtil.strList2List(verificationFailedNodeList) + "  which are being added to the cluster");
                errMsg = resultStatus == 3 ? s_gMsgBundle.getMessage("11885", true, (Object[])new String[]{oraclehome, dbname, VerificationUtil.strList2List(verificationFailedNodeList)}) : s_gMsgBundle.getMessage("11867", true, (Object[])new String[]{oraclehome, dbname, VerificationUtil.strList2List(verificationFailedNodeList)});
                this.m_resultSet.addResult(verificationFailedNodeList, resultStatus);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(errDesc);
                ReportUtil.sureprintln(errMsg);
                retVal = false;
            }
        }
        if (retVal) {
            Trace.out((String)"All the Database homes exist on the nodes which are being added to the cluster");
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11863", false));
        } else {
            Trace.out((String)"All or some of the Database homes does not exist on the nodes which are being added to the cluster");
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11864", false));
        }
        return retVal;
    }

    private boolean checkOracleHomeAvailability(List<String> nodeList, String oracleHome, List<String> verificationFailedNodeList) {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        VerifyStorage verifyStorage = new VerifyStorage();
        boolean retVal = true;
        try {
            if (!verifyStorage.isACFS(m_localNode, oracleHome)) {
                String filePath = oracleHome + File.separator + "bin" + File.separator + nativeSys.getExeName("oracle");
                retVal = this.checkFileExistence(filePath, nodeList, verificationFailedNodeList);
            } else {
                VerificationUtil.traceAndLog("Storage type retreived for Oracle Home: " + oracleHome + " is ACFS");
            }
        }
        catch (StorageException se) {
            VerificationUtil.traceAndLog("Failed to retrieve the storage type of  Oracle Home " + oracleHome);
            String errStr = s_gMsgBundle.getMessage("11420", true, (Object[])new String[]{oracleHome});
            if (VerificationUtil.isStringGood(se.getMessage())) {
                errStr = errStr + LSEP + se.getMessage();
            }
            this.m_resultSet.addResult(nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errStr);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(errStr);
            retVal = false;
        }
        return retVal;
    }

    private boolean checkFileExistence(String filePath, List<String> nodeList, List<String> verificationFailedNodeList) {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet resultSet = new ResultSet();
        String[] nodeListArr = nodeList.toArray(new String[nodeList.size()]);
        globalExec.checkFileExistence(nodeListArr, filePath, resultSet);
        if (resultSet.allSuccess()) {
            return true;
        }
        Hashtable ht = resultSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result != null && result.getStatus() == 3) {
                verificationFailedNodeList.add(node);
                continue;
            }
            if (result != null && result.getStatus() == 1) continue;
            String errMsg = s_msgBundle.getMessage("5310", true, (Object[])new String[]{filePath, node}) + LSEP + result.getErrMessage();
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(node, errorDesc);
            this.m_resultSet.addResult(node, result.getStatus());
        }
        if (verificationFailedNodeList.size() > 0) {
            String errMsg = s_gMsgBundle.getMessage("9021", true, (Object[])new String[]{filePath, VerificationUtil.strList2List(verificationFailedNodeList)});
            Trace.out((String)errMsg);
            ReportUtil.println(errMsg);
        }
        return false;
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11861", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11860", false);
    }
}

