/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskClusterMgrIntegrity;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskClusterMgrIntegrity
extends Task {
    public TaskClusterMgrIntegrity(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
    }

    public TaskClusterMgrIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskClusterMgrIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskClusterMgrIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        Version verCRSSoft;
        String errMsg = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4800", false));
        ReportUtil.sureblankln();
        ResultSet tempRs = new ResultSet();
        String[] validNodeArr = VerificationUtil.getNodesWithCRSInstall(this.m_nodeList, tempRs);
        if (validNodeArr == null || this.m_nodeList.length != validNodeArr.length) {
            ArrayList<String> failedNodes = new ArrayList<String>(Arrays.asList(this.m_nodeList));
            if (validNodeArr != null) {
                failedNodes.removeAll(Arrays.asList(validNodeArr));
            }
            this.m_resultSet.addResult(failedNodes, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(s_msgBundle.getMessage("9905", true, (Object[])new String[]{VerificationUtil.strList2List(failedNodes)})));
            if (validNodeArr == null) {
                return false;
            }
        }
        this.m_nodeList = validNodeArr;
        String exeHome = VerificationUtil.getCRSHome();
        if (exeHome == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Failed to retrieve CRS home");
            }
            this.m_resultSet.addErrorDescription(new ErrorDescription(s_msgBundle.getMessage("5301", false)));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("exeHome = '" + exeHome + "'"));
        }
        if ((verCRSSoft = VerificationUtil.getCRSSoftwareVersionObj()) == null) {
            errMsg = s_msgBundle.getMessage("4803", false);
            String cause = s_msgBundle.getMessage("5434", true);
            ReportUtil.printError(errMsg + LSEP + cause);
            this.m_resultSet.addResult(m_localNode, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg + LSEP + cause, s_msgBundle.getCause("5434", false), s_msgBundle.getAction("5434", false)));
            return false;
        }
        if (!Version.isPre112((Version)verCRSSoft)) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Checking Cluster Mgr Integrity POST 11.2");
            }
            boolean vfyResult = true;
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4801", false));
            String cmdSpec = exeHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "crsctl check css";
            GlobalExecution globalExec = new GlobalExecution();
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Attempt to run command:'" + cmdSpec + "' on valid nodes:'" + VerificationUtil.strArr2List(validNodeArr) + "'"));
            }
            ResultSet cssResultSet = new ResultSet();
            Hashtable cssCheckOutput = globalExec.runExeWithOutput(validNodeArr, cmdSpec, cssResultSet);
            ReportUtil.blankln();
            ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS);
            for (String node : validNodeArr) {
                ErrorDescription errDesc;
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Checking the result of command execution on node: '" + node + "'"));
                }
                Result result = cssResultSet.getResult(node);
                String etOutput = (String)cssCheckOutput.get(node);
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("exectask Output is:'" + etOutput + "'"));
                }
                if (result.getStatus() == 2) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\nFailed to execute exectask command: " + cmdSpec + "\n on node '" + node + "'"));
                    }
                    errDesc = new ErrorDescription("5302", new String[]{node}, s_msgBundle);
                    errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + cmdSpec + LSEP + result.getExecutionErrorDetails());
                    ReportUtil.printError(errDesc.getErrorMessage());
                    this.m_resultSet.addErrorDescription(errDesc);
                    this.m_resultSet.addResult(node, 2);
                    continue;
                }
                String cmdOutput = VerificationUtil.fetchVerificationValue(etOutput);
                String cmdExitStat = VerificationUtil.fetchVerificationResult(etOutput);
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("cmdExitStat is:'" + cmdExitStat + "'" + LSEP + "cmdOutput is:'" + cmdOutput + "'"));
                }
                if (!cmdExitStat.equals("0")) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\nExectask command: " + cmdSpec + "\n on node '" + node + "'" + "\n encountered the following error: " + cmdOutput));
                    }
                    errDesc = new ErrorDescription("5302", new String[]{node}, s_msgBundle);
                    errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + cmdSpec + LSEP + result.getExecutionErrorDetails());
                    ReportUtil.printError(errDesc.getErrorMessage());
                    this.m_resultSet.addErrorDescription(errDesc);
                    this.m_resultSet.addResult(node, 2);
                    continue;
                }
                if (cmdOutput.contains("CRS-4529")) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("Oracle clusterware in a healthy state on node '" + node + "'"));
                    }
                    ReportUtil.writeRecord(node, ReportUtil.ALIVE);
                    this.m_resultSet.addResult(node, 1);
                    continue;
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Oracle clusterware not in a healthy state on node '" + node + "'" + LSEP + "Command output is: '" + cmdOutput + "'"));
                }
                errDesc = new ErrorDescription("5319", s_msgBundle);
                ReportUtil.writeRecord(node, ReportUtil.NOTALIVE);
                this.m_resultSet.addErrorDescription(node, errDesc);
                this.m_resultSet.addResult(node, 3);
                vfyResult = false;
            }
            ReportUtil.blankln();
            if (vfyResult) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5320", false));
                ReportUtil.sureblankln();
                ReportUtil.sureprintln(s_msgBundle.getMessage("4802", false));
            } else {
                ReportUtil.printError(s_msgBundle.getMessage("5319", true));
                ReportUtil.sureblankln();
                ReportUtil.sureprintln(s_msgBundle.getMessage("4803", false));
            }
            ReportUtil.sureblankln();
            return vfyResult;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Checking Cluster Mgr Integrity PRE 11.2");
        }
        sTaskClusterMgrIntegrity sTask = new sTaskClusterMgrIntegrity(this);
        boolean status = sTask.performCheck();
        return status;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4431", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4482", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        return sb.toString();
    }
}

