/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.Home;
import oracle.cluster.winsecurity.User;
import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCheckWindowsUserConsistency
extends Task {
    private Set<String> m_nodesWithOperationFailure;
    private UserType m_checkType = UserType.INSTALL_USER;

    public TaskCheckWindowsUserConsistency(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        Version actCRSVer = VerificationUtil.getCRSActiveVersionObj();
        this.m_checkType = this.m_globalContext.isUpgrade() && actCRSVer != null && !Version.isPre12101((Version)actCRSVer) && VerificationUtil.isStringGood(CVUVariables.getValue(CVUVariableConstants.CV_RAC_HOME)) ? UserType.ORACLE_HOME_USER : UserType.INSTALL_USER;
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (this.m_nodeList != null && this.m_nodeList.length > 1) {
            VerificationUtil.traceAndLog("CRS user consistency check applicable for " + this.m_checkType.toString());
            return true;
        }
        VerificationUtil.traceAndLog("CRS user consistency check Not Applicable as the node count is not greater than 1");
        return false;
    }

    public TaskCheckWindowsUserConsistency(String[] nodeList, UserType type) {
        super(nodeList);
        this.m_checkType = type;
    }

    @Override
    public boolean performTask() {
        this.m_nodesWithOperationFailure = new HashSet<String>();
        Trace.out((int)2, (String)"Entry");
        String userName = null;
        String message = null;
        ReportUtil.blankln();
        ReportUtil.sureprintln(s_gMsgBundle.getMessage(this.m_checkType == UserType.INSTALL_USER ? "11814" : "11815", false));
        try {
            userName = this.resolveUserName();
            Trace.out((String)("User name is " + userName));
            ResultSet resultSet = new ResultSet();
            UserData userData = this.initUserData(userName);
            switch (userData.getUserAccountType()) {
                case LOCAL_USER: {
                    switch (this.m_checkType) {
                        case INSTALL_USER: {
                            resultSet = this.performChecksForLocalUser(userData);
                            break;
                        }
                        case ORACLE_HOME_USER: {
                            message = s_gMsgBundle.getMessage("11819", true, (Object[])new String[]{userName});
                            resultSet.setStatus(3);
                            resultSet.addErrorDescription(new ErrorDescription(message));
                            ReportUtil.printError(message);
                        }
                    }
                    break;
                }
                case DOMAIN_USER: {
                    resultSet = this.performChecksForDomainUser(userData);
                    break;
                }
                case MSA_USER: {
                    switch (this.m_checkType) {
                        case INSTALL_USER: {
                            Trace.out((String)"Install user was found to be an Managed Service Account user.");
                            resultSet.setStatus(3);
                            break;
                        }
                        case ORACLE_HOME_USER: {
                            Trace.out((String)"Oracle home user consistency check is not applicable  if the home owner account type is Microsoft built in user account type");
                            resultSet.setStatus(1);
                        }
                    }
                    break;
                }
            }
            this.m_resultSet.addResultSetData(resultSet);
        }
        catch (WindowsSecurityException wse) {
            Trace.out((String)("Failed to retrieve the details for user account " + userName + " failed with Error:\n" + wse.getMessage()));
            VerificationLogData.logError("Failed to retrieve the details for user account " + userName + " failed with Error:\n" + wse.getMessage());
            this.m_resultSet.setStatus(2);
            message = s_gMsgBundle.getMessage("11820", true, (Object[])new String[]{userName, m_localNode});
            this.m_resultSet.addErrorDescription(new ErrorDescription(message));
            this.m_resultSet.addErrorDescription(new ErrorDescription(wse.getMessage()));
            this.m_nodesWithOperationFailure.add(m_localNode);
        }
        catch (CVUException ce) {
            message = ce.getMessage();
            Trace.out((String)("Failed to resolve the user name, failed with Error:\n" + message));
            VerificationLogData.logError("Failed to resolve the user name, failed with Error:\n" + message);
            this.m_resultSet.setStatus(2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(message));
            ReportUtil.printError(message);
        }
        this.m_resultSet.setStatus();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_gMsgBundle.getMessage("11812", false, (Object[])new String[]{userName}));
        } else {
            if (!this.m_nodesWithOperationFailure.isEmpty()) {
                message = s_gMsgBundle.getMessage("11820", true, (Object[])new String[]{userName, VerificationUtil.strCollection2String(this.m_nodesWithOperationFailure)});
                this.m_resultSet.addErrorDescription(new ErrorDescription(message));
                ReportUtil.printError(message);
            }
            ReportUtil.printResult(s_gMsgBundle.getMessage("11813", false, (Object[])new String[]{userName}));
        }
        Trace.out((int)2, (String)"Exit");
        return this.m_resultSet.allSuccess();
    }

    private String resolveUserName() throws CVUException {
        String userName = "";
        switch (this.m_checkType) {
            case INSTALL_USER: {
                try {
                    userName = new SystemFactory().CreateSystem().getCurrentUserName();
                    break;
                }
                catch (NativeException ne) {
                    throw new CVUException(ne);
                }
            }
            case ORACLE_HOME_USER: {
                Trace.out((String)"getting winsecurity factory and user");
                String oracleHome = CVUVariables.getValue(CVUVariableConstants.CV_RAC_HOME);
                if (!VerificationUtil.isStringGood(oracleHome)) {
                    return null;
                }
                try {
                    WinSecurityFactory wsecFac = WinSecurityFactory.getInstance((String)(oracleHome + FILE_SEPARATOR + "bin"), (String)VerificationUtil.getDestLoc());
                    Home home = wsecFac.getHome(oracleHome, new Version());
                    Credentials cred = home.getServiceUserFromHomePath();
                    userName = cred.getUsername();
                    break;
                }
                catch (WindowsSecurityException wse) {
                    String msg = s_gMsgBundle.getMessage("11825", true, (Object[])new String[]{oracleHome});
                    msg = msg + LSEP + wse.getMessage();
                    throw new CVUException(msg);
                }
            }
        }
        return userName;
    }

    private UserData initUserData(String userName) throws WindowsSecurityException {
        String srcloc = VerificationUtil.getCVHome();
        String destloc = VerificationUtil.getDestLoc();
        Trace.out((String)"getting winsecurity factory and user");
        WinSecurityFactory wsecFac = WinSecurityFactory.getInstance((String)srcloc, (String)destloc);
        Credentials credentials = new Credentials(userName);
        User user = wsecFac.getUser(credentials, new Version());
        UserAccountType userAccountType = UserAccountType.INVALID_USER;
        if (user.isExists()) {
            if (user.isUserDomainUser()) {
                userAccountType = UserAccountType.DOMAIN_USER;
            }
            if (user.isUserMSA()) {
                userAccountType = UserAccountType.MSA_USER;
            }
            if (user.isExistsLocalAccount()) {
                userAccountType = UserAccountType.LOCAL_USER;
            }
        } else {
            Trace.out((String)("User " + userName + " was not found to be valid user"));
            throw new WindowsSecurityException((Throwable)new CVUException(s_gMsgBundle.getMessage("11820", true, (Object[])new String[]{userName, m_localNode})));
        }
        return new UserData(userName, user, userAccountType);
    }

    private ResultSet performChecksForDomainUser(UserData userData) throws WindowsSecurityException {
        ResultSet resultSet = new ResultSet();
        String message = null;
        ArrayList<String> nodesWithDuplicateAccounts = new ArrayList<String>();
        Trace.out((String)("Current user " + userData.getFullyQualifiedUserName() + " is found to be domain user with domain as " + userData.getDomainName()));
        Trace.out((String)"Checking that there is no local user account on all the applicable cluster nodes");
        ResultSet localUserAccResultSet = this.checkUserAccountExistenceOnNodes(userData, true, Arrays.asList(this.m_nodeList));
        for (String node : this.m_nodeList) {
            Result nodeRes = localUserAccResultSet.getResult(node);
            if (nodeRes.getStatus() == 1) {
                Trace.out((String)("Duplicate local user account (" + node.toUpperCase() + '\\' + userData.getUserName() + ") found when current user (" + userData.getFullyQualifiedUserName() + ") is domain user on node " + node));
                nodesWithDuplicateAccounts.add(node);
                message = s_gMsgBundle.getMessage("11816", true, (Object[])new String[]{userData.getFullyQualifiedUserName(), node.toUpperCase() + '\\' + userData.getUserName(), node});
                resultSet.addErrorDescription(node, new ErrorDescription(message));
                resultSet.addResult(node, 3);
                continue;
            }
            if (nodeRes.getStatus() != 2) continue;
            Trace.out((String)("Failed to determine the local user account (" + node.toUpperCase() + '\\' + userData.getUserName() + ") existence on node " + node));
            VerificationLogData.logError("Failed to determine the local user account (" + node.toUpperCase() + '\\' + userData.getUserName() + ") existence on node " + node);
            resultSet.addResult(node, nodeRes);
            this.m_nodesWithOperationFailure.add(node);
        }
        if (!nodesWithDuplicateAccounts.isEmpty()) {
            message = s_gMsgBundle.getMessage("11818", true, (Object[])new String[]{userData.getFullyQualifiedUserName(), VerificationUtil.strCollection2String(nodesWithDuplicateAccounts)});
            resultSet.addErrorDescription(new ErrorDescription(message));
            ReportUtil.sureprintln(message);
        }
        ArrayList<String> nodeList = new ArrayList<String>();
        for (String node : this.m_nodeList) {
            if (this.m_nodesWithOperationFailure.contains(node)) continue;
            nodeList.add(node);
        }
        if (nodeList.size() > 0) {
            ResultSet domainUserAccResultSet = this.checkUserAccountExistenceOnNodes(userData, false, Arrays.asList(this.m_nodeList));
            if (domainUserAccResultSet.anyFailure()) {
                for (String node : this.m_nodeList) {
                    Result nodeRes = domainUserAccResultSet.getResult(node);
                    if (nodeRes.getStatus() == 2) {
                        Trace.out((String)("Failed to determine the domain user account (" + userData.getFullyQualifiedUserName() + ")existence on node " + node));
                        VerificationLogData.logError("Failed to determine the domain user account (" + userData.getFullyQualifiedUserName() + ")existence on node " + node);
                        resultSet.addResult(node, nodeRes);
                        this.m_nodesWithOperationFailure.add(node);
                        continue;
                    }
                    if (nodeRes.getStatus() == 3) {
                        Trace.out((String)("The domain user account (" + userData.getFullyQualifiedUserName() + ") does not exist on node " + node));
                        continue;
                    }
                    Trace.out((String)("The domain user account (" + userData.getFullyQualifiedUserName() + ") exists on node " + node));
                }
            } else {
                resultSet.addResultSetData(domainUserAccResultSet);
            }
        }
        return resultSet;
    }

    private ResultSet performChecksForLocalUser(UserData userData) throws WindowsSecurityException {
        ResultSet resultSet = new ResultSet();
        Trace.out((String)("User " + userData.getFullyQualifiedUserName() + " is found to be local user "));
        Trace.out((String)"Checking that there is a local user account on all the applicable cluster nodes");
        ArrayList<String> localUserAccountMissingNodes = new ArrayList<String>();
        ResultSet localUserAccResultSet = this.checkUserAccountExistenceOnNodes(userData, true, Arrays.asList(this.m_nodeList));
        if (localUserAccResultSet.anyFailure()) {
            for (String node : this.m_nodeList) {
                Result nodeRes = localUserAccResultSet.getResult(node);
                if (nodeRes.getStatus() == 1) {
                    Trace.out((String)("Local user account (" + node.toUpperCase() + '\\' + userData.getFullyQualifiedUserName() + ") found on node " + node));
                    resultSet.addResult(node, nodeRes);
                    continue;
                }
                if (nodeRes.getStatus() != 3) continue;
                Trace.out((String)("Local user account (" + node.toUpperCase() + '\\' + userData.getFullyQualifiedUserName() + ") was NOT found on node " + node));
                resultSet.addErrorDescription(node, new ErrorDescription(s_gMsgBundle.getMessage("11817", true, (Object[])new String[]{node.toUpperCase() + '\\' + userData.getFullyQualifiedUserName(), node})));
                resultSet.addResult(node, 3);
                localUserAccountMissingNodes.add(node);
            }
        } else {
            resultSet.addResultSetData(localUserAccResultSet);
        }
        if (!localUserAccountMissingNodes.isEmpty()) {
            String message = s_gMsgBundle.getMessage("11817", true, (Object[])new String[]{userData.getFullyQualifiedUserName(), VerificationUtil.strList2List(localUserAccountMissingNodes)});
            resultSet.addErrorDescription(new ErrorDescription(message));
            ReportUtil.sureprintln(message);
        }
        return resultSet;
    }

    private ResultSet checkUserAccountExistenceOnNodes(UserData userData, boolean checkLocalUser, List<String> nodeList) throws WindowsSecurityException {
        ResultSet resultSet = new ResultSet();
        String userName = checkLocalUser ? userData.getUserName() : userData.getFullyQualifiedUserName();
        try {
            Map nodeAccountExistenceMap = checkLocalUser ? userData.getUser().checkLocalAccountExistence(m_localNode, nodeList.toArray(new String[0])) : userData.getUser().isExists(m_localNode, nodeList.toArray(new String[0]));
            for (String node : nodeAccountExistenceMap.keySet()) {
                Result nodeResult = new Result(node);
                boolean isExists = (Boolean)nodeAccountExistenceMap.get(node);
                if (isExists) {
                    Trace.out((String)("The user account (" + userName + ") exist on node " + node));
                    nodeResult.setStatus(1);
                } else {
                    Trace.out((String)("The user account (" + userName + ") does not exist on node " + node));
                    nodeResult.setStatus(3);
                }
                resultSet.addResult(node, nodeResult);
            }
        }
        catch (WindowsSecurityException ece) {
            Trace.out((String)("Failed to retrieve user account detail for user " + userName + " on nodes " + VerificationUtil.strCollection2String(nodeList)));
            for (String node : nodeList) {
                resultSet.addErrorDescription(node, new ErrorDescription(s_gMsgBundle.getMessage("11820", true, (Object[])new String[]{userName, node}) + LSEP + ece.getMessage()));
                resultSet.addResult(node, 2);
            }
        }
        catch (CompositeOperationException coe) {
            Trace.out((String)("Received CompositeOperationException while checking the user account (" + userName + ") on nodes (" + VerificationUtil.strCollection2String(nodeList) + ") Error is: " + coe.getMessage()));
            VerificationLogData.logError("Received CompositeOperationException while checking the user account (" + userName + ") on nodes (" + VerificationUtil.strCollection2String(nodeList) + ") Error is: " + coe.getMessage());
            try {
                Set compositeErrorSet = coe.getOperationIdentifier();
                for (Object obj : compositeErrorSet) {
                    String[] resultStringArr;
                    String errMsg;
                    String reoutput;
                    String[] resultStringArr2;
                    String node = (String)obj;
                    NativeResult nativeResult = coe.getNativeResult(obj);
                    int osErrorCode = nativeResult.getOSErrCode();
                    if (coe.getStatus(obj) == CompositeOperationException.Status.SUCCESS) {
                        if (osErrorCode <= 2) {
                            Trace.out((String)("execution successful on node: " + node));
                            resultSet.addResult(node, 1);
                            resultStringArr2 = nativeResult.getResultString();
                            reoutput = VerificationUtil.strArr2String(resultStringArr2);
                            resultSet.getResult(node).addResultInfo(reoutput);
                            resultSet.getResult(node).addResultInfo(resultStringArr2);
                            continue;
                        }
                        resultSet.addResult(node, 2);
                        errMsg = coe.getMessage() + LSEP + VerificationUtil.strArr2String(nativeResult.getOutputString(), LSEP);
                        ErrorDescription ed = new ErrorDescription(errMsg);
                        resultSet.addErrorDescription(node, ed);
                        continue;
                    }
                    if (coe.getStatus(obj) == CompositeOperationException.Status.FAILURE) {
                        Trace.out((String)"composite operation exception is having failure status");
                        if (osErrorCode <= 2) {
                            Trace.out((String)("execution successful on node: " + node));
                            resultSet.addResult(node, 1);
                            resultStringArr2 = nativeResult.getResultString();
                            reoutput = VerificationUtil.strArr2String(resultStringArr2);
                            resultSet.getResult(node).addResultInfo(reoutput);
                            resultSet.getResult(node).addResultInfo(resultStringArr2);
                            continue;
                        }
                        resultSet.addResult(node, 2);
                        errMsg = s_gMsgBundle.getMessage("11820", true, (Object[])new String[]{userName, node}) + LSEP + coe.getMessage();
                        resultStringArr = nativeResult.getResultString();
                        if (resultStringArr != null) {
                            errMsg = errMsg + LSEP + VerificationUtil.strArr2String(resultStringArr);
                        }
                        ErrorDescription ed = new ErrorDescription(errMsg);
                        resultSet.addErrorDescription(node, ed);
                        continue;
                    }
                    resultSet.addResult(node, 2);
                    Exception nativeException = coe.getException(obj);
                    if (nativeException != null) {
                        resultSet.addErrorDescription(node, new ErrorDescription(nativeException.getMessage()));
                        continue;
                    }
                    resultStringArr = nativeResult.getResultString();
                    if (resultStringArr == null) continue;
                    resultSet.addErrorDescription(node, new ErrorDescription(VerificationUtil.strArr2String(resultStringArr)));
                }
            }
            catch (NoSuchIdentifierException ne) {
                Trace.out((String)ne.getMessage());
            }
        }
        return resultSet;
    }

    private String filterUserName(String userNameString) {
        String userName = "";
        if (VerificationUtil.isStringGood(userNameString)) {
            userName = userNameString.contains("\\") ? userNameString.substring(userNameString.lastIndexOf("\\") + 1) : userNameString;
        }
        return userName;
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11811", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11810", false);
    }

    private class UserData {
        String m_userName;
        String m_domainName;
        User m_userObj;
        UserAccountType m_userAccountType;

        private UserData(String userName, User user, UserAccountType userAccountType) throws WindowsSecurityException {
            this.m_userObj = user;
            this.m_userName = TaskCheckWindowsUserConsistency.this.filterUserName(userName);
            this.m_userAccountType = userAccountType;
            if (userAccountType == UserAccountType.DOMAIN_USER || userAccountType == UserAccountType.MSA_USER) {
                try {
                    this.m_domainName = this.m_userObj.getDomainname();
                }
                catch (WindowsSecurityException wse) {
                    Trace.out((String)("Failed to determine the domain name for user account (" + userName + ")" + wse.getMessage()));
                    VerificationLogData.logError("Failed to determine the domain name for user account (" + userName + ")" + wse.getMessage());
                    String message = Task.s_gMsgBundle.getMessage("11820", true, (Object[])new String[]{userName, Task.m_localNode});
                    message = message + VerificationConstants.LSEP + wse.getMessage();
                    throw new WindowsSecurityException((Throwable)new CVUException(message));
                }
            } else {
                this.m_domainName = "";
            }
        }

        String getDomainName() {
            return this.m_domainName;
        }

        String getUserName() {
            return this.m_userName;
        }

        String getFullyQualifiedUserName() {
            if (VerificationUtil.isStringGood(this.m_domainName)) {
                return this.m_domainName + '\\' + this.m_userName;
            }
            return this.m_userName;
        }

        User getUser() {
            return this.m_userObj;
        }

        UserAccountType getUserAccountType() {
            return this.m_userAccountType;
        }
    }

    private static enum UserType {
        INSTALL_USER,
        ORACLE_HOME_USER;

    }

    private static enum UserAccountType {
        LOCAL_USER,
        DOMAIN_USER,
        MSA_USER,
        INVALID_USER;

    }
}

