/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.SeverityType;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskCheckRPMVersion;
import oracle.ops.verification.framework.report.ReportUtil;

public class TaskCheckRPMVersion
extends Task {
    public TaskCheckRPMVersion(String[] nodeList) {
        super(nodeList);
    }

    @Override
    public boolean performTask() {
        String errMsg = null;
        String msg = null;
        this.setSeverity(SeverityType.IGNORABLE);
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("9102", false));
        HashMap<String, String> nodeVersionPair = new HashMap<String, String>();
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.COMMENT);
        ResultSet rpmVerResults = new ResultSet();
        sTaskCheckRPMVersion sTask = new sTaskCheckRPMVersion();
        sTask.performVerification(this.m_nodeList, nodeVersionPair, rpmVerResults);
        this.m_resultSet.overwriteResultSet(rpmVerResults);
        boolean result = rpmVerResults.allSuccess();
        String expectedVer = sTask.getExpectedRPMVersion();
        Hashtable rsltTab = rpmVerResults.getResultTable();
        Enumeration e = rsltTab.keys();
        Vector<String> verFailedNodes = new Vector<String>();
        Vector<String> operationFailedNodes = new Vector<String>();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result nodeResult = (Result)rsltTab.get(node);
            String actualVer = nodeVersionPair.get(node);
            String comment = null;
            comment = actualVer != null ? s_msgBundle.getMessage("9110", false, (Object[])new String[]{expectedVer, actualVer}) : s_msgBundle.getMessage("9109", false);
            if (nodeResult.getStatus() == 1) {
                ReportUtil.writeRecord(node, ReportUtil.PASSED, comment);
                continue;
            }
            if (nodeResult.getStatus() == 3) {
                ReportUtil.writeRecord(node, ReportUtil.FAILED, comment);
                verFailedNodes.add(node);
                continue;
            }
            ReportUtil.writeRecord(node, ReportUtil.FAILED, comment);
            operationFailedNodes.add(node);
        }
        if (result) {
            msg = s_msgBundle.getMessage("9103", false);
            ReportUtil.printResult(msg);
        } else {
            msg = s_msgBundle.getMessage("9104", false);
            ReportUtil.printResult(msg);
            if (verFailedNodes.size() > 0) {
                errMsg = s_msgBundle.getMessage("9105", true, (Object[])new String[]{expectedVer});
                ReportUtil.printErrorWithNodes(errMsg, verFailedNodes);
            }
            if (operationFailedNodes.size() > 0) {
                errMsg = s_msgBundle.getMessage("9107", true);
                ReportUtil.printErrorWithNodes(errMsg, operationFailedNodes);
            }
        }
        return result;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("9100", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("9101", false);
    }
}

