/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.network.NetworkDataDiscovery;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCheckLoopback
extends Task {
    boolean m_checkIPv6 = false;
    boolean m_checkIPv4 = false;
    private HashMap<String, Set<NetworkInfo>> m_globalNodeNetworksMap = null;

    public TaskCheckLoopback(VerificationTaskContext ctx) {
        super(ctx);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return this.m_checkIPv4 || this.m_checkIPv6;
    }

    @Override
    protected void init() {
        if (!this.m_globalContext.isPreCRS()) {
            return;
        }
        Set<NetworkInfo> clusterNetworks = NetworkDataDiscovery.getClusterNetworks(m_localNode, new ResultSet());
        VerificationUtil.traceAndLog("ClusterNetworks: %s", VerificationUtil.strCollection2String(NetworkDataDiscovery.getClusterNetworkNames(clusterNetworks)));
        if (NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            String udID = VerificationUtil.getUniqueDistributionID();
            if (VerificationUtil.isPlatformSolaris() && VerificationUtil.isVersionPost(udID, "5.11")) {
                this.m_checkIPv6 = true;
                this.m_checkIPv4 = true;
            } else if (VerificationUtil.isPlatformSolaris() && VerificationUtil.isVersionPre(udID, "5.11") || VerificationUtil.isPlatformLinux()) {
                for (NetworkInfo network : clusterNetworks) {
                    if (!this.m_checkIPv4) {
                        this.m_checkIPv4 = NetworkUtility.isIPV4(network, true);
                    }
                    if (!this.m_checkIPv6) {
                        this.m_checkIPv6 = NetworkUtility.isIPV6(network, true);
                    }
                    if (!this.m_checkIPv4 || !this.m_checkIPv6) continue;
                    break;
                }
            }
        } else {
            Trace.out((String)"No cluster networks found provided nor configured, nothing to check.");
        }
    }

    @Override
    protected boolean performTask() {
        Trace.out((String)"check ipv4 loopback [%s], check ipv6 loopback [%s]", (Object[])new Object[]{Boolean.toString(this.m_checkIPv4), Boolean.toString(this.m_checkIPv6)});
        boolean retVal = true;
        this.m_resultSet.addResult(this.m_nodeList, 1);
        ResultSet networksResultSet = new ResultSet();
        networksResultSet.addResult(this.m_nodeList, 1);
        if (VerificationUtil.isPlatformLinux()) {
            this.m_globalNodeNetworksMap = NetworkDataDiscovery.discoverAllNetworks(this.m_nodeList, networksResultSet, true);
        } else if (VerificationUtil.isPlatformSolaris()) {
            this.m_globalNodeNetworksMap = NetworkUtility.discoverLoopbackNetworksOnSolaris(this.m_nodeList, networksResultSet);
        }
        for (String node : this.m_globalNodeNetworksMap.keySet()) {
            VerificationUtil.traceAndLog("node [%s] Networks: [%s]", node, VerificationUtil.strCollection2String(NetworkDataDiscovery.getClusterNetworkNames(this.m_globalNodeNetworksMap.get(node))));
        }
        if (!NetworkUtility.isNetworksMapGood(this.m_globalNodeNetworksMap)) {
            Trace.out((String)"Could not discover the network details successfully during Loopback checks");
            NetworkUtility.reportResultSet(networksResultSet, this.m_resultSet, true);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        this.m_resultSet.uploadResultSet(networksResultSet);
        if (networksResultSet.anySuccess()) {
            String[] considerNodes = networksResultSet.getSuccNodes();
            if (this.m_checkIPv4) {
                retVal &= this.checkLoopbackInterface(considerNodes, "13362", IPAddressUtil.IPAddrType.IPv4);
            }
            if (this.m_checkIPv6) {
                retVal &= this.checkLoopbackInterface(considerNodes, "13363", IPAddressUtil.IPAddrType.IPv6);
            }
        } else {
            Trace.out((String)"There are no good nodes to perform the verification on");
        }
        return retVal;
    }

    private boolean checkLoopbackInterface(String[] nodeList, String msgID, IPAddressUtil.IPAddrType ipTypeReq) {
        Trace.out((Object)"Check for loopback [%s]", (String)ipTypeReq.toString());
        ArrayList<String> nodesMissingLoopback = new ArrayList<String>();
        boolean retVal = this.isLoopbackInterfaceUp(nodeList, ipTypeReq, nodesMissingLoopback);
        if (nodesMissingLoopback.size() > 0) {
            String errorMsg = s_gMsgBundle.getMessage(msgID, true, (Object[])new String[]{VerificationUtil.strCollection2String(nodesMissingLoopback)});
            ErrorDescription errDesc = new ErrorDescription(errorMsg);
            this.m_resultSet.addResult(nodesMissingLoopback, 3);
            this.m_resultSet.addErrorDescription(errDesc);
        }
        return retVal;
    }

    private boolean isLoopbackInterfaceUp(String[] nodeList, IPAddressUtil.IPAddrType ipTypeReq, List<String> nodesMissingLoopback) {
        for (String node : nodeList) {
            boolean foundLoopbackUp = false;
            Set<NetworkInfo> nodeNetworks = this.m_globalNodeNetworksMap.get(node);
            if (NetworkUtility.isNetworksSetGood(nodeNetworks)) {
                for (NetworkInfo network : nodeNetworks) {
                    if (!IPAddressUtil.isLocalhost((String)network.getIPAsString())) continue;
                    IPAddressUtil.IPAddrType ipType = network.getIpAddressType();
                    Trace.out((int)1, (String)("IPType found for localhost is " + ipType.toString()));
                    if (ipType != IPAddressUtil.IPAddrType.BOTH && ipType != ipTypeReq || network.getStatus() != 22) continue;
                    foundLoopbackUp = true;
                    Trace.out((int)1, (String)("Found correct ipType loopback on node " + node));
                    break;
                }
            }
            if (foundLoopbackUp) continue;
            Trace.out((String)"Loopback %s is missing on node %s", (Object[])new Object[]{ipTypeReq.toString(), node});
            nodesMissingLoopback.add(node);
        }
        return nodesMissingLoopback.isEmpty();
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("13361", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("13360", false);
    }
}

