/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.OracleDirectoryType;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.Assert;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCheckHome
extends Task {
    private String m_location;
    private OracleDirectoryType m_type;
    private static final double OB_SPACE_REQUIRED = 1.0;
    private static final double OB_SPACE_RECOMMENDED = 10.0;
    private static final double OB_SPACE_RECOMMENDED_DSC = 100.0;

    public TaskCheckHome(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("PATH".equals(argName)) {
                this.m_location = argVal;
                continue;
            }
            if ("TYPE".equals(argName)) {
                this.m_type = OracleDirectoryType.valueOf(argVal);
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (!VerificationUtil.isStringGood(this.m_location)) {
            Trace.out((String)"The task is not applicable because the home location is unavailable");
            return false;
        }
        return true;
    }

    public TaskCheckHome(String[] nodeList, String path, OracleDirectoryType type) {
        super(nodeList, null, 1);
        this.m_location = path;
        this.m_type = type;
    }

    @Override
    public boolean performTask() {
        boolean ret = true;
        try {
            Assert.assertPath(this.m_location);
        }
        catch (InvalidPathException ipe) {
            Trace.out((String)("InvalidPathException: " + ipe.getMessage()));
            ErrorDescription errorDesc = new ErrorDescription(ipe.getMessage());
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ReportUtil.printError(ipe.getMessage() + LSEP);
            return false;
        }
        switch (this.m_type) {
            case CRS_HOME: 
            case GI_HOME: {
                ret = this.performCRSHomeChecks();
                break;
            }
            case ORACLE_HOME: 
            case RAC_HOME: {
                ret = this.performRACHomeChecks();
                break;
            }
            case ORACLE_BASE: {
                if (!VerificationUtil.isPlatformWindows() && this.m_globalContext.isUpgrade()) {
                    Trace.out((String)"Unix platform during upgrade. setting severity to FATAL");
                    this.setSeverity(SeverityType.FATAL);
                }
                ret = this.performOracleBaseChecks();
            }
        }
        return ret;
    }

    public boolean performCRSHomeChecks() {
        Trace.out((String)"Performing destination CRS home verification task... ");
        ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("11981", false, (Object[])new String[]{this.m_location}));
        Trace.out((String)("Destination CRS home path[" + this.m_location + "]"));
        ResultSet pathExCrRset = new ResultSet();
        VerificationUtil.checkPathWriteableCreateable(this.m_nodeList, this.m_location, pathExCrRset, false);
        TaskAnonymousProxy anonymousTask = new TaskAnonymousProxy("'" + this.m_location + "'", this.m_nodeList, this, pathExCrRset);
        anonymousTask.perform();
        this.m_resultSet.uploadResultSet(pathExCrRset);
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11982", false));
            return true;
        }
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11983", false));
        return false;
    }

    private boolean performRACHomeChecks() {
        Trace.out((String)"Performing Oracle home verification task... ");
        ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("11954", false, (Object[])new String[]{this.m_location}));
        Trace.out((String)("Oracle home path[" + this.m_location + "]"));
        ResultSet pathExCrRset = new ResultSet();
        VerificationUtil.checkPathWriteableCreateable(this.m_nodeList, this.m_location, pathExCrRset, false);
        if (!VerificationUtil.isPlatformWindows()) {
            pathExCrRset.addResultSetData(this.checkRACHomePermissions());
        }
        TaskAnonymousProxy anonymousTask = new TaskAnonymousProxy("'" + this.m_location + "'", this.m_nodeList, this, pathExCrRset);
        anonymousTask.perform();
        this.m_resultSet.uploadResultSet(pathExCrRset);
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11955", false));
            return true;
        }
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11956", false));
        return false;
    }

    private ResultSet checkRACHomePermissions() {
        ResultSet permsCheckRes = new ResultSet();
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        VerificationUtil.pathExists(this.m_nodeList, this.m_location, 1, succNodes, failNodes);
        if (!succNodes.isEmpty()) {
            Hashtable<String, FileInfo> nodeHomePathAttrTable = VerificationUtil.getFileAttributes(this.m_location, succNodes.toArray(new String[0]), permsCheckRes);
            String expectedPermissions = new FileInfo.Permissions("050").toStringGroup();
            for (String node : nodeHomePathAttrTable.keySet()) {
                FileInfo.Permissions nodeHomePerms = nodeHomePathAttrTable.get(node).getFilePermissionsObj();
                Trace.out((String)("RAC home (" + this.m_location + ") has permissions (" + nodeHomePerms.toString() + ") on node (" + node + ")"));
                if (!nodeHomePerms.isGroupReadable() || !nodeHomePerms.isGroupExecutable()) {
                    permsCheckRes.addResult(node, 3);
                    String errorMsg = "";
                    if (!nodeHomePerms.isGroupReadable()) {
                        errorMsg = s_gMsgBundle.getMessage("11946", true, (Object[])new String[]{this.m_location, node});
                    }
                    if (!nodeHomePerms.isGroupExecutable()) {
                        errorMsg = errorMsg + (VerificationUtil.isStringGood(errorMsg) ? LSEP : "") + s_gMsgBundle.getMessage("11947", true, (Object[])new String[]{this.m_location, node});
                    }
                    permsCheckRes.addErrorDescription(new ErrorDescription(errorMsg));
                    VerificationUtil.traceAndLogError("Incorret group permissions detected on RAC home path (" + this.m_location + ") on node (" + node + ") Expected atleast (" + expectedPermissions + ") current (" + nodeHomePerms.toStringGroup() + ")");
                    continue;
                }
                permsCheckRes.addResult(node, 1);
            }
        } else {
            permsCheckRes.addResult(this.m_nodeList, 1);
            Trace.out((String)("The home location (" + this.m_location + ") does not exist on any of" + " the nodes. permissions check is being skipped. "));
        }
        return permsCheckRes;
    }

    private boolean performOracleBaseChecks() {
        Trace.out((String)"Performing Oracle base verification task... ");
        ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("11964", false, (Object[])new String[]{this.m_location}));
        Trace.out((String)("Oracle base path[" + this.m_location + "]"));
        ResultSet oBaseRset = new ResultSet();
        VerificationUtil.checkPathWriteableCreateable(this.m_nodeList, this.m_location, oBaseRset, false);
        Hashtable ht = oBaseRset.getResultTable();
        Enumeration e = ht.keys();
        int nodeCount = ht.size();
        HashMap<String, List<String>> pathNodeMap = new HashMap<String, List<String>>();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result pathResult = (Result)ht.get(node);
            if (pathResult.getStatus() != 1) continue;
            String longestPath = (String)pathResult.getResultInfoSet().firstElement();
            if (pathNodeMap.containsKey(longestPath)) {
                pathNodeMap.get(longestPath).add(node);
                continue;
            }
            ArrayList<String> nodeList = new ArrayList<String>();
            nodeList.add(node);
            pathNodeMap.put(longestPath, nodeList);
        }
        ResultSet spaceRset = new ResultSet();
        this.checkOracleBaseSpace(pathNodeMap, spaceRset);
        oBaseRset.addResultSetData(spaceRset);
        TaskAnonymousProxy anonymousTask = new TaskAnonymousProxy("'" + this.m_location + "'", this.m_nodeList, this, oBaseRset);
        anonymousTask.perform();
        this.m_resultSet.uploadResultSet(oBaseRset);
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11965", false));
            return true;
        }
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11966", false));
        return false;
    }

    private void checkOracleBaseSpace(HashMap<String, List<String>> pathNodeMap, ResultSet spaceRset) {
        double spaceRec = 10.0;
        String clusterType = CVUVariables.getValue(CVUVariableConstants.RSP_CLUSTERTYPE_OPT);
        if (VerificationUtil.isStringGood(clusterType) && "domain".equalsIgnoreCase(clusterType)) {
            spaceRec = 100.0;
        }
        StorageSize recSpace = new StorageSize(spaceRec, StorageUnit.GBYTE);
        StorageSize reqSpace = new StorageSize(1.0, StorageUnit.GBYTE);
        ResultSet resultSet = new ResultSet();
        ResultSet fsrSet = new ResultSet();
        for (Map.Entry<String, List<String>> entry : pathNodeMap.entrySet()) {
            String location = entry.getKey();
            List<String> nodeList = entry.getValue();
            fsrSet.clear();
            Trace.out((String)("Getting free space for " + location + " on nodes " + VerificationUtil.strCollection2String(nodeList)));
            GlobalExecution globalExec = new GlobalExecution();
            globalExec.getFreeSpace(nodeList.toArray(new String[0]), location, fsrSet);
            resultSet.addResultSetData(fsrSet);
        }
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            boolean gotSpaceValue = false;
            if (result.getStatus() == 1) {
                long avlSpace = 0L;
                try {
                    Long lAvl = (Long)result.getResultInfoSet().firstElement();
                    avlSpace = lAvl;
                    StorageSize avlSpaceMS = new StorageSize((double)avlSpace, StorageUnit.BYTE);
                    if (avlSpaceMS.compareTo(reqSpace) < 0) {
                        VerificationUtil.traceAndLog("Insufficient space on node: " + node + " [Required=" + reqSpace + ", Available=" + avlSpaceMS + "]");
                        spaceRset.addResult(node, 3);
                        errDesc = new ErrorDescription(s_msgBundle.getMessage("7501", true, (Object[])new String[]{this.m_location, node, ReportUtil.unitizeSize(reqSpace), ReportUtil.unitizeSize(avlSpaceMS)}));
                        spaceRset.addErrorDescription(node, errDesc);
                    } else if (avlSpaceMS.compareTo(recSpace) < 0) {
                        VerificationUtil.traceAndLog("Insufficient space on node: " + node + " [Required=" + recSpace + ", Available=" + avlSpaceMS + "]");
                        spaceRset.addResult(node, 4);
                        errDesc = new ErrorDescription(s_msgBundle.getMessage("7501", true, (Object[])new String[]{this.m_location, node, ReportUtil.unitizeSize(recSpace), ReportUtil.unitizeSize(avlSpaceMS)}));
                        spaceRset.addErrorDescription(node, errDesc);
                    }
                    gotSpaceValue = true;
                }
                catch (NumberFormatException nfe) {
                    Trace.out((Exception)nfe);
                }
            }
            if (gotSpaceValue) continue;
            VerificationUtil.traceAndLog("Free space  couldn't be obtained from node: " + node);
            errDesc = new ErrorDescription(s_msgBundle.getMessage("7592", true, (Object[])new String[]{this.m_location, node}));
            spaceRset.addResult(node, 2);
            spaceRset.addErrorDescription(node, errDesc);
        }
    }

    @Override
    public String getDefaultElementName() {
        String elem = null;
        switch (this.m_type) {
            case CRS_HOME: 
            case GI_HOME: {
                elem = s_gMsgBundle.getMessage("11979", false, (Object[])new String[]{this.m_location});
                break;
            }
            case ORACLE_HOME: 
            case RAC_HOME: {
                elem = s_gMsgBundle.getMessage("11952", false, (Object[])new String[]{this.m_location});
                break;
            }
            case ORACLE_BASE: {
                elem = s_gMsgBundle.getMessage("11962", false, (Object[])new String[]{this.m_location});
            }
        }
        return elem;
    }

    @Override
    public String getDefaultDescription() {
        String description = null;
        switch (this.m_type) {
            case CRS_HOME: 
            case GI_HOME: {
                description = s_gMsgBundle.getMessage("11980", false, (Object[])new String[]{this.m_location});
                break;
            }
            case ORACLE_HOME: 
            case RAC_HOME: {
                description = s_gMsgBundle.getMessage("11953", false, (Object[])new String[]{this.m_location});
                break;
            }
            case ORACLE_BASE: {
                description = s_gMsgBundle.getMessage("11963", false, (Object[])new String[]{this.m_location});
            }
        }
        return description;
    }
}

