/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.ASMDiskData;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCheckDiskScheduler
extends Task {
    private String[] m_inputDevicePaths = null;
    private String[] m_processedPaths = null;
    private String m_typeScheduler;
    private boolean m_preCRSInst = false;
    private HashMap<String, Vector<StorageInfo>> m_storageInfoMap = new HashMap();
    private boolean m_isCvuqdiskCheckRequired = true;

    public TaskCheckDiskScheduler(VerificationTaskContext ctx) {
        super(ctx);
    }

    public TaskCheckDiskScheduler(String[] nodeList) {
        super(nodeList, null, 1);
        this.m_typeScheduler = VDMUtil.getDefaultIOScheduler();
    }

    @Override
    protected void init() {
        this.m_typeScheduler = VDMUtil.getDefaultIOScheduler();
        this.m_isCvuqdiskCheckRequired = this.m_isCvuqdiskCheckRequired && VerificationUtil.isPlatformLinux();
        switch (this.m_globalContext.getVerificationType()) {
            case PREREQ_CRS_INST: 
            case BESTPRACTICE_PRE_CRS_INST: 
            case PREREQ_USM_CONFIG: {
                this.initPre();
                break;
            }
        }
    }

    private void initPre() {
        String asmDeviceString = CVUVariables.getValue(CVUVariableConstants.ASM_DISKGROUP_DISKS);
        String asmDiscoveryString = CVUVariables.getValue(CVUVariableConstants.ASM_DISK_DISCOVERY_STRING);
        Trace.out((String)"ASM Disks=%s, ASM Discovery String=%s", (Object[])new Object[]{asmDeviceString, asmDiscoveryString});
        asmDeviceString = asmDeviceString != null ? asmDeviceString : asmDiscoveryString;
        String[] devarr = null;
        if (asmDeviceString != null) {
            devarr = asmDeviceString.split(",");
        } else {
            devarr = this.m_globalContext.getASMdevices();
            Trace.out((Object)"Using ASM Devices from context: %s", (String)VerificationUtil.strArr2List(devarr));
        }
        this.setInputDevicePaths(devarr);
        this.setPreCRSInst();
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        block8: {
            block7: {
                if (VerificationUtil.isEngineeredSystem()) break block7;
                TaskCheckDiskScheduler taskCheckDiskScheduler = this;
                if (!taskCheckDiskScheduler.m_globalContext.isMemberCluster()) break block8;
            }
            return false;
        }
        switch (this.m_globalContext.getVerificationType()) {
            case PREREQ_CRS_INST: 
            case BESTPRACTICE_PRE_CRS_INST: 
            case PREREQ_USM_CONFIG: {
                return this.m_inputDevicePaths != null || this.m_processedPaths != null || !this.m_storageInfoMap.isEmpty();
            }
            case POSTREQ_CRS_INST: 
            case BESTPRACTICE_POSTREQ_CRS_INST: {
                return this.m_globalContext.isOCROrVdiskOnASM();
            }
            case POSTREQ_USM_CONFIG: {
                return true;
            }
        }
        return false;
    }

    public TaskCheckDiskScheduler(String[] nodeList, String typeScheduler) {
        super(nodeList, null, 1);
        this.m_typeScheduler = typeScheduler;
    }

    public String[] getInputDevicePaths() {
        return this.m_inputDevicePaths;
    }

    public void setInputDevicePaths(String[] devicePaths) {
        this.m_inputDevicePaths = devicePaths;
    }

    public void setPreCRSInst() {
        this.m_preCRSInst = true;
    }

    @Override
    public boolean performTask() {
        boolean storageInfoAvailable;
        Hashtable<String, Hashtable<String, List<String>>> nodeGroupsDisks = new Hashtable<String, Hashtable<String, List<String>>>();
        Hashtable<String, List<ASMDiskData>> nodeDevicesMap = new Hashtable<String, List<ASMDiskData>>();
        ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("11972", false));
        if (this.m_isCvuqdiskCheckRequired) {
            boolean cvuqdiskAvailable = false;
            String[] pkgRsltSet = new ResultSet();
            cvuqdiskAvailable = VerificationUtil.isCVUQDiskAvailable(this.m_nodeList, (ResultSet)pkgRsltSet, this);
            if (!cvuqdiskAvailable) {
                this.m_resultSet.addResultSetData((ResultSet)pkgRsltSet);
                VerificationUtil.traceAndLog("cvuqdisk rpm is not installed. Skipping validation of I/O scheduler");
                Enumeration enumNodes = this.m_resultSet.getResultTable().keys();
                while (enumNodes.hasMoreElements()) {
                    String node = (String)enumNodes.nextElement();
                    ((Result)this.m_resultSet.getResultTable().get(node)).setStatus(4);
                }
                this.m_resultSet.setStatus(4);
                this.setSeverity(SeverityType.IGNORABLE);
                return false;
            }
        }
        this.m_resultSet.addResult(this.m_nodeList, 1);
        boolean bl = storageInfoAvailable = this.m_storageInfoMap != null && !this.m_storageInfoMap.isEmpty();
        if (this.m_preCRSInst || storageInfoAvailable) {
            if (this.m_inputDevicePaths != null && this.m_inputDevicePaths.length > 0) {
                for (String node : this.m_nodeList) {
                    List<String> expandedDeviceList = StorageUtil.expandDevicePaths(node, this.m_inputDevicePaths);
                    expandedDeviceList = new ArrayList<String>(new LinkedHashSet<String>(expandedDeviceList));
                    Trace.out((String)("expanded device list: " + expandedDeviceList));
                    ArrayList<String> resolvedDevicePathList = new ArrayList<String>();
                    ArrayList<String> devicesManagedByASM = new ArrayList<String>();
                    StorageUtil.processASMDiskStamps(new String[]{node}, expandedDeviceList, devicesManagedByASM, resolvedDevicePathList);
                    Trace.out((String)("node [" + node + "] resolvedPaths: " + resolvedDevicePathList));
                    ArrayList<ASMDiskData> disks = new ArrayList<ASMDiskData>();
                    for (String asmDiskPath : resolvedDevicePathList) {
                        ASMDiskData diskData = new ASMDiskData();
                        diskData.setASMDisk(asmDiskPath);
                        disks.add(diskData);
                    }
                    nodeDevicesMap.put(node, disks);
                }
            }
            if (this.m_processedPaths != null && this.m_processedPaths.length > 0) {
                ArrayList disks = new ArrayList();
                for (String asmDiskPath : this.m_processedPaths) {
                    ASMDiskData diskData = new ASMDiskData();
                    diskData.setASMDisk(asmDiskPath);
                    disks.add(diskData);
                }
                for (String node : this.m_nodeList) {
                    nodeDevicesMap.put(node, disks);
                }
            }
            if (storageInfoAvailable) {
                for (String path : this.m_storageInfoMap.keySet()) {
                    for (StorageInfo st : this.m_storageInfoMap.get(path)) {
                        ASMDiskData diskData = new ASMDiskData();
                        diskData.setASMDisk(path);
                        diskData.setStorageInfo(st);
                        String node = st.getNode();
                        if (!nodeDevicesMap.containsKey(node)) {
                            nodeDevicesMap.put(node, new ArrayList());
                        }
                        nodeDevicesMap.get(node).add(diskData);
                    }
                }
            }
        } else {
            ResultSet diskGroupRS = new ResultSet();
            try {
                boolean result = new ASMDiskGroupsUtil().getDiskGroupsDiskMap(this.m_nodeList, diskGroupRS, nodeGroupsDisks);
                if (!result) {
                    Trace.out((String)"Failed to retrieve the disk group information");
                    List<VerificationError> errorList = diskGroupRS.getErrors();
                    for (VerificationError err : errorList) {
                        ReportUtil.printError(err.getErrorMessage());
                    }
                    this.m_resultSet.addResultSetData(diskGroupRS);
                    return false;
                }
                if (diskGroupRS.anyFailure()) {
                    ReportUtil.printWarning(s_gMsgBundle.getMessage("11978", false));
                    this.m_resultSet.addResult(this.m_nodeList, 4);
                    this.setSeverity(SeverityType.IGNORABLE);
                    return true;
                }
                Enumeration<String> nodekeys = nodeGroupsDisks.keys();
                Enumeration<String> groupkeys = null;
                Hashtable<String, List<String>> groupDev = null;
                List<String> devices = null;
                String groupkey = null;
                String nodeKey = null;
                ASMDiskData diskData = null;
                while (nodekeys.hasMoreElements()) {
                    nodeKey = nodekeys.nextElement();
                    groupDev = nodeGroupsDisks.get(nodeKey);
                    groupkeys = groupDev.keys();
                    while (groupkeys.hasMoreElements()) {
                        groupkey = groupkeys.nextElement();
                        devices = groupDev.get(groupkey);
                        ArrayList<String> resolvedDevicePathList = new ArrayList<String>();
                        ArrayList<String> devicesManagedByASM = new ArrayList<String>();
                        StorageUtil.processASMDiskStamps(new String[]{nodeKey}, devices, devicesManagedByASM, resolvedDevicePathList);
                        Trace.out((String)("node [" + nodeKey + "] resolvedPaths: " + resolvedDevicePathList));
                        List<Object> disks = null;
                        disks = nodeDevicesMap.containsKey(nodeKey) && nodeDevicesMap.get(nodeKey) != null ? nodeDevicesMap.get(nodeKey) : new ArrayList();
                        for (String devicePath : resolvedDevicePathList) {
                            diskData = new ASMDiskData();
                            diskData.setASMDisk(devicePath);
                            diskData.setASMDiskGroup(groupkey);
                            disks.add(diskData);
                        }
                        nodeDevicesMap.put(nodeKey, disks);
                    }
                }
            }
            catch (ASMDiskGroupsUtilException asme) {
                Trace.out((String)("Failed to discover the asm disks of the disk groups\n" + asme.getMessage()));
                VerificationLogData.log(asme.getMessage());
                ReportUtil.printError(asme.getMessage());
                this.m_resultSet.addResultSetData(diskGroupRS);
                return false;
            }
        }
        ResultSet checkSchedulerRset = new ResultSet();
        if (nodeDevicesMap.size() > 0) {
            this.performCheckDiskScheduler(nodeDevicesMap, checkSchedulerRset);
        } else {
            checkSchedulerRset.addResult(this.m_nodeList, 1);
            for (String node : this.m_nodeList) {
                this.m_resultSet.getResult(node).setHasResultValues(false);
            }
        }
        this.m_resultSet.addResultSetData(checkSchedulerRset);
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11973", false));
            return true;
        }
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11974", false));
        return false;
    }

    private void performCheckDiskScheduler(Hashtable<String, List<ASMDiskData>> nodeDevices, ResultSet rset) {
        StorageInfo storageInfo = null;
        List<ASMDiskData> asmDisks = null;
        Object realPathdevice = null;
        String nodeName = null;
        Enumeration<String> nodeNames = nodeDevices.keys();
        Hashtable<ASMDiskData, List<String>> schedulerNotExpected = new Hashtable<ASMDiskData, List<String>>();
        String[] schdulerTypeArr = VerificationUtil.string2strArr(this.m_typeScheduler);
        ArrayList<String> schedulerTypeList = new ArrayList<String>(Arrays.asList(schdulerTypeArr));
        while (nodeNames.hasMoreElements()) {
            nodeName = nodeNames.nextElement();
            asmDisks = nodeDevices.get(nodeName);
            Trace.out((Object)"Getting storage info on node %s...", (String)nodeName);
            for (ASMDiskData asmDiskData : asmDisks) {
                String asmDiskDataDeviceString = asmDiskData.getASMDisk();
                Trace.out((Object)"originalPath[%s]", (String)asmDiskDataDeviceString);
                try {
                    Result resultScheduler;
                    storageInfo = asmDiskData.getStorageInfo();
                    if (storageInfo == null) {
                        storageInfo = new TypeFinder().getStorageInstance(asmDiskDataDeviceString, nodeName);
                    }
                    if (storageInfo == null) continue;
                    asmDiskData.setStorageInfo(storageInfo);
                    String currentScheduler = storageInfo.getDiskScheduler();
                    Trace.out((String)("IO scheduler for disk " + asmDiskDataDeviceString + " is " + currentScheduler));
                    if (!VerificationUtil.isStringGood(currentScheduler)) continue;
                    if (schedulerTypeList.contains(currentScheduler.toLowerCase())) {
                        resultScheduler = new Result(nodeName);
                        resultScheduler.setStatus(1);
                        rset.addResult(nodeName, resultScheduler);
                        continue;
                    }
                    resultScheduler = new Result(nodeName);
                    resultScheduler.setStatus(4);
                    this.setSeverity(SeverityType.IGNORABLE);
                    asmDiskData.setScheduler(currentScheduler);
                    this.addDeviceSchedulerNode(asmDiskData, nodeName, schedulerNotExpected);
                    rset.addResult(nodeName, resultScheduler);
                }
                catch (StorageException se) {
                    Trace.out((String)("StorageException getting storage type for: " + asmDiskDataDeviceString));
                    rset.addResult(nodeName, 4);
                    rset.addErrorDescription(nodeName, new ErrorDescription(se.getMessage()));
                    VerificationLogData.log(se.getMessage());
                    ReportUtil.sureprintln(se.getMessage());
                }
            }
        }
        this.displayErrorMessages(schedulerNotExpected, rset);
    }

    private void displayErrorMessages(Hashtable devicesNodes, ResultSet rset) {
        List nodesError = null;
        Enumeration keys = null;
        String errMsg = null;
        Object key = null;
        String device = null;
        ASMDiskData diskData = null;
        keys = devicesNodes.keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            if (key instanceof String) {
                device = key;
                nodesError = (List)devicesNodes.get(device);
                errMsg = s_gMsgBundle.getMessage("11977", true, (Object[])new String[]{device, VerificationUtil.strList2List(nodesError)});
            }
            if (key instanceof ASMDiskData) {
                diskData = key;
                nodesError = (List)devicesNodes.get(diskData);
                errMsg = this.m_preCRSInst ? s_gMsgBundle.getMessage("11975", true, (Object[])new String[]{diskData.getStorageInfo().getPath(), VerificationUtil.strList2List(nodesError), this.m_typeScheduler.toString().toLowerCase(), diskData.getScheduler()}) : s_gMsgBundle.getMessage("11976", true, (Object[])new String[]{diskData.getStorageInfo().getPath(), diskData.getASMDisk(), diskData.getASMDiskGroup(), VerificationUtil.strList2List(nodesError), this.m_typeScheduler.toString().toLowerCase(), diskData.getScheduler()});
            }
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            rset.addErrorDescription(errorDesc);
            VerificationLogData.log(errMsg);
            ReportUtil.printWarning(errMsg);
        }
    }

    private void addDeviceNode(String device, String node, Hashtable<String, List<String>> deviceNodes) {
        List<Object> nodes = null;
        if (deviceNodes.containsKey(device)) {
            nodes = deviceNodes.get(device);
        } else {
            nodes = new ArrayList();
            deviceNodes.put(device, nodes);
        }
        nodes.add(node);
    }

    private void addDeviceSchedulerNode(ASMDiskData deviceScheduler, String node, Hashtable<ASMDiskData, List<String>> deviceNodes) {
        List<Object> nodes = null;
        if (deviceNodes.containsKey(deviceScheduler)) {
            nodes = deviceNodes.get(deviceScheduler);
        } else {
            nodes = new ArrayList();
            deviceNodes.put(deviceScheduler, nodes);
        }
        nodes.add(node);
    }

    public void setPathList(String[] pathList) {
        this.m_processedPaths = pathList;
    }

    public void setStorageInfoMap(HashMap<String, Vector<StorageInfo>> stInfoMap) {
        this.m_storageInfoMap.putAll(stInfoMap);
    }

    public void setCvuqdiskCheckRequired(boolean isCvuqdiskCheckReq) {
        this.m_isCvuqdiskCheckRequired = isCvuqdiskCheckReq;
    }

    public HashMap<String, Vector<StorageInfo>> getStorageInfoMap() {
        return this.m_storageInfoMap;
    }

    public String[] getPathList() {
        return this.m_processedPaths;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11970", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11971", false);
    }
}

