/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.util.CommandsUtil;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCheckAuditRules
extends Task {
    private final String AUDIT_RULES_FILE_PATH = "/etc/audit/audit.rules";
    private final String m_failureFlagField = "^-f[\\s].*";
    private final String m_failureFlagPattern = "[[:space:]]*-f[[:space:]].*";
    private final String m_failureFlagParam = "-f";

    public TaskCheckAuditRules(VerificationTaskContext ctx) {
        super(ctx);
    }

    public TaskCheckAuditRules(String[] nodeList) {
        super(nodeList);
    }

    @Override
    public boolean performTask() {
        this.m_resultSet.addResult(this.m_nodeList, 1);
        try {
            Trace.out((int)1, (String)"getting root automation configuration");
            this.m_rootCreds = RootAutomationUtility.getRootExecutionInfo();
        }
        catch (VerificationException e) {
            VerificationUtil.traceAndLog(e.getMessage());
            ErrorDescription errDesc = new ErrorDescription(e.getMessage());
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            return false;
        }
        return this.checkAuditRulesForPanic();
    }

    private boolean checkAuditRulesForPanic() {
        boolean status = true;
        GlobalExecution globalExec = new GlobalExecution();
        CommandsUtil cmdUtil = new CommandsUtil();
        ResultSet locrs = new ResultSet();
        ArrayList<String> verificationWarningNodeList = new ArrayList<String>();
        String command = cmdUtil.getGrep();
        String[] env = null;
        String[] args = new String[]{"[[:space:]]*-f[[:space:]].*", "/etc/audit/audit.rules"};
        String commandWithOptions = command + " " + VerificationUtil.strArr2String(args, " ");
        try {
            Trace.out((String)("Executing command : " + commandWithOptions));
            globalExec.runGenericCmdAsRoot(this.m_nodeList, command, env, args, this.m_rootCreds, this.m_defaultTimeout, locrs);
        }
        catch (RootAutomationNotConfiguredException e) {
            VerificationUtil.traceAndLog("RootAutomationNotConfiguredException: " + e.getMessage());
            ErrorDescription errDesc = new ErrorDescription(e.getMessage());
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            return false;
        }
        this.m_resultSet.addResultSetData(locrs);
        if (!locrs.anySuccess()) {
            Trace.out((String)"root command execution failed");
            return false;
        }
        Hashtable ht = locrs.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result != null && result.getStatus() == 1) {
                String output = (String)locrs.getResult(node).getResultInfoSet().get(0);
                Trace.out((String)("Command output is : " + output));
                if (!VerificationUtil.isStringGood(output)) continue;
                boolean badAuditFileFormat = false;
                String[] outputArr = VerificationUtil.string2strArr(output, LSEP);
                if (outputArr.length > 1) {
                    badAuditFileFormat = true;
                    output = VerificationUtil.strArr2List(outputArr, LSEP);
                } else {
                    output = outputArr[0].trim();
                    int index = output.indexOf("#");
                    if (index != -1) {
                        output = output.substring(0, index).trim();
                    }
                    if (output.matches("^-f[\\s].*")) {
                        String[] failureFlagArr = output.split("\\s+");
                        if (failureFlagArr.length != 2) {
                            badAuditFileFormat = true;
                        } else if (failureFlagArr[1].trim().equals("2")) {
                            Trace.out((String)("Failure flag parameter value set to 2(=panic) on node " + node));
                            verificationWarningNodeList.add(node);
                        }
                    }
                }
                if (!badAuditFileFormat) continue;
                VerificationUtil.traceAndLog("failure flag parameter value has  invalid format on node " + node);
                String errMsg = s_gMsgBundle.getMessage("13374", true, (Object[])new String[]{"/etc/audit/audit.rules", node, output});
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                this.m_resultSet.addResult(node, 3);
                status = false;
                continue;
            }
            VerificationUtil.traceAndLog("command execution failed on node " + node);
            List<VerificationError> errList = locrs.getResult(node).getErrors();
            StringBuilder sb = new StringBuilder();
            for (VerificationError vfyErr : errList) {
                sb.append(vfyErr.getErrorMessage());
            }
            Trace.out((String)("error on node " + node + " is " + sb.toString()));
            status = false;
        }
        if (verificationWarningNodeList.size() > 0) {
            VerificationUtil.traceAndLog("Failure flag parameter value set to 2(=panic) in the audit rules");
            String warningMsg = s_gMsgBundle.getMessage("13373", true, (Object[])new String[]{"-f", "/etc/audit/audit.rules", VerificationUtil.strList2List(verificationWarningNodeList)});
            ErrorDescription errDesc = new ErrorDescription(warningMsg);
            this.m_resultSet.addResult(verificationWarningNodeList, 4);
            this.m_resultSet.addErrorDescription(verificationWarningNodeList, errDesc);
        }
        return status;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("13371", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("13372", false);
    }
}

