/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import oracle.cluster.verification.CollectionResult;
import oracle.cluster.verification.CollectionResultSet;
import oracle.cluster.verification.CollectionValueUnavailableException;
import oracle.cluster.verification.NodeResultStatus;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.CollectionGroup;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.util.ClusterwareUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCRSResourceCollection
extends Task {
    boolean m_collectOHASDResources = false;

    public TaskCRSResourceCollection(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("MODE".equals(argName)) {
                if ("OHASD".equalsIgnoreCase(argVal)) {
                    this.m_collectOHASDResources = true;
                    continue;
                }
                if (!"CRS".equalsIgnoreCase(argVal)) continue;
                this.m_collectOHASDResources = false;
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return !(!VerificationUtil.isStringGood(this.m_globalContext.getCRSHome()) && !VerificationUtil.isStringGood(this.m_globalContext.getHAHome()) || !VerificationUtil.isBaselineCollectionMode() && !VerificationUtil.isCVUResource());
    }

    public TaskCRSResourceCollection(String[] nodeList, boolean collectOHASDResources) {
        super(nodeList);
        this.m_collectOHASDResources = collectOHASDResources;
    }

    @Override
    public boolean performTask() {
        boolean retVal = true;
        Trace.out((String)"Performing CRS Resource Collection");
        String node = this.m_nodeList[0];
        CollectionResultSet<List<CollectionElement>> crsResourceCollectionRS = ClusterwareUtil.collectCRSResourceAttributes(node, this.m_collectOHASDResources);
        HashMap<String, CollectionResult<List<CollectionElement>>> t = crsResourceCollectionRS.getNodeCollectionResults();
        Set<String> e = t.keySet();
        CollectionResult<List<CollectionElement>> nodeResult = t.get(node);
        this.m_resultSet.addResult(node, nodeResult.getNodeResultStatus().getResultStatus());
        if (NodeResultStatus.SUCCESSFUL.equals((Object)nodeResult.getNodeResultStatus())) {
            try {
                List<CollectionElement> crsResourceCEList = nodeResult.getCollectedValue();
                this.m_resultSet.addCollectionElements(crsResourceCEList);
            }
            catch (CollectionValueUnavailableException e1) {
                Trace.out(e);
            }
        }
        return retVal;
    }

    @Override
    public CollectionGroup getCollectionGroup() {
        if (this.m_collectOHASDResources) {
            return CollectionGroup.OHASD_MODEL_COLLECTION;
        }
        return CollectionGroup.CRS_MODEL_COLLECTION;
    }

    @Override
    public String getTaskID() {
        if (this.m_collectOHASDResources) {
            return "OHASD_MODEL_COLLECTION";
        }
        return "CRS_MODEL_COLLECTION";
    }

    @Override
    public String getDefaultElementName() {
        if (this.m_collectOHASDResources) {
            return s_gMsgBundle.getMessage("11198", false);
        }
        return s_gMsgBundle.getMessage("11195", false);
    }

    @Override
    public String getDefaultDescription() {
        if (this.m_collectOHASDResources) {
            return s_gMsgBundle.getMessage("11199", false);
        }
        return s_gMsgBundle.getMessage("11196", false);
    }
}

