/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.ParamPreReqCFSSetup;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskCFSIntegrity;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCFSIntegrity
extends Task {
    protected String m_fileSystem;

    public TaskCFSIntegrity(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ParamPreReq param = this.m_globalContext.getParamPrereq();
        if (param instanceof ParamPreReqCFSSetup) {
            this.m_fileSystem = ((ParamPreReqCFSSetup)param).getFileSystem();
        }
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("PATH".equals(argName)) {
                this.m_fileSystem = argVal;
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        VerificationType vType = this.m_globalContext.getVerificationType();
        switch (vType) {
            case PREREQ_DB_INST: {
                boolean isOracleHomeOnOCFS = Boolean.valueOf(CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME_ON_OCFS));
                if (VerificationUtil.isStringGood(this.m_fileSystem)) {
                    if (isOracleHomeOnOCFS) {
                        VerificationUtil.traceAndLog("The current scenario has the Oracle home on OCFS, Adding CFS integrity check");
                    } else {
                        VerificationUtil.traceAndLog("The current scenario does not have the Oracle home on OCFS, hence not adding CFS integrity  check");
                    }
                }
                return isOracleHomeOnOCFS && VerificationUtil.isStringGood(this.m_fileSystem);
            }
        }
        return VerificationUtil.isStringGood(this.m_fileSystem);
    }

    public TaskCFSIntegrity(String[] nodeList, String fileSystem) {
        this(nodeList, fileSystem, null, 1);
    }

    public TaskCFSIntegrity(String[] nodeList, String fileSystem, MultiTaskHandler multiTaskHandler) {
        this(nodeList, fileSystem, multiTaskHandler, 1);
    }

    public TaskCFSIntegrity(String[] nodeList, String fileSystem, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.m_fileSystem = fileSystem;
    }

    public void setFileSystem(String fileSystem) {
        this.m_fileSystem = fileSystem;
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing CFS Integrity verification task... ");
        sTaskCFSIntegrity sTask = new sTaskCFSIntegrity(this);
        boolean status = sTask.performCheck();
        return status;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4422", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4473", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        sb.append("\n    FileSystem: " + this.m_fileSystem);
        return sb.toString();
    }
}

