/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.HashMap;
import java.util.Hashtable;
import oracle.cluster.verification.CollectionResult;
import oracle.cluster.verification.CollectionResultSet;
import oracle.cluster.verification.CollectionValueUnavailableException;
import oracle.cluster.verification.NodeResultStatus;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.constraints.CDMConstraintTypes;
import oracle.cluster.verification.util.CollectionGroup;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.util.ClusterwareUtil;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.framework.util.sOSCollectionsCommandHandler;

public class TaskAllRLimitsByPidCollection
extends Task {
    private static String ARG_RUNEXE = "-getallrlimitsbypid";

    public TaskAllRLimitsByPidCollection(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return RootAutomationUtility.isRootExecutionConfigured() && VerificationUtil.isBaselineCollectionMode();
    }

    @Override
    protected boolean performTask() {
        Trace.out((String)"ENTRY");
        CollectionResultSet<String> colRes = ClusterwareUtil.getCRSDProcessID(this.m_nodeList);
        if (colRes.getOverallStatus() != OverallStatus.SUCCESSFUL) {
            this.m_resultSet.addResult(this.m_nodeList, 3);
            for (VerificationError error : colRes.getErrors()) {
                this.m_resultSet.addErrorDescription((ErrorDescription)error);
            }
            return true;
        }
        GlobalExecution globalExec = new GlobalExecution();
        HashMap<String, CollectionResult<String>> t = colRes.getNodeCollectionResults();
        String exectaskCommand = VerificationUtil.getCVUSubDirPath() + VerificationUtil.FSEP + VerificationUtil.getCmd4RemExec();
        for (String node : t.keySet()) {
            CollectionResult<String> result = t.get(node);
            this.m_resultSet.addResult(node, result.getNodeResultStatus().getResultStatus());
            if (result.getNodeResultStatus() != NodeResultStatus.SUCCESSFUL) {
                for (VerificationError error : colRes.getErrors()) {
                    this.m_resultSet.addResult(node, result.getNodeResultStatus().getResultStatus());
                    this.m_resultSet.addErrorDescription(node, (ErrorDescription)error);
                }
                continue;
            }
            try {
                this.m_resultSet.addResult(node, 1);
                String pid = result.getCollectedValue();
                ResultSet getEnvRS = new ResultSet();
                globalExec.runGenericCmdAsRoot(this.m_nodeList, exectaskCommand, null, new String[]{ARG_RUNEXE, pid}, this.m_rootCreds, this.m_defaultTimeout, getEnvRS);
                String output = (String)getEnvRS.getResult(node).getResultInfoSet().get(0);
                CollectionResult<Hashtable<String, Hashtable<String, String>>> colResult = sOSCollectionsCommandHandler.parseAllRLimitsByPid(node, output);
                if (colResult.getNodeResultStatus() != NodeResultStatus.SUCCESSFUL) {
                    for (VerificationError error : colRes.getErrors()) {
                        this.m_resultSet.addErrorDescription(node, (ErrorDescription)error);
                    }
                    continue;
                }
                try {
                    for (String resourceName : colResult.getCollectedValue().keySet()) {
                        Hashtable<String, String> limits = colResult.getCollectedValue().get(resourceName);
                        CollectionElement limitsCE = new CollectionElement(resourceName, null, null, null, resourceName, 1);
                        CollectionElement softLimitsCE = new CollectionElement(s_msgBundle.getMessage("1068", false), limits.get(CDMConstraintTypes.SOFTLIMIT), null, null, resourceName, 1);
                        CollectionElement hardLimitsCE = new CollectionElement(s_msgBundle.getMessage("1067", false), limits.get(CDMConstraintTypes.HARDLIMIT), null, null, resourceName, 1);
                        limitsCE.addChild(softLimitsCE);
                        limitsCE.addChild(hardLimitsCE);
                        this.m_resultSet.addCollectionElement(node, limitsCE);
                    }
                }
                catch (CollectionValueUnavailableException e1) {
                    this.m_resultSet.addResult(node, 3);
                    this.m_resultSet.addErrorDescription(node, new ErrorDescription(e1.getMessage()));
                }
            }
            catch (CollectionValueUnavailableException e) {
                this.m_resultSet.addResult(node, 3);
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(e.getMessage()));
            }
            catch (RootAutomationNotConfiguredException e) {
                this.m_resultSet.addResult(node, 3);
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(e.getMessage()));
            }
        }
        return true;
    }

    @Override
    public CollectionGroup getCollectionGroup() {
        return CollectionGroup.OS_RESOURCE_LIMITS_FOR_CRSD;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("13112", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("13113", false);
    }
}

