/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.KFODUtil;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.SubtasksNotCompleteException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.util.VerificationType;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskASMFilterDriverChecks;
import oracle.ops.verification.framework.engine.task.TaskNodeConnectivity;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkDataDiscovery;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.ASMDiskGroup;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.ASMUtils;
import oracle.ops.verification.framework.util.CVUHelperException;
import oracle.ops.verification.framework.util.CVUHelperExec;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.helper.CVUHelperConstants;

public class TaskASMIntegrity
extends Task
implements VerificationConstants,
CVUHelperConstants {
    private static final String TASK_TYPE = "ASM Integrity";
    private static final String SQLNET_FILENAME = "sqlnet.ora";
    private static final Object AUTH_SERVICES_KEY = "sqlnet.authentication_services";
    private static final String EXPECTED_AUTH_PATTERN = ".*all.*|.*beq.*";
    private static final String EXPECTED_AUTH_PATTERN_NT = ".*all.*|.*nts.*";
    private boolean m_isPreCheck = false;
    private String[] m_allClusterNodes = null;
    private String[] m_allASMInstanceNodes = null;
    private HashMap<String, Set<NetworkInfo>> m_globalNodeNetworksMap = null;
    private HashMap<String, Set<NetworkInfo>> m_nodeNetworksMapForAsmNetworks = null;
    private Set<NetworkInfo> m_asmNetworksToConsider = new HashSet<NetworkInfo>();
    private String[] m_dgList;
    private boolean m_DiskGroupCheck = false;
    private VerificationType m_vtype;
    private boolean m_OCRonASM = false;
    private String CHECK_IOSERVER_HELPER_ARG = "-getIOServerNodes";
    private String CLUSTER_DATABASE_PARAM = "cluster_database";

    public TaskASMIntegrity(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        this.m_vtype = this.m_globalContext.getVerificationType();
        switch (this.m_vtype) {
            case COMPONENT_ACFS_INTEGRITY: 
            case COMPONENT_ASM_INTEGRITY: {
                if (VerificationUtil.isOPC() || VerificationUtil.isODALiteEnv()) break;
                try {
                    this.setNetworkInfoFromOifcfg();
                }
                catch (CVUException e) {
                    Trace.out((String)("Exception occured while setting network info from oifcfg. msg=" + e.getMessage()));
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    Trace.out((Exception)e);
                }
                break;
            }
            default: {
                if (this.m_globalContext.isUpgrade()) {
                    Trace.out((String)"Current mode is upgrade mode. Setting nodelist accordingly.");
                    this.setNodeList(new String[]{VerificationUtil.getLocalHostName()});
                }
                this.setPreCheck(this.m_globalContext.isPreCRS());
                this.setOCRonASM(this.m_globalContext.isOCROrVdiskOnASM());
                this.m_dgList = this.m_globalContext.getASMDiskGroups();
                try {
                    ResultSet networksResultSet = new ResultSet();
                    this.m_globalNodeNetworksMap = NetworkDataDiscovery.getNodeNetworksMap(this.m_nodeList, networksResultSet);
                    Set<NetworkInfo> clusterNetworks = NetworkUtility.getNetworkInfo(networksResultSet);
                    if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
                        Trace.out((String)"Could not discover the network details successfully during ASM Integrity checks");
                        NetworkUtility.reportResultSet(networksResultSet, this.m_resultSet, true);
                        return;
                    }
                    Trace.out((String)"Found cluster networks ");
                    VerificationUtil.logNetworkInterfaces(clusterNetworks);
                    if (!NetworkUtility.isNetworksSetGood(clusterNetworks) || !NetworkDataDiscovery.hasNetworkTypeInClusterNetworks(clusterNetworks, NetworkConstants.NetworkType.ASM.getValue())) break;
                    Trace.out((String)"Found NETTYPE_ASM in network information");
                    clusterNetworks = NetworkDataDiscovery.getClusterNetworksByType(clusterNetworks, NetworkConstants.NetworkType.ASM);
                    this.setNetworksToConsider(clusterNetworks);
                    break;
                }
                catch (CVUException ve) {
                    String errorMessage = ve.getMessage();
                    Trace.out((String)errorMessage);
                    ReportUtil.printError(errorMessage);
                    VerificationUtil.traceAndLog("Exception occured while getting network info. msg=" + errorMessage);
                    return;
                }
            }
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (VerificationType.PREREQ_CRS_INST.equals((Object)this.m_globalContext.getVerificationType()) && VerificationUtil.isBaselineCollectionMode()) {
            return false;
        }
        if (this.m_vtype != null) {
            switch (this.m_vtype) {
                case PREREQ_CRS_INST: 
                case BESTPRACTICE_PRE_CRS_INST: 
                case PREREQ_DB_CONFIG: 
                case POSTREQ_HWOS_SETUP: {
                    return this.isASMIntegrityRequired();
                }
                case POSTREQ_CRS_INST: 
                case BESTPRACTICE_POSTREQ_CRS_INST: {
                    return this.m_OCRonASM ? true : this.isASMIntegrityRequired();
                }
                case PREREQ_DB_INST: {
                    boolean isUSMChecks = false;
                    boolean isASMChecks = false;
                    String isASMChecksVal = CVUVariables.getValue(CVUVariableConstants.ASM_DEVICE_CHECKS_FLAG);
                    String isUSMChecksVal = CVUVariables.getValue(CVUVariableConstants.USM_DEVICE_CHECKS_FLAG);
                    if (VerificationUtil.isStringGood(isASMChecksVal)) {
                        isASMChecks = Boolean.valueOf(isASMChecksVal);
                    }
                    if (VerificationUtil.isStringGood(isUSMChecksVal)) {
                        isUSMChecks = Boolean.valueOf(isUSMChecksVal);
                    }
                    return isUSMChecks || isASMChecks;
                }
                case PREREQ_NODE_ADD: {
                    String actCRSVer = VerificationUtil.getCRSActiveVersion();
                    if (!VerificationUtil.isVersionPre(actCRSVer, "12.1") && !CVUHelperUtil.isASMLocal()) {
                        return true;
                    }
                    VerificationUtil.traceAndLog("ASM integrity check skipped as the CRS version is either pre 12.1 or it is a Local ASM");
                    return false;
                }
                case COMPONENT_ACFS_INTEGRITY: 
                case COMPONENT_ASM_INTEGRITY: {
                    Trace.out((String)"ASM checks requested");
                    return true;
                }
                case POSTREQ_USM_CONFIG: {
                    return true;
                }
            }
        } else {
            VerificationUtil.traceAndLog("Verification Type is unknown, returning false");
        }
        return false;
    }

    private boolean isASMIntegrityRequired() {
        String reqRel = this.m_globalContext.getRequestedRelease();
        if (this.m_isPreCheck && reqRel != null && VerificationUtil.isVersionPre(reqRel, "12.1")) {
            Trace.out((String)"pre 12.1 no asm integrity in pre");
            return false;
        }
        String asmCred = CVUVariables.getValue(CVUVariableConstants.ASM_CLIENTDATA);
        if (this.m_isPreCheck && asmCred != null && asmCred.length() != 0) {
            Trace.out((String)"asm credentials file specified");
            return true;
        }
        if (this.isASMNetworkExist()) {
            Trace.out((String)"asm network has been specified");
            return true;
        }
        Trace.out((String)"no asm config specified for check");
        return false;
    }

    public TaskASMIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskASMIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskASMIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    public void setNetworksToConsider(Set<NetworkInfo> networksToConsider) {
        ResultSet networksResultSet = new ResultSet();
        this.m_globalNodeNetworksMap = NetworkDataDiscovery.getNodeNetworksMap(this.m_nodeList, networksResultSet);
        if (!networksResultSet.anyFailure() && NetworkUtility.isNetworksSetGood(networksToConsider)) {
            this.m_asmNetworksToConsider = networksToConsider;
            VerificationUtil.logNetworkInterfaces(networksToConsider);
            this.m_nodeNetworksMapForAsmNetworks = NetworkDataDiscovery.getMatchingNodeNetworksMapOnNodes(this.m_globalNodeNetworksMap, this.m_asmNetworksToConsider, this.m_nodeList);
        } else if (networksResultSet.anyFailure()) {
            Trace.out((String)"errors occured while getting matching networks info for ASM networks");
            NetworkUtility.reportResultSet(networksResultSet, null, false);
        }
    }

    @Override
    public boolean performTask() {
        boolean doUploadRS;
        ResultSet locrs = new ResultSet();
        ResultSet networksResultSet = new ResultSet();
        if (NetworkUtility.isNetworksSetGood(this.m_asmNetworksToConsider)) {
            List<String> asmInterfaceNames = NetworkDataDiscovery.getClusterNetworkNames(this.m_asmNetworksToConsider);
            Trace.out((String)("Performing ASM Integrity verification task..." + LSEP + "m_isPreCheck=" + this.m_isPreCheck + ": m_asmInterfaceArr='" + VerificationUtil.strList2List(asmInterfaceNames) + "'"));
            Trace.out((String)"Check network existence on all nodes");
            if (this.m_nodeList == null || this.m_nodeList.length == 0) {
                return false;
            }
            HashSet<String> validNodeList = new HashSet<String>();
            boolean hasNetworks = NetworkDataDiscovery.checkForNetworkExistenceOnAllNodes(null, this.m_asmNetworksToConsider, this.m_nodeList, validNodeList, this.m_resultSet, TASK_TYPE);
            if (!hasNetworks) {
                return false;
            }
        }
        ReportUtil.sureprintln(s_msgBundle.getMessage("4391", false) + LSEP);
        String softwareVersion = null;
        if (!this.m_isPreCheck) {
            softwareVersion = VerificationUtil.getCRSSoftwareVersion(this.m_nodeList[0]);
        } else {
            String requestRel = VerificationUtil.getRequestedRelease();
            Trace.out((String)("requestRel=" + requestRel));
            softwareVersion = "10gR1".equalsIgnoreCase(requestRel) || "10.1".equalsIgnoreCase(requestRel) ? "10.1" : ("10gR2".equalsIgnoreCase(requestRel) || "10.2".equalsIgnoreCase(requestRel) ? "10.2" : ("11gR1".equalsIgnoreCase(requestRel) || "11.1".equalsIgnoreCase(requestRel) ? "11.1" : ("11gR2".equalsIgnoreCase(requestRel) || "11.2".equalsIgnoreCase(requestRel) ? "11.2" : (requestRel == null ? "12.2" : requestRel))));
        }
        Trace.out((String)("software version obtained is :" + softwareVersion));
        if (VerificationUtil.isVersionPost(softwareVersion, "12")) {
            if (!VerificationUtil.isOPC() && !VerificationUtil.isODALiteEnv()) {
                doUploadRS = this.performASMNetworkValidation(locrs);
                if (doUploadRS) {
                    Trace.out((String)"uploading ASM network validation resultset");
                    this.m_resultSet.uploadResultSet(locrs);
                }
                locrs.clear();
            } else {
                VerificationUtil.traceAndLog("Skipped asm network validation check  in OPC/ODALite env");
            }
            doUploadRS = this.performCredFileValidation(locrs);
            if (doUploadRS) {
                Trace.out((String)"uploading cred file validation resultset");
                this.m_resultSet.addResultSetData(locrs);
            }
            locrs.clear();
        }
        if (!this.m_isPreCheck || this.m_globalContext.isRollingUpgrade()) {
            doUploadRS = this.performASMInstanceCheck(softwareVersion, locrs);
            if (doUploadRS) {
                Trace.out((String)"uploading asm instance check resultset");
                this.m_resultSet.addResultSetData(locrs);
            }
            if (!VerificationUtil.isHAConfigured() && VerificationUtil.isASMRunning()) {
                String errMsg;
                Result result = new Result(m_localNode);
                String clusterDatabaseParam = CVUHelperUtil.getASMParameter(this.CLUSTER_DATABASE_PARAM, result);
                if (!VerificationUtil.isStringGood(clusterDatabaseParam)) {
                    errMsg = s_gMsgBundle.getMessage("6085", true, (Object[])new String[]{this.CLUSTER_DATABASE_PARAM, m_localNode});
                    String errorString = VerificationUtil.errorCollection2String(result.getErrors());
                    Trace.out((String)("Failed to obtain the ASM parameter cluster_database value. Error is " + errorString));
                    if (VerificationUtil.isStringGood(errorString)) {
                        errMsg = errMsg + LSEP + errorString;
                    }
                    this.m_resultSet.addResult(m_localNode, 2);
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                } else if (clusterDatabaseParam.equalsIgnoreCase("FALSE")) {
                    Trace.out((String)("Parameter cluster_database value found to be " + clusterDatabaseParam));
                    errMsg = s_gMsgBundle.getMessage("6084", true);
                    this.m_resultSet.addResult(m_localNode, 3);
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                }
                ResultSet authRs = this.performAuthServicesCheck();
                if (authRs.anyFailure()) {
                    Trace.out((String)"Found failures during auth services check. adding authentication services check resultset");
                    this.m_resultSet.addResultSetData(authRs);
                }
            }
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4392", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4393", false));
        return false;
    }

    private boolean performASMNetworkValidation(ResultSet locrs) {
        String asmPresence = CVUVariables.getValue(CVUVariableConstants.ASMCONFIG);
        if (this.m_isPreCheck && "LOCAL".equalsIgnoreCase(asmPresence)) {
            Trace.out((String)"pre crsisnt and cluster is legacy cluster");
            return false;
        }
        if (!this.m_isPreCheck && CVUHelperUtil.isASMLocal()) {
            Trace.out((String)"post crsinst legacy cluster no network validation required");
            return false;
        }
        HashSet<String> asmNetworksList = new HashSet<String>();
        if (NetworkUtility.isNetworksMapGood(this.m_nodeNetworksMapForAsmNetworks)) {
            for (String node : this.m_nodeNetworksMapForAsmNetworks.keySet()) {
                asmNetworksList.addAll(NetworkDataDiscovery.getClusterNetworkNames(this.m_nodeNetworksMapForAsmNetworks.get(node)));
            }
        }
        if (asmNetworksList == null || asmNetworksList.size() == 0) {
            String msg;
            Trace.out((String)"ASM network not found in INTERCONNECT_LIST/OIFCFG");
            if (this.m_isPreCheck) {
                if (CVUVariables.getValue(CVUVariableConstants.INTERCONNECT_LIST) == null) {
                    Trace.out((String)"interconnect list not specified");
                    return false;
                }
                Trace.out((String)"interconnect list has been specified");
                msg = m_isCLImode ? s_gMsgBundle.getMessage("1611", true) : s_gMsgBundle.getMessage("1600", true);
            } else {
                msg = s_gMsgBundle.getMessage("1601", true);
            }
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            return true;
        }
        Trace.out((String)"starting ASM network validation");
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("1606", false));
        TaskNodeConnectivity taskNodeCon = new TaskNodeConnectivity(this.m_nodeList);
        taskNodeCon.setTaskType(0);
        taskNodeCon.setNetworksToConsider(this.m_asmNetworksToConsider);
        this.addChildTask(taskNodeCon);
        try {
            taskNodeCon.verify();
        }
        catch (SubtasksNotCompleteException e) {
            Trace.out((Exception)e);
            locrs.addResult(this.m_nodeList, 2);
            locrs.addErrorDescription(this.m_nodeList, new ErrorDescription(e.getMessage()));
            ReportUtil.sureprintln(e.getMessage());
            return true;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            locrs.addResult(this.m_nodeList, 2);
            locrs.addErrorDescription(this.m_nodeList, new ErrorDescription(e.getMessage()));
            ReportUtil.sureprintln(e.getMessage());
            return true;
        }
        locrs.uploadResultSet(taskNodeCon.getResultSet());
        if (!locrs.allSuccess()) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1608", true));
        } else {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1607", false));
        }
        return true;
    }

    private boolean performCredFileValidation(ResultSet locrs) {
        Trace.out((String)"ENTRY");
        if (!this.m_isPreCheck && !CVUHelperUtil.isASMFar()) {
            Trace.out((String)"no credentials to validate as it is not a ASM far cluster");
            return false;
        }
        String credFile = null;
        if (this.m_isPreCheck) {
            credFile = CVUVariables.getValue(CVUVariableConstants.ASM_CLIENTDATA);
            if (credFile == null || credFile.length() == 0) {
                Trace.out((String)"asm cred file not specified pre crsinst");
                return false;
            }
            if (!(m_isAPImode || m_isFromRuncluvfy || Utils.isDevelopmentEnv())) {
                Trace.out((String)"kfod support is not available in OTN. Do not perform the check");
                return false;
            }
            Trace.out((String)("cred file is: " + credFile));
        }
        Throwable excpt = null;
        if (this.m_isPreCheck) {
            ReportUtil.println(s_gMsgBundle.getMessage("1602", false, (Object[])new String[]{credFile}));
        } else {
            ReportUtil.println(s_gMsgBundle.getMessage("1603", false, (Object[])new String[]{credFile}));
        }
        try {
            String kfodLocation = VerificationUtil.getKFODLocation(m_localNode, this.m_isPreCheck);
            Trace.out((String)("running kfod from: " + kfodLocation));
            KFODUtil kfodUtil = null;
            kfodUtil = this.m_isPreCheck && (m_isAPImode || m_isFromRuncluvfy) ? new KFODUtil(kfodLocation, true) : new KFODUtil(kfodLocation, false);
            if (this.m_isPreCheck) {
                Trace.out((String)"calling kfod before clusterware install");
                kfodUtil.validateASMCredentials(credFile);
            } else {
                Trace.out((String)"calling kfod after clusterware install");
                kfodUtil.validateASMCredentials();
            }
        }
        catch (CmdToolUtilException e) {
            excpt = e;
        }
        catch (VerificationException e) {
            excpt = e;
        }
        if (excpt != null) {
            String errMsg = null;
            errMsg = this.m_isPreCheck ? s_gMsgBundle.getMessage("1604", true, (Object[])new String[]{credFile}) : s_gMsgBundle.getMessage("1605", true);
            errMsg = errMsg + LSEP + excpt.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            locrs.addResult(this.m_nodeList, 2);
            locrs.addErrorDescription(errDesc);
            ReportUtil.sureprintln(errMsg);
            return true;
        }
        locrs.addResult(this.m_nodeList, 1);
        if (this.m_isPreCheck) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1609", false, (Object[])new String[]{credFile}));
        } else {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1610", false));
        }
        return true;
    }

    private boolean performASMInstanceCheck(String softwareVersion, ResultSet locrs) {
        Object errDesc = null;
        try {
            Trace.out((int)5, (String)"get the cluster nodes");
            this.m_allClusterNodes = VerificationUtil.getNodelistFromOlsnodesWithException();
        }
        catch (NodelistNotFoundException e) {
            Trace.out((String)("Failed to get the cluster nodes :: " + e.getMessage()));
            String exceptionErrMsg = s_gMsgBundle.getMessage("1008", true, (Object[])new String[]{VerificationUtil.strArr2String(this.m_nodeList, ",")}) + LSEP + e.getMessage();
            ReportUtil.sureprintln(exceptionErrMsg);
            locrs.addResult(this.m_nodeList, 2);
            locrs.addErrorDescription(this.m_nodeList, new ErrorDescription(exceptionErrMsg));
            return true;
        }
        Trace.out((String)("m_allClusterNodes::" + VerificationUtil.strArr2List(this.m_allClusterNodes)));
        if (!this.m_nodeMgr.isBigCluster()) {
            this.m_allASMInstanceNodes = this.m_allClusterNodes;
        } else {
            try {
                Trace.out((int)5, (String)"get active hub nodes");
                this.m_allASMInstanceNodes = this.m_nodeMgr.getActiveHubNodes();
            }
            catch (NoSuchNodesException e) {
                Trace.out((String)("Failed to get the active cluster nodes :: " + e.getMessage()));
                String exceptionErrMsg = s_gMsgBundle.getMessage("1008", true, (Object[])new String[]{VerificationUtil.strArr2String(this.m_nodeList, ",")}) + LSEP + e.getMessage();
                ReportUtil.sureprintln(exceptionErrMsg);
                locrs.addResult(this.m_nodeList, 2);
                locrs.addErrorDescription(this.m_nodeList, new ErrorDescription(exceptionErrMsg));
                return true;
            }
        }
        Trace.out((String)("m_allASMInstanceNodes::" + VerificationUtil.strArr2List(this.m_allASMInstanceNodes)));
        ArrayList<String> runningASMNodes = new ArrayList<String>();
        ArrayList<String> failedASMNodes = new ArrayList<String>();
        boolean isPre12c = VerificationUtil.isVersionPre(softwareVersion, "12");
        if (isPre12c || !CVUHelperUtil.isASMFar()) {
            Trace.out((String)"Starting ASM Running check...");
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5107", false));
            ASMDiskGroupsUtil asmdg = new ASMDiskGroupsUtil();
            try {
                Trace.out((int)5, (String)"determine the nodes on which ASM is running");
                asmdg.checkASMRunning(this.m_allASMInstanceNodes, runningASMNodes, failedASMNodes);
            }
            catch (ASMDiskGroupsUtilException e) {
                String exceptionErrMsg = s_gMsgBundle.getMessage("1008", true, (Object[])new String[]{VerificationUtil.strArr2String(this.m_nodeList, ",")}) + LSEP + e.getMessage();
                ReportUtil.sureprintln(exceptionErrMsg);
                locrs.addResult(this.m_nodeList, 2);
                locrs.addErrorDescription(this.m_nodeList, new ErrorDescription(exceptionErrMsg));
                for (String node : this.m_nodeList) {
                    failedASMNodes.add(node);
                }
                Trace.out((String)("Error determining ASM running nodes " + e));
            }
            if (isPre12c || CVUHelperUtil.isASMLocal()) {
                ArrayList<String> runningASMNodesOriginalList = new ArrayList<String>();
                ArrayList<String> failedASMNodesOriginalList = new ArrayList<String>();
                runningASMNodesOriginalList.addAll(runningASMNodes);
                runningASMNodesOriginalList.retainAll(Arrays.asList(this.m_nodeList));
                failedASMNodesOriginalList.addAll(failedASMNodes);
                failedASMNodesOriginalList.retainAll(Arrays.asList(this.m_nodeList));
                for (String node : runningASMNodesOriginalList) {
                    locrs.addResult(node, 1);
                }
                for (String node : failedASMNodesOriginalList) {
                    locrs.addResult(node, 3);
                }
            } else if (CVUHelperUtil.isASMNear()) {
                int expectedASMInstCount;
                int asmCount = CVUHelperUtil.getASMCount();
                if (asmCount == -1) {
                    expectedASMInstCount = this.m_allASMInstanceNodes.length;
                } else {
                    int n = expectedASMInstCount = asmCount > this.m_allASMInstanceNodes.length ? this.m_allASMInstanceNodes.length : asmCount;
                }
                if (runningASMNodes.size() >= expectedASMInstCount) {
                    locrs.addResult(this.m_nodeList, 1);
                } else {
                    locrs.addResult(this.m_nodeList, 3);
                }
            }
            locrs.setStatus();
            this.reportASMRunningStatus(runningASMNodes, failedASMNodes, locrs, isPre12c);
            Trace.out((int)5, (String)"ASM Running check on all nodes completed.");
            if (runningASMNodes.isEmpty()) {
                return true;
            }
        }
        if (!this.m_DiskGroupCheck) {
            if (this.m_vtype == VerificationType.PREREQ_DB_INST) {
                this.checkDiskGroupsforDB();
            } else {
                this.checkDiskGroupsASM();
            }
        }
        return true;
    }

    private void performIOServerExistanceCheck(List<String> runningASMNodes, ResultSet locrs) {
        String errMsg;
        String[] args = new String[]{this.CHECK_IOSERVER_HELPER_ARG};
        String[] env = null;
        CVUHelperExec helperExec = null;
        Trace.out((String)"executing cvuhelper to get ioserver nodes");
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            String errMsg2 = s_gMsgBundle.getMessage("6057", true, (Object[])new String[]{"cvuhelper " + this.CHECK_IOSERVER_HELPER_ARG}) + LSEP + e.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg2);
            locrs.addResult(this.m_nodeList, 2);
            locrs.addErrorDescription(errDesc);
            VerificationLogData.logError("cvuhelper -getIOServerNodes command failed" + e.getMessage());
            ReportUtil.sureprintln(errMsg2);
            return;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            String errMsg3 = s_gMsgBundle.getMessage("6057", true, (Object[])new String[]{helperExec.getCommandString()}) + LSEP + helperExec.getErrorString();
            locrs.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(errMsg3);
            locrs.addErrorDescription(errDesc);
            VerificationLogData.logError("cvuhelper -getIOServerNodes command failed" + helperExec.getErrorString());
            ReportUtil.sureprintln(errMsg3);
            return;
        }
        String[] output = helperExec.getOutput();
        int iosCount = 0;
        String[] iosRunningNodes = new String[]{};
        String[] errorArray = null;
        String[] iosInfoArr = null;
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            VerificationLogData.log(outputStr);
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"failed to get ioserver count and nodes");
                errorArray = CVUHelperUtil.fetchError(output);
                String errMsg4 = VerificationUtil.strArr2String(errorArray, LSEP);
                ErrorDescription errDesc = new ErrorDescription(errMsg4);
                locrs.addResult(this.m_nodeList, 3);
                locrs.addErrorDescription(errDesc);
                ReportUtil.sureprintln(errMsg4);
                VerificationLogData.logError("cvuhelper -getIOServerNodes command failed" + errMsg4);
                return;
            }
        } else {
            Trace.out((String)"cvuhelper failed to produce output");
            String errMsg5 = s_gMsgBundle.getMessage("6057", true, (Object[])new String[]{helperExec.getCommandString()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg5 = errMsg5 + LSEP + helperExec.getErrorString();
            }
            locrs.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg5);
            locrs.addErrorDescription(errDesc);
            ReportUtil.sureprintln(errMsg5);
            VerificationLogData.logError("cvuhelper -getIOServerNodes command failed" + errStr);
            return;
        }
        Trace.out((String)"fetching successful nodes");
        iosInfoArr = CVUHelperUtil.fetchOutput(output);
        String iosCountStr = VerificationUtil.fetchTextByTags(iosInfoArr[0], "<IOS_COUNT>", "</IOS_COUNT>");
        if (iosCountStr != null && iosCountStr.length() > 0) {
            Trace.out((String)("io server count is " + iosCountStr));
            iosCount = Integer.parseInt(iosCountStr);
        }
        if (iosCount == 0) {
            locrs.addResult(this.m_nodeList, 1);
            return;
        }
        int expectedIOSCount = iosCount == -1 ? this.m_allASMInstanceNodes.length : (iosCount > this.m_allASMInstanceNodes.length ? this.m_allASMInstanceNodes.length : iosCount);
        ReportUtil.println(s_gMsgBundle.getMessage("6060", false));
        String iosOutputNodeStr = VerificationUtil.fetchTextByTags(iosInfoArr[0], "<IOS_NODES>", "</IOS_NODES>");
        if (iosOutputNodeStr != null && iosOutputNodeStr.length() != 0) {
            iosRunningNodes = VerificationUtil.string2strArr(iosOutputNodeStr);
            Trace.out((String)("ioServers are running on " + iosRunningNodes.length + " nodes and they are" + iosOutputNodeStr));
        } else {
            Trace.out((String)"No running ioservers are available");
        }
        Trace.out((String)("iosCount=" + iosCount + "; m_nodeList.length=" + this.m_nodeList.length));
        Trace.out((String)("expectedIOSCount=" + expectedIOSCount));
        if (expectedIOSCount > iosRunningNodes.length) {
            errMsg = s_gMsgBundle.getMessage("6059", true, (Object[])new String[]{Integer.toString(expectedIOSCount), Integer.toString(iosRunningNodes.length)});
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            locrs.addResult(this.m_nodeList, 4);
            locrs.addErrorDescription(errDesc);
            ReportUtil.printWarning(errMsg);
            VerificationLogData.logError("ioserver running on insufficient nodes actual =" + iosRunningNodes.length + " required=" + expectedIOSCount);
        } else {
            locrs.addResult(this.m_nodeList, 1);
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("6058", false));
        }
        if (CVUHelperUtil.isASMFar()) {
            Trace.out((String)"far asm so no checking of io server running on asm nodes");
            return;
        }
        ArrayList<String> iosWithoutASM = new ArrayList<String>();
        for (int i = 0; i < iosRunningNodes.length; ++i) {
            if (runningASMNodes.contains(iosRunningNodes[i])) continue;
            VerificationUtil.traceAndLog("ios running on ASM not running on node " + iosRunningNodes[i]);
            iosWithoutASM.add(iosRunningNodes[i]);
        }
        if (iosWithoutASM.size() > 0) {
            errMsg = s_gMsgBundle.getMessage("6061", true, (Object[])new String[]{VerificationUtil.strList2List(iosWithoutASM)});
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            locrs.addResult(this.m_nodeList, 4);
            locrs.addErrorDescription(errDesc);
            ReportUtil.printWarning(errMsg);
        }
        Trace.out((int)2, (String)"Exit");
    }

    private void reportASMRunningStatus(List<String> runningASMNodes, List<String> failedASMNodes, ResultSet locrs, boolean isPre12c) {
        Trace.out((int)2, (String)"Entry");
        Trace.out((int)5, (String)"Reporting ASM Running status for the nodes");
        Trace.out((int)5, (String)("No of nodes running ASM = " + runningASMNodes.size()));
        Trace.out((int)5, (String)("No of nodes NOT running ASM = " + failedASMNodes.size()));
        if (runningASMNodes.size() == this.m_allASMInstanceNodes.length) {
            Trace.out((int)5, (String)"ASM is running on all cluster nodes.");
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5108", false));
        } else if (failedASMNodes.size() == this.m_allASMInstanceNodes.length) {
            Trace.out((int)5, (String)"ASM is NOT running on all cluster nodes.");
            String errMsg = LSEP + s_msgBundle.getMessage("5109", true);
            ReportUtil.sureprintln(errMsg);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(errDesc);
        } else if (!isPre12c && CVUHelperUtil.isASMNear()) {
            int expectedASMInstCount;
            int asmCount = CVUHelperUtil.getASMCount();
            if (asmCount == -1) {
                expectedASMInstCount = this.m_allASMInstanceNodes.length;
            } else {
                int n = expectedASMInstCount = asmCount > this.m_allASMInstanceNodes.length ? this.m_allASMInstanceNodes.length : asmCount;
            }
            if (runningASMNodes.size() >= expectedASMInstCount) {
                ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("6055", false));
                this.m_resultSet.addResult(this.m_nodeList, 1);
            } else {
                String msg = s_gMsgBundle.getMessage("6056", true, (Object[])new String[]{expectedASMInstCount + "", runningASMNodes.size() + "", VerificationUtil.strList2List(runningASMNodes)});
                ReportUtil.sureprintln(LSEP + msg + LSEP);
                locrs.addErrorDescription(new ErrorDescription(msg));
            }
        } else {
            ArrayList<String> failedASMNodesOriginalList = new ArrayList<String>();
            failedASMNodesOriginalList.addAll(failedASMNodes);
            failedASMNodesOriginalList.retainAll(Arrays.asList(this.m_nodeList));
            String nodel = VerificationUtil.strList2List(failedASMNodesOriginalList);
            locrs.addErrorDescription(failedASMNodesOriginalList, new ErrorDescription(s_msgBundle.getMessage("5110", true, (Object[])new String[]{nodel})));
            ReportUtil.println(LSEP + s_msgBundle.getMessage("5110", true, (Object[])new String[]{nodel}));
        }
        Trace.out((int)2, (String)"Exit");
    }

    private boolean checkDiskGroupsforDB() {
        boolean getdg;
        Trace.out((int)2, (String)"Entry");
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("5139", false));
        if (this.m_dgList == null || this.m_dgList.length == 0) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5138", true));
            return false;
        }
        ASMDiskGroupsUtil dgutil = new ASMDiskGroupsUtil();
        Hashtable<String, List<ASMDiskGroup>> htdg = new Hashtable<String, List<ASMDiskGroup>>();
        Hashtable<String, ASMDiskGroup> htreqddg = new Hashtable<String, ASMDiskGroup>();
        ResultSet dgResultSet = new ResultSet();
        try {
            getdg = dgutil.getDiskGroups(this.m_nodeList, dgResultSet, htdg);
        }
        catch (ASMDiskGroupsUtilException e) {
            String errMsg = s_msgBundle.getMessage("5131", true) + LSEP + e.getMessage();
            ReportUtil.sureprintln(errMsg);
            this.m_resultSet.addResultSetData(dgResultSet);
            this.m_resultSet.setStatus();
            return false;
        }
        this.m_resultSet.addResultSetData(dgResultSet);
        if (getdg) {
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(s_msgBundle.getMessage("5143", false));
            for (String dgnm : this.m_dgList) {
                Vector<String> unavailnodes = new Vector<String>();
                for (String node : this.m_nodeList) {
                    List<ASMDiskGroup> dgl = htdg.get(node);
                    if (dgl == null || dgl.size() < 1) {
                        unavailnodes.add(node);
                        continue;
                    }
                    boolean founddg = false;
                    for (ASMDiskGroup dg1 : dgl) {
                        if (!dg1.getName().equals(dgnm)) continue;
                        if (htreqddg.get(dgnm) == null) {
                            htreqddg.put(dgnm, dg1);
                        }
                        founddg = true;
                    }
                    if (founddg) continue;
                    unavailnodes.add(node);
                }
                if (unavailnodes.size() > 0) {
                    String dgUnavail = null;
                    if (unavailnodes.size() < this.m_nodeList.length) {
                        dgUnavail = s_msgBundle.getMessage("5144", true, (Object[])new String[]{dgnm, unavailnodes.toString()});
                        ReportUtil.sureprintln(dgUnavail);
                        ReportUtil.verboseReportPrintln(dgUnavail);
                        continue;
                    }
                    dgUnavail = s_msgBundle.getMessage("5145", true, (Object[])new String[]{dgnm});
                    ReportUtil.sureprintln(dgUnavail);
                    ReportUtil.verboseReportPrintln(dgUnavail);
                    continue;
                }
                ReportUtil.sureprintln(s_msgBundle.getMessage("5146", false, (Object[])new String[]{dgnm}));
            }
            ReportUtil.sureblankln();
            ReportUtil.sureblankln();
            String headerStr = s_msgBundle.getMessage("5148", false);
            ReportUtil.sureprintln(headerStr);
            ReportUtil.verboseReportPrintln(headerStr);
            if (htreqddg != null && htreqddg.size() > 0) {
                ReportUtil.writeColHeaders(s_msgBundle.getMessage("5133", false), s_msgBundle.getMessage("5134", false), s_msgBundle.getMessage("5135", false));
                Enumeration dgenum = htreqddg.keys();
                while (dgenum.hasMoreElements()) {
                    String dgnam = (String)dgenum.nextElement();
                    ASMDiskGroup adg = (ASMDiskGroup)htreqddg.get(dgnam);
                    ReportUtil.writeRecord(adg.getName(), Double.toString(adg.getSize().sizeIn(StorageUnit.MBYTE)), Double.toString(adg.getFree().sizeIn(StorageUnit.MBYTE)));
                    if (!(adg.getFree().sizeIn(StorageUnit.MBYTE) < 400.0)) continue;
                    String dgSmall = s_msgBundle.getMessage("5136", false, (Object[])new String[]{adg.getName(), new Long(400L).toString()});
                    ReportUtil.sureprintln(dgSmall);
                    ReportUtil.verboseReportPrintln(dgSmall);
                    Trace.out((String)("INSUFFICIENT SIZE OF DISKGROUP" + adg.getName() + ": MIN REQD=" + 400L + ", DISKGROUP SIZE=" + adg.getSize()));
                }
            } else {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5132", true));
            }
            ReportUtil.sureprintln(s_msgBundle.getMessage("5140", false));
            return true;
        }
        ReportUtil.sureprintln(s_msgBundle.getMessage("5131", false));
        ReportUtil.sureprintln(s_msgBundle.getMessage("5140", false));
        return false;
    }

    private void checkDiskGroupsASM() {
        Trace.out((int)2, (String)"Entry");
        ASMDiskGroupsUtil asmdg = new ASMDiskGroupsUtil();
        if (CVUHelperUtil.isASMFar()) {
            return;
        }
        Trace.out((int)5, (String)"Starting ASM DiskGroup check...");
        ReportUtil.println(LSEP + s_msgBundle.getMessage("5111", false));
        int dgLocalCount = 0;
        try {
            dgLocalCount = asmdg.getDiskGroupCount();
        }
        catch (ASMDiskGroupsUtilException e) {
            Trace.out((String)("Exception when getting disk groups list from ASM" + e.getMessage()));
            String dgError = s_gMsgBundle.getMessage("1612", true) + LSEP + e.getMessage();
            ReportUtil.sureprintln(dgError);
            this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(dgError));
            return;
        }
        if (dgLocalCount > 0) {
            Trace.out((int)5, (String)"DiskGroup Check: At least ONE Disk Group found.");
            ReportUtil.sureprintln(s_msgBundle.getMessage("5113", false));
        } else {
            Trace.out((int)5, (String)"DiskGroup Check: WARNING - No Disk Groups have been configured.");
            ReportUtil.sureprintln(s_msgBundle.getMessage("5114", true));
        }
        Trace.out((int)5, (String)"DiskGroup Check: Completed.");
    }

    private void checkFilterDriverManagedDisks(List<String> asmFDNodeList, ResultSet rs) {
        if (rs == null) {
            rs = new ResultSet();
        }
        if (asmFDNodeList == null || asmFDNodeList.isEmpty()) {
            return;
        }
        String[] asmFDNodeArray = asmFDNodeList.toArray(new String[0]);
        HashMap<String, List> kfodNodeDiskMap = new HashMap<String, List>();
        TaskASMFilterDriverChecks taskAFD = new TaskASMFilterDriverChecks(asmFDNodeArray);
        this.addChildTask(taskAFD);
        taskAFD.perform();
        rs.uploadResultSet(taskAFD.getResultSet());
        if (rs.allSuccess()) {
            List kfodDiskList;
            try {
                String kfodLocation = VerificationUtil.getKFODLocation(asmFDNodeList.get(0), this.m_isPreCheck);
                Trace.out((String)("running kfod from: " + kfodLocation));
                KFODUtil kfodUtil = new KFODUtil(kfodLocation);
                for (String node : asmFDNodeList) {
                    Trace.out((String)("calling kfod on node " + node));
                    kfodDiskList = kfodUtil.getASMDiskList(node);
                    kfodNodeDiskMap.put(node, kfodDiskList);
                }
            }
            catch (VerificationException ve) {
                Trace.out((String)("Caught VerificationException : " + ve.getMessage()));
                rs.addErrorDescription(new ErrorDescription(ve.getMessage()));
                rs.setStatus(2);
                return;
            }
            catch (CmdToolUtilException cte) {
                Trace.out((String)("Caught CmdToolUtilException : " + cte.getMessage()));
                rs.addErrorDescription(new ErrorDescription(cte.getMessage()));
                rs.setStatus(2);
                return;
            }
            Hashtable<String, Hashtable<String, String>> nodeWiseAfdLabels = StorageUtil.getAFDDiskList(asmFDNodeArray, VerificationUtil.getCRSHome(), VerificationUtil.getCRSActiveVersionObj(), rs);
            for (String node : asmFDNodeList) {
                ArrayList<String> notAFDManagedDiskList = new ArrayList<String>();
                kfodDiskList = (List)kfodNodeDiskMap.get(node);
                if (nodeWiseAfdLabels.containsKey(node)) {
                    Set<String> afdDiskList = nodeWiseAfdLabels.get(node).keySet();
                    for (String kfodDisk : kfodDiskList) {
                        if (afdDiskList.contains(kfodDisk)) continue;
                        notAFDManagedDiskList.add(kfodDisk);
                    }
                } else {
                    notAFDManagedDiskList.addAll(kfodDiskList);
                }
                if (notAFDManagedDiskList.isEmpty()) continue;
                String errMsg = s_gMsgBundle.getMessage("6081", true, (Object[])new String[]{VerificationUtil.strList2List(notAFDManagedDiskList), node});
                rs.addResult(node, 4);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                rs.addErrorDescription(node, errDesc);
                ReportUtil.printWarning(errMsg);
            }
        }
    }

    private ResultSet performAuthServicesCheck() {
        ResultSet authRs = new ResultSet();
        ArrayList<String> succNodes = new ArrayList<String>();
        ArrayList<String> failNodes = new ArrayList<String>();
        String scratchPath = VerificationUtil.getCVUSubDirPath() + "scratch";
        File tempArea = new File(scratchPath);
        if (!tempArea.exists()) {
            tempArea.mkdirs();
        }
        if (!tempArea.isDirectory()) {
            tempArea.delete();
            tempArea.mkdir();
        }
        if (!tempArea.exists() || !tempArea.isDirectory()) {
            Trace.out((String)("Couldn't create " + tempArea.getName()));
            authRs.addResult(this.m_nodeList, 2);
            String msg = s_msgBundle.getMessage("5642", true, (Object[])new String[]{scratchPath});
            ErrorDescription errDesc = new ErrorDescription(msg);
            authRs.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            return authRs;
        }
        ClusterCmd clusterCmd = new ClusterCmd();
        String sqlnetORA = ASMUtils.getSqlNetPath() + FSEP + SQLNET_FILENAME;
        String sqlnetORATmp = null;
        for (String node : this.m_nodeList) {
            boolean copyStatus = false;
            Trace.out((String)("copying file from node:" + node));
            try {
                boolean currentNodeStatus = clusterCmd.fileExists(node, sqlnetORA);
                if (!currentNodeStatus) {
                    Trace.out((String)(sqlnetORA + " does not exists on node " + node));
                    continue;
                }
                sqlnetORATmp = scratchPath + FSEP + SQLNET_FILENAME + "_" + node;
                copyStatus = clusterCmd.copyFileFromNode(node, sqlnetORA, sqlnetORATmp);
                Trace.out((String)("copy status = " + copyStatus));
                if (!copyStatus) {
                    failNodes.add(node);
                    String msg = s_gMsgBundle.getMessage("1361", false, (Object[])new String[]{sqlnetORA, node});
                    ErrorDescription errDesc = new ErrorDescription(msg);
                    authRs.addErrorDescription(node, errDesc);
                    authRs.addResult(node, 2);
                    continue;
                }
                NLParamParser npp = new NLParamParser(sqlnetORATmp);
                for (String np : npp.getNLPAllNames()) {
                    if (!np.toLowerCase().equals(AUTH_SERVICES_KEY)) continue;
                    Trace.out((String)"Entry found for AUTH_SERVICES_KEY ");
                    String npValue = npp.getNLPListElement(np).valueToString();
                    Trace.out((String)npValue);
                    String expected_auth_pattern = EXPECTED_AUTH_PATTERN;
                    if (VerificationUtil.isPlatformWindows()) {
                        expected_auth_pattern = EXPECTED_AUTH_PATTERN_NT;
                    }
                    if (Pattern.compile(expected_auth_pattern, 2).matcher(npValue).matches()) {
                        Trace.out((String)"Authentication method is configured as expected");
                        succNodes.add(node);
                        authRs.addResult(node, 1);
                        continue;
                    }
                    Trace.out((String)("node=" + node + " entry " + np + " = " + npValue));
                    failNodes.add(node);
                    String failMsg = s_gMsgBundle.getMessage("1362", true, (Object[])new String[]{sqlnetORA, node});
                    ErrorDescription errDesc = new ErrorDescription(failMsg);
                    authRs.addResult(node, 3);
                    authRs.addErrorDescription(node, errDesc);
                }
            }
            catch (ClusterException e) {
                Trace.out((String)e.getMessage());
                authRs.addResult(node, 2);
                authRs.addErrorDescription(node, new ErrorDescription(e.getMessage()));
                ReportUtil.sureprintln(e.getMessage());
                failNodes.add(node);
            }
            catch (IOException e) {
                authRs.addResult(node, 2);
                authRs.addErrorDescription(node, new ErrorDescription(e.getMessage()));
                ReportUtil.sureprintln(e.getMessage());
                failNodes.add(node);
            }
            catch (NLException e) {
                authRs.addResult(node, 2);
                authRs.addErrorDescription(node, new ErrorDescription(e.getMessage()));
                ReportUtil.sureprintln(e.getMessage());
                failNodes.add(node);
            }
        }
        return authRs;
    }

    public void setASMDGList(String[] dgList) {
        this.m_dgList = dgList;
    }

    public void setASMDGList(String dgName) {
        this.setASMDGList(new String[]{dgName});
    }

    public String[] getASMDGList() {
        return this.m_dgList;
    }

    public void setPreCheck(boolean preCheck) {
        this.m_isPreCheck = preCheck;
    }

    public boolean getPreCheck() {
        return this.m_isPreCheck;
    }

    public void setNoDiskGroupCheck(boolean noDGCheck) {
        this.m_DiskGroupCheck = noDGCheck;
    }

    public void setNetworkInfoFromOifcfg() throws CVUException {
        Set<NetworkInfo> clusterNetworks = null;
        ResultSet networksResultSet = new ResultSet();
        clusterNetworks = NetworkDataDiscovery.getClusterNetworksFromOifcfg(networksResultSet);
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            Trace.out((String)"Could not get the network details from oifcfg successfully during ASM Integrity checks");
            NetworkUtility.reportResultSet(networksResultSet, this.m_resultSet, true);
            return;
        }
        if (NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            NetworkDataDiscovery.getClusterNetworkTypes(clusterNetworks, true);
            if (NetworkDataDiscovery.hasNetworkTypeInClusterNetworks(clusterNetworks, 128)) {
                Trace.out((String)"Found NETTYPE_ASM in network information");
                Set<NetworkInfo> asmNetInfo = NetworkDataDiscovery.getClusterNetworksByType(clusterNetworks, NetworkConstants.NetworkType.ASM);
                this.setNetworksToConsider(asmNetInfo);
            }
        }
    }

    public void setVerificationType(VerificationType vtype) {
        this.m_vtype = vtype;
    }

    public void setOCRonASM(boolean isOCRonASM) {
        this.m_OCRonASM = isOCRonASM;
    }

    public boolean isASMNetworkExist() {
        return NetworkUtility.isNetworksSetGood(this.m_asmNetworksToConsider);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("6500", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("6700", false);
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }
}

