/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskASMFilterDriverChecks
extends Task {
    public TaskASMFilterDriverChecks(VerificationTaskContext ctx) {
        super(ctx);
    }

    public TaskASMFilterDriverChecks(String[] nodeList) {
        super(nodeList);
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        VerificationType vType = this.m_globalContext.getVerificationType();
        switch (vType) {
            case PREREQ_CRS_INST: {
                return VerificationUtil.isPlatformLinux() && StorageUtil.isAFDSupported();
            }
        }
        return StorageUtil.isAFDSupported();
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }

    @Override
    public boolean performTask() {
        if (this.m_globalContext.isPreCRS()) {
            ResultSet asmLibInstallRsltSet = new ResultSet();
            List<String> asmLibNodes = VerificationUtil.getASMLibInstalledNodes(this.m_nodeList, asmLibInstallRsltSet);
            if (!asmLibNodes.isEmpty()) {
                VerificationUtil.traceAndLog("ASMLib was found installed on the nodes" + VerificationUtil.strList2List(asmLibNodes));
                String errMsg = s_gMsgBundle.getMessage("12808", true, (Object[])new String[]{VerificationUtil.strList2List(asmLibNodes)});
                this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                this.m_resultSet.addResult(asmLibNodes, 3);
                return false;
            }
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return true;
        }
        Vector<String> afdInstalledNodes = new Vector<String>();
        Vector<String> afdLoadededNodes = new Vector<String>();
        ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("6071", false));
        Result result = new Result(m_localNode);
        String crsHome = VerificationUtil.getCRSHome(m_localNode, result);
        if (VerificationUtil.isStringGood(crsHome)) {
            Version activeCRSVer = VerificationUtil.getCRSActiveVersionObj();
            if (activeCRSVer != null) {
                ResultSet afdResultSet = this.isInstallConsistent(crsHome, activeCRSVer, afdInstalledNodes);
                this.m_resultSet.addResultSetData(afdResultSet);
                if (this.m_resultSet.allSuccess() && !afdInstalledNodes.isEmpty()) {
                    afdResultSet = this.isLoadedConsistently(afdInstalledNodes, crsHome, activeCRSVer, afdLoadededNodes);
                    this.m_resultSet.addResultSetData(afdResultSet);
                    if (this.m_resultSet.allSuccess() && !afdLoadededNodes.isEmpty()) {
                        afdResultSet = this.checkAFDDiskListConsistency(afdLoadededNodes, crsHome, activeCRSVer);
                        this.m_resultSet.addResultSetData(afdResultSet);
                    }
                }
            } else {
                String errMsg = s_msgBundle.getMessage("5300", true);
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(errorDesc);
                this.m_resultSet.setStatus(2);
                ReportUtil.printError(errMsg);
            }
        } else {
            this.m_resultSet.addResult(m_localNode, result);
            String errMsg = s_msgBundle.getMessage("5301", true);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errorDesc);
            this.m_resultSet.setStatus(2);
            ReportUtil.printError(errMsg);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_gMsgBundle.getMessage("6072", false));
            return true;
        }
        ReportUtil.printResult(s_gMsgBundle.getMessage("6073", false));
        return false;
    }

    private ResultSet isInstallConsistent(String crsHome, Version activeCRSVer, Vector<String> afdInstalledNodes) {
        ResultSet afdInstallRsltSet = new ResultSet();
        Vector<String> afdNotInstallNodes = new Vector<String>();
        Vector<String> operationFailedNode = new Vector<String>();
        StorageUtil.isASMFilterDriverInstallConsistent(this.m_nodeList, crsHome, activeCRSVer, afdInstallRsltSet, afdNotInstallNodes, operationFailedNode);
        for (String node : this.m_nodeList) {
            if (afdNotInstallNodes.contains(node) || operationFailedNode.contains(node)) continue;
            afdInstalledNodes.add(node);
        }
        if (afdInstallRsltSet.anyFailure()) {
            List<VerificationError> errors = afdInstallRsltSet.getErrors();
            for (VerificationError err : errors) {
                ReportUtil.printError(err.getErrorMessage());
            }
        } else if (afdInstalledNodes.isEmpty()) {
            ReportUtil.printResult(s_gMsgBundle.getMessage("6082", false));
        } else {
            ReportUtil.printResult(s_gMsgBundle.getMessage("6076", false));
        }
        return afdInstallRsltSet;
    }

    private ResultSet isLoadedConsistently(Vector<String> nodeList, String crsHome, Version activeCRSVer, Vector<String> afdLoadededNodes) {
        ResultSet afdLoadedRsltSet = new ResultSet();
        Vector<String> afdLibNotConfiguredNodes = new Vector<String>();
        Vector<String> operationFailedNode = new Vector<String>();
        StorageUtil.isASMFilterDriverLoadedConsistently(nodeList.toArray(new String[0]), crsHome, activeCRSVer, afdLoadedRsltSet, afdLibNotConfiguredNodes, operationFailedNode);
        for (String node : nodeList) {
            if (afdLibNotConfiguredNodes.contains(node) || operationFailedNode.contains(node)) continue;
            afdLoadededNodes.add(node);
        }
        if (afdLoadedRsltSet.anyFailure()) {
            List<VerificationError> errors = afdLoadedRsltSet.getErrors();
            for (VerificationError err : errors) {
                ReportUtil.printError(err.getErrorMessage());
            }
        } else {
            ReportUtil.printResult(s_gMsgBundle.getMessage("6077", false));
        }
        return afdLoadedRsltSet;
    }

    private ResultSet checkAFDDiskListConsistency(Vector<String> nodeList, String crsHome, Version activeCRSVer) {
        ResultSet afdListDiskRsltSet = new ResultSet();
        Hashtable<String, Hashtable<String, String>> nodeWiseAFDLabelPathTable = StorageUtil.getAFDDiskList(nodeList.toArray(new String[0]), crsHome, activeCRSVer, afdListDiskRsltSet);
        Hashtable labelWiseNodeListTable = new Hashtable();
        for (String node : nodeList) {
            if (!nodeWiseAFDLabelPathTable.containsKey(node)) continue;
            Hashtable<String, String> labelPathTableOnNode = nodeWiseAFDLabelPathTable.get(node);
            for (String label : labelPathTableOnNode.keySet()) {
                if (labelWiseNodeListTable.containsKey(label)) {
                    ((Set)labelWiseNodeListTable.get(label)).add(node);
                    continue;
                }
                HashSet<String> nodeListForLabel = new HashSet<String>();
                nodeListForLabel.add(node);
                labelWiseNodeListTable.put(label, nodeListForLabel);
            }
        }
        Hashtable nodeWiseMissingLabelList = new Hashtable();
        for (String label : labelWiseNodeListTable.keySet()) {
            for (String node : nodeList) {
                if (((Set)labelWiseNodeListTable.get(label)).containsAll(nodeList)) {
                    Trace.out((String)("Disk label (" + label + ") is visible on all the nodes (" + nodeList + ")"));
                    continue;
                }
                if (((Set)labelWiseNodeListTable.get(label)).contains(node)) continue;
                Trace.out((String)("Disk label (" + label + ") is not listed/visible on node (" + node + ") by afdtool"));
                if (nodeWiseMissingLabelList.containsKey(node)) {
                    ((Set)nodeWiseMissingLabelList.get(node)).add(label);
                    continue;
                }
                HashSet<String> labelSet = new HashSet<String>();
                labelSet.add(label);
                nodeWiseMissingLabelList.put(node, labelSet);
            }
        }
        for (String node : nodeWiseMissingLabelList.keySet()) {
            if (((Set)nodeWiseMissingLabelList.get(node)).isEmpty()) continue;
            String errMsg = s_gMsgBundle.getMessage("6083", true, (Object[])new String[]{VerificationUtil.strCollection2String((Collection)nodeWiseMissingLabelList.get(node)), node});
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            afdListDiskRsltSet.addErrorDescription(node, errorDesc);
            afdListDiskRsltSet.addResult(node, 3);
            ReportUtil.printError(errMsg);
        }
        return afdListDiskRsltSet;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("6079", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("6080", false);
    }
}

